/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MemberImpl;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class BodyEnhanced
extends AbstractTextBlock
implements TextBlock {
    private TextBlock area2;
    private final FontConfiguration titleConfig;
    private final List<String> rawBody;
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final HorizontalAlignment align;
    private final boolean manageHorizontalLine;
    private final boolean manageModifier;
    private final List<Url> urls = new ArrayList<Url>();
    private final boolean manageUrl;

    public BodyEnhanced(List<String> rawBody, FontParam fontParam, ISkinParam skinParam, boolean manageModifier) {
        this.rawBody = new ArrayList<String>(rawBody);
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.manageUrl = true;
        this.titleConfig = new FontConfiguration(skinParam.getFont(fontParam, null, false), new Rose().getFontColor(skinParam, fontParam), skinParam.getHyperlinkColor(), skinParam.useUnderlineForHyperlink());
        this.lineFirst = true;
        this.align = HorizontalAlignment.LEFT;
        this.manageHorizontalLine = true;
        this.manageModifier = manageModifier;
    }

    public BodyEnhanced(Display display, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype, boolean manageHorizontalLine, boolean manageModifier, boolean manageUrl) {
        this.manageUrl = manageUrl;
        this.rawBody = new ArrayList<String>();
        for (CharSequence s : display) {
            this.rawBody.add(s.toString());
        }
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.titleConfig = new FontConfiguration(skinParam, fontParam, stereotype);
        this.lineFirst = false;
        this.align = align;
        this.manageHorizontalLine = manageHorizontalLine;
        this.manageModifier = manageModifier;
    }

    private TextBlock decorate(StringBounder stringBounder, TextBlock b, char separator, TextBlock title) {
        if (separator == '\u0000') {
            return b;
        }
        if (title == null) {
            return new TextBlockLineBefore(TextBlockUtils.withMargin(b, 6.0, 4.0), separator);
        }
        Dimension2D dimTitle = title.calculateDimension(stringBounder);
        TextBlockLineBefore raw = new TextBlockLineBefore(TextBlockUtils.withMargin(b, 6.0, 6.0, dimTitle.getHeight() / 2.0, 4.0), separator, title);
        return TextBlockUtils.withMargin(raw, 0.0, 0.0, dimTitle.getHeight() / 2.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getArea(stringBounder).calculateDimension(stringBounder);
    }

    private TextBlock getArea(StringBounder stringBounder) {
        if (this.area2 != null) {
            return this.area2;
        }
        this.urls.clear();
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock title = null;
        ArrayList<Member> members = new ArrayList<Member>();
        ListIterator<String> it = this.rawBody.listIterator();
        while (it.hasNext()) {
            String s = it.next();
            if (this.manageHorizontalLine && BodyEnhanced.isBlockSeparator(s)) {
                blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align), separator, title));
                separator = s.charAt(0);
                title = this.getTitle(s, this.skinParam);
                members = new ArrayList();
                continue;
            }
            if (CreoleParser.isTreeStart(s)) {
                if (members.size() > 0) {
                    blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align), separator, title));
                }
                members = new ArrayList();
                List<String> allTree = BodyEnhanced.buildAllTree(s, it);
                TextBlock bloc = Display.create(allTree).create(this.fontParam.getFontConfiguration(this.skinParam), this.align, this.skinParam, CreoleMode.FULL);
                blocks.add(bloc);
                continue;
            }
            MemberImpl m = new MemberImpl(s, MemberImpl.isMethod(s), this.manageModifier, this.manageUrl);
            members.add(m);
            if (m.getUrl() == null) continue;
            this.urls.add(m.getUrl());
        }
        blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(members, this.fontParam, this.skinParam, this.align), separator, title));
        this.area2 = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        return this.area2;
    }

    private static List<String> buildAllTree(String init, ListIterator<String> it) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(init);
        while (it.hasNext()) {
            String s = it.next();
            if (CreoleParser.isTreeStart(StringUtils.trinNoTrace(s))) {
                result.add(s);
                continue;
            }
            it.previous();
            return result;
        }
        return result;
    }

    public static boolean isBlockSeparator(String s) {
        if (s.startsWith("--") && s.endsWith("--")) {
            return true;
        }
        if (s.startsWith("==") && s.endsWith("==")) {
            return true;
        }
        if (s.startsWith("..") && s.endsWith("..") && !s.equals("...")) {
            return true;
        }
        return s.startsWith("__") && s.endsWith("__");
    }

    private TextBlock getTitle(String s, ISkinSimple spriteContainer) {
        if (s.length() <= 4) {
            return null;
        }
        s = StringUtils.trin(s.substring(2, s.length() - 2));
        return Display.getWithNewlines(s).create(this.titleConfig, HorizontalAlignment.LEFT, spriteContainer);
    }

    @Override
    public void drawU(UGraphic ug) {
        this.getArea(ug.getStringBounder()).drawU(ug);
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }
}

