/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.statediagram.StateDiagram;

public class CommandCreatePackageState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreatePackageState() {
        super(CommandCreatePackageState.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^state[%s]+"), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+)[%s]+"), new RegexLeaf("DISPLAY1", "as[%s]+[%g]([^%g]+)[%g]")), new RegexConcat(new RegexLeaf("DISPLAY2", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?"), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)"))), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("(?:[%s]*\\{|[%s]+begin)$"));
    }

    private String getNotNull(RegexResult arg, String v1, String v2) {
        if (arg.get(v1, 0) == null) {
            return arg.get(v2, 0);
        }
        return arg.get(v1, 0);
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, RegexResult arg) {
        String urlString;
        IGroup currentPackage = diagram.getCurrentGroup();
        Code code = Code.of(this.getNotNull(arg, "CODE1", "CODE2"));
        String display = this.getNotNull(arg, "DISPLAY1", "DISPLAY2");
        if (display == null) {
            display = code.getFullName();
        }
        IGroup p = diagram.getOrCreateGroup(code, Display.getWithNewlines(display), GroupType.STATE, currentPackage);
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(new Stereotype(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        p.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        p.setSpecificLineColor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LINECOLOR", 1)));
        CommandCreateClassMultilines.applyStroke(p, arg.get("LINECOLOR", 0));
        return CommandExecutionResult.ok();
    }
}

