/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.Version;

public class GraphvizCrash
extends AbstractTextBlock
implements IEntityImage {
    private static final UFont font = new UFont("SansSerif", 0, 12);
    private final GraphicStrings graphicStrings;
    private final BufferedImage flashCode;

    public GraphvizCrash(String text) {
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        this.flashCode = utils.exportFlashcode(text);
        this.graphicStrings = new GraphicStrings(this.init(), font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    private List<String> init() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured!");
        String quote = QuoteUtils.getSomeQuote();
        strings.add("<i>" + quote);
        strings.add(" ");
        strings.add("For some reason, dot/Graphviz has crashed.");
        strings.add("This has been generated with PlantUML (" + Version.versionString() + ").");
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        try {
            String dotVersion = GraphvizUtils.dotVersion();
            strings.add("Default dot version: " + dotVersion);
        }
        catch (Throwable e) {
            strings.add("Cannot determine dot version: " + e.toString());
        }
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        strings.add("You can try to turn arround this issue by simplifing your diagram.");
        if (this.flashCode != null) {
            GraphvizCrash.addDecodeHint(strings);
        }
        return strings;
    }

    public static void addDecodeHint(List<String> strings) {
        strings.add(" ");
        strings.add(" Diagram source: (Use http://zxing.org/w/decode.jspx to decode the flashcode)");
    }

    public static void addProperties(List<String> strings) {
        GraphvizCrash.addTextProperty(strings, "os.version");
        GraphvizCrash.addTextProperty(strings, "os.name");
        GraphvizCrash.addTextProperty(strings, "java.vm.vendor");
        GraphvizCrash.addTextProperty(strings, "java.vm.version");
        GraphvizCrash.addTextProperty(strings, "java.version");
        GraphvizCrash.addTextProperty(strings, "user.language");
    }

    private static void addTextProperty(List<String> strings, String prop) {
        strings.add(prop + ": " + System.getProperty(prop));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public HtmlColor getBackcolor() {
        return HtmlColorUtils.WHITE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D result = this.graphicStrings.calculateDimension(stringBounder);
        if (this.flashCode != null) {
            result = Dimension2DDouble.mergeTB(result, new Dimension2DDouble(this.flashCode.getWidth(), this.flashCode.getHeight()));
        }
        return result;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.graphicStrings.drawU(ug);
        if (this.flashCode != null) {
            double h = this.graphicStrings.calculateDimension(ug.getStringBounder()).getHeight();
            ug = ug.apply(new UTranslate(0.0, h));
            ug.draw(new UImage(this.flashCode));
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

