/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHidden;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPixel;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LimitFinder
implements UGraphic {
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final MinMaxMutable minmax;
    private UClip clip;

    @Override
    public boolean isSpecialTxt() {
        return false;
    }

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new LimitFinder(this.stringBounder, this.minmax, this.translate.compose((UTranslate)change), this.clip);
        }
        if (change instanceof UStroke) {
            return new LimitFinder(this);
        }
        if (change instanceof UChangeBackColor) {
            return new LimitFinder(this);
        }
        if (change instanceof UChangeColor) {
            return new LimitFinder(this);
        }
        if (change instanceof UHidden) {
            return new LimitFinder(this);
        }
        if (change instanceof UAntiAliasing) {
            return new LimitFinder(this);
        }
        if (change instanceof UClip) {
            LimitFinder copy = new LimitFinder(this);
            copy.clip = (UClip)change;
            copy.clip = copy.clip.translate(this.translate);
            return copy;
        }
        throw new UnsupportedOperationException(change.getClass().toString());
    }

    public LimitFinder(StringBounder stringBounder, boolean initToZero) {
        this(stringBounder, MinMaxMutable.getEmpty(initToZero), new UTranslate(), null);
    }

    private LimitFinder(StringBounder stringBounder, MinMaxMutable minmax, UTranslate translate, UClip clip) {
        this.stringBounder = stringBounder;
        this.minmax = minmax;
        this.translate = translate;
        this.clip = clip;
    }

    private LimitFinder(LimitFinder other) {
        this(other.stringBounder, other.minmax, other.translate, other.clip);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public UParam getParam() {
        return new UParamNull();
    }

    private void addPoint(double x, double y) {
        if (this.clip == null || this.clip.isInside(x, y)) {
            this.minmax.addPoint(x, y);
        }
    }

    @Override
    public void draw(UShape shape) {
        double x = this.translate.getDx();
        double y = this.translate.getDy();
        if (shape instanceof UText) {
            this.drawText(x, y, (UText)shape);
        } else if (shape instanceof ULine) {
            this.drawULine(x, y, (ULine)shape);
        } else if (shape instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)shape);
        } else if (shape instanceof UPolygon) {
            this.drawUPolygon(x, y, (UPolygon)shape);
        } else if (shape instanceof UPath) {
            this.drawUPath(x, y, (UPath)shape);
        } else if (shape instanceof URectangle) {
            this.drawRectangle(x, y, (URectangle)shape);
        } else if (shape instanceof DotPath) {
            this.drawDotPath(x, y, (DotPath)shape);
        } else if (shape instanceof UImage) {
            this.drawImage(x, y, (UImage)shape);
        } else if (shape instanceof UEmpty) {
            this.drawEmpty(x, y, (UEmpty)shape);
        } else if (shape instanceof TextBlock) {
            TextBlock tb = (TextBlock)shape;
            tb.drawU(this);
        } else if (!(shape instanceof UCenteredCharacter)) {
            if (shape instanceof UPixel) {
                this.addPoint(x, y);
            } else {
                throw new UnsupportedOperationException(shape.getClass().getName());
            }
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth(), y + shape.getHeight());
    }

    private void drawUPath(double x, double y, UPath shape) {
        this.addPoint(x + shape.getMinX(), y + shape.getMinY());
        this.addPoint(x + shape.getMaxX(), y + shape.getMaxY());
    }

    private void drawUPolygon(double x, double y, UPolygon shape) {
        if (shape.getPoints().size() == 0) {
            return;
        }
        this.addPoint(x + shape.getMinX(), y + shape.getMinY());
        this.addPoint(x + shape.getMaxX(), y + shape.getMaxY());
    }

    private void drawULine(double x, double y, ULine shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getDX(), y + shape.getDY());
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth(), y + shape.getHeight());
    }

    private void drawDotPath(double x, double y, DotPath shape) {
        MinMax shapeMinMax = shape.getMinMax();
        this.addPoint(x + shapeMinMax.getMinX(), y + shapeMinMax.getMinY());
        this.addPoint(x + shapeMinMax.getMaxX(), y + shapeMinMax.getMaxY());
    }

    private void drawImage(double x, double y, UImage shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth(), y + shape.getHeight());
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth(), y + shape.getHeight());
    }

    private void drawText(double x, double y, UText text) {
        Dimension2D dim = this.stringBounder.calculateDimension(text.getFontConfiguration().getFont(), text.getText());
        this.addPoint(x, y -= dim.getHeight() - 1.5);
        this.addPoint(x, y + dim.getHeight());
        this.addPoint(x + dim.getWidth(), y);
        this.addPoint(x + dim.getWidth(), y + dim.getHeight());
    }

    @Override
    public ColorMapper getColorMapper() {
        return new ColorMapperIdentity();
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeAction() {
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public MinMax getMinMax() {
        if (this.minmax.isInfinity()) {
            return MinMax.getEmpty(true);
        }
        return MinMax.fromMutable(this.minmax);
    }

    @Override
    public void flushUg() {
    }
}

