# Source disambiguation test files

This directory holds example `Cargo.lock` files generated by `cargo`. The lock files are intended to exercise `cargo-lock` code paths related to the disambiguation of dependency specifications when the lock file contains multiple versions of the same crate and/or multiple sources for the same crate.

The following examples are provided, specifically:
* **single_version_different_registries** - The lock file has one version of a crate, from two different registries. The registries are expected to be encoded by `cargo-lock`, since they are needed for disambiguation.

* **single_version_different_source_types** - The lock file has one version of a crate, from two different sources: one from git, one from a registry. The sources are expected to be encoded by `cargo-lock`, since they are needed for disambiguation.

* **two_versions_different_registries** - The lock file has two versions of a crate, each from a different registry. The registries are **not** expected to be encoded by `cargo-lock`, since they are not needed for disambiguation.

* **two_versions_different_source_types** - The lock file has two versions of a crate, from two different sources: one from git, one from a registry. The sources are **not** expected to be encoded by `cargo-lock`, since they are not needed for disambiguation.

* **two_versions_same_registry** - The lock file has two versions of a crate, both from the same registry. The registry is **not** expected to be encoded by `cargo-lock`, since it is not needed for disambiguation.
