/* Public domain. */

#ifndef CDB_MAKE_H
#define CDB_MAKE_H

#include "outbuf.h"
#include "num.h"
#include <inttypes.h>

#ifdef CDB64
#define CDB_MAKE_NUMBYTES 8
#define cdb_uint uint64_t
#else
#define CDB_MAKE_NUMBYTES 4
#define cdb_uint uint32_t
#endif

#ifdef CDB64
#define cdb_hp cdb64_hp
#define cdb_hplist cdb64_hplist
#define cdb_make cdb64_make
#define cdb_make_start cdb64_make_start
#define cdb_make_addbegin cdb64_make_addbegin
#define cdb_make_addend cdb64_make_addend
#define cdb_make_add cdb64_make_add
#define cdb_make_finish cdb64_make_finish
#endif

#define CDB_HPLIST 1000

struct cdb_hp { cdb_uint h; cdb_uint p; } ;

struct cdb_hplist {
  struct cdb_hp hp[CDB_HPLIST];
  struct cdb_hplist *next;
  num cdb_num;
} ;

struct cdb_make {
  char bspace[8192];
  char final[256*2*CDB_MAKE_NUMBYTES];
  cdb_uint count[256];
  cdb_uint start[256];
  struct cdb_hplist *head;
  struct cdb_hp *split; /* includes space for hash */
  struct cdb_hp *hash;
  num numentries;
  outbuf b;
  num pos;
  num fd;
} ;

extern num cdb_make_start(struct cdb_make *,num);
extern num cdb_make_addbegin(struct cdb_make *,num,num);
extern num cdb_make_addend(struct cdb_make *,num,num,num);
extern num cdb_make_add(struct cdb_make *,const char *,num,const char *,num);
extern num cdb_make_finish(struct cdb_make *);

#endif
