#include <unistd.h>
#include "inbuf.h"
#include "outbuf.h"
#include "strerr.h"
#include "cdb.h"

#ifdef CDB64
#define FATAL "cdb64dump: fatal: "
#else
#define FATAL "cdbdump: fatal: "
#endif

static void die_write(void)
{
  strerr_die2sys(111,FATAL,"unable to write output: ");
}
static void put(char *buf,num len)
{
  if (outbuf_put(outbuf_1,buf,len) == -1) die_write();
}
static void putflush(void)
{
  if (outbuf_flush(outbuf_1) == -1) die_write();
}

static num pos = 0;

static void get(char *buf,num len)
{
  num r;
  while (len > 0) {
    r = inbuf_get(inbuf_0,buf,len);
    if (r == -1)
      strerr_die2sys(111,FATAL,"unable to read input: ");
    if (r == 0)
      strerr_die2x(111,FATAL,"unable to read input: truncated file");
    pos += r;
    buf += r;
    len -= r;
  }
}

static char buf[512];

static void copy(num len)
{
  num x;

  while (len > 0) {
    x = sizeof buf;
    if (len < x) x = len;
    get(buf,x);
    put(buf,x);
    len -= x;
  }
}

static num getnum(void)
{
  num result;
  get(buf,CDB_NUMBYTES);
  result = cdb_unpacknum(buf);
  if (result < 0 || result > CDB_LIMIT)
    strerr_die2x(111,FATAL,"unable to read input: malformatted file");
  return result;
}

static char strnum[NUM_TOSTRING_NONNEG];

int main(int argc,char **argv)
{
  num eod;
  num klen;
  num dlen;

  eod = getnum();
  while (pos < 256*2*CDB_NUMBYTES) dlen = getnum();

  while (pos < eod) {
    klen = getnum();
    dlen = getnum();
    put("+",1); put(strnum,num_tostring_nonneg(strnum,klen));
    put(",",1); put(strnum,num_tostring_nonneg(strnum,dlen));
    put(":",1); copy(klen);
    put("->",2); copy(dlen);
    put("\n",1);
  }

  put("\n",1);
  putflush();
  _exit(0);
  return 0;
}
