### NAME

cdbmake - create a constant database

### SYNOPSIS

`cdbmake` _f_ _ftmp_

### DESCRIPTION

`cdbmake` reads a series of encoded records from its standard input
and writes a constant database to a file named _f_,
replacing any previous contents of _f_.

`cdbmake` ensures that _f_ is updated atomically,
so programs reading _f_ never have to wait for `cdbmake` to finish.
It does this by first writing the database to _ftmp_
and then moving _ftmp_ on top of _f_.
If _ftmp_ already exists, it is destroyed.
The directories containing _ftmp_ and _f_ must be writable to `cdbmake`;
they must also be on the same filesystem.

`cdbmake` always makes sure that _ftmp_ is safely written to disk
before it replaces _f_.
If the input is in a bad format
or if `cdbmake` has any trouble writing _ftmp_ to disk,
`cdbmake` complains and leaves f alone.

There is also a `cdb64make` that uses cdb64 format instead of cdb format.

### RECORD FORMAT

Records are indexed by keys.
A key is a string.
The file _f_ is structured
so that another program,
starting from a key,
can quickly find the relevant record.
`cdbmake` allows several records with the same key, although

* most readers take only the first record, and

* `cdbmake` slows down somewhat if there are many records with the same key.

`cdbmake` preserves the order of records.

For the input provided to `cdbmake`,
each record is encoded
as +_klen_,_dlen_:_key_->_data_
followed by a newline.
Here _klen_ is the number of bytes in _key_
and _dlen_ is the number of bytes in _data_.
The end of all records is indicated by an extra newline.
For example, here are two records:

    +3,5:one->Hello
    +3,7:two->Goodbye

_key_ and _data_ may contain any characters,
including colons, dashes, newlines, and nulls.

Keys and data do not have to fit into memory,
but `cdbmake` needs roughly 16 bytes of memory per record.
A database cannot exceed 4 gigabytes (or 1 exabyte for `cdb64make`).

_f_ is portable across machines.

### SEE ALSO

**cdbdump**(1),
**cdbget**(1),
**cdbmake-12**(1),
**cdbmake-sv**(1),
**cdbstats**(1)
