#include <errno.h>
#include "inbuf.h"
#include "byte.h"

static num oneread(num (*op)(num,char *,num),num fd,char *buf,num len)
{
  num r;

  for (;;) {
    r = op(fd,buf,len);
    if (r == -1) if (errno == EINTR) continue;
    return r;
  }
}

static num getthis(inbuf *s,char *buf,num len)
{
  if (len > s->p) len = s->p;
  s->p -= len;
  byte_copy(buf,len,s->x + s->n);
  s->n += len;
  return len;
}

num inbuf_feed(inbuf *s)
{
  num r;

  if (s->p) return s->p;
  r = oneread(s->op,s->fd,s->x,s->n);
  if (r <= 0) return r;
  s->p = r;
  s->n -= r;
  if (s->n > 0) byte_copyr(s->x + s->n,r,s->x);
  return r;
}

num inbuf_get(inbuf *s,char *buf,num len)
{
  num r;
 
  if (s->p > 0) return getthis(s,buf,len);
  if (s->n <= len) return oneread(s->op,s->fd,buf,len);
  r = inbuf_feed(s); if (r <= 0) return r;
  return getthis(s,buf,len);
}

char *inbuf_peek(inbuf *s)
{
  return s->x + s->n;
}

void inbuf_seek(inbuf *s,num len)
{
  s->n += len;
  s->p -= len;
}
