#include <unistd.h>
#include "outbuf.h"
#include "strerr.h"

void strerr_warn(const char *x1,const char *x2,const char *x3,const char *x4,const char *x5,const char *x6,const struct strerr *se)
{
  strerr_sysinit();
 
  if (x1) outbuf_puts(outbuf_2,x1);
  if (x2) outbuf_puts(outbuf_2,x2);
  if (x3) outbuf_puts(outbuf_2,x3);
  if (x4) outbuf_puts(outbuf_2,x4);
  if (x5) outbuf_puts(outbuf_2,x5);
  if (x6) outbuf_puts(outbuf_2,x6);
 
  while(se) {
    if (se->x) outbuf_puts(outbuf_2,se->x);
    if (se->y) outbuf_puts(outbuf_2,se->y);
    if (se->z) outbuf_puts(outbuf_2,se->z);
    se = se->who;
  }
 
  outbuf_puts(outbuf_2,"\n");
  outbuf_flush(outbuf_2);
}

void strerr_die(num e,const char *x1,const char *x2,const char *x3,const char *x4,const char *x5,const char *x6,const struct strerr *se)
{
  strerr_warn(x1,x2,x3,x4,x5,x6,se);
  _exit(e);
}
