use crate::render::option::option_display;

pub mod comment;
pub mod create;
pub mod edit;
pub mod list;
pub mod view;

use clap::Subcommand;

use super::GeneralArgs;

/// Issue subcommands
#[derive(Subcommand, Debug)]
pub enum IssueArgs {
    List(list::ListIssueArgs),
    Create(create::CreateIssueArgs),
    Comment(comment::CommentIssueArgs),
    View(view::ViewIssueArgs),
    Edit(edit::EditIssueArgs),
}

impl IssueArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            IssueArgs::List(args) => args.run(general_args).await,
            IssueArgs::Create(args) => args.run(general_args).await,
            IssueArgs::Comment(args) => args.run(general_args).await,
            IssueArgs::View(args) => args.run(general_args).await,
            IssueArgs::Edit(args) => args.run(general_args).await,
        }
    }
}

fn display_issue(issue: &forgejo_api::structs::Issue) -> String {
    let nr = option_display(&issue.number);
    let title = option_display(&issue.title);
    format!("#{nr}:{title}")
}
