use forgejo_api::structs::IssueListLabelsQuery;
use miette::IntoDiagnostic;

use crate::actions::label::display_label;

use crate::actions::GlobalArgs;
use crate::render::spinner::spin_until_ready;
use crate::render::ui::multi_fuzzy_select_with_key;

use crate::actions::text_manipulation::select_prompt_for;
use crate::types::context::BergContext;
use crate::types::git::OwnerRepo;

use clap::Parser;

/// Delete a label
#[derive(Parser, Debug)]
pub struct DeleteLabelArgs {}

impl DeleteLabelArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        let _ = global_args;
        let ctx = BergContext::new(self, global_args).await?;

        let OwnerRepo { repo, owner } = ctx.owner_repo()?;
        let (_, labels_list) = spin_until_ready(
            ctx.client
                .issue_list_labels(
                    owner.as_str(),
                    repo.as_str(),
                    IssueListLabelsQuery::default(),
                )
                .send(),
        )
        .await
        .into_diagnostic()?;

        // TODO: cleanup AI generated code ... no non-interactive version

        let selected_labels = multi_fuzzy_select_with_key(
            &labels_list,
            select_prompt_for("label"),
            |_| false,
            display_label,
        )?;

        for id in selected_labels.into_iter().filter_map(|label| label.id) {
            ctx.client
                .issue_delete_label(owner.as_str(), repo.as_str(), id)
                .await
                .into_diagnostic()?;
        }

        Ok(())
    }
}
