/*
* delaylevels.cc
* DIN Is Noise is copyright (c) 2006-2025 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#include "ui_list.h"
#include "delaylevels.h"
#include "delay.h"
#include "din.h"
#include "console.h"

#define DECLARE_WIDGET_ARRAY_wa \
widget* wa [] = {\
    &title,\
    &fold,\
    &fbk.both, &vol.both,\
    &L.fbk, &R.fbk, \
    &L.vol, &R.vol,\
    &len,\
    &sl,\
    0\
  };\

#define NUM_WIDGETS 10 
#define NUM_WIDGETS_1 (NUM_WIDGETS - 1)

void delaylevels::setup () {
  
  DECLARE_WIDGET_ARRAY_wa
  makefam (wa);

  title.set_text ("Levels");

  static const float DELTA = 0.001f;
  fbk.both.set ("feedback-both", DELTA, &fbkbothl, 0);
  L.fbk.set ("feedback-l", DELTA, &fbkll, 0);
  R.fbk.set ("feedback-r", DELTA, &fbkrl, 0);

  vol.both.set ("volume-both", DELTA, &volbothl, 0);
  L.vol.set ("volume-l", DELTA, &volll, 0);
  R.vol.set ("volume-r", DELTA, &volrl, 0);

  fold.set_dir (arrow_button::right);
  fold.set_listener (&foldl);
  folded = 0;

  title.set_moveable (1);

  len.set_text ("Length");
  sl.set_sizer_visible (1);
  sl.set_size (500);
  sl.set_limits (0.0f, 1.0f);
  sl.set_val (1.0f);
  sl.set_listener (this);

  widget_load ("d_delaylevels", wa, NUM_WIDGETS);

#ifdef __WIDGET_MOVE__
  for (int i = 0; i < NUM_WIDGETS; ++i) wa[i]->set_moveable (1);
#endif


}

void delaylevels::draw () {
  if (folded) {
    fold.draw ();
    title.draw ();
  } else {
		DECLARE_WIDGET_ARRAY_wa
		for (int i = 0; i < NUM_WIDGETS; ++i) {
			widget* wi = wa[i];
			wi->draw ();
		}
  }
}

int delaylevels::handle_input () {
  if (folded) {
		if (fold.handle_input ()) return 1;
		else return title.handle_input ();
  } else {
		DECLARE_WIDGET_ARRAY_wa
		for (int i = 0; i < NUM_WIDGETS; ++i) {
			widget* wi = wa[i];
			if (wi->handle_input ()) return 1;
		}
  }
  return 0;
}

delaylevels::~delaylevels () {
	DECLARE_WIDGET_ARRAY_wa
	widget_save ("d_delaylevels", wa, NUM_WIDGETS);
}


CLICKED_BUTTON(delaylevels, fold_lis) {
  delaylevels& dl = uis.delaylevs;
  int& folded = dl.folded;
  folded = !folded;
  if (folded) {
    dl.fold.set_dir (arrow_button::right);
  } else {
    dl.fold.set_dir (arrow_button::down);
  }
}

void delaylevels::changed (slider<float>& s) {
  float bl = L.beats * s();
  float br = R.beats * s();
  left_delay.set (bl);
  right_delay.set (br);
}

PARAM(fbk)
PARAM(vol)
