/* ========================================================================== */
/* Operating system API */
/*
 * Never include this file directly. Include 'posix.h' instead.
 */

#ifndef BSD_FOR_POSIX
#  error Do not include 'bsd.h' directly, include 'posix.h' instead!
#endif  /* BSD_FOR_POSIX */

#include <unistd.h>
#include <errno.h>
#include <sys/types.h>


/* ========================================================================== */
/* General stuff */

#include <sys/socket.h>

#define API_POSIX_MSG_PEEK  MSG_PEEK

#define api_posix_ssize_t  ssize_t


/* ========================================================================== */
/* ARPA internet stuff */

#include <netinet/in.h>
#include <arpa/inet.h>

#define API_POSIX_AF_UNSPEC  0U
#define API_POSIX_AF_INET    1U

typedef unsigned int  api_posix_sa_family_t;

#if CFG_HDR_INTTYPES_H
#   include <inttypes.h>
typedef uint16_t  api_posix_in_port_t;
typedef uint32_t  api_posix_in_addr_t;
#else
typedef CFG_UINT16_TYPE  api_posix_in_port_t;
typedef CFG_UINT32_TYPE  api_posix_in_addr_t;
#endif  /* CFG_HDR_INTTYPES_H */

/* IPv4 network address */
struct api_posix_in_addr
{
   api_posix_in_addr_t  s_addr;
};

#define api_posix_struct_in_addr  struct api_posix_in_addr

/* IPv4 socket address */
struct api_posix_sockaddr_in
{
   api_posix_sa_family_t  sin_family;
   api_posix_in_port_t  sin_port;
   api_posix_struct_in_addr  sin_addr;
};

#define api_posix_struct_sockaddr_in  struct api_posix_sockaddr_in

#if CFG_HDR_INTTYPES_H
#   include <inttypes.h>
uint16_t  api_posix_htons(uint16_t);
uint32_t  api_posix_htonl(uint32_t);
uint16_t  api_posix_ntohs(uint16_t);
uint32_t  api_posix_ntohl(uint32_t);
#else
unsigned short int  api_posix_htons(unsigned short int);
unsigned long int  api_posix_htonl(unsigned long int);
unsigned short int  api_posix_ntohs(unsigned short int);
unsigned long int  api_posix_ntohl(unsigned long int);
#endif  /* CFG_HDR_INTTYPES_H */

api_posix_in_addr_t  api_posix_inet_addr(const char*);
int  api_posix_inet_pton(int, const char*, void*);


/* ========================================================================== */
/* Socket API */

#include <string.h>

#define API_POSIX_SOCK_STREAM  0

/* Yes, this type is signed in the original BSD API */
typedef int  api_posix_socklen_t;

/* Maximum size socket address structure to allocate memory */
struct api_posix_sockaddr_storage
{
   api_posix_sa_family_t  ss_family;
   char  ss_data[sizeof(api_posix_struct_sockaddr_in)
                 - sizeof(api_posix_sa_family_t)];
};

#define api_posix_struct_sockaddr_storage  struct api_posix_sockaddr_storage

struct api_posix_sockaddr
{
   api_posix_sa_family_t  sa_family;
   char  sa_data[sizeof(api_posix_struct_sockaddr_in)
                 - sizeof(api_posix_sa_family_t)];
};

#define api_posix_struct_sockaddr  struct api_posix_sockaddr

struct api_posix_servent
{
   char*  s_name;
   char**  s_aliases;
   int  s_port;
   char*  s_proto;
};

#define api_posix_struct_servent  struct api_posix_servent

struct api_posix_hostent
{
   char*  h_name;
   char**  h_aliases;
   int  h_addrtype;
   int  h_length;
   char**  h_addr_list;
};

#define api_posix_struct_hostent  struct api_posix_hostent

api_posix_struct_servent*  api_posix_getservbyname(const char*, const char*);
api_posix_struct_hostent*  api_posix_gethostbyname(const char*);

int  api_posix_socket(int, int, int);
int  api_posix_connect(int, const api_posix_struct_sockaddr*, api_posix_socklen_t);

#define API_POSIX_SOL_SOCKET   0

#define API_POSIX_SO_ERROR     0
#define API_POSIX_SO_RCVTIMEO  1
#define API_POSIX_SO_SNDTIMEO  2

int  api_posix_getsockopt(int, int, int, void*, api_posix_socklen_t*);
int  api_posix_setsockopt(int, int, int, const void*, api_posix_socklen_t);

#define API_POSIX_POLLIN    (short int) 0x0001
#define API_POSIX_POLLOUT   (short int) 0x0002
#define API_POSIX_POLLERR   (short int) 0x0004
#define API_POSIX_POLLHUP   (short int) 0x0008
#define API_POSIX_POLLNVAL  (short int) 0x0010

typedef unsigned int  api_posix_nfds_t;

struct api_posix_pollfd
{
   int  fd;
   short int  events;
   short int  revents;
};

#define api_posix_struct_pollfd  struct api_posix_pollfd

int  api_posix_poll(api_posix_struct_pollfd [], api_posix_nfds_t, int);

api_posix_ssize_t  api_posix_send(int, const void*, size_t, int);
api_posix_ssize_t  api_posix_recv(int, void*, size_t, int);


/* EOF */
