#ifndef NLS_H
#define NLS_H  1


/* ========================================================================== */
/* Include headers */

#include "config.h"


/* ========================================================================== */
/* Variables */

extern char  nls_loc[6];


/*! \addtogroup NLS */
/*! @{ */


/* ========================================================================== */
/* Macros */

/*! \brief Always remove NLS comments from code */
#define NLS_COMMENT(comment)
#if !CFG_USE_XSI || CFG_NLS_DISABLE
/*! \brief Leave default string in place if NLS is disabled */
#  define NLS_STRING(string)  string
#endif  /* !CFG_USE_XSI || CFG_NLS_DISABLE */


/*! @} */


/* ========================================================================== */
/* Function prototypes */

int  nls_init(void);
void  nls_exit(void);
const char*  nls_getstring(int, const char*);


#endif  /* NLS_H */

/* EOF */
