# ==============================================================================
# Second sublevel Makefile torso
#
# Copyright (c) 2012-2026 by the developers. See the LICENSE file for details.


# ==============================================================================
# Source files that contain NLS strings

NLS_SRCS=gui.cxx


# ==============================================================================
# Object files

COMMON_OBJS= bdate.o bsd.o compression.o conf.o core.o database.o digest.o \
             drunken_bishop.o encoding.o extutils.o fileutils.o filter.o \
             group.o hmac.o http.o inet.o log.o nntp.o posix.o secure.o \
             sighandler.o timing.o tls.o ts_functions.o xdg.o
OBJS= gui.o main.o nls.o $(COMMON_OBJS)
TEST_OBJS= $(COMMON_OBJS) test.o test_base64.o test_compression.o \
           test_cancellock.o test_inet_pton.o test_regex.o test_snprintf.o \
           test_strcasecmp_l.o test_timestamp.o test_unicode.o


# ==============================================================================
# Installation directories

INSTALL_DIRS=$(PREFIX)/bin $(MAN_PATH)


# ==============================================================================
# Suffix list

.SUFFIXES:
.SUFFIXES: .c .cxx .o


# ==============================================================================
# Main rules

# Complete build (without documentation)
all: bin/$(TARGET)
	@printf "Build successfully completed.\n"

# Tests (with default locale)
test: bin/test
	@./bin/test
	@printf "Tests successfully completed.\n"

# Installation
install: bin/$(TARGET) bsd_install
	@printf "Create installation tool ...\n"
	printf "%s\n" "#! $(SHELL)" >bin/install
	@printf "# =======================================" >>bin/install
	@printf "=========================================\n" >>bin/install
	printf "# Installation tool header created by build2.mk\n\n" >>bin/install
	printf "%s\n" "UTIL_CAT=$(UTIL_CAT)" >>bin/install
	printf "%s\n" "UTIL_RM=$(UTIL_RM)" >>bin/install
	printf "%s\n" "UTIL_CHMOD=$(UTIL_CHMOD)" >>bin/install
	printf "%s\n" "UTIL_STRIP=$(UTIL_STRIP)" >>bin/install
	export LC_ALL=POSIX ; \
           printf "%s\n" "FILE_LIST=$(FILE_LIST)" >>bin/install
	printf "\n\n" >>bin/install
	$(UTIL_CAT) bsd_install >>bin/install
	$(UTIL_CHMOD) +x bin/install
	@printf "\nDelete old file list ...\n"
	export LC_ALL=POSIX ; \
           if test -f $(FILE_LIST) ; then $(UTIL_RM) -f $(FILE_LIST) ; fi
	export LC_ALL=POSIX ; $(UTIL_TOUCH) $(FILE_LIST)
	@printf "\nCreate directories ...\n"
	export LC_ALL=POSIX ; \
           for dir in $(INSTALL_DIRS) ; \
           do $(UTIL_MKDIR) -p "$(DESTDIR)$$dir" ; done
	@printf "\nInstall program binary ...\n"
	export LC_ALL=POSIX ; ./bin/install -c -m 755 \
           bin/$(TARGET) "$(DESTDIR)$(PREFIX)/bin/$(TARGET)"
	@printf "\nInstall man page ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_SED) -e 's/$$NAME/$(TARGET)/g' -e 's/$$VERSION/$(VERSION)/g' \
           -e 's/$$DATE/$(DATE)/g' doc/man/manpage.1 >/tmp/$(TARGET).1
	export LC_ALL=POSIX ; ./bin/install -m 644 /tmp/$(TARGET).1 \
           "$(DESTDIR)$(MAN_PATH)/$(TARGET).1"
	@printf "\nInstall license file ...\n"
	# Replace Copyright symbol and Umlaut with Unicode glyphs
	export LC_ALL=POSIX ; \
           $(UTIL_MKDIR) -p "$(DESTDIR)$(LICENSE_PATH)" ; \
           $(UTIL_CAT) "LICENSE" | $(UTIL_SED) -e 's/(c)/©/1' \
           | $(UTIL_SED) -e 's/ae/ä/2' >/tmp/license ; \
           ./bin/install -m 644 "/tmp/license" \
           "$(DESTDIR)$(LICENSE_PATH)/license.txt"
	@printf "\nInstall NLS catalogs ...\n"
	export LC_ALL=POSIX ; \
           if test 0 -ne $(USE_NLS) ; \
           then \
              $(UTIL_MKDIR) -p "$(DESTDIR)$(NLS_PATH)" ; \
              cd nls/L10n ; for file in *.cat ; \
              do \
                 ../../bin/install -c -m 644 "$$file" \
                 "$(DESTDIR)$(NLS_PATH)/$$file" ; \
              done ; \
           fi
	@printf "\nInstall XDG files ...\n"
	export LC_ALL=POSIX ; \
           if test 0 -ne $(USE_XDG) ; \
           then \
              $(UTIL_MKDIR) -p "$(DESTDIR)$(XDGD_PATH)" ; \
              cd xdg/applications ; for file in *.desktop ; \
              do \
                 ../../bin/install -c -m 644 "$$file" \
                 "$(DESTDIR)$(XDGD_PATH)/$$file" ; \
              done ; \
           fi
	export LC_ALL=POSIX ; \
           if test 0 -ne $(USE_XDG) ; \
           then \
              $(UTIL_MKDIR) -p \
                 "$(DESTDIR)$(XDGI_PATH)/hicolor/48x48/apps" ; \
              cd xdg/icons/hicolor/48x48/apps ; for file in * ; \
              do \
                 ../../../../../bin/install -c -m 644 "$$file" \
                 "$(DESTDIR)$(XDGI_PATH)/hicolor/48x48/apps/$$file" ; \
              done ; \
           fi
	export LC_ALL=POSIX ; \
           if test 0 -ne $(USE_XDG) ; \
           then \
              $(UTIL_MKDIR) -p \
                 "$(DESTDIR)$(XDGI_PATH)/hicolor/64x64/apps" ; \
              cd xdg/icons/hicolor/64x64/apps ; for file in * ; \
              do \
                 ../../../../../bin/install -c -m 644 "$$file" \
                 "$(DESTDIR)$(XDGI_PATH)/hicolor/64x64/apps/$$file" ; \
              done ; \
           fi
	@printf "\nInstallation successfully completed.\n"

# Installation with stripped binary
install-strip: install
	$(UTIL_STRIP) "$(DESTDIR)$(PREFIX)/bin/$(TARGET)"

# Create documentation
documentation:
	@printf "\nConvert man page to HTML format ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_SED) -e 's/$$NAME/$(TARGET)/g' -e 's/$$VERSION/$(VERSION)/g' \
           -e 's/$$DATE/$(DATE)/g' doc/man/manpage.1 >/tmp/$(TARGET).1
	printf '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">\n' \
           >doc/$(TARGET).1.html
	export LC_ALL=POSIX ; \
           nroff -man </tmp/$(TARGET).1 | man2html -nodepage \
           >>doc/$(TARGET).1.html
	export LC_ALL=POSIX ; $(UTIL_RM) /tmp/$(TARGET).1
	@printf "Prepare Doxyfile ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_SED) 's/$$NAME/\"$(TARGET) $(VERSION)\"/g' \
           doc/templates/Doxyfile | $(UTIL_SED) 's/$$VERSION//g' >Doxyfile
	@printf "Prepare HTML header ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_SED) 's/$$NAME/$(TARGET)/g' doc/templates/header.html \
           | $(UTIL_SED) 's/$$VERSION/$(VERSION)/g' \
           >doc/html/header.html
	@printf "Prepare HTML footer ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_SED) 's/$$DATE/$(DATE)/g' doc/templates/footer.html \
           >doc/html/footer.html
	$(UTIL_CAT) doc/images/Doxygen.png >doc/html/Doxygen.png
	@printf "Prepare LaTeX title page ...\n"
	export LC_ALL=POSIX ; \
           $(UTIL_SED) 's/$$DATE/$(DATE)/g' doc/templates/header.tex \
           | $(UTIL_SED) 's/$$NAME/$(TARGET)/g' \
           | $(UTIL_SED) 's/$$VERSION/$(VERSION)/g' >doc/latex/header.tex
	$(UTIL_CAT) doc/images/Logo.png >doc/latex/Logo.png
	$(UTIL_CAT) doc/images/Doxygen.png >doc/latex/Doxygen.png
	@printf "Create documentation ...\n"
	export LC_ALL=POSIX ; doxygen
	@printf "\nPatch CSS for source code in HTML pages ...\n"
	patch doc/html/doxygen.css <doc/templates/doxygen.css.patch
	export LC_ALL=POSIX ; cd doc/latex ; $(MAKE)
	@printf "\nDocumentation successfully created.\n"


# ==============================================================================
# Sub rules

bin/$(TARGET): $(OBJS)
	$(CXX) $(CXXFLAGS) -o $@ $(OBJS) \
	   -L./lib -lbasexx-0 -ljpiconv-0 -lssiconv-0 -luciconv-0 \
           $(LDFLAGS) $(LIBS)

bin/test: $(TEST_OBJS)
	$(CXX) $(CXXFLAGS) -o $@ $(TEST_OBJS) \
	   -L./lib -lbasexx-0 -ljpiconv-0 -lssiconv-0 -luciconv-0 \
	   $(LDFLAGS) $(LIBS)

# If NLS is enabled:
# - Map 'S()' macros to 'NLS_STRING() macros'
#   'gui.cxx' => '.gui_tmp.cxx'
# - Replace 'NLS_STRING()' macros with 'nls_getstring()' function calls
#   '.gui_tmp.cxx' => '.gui_nls.cxx'
# If NLS is disabled:
# - Do nothing, just copy file as is
#   'gui.cxx' => '.gui_nls.cxx'
# Compile:
# - Always use '.gui_nls.cxx' as input
#   '.gui_nls.cxx' => 'gui.o'
# The temporary source files are automatically deleted on success
gui.o: nls/.nls_switch gui.cxx
	-$(UTIL_RM) -f .gui_nls.cxx
	export LC_ALL=POSIX ; if test -f nls/.nls_support ; \
        then \
           $(UTIL_SED) 's/\([^[:alnum:]]\)S(/\1NLS_STRING(/g' gui.cxx \
           > .gui_tmp.cxx && \
           $(UTIL_AWK) -f nls/string_replace.awk .gui_tmp.cxx >.gui_nls.cxx ; \
           $(UTIL_RM) .gui_tmp.cxx ; \
        else \
           $(UTIL_CAT) gui.cxx >.gui_nls.cxx ; \
        fi
	$(CXX) $(CXXFLAGS) -c -o $@ .gui_nls.cxx


# ==============================================================================
# Inference rules

.c.o:
	$(CC) $(CFLAGS) -c -o $@ $*.c

.cxx.o:
	$(CXX) -I./include $(CXXFLAGS) -c -o $@ $*.cxx


# ==============================================================================
# NLS

nls/.nls_support: mk/config.mk nls/string_table nls/.nls_catalogs
	$(UTIL_SLEEP) 1
	$(UTIL_TOUCH) $@

# SUSv2 define support for at least 32767 NLS strings
nls/string_table: nls/nls.txt
	# Remove duplicate NLS strings
	export LC_ALL=POSIX ; TMPFILE="nls/.tmp" ; \
	   $(UTIL_CAT) nls/nls.txt >$$TMPFILE ; \
           NUMEND=$$($(UTIL_AWK) -f nls/string_count.awk $$TMPFILE) ; \
           export NUM=1 ; \
           while test $$NUM -le $$NUMEND ; \
           do \
              $(UTIL_AWK) -f nls/string_dupclean.awk $$TMPFILE >$$TMPFILE.1 ; \
              $(UTIL_CAT) $$TMPFILE.1 >$$TMPFILE ; \
              $(UTIL_RM) $$TMPFILE.1 ; \
              NUMEND=$$($(UTIL_AWK) -f nls/string_count.awk $$TMPFILE) ; \
              NUM=$$(($$NUM + 1)) ; \
           done
	# Create table with NLS string to catalog number mapping
	export LC_ALL=POSIX ; export NLS_MSGMAX=32767 ; TMPFILE="nls/.tmp" ; \
           $(UTIL_AWK) -f nls/string_table.awk $$TMPFILE >$$TMPFILE.table ; \
           $(UTIL_CAT) $$TMPFILE.table >$@ ; \
           $(UTIL_RM) $$TMPFILE $$TMPFILE.table

# Attention:
# Conditional compilation should only depend from "config.h" or constants that
# are #define'd directly inside of the files (because for NLS string extraction
# the #include statements are removed).
nls/nls.txt: $(NLS_SRCS)
	# Extract NLS strings for translation
	@printf "" >$@
	printf "$$ Note for translators:\n" >>$@
	printf "$$ Empty lines are ignored\n" >>$@
	printf "$$ All lines starting with \"$$ \" are comments\n\n" >>$@
	export LC_ALL=POSIX ; TMPFILE="nls/.tmp" ; \
           for file in * ; \
           do \
              case $$file in \
              *.c)    printf "#include \"config.h\"\n" >$$TMPFILE.c && \
                      $(UTIL_SED) 's/#include.*//' $$file >>$$TMPFILE.c && \
                      $(CC) $(CFLAGS) -E $$TMPFILE.c \
                      | $(UTIL_AWK) -f nls/string_extract.awk >>$@ ; \
                      $(UTIL_RM) $$TMPFILE.c \
                      ;; \
              *.cxx)  printf "#include \"config.h\"\n" >$$TMPFILE.cxx && \
                      $(UTIL_SED) 's/#include.*//' $$file >>$$TMPFILE.cxx && \
                      $(CXX) $(CXXFLAGS) -E $$TMPFILE.cxx \
                      | $(UTIL_AWK) -f nls/string_extract.awk >>$@ ; \
                      $(UTIL_RM) $$TMPFILE.cxx \
                      ;; \
              esac ; \
           done

nls/.nls_catalogs: nls/string_table nls/.nls_translations
	# Build NLS catalogs
	export LC_ALL=$(LOCALE_GENCAT) ; for file in nls/L10n/*.txt ; \
           do \
              export NLS_TRANSLATION="$$file" ; \
              message_file=$$(printf "%s\n" "$$NLS_TRANSLATION" \
              | $(UTIL_SED) 's/\.txt/\.msg/') ; \
              catalog_file=$$(printf "%s\n" "$$NLS_TRANSLATION" \
              | $(UTIL_SED) 's/\.txt/\.cat/') ; \
              $(UTIL_AWK) -f nls/string_mkcatalog.awk nls/string_table \
              >$$message_file ; \
              $(UTIL_RM) -f $$catalog_file ; \
              $(UTIL_GENCAT) $$catalog_file $$message_file ; \
           done
	$(UTIL_TOUCH) $@

nls/.nls_translations: nls/string_table
	# Maintain NLS translation files
	export LC_ALL=POSIX ; for file in nls/L10n/*.txt ; \
           do \
              export NLS_TRANSLATION="$$file" ; \
              $(UTIL_AWK) -f nls/string_maintain.awk nls/nls.txt \
              >$$file.new ; \
              $(UTIL_CAT) $$file.new >$$file ; $(UTIL_RM) $$file.new ; \
           done
	$(UTIL_TOUCH) $@


