/*
 * Base 64 IMAP encoding and decoding functions
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include "libbasexx-0/base64_imap.h"


/* ========================================================================== */
void bxx0_base64_imap_to(unsigned char *buf, const size_t len)
{
    size_t i = 0;

    for (; len > i; ++i)
    {
        if (0x2FU == buf[i])
            buf[i] = 0x2C;
    }
}


/* ========================================================================== */
void bxx0_base64_imap_from(unsigned char *buf, const size_t len)
{
    size_t i = 0;

    for (; len > i; ++i)
    {
        if (0x2CU == buf[i])
            buf[i] = 0x2F;
    }
}
