/*
fuzzylite (R), a fuzzy logic control library in C++.

Copyright (C) 2010-2024 FuzzyLite Limited. All rights reserved.
Author: Juan Rada-Vilela, PhD <jcrada@fuzzylite.com>.

This file is part of fuzzylite.

fuzzylite is free software: you can redistribute it and/or modify it under
the terms of the FuzzyLite License included with the software.

You should have received a copy of the FuzzyLite License along with
fuzzylite. If not, see <https://github.com/fuzzylite/fuzzylite/>.

fuzzylite is a registered trademark of FuzzyLite Limited.
*/

#include "fuzzylite/norm/t/HamacherProduct.h"

#include "fuzzylite/Operation.h"

namespace fuzzylite {

    std::string HamacherProduct::className() const {
        return "HamacherProduct";
    }

    scalar HamacherProduct::compute(scalar a, scalar b) const {
        if (Op::isEq(a + b, 0.0))
            return 0.0;
        return (a * b) / (a + b - a * b);
    }

    HamacherProduct* HamacherProduct::clone() const {
        return new HamacherProduct(*this);
    }

    TNorm* HamacherProduct::constructor() {
        return new HamacherProduct;
    }

}
