;;;============================================================================

;;; File: "fixnum.scm"

;;; Copyright (c) 1994-2025 by Marc Feeley, All Rights Reserved.

(##declare
  (standard-bindings)
  (fixnum)
)

(##define-macro (include-adt filename)
  `(begin
     (##declare (not core))
     (##include ,(string-append "../gsc/" filename))
     (##declare (core))))

;; Define where things are defined to avoid undefined references warnings.

;;-----------------------------------------------------------------------------
;; defined in "_host.scm"

(namespace ("c#"
**compilation-meta-info-add!
**compilation-module-ref-set!
**comply-to-standard-scheme?
**display-message-with-locat
**in-new-compilation-ctx
**locat-start-position ;; TODO: remove after bootstrap
**locat-end-position ;; TODO: remove after bootstrap
**macro-compilation-ctx-demand-modules
**macro-compilation-ctx-meta-info
**macro-compilation-ctx-supply-modules
**macro-compilation-ctx-supply-modules-set!
**macro-descr-def-syntax?
**macro-descr-expander
**macro-descr-size
**main-readtable ;; variable
**make-locat ;; TODO: remove after bootstrap
**make-macro-descr
**meta-info->alist
absent-object
absent-object?
box-object
box-object?
character->unicode
deleted-object?
end-of-file-object
end-of-file-object?
f32vect->list
f32vect-length
f32vect-ref
f32vect-set!
f32vect?
f64vect->list
f64vect-length
f64vect-ref
f64vect-set!
f64vect?
false-object
false-object?
fatal-err
float-copysign
format-filepos
in-char-range?
in-integer-range?
key-object
key-object?
keyword-object->string
keyword-object-hash
keyword-object-interned?
keyword-object?
make-f32vect
make-f64vect
make-u16vect
make-u32vect
make-u64vect
make-u8vect
max-fixnum32-div-max-lines
max-lines
open-input-file*
open-input-file*-preserving-case
open-output-file-preserving-case
optional-object
optional-object?
pp-expression
write-returning-len
write-returning-len-without-read-macros
display-returning-len
rest-object
rest-object?
s16vect->list
s16vect-length
s16vect-ref
s16vect?
s32vect->list
s32vect-length
s32vect-ref
s32vect?
s64vect->list
s64vect-length
s64vect-ref
s64vect?
s8vect->list
s8vect-length
s8vect-ref
s8vect?
scheme-file-extensions
scheme-global-eval
scheme-global-var
scheme-global-var-define!
set-box-object!
string->keyword-object
structure->list
structure-object?
symbol-object-hash
symbol-object-interned?
symbol-object?
u16vect->list
u16vect-length
u16vect-ref
u16vect-set!
u16vect?
u32vect->list
u32vect-length
u32vect-ref
u32vect-set!
u32vect?
u64vect->list
u64vect-length
u64vect-ref
u64vect-set!
u64vect?
u8vect->list
u8vect-length
u8vect-ref
u8vect-set!
u8vect?
unbound1-object?
unbound2-object?
unbox-object
unicode->character
unused-object?
vector-object?
void-object
void-object?
))

;;-----------------------------------------------------------------------------
;; defined in "_utils.scm"

(namespace ("c#"
append-lists
base92-encode
compiler-error
compiler-internal-error
compiler-user-error
compiler-user-warning
every?
for-each-index
keep
list->ptset
list->queue
list->str
list->varset
list->vect
lset-difference
make-counter
make-gnode
make-ordered-table
make-stretchable-vector
map-index
object-pos-in-list
ordered-table->list
ordered-table-enter
ordered-table-lookup
pair-up
pos-in-list
ptset->list
ptset-adjoin
ptset-empty
ptset-empty?
ptset-every?
ptset-member?
ptset-remove
ptset-size
queue->list
queue-empty
queue-empty?
queue-get!
queue-put!
read-line*
remq ;; TODO: remove since this is also in the "" namespace
sort-list
str->list
stretchable-vector->list
stretchable-vector-copy
stretchable-vector-for-each
stretchable-vector-length
stretchable-vector-ref
stretchable-vector-set!
string-substitute
topological-sort
transitive-closure
varset->list
varset-adjoin
varset-difference
varset-empty
varset-empty?
varset-equal?
varset-intersection
varset-intersects?
varset-member?
varset-remove
varset-singleton
varset-size
varset-union
varset-union-multi
vect->list
with-exception-handling
))

;;-----------------------------------------------------------------------------
;; defined in "_source.scm"

(namespace ("c#"
**filepos-line
expression->source
include-expr->source
locat-filename-and-line
locat-show
make-source
read-source
source->expression
source-code
source-locat
source-path
source?
sourcify
sourcify-deep
string->canonical-symbol
))

;;-----------------------------------------------------------------------------
;; defined in "_parms.scm"

(namespace ("c#"
**and-sym
**begin-sym
**box-sym
**c-declare-sym
**c-define-sym
**c-define-type-sym
**c-initialize-sym
**c-lambda-sym
**case-memv-sym
**case-sym
**cond-sym
**dead-end-sym
**declare-scope-sym
**declare-sym
**define-macro-sym
**define-sym
**define-syntax-sym
**delay-sym
**do-sym
**eq?-sym
**eqv?-sym
**future-sym
**guard-sym
**identity-sym
**if-sym
**include-sym
**lambda-sym
**let*-sym
**let-sym
**letrec*-sym
**letrec-sym
**macro-scope-sym
**make-delay-promise-sym
**namespace-scope-sym
**namespace-sym
**not-sym
**or-sym
**quasi-append-sym
**quasi-cons-sym
**quasi-list->vector-sym
**quasi-list-sym
**quasi-vector-sym
**quasiquote-sym
**quote-sym
**r7rs-guard-sym
**r7rs-with-exception-catcher-sym
**r7rs-reraise-sym
**fixnum?-sym
**fixnums?-sym
**flonum?-sym
**flonums?-sym
**iflonum?-sym
**iflonums?-sym
**raise-sym
**set!-sym
**set-box!-sym
**unbox-sym
**with-exception-catcher-sym
=>-sym
allocation-limit-sym
and-sym
begin-sym
block-sym
c-id-prefix
compiler-version
compiler-version-string
constant-fold-sym
core-sym
debug-environments-sym
debug-location-sym
debug-source-sym
debug-sym
define-sym
else-sym
environment-map-sym
extended-bindings-sym
fixnum-sym
flonum-sym
function-sym
future-sym
gambit-scheme-sym
generative-lambda-sym
generic-sym
ieee-scheme-sym
if-sym
inline-primitives-sym
inline-sym
inlining-limit-sym
interrupts-enabled-sym
lambda-lift-sym
lambda-sym
let-sym
letrec-sym
mostly-fixnum-flonum-sym
mostly-fixnum-iflonum-sym
mostly-fixnum-sym
mostly-flonum-fixnum-sym
mostly-flonum-sym
mostly-iflonum-fixnum-sym
mostly-iflonum-sym
mostly-generic-sym
multilisp-sym
nonnull-function-sym
nonnull-pointer-sym
not-sym
optimize-dead-definitions-sym
optimize-dead-local-variables-sym
or-sym
pointer-sym
poll-on-return-sym
proper-tail-calls-sym
quasiquote-sym
quote-sym
r4rs-scheme-sym
r5rs-scheme-sym
run-time-bindings-sym
safe-sym
scheme-object-sym
scheme-to-c-notation
separate-sym
set!-sym
standard-bindings-sym
struct-sym
type-sym
union-sym
unquote-splicing-sym
unquote-sym
void-sym
warnings-sym
))

;;-----------------------------------------------------------------------------
;; defined in "_env.scm"

(namespace ("c#"
boolean-decl
boolean-declarations
closure-env-var
declaration-value
define-boolean-decl
define-flag-decl
define-namable-boolean-decl
define-namable-decl
define-parameterized-decl
empty-var
env-decl-ref
env-decl-set
env-declare
env-define-var
env-externals-ref
env-frame
env-global-variables
env-lookup
env-lookup-global-var
env-lookup-macro
env-lookup-var
env-macro
env-macros-ref
env-macros-set
env-namespace
env-namespace-ref
env-namespace-set
env-vars-ref
env.begin!
env.end!
flag-decl
flag-declarations
make-global-environment
make-temp-var
make-var
namable-boolean-decl
namable-boolean-declarations
namable-decl
namable-declarations
namespace-valid?
next-var-stamp
parameterized-decl
parameterized-declarations
ret-var
ret-var-set
var-bound
var-bound-set!
var-boxed?
var-boxed?-set!
var-clone
var-clone-set!
var-constant
var-constant-set!
var-info
var-info-set!
var-lexical-level
var-name
var-name-set!
var-refs
var-refs-set!
var-sets
var-sets-set!
var-source
var-source-set!
var-stamp
var-stamp-set!
var-tag
var-temp?
var-temp?-set!
var?
))

;;-----------------------------------------------------------------------------
;; defined in "_ptree1.scm"

(namespace ("c#"
add-not-inline-primitives
add-not-safe
add-proper-tail-calls
app->specialized-proc
app-args
app-oper
app-tag
app?
bindable-var?
bound-free-variables
bound?
conj-alt
conj-pre
conj-tag
conj?
constant-fold?
core?
cst-tag
cst-val
cst-val-set!
cst?
debug-environments?
debug-location?
debug-source?
debug?
def-tag
def-val
def-var
def-var-set!
def?
disj-alt
disj-pre
disj-tag
disj?
environment-map?
free-variables
fut-tag
fut-val
fut?
generative-lambda?
global-proc-obj
global-single-def
global-singly-bound?
global?
ill-formed-special-form
inline-primitive?
inline?
inlining-limit
intrs-enabled?
lambda-lift?
make-app
make-conj
make-cst
make-def
make-disj
make-fut
make-prc
make-ref
make-set
make-tst
match
mutable?
nb-args-conforms?
new-call
new-conj
new-cst
new-def
new-disj
new-fut
new-let
new-prc
new-ref
new-seq
new-set
new-temp-variable
new-tst
next-node-stamp
node-bfv
node-bfv-set!
node-children
node-children-set!
node-env
node-env-set!
node-fv
node-fv-invalidate!
node-fv-set!
node-parent
node-parent-set!
node-source
node-source-set!
node-stamp
node-stamp-set!
oper-pos?
optimize-dead-definitions?
optimize-dead-local-variables?
parms->source
parse-program
poll-on-return?
prc-body
prc-c-name
prc-c-name-set!
prc-keys
prc-keys-set!
prc-name
prc-name-set!
prc-opts
prc-opts-set!
prc-parms
prc-parms-set!
prc-proc-obj
prc-proc-obj-get
prc-proc-obj-set!
prc-req-and-opt-parms-only?
prc-rest?
prc-rest?-set!
prc-tag
prc?
proper-length
proper-tail-calls?
pt-syntax-error
ptree.begin!
ptree.end!
ptree?
ref-tag
ref-var
ref-var-set!
ref?
remove-std-ext-rt-bindings
run-time-binding?
safe?
scheme-dialect
self-evaluating?
set-tag
set-val
set-var
set-var-set!
set?
specialize-app
specialize-proc
standard-proc-obj
standard-procedure?
tst-alt
tst-con
tst-pre
tst-tag
tst?
warnings?
))

;;-----------------------------------------------------------------------------
;; defined in "_ptree2.scm"

(namespace ("c#"
**c-declare-expr?
**c-define-expr?
**c-define-type-expr?
**c-initialize-expr?
**c-lambda-expr?
add-c-decl
add-c-init
add-c-type
build-c-define
c-declaration-body
c-definition-name
c-definition-param-types
c-definition-proc-name
c-definition-result-type
c-definition-scope
c-definition-value
c-initialization-body
c-interface-begin
c-interface-end
c-intf-decls
c-intf-decls-set!
c-intf-inits
c-intf-inits-set!
c-intf-objs
c-intf-objs-set!
c-intf-procs
c-intf-procs-set!
c-proc-arity
c-proc-body
c-proc-c-name
c-proc-scheme-name
c-type-definition-name
c-type-definition-type
dead-end-calls?
gen-call-prim
gen-call-prim-notsafe
gen-call-prim-vars
gen-call-prim-vars-notsafe
gen-disj-multi
gen-prc
gen-temp-vars
gen-var-type-checks
nonneg-integer->c-id
normalize-program
parse-tree->expression
pt-c-lambda
scheme-id->c-id
side-effects-impossible?
string->c-id
))

;;-----------------------------------------------------------------------------
;; defined in "_gvm.scm"

(namespace ("c#"
*opnd-table*
apply-loc
apply-opnds
apply-prim
bb-branch-instr
bb-entry-frame-size
bb-exit-frame-size
bb-label-instr
bb-label-type
bb-lbl-num
bb-non-branch-instrs
bb-non-branch-instrs-set!
bb-precedents
bb-put-branch!
bb-put-non-branch!
bb-slots-gained
bbs->code-list
bbs-basic-blocks
bbs-entry-lbl-num
bbs-entry-lbl-num-set!
bbs-new-lbl!
bbs-next-lbl-num
bbs?
clo-base
clo-index
clo?
close-parms
closure-parms-lbl
closure-parms-loc
closure-parms-opnds
code-bb
code-gvm-instr
code-slots-needed
comment-get
comment-put!
copy-loc
copy-opnd
debug-info-add!
debug-info-generate
enter-opnd
frame-closed
frame-live
frame-live?
frame-regs
frame-size
frame-slots
glo-name
glo?
gvm-instr-comment
gvm-instr-frame
gvm-instr-type
ifjump-false
ifjump-opnds
ifjump-poll?
ifjump-test
ifjump-true
jump-nb-args
jump-opnd
jump-poll?
jump-ret
jump-safe?
label-entry-closed?
label-entry-keys
label-entry-nb-parms
label-entry-opts
label-entry-rest?
label-lbl-num
label-type
lbl-num
lbl-num->bb
lbl?
make-apply
make-bb
make-bbs
make-clo
make-close
make-closure-parms
make-comment
make-copy
make-debug-info-state
make-frame
make-glo
make-ifjump
make-jump
make-label-entry
make-label-return
make-label-simple
make-label-task-entry
make-label-task-return
make-lbl
make-obj
make-pattern
make-pcontext
make-proc-obj
make-reg
make-stk
make-switch
make-switch-case
obj-val
obj?
pattern-member?
pcontext-fs
pcontext-map
proc-obj-c-name
proc-obj-c-name-set!
proc-obj-call-pat
proc-obj-call-pat-set!
proc-obj-code
proc-obj-code-set!
proc-obj-dead-end?
proc-obj-dead-end?-set!
proc-obj-expand
proc-obj-expand-set!
proc-obj-expandable?
proc-obj-expandable?-set!
proc-obj-inlinable?
proc-obj-inlinable?-set!
proc-obj-inline
proc-obj-inline-set!
proc-obj-jump-inlinable?-set!
proc-obj-jump-inline
proc-obj-jump-inline-set!
proc-obj-lift-pat
proc-obj-name
proc-obj-name-set!
proc-obj-primitive?
proc-obj-primitive?-set!
proc-obj-side-effects?
proc-obj-simplify
proc-obj-simplify-set!
proc-obj-specialize
proc-obj-specialize-set!
proc-obj-standard
proc-obj-test
proc-obj-test-set!
proc-obj-testable?
proc-obj-testable?-set!
proc-obj-type
proc-obj?
purify-procs
reachable-procs
reg-num
reg?
return-addr-reg
stk-num
stk?
switch-case-lbl
switch-case-obj
switch-cases
switch-default
switch-opnd
switch-poll?
type-name
virtual.begin!
virtual.dump-cfg
virtual.dump-dg
virtual.dump-gvm
virtual.end!
))

;;-----------------------------------------------------------------------------
;; defined in "_back.scm"

(namespace ("c#"
**dead-end-proc-obj
**eq?-proc-obj
**identity-proc-obj
**not-proc-obj
**quasi-cons-proc-obj
**quasi-list-proc-obj
**fixnum?-proc-obj
**fixnums?-proc-obj
**flonum?-proc-obj
**flonums?-proc-obj
**iflonum?-proc-obj
**iflonums?-proc-obj
allocation-limit
arith-implementation
default-target
frame-constraints-align
frame-constraints-reserve
get-option
link-modules
make-frame-constraints
make-prim-proc-table
make-target
mostly-arith-implementation
prim-proc-add!
prim-proc-info
target-add
target-begin!-set!
target-compactness
target-compactness-set!
target-dump-set!
target-end!-set!
target-eq-testable?-set!
target-extra
target-extra-set!
target-file-extensions
target-frame-constraints-set!
target-get
target-jump-info
target-label-info
target-link-info-set!
target-link-set!
target-max-small-allocation
target-max-small-allocation-set!
target-name
target-nb-arg-regs
target-nb-arg-regs-set!
target-nb-regs
target-nb-regs-set!
target-object-type
target-object-type-set!
target-options
target-prim-info
target-prim-info-set!
target-proc-result-set!
target-select!
target-switch-testable?-set!
target-unselect!
target.dump
target.file-extensions
target.frame-constraints
target.jump-info
target.label-info
target.nb-regs
target.prim-info
target.proc-result
target.switch-testable?
))

;;-----------------------------------------------------------------------------
;; defined in "_front.scm"

(namespace ("c#"
cf
compiler-option-debug
compiler-option-debug-environments
compiler-option-debug-location
compiler-option-debug-source
compiler-option-track-scheme
))

;;-----------------------------------------------------------------------------
;; defined in "_prims.scm"

(namespace ("c#"
prim-procs
setup-prims
))

;;-----------------------------------------------------------------------------
;; defined in "_asm.scm"

(namespace ("_asm#"
asm-16-le
asm-32-le
asm-8
asm-align
asm-assemble-to-u8vector
asm-at-assembly
asm-display-listing
asm-init-code-block
asm-int-le
asm-label
asm-label-id
asm-label-name
asm-label-pos
asm-label?
asm-listing
asm-make-label
asm-separated-list
asm-signed-lo
asm-signed-lo64
asm-signed32?
asm-signed8?
asm-unsigned-lo16
asm-unsigned-lo32
asm-unsigned-lo64
))

;;-----------------------------------------------------------------------------
;; defined in "_x86.scm"

(namespace ("_x86#"
x86-add
x86-and
x86-arch-set!
x86-bt
x86-cdq
x86-cmova
x86-cmovae
x86-cmovb
x86-cmovbe
x86-cmove
x86-cmovg
x86-cmovge
x86-cmovl
x86-cmovle
x86-cmovne
x86-cmp
x86-cqo
x86-cwd
x86-db
x86-dd
x86-dq
x86-dw
x86-idiv
x86-imm-glo
x86-imm-int
x86-imm-lbl
x86-imm-obj
x86-imul
x86-ja
x86-jae
x86-jb
x86-jbe
x86-je
x86-jg
x86-jge
x86-jl
x86-jle
x86-jmp
x86-jne
x86-jno
x86-jo
x86-label
x86-lea
x86-lzcnt
x86-mem
x86-mem?
x86-mov
x86-movsx
x86-neg
x86-not
x86-or
x86-pop
x86-popcnt
x86-sar
x86-shl
x86-shr
x86-sub
x86-test
x86-xor
))

;;-----------------------------------------------------------------------------
;; defined in "_arm.scm"

(namespace ("_arm#"
arm-add
arm-and
arm-arch-set!
arm-b
arm-bx
arm-cmp
arm-db
arm-dd
arm-dq
arm-dw
arm-imm-int
arm-label
arm-ldr
arm-listing
arm-lsl
arm-lsr
arm-mov
arm-movt
arm-movw
arm-mul
arm-mvn
arm-neg
arm-str
arm-sub
arm-tst
))

;;-----------------------------------------------------------------------------
;; defined in "_riscv.scm"

(namespace ("_riscv#"
riscv-add
riscv-addi
riscv-and
riscv-andi
riscv-arch-set!
riscv-beq
riscv-beqz
riscv-bge
riscv-bgeu
riscv-bgez
riscv-bgt
riscv-bgtu
riscv-bgtz
riscv-ble
riscv-bleu
riscv-blez
riscv-blt
riscv-bltu
riscv-bltz
riscv-bne
riscv-bnez
riscv-db
riscv-dd
riscv-dh
riscv-dw
riscv-imm-int
riscv-imm-lbl
riscv-j
riscv-jal
riscv-jr
riscv-label
riscv-ld
riscv-li
riscv-listing
riscv-lui
riscv-lw
riscv-mv
riscv-not
riscv-sd
riscv-slli
riscv-slt
riscv-sltz
riscv-srli
riscv-sub
riscv-sw
))

;;-----------------------------------------------------------------------------
;; defined in "_codegen.scm"

(namespace ("_codegen#"
codegen-context-arch
codegen-context-arch-set!
codegen-context-current-code
codegen-context-current-code-set!
codegen-context-current-proc
codegen-context-current-proc-set!
codegen-context-delayed-actions
codegen-context-delayed-actions-set!
codegen-context-fixup-locs->vector
codegen-context-fixup-objs->vector
codegen-context-frame
codegen-context-frame-set!
codegen-context-label-struct-position
codegen-context-label-struct-position-set!
codegen-context-listing-format
codegen-context-listing-format-set!
codegen-context-memory-allocated
codegen-context-memory-allocated-set!
codegen-context-other-labels-table
codegen-context-primitive-labels-table
codegen-context-proc-labels-table
codegen-context-registers-status
codegen-context-registers-status-set!
codegen-context-target
codegen-context-target-set!
codegen-fixup-glo!
codegen-fixup-handler!
codegen-fixup-lbl!
codegen-fixup-lbl-late!
codegen-fixup-obj!
make-codegen-context
))

;;-----------------------------------------------------------------------------
;; defined in "_t-univ-1.scm"

(namespace ("c#"
ctx-decls
ctx-globals-used
ctx-imports
ctx-inits
ctx-ns-prefix
ctx-ns-prefix-class
ctx-rtlib-features-used
ctx-rtlib-features-used-set!
ctx-stack-base-offset
ctx-target
gvm-lbl-use
gvm-lbl-use-aux
gvm-proc-use
gvm-state-current-processor
gvm-state-current-thread
gvm-state-current-vm
gvm-state-glo-use
gvm-state-nargs-use
gvm-state-pollcount-use
gvm-state-sp-use
gvm-state-stack-use
make-resource-set
resource-set-add!
resource-set-pop
resource-set-stack
tt
univ-absent-representation
univ-add-module-import
univ-add-module-init
univ-always-return-jump?
univ-array-constructor
univ-bb-prefix
univ-boolean-representation
univ-box
univ-box?
univ-capitalized-bb-prefix
univ-char-representation
univ-clo-slots
univ-compactness>=?
univ-constant
univ-deleted-representation
univ-denv-local
univ-display
univ-emit-!=
univ-emit-&&
univ-emit-*
univ-emit-+
univ-emit--
univ-emit-/
univ-emit-<
univ-emit-<<
univ-emit-<=
univ-emit-=
univ-emit->
univ-emit->=
univ-emit->>
univ-emit->>>
univ-emit-alias
univ-emit-and
univ-emit-array-index
univ-emit-array-length
univ-emit-array-literal
univ-emit-array-push!
univ-emit-array-shrink!
univ-emit-array-shrink-possibly-copy!
univ-emit-array?
univ-emit-assign
univ-emit-assign-expr
univ-emit-attribute-exists?
univ-emit-bitand
univ-emit-bitior
univ-emit-bitnot
univ-emit-bitxor
univ-emit-call-with-arg-array
univ-emit-cast
univ-emit-cast*
univ-emit-cast*-jumpable
univ-emit-cast*-scmobj
univ-emit-concat
univ-emit-conv*
univ-emit-copy-array-to-extensible-array
univ-emit-downcast*
univ-emit-downupcast*
univ-emit-eq?
univ-emit-expr-statement
univ-emit-extensible-array-literal
univ-emit-extensible-array-to-array!
univ-emit-extensible-subarray
univ-emit-getglo
univ-emit-getnargs
univ-emit-getopnd
univ-emit-getopnds
univ-emit-getpeps
univ-emit-getreg
univ-emit-getstk
univ-emit-glo-var-primitive-ref
univ-emit-glo-var-primitive-set!
univ-emit-glo-var-ref
univ-emit-glo-var-set!
univ-emit-glo-var?
univ-emit-global-var
univ-emit-if
univ-emit-if-expr
univ-emit-if-instanceof
univ-emit-inc-by
univ-emit-indent
univ-emit-local-var
univ-emit-make-array
univ-emit-map
univ-emit-move-array-to-array
univ-emit-new-array
univ-emit-not
univ-emit-obj
univ-emit-obj*
univ-emit-or
univ-emit-parens
univ-emit-parens-php
univ-emit-pop
univ-emit-popcount!
univ-emit-prefix
univ-emit-prefix-class
univ-emit-prop-index
univ-emit-prop-index-exists?
univ-emit-prop-index-or-null
univ-emit-push
univ-emit-rts-class
univ-emit-rts-class-ref
univ-emit-rts-class-use
univ-emit-rts-field-use
univ-emit-rts-jumpable-use
univ-emit-rts-method
univ-emit-rts-method-ref
univ-emit-rts-method-use
univ-emit-setglo
univ-emit-setloc
univ-emit-setnargs
univ-emit-setreg
univ-emit-subarray
univ-emit-this-mod-jumpable
univ-emit-tostr
univ-emit-try-catch
univ-emit-unalias
univ-emit-upcast*
univ-emit-var-declaration
univ-emit-while
univ-env-name-val
univ-eof-representation
univ-field-rename
univ-fixnum-max
univ-fixnum-max*2+1
univ-fixnum-max+1
univ-fixnum-min
univ-fixnum-representation
univ-flonum-representation
univ-foldr-range
univ-frame-representation
univ-gensym
univ-glo-use
univ-java-pre7?
univ-js-define-globals-using-assignment
univ-key-representation
univ-keyword-representation
univ-max-memoized-fixnum
univ-mdigit-base
univ-mdigit-base-minus-1
univ-mdigit-width
univ-min-memoized-fixnum
univ-mod-jumpable-is-field?
univ-module-representation
univ-nb-arg-regs
univ-never-return-jump?
univ-null-representation
univ-num-array-constant
univ-obj-use
univ-optional-representation
univ-php-pre53?
univ-pop-args-to-regs
univ-pop-args-to-vars
univ-prim-info*
univ-procedure-representation
univ-push-args
univ-python-pre3?
univ-renamed-fields
univ-rest-representation
univ-rts-field-low-level-name
univ-rts-method-low-level-name
univ-separated-list
univ-single-line-comment-prefix
univ-stack-resizable?
univ-stk-slot-from-tos
univ-string-representation
univ-structure-representation
univ-symbol-representation
univ-tag-bits
univ-thread-cont-slot
univ-thread-denv-cache1-slot
univ-thread-denv-cache2-slot
univ-thread-denv-cache3-slot
univ-thread-denv-slot
univ-tostr-method-name
univ-unbound-representation
univ-unbox
univ-unused-representation
univ-use-rtlib
univ-values-representation
univ-vector-representation
univ-void-representation
univ-word-bits
univ-wrap
univ-wrap*
univ-wrap+
univ-wrap-
univ-wrap/
with-new-resources-used
with-stack-pointer-adjust
))

;;-----------------------------------------------------------------------------
;; defined in "_t-univ-2.scm"

(namespace ("c#"
univ-class
univ-class-class-classes
univ-class-class-fields
univ-class-class-methods
univ-class-constructor
univ-class-extends
univ-class-inits
univ-class-instance-fields
univ-class-instance-methods
univ-class-properties
univ-class-root-name
univ-decl-properties
univ-def-kind
univ-entry-defs
univ-field
univ-field-inherited?
univ-field-init
univ-field-name
univ-field-properties
univ-field-type
univ-link-info-prefix
univ-method
univ-method-attribs
univ-method-body
univ-method-modifier
univ-method-name
univ-method-params
univ-method-result-type
univ-method?
univ-module-footer
univ-module-header
univ-rtlib-defs
univ-rtlib-feature-table
univ-rtlib-init
univ-source-file-footer
))

;;-----------------------------------------------------------------------------
;; defined in "_t-univ-3.scm"

(namespace ("c#"
make-translated-operand-generator
univ-add-class
univ-add-field
univ-add-init
univ-add-method
univ-call-with-ctrlpt-attrib
univ-define-prim
univ-define-prim-bool
univ-defs-classes
univ-defs-combine
univ-defs-combine-list
univ-defs-fields
univ-defs-inits
univ-defs-methods
univ-emit-absent
univ-emit-apply
univ-emit-bignum-digits
univ-emit-bignum?
univ-emit-bool
univ-emit-bool?
univ-emit-boolean-box
univ-emit-boolean-obj
univ-emit-boolean-unbox
univ-emit-boolean?
univ-emit-box
univ-emit-box?
univ-emit-call-member
univ-emit-call-prim
univ-emit-char-box
univ-emit-char-box-uninterned
univ-emit-char-obj
univ-emit-char-unbox
univ-emit-char?
univ-emit-chr-fromint
univ-emit-chr-toint
univ-emit-closure-code
univ-emit-closure-length
univ-emit-closure-ref
univ-emit-closure-set!
univ-emit-closure?
univ-emit-cons
univ-emit-cons-inline
univ-emit-continuation?
univ-emit-cpxnum-make
univ-emit-cpxnum?
univ-emit-decl
univ-emit-defs
univ-emit-deleted
univ-emit-dict-delete
univ-emit-dict-get
univ-emit-dict-get-or-null
univ-emit-dict-key-exists?
univ-emit-dict-length
univ-emit-dict-set
univ-emit-empty-dict
univ-emit-eof
univ-emit-f32vector-box
univ-emit-f32vector-length
univ-emit-f32vector-ref
univ-emit-f32vector-set!
univ-emit-f32vector-shrink!
univ-emit-f32vector?
univ-emit-f64vector-box
univ-emit-f64vector-length
univ-emit-f64vector-ref
univ-emit-f64vector-set!
univ-emit-f64vector-shrink!
univ-emit-f64vector?
univ-emit-field
univ-emit-fixnum-box
univ-emit-fixnum-unbox
univ-emit-fixnum?
univ-emit-float
univ-emit-float-abs
univ-emit-float-acos
univ-emit-float-acosh
univ-emit-float-asin
univ-emit-float-asinh
univ-emit-float-atan
univ-emit-float-atan2
univ-emit-float-atanh
univ-emit-float-ceiling
univ-emit-float-copysign
univ-emit-float-cos
univ-emit-float-cosh
univ-emit-float-eqv?
univ-emit-float-exp
univ-emit-float-expm1
univ-emit-float-expt
univ-emit-float-finite?
univ-emit-float-floor
univ-emit-float-fromint
univ-emit-float-hypot
univ-emit-float-ilogb
univ-emit-float-infinite?
univ-emit-float-integer?
univ-emit-float-log
univ-emit-float-log1p
univ-emit-float-math
univ-emit-float-nan?
univ-emit-float-round-half-to-even
univ-emit-float-scalbn
univ-emit-float-sin
univ-emit-float-sinh
univ-emit-float-sqrt
univ-emit-float-tan
univ-emit-float-tanh
univ-emit-float-toint
univ-emit-float-truncate
univ-emit-float?
univ-emit-flonum-box
univ-emit-flonum-box-inline
univ-emit-flonum-unbox
univ-emit-flonum?
univ-emit-flonum?-inline
univ-emit-fn-body
univ-emit-fn-decl
univ-emit-foreign?
univ-emit-frame-box
univ-emit-frame-slots
univ-emit-frame-unbox
univ-emit-frame?
univ-emit-function-declaration
univ-emit-function?
univ-emit-getcar
univ-emit-getcdr
univ-emit-host-primitive?
univ-emit-instanceof
univ-emit-int
univ-emit-int?
univ-emit-js-bigint?
univ-emit-js-number?
univ-emit-js-number?-inline
univ-emit-jump
univ-emit-key
univ-emit-keyword-box
univ-emit-keyword-box-uninterned
univ-emit-keyword-obj
univ-emit-keyword-unbox
univ-emit-keyword?
univ-emit-member
univ-emit-new
univ-emit-new*
univ-emit-new-continuation
univ-emit-new-delay-promise
univ-emit-new-foreign
univ-emit-new-scheme
univ-emit-new-will
univ-emit-null
univ-emit-null-obj
univ-emit-null-obj?
univ-emit-null?
univ-emit-num-of-type
univ-emit-optional
univ-emit-pair?
univ-emit-pair?-inline
univ-emit-poll-or-continue
univ-emit-procedure-declaration
univ-emit-procedure?
univ-emit-promise?
univ-emit-ratnum-make
univ-emit-ratnum?
univ-emit-rest
univ-emit-return
univ-emit-return-call-prim
univ-emit-return-jump
univ-emit-return-poll
univ-emit-return?
univ-emit-s16vector-box
univ-emit-s16vector-length
univ-emit-s16vector-ref
univ-emit-s16vector-set!
univ-emit-s16vector-shrink!
univ-emit-s16vector?
univ-emit-s32-box
univ-emit-s32-unbox
univ-emit-s32vector-box
univ-emit-s32vector-length
univ-emit-s32vector-ref
univ-emit-s32vector-set!
univ-emit-s32vector-shrink!
univ-emit-s32vector?
univ-emit-s64-box
univ-emit-s64-unbox
univ-emit-s64vector-box
univ-emit-s64vector-length
univ-emit-s64vector-ref
univ-emit-s64vector-set!
univ-emit-s64vector-shrink!
univ-emit-s64vector?
univ-emit-s8vector-box
univ-emit-s8vector-length
univ-emit-s8vector-ref
univ-emit-s8vector-set!
univ-emit-s8vector-shrink!
univ-emit-s8vector?
univ-emit-scheme?
univ-emit-setbox
univ-emit-setcar
univ-emit-setcdr
univ-emit-str
univ-emit-str->string
univ-emit-str-index-code
univ-emit-str-length
univ-emit-str-toint
univ-emit-str?
univ-emit-string->str
univ-emit-string-box
univ-emit-string-length
univ-emit-string-obj
univ-emit-string-ref
univ-emit-string-set!
univ-emit-string-shrink!
univ-emit-string-unbox
univ-emit-string?
univ-emit-string?-inline
univ-emit-structure-box
univ-emit-structure-ref
univ-emit-structure-set!
univ-emit-structure-unbox
univ-emit-structure?
univ-emit-substring
univ-emit-symbol-box
univ-emit-symbol-box-uninterned
univ-emit-symbol-obj
univ-emit-symbol-unbox
univ-emit-symbol?
univ-emit-this
univ-emit-type
univ-emit-u16vector-box
univ-emit-u16vector-length
univ-emit-u16vector-ref
univ-emit-u16vector-set!
univ-emit-u16vector-shrink!
univ-emit-u16vector?
univ-emit-u32-box
univ-emit-u32-unbox
univ-emit-u32vector-box
univ-emit-u32vector-length
univ-emit-u32vector-ref
univ-emit-u32vector-set!
univ-emit-u32vector-shrink!
univ-emit-u32vector?
univ-emit-u64-box
univ-emit-u64-unbox
univ-emit-u64vector-box
univ-emit-u64vector-length
univ-emit-u64vector-ref
univ-emit-u64vector-set!
univ-emit-u64vector-shrink!
univ-emit-u64vector?
univ-emit-u8vector-box
univ-emit-u8vector-length
univ-emit-u8vector-ref
univ-emit-u8vector-set!
univ-emit-u8vector-shrink!
univ-emit-u8vector?
univ-emit-unbound1
univ-emit-unbound2
univ-emit-unbound?
univ-emit-unbox
univ-emit-unused
univ-emit-values-box
univ-emit-values-length
univ-emit-values-ref
univ-emit-values-set!
univ-emit-values?
univ-emit-vect-box
univ-emit-vect-unbox
univ-emit-vect?
univ-emit-vector-box
univ-emit-vector-length
univ-emit-vector-ref
univ-emit-vector-set!
univ-emit-vector-shrink!
univ-emit-vector?
univ-emit-vector?-inline
univ-emit-void
univ-emit-void-obj
univ-emit-void-obj?
univ-emit-void?
univ-emit-will?
univ-field-param
univ-floats-have-same-sign?
univ-fold-left
univ-fold-left-compare
univ-fxmodulo
univ-fxquotient
univ-fxremainder
univ-get-ctrlpt-attrib
univ-ident-when-special-float
univ-jump-method-name
univ-jumpable-declaration-defs
univ-make-empty-defs
univ-rts-type-alias
univ-set-ctrlpt-attrib
univ-throw
univ-use-ctrlpt-init?
univ-with-ctrlpt-attribs
))

;;-----------------------------------------------------------------------------
;; defined in "_t-univ-4.scm"

(namespace ("c#"
univ-ctrlpt-reference
univ-ctrlpt-reference-to-ctrlpt
univ-ctrlpt-reference-type
univ-end-of-cont-marker
univ-method-reference
univ-parent-entry-point-has-null-parent?
univ-prm-name
univ-unstringify-method
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu-abstract-machine.scm"

(namespace ("c#"
am-add
am-allocate-memory
am-check-nargs
am-compare-jump
am-compare-move
am-default-allocate-memory
am-default-check-nargs
am-default-place-extra-data
am-default-poll
am-default-set-nargs
am-div
am-jmp
am-lbl
am-mov
am-mul
am-sub
any-opnds
cond-is-equal
cond-is-signed
condition-equal
condition-greater
condition-lesser
condition-not-equal
cpu-make-info
encode-procs
get-clo-trampoline-size
get-condition
get-free-register
get-fun-fs
get-make-cgc-fun
get-multiple-free-registers
get-primitive-table
get-register
get-word-width
get-word-width-bits
glo-opnd-name
glo-opnd?
int-opnd
int-opnd-negative
int-opnd-value
int-opnd?
invert-condition
lbl-opnd-label
lbl-opnd-offset
lbl-opnd?
load-if-necessary
load-multiple-if-necessary
make-am-data
make-backend
make-instruction-dictionnary
make-obj-opnd
make-routine-dictionnary
make-unique-label
mem-opnd
mem-opnd-base
mem-opnd-offset
mem-opnd-reg-offset
mem-opnd-scale
mem-opnd?
mk-test
obj-opnd-value
obj-opnd?
opnd-type
opnd-with-offset
put-entry-point-label
reg-opnd?
test-condition
test-operand1
test-operand2
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu-primitives.scm"

(namespace ("c#"
**eof-object-primitive
**eof-object?-primitive
**eq?-primitive
**fxzero?-primitive
**identity-primitive
**not-primitive
**null?-primitive
**void-primitive
am-cond-return
am-if-eq
am-return-const
am-return-opnd
const-nargs-prim
foldl-compare-prim
foldl-prim
get-primitive-arity
get-primitive-function
get-primitive-inlinable?
get-primitive-jump-inlinable?
get-primitive-testable?
make-prim-obj
object-read-prim
object-set-prim
then-jump
then-move
then-nothing
then-return
with-result-opnd
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu-object-desc.scm"

(namespace ("c#"
bignum-desc
body-offset
boxvalues-desc
char-desc
continuation-desc
cpxnum-desc
desc-type
desc-type-tag
f32vector-desc
f64vector-desc
flonum-desc
foreign-desc
frame-desc
head-type-tag
head-type-tag-bits
header-offset
imm-desc?
imm-encode
imm-encoder
imm-object?
jazz-desc
keyword-desc
length-mask
meroon-desc
nul-desc
pair-desc
procedure-desc
promise-desc
ratnum-desc
ref-object?
ref-size
ref-subtype
ref-subtype-tag
ref-type-tag
return-desc
s16vector-desc
s32vector-desc
s64vector-desc
s8vector-desc
string-desc
structure-desc
subtype-tag
subtype-tag-bits
subtype-tag-mask
symbol-desc
tru-desc
type-tag
type-tag-bits
type-tag-mask
u16vector-desc
u32vector-desc
u64vector-desc
u8vector-desc
vector-desc
void-desc
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu-utils.scm"

(namespace ("c#"
count
filter ;; TODO: remove since this is also in the "" namespace
flip
in-range?
safe-car
safe-cdr
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu-backend-x86.scm"

(namespace ("c#"
x86-32-target
x86-64-target
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu-backend-arm.scm"

(namespace ("c#"
arm-target
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu-backend-riscv.scm"

(namespace ("c#"
riscv-32-target
riscv-64-target
))

;;-----------------------------------------------------------------------------
;; defined in "_t-cpu.scm"

(namespace ("c#"
cpu-default-nb-arg-regs
cpu-default-nb-gvm-regs
cpu-frame-alignment
cpu-frame-reserve
cpu-make-target
))

;;-----------------------------------------------------------------------------
;; defined in "_t-c-1.scm"

(namespace ("c#"
targ-box-space
targ-c-id-glo
targ-c-id-glo2
targ-c-unsigned-long
targ-cell-set!
targ-closure-space
targ-continuation-space
targ-cpxnum-space
targ-delay-promise-space
targ-flonum-space
targ-frame-alignment
targ-frame-reserve
targ-fp-cache ;; variable
targ-get-prim-info
targ-info-port
targ-jump-info
targ-keyword-space
targ-label-info
targ-lbl-alloc ;; variable
targ-make-cell
targ-max-small-allocation
targ-min-word-size
targ-module-rd-res
targ-module-wr-res
targ-msection-fudge
targ-nb-arg-regs
targ-nb-gvm-regs
targ-pair-space
targ-ratnum-space
targ-s8vector-space
targ-sharing-table
targ-string-space
targ-symbol-space
targ-min-tag-bits
targ-max-tag-bits
targ-track-scheme-option?
targ-unique-name
targ-use-glo
targ-use-obj
targ-use-prc
targ-vector-space
targ-will-space
))

;;-----------------------------------------------------------------------------
;; defined in "_t-c-2.scm"

(namespace ("c#"
targ-lbl-goto?
targ-lbl-num
targ-lbl-val?
targ-make-glbl
targ-res-op
targ-scan-procedure
))

;;-----------------------------------------------------------------------------
;; defined in "_t-c-3.scm"

(namespace ("c#"
targ-align-frame
targ-align-frame-without-reserve
targ-bignum-digits
targ-build-gc-map
targ-build-gc-map-all-live
targ-denominator
targ-f32->bits
targ-f64->hi-lo-bits
targ-finite?
targ-fixnum32?
targ-fixnum64?
targ-flonum?
targ-gc-map-chunks
targ-hash
targ-iflonum?
targ-imag-part
targ-inexact-+0
targ-inexact-+1
targ-inexact-+1/2
targ-inexact-+2
targ-inexact--1
targ-integer?
targ-max-adigit-width
targ-min-adigit-width
targ-nonzero-fixnum32?
targ-nonzero-flonum?
targ-nonzero-integer?
targ-nonzero-number?
targ-number?
targ-numerator
targ-obj-subtype
targ-obj-subtype-integer
targ-obj-type
targ-out-of-line-frame?
targ-real-part
targ-s32->hex-string
targ-s64->hi-lo-bits
targ-u32-to-s32
targ-u64->hi-lo-bits
targ-unusual-float?
))

;;-----------------------------------------------------------------------------
;; defined in "_gsclib.scm"

(namespace ("c#"
make-global-environment
))

;;;============================================================================
