# V3CollectionsListEventsRequest


## Fields

| Field                                                                                                                                                                                                          | Type                                                                                                                                                                                                           | Required                                                                                                                                                                                                       | Description                                                                                                                                                                                                    | Example                                                                                                                                                                                                        |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `OrganizationID`                                                                                                                                                                                               | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information.             |                                                                                                                                                                                                                |
| `CollectionUID`                                                                                                                                                                                                | *string*                                                                                                                                                                                                       | :heavy_check_mark:                                                                                                                                                                                             | The UID for the collection. Obtain the collection ID using the [list collections endpoint](https://docs.censys.com/reference/v3-collections-crud-list#/) or via the collection URL when using the web console. | 11111111-2222-3333-4444-555555555555                                                                                                                                                                           |
| `PageSize`                                                                                                                                                                                                     | **int*                                                                                                                                                                                                         | :heavy_minus_sign:                                                                                                                                                                                             | Amount of results to return per page.                                                                                                                                                                          | 1                                                                                                                                                                                                              |
| `PageToken`                                                                                                                                                                                                    | **string*                                                                                                                                                                                                      | :heavy_minus_sign:                                                                                                                                                                                             | Page token for the requested page of collection results.                                                                                                                                                       |                                                                                                                                                                                                                |
| `ChangeTypes`                                                                                                                                                                                                  | [][operations.ChangeTypes](../../models/operations/changetypes.md)                                                                                                                                             | :heavy_minus_sign:                                                                                                                                                                                             | Change types                                                                                                                                                                                                   |                                                                                                                                                                                                                |
| `AssetChangeTypes`                                                                                                                                                                                             | [][operations.AssetChangeTypes](../../models/operations/assetchangetypes.md)                                                                                                                                   | :heavy_minus_sign:                                                                                                                                                                                             | Asset change types                                                                                                                                                                                             |                                                                                                                                                                                                                |
| `StatusChangeTypes`                                                                                                                                                                                            | [][operations.StatusChangeTypes](../../models/operations/statuschangetypes.md)                                                                                                                                 | :heavy_minus_sign:                                                                                                                                                                                             | Status change types                                                                                                                                                                                            |                                                                                                                                                                                                                |
| `StartTime`                                                                                                                                                                                                    | [*time.Time](https://pkg.go.dev/time#Time)                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                             | Start time of the host timeline                                                                                                                                                                                | 2025-01-01T00:00:00Z                                                                                                                                                                                           |
| `EndTime`                                                                                                                                                                                                      | [*time.Time](https://pkg.go.dev/time#Time)                                                                                                                                                                     | :heavy_minus_sign:                                                                                                                                                                                             | End time of the host timeline                                                                                                                                                                                  | 2025-01-02T00:00:00Z                                                                                                                                                                                           |