// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

type HTTP struct {
	// The body of the HTTP response. For hosts without a name, the first 64KB are available. For hosts with a name, only 6KB are available.
	Body           *string `json:"body,omitempty"`
	BodyHashSha1   *string `json:"body_hash_sha1,omitempty"`
	BodyHashSha256 *string `json:"body_hash_sha256,omitempty"`
	BodyHashTlsh   *string `json:"body_hash_tlsh,omitempty"`
	// The length, in bytes, of services.http.response.body; at most, 64KB.
	BodySize *int          `json:"body_size,omitempty"`
	Favicons []HTTPFavicon `json:"favicons,omitempty"`
	// The key-value header pairs included in the response.
	Headers map[string]HTTPRepeatedHeaders `json:"headers,omitempty"`
	// A list of the <title> and <meta> tags from services.http.response.body.
	HTMLTags []string `json:"html_tags,omitempty"`
	// The title of the HTML page: the inner contents of the <title> tag in the response body, if present.
	HTMLTitle *string `json:"html_title,omitempty"`
	// The protocol field of the response, which includes the claimed HTTP version number.
	Protocol *string `json:"protocol,omitempty"`
	// A 3-digit integer result code indicating the result of the services.http.request.
	StatusCode *int `json:"status_code,omitempty"`
	// A human-readable phrase describing the status code.
	StatusReason      *string  `json:"status_reason,omitempty"`
	SupportedVersions []string `json:"supported_versions,omitempty"`
	// The full path used to make the request, which includes the scheme, host, port (when non-standard), and endpoint.
	URI *string `json:"uri,omitempty"`
}

func (o *HTTP) GetBody() *string {
	if o == nil {
		return nil
	}
	return o.Body
}

func (o *HTTP) GetBodyHashSha1() *string {
	if o == nil {
		return nil
	}
	return o.BodyHashSha1
}

func (o *HTTP) GetBodyHashSha256() *string {
	if o == nil {
		return nil
	}
	return o.BodyHashSha256
}

func (o *HTTP) GetBodyHashTlsh() *string {
	if o == nil {
		return nil
	}
	return o.BodyHashTlsh
}

func (o *HTTP) GetBodySize() *int {
	if o == nil {
		return nil
	}
	return o.BodySize
}

func (o *HTTP) GetFavicons() []HTTPFavicon {
	if o == nil {
		return nil
	}
	return o.Favicons
}

func (o *HTTP) GetHeaders() map[string]HTTPRepeatedHeaders {
	if o == nil {
		return nil
	}
	return o.Headers
}

func (o *HTTP) GetHTMLTags() []string {
	if o == nil {
		return nil
	}
	return o.HTMLTags
}

func (o *HTTP) GetHTMLTitle() *string {
	if o == nil {
		return nil
	}
	return o.HTMLTitle
}

func (o *HTTP) GetProtocol() *string {
	if o == nil {
		return nil
	}
	return o.Protocol
}

func (o *HTTP) GetStatusCode() *int {
	if o == nil {
		return nil
	}
	return o.StatusCode
}

func (o *HTTP) GetStatusReason() *string {
	if o == nil {
		return nil
	}
	return o.StatusReason
}

func (o *HTTP) GetSupportedVersions() []string {
	if o == nil {
		return nil
	}
	return o.SupportedVersions
}

func (o *HTTP) GetURI() *string {
	if o == nil {
		return nil
	}
	return o.URI
}
