// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/censys/censys-sdk-go/models/components"
)

type V3CollectionsSearchAggregateGlobals struct {
	OrganizationID *string `queryParam:"style=form,explode=true,name=organization_id"`
}

func (o *V3CollectionsSearchAggregateGlobals) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

type V3CollectionsSearchAggregateRequest struct {
	// The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information.
	OrganizationID *string `queryParam:"style=form,explode=false,name=organization_id"`
	// The UID for the collection. Obtain the collection ID using the [list collections endpoint](https://docs.censys.com/reference/v3-collections-crud-list#/) or via the collection URL when using the web console.
	CollectionUID            string                              `pathParam:"style=simple,explode=false,name=collection_uid"`
	SearchAggregateInputBody components.SearchAggregateInputBody `request:"mediaType=application/json"`
}

func (o *V3CollectionsSearchAggregateRequest) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

func (o *V3CollectionsSearchAggregateRequest) GetCollectionUID() string {
	if o == nil {
		return ""
	}
	return o.CollectionUID
}

func (o *V3CollectionsSearchAggregateRequest) GetSearchAggregateInputBody() components.SearchAggregateInputBody {
	if o == nil {
		return components.SearchAggregateInputBody{}
	}
	return o.SearchAggregateInputBody
}

type V3CollectionsSearchAggregateResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	ResponseEnvelopeSearchAggregateResponse *components.ResponseEnvelopeSearchAggregateResponse
	Headers                                 map[string][]string
}

func (o *V3CollectionsSearchAggregateResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V3CollectionsSearchAggregateResponse) GetResponseEnvelopeSearchAggregateResponse() *components.ResponseEnvelopeSearchAggregateResponse {
	if o == nil {
		return nil
	}
	return o.ResponseEnvelopeSearchAggregateResponse
}

func (o *V3CollectionsSearchAggregateResponse) GetHeaders() map[string][]string {
	if o == nil {
		return map[string][]string{}
	}
	return o.Headers
}
