const { SidebarTitle } = require("../components/SidebarTitle");

module.exports = {
  docsSidebar: [
    SidebarTitle("Core Documentation", { space: false }),
    ,
    "index",
    { type: "autogenerated", dirName: "philosophy" },
    "policy-language",
    {
      type: "category",
      label: "Policy Reference",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "policy-reference" },
      ],
    },

    "policy-testing",
    "policy-performance",
    { type: "autogenerated", dirName: "external-data" },
    SidebarTitle("Use Cases"),
    {
      type: "category",
      label: "Data Filtering",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "filtering" },
      ],
    },
    {
      type: "category",
      label: "Envoy & Istio",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "envoy" },
      ],
    },
    {
      type: "category",
      label: "Kubernetes",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "kubernetes" },
      ],
    },
    "cicd",
    "aws-cloudformation-hooks",
    "docker-authorization",
    "http-api-authorization",
    "graphql-api-authorization",
    "kafka-authorization",
    "ssh-and-sudo-authorization",
    "terraform",
    SidebarTitle("Operations"),
    "cli",
    {
      type: "category",
      label: "Management APIs",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "management-introduction" },
        { type: "autogenerated", dirName: "management-bundles" },
        "management-decision-logs",
        "management-status",
        "management-discovery",
      ],
    },
    {
      type: "category",
      label: "Operations & Configuration",
      collapsible: true,
      collapsed: true,
      items: [
        "operations",
        "configuration",
        {
          type: "category",
          label: "Deployment",
          collapsible: true,
          collapsed: true,
          items: [
            { type: "autogenerated", dirName: "deploy" },
          ],
        },
        "monitoring",
        "security",
        "privacy",
        "storage",
      ],
    },
    {
      type: "category",
      label: "Control Plane (OCP)",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "ocp" },
      ],
    },
    SidebarTitle("Developers"),
    {
      type: "category",
      label: "Policy Authoring",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "debugging" },
        "editor-and-ide-support",
        "oauth-oidc",
        "cheatsheet",
        "style-guide",
      ],
    },
    {
      type: "category",
      label: "Errors Guide",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "errors" },
      ],
    },
    {
      type: "category",
      label: "Integration",
      collapsible: true,
      collapsed: true,
      items: [
        "integration",
        "extensions",
        "rest-api",
        {
          type: "category",
          label: "Alternative Runtimes",
          collapsible: true,
          collapsed: true,
          items: [
            "ir",
            "wasm",
          ],
        },
      ],
    },
    {
      type: "category",
      label: "Backwards Compatibility",
      collapsible: true,
      collapsed: true,
      items: [
        "v0-compatibility",
        { type: "autogenerated", dirName: "v0-upgrade" },
      ],
    },
    SidebarTitle("FAQ"),
    "faq",
    {
      type: "category",
      label: "Comparisons",
      collapsible: true,
      collapsed: true,
      items: [
        { type: "autogenerated", dirName: "comparisons" },
      ],
    },
    SidebarTitle("Contributing"),
    "contributing",
    {
      type: "category",
      label: "Guides",
      collapsible: true,
      collapsed: true,
      items: [
        "contrib-code",
        "contrib-docs",
        "contrib-adding-builtin-functions",
      ],
    },
    "contrib-development",
    SidebarTitle("Support"),
    {
      type: "link",
      label: "Community Support",
      href: "/community",
    },
    {
      type: "link",
      label: "Enterprise Support",
      href: "/support",
    },
  ],
  rootSidebar: [],
};
