// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Science API
//
// Use the Data Science API to organize your data science work, access data and computing resources, and build, train, deploy and manage models and model deployments. For more information, see Data Science (https://docs.oracle.com/iaas/data-science/using/data-science.htm).
//

package datascience

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// PipelineDefaultStepParameterDetails Pipeline Default step parameter details
type PipelineDefaultStepParameterDetails struct {
	Output PipelineStepOutputParameterDetails `mandatory:"true" json:"output"`
}

func (m PipelineDefaultStepParameterDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m PipelineDefaultStepParameterDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m PipelineDefaultStepParameterDetails) MarshalJSON() (buff []byte, e error) {
	type MarshalTypePipelineDefaultStepParameterDetails PipelineDefaultStepParameterDetails
	s := struct {
		DiscriminatorParam string `json:"parameterType"`
		MarshalTypePipelineDefaultStepParameterDetails
	}{
		"DEFAULT",
		(MarshalTypePipelineDefaultStepParameterDetails)(m),
	}

	return json.Marshal(&s)
}

// UnmarshalJSON unmarshals from json
func (m *PipelineDefaultStepParameterDetails) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		Output pipelinestepoutputparameterdetails `json:"output"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	nn, e = model.Output.UnmarshalPolymorphicJSON(model.Output.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.Output = nn.(PipelineStepOutputParameterDetails)
	} else {
		m.Output = nil
	}

	return
}
