// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Dblm API
//
// A description of the Dblm API
//

package dblm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// VulnerabilityScanSummary Summary information about a VulnerabilityScan.
type VulnerabilityScanSummary struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VulnerabilityScan.
	Id *string `mandatory:"true" json:"id"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// Vulnerability Scan Type.
	VulnerabilityScanType VulnerabilityScanVulnerabilityScanTypeEnum `mandatory:"true" json:"vulnerabilityScanType"`

	// The status of the scan.
	VulnerabilityScanStatus VulnerabilityScanVulnerabilityScanStatusEnum `mandatory:"true" json:"vulnerabilityScanStatus"`

	// The message of the scan status.
	VulnerabilityScanMessage *string `mandatory:"true" json:"vulnerabilityScanMessage"`

	// The date and time the VulnerabilityScan was created, in the format defined by RFC 3339 (https://tools.ietf.org/html/rfc3339).
	// Example: `2016-08-25T21:10:29.600Z`
	TimeCreated *common.SDKTime `mandatory:"true" json:"timeCreated"`

	// The date and time the VulnerabilityScan was updated, in the format defined by RFC 3339 (https://tools.ietf.org/html/rfc3339).
	// Example: `2016-08-25T21:10:29.600Z`
	TimeEnded *common.SDKTime `mandatory:"true" json:"timeEnded"`

	// A user-friendly name. Does not have to be unique, and it's changeable.
	DisplayName *string `mandatory:"false" json:"displayName"`

	// The current state of the PatchOperation.
	LifecycleState VulnerabilityScanLifecycleStateEnum `mandatory:"false" json:"lifecycleState,omitempty"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// System tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m VulnerabilityScanSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m VulnerabilityScanSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingVulnerabilityScanVulnerabilityScanTypeEnum(string(m.VulnerabilityScanType)); !ok && m.VulnerabilityScanType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityScanType: %s. Supported values are: %s.", m.VulnerabilityScanType, strings.Join(GetVulnerabilityScanVulnerabilityScanTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingVulnerabilityScanVulnerabilityScanStatusEnum(string(m.VulnerabilityScanStatus)); !ok && m.VulnerabilityScanStatus != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityScanStatus: %s. Supported values are: %s.", m.VulnerabilityScanStatus, strings.Join(GetVulnerabilityScanVulnerabilityScanStatusEnumStringValues(), ",")))
	}

	if _, ok := GetMappingVulnerabilityScanLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetVulnerabilityScanLifecycleStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
