// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Java Management Service Fleets API
//
// The APIs for the Fleet Management (https://docs.oracle.com/en-us/iaas/jms/doc/fleet-management.html) feature of Java Management Service to monitor and manage the usage of Java in your enterprise. Use these APIs to manage fleets, configure managed instances to report to fleets, and gain insights into the Java workloads running on these instances by carrying out basic and advanced features.
//

package jms

import (
	"strings"
)

// PackageSortByEnum Enum with underlying type: string
type PackageSortByEnum string

// Set of constants representing the allowable values for PackageSortByEnum
const (
	PackageSortByPackageName             PackageSortByEnum = "packageName"
	PackageSortByManagedInstanceCount    PackageSortByEnum = "managedInstanceCount"
	PackageSortByApplicationCount        PackageSortByEnum = "applicationCount"
	PackageSortByLastDetectedDynamically PackageSortByEnum = "lastDetectedDynamically"
)

var mappingPackageSortByEnum = map[string]PackageSortByEnum{
	"packageName":             PackageSortByPackageName,
	"managedInstanceCount":    PackageSortByManagedInstanceCount,
	"applicationCount":        PackageSortByApplicationCount,
	"lastDetectedDynamically": PackageSortByLastDetectedDynamically,
}

var mappingPackageSortByEnumLowerCase = map[string]PackageSortByEnum{
	"packagename":             PackageSortByPackageName,
	"managedinstancecount":    PackageSortByManagedInstanceCount,
	"applicationcount":        PackageSortByApplicationCount,
	"lastdetecteddynamically": PackageSortByLastDetectedDynamically,
}

// GetPackageSortByEnumValues Enumerates the set of values for PackageSortByEnum
func GetPackageSortByEnumValues() []PackageSortByEnum {
	values := make([]PackageSortByEnum, 0)
	for _, v := range mappingPackageSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetPackageSortByEnumStringValues Enumerates the set of values in String for PackageSortByEnum
func GetPackageSortByEnumStringValues() []string {
	return []string{
		"packageName",
		"managedInstanceCount",
		"applicationCount",
		"lastDetectedDynamically",
	}
}

// GetMappingPackageSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingPackageSortByEnum(val string) (PackageSortByEnum, bool) {
	enum, ok := mappingPackageSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
