package Pkg is
   procedure P is null;
   --  This test checks that no style warnings are issued when compiling
   --  instrumented sources.
   --  As a reminder, each instrumented unit has an associated buffer
   --  unit (defining the buffers and exporting them as symbols), and a
   --  pure buffer unit (defining pointers to coverage buffers and
   --  importing the definition symbols). The pure buffer unit is imported
   --  into the instrumented unit and the buffers declared in this unit are
   --  used for coverage analysis. These generated buffer units do not
   --  respect any style conventions, just like instrumented files.
   --
   --  Sometimes, gnatcov also needs to generate additional code, to
   --  support specific language constructions, such as null procedures.
   --  In this case, additional code will be generated in the pure buffer
   --  unit body (otherwise, there will be no body for this unit, only a
   --  spec, as no actual code is required), as it is the unit imported by
   --  the instrumented file.
   --  As this testcase should exercise all different kinds of files
   --  generated by gnatcov (instrumented files, buffers spec / body),
   --  it also exercises this corner case. This explains the null procedure
   --  here.
end Pkg;
