---
title: FAQ
toc: false
weight: 5
aliases:
  - /welcome/faq/
---

## Which Go versions are supported?

The same as the Go team (the 2 latest minor versions).

Basically, golangci-lint supports Go versions lower or equal to the Go version used to compile it.

New versions of Go are not automatically supported because, in addition of the Go version used to build it,
some linters and/or internal pieces of golangci-lint could need to be adapted to support this new Go version.

## How to use golangci-lint in CI

Run golangci-lint in CI and check the exit code. If it's non-zero - fail the build.

See [how to properly install golangci-lint in CI](/docs/welcome/install/ci)

## golangci-lint doesn't work

1. Please ensure you are using the latest binary release.
2. Run it with `-v` option and check the output.
3. If it doesn't help, create a [GitHub issue](https://github.com/golangci/golangci-lint/issues/new/choose) with the output from the error and #2 above.

## Why do you have `typecheck` errors?

`typecheck` is like a front-end for the Go compiler errors.
Compilation errors are identified/labeled as reports of `typecheck` but they are not produced by a linter called `typecheck`.

`typecheck` is not a linter, it doesn't perform any analysis,
it's just a way to identify, parse, and display compiling errors (produced by the `types.Checker`) and some linter errors.

It cannot be disabled because of that.

Of course, this is just as good as the compiler itself, and a lot of compilation issues will not properly show where in the code your error lies.

As a consequence, the code to analyze should compile.
It means that if you try to run an analysis on a single file or a group of files or a package or a group of packages,
with dependencies on other files or packages of your project, as it doesn't compile (because of the missing pieces of code),
it also cannot be analyzed.

If there are `typecheck` errors, golangci-lint will not be able to produce other reports because that kind of error doesn't allow it to perform any analysis.

How to troubleshoot:

1. Ensure the version of golangci-lint is built with a compatible version of Go (`golangci-lint version`).
2. Ensure dependencies are up to date with `go mod tidy`.
3. Ensure building works with `go run ./...`/`go build ./...` - whole package.
4. Ensure you are not running an analysis on code that depends on files/packages outside the scope of the analyzed elements.
5. If using CGO, ensure all required system libraries are installed.
6. If you are using private repositories/dependencies, ensure the [Go proxy](https://go.dev/ref/mod#module-proxy) (`GOPROXY`) and [checksum database](https://go.dev/ref/mod#checksum-database) (`GOSUMDB`) are right and/or your git configuration.

## Why is it not possible to skip/ignore `typecheck` errors?

For mainly the same reasons that you cannot compile when you have a compiler error.

`typecheck` errors are reported in the same style as linter reports/issues,
but are completely different because they are related to problems that block the analysis (`typecheck` is not a linter).

When there are `typecheck` errors,
most linters are not able to perform the analysis,
and they simply do not produce any reports,
so it's not possible to skip/ignore `typecheck` errors.

## Why running with `--fast-only` can be slow on the first run?

Because the first run caches type information.
All subsequent runs will be faster.
Usually this option is used during development on a local machine and compilation was already performed.

## How do you add a custom linter?

You can integrate it yourself, see this [manual](/docs/contributing/new-linters/).
Or you can create a [GitHub Issue](https://github.com/golangci/golangci-lint/issues/new?assignees=&labels=enhancement&projects=&template=feature_request.yml) and we will integrate when time permits.

## How to integrate golangci-lint into a large project with thousands of issues

We are sure that every project can easily integrate golangci-lint, even the large one.

The idea is to not fix all existing issues.
Fix only newly added issue: issues in new code.

To do this, set up the CI to run golangci-lint with options `--new-from-merge-base=main` or `--new-from-rev=HEAD~1`.

Also, take a look at option `--new`,
but consider that CI scripts that generate unstaged files will make `--new` only point out issues in those files and not in the last commit.
In that regard `--new-from-merge-base=main` or `--new-from-rev=HEAD~1` are safer.

By doing this you won't create new issues in your code and can choose fix existing issues (or not).

## Why `--new-from-xxx` don't seem to be working in some cases?

The options `--new-from-merge-base`, `--new-from-rev`, and `--new-from-patch` work by comparing `git diff` output and issues.

If an issue is not reported as the same line as the changes then the issue will be skipped.
This is the line of the issue is not inside the lines changed.

To fix that, you have to use the option `--whole-files`.

The side effect is the issues inside the file that contain changes but not directly related to the changes themselves will be reported.
