--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

with Ada.Containers.Vectors;
with Ada.Exceptions;
with Ada.Unchecked_Conversion;
with Ada.Unchecked_Deallocation;

with System;

with Langkit_Support.Bump_Ptr;    use Langkit_Support.Bump_Ptr;
with Langkit_Support.Diagnostics; use Langkit_Support.Diagnostics;
with Langkit_Support.Packrat;
with Langkit_Support.Slocs;       use Langkit_Support.Slocs;

pragma Warnings (Off, "referenced");
with Langkit_Support.Symbols; use Langkit_Support.Symbols;
pragma Warnings (On, "referenced");

with Langkit_Support.Text;        use Langkit_Support.Text;

with Libadalang.Common;         use Libadalang.Common;
with Libadalang.Implementation; use Libadalang.Implementation;
use Libadalang.Implementation.Precomputed_Symbols;

pragma Warnings (Off, "referenced");
with Libadalang.Private_Converters; use Libadalang.Private_Converters;
pragma Warnings (On, "referenced");




package body Libadalang.Parsers_Impl is
   pragma Warnings (Off, "use clause");
   use all type Langkit_Support.Symbols.Symbol_Type;
   pragma Warnings (On, "use clause");

   --  Prepare packrat instantiations: one per enum type and onefor each kind
   --  of node (including lists). Likewise for bump ptr. allocators, except
   --  we need them only for non-abstract AST nodes.

   pragma Warnings (Off, "is not referenced");
      package Bare_Ada_Node_Memos is new Langkit_Support.Packrat
        (Bare_Ada_Node, Token_Index);

      package Bare_Abort_Node_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Node, Token_Index);

      package Bare_Abort_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Absent, Token_Index);

         
         subtype Subtype_For_Abort_Absent is
            Root_Node_Record (Ada_Abort_Absent);
         type Access_To_Subtype_For_Abort_Absent is access all Subtype_For_Abort_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abort_Absent);
         package Bare_Abort_Absent_Alloc is new Alloc
           (Subtype_For_Abort_Absent, Access_To_Subtype_For_Abort_Absent);

         function Allocate_Abort_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Absent;

         function Allocate_Abort_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Absent
         is
            Result      : constant Access_To_Subtype_For_Abort_Absent := Bare_Abort_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abort_Absent;
            return Bare_Abort_Absent (Result);
         end Allocate_Abort_Absent;

      package Bare_Abort_Present_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Present, Token_Index);

         
         subtype Subtype_For_Abort_Present is
            Root_Node_Record (Ada_Abort_Present);
         type Access_To_Subtype_For_Abort_Present is access all Subtype_For_Abort_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abort_Present);
         package Bare_Abort_Present_Alloc is new Alloc
           (Subtype_For_Abort_Present, Access_To_Subtype_For_Abort_Present);

         function Allocate_Abort_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Present;

         function Allocate_Abort_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Present
         is
            Result      : constant Access_To_Subtype_For_Abort_Present := Bare_Abort_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abort_Present;
            return Bare_Abort_Present (Result);
         end Allocate_Abort_Present;

      package Bare_Abstract_Node_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Node, Token_Index);

      package Bare_Abstract_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Absent, Token_Index);

         
         subtype Subtype_For_Abstract_Absent is
            Root_Node_Record (Ada_Abstract_Absent);
         type Access_To_Subtype_For_Abstract_Absent is access all Subtype_For_Abstract_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abstract_Absent);
         package Bare_Abstract_Absent_Alloc is new Alloc
           (Subtype_For_Abstract_Absent, Access_To_Subtype_For_Abstract_Absent);

         function Allocate_Abstract_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Absent;

         function Allocate_Abstract_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Absent
         is
            Result      : constant Access_To_Subtype_For_Abstract_Absent := Bare_Abstract_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Absent;
            return Bare_Abstract_Absent (Result);
         end Allocate_Abstract_Absent;

      package Bare_Abstract_Present_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Present, Token_Index);

         
         subtype Subtype_For_Abstract_Present is
            Root_Node_Record (Ada_Abstract_Present);
         type Access_To_Subtype_For_Abstract_Present is access all Subtype_For_Abstract_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abstract_Present);
         package Bare_Abstract_Present_Alloc is new Alloc
           (Subtype_For_Abstract_Present, Access_To_Subtype_For_Abstract_Present);

         function Allocate_Abstract_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Present;

         function Allocate_Abstract_Present
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Present
         is
            Result      : constant Access_To_Subtype_For_Abstract_Present := Bare_Abstract_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Present;
            return Bare_Abstract_Present (Result);
         end Allocate_Abstract_Present;

      package Bare_Ada_List_Memos is new Langkit_Support.Packrat
        (Bare_Ada_List, Token_Index);

      package Bare_Ada_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_Ada_Node_List, Token_Index);

         
         subtype Subtype_For_Ada_Node_List is
            Root_Node_Record (Ada_Ada_Node_List);
         type Access_To_Subtype_For_Ada_Node_List is access all Subtype_For_Ada_Node_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Ada_Node_List);
         package Bare_Ada_Node_List_Alloc is new Alloc
           (Subtype_For_Ada_Node_List, Access_To_Subtype_For_Ada_Node_List);

         function Allocate_Ada_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Ada_Node_List;

         function Allocate_Ada_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Ada_Node_List
         is
            Result      : constant Access_To_Subtype_For_Ada_Node_List := Bare_Ada_Node_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Ada_Node_List;
            return Bare_Ada_Node_List (Result);
         end Allocate_Ada_Node_List;

      package Bare_Abstract_State_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_State_Decl_List, Token_Index);

         
         subtype Subtype_For_Abstract_State_Decl_List is
            Root_Node_Record (Ada_Abstract_State_Decl_List);
         type Access_To_Subtype_For_Abstract_State_Decl_List is access all Subtype_For_Abstract_State_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abstract_State_Decl_List);
         package Bare_Abstract_State_Decl_List_Alloc is new Alloc
           (Subtype_For_Abstract_State_Decl_List, Access_To_Subtype_For_Abstract_State_Decl_List);

         function Allocate_Abstract_State_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_State_Decl_List;

         function Allocate_Abstract_State_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_State_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Abstract_State_Decl_List := Bare_Abstract_State_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_State_Decl_List;
            return Bare_Abstract_State_Decl_List (Result);
         end Allocate_Abstract_State_Decl_List;

      package Bare_Alternatives_List_Memos is new Langkit_Support.Packrat
        (Bare_Alternatives_List, Token_Index);

         
         subtype Subtype_For_Alternatives_List is
            Root_Node_Record (Ada_Alternatives_List);
         type Access_To_Subtype_For_Alternatives_List is access all Subtype_For_Alternatives_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Alternatives_List);
         package Bare_Alternatives_List_Alloc is new Alloc
           (Subtype_For_Alternatives_List, Access_To_Subtype_For_Alternatives_List);

         function Allocate_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Alternatives_List;

         function Allocate_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Alternatives_List
         is
            Result      : constant Access_To_Subtype_For_Alternatives_List := Bare_Alternatives_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Alternatives_List;
            return Bare_Alternatives_List (Result);
         end Allocate_Alternatives_List;

      package Bare_Constraint_List_Memos is new Langkit_Support.Packrat
        (Bare_Constraint_List, Token_Index);

         
         subtype Subtype_For_Constraint_List is
            Root_Node_Record (Ada_Constraint_List);
         type Access_To_Subtype_For_Constraint_List is access all Subtype_For_Constraint_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Constraint_List);
         package Bare_Constraint_List_Alloc is new Alloc
           (Subtype_For_Constraint_List, Access_To_Subtype_For_Constraint_List);

         function Allocate_Constraint_List
           (Pool : Bump_Ptr_Pool) return Bare_Constraint_List;

         function Allocate_Constraint_List
           (Pool : Bump_Ptr_Pool) return Bare_Constraint_List
         is
            Result      : constant Access_To_Subtype_For_Constraint_List := Bare_Constraint_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constraint_List;
            return Bare_Constraint_List (Result);
         end Allocate_Constraint_List;

      package Bare_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Decl_List, Token_Index);

         
         subtype Subtype_For_Decl_List is
            Root_Node_Record (Ada_Decl_List);
         type Access_To_Subtype_For_Decl_List is access all Subtype_For_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decl_List);
         package Bare_Decl_List_Alloc is new Alloc
           (Subtype_For_Decl_List, Access_To_Subtype_For_Decl_List);

         function Allocate_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Decl_List;

         function Allocate_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Decl_List := Bare_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decl_List;
            return Bare_Decl_List (Result);
         end Allocate_Decl_List;

      package Bare_Stmt_List_Memos is new Langkit_Support.Packrat
        (Bare_Stmt_List, Token_Index);

         
         subtype Subtype_For_Stmt_List is
            Root_Node_Record (Ada_Stmt_List);
         type Access_To_Subtype_For_Stmt_List is access all Subtype_For_Stmt_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Stmt_List);
         package Bare_Stmt_List_Alloc is new Alloc
           (Subtype_For_Stmt_List, Access_To_Subtype_For_Stmt_List);

         function Allocate_Stmt_List
           (Pool : Bump_Ptr_Pool) return Bare_Stmt_List;

         function Allocate_Stmt_List
           (Pool : Bump_Ptr_Pool) return Bare_Stmt_List
         is
            Result      : constant Access_To_Subtype_For_Stmt_List := Bare_Stmt_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Stmt_List;
            return Bare_Stmt_List (Result);
         end Allocate_Stmt_List;

      package Bare_Aspect_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Assoc_List, Token_Index);

         
         subtype Subtype_For_Aspect_Assoc_List is
            Root_Node_Record (Ada_Aspect_Assoc_List);
         type Access_To_Subtype_For_Aspect_Assoc_List is access all Subtype_For_Aspect_Assoc_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aspect_Assoc_List);
         package Bare_Aspect_Assoc_List_Alloc is new Alloc
           (Subtype_For_Aspect_Assoc_List, Access_To_Subtype_For_Aspect_Assoc_List);

         function Allocate_Aspect_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc_List;

         function Allocate_Aspect_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Aspect_Assoc_List := Bare_Aspect_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aspect_Assoc_List;
            return Bare_Aspect_Assoc_List (Result);
         end Allocate_Aspect_Assoc_List;

      package Bare_Base_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Base_Assoc_List, Token_Index);

         
         subtype Subtype_For_Base_Assoc_List is
            Root_Node_Record (Ada_Base_Assoc_List);
         type Access_To_Subtype_For_Base_Assoc_List is access all Subtype_For_Base_Assoc_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Base_Assoc_List);
         package Bare_Base_Assoc_List_Alloc is new Alloc
           (Subtype_For_Base_Assoc_List, Access_To_Subtype_For_Base_Assoc_List);

         function Allocate_Base_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Assoc_List;

         function Allocate_Base_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Base_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Base_Assoc_List := Bare_Base_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Base_Assoc_List;
            return Bare_Base_Assoc_List (Result);
         end Allocate_Base_Assoc_List;

      package Bare_Basic_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Assoc_List, Token_Index);

      package Bare_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Assoc_List, Token_Index);

         
         subtype Subtype_For_Assoc_List is
            Root_Node_Record (Ada_Assoc_List);
         type Access_To_Subtype_For_Assoc_List is access all Subtype_For_Assoc_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Assoc_List);
         package Bare_Assoc_List_Alloc is new Alloc
           (Subtype_For_Assoc_List, Access_To_Subtype_For_Assoc_List);

         function Allocate_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Assoc_List;

         function Allocate_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Assoc_List := Bare_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Assoc_List;
            return Bare_Assoc_List (Result);
         end Allocate_Assoc_List;

      package Bare_Case_Expr_Alternative_List_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expr_Alternative_List, Token_Index);

         
         subtype Subtype_For_Case_Expr_Alternative_List is
            Root_Node_Record (Ada_Case_Expr_Alternative_List);
         type Access_To_Subtype_For_Case_Expr_Alternative_List is access all Subtype_For_Case_Expr_Alternative_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Case_Expr_Alternative_List);
         package Bare_Case_Expr_Alternative_List_Alloc is new Alloc
           (Subtype_For_Case_Expr_Alternative_List, Access_To_Subtype_For_Case_Expr_Alternative_List);

         function Allocate_Case_Expr_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative_List;

         function Allocate_Case_Expr_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative_List
         is
            Result      : constant Access_To_Subtype_For_Case_Expr_Alternative_List := Bare_Case_Expr_Alternative_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Expr_Alternative_List;
            return Bare_Case_Expr_Alternative_List (Result);
         end Allocate_Case_Expr_Alternative_List;

      package Bare_Case_Stmt_Alternative_List_Memos is new Langkit_Support.Packrat
        (Bare_Case_Stmt_Alternative_List, Token_Index);

         
         subtype Subtype_For_Case_Stmt_Alternative_List is
            Root_Node_Record (Ada_Case_Stmt_Alternative_List);
         type Access_To_Subtype_For_Case_Stmt_Alternative_List is access all Subtype_For_Case_Stmt_Alternative_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Case_Stmt_Alternative_List);
         package Bare_Case_Stmt_Alternative_List_Alloc is new Alloc
           (Subtype_For_Case_Stmt_Alternative_List, Access_To_Subtype_For_Case_Stmt_Alternative_List);

         function Allocate_Case_Stmt_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative_List;

         function Allocate_Case_Stmt_Alternative_List
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative_List
         is
            Result      : constant Access_To_Subtype_For_Case_Stmt_Alternative_List := Bare_Case_Stmt_Alternative_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Stmt_Alternative_List;
            return Bare_Case_Stmt_Alternative_List (Result);
         end Allocate_Case_Stmt_Alternative_List;

      package Bare_Compilation_Unit_List_Memos is new Langkit_Support.Packrat
        (Bare_Compilation_Unit_List, Token_Index);

         
         subtype Subtype_For_Compilation_Unit_List is
            Root_Node_Record (Ada_Compilation_Unit_List);
         type Access_To_Subtype_For_Compilation_Unit_List is access all Subtype_For_Compilation_Unit_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Compilation_Unit_List);
         package Bare_Compilation_Unit_List_Alloc is new Alloc
           (Subtype_For_Compilation_Unit_List, Access_To_Subtype_For_Compilation_Unit_List);

         function Allocate_Compilation_Unit_List
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit_List;

         function Allocate_Compilation_Unit_List
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit_List
         is
            Result      : constant Access_To_Subtype_For_Compilation_Unit_List := Bare_Compilation_Unit_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Compilation_Unit_List;
            return Bare_Compilation_Unit_List (Result);
         end Allocate_Compilation_Unit_List;

      package Bare_Concat_Operand_List_Memos is new Langkit_Support.Packrat
        (Bare_Concat_Operand_List, Token_Index);

         
         subtype Subtype_For_Concat_Operand_List is
            Root_Node_Record (Ada_Concat_Operand_List);
         type Access_To_Subtype_For_Concat_Operand_List is access all Subtype_For_Concat_Operand_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Concat_Operand_List);
         package Bare_Concat_Operand_List_Alloc is new Alloc
           (Subtype_For_Concat_Operand_List, Access_To_Subtype_For_Concat_Operand_List);

         function Allocate_Concat_Operand_List
           (Pool : Bump_Ptr_Pool) return Bare_Concat_Operand_List;

         function Allocate_Concat_Operand_List
           (Pool : Bump_Ptr_Pool) return Bare_Concat_Operand_List
         is
            Result      : constant Access_To_Subtype_For_Concat_Operand_List := Bare_Concat_Operand_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Concat_Operand_List;
            return Bare_Concat_Operand_List (Result);
         end Allocate_Concat_Operand_List;

      package Bare_Contract_Case_Assoc_List_Memos is new Langkit_Support.Packrat
        (Bare_Contract_Case_Assoc_List, Token_Index);

         
         subtype Subtype_For_Contract_Case_Assoc_List is
            Root_Node_Record (Ada_Contract_Case_Assoc_List);
         type Access_To_Subtype_For_Contract_Case_Assoc_List is access all Subtype_For_Contract_Case_Assoc_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Contract_Case_Assoc_List);
         package Bare_Contract_Case_Assoc_List_Alloc is new Alloc
           (Subtype_For_Contract_Case_Assoc_List, Access_To_Subtype_For_Contract_Case_Assoc_List);

         function Allocate_Contract_Case_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc_List;

         function Allocate_Contract_Case_Assoc_List
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc_List
         is
            Result      : constant Access_To_Subtype_For_Contract_Case_Assoc_List := Bare_Contract_Case_Assoc_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Contract_Case_Assoc_List;
            return Bare_Contract_Case_Assoc_List (Result);
         end Allocate_Contract_Case_Assoc_List;

      package Bare_Defining_Name_List_Memos is new Langkit_Support.Packrat
        (Bare_Defining_Name_List, Token_Index);

         
         subtype Subtype_For_Defining_Name_List is
            Root_Node_Record (Ada_Defining_Name_List);
         type Access_To_Subtype_For_Defining_Name_List is access all Subtype_For_Defining_Name_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Defining_Name_List);
         package Bare_Defining_Name_List_Alloc is new Alloc
           (Subtype_For_Defining_Name_List, Access_To_Subtype_For_Defining_Name_List);

         function Allocate_Defining_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name_List;

         function Allocate_Defining_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name_List
         is
            Result      : constant Access_To_Subtype_For_Defining_Name_List := Bare_Defining_Name_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Defining_Name_List;
            return Bare_Defining_Name_List (Result);
         end Allocate_Defining_Name_List;

      package Bare_Discriminant_Spec_List_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Spec_List, Token_Index);

         
         subtype Subtype_For_Discriminant_Spec_List is
            Root_Node_Record (Ada_Discriminant_Spec_List);
         type Access_To_Subtype_For_Discriminant_Spec_List is access all Subtype_For_Discriminant_Spec_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Discriminant_Spec_List);
         package Bare_Discriminant_Spec_List_Alloc is new Alloc
           (Subtype_For_Discriminant_Spec_List, Access_To_Subtype_For_Discriminant_Spec_List);

         function Allocate_Discriminant_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec_List;

         function Allocate_Discriminant_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec_List
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Spec_List := Bare_Discriminant_Spec_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Spec_List;
            return Bare_Discriminant_Spec_List (Result);
         end Allocate_Discriminant_Spec_List;

      package Bare_Elsif_Expr_Part_List_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Expr_Part_List, Token_Index);

         
         subtype Subtype_For_Elsif_Expr_Part_List is
            Root_Node_Record (Ada_Elsif_Expr_Part_List);
         type Access_To_Subtype_For_Elsif_Expr_Part_List is access all Subtype_For_Elsif_Expr_Part_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Elsif_Expr_Part_List);
         package Bare_Elsif_Expr_Part_List_Alloc is new Alloc
           (Subtype_For_Elsif_Expr_Part_List, Access_To_Subtype_For_Elsif_Expr_Part_List);

         function Allocate_Elsif_Expr_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part_List;

         function Allocate_Elsif_Expr_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part_List
         is
            Result      : constant Access_To_Subtype_For_Elsif_Expr_Part_List := Bare_Elsif_Expr_Part_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Expr_Part_List;
            return Bare_Elsif_Expr_Part_List (Result);
         end Allocate_Elsif_Expr_Part_List;

      package Bare_Elsif_Stmt_Part_List_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Stmt_Part_List, Token_Index);

         
         subtype Subtype_For_Elsif_Stmt_Part_List is
            Root_Node_Record (Ada_Elsif_Stmt_Part_List);
         type Access_To_Subtype_For_Elsif_Stmt_Part_List is access all Subtype_For_Elsif_Stmt_Part_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Elsif_Stmt_Part_List);
         package Bare_Elsif_Stmt_Part_List_Alloc is new Alloc
           (Subtype_For_Elsif_Stmt_Part_List, Access_To_Subtype_For_Elsif_Stmt_Part_List);

         function Allocate_Elsif_Stmt_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part_List;

         function Allocate_Elsif_Stmt_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part_List
         is
            Result      : constant Access_To_Subtype_For_Elsif_Stmt_Part_List := Bare_Elsif_Stmt_Part_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Stmt_Part_List;
            return Bare_Elsif_Stmt_Part_List (Result);
         end Allocate_Elsif_Stmt_Part_List;

      package Bare_Enum_Literal_Decl_List_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Literal_Decl_List, Token_Index);

         
         subtype Subtype_For_Enum_Literal_Decl_List is
            Root_Node_Record (Ada_Enum_Literal_Decl_List);
         type Access_To_Subtype_For_Enum_Literal_Decl_List is access all Subtype_For_Enum_Literal_Decl_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Literal_Decl_List);
         package Bare_Enum_Literal_Decl_List_Alloc is new Alloc
           (Subtype_For_Enum_Literal_Decl_List, Access_To_Subtype_For_Enum_Literal_Decl_List);

         function Allocate_Enum_Literal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl_List;

         function Allocate_Enum_Literal_Decl_List
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl_List
         is
            Result      : constant Access_To_Subtype_For_Enum_Literal_Decl_List := Bare_Enum_Literal_Decl_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Literal_Decl_List;
            return Bare_Enum_Literal_Decl_List (Result);
         end Allocate_Enum_Literal_Decl_List;

      package Bare_Expr_List_Memos is new Langkit_Support.Packrat
        (Bare_Expr_List, Token_Index);

      package Bare_Expr_Alternatives_List_Memos is new Langkit_Support.Packrat
        (Bare_Expr_Alternatives_List, Token_Index);

         
         subtype Subtype_For_Expr_Alternatives_List is
            Root_Node_Record (Ada_Expr_Alternatives_List);
         type Access_To_Subtype_For_Expr_Alternatives_List is access all Subtype_For_Expr_Alternatives_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Expr_Alternatives_List);
         package Bare_Expr_Alternatives_List_Alloc is new Alloc
           (Subtype_For_Expr_Alternatives_List, Access_To_Subtype_For_Expr_Alternatives_List);

         function Allocate_Expr_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Alternatives_List;

         function Allocate_Expr_Alternatives_List
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Alternatives_List
         is
            Result      : constant Access_To_Subtype_For_Expr_Alternatives_List := Bare_Expr_Alternatives_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Expr_Alternatives_List;
            return Bare_Expr_Alternatives_List (Result);
         end Allocate_Expr_Alternatives_List;

      package Bare_Format_String_Chunk_List_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Chunk_List, Token_Index);

         
         subtype Subtype_For_Format_String_Chunk_List is
            Root_Node_Record (Ada_Format_String_Chunk_List);
         type Access_To_Subtype_For_Format_String_Chunk_List is access all Subtype_For_Format_String_Chunk_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Format_String_Chunk_List);
         package Bare_Format_String_Chunk_List_Alloc is new Alloc
           (Subtype_For_Format_String_Chunk_List, Access_To_Subtype_For_Format_String_Chunk_List);

         function Allocate_Format_String_Chunk_List
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Chunk_List;

         function Allocate_Format_String_Chunk_List
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Chunk_List
         is
            Result      : constant Access_To_Subtype_For_Format_String_Chunk_List := Bare_Format_String_Chunk_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Format_String_Chunk_List;
            return Bare_Format_String_Chunk_List (Result);
         end Allocate_Format_String_Chunk_List;

      package Bare_Identifier_List_Memos is new Langkit_Support.Packrat
        (Bare_Identifier_List, Token_Index);

      package Bare_Discriminant_Choice_List_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Choice_List, Token_Index);

         
         subtype Subtype_For_Discriminant_Choice_List is
            Root_Node_Record (Ada_Discriminant_Choice_List);
         type Access_To_Subtype_For_Discriminant_Choice_List is access all Subtype_For_Discriminant_Choice_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Discriminant_Choice_List);
         package Bare_Discriminant_Choice_List_Alloc is new Alloc
           (Subtype_For_Discriminant_Choice_List, Access_To_Subtype_For_Discriminant_Choice_List);

         function Allocate_Discriminant_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Choice_List;

         function Allocate_Discriminant_Choice_List
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Choice_List
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Choice_List := Bare_Discriminant_Choice_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Choice_List;
            return Bare_Discriminant_Choice_List (Result);
         end Allocate_Discriminant_Choice_List;

      package Bare_Name_List_Memos is new Langkit_Support.Packrat
        (Bare_Name_List, Token_Index);

         
         subtype Subtype_For_Name_List is
            Root_Node_Record (Ada_Name_List);
         type Access_To_Subtype_For_Name_List is access all Subtype_For_Name_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Name_List);
         package Bare_Name_List_Alloc is new Alloc
           (Subtype_For_Name_List, Access_To_Subtype_For_Name_List);

         function Allocate_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Name_List;

         function Allocate_Name_List
           (Pool : Bump_Ptr_Pool) return Bare_Name_List
         is
            Result      : constant Access_To_Subtype_For_Name_List := Bare_Name_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Name_List;
            return Bare_Name_List (Result);
         end Allocate_Name_List;

      package Bare_Parent_List_Memos is new Langkit_Support.Packrat
        (Bare_Parent_List, Token_Index);

         
         subtype Subtype_For_Parent_List is
            Root_Node_Record (Ada_Parent_List);
         type Access_To_Subtype_For_Parent_List is access all Subtype_For_Parent_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Parent_List);
         package Bare_Parent_List_Alloc is new Alloc
           (Subtype_For_Parent_List, Access_To_Subtype_For_Parent_List);

         function Allocate_Parent_List
           (Pool : Bump_Ptr_Pool) return Bare_Parent_List;

         function Allocate_Parent_List
           (Pool : Bump_Ptr_Pool) return Bare_Parent_List
         is
            Result      : constant Access_To_Subtype_For_Parent_List := Bare_Parent_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Parent_List;
            return Bare_Parent_List (Result);
         end Allocate_Parent_List;

      package Bare_Param_Spec_List_Memos is new Langkit_Support.Packrat
        (Bare_Param_Spec_List, Token_Index);

         
         subtype Subtype_For_Param_Spec_List is
            Root_Node_Record (Ada_Param_Spec_List);
         type Access_To_Subtype_For_Param_Spec_List is access all Subtype_For_Param_Spec_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Param_Spec_List);
         package Bare_Param_Spec_List_Alloc is new Alloc
           (Subtype_For_Param_Spec_List, Access_To_Subtype_For_Param_Spec_List);

         function Allocate_Param_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec_List;

         function Allocate_Param_Spec_List
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec_List
         is
            Result      : constant Access_To_Subtype_For_Param_Spec_List := Bare_Param_Spec_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Param_Spec_List;
            return Bare_Param_Spec_List (Result);
         end Allocate_Param_Spec_List;

      package Bare_Pragma_Node_List_Memos is new Langkit_Support.Packrat
        (Bare_Pragma_Node_List, Token_Index);

         
         subtype Subtype_For_Pragma_Node_List is
            Root_Node_Record (Ada_Pragma_Node_List);
         type Access_To_Subtype_For_Pragma_Node_List is access all Subtype_For_Pragma_Node_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pragma_Node_List);
         package Bare_Pragma_Node_List_Alloc is new Alloc
           (Subtype_For_Pragma_Node_List, Access_To_Subtype_For_Pragma_Node_List);

         function Allocate_Pragma_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node_List;

         function Allocate_Pragma_Node_List
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node_List
         is
            Result      : constant Access_To_Subtype_For_Pragma_Node_List := Bare_Pragma_Node_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pragma_Node_List;
            return Bare_Pragma_Node_List (Result);
         end Allocate_Pragma_Node_List;

      package Bare_Select_When_Part_List_Memos is new Langkit_Support.Packrat
        (Bare_Select_When_Part_List, Token_Index);

         
         subtype Subtype_For_Select_When_Part_List is
            Root_Node_Record (Ada_Select_When_Part_List);
         type Access_To_Subtype_For_Select_When_Part_List is access all Subtype_For_Select_When_Part_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Select_When_Part_List);
         package Bare_Select_When_Part_List_Alloc is new Alloc
           (Subtype_For_Select_When_Part_List, Access_To_Subtype_For_Select_When_Part_List);

         function Allocate_Select_When_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part_List;

         function Allocate_Select_When_Part_List
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part_List
         is
            Result      : constant Access_To_Subtype_For_Select_When_Part_List := Bare_Select_When_Part_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Select_When_Part_List;
            return Bare_Select_When_Part_List (Result);
         end Allocate_Select_When_Part_List;

      package Bare_Unconstrained_Array_Index_List_Memos is new Langkit_Support.Packrat
        (Bare_Unconstrained_Array_Index_List, Token_Index);

         
         subtype Subtype_For_Unconstrained_Array_Index_List is
            Root_Node_Record (Ada_Unconstrained_Array_Index_List);
         type Access_To_Subtype_For_Unconstrained_Array_Index_List is access all Subtype_For_Unconstrained_Array_Index_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Unconstrained_Array_Index_List);
         package Bare_Unconstrained_Array_Index_List_Alloc is new Alloc
           (Subtype_For_Unconstrained_Array_Index_List, Access_To_Subtype_For_Unconstrained_Array_Index_List);

         function Allocate_Unconstrained_Array_Index_List
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index_List;

         function Allocate_Unconstrained_Array_Index_List
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index_List
         is
            Result      : constant Access_To_Subtype_For_Unconstrained_Array_Index_List := Bare_Unconstrained_Array_Index_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unconstrained_Array_Index_List;
            return Bare_Unconstrained_Array_Index_List (Result);
         end Allocate_Unconstrained_Array_Index_List;

      package Bare_Variant_List_Memos is new Langkit_Support.Packrat
        (Bare_Variant_List, Token_Index);

         
         subtype Subtype_For_Variant_List is
            Root_Node_Record (Ada_Variant_List);
         type Access_To_Subtype_For_Variant_List is access all Subtype_For_Variant_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Variant_List);
         package Bare_Variant_List_Alloc is new Alloc
           (Subtype_For_Variant_List, Access_To_Subtype_For_Variant_List);

         function Allocate_Variant_List
           (Pool : Bump_Ptr_Pool) return Bare_Variant_List;

         function Allocate_Variant_List
           (Pool : Bump_Ptr_Pool) return Bare_Variant_List
         is
            Result      : constant Access_To_Subtype_For_Variant_List := Bare_Variant_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Variant_List;
            return Bare_Variant_List (Result);
         end Allocate_Variant_List;

      package Bare_Aliased_Node_Memos is new Langkit_Support.Packrat
        (Bare_Aliased_Node, Token_Index);

      package Bare_Aliased_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Aliased_Absent, Token_Index);

         
         subtype Subtype_For_Aliased_Absent is
            Root_Node_Record (Ada_Aliased_Absent);
         type Access_To_Subtype_For_Aliased_Absent is access all Subtype_For_Aliased_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aliased_Absent);
         package Bare_Aliased_Absent_Alloc is new Alloc
           (Subtype_For_Aliased_Absent, Access_To_Subtype_For_Aliased_Absent);

         function Allocate_Aliased_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Absent;

         function Allocate_Aliased_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Absent
         is
            Result      : constant Access_To_Subtype_For_Aliased_Absent := Bare_Aliased_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aliased_Absent;
            return Bare_Aliased_Absent (Result);
         end Allocate_Aliased_Absent;

      package Bare_Aliased_Present_Memos is new Langkit_Support.Packrat
        (Bare_Aliased_Present, Token_Index);

         
         subtype Subtype_For_Aliased_Present is
            Root_Node_Record (Ada_Aliased_Present);
         type Access_To_Subtype_For_Aliased_Present is access all Subtype_For_Aliased_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aliased_Present);
         package Bare_Aliased_Present_Alloc is new Alloc
           (Subtype_For_Aliased_Present, Access_To_Subtype_For_Aliased_Present);

         function Allocate_Aliased_Present
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Present;

         function Allocate_Aliased_Present
           (Pool : Bump_Ptr_Pool) return Bare_Aliased_Present
         is
            Result      : constant Access_To_Subtype_For_Aliased_Present := Bare_Aliased_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aliased_Present;
            return Bare_Aliased_Present (Result);
         end Allocate_Aliased_Present;

      package Bare_All_Node_Memos is new Langkit_Support.Packrat
        (Bare_All_Node, Token_Index);

      package Bare_All_Absent_Memos is new Langkit_Support.Packrat
        (Bare_All_Absent, Token_Index);

         
         subtype Subtype_For_All_Absent is
            Root_Node_Record (Ada_All_Absent);
         type Access_To_Subtype_For_All_Absent is access all Subtype_For_All_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_All_Absent);
         package Bare_All_Absent_Alloc is new Alloc
           (Subtype_For_All_Absent, Access_To_Subtype_For_All_Absent);

         function Allocate_All_Absent
           (Pool : Bump_Ptr_Pool) return Bare_All_Absent;

         function Allocate_All_Absent
           (Pool : Bump_Ptr_Pool) return Bare_All_Absent
         is
            Result      : constant Access_To_Subtype_For_All_Absent := Bare_All_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_All_Absent;
            return Bare_All_Absent (Result);
         end Allocate_All_Absent;

      package Bare_All_Present_Memos is new Langkit_Support.Packrat
        (Bare_All_Present, Token_Index);

         
         subtype Subtype_For_All_Present is
            Root_Node_Record (Ada_All_Present);
         type Access_To_Subtype_For_All_Present is access all Subtype_For_All_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_All_Present);
         package Bare_All_Present_Alloc is new Alloc
           (Subtype_For_All_Present, Access_To_Subtype_For_All_Present);

         function Allocate_All_Present
           (Pool : Bump_Ptr_Pool) return Bare_All_Present;

         function Allocate_All_Present
           (Pool : Bump_Ptr_Pool) return Bare_All_Present
         is
            Result      : constant Access_To_Subtype_For_All_Present := Bare_All_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_All_Present;
            return Bare_All_Present (Result);
         end Allocate_All_Present;

      package Bare_Array_Indices_Memos is new Langkit_Support.Packrat
        (Bare_Array_Indices, Token_Index);

      package Bare_Constrained_Array_Indices_Memos is new Langkit_Support.Packrat
        (Bare_Constrained_Array_Indices, Token_Index);

         
         subtype Subtype_For_Constrained_Array_Indices is
            Root_Node_Record (Ada_Constrained_Array_Indices);
         type Access_To_Subtype_For_Constrained_Array_Indices is access all Subtype_For_Constrained_Array_Indices;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Constrained_Array_Indices);
         package Bare_Constrained_Array_Indices_Alloc is new Alloc
           (Subtype_For_Constrained_Array_Indices, Access_To_Subtype_For_Constrained_Array_Indices);

         function Allocate_Constrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Array_Indices;

         function Allocate_Constrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Array_Indices
         is
            Result      : constant Access_To_Subtype_For_Constrained_Array_Indices := Bare_Constrained_Array_Indices_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constrained_Array_Indices;
            return Bare_Constrained_Array_Indices (Result);
         end Allocate_Constrained_Array_Indices;

      package Bare_Unconstrained_Array_Indices_Memos is new Langkit_Support.Packrat
        (Bare_Unconstrained_Array_Indices, Token_Index);

         
         subtype Subtype_For_Unconstrained_Array_Indices is
            Root_Node_Record (Ada_Unconstrained_Array_Indices);
         type Access_To_Subtype_For_Unconstrained_Array_Indices is access all Subtype_For_Unconstrained_Array_Indices;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Unconstrained_Array_Indices);
         package Bare_Unconstrained_Array_Indices_Alloc is new Alloc
           (Subtype_For_Unconstrained_Array_Indices, Access_To_Subtype_For_Unconstrained_Array_Indices);

         function Allocate_Unconstrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Indices;

         function Allocate_Unconstrained_Array_Indices
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Indices
         is
            Result      : constant Access_To_Subtype_For_Unconstrained_Array_Indices := Bare_Unconstrained_Array_Indices_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unconstrained_Array_Indices;
            return Bare_Unconstrained_Array_Indices (Result);
         end Allocate_Unconstrained_Array_Indices;

      package Bare_Aspect_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Assoc, Token_Index);

         
         subtype Subtype_For_Aspect_Assoc is
            Root_Node_Record (Ada_Aspect_Assoc);
         type Access_To_Subtype_For_Aspect_Assoc is access all Subtype_For_Aspect_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aspect_Assoc);
         package Bare_Aspect_Assoc_Alloc is new Alloc
           (Subtype_For_Aspect_Assoc, Access_To_Subtype_For_Aspect_Assoc);

         function Allocate_Aspect_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc;

         function Allocate_Aspect_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Assoc
         is
            Result      : constant Access_To_Subtype_For_Aspect_Assoc := Bare_Aspect_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aspect_Assoc;
            return Bare_Aspect_Assoc (Result);
         end Allocate_Aspect_Assoc;

      package Bare_Aspect_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Clause, Token_Index);

      package Bare_At_Clause_Memos is new Langkit_Support.Packrat
        (Bare_At_Clause, Token_Index);

         
         subtype Subtype_For_At_Clause is
            Root_Node_Record (Ada_At_Clause);
         type Access_To_Subtype_For_At_Clause is access all Subtype_For_At_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_At_Clause);
         package Bare_At_Clause_Alloc is new Alloc
           (Subtype_For_At_Clause, Access_To_Subtype_For_At_Clause);

         function Allocate_At_Clause
           (Pool : Bump_Ptr_Pool) return Bare_At_Clause;

         function Allocate_At_Clause
           (Pool : Bump_Ptr_Pool) return Bare_At_Clause
         is
            Result      : constant Access_To_Subtype_For_At_Clause := Bare_At_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_At_Clause;
            return Bare_At_Clause (Result);
         end Allocate_At_Clause;

      package Bare_Attribute_Def_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Attribute_Def_Clause, Token_Index);

         
         subtype Subtype_For_Attribute_Def_Clause is
            Root_Node_Record (Ada_Attribute_Def_Clause);
         type Access_To_Subtype_For_Attribute_Def_Clause is access all Subtype_For_Attribute_Def_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attribute_Def_Clause);
         package Bare_Attribute_Def_Clause_Alloc is new Alloc
           (Subtype_For_Attribute_Def_Clause, Access_To_Subtype_For_Attribute_Def_Clause);

         function Allocate_Attribute_Def_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Def_Clause;

         function Allocate_Attribute_Def_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Def_Clause
         is
            Result      : constant Access_To_Subtype_For_Attribute_Def_Clause := Bare_Attribute_Def_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Attribute_Def_Clause;
            return Bare_Attribute_Def_Clause (Result);
         end Allocate_Attribute_Def_Clause;

      package Bare_Enum_Rep_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Rep_Clause, Token_Index);

         
         subtype Subtype_For_Enum_Rep_Clause is
            Root_Node_Record (Ada_Enum_Rep_Clause);
         type Access_To_Subtype_For_Enum_Rep_Clause is access all Subtype_For_Enum_Rep_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Rep_Clause);
         package Bare_Enum_Rep_Clause_Alloc is new Alloc
           (Subtype_For_Enum_Rep_Clause, Access_To_Subtype_For_Enum_Rep_Clause);

         function Allocate_Enum_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Rep_Clause;

         function Allocate_Enum_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Rep_Clause
         is
            Result      : constant Access_To_Subtype_For_Enum_Rep_Clause := Bare_Enum_Rep_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Rep_Clause;
            return Bare_Enum_Rep_Clause (Result);
         end Allocate_Enum_Rep_Clause;

      package Bare_Record_Rep_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Record_Rep_Clause, Token_Index);

         
         subtype Subtype_For_Record_Rep_Clause is
            Root_Node_Record (Ada_Record_Rep_Clause);
         type Access_To_Subtype_For_Record_Rep_Clause is access all Subtype_For_Record_Rep_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Record_Rep_Clause);
         package Bare_Record_Rep_Clause_Alloc is new Alloc
           (Subtype_For_Record_Rep_Clause, Access_To_Subtype_For_Record_Rep_Clause);

         function Allocate_Record_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Record_Rep_Clause;

         function Allocate_Record_Rep_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Record_Rep_Clause
         is
            Result      : constant Access_To_Subtype_For_Record_Rep_Clause := Bare_Record_Rep_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Record_Rep_Clause;
            return Bare_Record_Rep_Clause (Result);
         end Allocate_Record_Rep_Clause;

      package Bare_Aspect_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Aspect_Spec, Token_Index);

         
         subtype Subtype_For_Aspect_Spec is
            Root_Node_Record (Ada_Aspect_Spec);
         type Access_To_Subtype_For_Aspect_Spec is access all Subtype_For_Aspect_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aspect_Spec);
         package Bare_Aspect_Spec_Alloc is new Alloc
           (Subtype_For_Aspect_Spec, Access_To_Subtype_For_Aspect_Spec);

         function Allocate_Aspect_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Spec;

         function Allocate_Aspect_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Aspect_Spec
         is
            Result      : constant Access_To_Subtype_For_Aspect_Spec := Bare_Aspect_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aspect_Spec;
            return Bare_Aspect_Spec (Result);
         end Allocate_Aspect_Spec;

      package Bare_Base_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Base_Assoc, Token_Index);

      package Bare_Contract_Case_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Contract_Case_Assoc, Token_Index);

         
         subtype Subtype_For_Contract_Case_Assoc is
            Root_Node_Record (Ada_Contract_Case_Assoc);
         type Access_To_Subtype_For_Contract_Case_Assoc is access all Subtype_For_Contract_Case_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Contract_Case_Assoc);
         package Bare_Contract_Case_Assoc_Alloc is new Alloc
           (Subtype_For_Contract_Case_Assoc, Access_To_Subtype_For_Contract_Case_Assoc);

         function Allocate_Contract_Case_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc;

         function Allocate_Contract_Case_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Case_Assoc
         is
            Result      : constant Access_To_Subtype_For_Contract_Case_Assoc := Bare_Contract_Case_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Contract_Case_Assoc;
            return Bare_Contract_Case_Assoc (Result);
         end Allocate_Contract_Case_Assoc;

      package Bare_Pragma_Argument_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Pragma_Argument_Assoc, Token_Index);

         
         subtype Subtype_For_Pragma_Argument_Assoc is
            Root_Node_Record (Ada_Pragma_Argument_Assoc);
         type Access_To_Subtype_For_Pragma_Argument_Assoc is access all Subtype_For_Pragma_Argument_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pragma_Argument_Assoc);
         package Bare_Pragma_Argument_Assoc_Alloc is new Alloc
           (Subtype_For_Pragma_Argument_Assoc, Access_To_Subtype_For_Pragma_Argument_Assoc);

         function Allocate_Pragma_Argument_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Argument_Assoc;

         function Allocate_Pragma_Argument_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Argument_Assoc
         is
            Result      : constant Access_To_Subtype_For_Pragma_Argument_Assoc := Bare_Pragma_Argument_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pragma_Argument_Assoc;
            return Bare_Pragma_Argument_Assoc (Result);
         end Allocate_Pragma_Argument_Assoc;

      package Bare_Base_Formal_Param_Holder_Memos is new Langkit_Support.Packrat
        (Bare_Base_Formal_Param_Holder, Token_Index);

      package Bare_Base_Subp_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Base_Subp_Spec, Token_Index);

      package Bare_Entry_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Spec, Token_Index);

         
         subtype Subtype_For_Entry_Spec is
            Root_Node_Record (Ada_Entry_Spec);
         type Access_To_Subtype_For_Entry_Spec is access all Subtype_For_Entry_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Entry_Spec);
         package Bare_Entry_Spec_Alloc is new Alloc
           (Subtype_For_Entry_Spec, Access_To_Subtype_For_Entry_Spec);

         function Allocate_Entry_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Spec;

         function Allocate_Entry_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Spec
         is
            Result      : constant Access_To_Subtype_For_Entry_Spec := Bare_Entry_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Spec;
            return Bare_Entry_Spec (Result);
         end Allocate_Entry_Spec;

      package Bare_Enum_Subp_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Subp_Spec, Token_Index);

         
         subtype Subtype_For_Enum_Subp_Spec is
            Root_Node_Record (Ada_Enum_Subp_Spec);
         type Access_To_Subtype_For_Enum_Subp_Spec is access all Subtype_For_Enum_Subp_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Subp_Spec);
         package Bare_Enum_Subp_Spec_Alloc is new Alloc
           (Subtype_For_Enum_Subp_Spec, Access_To_Subtype_For_Enum_Subp_Spec);

         function Allocate_Enum_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Subp_Spec;

         function Allocate_Enum_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Subp_Spec
         is
            Result      : constant Access_To_Subtype_For_Enum_Subp_Spec := Bare_Enum_Subp_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Subp_Spec;
            return Bare_Enum_Subp_Spec (Result);
         end Allocate_Enum_Subp_Spec;

      package Bare_Subp_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Spec, Token_Index);

         
         subtype Subtype_For_Subp_Spec is
            Root_Node_Record (Ada_Subp_Spec);
         type Access_To_Subtype_For_Subp_Spec is access all Subtype_For_Subp_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subp_Spec);
         package Bare_Subp_Spec_Alloc is new Alloc
           (Subtype_For_Subp_Spec, Access_To_Subtype_For_Subp_Spec);

         function Allocate_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Spec;

         function Allocate_Subp_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Spec
         is
            Result      : constant Access_To_Subtype_For_Subp_Spec := Bare_Subp_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Spec;
            return Bare_Subp_Spec (Result);
         end Allocate_Subp_Spec;

      package Bare_Synthetic_Binary_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Binary_Spec, Token_Index);

         
         subtype Subtype_For_Synthetic_Binary_Spec is
            Root_Node_Record (Ada_Synthetic_Binary_Spec);
         type Access_To_Subtype_For_Synthetic_Binary_Spec is access all Subtype_For_Synthetic_Binary_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Binary_Spec);
         package Bare_Synthetic_Binary_Spec_Alloc is new Alloc
           (Subtype_For_Synthetic_Binary_Spec, Access_To_Subtype_For_Synthetic_Binary_Spec);

         function Allocate_Synthetic_Binary_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Binary_Spec;

         function Allocate_Synthetic_Binary_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Binary_Spec
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Binary_Spec := Bare_Synthetic_Binary_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Binary_Spec;
            return Bare_Synthetic_Binary_Spec (Result);
         end Allocate_Synthetic_Binary_Spec;

      package Bare_Synthetic_Unary_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Unary_Spec, Token_Index);

         
         subtype Subtype_For_Synthetic_Unary_Spec is
            Root_Node_Record (Ada_Synthetic_Unary_Spec);
         type Access_To_Subtype_For_Synthetic_Unary_Spec is access all Subtype_For_Synthetic_Unary_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Unary_Spec);
         package Bare_Synthetic_Unary_Spec_Alloc is new Alloc
           (Subtype_For_Synthetic_Unary_Spec, Access_To_Subtype_For_Synthetic_Unary_Spec);

         function Allocate_Synthetic_Unary_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Unary_Spec;

         function Allocate_Synthetic_Unary_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Unary_Spec
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Unary_Spec := Bare_Synthetic_Unary_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Unary_Spec;
            return Bare_Synthetic_Unary_Spec (Result);
         end Allocate_Synthetic_Unary_Spec;

      package Bare_Component_List_Memos is new Langkit_Support.Packrat
        (Bare_Component_List, Token_Index);

         
         subtype Subtype_For_Component_List is
            Root_Node_Record (Ada_Component_List);
         type Access_To_Subtype_For_Component_List is access all Subtype_For_Component_List;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Component_List);
         package Bare_Component_List_Alloc is new Alloc
           (Subtype_For_Component_List, Access_To_Subtype_For_Component_List);

         function Allocate_Component_List
           (Pool : Bump_Ptr_Pool) return Bare_Component_List;

         function Allocate_Component_List
           (Pool : Bump_Ptr_Pool) return Bare_Component_List
         is
            Result      : constant Access_To_Subtype_For_Component_List := Bare_Component_List_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_List;
            return Bare_Component_List (Result);
         end Allocate_Component_List;

      package Bare_Discriminant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Part, Token_Index);

      package Bare_Known_Discriminant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Known_Discriminant_Part, Token_Index);

         
         subtype Subtype_For_Known_Discriminant_Part is
            Root_Node_Record (Ada_Known_Discriminant_Part);
         type Access_To_Subtype_For_Known_Discriminant_Part is access all Subtype_For_Known_Discriminant_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Known_Discriminant_Part);
         package Bare_Known_Discriminant_Part_Alloc is new Alloc
           (Subtype_For_Known_Discriminant_Part, Access_To_Subtype_For_Known_Discriminant_Part);

         function Allocate_Known_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Known_Discriminant_Part;

         function Allocate_Known_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Known_Discriminant_Part
         is
            Result      : constant Access_To_Subtype_For_Known_Discriminant_Part := Bare_Known_Discriminant_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Known_Discriminant_Part;
            return Bare_Known_Discriminant_Part (Result);
         end Allocate_Known_Discriminant_Part;

      package Bare_Unknown_Discriminant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Unknown_Discriminant_Part, Token_Index);

         
         subtype Subtype_For_Unknown_Discriminant_Part is
            Root_Node_Record (Ada_Unknown_Discriminant_Part);
         type Access_To_Subtype_For_Unknown_Discriminant_Part is access all Subtype_For_Unknown_Discriminant_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Unknown_Discriminant_Part);
         package Bare_Unknown_Discriminant_Part_Alloc is new Alloc
           (Subtype_For_Unknown_Discriminant_Part, Access_To_Subtype_For_Unknown_Discriminant_Part);

         function Allocate_Unknown_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Unknown_Discriminant_Part;

         function Allocate_Unknown_Discriminant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Unknown_Discriminant_Part
         is
            Result      : constant Access_To_Subtype_For_Unknown_Discriminant_Part := Bare_Unknown_Discriminant_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unknown_Discriminant_Part;
            return Bare_Unknown_Discriminant_Part (Result);
         end Allocate_Unknown_Discriminant_Part;

      package Bare_Entry_Completion_Formal_Params_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Completion_Formal_Params, Token_Index);

         
         subtype Subtype_For_Entry_Completion_Formal_Params is
            Root_Node_Record (Ada_Entry_Completion_Formal_Params);
         type Access_To_Subtype_For_Entry_Completion_Formal_Params is access all Subtype_For_Entry_Completion_Formal_Params;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Entry_Completion_Formal_Params);
         package Bare_Entry_Completion_Formal_Params_Alloc is new Alloc
           (Subtype_For_Entry_Completion_Formal_Params, Access_To_Subtype_For_Entry_Completion_Formal_Params);

         function Allocate_Entry_Completion_Formal_Params
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Completion_Formal_Params;

         function Allocate_Entry_Completion_Formal_Params
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Completion_Formal_Params
         is
            Result      : constant Access_To_Subtype_For_Entry_Completion_Formal_Params := Bare_Entry_Completion_Formal_Params_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Completion_Formal_Params;
            return Bare_Entry_Completion_Formal_Params (Result);
         end Allocate_Entry_Completion_Formal_Params;

      package Bare_Generic_Formal_Part_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Part, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Part is
            Root_Node_Record (Ada_Generic_Formal_Part);
         type Access_To_Subtype_For_Generic_Formal_Part is access all Subtype_For_Generic_Formal_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Formal_Part);
         package Bare_Generic_Formal_Part_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Part, Access_To_Subtype_For_Generic_Formal_Part);

         function Allocate_Generic_Formal_Part
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Part;

         function Allocate_Generic_Formal_Part
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Part
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Part := Bare_Generic_Formal_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Part;
            return Bare_Generic_Formal_Part (Result);
         end Allocate_Generic_Formal_Part;

      package Bare_Base_Record_Def_Memos is new Langkit_Support.Packrat
        (Bare_Base_Record_Def, Token_Index);

      package Bare_Null_Record_Def_Memos is new Langkit_Support.Packrat
        (Bare_Null_Record_Def, Token_Index);

         
         subtype Subtype_For_Null_Record_Def is
            Root_Node_Record (Ada_Null_Record_Def);
         type Access_To_Subtype_For_Null_Record_Def is access all Subtype_For_Null_Record_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Record_Def);
         package Bare_Null_Record_Def_Alloc is new Alloc
           (Subtype_For_Null_Record_Def, Access_To_Subtype_For_Null_Record_Def);

         function Allocate_Null_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Def;

         function Allocate_Null_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Def
         is
            Result      : constant Access_To_Subtype_For_Null_Record_Def := Bare_Null_Record_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Record_Def;
            return Bare_Null_Record_Def (Result);
         end Allocate_Null_Record_Def;

      package Bare_Record_Def_Memos is new Langkit_Support.Packrat
        (Bare_Record_Def, Token_Index);

         
         subtype Subtype_For_Record_Def is
            Root_Node_Record (Ada_Record_Def);
         type Access_To_Subtype_For_Record_Def is access all Subtype_For_Record_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Record_Def);
         package Bare_Record_Def_Alloc is new Alloc
           (Subtype_For_Record_Def, Access_To_Subtype_For_Record_Def);

         function Allocate_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Def;

         function Allocate_Record_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Def
         is
            Result      : constant Access_To_Subtype_For_Record_Def := Bare_Record_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Record_Def;
            return Bare_Record_Def (Result);
         end Allocate_Record_Def;

      package Bare_Basic_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Assoc, Token_Index);

      package Bare_Aggregate_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Aggregate_Assoc, Token_Index);

         
         subtype Subtype_For_Aggregate_Assoc is
            Root_Node_Record (Ada_Aggregate_Assoc);
         type Access_To_Subtype_For_Aggregate_Assoc is access all Subtype_For_Aggregate_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aggregate_Assoc);
         package Bare_Aggregate_Assoc_Alloc is new Alloc
           (Subtype_For_Aggregate_Assoc, Access_To_Subtype_For_Aggregate_Assoc);

         function Allocate_Aggregate_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate_Assoc;

         function Allocate_Aggregate_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate_Assoc
         is
            Result      : constant Access_To_Subtype_For_Aggregate_Assoc := Bare_Aggregate_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aggregate_Assoc;
            return Bare_Aggregate_Assoc (Result);
         end Allocate_Aggregate_Assoc;

      package Bare_Multi_Dim_Array_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Multi_Dim_Array_Assoc, Token_Index);

         
         subtype Subtype_For_Multi_Dim_Array_Assoc is
            Root_Node_Record (Ada_Multi_Dim_Array_Assoc);
         type Access_To_Subtype_For_Multi_Dim_Array_Assoc is access all Subtype_For_Multi_Dim_Array_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Multi_Dim_Array_Assoc);
         package Bare_Multi_Dim_Array_Assoc_Alloc is new Alloc
           (Subtype_For_Multi_Dim_Array_Assoc, Access_To_Subtype_For_Multi_Dim_Array_Assoc);

         function Allocate_Multi_Dim_Array_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Multi_Dim_Array_Assoc;

         function Allocate_Multi_Dim_Array_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Multi_Dim_Array_Assoc
         is
            Result      : constant Access_To_Subtype_For_Multi_Dim_Array_Assoc := Bare_Multi_Dim_Array_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Multi_Dim_Array_Assoc;
            return Bare_Multi_Dim_Array_Assoc (Result);
         end Allocate_Multi_Dim_Array_Assoc;

      package Bare_Composite_Constraint_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Composite_Constraint_Assoc, Token_Index);

         
         subtype Subtype_For_Composite_Constraint_Assoc is
            Root_Node_Record (Ada_Composite_Constraint_Assoc);
         type Access_To_Subtype_For_Composite_Constraint_Assoc is access all Subtype_For_Composite_Constraint_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Composite_Constraint_Assoc);
         package Bare_Composite_Constraint_Assoc_Alloc is new Alloc
           (Subtype_For_Composite_Constraint_Assoc, Access_To_Subtype_For_Composite_Constraint_Assoc);

         function Allocate_Composite_Constraint_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Composite_Constraint_Assoc;

         function Allocate_Composite_Constraint_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Composite_Constraint_Assoc
         is
            Result      : constant Access_To_Subtype_For_Composite_Constraint_Assoc := Bare_Composite_Constraint_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Composite_Constraint_Assoc;
            return Bare_Composite_Constraint_Assoc (Result);
         end Allocate_Composite_Constraint_Assoc;

      package Bare_Iterated_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Iterated_Assoc, Token_Index);

         
         subtype Subtype_For_Iterated_Assoc is
            Root_Node_Record (Ada_Iterated_Assoc);
         type Access_To_Subtype_For_Iterated_Assoc is access all Subtype_For_Iterated_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Iterated_Assoc);
         package Bare_Iterated_Assoc_Alloc is new Alloc
           (Subtype_For_Iterated_Assoc, Access_To_Subtype_For_Iterated_Assoc);

         function Allocate_Iterated_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Iterated_Assoc;

         function Allocate_Iterated_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Iterated_Assoc
         is
            Result      : constant Access_To_Subtype_For_Iterated_Assoc := Bare_Iterated_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Iterated_Assoc;
            return Bare_Iterated_Assoc (Result);
         end Allocate_Iterated_Assoc;

      package Bare_Param_Assoc_Memos is new Langkit_Support.Packrat
        (Bare_Param_Assoc, Token_Index);

         
         subtype Subtype_For_Param_Assoc is
            Root_Node_Record (Ada_Param_Assoc);
         type Access_To_Subtype_For_Param_Assoc is access all Subtype_For_Param_Assoc;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Param_Assoc);
         package Bare_Param_Assoc_Alloc is new Alloc
           (Subtype_For_Param_Assoc, Access_To_Subtype_For_Param_Assoc);

         function Allocate_Param_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Param_Assoc;

         function Allocate_Param_Assoc
           (Pool : Bump_Ptr_Pool) return Bare_Param_Assoc
         is
            Result      : constant Access_To_Subtype_For_Param_Assoc := Bare_Param_Assoc_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Param_Assoc;
            return Bare_Param_Assoc (Result);
         end Allocate_Param_Assoc;

      package Bare_Basic_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Decl, Token_Index);

      package Bare_Abstract_State_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_State_Decl, Token_Index);

         
         subtype Subtype_For_Abstract_State_Decl is
            Root_Node_Record (Ada_Abstract_State_Decl);
         type Access_To_Subtype_For_Abstract_State_Decl is access all Subtype_For_Abstract_State_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abstract_State_Decl);
         package Bare_Abstract_State_Decl_Alloc is new Alloc
           (Subtype_For_Abstract_State_Decl, Access_To_Subtype_For_Abstract_State_Decl);

         function Allocate_Abstract_State_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_State_Decl;

         function Allocate_Abstract_State_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_State_Decl
         is
            Result      : constant Access_To_Subtype_For_Abstract_State_Decl := Bare_Abstract_State_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_State_Decl;
            return Bare_Abstract_State_Decl (Result);
         end Allocate_Abstract_State_Decl;

      package Bare_Anonymous_Expr_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Expr_Decl, Token_Index);

         
         subtype Subtype_For_Anonymous_Expr_Decl is
            Root_Node_Record (Ada_Anonymous_Expr_Decl);
         type Access_To_Subtype_For_Anonymous_Expr_Decl is access all Subtype_For_Anonymous_Expr_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Anonymous_Expr_Decl);
         package Bare_Anonymous_Expr_Decl_Alloc is new Alloc
           (Subtype_For_Anonymous_Expr_Decl, Access_To_Subtype_For_Anonymous_Expr_Decl);

         function Allocate_Anonymous_Expr_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Expr_Decl;

         function Allocate_Anonymous_Expr_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Expr_Decl
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Expr_Decl := Bare_Anonymous_Expr_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Expr_Decl;
            return Bare_Anonymous_Expr_Decl (Result);
         end Allocate_Anonymous_Expr_Decl;

      package Bare_Base_Formal_Param_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Formal_Param_Decl, Token_Index);

      package Bare_Component_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Component_Decl, Token_Index);

         
         subtype Subtype_For_Component_Decl is
            Root_Node_Record (Ada_Component_Decl);
         type Access_To_Subtype_For_Component_Decl is access all Subtype_For_Component_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Component_Decl);
         package Bare_Component_Decl_Alloc is new Alloc
           (Subtype_For_Component_Decl, Access_To_Subtype_For_Component_Decl);

         function Allocate_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Component_Decl;

         function Allocate_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Component_Decl
         is
            Result      : constant Access_To_Subtype_For_Component_Decl := Bare_Component_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_Decl;
            return Bare_Component_Decl (Result);
         end Allocate_Component_Decl;

      package Bare_Discriminant_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Discriminant_Spec, Token_Index);

         
         subtype Subtype_For_Discriminant_Spec is
            Root_Node_Record (Ada_Discriminant_Spec);
         type Access_To_Subtype_For_Discriminant_Spec is access all Subtype_For_Discriminant_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Discriminant_Spec);
         package Bare_Discriminant_Spec_Alloc is new Alloc
           (Subtype_For_Discriminant_Spec, Access_To_Subtype_For_Discriminant_Spec);

         function Allocate_Discriminant_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec;

         function Allocate_Discriminant_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Discriminant_Spec
         is
            Result      : constant Access_To_Subtype_For_Discriminant_Spec := Bare_Discriminant_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discriminant_Spec;
            return Bare_Discriminant_Spec (Result);
         end Allocate_Discriminant_Spec;

      package Bare_Generic_Formal_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal, Token_Index);

      package Bare_Generic_Formal_Obj_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Obj_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Obj_Decl is
            Root_Node_Record (Ada_Generic_Formal_Obj_Decl);
         type Access_To_Subtype_For_Generic_Formal_Obj_Decl is access all Subtype_For_Generic_Formal_Obj_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Formal_Obj_Decl);
         package Bare_Generic_Formal_Obj_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Obj_Decl, Access_To_Subtype_For_Generic_Formal_Obj_Decl);

         function Allocate_Generic_Formal_Obj_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Obj_Decl;

         function Allocate_Generic_Formal_Obj_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Obj_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Obj_Decl := Bare_Generic_Formal_Obj_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Obj_Decl;
            return Bare_Generic_Formal_Obj_Decl (Result);
         end Allocate_Generic_Formal_Obj_Decl;

      package Bare_Generic_Formal_Package_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Package, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Package is
            Root_Node_Record (Ada_Generic_Formal_Package);
         type Access_To_Subtype_For_Generic_Formal_Package is access all Subtype_For_Generic_Formal_Package;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Formal_Package);
         package Bare_Generic_Formal_Package_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Package, Access_To_Subtype_For_Generic_Formal_Package);

         function Allocate_Generic_Formal_Package
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Package;

         function Allocate_Generic_Formal_Package
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Package
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Package := Bare_Generic_Formal_Package_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Package;
            return Bare_Generic_Formal_Package (Result);
         end Allocate_Generic_Formal_Package;

      package Bare_Generic_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Subp_Decl is
            Root_Node_Record (Ada_Generic_Formal_Subp_Decl);
         type Access_To_Subtype_For_Generic_Formal_Subp_Decl is access all Subtype_For_Generic_Formal_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Formal_Subp_Decl);
         package Bare_Generic_Formal_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Subp_Decl, Access_To_Subtype_For_Generic_Formal_Subp_Decl);

         function Allocate_Generic_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Subp_Decl;

         function Allocate_Generic_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Subp_Decl := Bare_Generic_Formal_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Subp_Decl;
            return Bare_Generic_Formal_Subp_Decl (Result);
         end Allocate_Generic_Formal_Subp_Decl;

      package Bare_Generic_Formal_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Formal_Type_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Formal_Type_Decl is
            Root_Node_Record (Ada_Generic_Formal_Type_Decl);
         type Access_To_Subtype_For_Generic_Formal_Type_Decl is access all Subtype_For_Generic_Formal_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Formal_Type_Decl);
         package Bare_Generic_Formal_Type_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Formal_Type_Decl, Access_To_Subtype_For_Generic_Formal_Type_Decl);

         function Allocate_Generic_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Type_Decl;

         function Allocate_Generic_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Formal_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Formal_Type_Decl := Bare_Generic_Formal_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Formal_Type_Decl;
            return Bare_Generic_Formal_Type_Decl (Result);
         end Allocate_Generic_Formal_Type_Decl;

      package Bare_Param_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Param_Spec, Token_Index);

         
         subtype Subtype_For_Param_Spec is
            Root_Node_Record (Ada_Param_Spec);
         type Access_To_Subtype_For_Param_Spec is access all Subtype_For_Param_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Param_Spec);
         package Bare_Param_Spec_Alloc is new Alloc
           (Subtype_For_Param_Spec, Access_To_Subtype_For_Param_Spec);

         function Allocate_Param_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec;

         function Allocate_Param_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Param_Spec
         is
            Result      : constant Access_To_Subtype_For_Param_Spec := Bare_Param_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Param_Spec;
            return Bare_Param_Spec (Result);
         end Allocate_Param_Spec;

      package Bare_Synthetic_Formal_Param_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Formal_Param_Decl, Token_Index);

         
         subtype Subtype_For_Synthetic_Formal_Param_Decl is
            Root_Node_Record (Ada_Synthetic_Formal_Param_Decl);
         type Access_To_Subtype_For_Synthetic_Formal_Param_Decl is access all Subtype_For_Synthetic_Formal_Param_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Formal_Param_Decl);
         package Bare_Synthetic_Formal_Param_Decl_Alloc is new Alloc
           (Subtype_For_Synthetic_Formal_Param_Decl, Access_To_Subtype_For_Synthetic_Formal_Param_Decl);

         function Allocate_Synthetic_Formal_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Formal_Param_Decl;

         function Allocate_Synthetic_Formal_Param_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Formal_Param_Decl
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Formal_Param_Decl := Bare_Synthetic_Formal_Param_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Formal_Param_Decl;
            return Bare_Synthetic_Formal_Param_Decl (Result);
         end Allocate_Synthetic_Formal_Param_Decl;

      package Bare_Base_Package_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Package_Decl, Token_Index);

      package Bare_Generic_Package_Internal_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Internal, Token_Index);

         
         subtype Subtype_For_Generic_Package_Internal is
            Root_Node_Record (Ada_Generic_Package_Internal);
         type Access_To_Subtype_For_Generic_Package_Internal is access all Subtype_For_Generic_Package_Internal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Package_Internal);
         package Bare_Generic_Package_Internal_Alloc is new Alloc
           (Subtype_For_Generic_Package_Internal, Access_To_Subtype_For_Generic_Package_Internal);

         function Allocate_Generic_Package_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Internal;

         function Allocate_Generic_Package_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Internal
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Internal := Bare_Generic_Package_Internal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Internal;
            return Bare_Generic_Package_Internal (Result);
         end Allocate_Generic_Package_Internal;

      package Bare_Package_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Package_Decl, Token_Index);

         
         subtype Subtype_For_Package_Decl is
            Root_Node_Record (Ada_Package_Decl);
         type Access_To_Subtype_For_Package_Decl is access all Subtype_For_Package_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Package_Decl);
         package Bare_Package_Decl_Alloc is new Alloc
           (Subtype_For_Package_Decl, Access_To_Subtype_For_Package_Decl);

         function Allocate_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Decl;

         function Allocate_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Decl
         is
            Result      : constant Access_To_Subtype_For_Package_Decl := Bare_Package_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Decl;
            return Bare_Package_Decl (Result);
         end Allocate_Package_Decl;

      package Bare_Base_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Type_Decl, Token_Index);

      package Bare_Base_Subtype_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Base_Subtype_Decl, Token_Index);

      package Bare_Discrete_Base_Subtype_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Discrete_Base_Subtype_Decl, Token_Index);

         
         subtype Subtype_For_Discrete_Base_Subtype_Decl is
            Root_Node_Record (Ada_Discrete_Base_Subtype_Decl);
         type Access_To_Subtype_For_Discrete_Base_Subtype_Decl is access all Subtype_For_Discrete_Base_Subtype_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Discrete_Base_Subtype_Decl);
         package Bare_Discrete_Base_Subtype_Decl_Alloc is new Alloc
           (Subtype_For_Discrete_Base_Subtype_Decl, Access_To_Subtype_For_Discrete_Base_Subtype_Decl);

         function Allocate_Discrete_Base_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Base_Subtype_Decl;

         function Allocate_Discrete_Base_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Base_Subtype_Decl
         is
            Result      : constant Access_To_Subtype_For_Discrete_Base_Subtype_Decl := Bare_Discrete_Base_Subtype_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discrete_Base_Subtype_Decl;
            return Bare_Discrete_Base_Subtype_Decl (Result);
         end Allocate_Discrete_Base_Subtype_Decl;

      package Bare_Subtype_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Subtype_Decl, Token_Index);

         
         subtype Subtype_For_Subtype_Decl is
            Root_Node_Record (Ada_Subtype_Decl);
         type Access_To_Subtype_For_Subtype_Decl is access all Subtype_For_Subtype_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subtype_Decl);
         package Bare_Subtype_Decl_Alloc is new Alloc
           (Subtype_For_Subtype_Decl, Access_To_Subtype_For_Subtype_Decl);

         function Allocate_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Decl;

         function Allocate_Subtype_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Decl
         is
            Result      : constant Access_To_Subtype_For_Subtype_Decl := Bare_Subtype_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subtype_Decl;
            return Bare_Subtype_Decl (Result);
         end Allocate_Subtype_Decl;

      package Bare_Classwide_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Classwide_Type_Decl, Token_Index);

         
         subtype Subtype_For_Classwide_Type_Decl is
            Root_Node_Record (Ada_Classwide_Type_Decl);
         type Access_To_Subtype_For_Classwide_Type_Decl is access all Subtype_For_Classwide_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Classwide_Type_Decl);
         package Bare_Classwide_Type_Decl_Alloc is new Alloc
           (Subtype_For_Classwide_Type_Decl, Access_To_Subtype_For_Classwide_Type_Decl);

         function Allocate_Classwide_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Classwide_Type_Decl;

         function Allocate_Classwide_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Classwide_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Classwide_Type_Decl := Bare_Classwide_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Classwide_Type_Decl;
            return Bare_Classwide_Type_Decl (Result);
         end Allocate_Classwide_Type_Decl;

      package Bare_Incomplete_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Incomplete_Type_Decl, Token_Index);

         
         subtype Subtype_For_Incomplete_Type_Decl is
            Root_Node_Record (Ada_Incomplete_Type_Decl);
         type Access_To_Subtype_For_Incomplete_Type_Decl is access all Subtype_For_Incomplete_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Incomplete_Type_Decl);
         package Bare_Incomplete_Type_Decl_Alloc is new Alloc
           (Subtype_For_Incomplete_Type_Decl, Access_To_Subtype_For_Incomplete_Type_Decl);

         function Allocate_Incomplete_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Type_Decl;

         function Allocate_Incomplete_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Incomplete_Type_Decl := Bare_Incomplete_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Incomplete_Type_Decl;
            return Bare_Incomplete_Type_Decl (Result);
         end Allocate_Incomplete_Type_Decl;

      package Bare_Incomplete_Formal_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Incomplete_Formal_Type_Decl, Token_Index);

         
         subtype Subtype_For_Incomplete_Formal_Type_Decl is
            Root_Node_Record (Ada_Incomplete_Formal_Type_Decl);
         type Access_To_Subtype_For_Incomplete_Formal_Type_Decl is access all Subtype_For_Incomplete_Formal_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Incomplete_Formal_Type_Decl);
         package Bare_Incomplete_Formal_Type_Decl_Alloc is new Alloc
           (Subtype_For_Incomplete_Formal_Type_Decl, Access_To_Subtype_For_Incomplete_Formal_Type_Decl);

         function Allocate_Incomplete_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Formal_Type_Decl;

         function Allocate_Incomplete_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Formal_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Incomplete_Formal_Type_Decl := Bare_Incomplete_Formal_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Incomplete_Formal_Type_Decl;
            return Bare_Incomplete_Formal_Type_Decl (Result);
         end Allocate_Incomplete_Formal_Type_Decl;

      package Bare_Incomplete_Tagged_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Incomplete_Tagged_Type_Decl, Token_Index);

         
         subtype Subtype_For_Incomplete_Tagged_Type_Decl is
            Root_Node_Record (Ada_Incomplete_Tagged_Type_Decl);
         type Access_To_Subtype_For_Incomplete_Tagged_Type_Decl is access all Subtype_For_Incomplete_Tagged_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Incomplete_Tagged_Type_Decl);
         package Bare_Incomplete_Tagged_Type_Decl_Alloc is new Alloc
           (Subtype_For_Incomplete_Tagged_Type_Decl, Access_To_Subtype_For_Incomplete_Tagged_Type_Decl);

         function Allocate_Incomplete_Tagged_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Tagged_Type_Decl;

         function Allocate_Incomplete_Tagged_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Incomplete_Tagged_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Incomplete_Tagged_Type_Decl := Bare_Incomplete_Tagged_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Incomplete_Tagged_Type_Decl;
            return Bare_Incomplete_Tagged_Type_Decl (Result);
         end Allocate_Incomplete_Tagged_Type_Decl;

      package Bare_Protected_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Type_Decl, Token_Index);

         
         subtype Subtype_For_Protected_Type_Decl is
            Root_Node_Record (Ada_Protected_Type_Decl);
         type Access_To_Subtype_For_Protected_Type_Decl is access all Subtype_For_Protected_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Protected_Type_Decl);
         package Bare_Protected_Type_Decl_Alloc is new Alloc
           (Subtype_For_Protected_Type_Decl, Access_To_Subtype_For_Protected_Type_Decl);

         function Allocate_Protected_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Type_Decl;

         function Allocate_Protected_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Protected_Type_Decl := Bare_Protected_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Type_Decl;
            return Bare_Protected_Type_Decl (Result);
         end Allocate_Protected_Type_Decl;

      package Bare_Task_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Task_Type_Decl, Token_Index);

         
         subtype Subtype_For_Task_Type_Decl is
            Root_Node_Record (Ada_Task_Type_Decl);
         type Access_To_Subtype_For_Task_Type_Decl is access all Subtype_For_Task_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Task_Type_Decl);
         package Bare_Task_Type_Decl_Alloc is new Alloc
           (Subtype_For_Task_Type_Decl, Access_To_Subtype_For_Task_Type_Decl);

         function Allocate_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Task_Type_Decl;

         function Allocate_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Task_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Task_Type_Decl := Bare_Task_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Type_Decl;
            return Bare_Task_Type_Decl (Result);
         end Allocate_Task_Type_Decl;

      package Bare_Single_Task_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Single_Task_Type_Decl, Token_Index);

         
         subtype Subtype_For_Single_Task_Type_Decl is
            Root_Node_Record (Ada_Single_Task_Type_Decl);
         type Access_To_Subtype_For_Single_Task_Type_Decl is access all Subtype_For_Single_Task_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Single_Task_Type_Decl);
         package Bare_Single_Task_Type_Decl_Alloc is new Alloc
           (Subtype_For_Single_Task_Type_Decl, Access_To_Subtype_For_Single_Task_Type_Decl);

         function Allocate_Single_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Type_Decl;

         function Allocate_Single_Task_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Single_Task_Type_Decl := Bare_Single_Task_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Single_Task_Type_Decl;
            return Bare_Single_Task_Type_Decl (Result);
         end Allocate_Single_Task_Type_Decl;

      package Bare_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Type_Decl, Token_Index);

      package Bare_Anonymous_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Type_Decl, Token_Index);

         
         subtype Subtype_For_Anonymous_Type_Decl is
            Root_Node_Record (Ada_Anonymous_Type_Decl);
         type Access_To_Subtype_For_Anonymous_Type_Decl is access all Subtype_For_Anonymous_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Anonymous_Type_Decl);
         package Bare_Anonymous_Type_Decl_Alloc is new Alloc
           (Subtype_For_Anonymous_Type_Decl, Access_To_Subtype_For_Anonymous_Type_Decl);

         function Allocate_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Decl;

         function Allocate_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Type_Decl := Bare_Anonymous_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Type_Decl;
            return Bare_Anonymous_Type_Decl (Result);
         end Allocate_Anonymous_Type_Decl;

      package Bare_Synth_Anonymous_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Synth_Anonymous_Type_Decl, Token_Index);

         
         subtype Subtype_For_Synth_Anonymous_Type_Decl is
            Root_Node_Record (Ada_Synth_Anonymous_Type_Decl);
         type Access_To_Subtype_For_Synth_Anonymous_Type_Decl is access all Subtype_For_Synth_Anonymous_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synth_Anonymous_Type_Decl);
         package Bare_Synth_Anonymous_Type_Decl_Alloc is new Alloc
           (Subtype_For_Synth_Anonymous_Type_Decl, Access_To_Subtype_For_Synth_Anonymous_Type_Decl);

         function Allocate_Synth_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Anonymous_Type_Decl;

         function Allocate_Synth_Anonymous_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synth_Anonymous_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Synth_Anonymous_Type_Decl := Bare_Synth_Anonymous_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synth_Anonymous_Type_Decl;
            return Bare_Synth_Anonymous_Type_Decl (Result);
         end Allocate_Synth_Anonymous_Type_Decl;

      package Bare_Concrete_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Concrete_Type_Decl, Token_Index);

         
         subtype Subtype_For_Concrete_Type_Decl is
            Root_Node_Record (Ada_Concrete_Type_Decl);
         type Access_To_Subtype_For_Concrete_Type_Decl is access all Subtype_For_Concrete_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Concrete_Type_Decl);
         package Bare_Concrete_Type_Decl_Alloc is new Alloc
           (Subtype_For_Concrete_Type_Decl, Access_To_Subtype_For_Concrete_Type_Decl);

         function Allocate_Concrete_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Concrete_Type_Decl;

         function Allocate_Concrete_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Concrete_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Concrete_Type_Decl := Bare_Concrete_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Concrete_Type_Decl;
            return Bare_Concrete_Type_Decl (Result);
         end Allocate_Concrete_Type_Decl;

      package Bare_Formal_Type_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Type_Decl, Token_Index);

         
         subtype Subtype_For_Formal_Type_Decl is
            Root_Node_Record (Ada_Formal_Type_Decl);
         type Access_To_Subtype_For_Formal_Type_Decl is access all Subtype_For_Formal_Type_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Formal_Type_Decl);
         package Bare_Formal_Type_Decl_Alloc is new Alloc
           (Subtype_For_Formal_Type_Decl, Access_To_Subtype_For_Formal_Type_Decl);

         function Allocate_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Type_Decl;

         function Allocate_Formal_Type_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Type_Decl
         is
            Result      : constant Access_To_Subtype_For_Formal_Type_Decl := Bare_Formal_Type_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Formal_Type_Decl;
            return Bare_Formal_Type_Decl (Result);
         end Allocate_Formal_Type_Decl;

      package Bare_Basic_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Basic_Subp_Decl, Token_Index);

      package Bare_Classic_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Classic_Subp_Decl, Token_Index);

      package Bare_Abstract_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Abstract_Subp_Decl is
            Root_Node_Record (Ada_Abstract_Subp_Decl);
         type Access_To_Subtype_For_Abstract_Subp_Decl is access all Subtype_For_Abstract_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abstract_Subp_Decl);
         package Bare_Abstract_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Abstract_Subp_Decl, Access_To_Subtype_For_Abstract_Subp_Decl);

         function Allocate_Abstract_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Subp_Decl;

         function Allocate_Abstract_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Abstract_Subp_Decl := Bare_Abstract_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Subp_Decl;
            return Bare_Abstract_Subp_Decl (Result);
         end Allocate_Abstract_Subp_Decl;

      package Bare_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Subp_Decl, Token_Index);

      package Bare_Abstract_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_Formal_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Abstract_Formal_Subp_Decl is
            Root_Node_Record (Ada_Abstract_Formal_Subp_Decl);
         type Access_To_Subtype_For_Abstract_Formal_Subp_Decl is access all Subtype_For_Abstract_Formal_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abstract_Formal_Subp_Decl);
         package Bare_Abstract_Formal_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Abstract_Formal_Subp_Decl, Access_To_Subtype_For_Abstract_Formal_Subp_Decl);

         function Allocate_Abstract_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Formal_Subp_Decl;

         function Allocate_Abstract_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_Formal_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Abstract_Formal_Subp_Decl := Bare_Abstract_Formal_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_Formal_Subp_Decl;
            return Bare_Abstract_Formal_Subp_Decl (Result);
         end Allocate_Abstract_Formal_Subp_Decl;

      package Bare_Concrete_Formal_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Concrete_Formal_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Concrete_Formal_Subp_Decl is
            Root_Node_Record (Ada_Concrete_Formal_Subp_Decl);
         type Access_To_Subtype_For_Concrete_Formal_Subp_Decl is access all Subtype_For_Concrete_Formal_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Concrete_Formal_Subp_Decl);
         package Bare_Concrete_Formal_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Concrete_Formal_Subp_Decl, Access_To_Subtype_For_Concrete_Formal_Subp_Decl);

         function Allocate_Concrete_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Concrete_Formal_Subp_Decl;

         function Allocate_Concrete_Formal_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Concrete_Formal_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Concrete_Formal_Subp_Decl := Bare_Concrete_Formal_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Concrete_Formal_Subp_Decl;
            return Bare_Concrete_Formal_Subp_Decl (Result);
         end Allocate_Concrete_Formal_Subp_Decl;

      package Bare_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Subp_Decl is
            Root_Node_Record (Ada_Subp_Decl);
         type Access_To_Subtype_For_Subp_Decl is access all Subtype_For_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subp_Decl);
         package Bare_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Subp_Decl, Access_To_Subtype_For_Subp_Decl);

         function Allocate_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Decl;

         function Allocate_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Subp_Decl := Bare_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Decl;
            return Bare_Subp_Decl (Result);
         end Allocate_Subp_Decl;

      package Bare_Entry_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Decl, Token_Index);

         
         subtype Subtype_For_Entry_Decl is
            Root_Node_Record (Ada_Entry_Decl);
         type Access_To_Subtype_For_Entry_Decl is access all Subtype_For_Entry_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Entry_Decl);
         package Bare_Entry_Decl_Alloc is new Alloc
           (Subtype_For_Entry_Decl, Access_To_Subtype_For_Entry_Decl);

         function Allocate_Entry_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Decl;

         function Allocate_Entry_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Decl
         is
            Result      : constant Access_To_Subtype_For_Entry_Decl := Bare_Entry_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Decl;
            return Bare_Entry_Decl (Result);
         end Allocate_Entry_Decl;

      package Bare_Enum_Literal_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Literal_Decl, Token_Index);

         
         subtype Subtype_For_Enum_Literal_Decl is
            Root_Node_Record (Ada_Enum_Literal_Decl);
         type Access_To_Subtype_For_Enum_Literal_Decl is access all Subtype_For_Enum_Literal_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Literal_Decl);
         package Bare_Enum_Literal_Decl_Alloc is new Alloc
           (Subtype_For_Enum_Literal_Decl, Access_To_Subtype_For_Enum_Literal_Decl);

         function Allocate_Enum_Literal_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl;

         function Allocate_Enum_Literal_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Literal_Decl
         is
            Result      : constant Access_To_Subtype_For_Enum_Literal_Decl := Bare_Enum_Literal_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Literal_Decl;
            return Bare_Enum_Literal_Decl (Result);
         end Allocate_Enum_Literal_Decl;

      package Bare_Synthetic_Char_Enum_Lit_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Char_Enum_Lit, Token_Index);

         
         subtype Subtype_For_Synthetic_Char_Enum_Lit is
            Root_Node_Record (Ada_Synthetic_Char_Enum_Lit);
         type Access_To_Subtype_For_Synthetic_Char_Enum_Lit is access all Subtype_For_Synthetic_Char_Enum_Lit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Char_Enum_Lit);
         package Bare_Synthetic_Char_Enum_Lit_Alloc is new Alloc
           (Subtype_For_Synthetic_Char_Enum_Lit, Access_To_Subtype_For_Synthetic_Char_Enum_Lit);

         function Allocate_Synthetic_Char_Enum_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Char_Enum_Lit;

         function Allocate_Synthetic_Char_Enum_Lit
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Char_Enum_Lit
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Char_Enum_Lit := Bare_Synthetic_Char_Enum_Lit_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Char_Enum_Lit;
            return Bare_Synthetic_Char_Enum_Lit (Result);
         end Allocate_Synthetic_Char_Enum_Lit;

      package Bare_Generic_Subp_Internal_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Internal, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Internal is
            Root_Node_Record (Ada_Generic_Subp_Internal);
         type Access_To_Subtype_For_Generic_Subp_Internal is access all Subtype_For_Generic_Subp_Internal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Subp_Internal);
         package Bare_Generic_Subp_Internal_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Internal, Access_To_Subtype_For_Generic_Subp_Internal);

         function Allocate_Generic_Subp_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Internal;

         function Allocate_Generic_Subp_Internal
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Internal
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Internal := Bare_Generic_Subp_Internal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Internal;
            return Bare_Generic_Subp_Internal (Result);
         end Allocate_Generic_Subp_Internal;

      package Bare_Synthetic_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Synthetic_Subp_Decl is
            Root_Node_Record (Ada_Synthetic_Subp_Decl);
         type Access_To_Subtype_For_Synthetic_Subp_Decl is access all Subtype_For_Synthetic_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Subp_Decl);
         package Bare_Synthetic_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Synthetic_Subp_Decl, Access_To_Subtype_For_Synthetic_Subp_Decl);

         function Allocate_Synthetic_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Subp_Decl;

         function Allocate_Synthetic_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Subp_Decl := Bare_Synthetic_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Subp_Decl;
            return Bare_Synthetic_Subp_Decl (Result);
         end Allocate_Synthetic_Subp_Decl;

      package Bare_Body_Node_Memos is new Langkit_Support.Packrat
        (Bare_Body_Node, Token_Index);

      package Bare_Accept_Stmt_Body_Memos is new Langkit_Support.Packrat
        (Bare_Accept_Stmt_Body, Token_Index);

         
         subtype Subtype_For_Accept_Stmt_Body is
            Root_Node_Record (Ada_Accept_Stmt_Body);
         type Access_To_Subtype_For_Accept_Stmt_Body is access all Subtype_For_Accept_Stmt_Body;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Accept_Stmt_Body);
         package Bare_Accept_Stmt_Body_Alloc is new Alloc
           (Subtype_For_Accept_Stmt_Body, Access_To_Subtype_For_Accept_Stmt_Body);

         function Allocate_Accept_Stmt_Body
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt_Body;

         function Allocate_Accept_Stmt_Body
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt_Body
         is
            Result      : constant Access_To_Subtype_For_Accept_Stmt_Body := Bare_Accept_Stmt_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Accept_Stmt_Body;
            return Bare_Accept_Stmt_Body (Result);
         end Allocate_Accept_Stmt_Body;

      package Bare_Base_Subp_Body_Memos is new Langkit_Support.Packrat
        (Bare_Base_Subp_Body, Token_Index);

      package Bare_Expr_Function_Memos is new Langkit_Support.Packrat
        (Bare_Expr_Function, Token_Index);

         
         subtype Subtype_For_Expr_Function is
            Root_Node_Record (Ada_Expr_Function);
         type Access_To_Subtype_For_Expr_Function is access all Subtype_For_Expr_Function;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Expr_Function);
         package Bare_Expr_Function_Alloc is new Alloc
           (Subtype_For_Expr_Function, Access_To_Subtype_For_Expr_Function);

         function Allocate_Expr_Function
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Function;

         function Allocate_Expr_Function
           (Pool : Bump_Ptr_Pool) return Bare_Expr_Function
         is
            Result      : constant Access_To_Subtype_For_Expr_Function := Bare_Expr_Function_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Expr_Function;
            return Bare_Expr_Function (Result);
         end Allocate_Expr_Function;

      package Bare_Null_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Null_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Null_Subp_Decl is
            Root_Node_Record (Ada_Null_Subp_Decl);
         type Access_To_Subtype_For_Null_Subp_Decl is access all Subtype_For_Null_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Subp_Decl);
         package Bare_Null_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Null_Subp_Decl, Access_To_Subtype_For_Null_Subp_Decl);

         function Allocate_Null_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Subp_Decl;

         function Allocate_Null_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Null_Subp_Decl := Bare_Null_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Subp_Decl;
            return Bare_Null_Subp_Decl (Result);
         end Allocate_Null_Subp_Decl;

      package Bare_Subp_Body_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Body, Token_Index);

         
         subtype Subtype_For_Subp_Body is
            Root_Node_Record (Ada_Subp_Body);
         type Access_To_Subtype_For_Subp_Body is access all Subtype_For_Subp_Body;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subp_Body);
         package Bare_Subp_Body_Alloc is new Alloc
           (Subtype_For_Subp_Body, Access_To_Subtype_For_Subp_Body);

         function Allocate_Subp_Body
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body;

         function Allocate_Subp_Body
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body
         is
            Result      : constant Access_To_Subtype_For_Subp_Body := Bare_Subp_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Body;
            return Bare_Subp_Body (Result);
         end Allocate_Subp_Body;

      package Bare_Subp_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Subp_Renaming_Decl is
            Root_Node_Record (Ada_Subp_Renaming_Decl);
         type Access_To_Subtype_For_Subp_Renaming_Decl is access all Subtype_For_Subp_Renaming_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subp_Renaming_Decl);
         package Bare_Subp_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Subp_Renaming_Decl, Access_To_Subtype_For_Subp_Renaming_Decl);

         function Allocate_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Renaming_Decl;

         function Allocate_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Subp_Renaming_Decl := Bare_Subp_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Renaming_Decl;
            return Bare_Subp_Renaming_Decl (Result);
         end Allocate_Subp_Renaming_Decl;

      package Bare_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Body_Stub, Token_Index);

      package Bare_Package_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Package_Body_Stub, Token_Index);

         
         subtype Subtype_For_Package_Body_Stub is
            Root_Node_Record (Ada_Package_Body_Stub);
         type Access_To_Subtype_For_Package_Body_Stub is access all Subtype_For_Package_Body_Stub;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Package_Body_Stub);
         package Bare_Package_Body_Stub_Alloc is new Alloc
           (Subtype_For_Package_Body_Stub, Access_To_Subtype_For_Package_Body_Stub);

         function Allocate_Package_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body_Stub;

         function Allocate_Package_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Package_Body_Stub := Bare_Package_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Body_Stub;
            return Bare_Package_Body_Stub (Result);
         end Allocate_Package_Body_Stub;

      package Bare_Protected_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Body_Stub, Token_Index);

         
         subtype Subtype_For_Protected_Body_Stub is
            Root_Node_Record (Ada_Protected_Body_Stub);
         type Access_To_Subtype_For_Protected_Body_Stub is access all Subtype_For_Protected_Body_Stub;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Protected_Body_Stub);
         package Bare_Protected_Body_Stub_Alloc is new Alloc
           (Subtype_For_Protected_Body_Stub, Access_To_Subtype_For_Protected_Body_Stub);

         function Allocate_Protected_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body_Stub;

         function Allocate_Protected_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Protected_Body_Stub := Bare_Protected_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Body_Stub;
            return Bare_Protected_Body_Stub (Result);
         end Allocate_Protected_Body_Stub;

      package Bare_Subp_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Body_Stub, Token_Index);

         
         subtype Subtype_For_Subp_Body_Stub is
            Root_Node_Record (Ada_Subp_Body_Stub);
         type Access_To_Subtype_For_Subp_Body_Stub is access all Subtype_For_Subp_Body_Stub;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subp_Body_Stub);
         package Bare_Subp_Body_Stub_Alloc is new Alloc
           (Subtype_For_Subp_Body_Stub, Access_To_Subtype_For_Subp_Body_Stub);

         function Allocate_Subp_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body_Stub;

         function Allocate_Subp_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Subp_Body_Stub := Bare_Subp_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Body_Stub;
            return Bare_Subp_Body_Stub (Result);
         end Allocate_Subp_Body_Stub;

      package Bare_Task_Body_Stub_Memos is new Langkit_Support.Packrat
        (Bare_Task_Body_Stub, Token_Index);

         
         subtype Subtype_For_Task_Body_Stub is
            Root_Node_Record (Ada_Task_Body_Stub);
         type Access_To_Subtype_For_Task_Body_Stub is access all Subtype_For_Task_Body_Stub;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Task_Body_Stub);
         package Bare_Task_Body_Stub_Alloc is new Alloc
           (Subtype_For_Task_Body_Stub, Access_To_Subtype_For_Task_Body_Stub);

         function Allocate_Task_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body_Stub;

         function Allocate_Task_Body_Stub
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body_Stub
         is
            Result      : constant Access_To_Subtype_For_Task_Body_Stub := Bare_Task_Body_Stub_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Body_Stub;
            return Bare_Task_Body_Stub (Result);
         end Allocate_Task_Body_Stub;

      package Bare_Entry_Body_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Body, Token_Index);

         
         subtype Subtype_For_Entry_Body is
            Root_Node_Record (Ada_Entry_Body);
         type Access_To_Subtype_For_Entry_Body is access all Subtype_For_Entry_Body;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Entry_Body);
         package Bare_Entry_Body_Alloc is new Alloc
           (Subtype_For_Entry_Body, Access_To_Subtype_For_Entry_Body);

         function Allocate_Entry_Body
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Body;

         function Allocate_Entry_Body
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Body
         is
            Result      : constant Access_To_Subtype_For_Entry_Body := Bare_Entry_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Body;
            return Bare_Entry_Body (Result);
         end Allocate_Entry_Body;

      package Bare_Package_Body_Memos is new Langkit_Support.Packrat
        (Bare_Package_Body, Token_Index);

         
         subtype Subtype_For_Package_Body is
            Root_Node_Record (Ada_Package_Body);
         type Access_To_Subtype_For_Package_Body is access all Subtype_For_Package_Body;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Package_Body);
         package Bare_Package_Body_Alloc is new Alloc
           (Subtype_For_Package_Body, Access_To_Subtype_For_Package_Body);

         function Allocate_Package_Body
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body;

         function Allocate_Package_Body
           (Pool : Bump_Ptr_Pool) return Bare_Package_Body
         is
            Result      : constant Access_To_Subtype_For_Package_Body := Bare_Package_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Body;
            return Bare_Package_Body (Result);
         end Allocate_Package_Body;

      package Bare_Protected_Body_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Body, Token_Index);

         
         subtype Subtype_For_Protected_Body is
            Root_Node_Record (Ada_Protected_Body);
         type Access_To_Subtype_For_Protected_Body is access all Subtype_For_Protected_Body;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Protected_Body);
         package Bare_Protected_Body_Alloc is new Alloc
           (Subtype_For_Protected_Body, Access_To_Subtype_For_Protected_Body);

         function Allocate_Protected_Body
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body;

         function Allocate_Protected_Body
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Body
         is
            Result      : constant Access_To_Subtype_For_Protected_Body := Bare_Protected_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Body;
            return Bare_Protected_Body (Result);
         end Allocate_Protected_Body;

      package Bare_Task_Body_Memos is new Langkit_Support.Packrat
        (Bare_Task_Body, Token_Index);

         
         subtype Subtype_For_Task_Body is
            Root_Node_Record (Ada_Task_Body);
         type Access_To_Subtype_For_Task_Body is access all Subtype_For_Task_Body;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Task_Body);
         package Bare_Task_Body_Alloc is new Alloc
           (Subtype_For_Task_Body, Access_To_Subtype_For_Task_Body);

         function Allocate_Task_Body
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body;

         function Allocate_Task_Body
           (Pool : Bump_Ptr_Pool) return Bare_Task_Body
         is
            Result      : constant Access_To_Subtype_For_Task_Body := Bare_Task_Body_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Body;
            return Bare_Task_Body (Result);
         end Allocate_Task_Body;

      package Bare_Entry_Index_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Entry_Index_Spec, Token_Index);

         
         subtype Subtype_For_Entry_Index_Spec is
            Root_Node_Record (Ada_Entry_Index_Spec);
         type Access_To_Subtype_For_Entry_Index_Spec is access all Subtype_For_Entry_Index_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Entry_Index_Spec);
         package Bare_Entry_Index_Spec_Alloc is new Alloc
           (Subtype_For_Entry_Index_Spec, Access_To_Subtype_For_Entry_Index_Spec);

         function Allocate_Entry_Index_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Index_Spec;

         function Allocate_Entry_Index_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Entry_Index_Spec
         is
            Result      : constant Access_To_Subtype_For_Entry_Index_Spec := Bare_Entry_Index_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Entry_Index_Spec;
            return Bare_Entry_Index_Spec (Result);
         end Allocate_Entry_Index_Spec;

      package Bare_Error_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Error_Decl, Token_Index);

         
         subtype Subtype_For_Error_Decl is
            Root_Node_Record (Ada_Error_Decl);
         type Access_To_Subtype_For_Error_Decl is access all Subtype_For_Error_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Error_Decl);
         package Bare_Error_Decl_Alloc is new Alloc
           (Subtype_For_Error_Decl, Access_To_Subtype_For_Error_Decl);

         function Allocate_Error_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Error_Decl;

         function Allocate_Error_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Error_Decl
         is
            Result      : constant Access_To_Subtype_For_Error_Decl := Bare_Error_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Error_Decl;
            return Bare_Error_Decl (Result);
         end Allocate_Error_Decl;

      package Bare_Exception_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Exception_Decl, Token_Index);

         
         subtype Subtype_For_Exception_Decl is
            Root_Node_Record (Ada_Exception_Decl);
         type Access_To_Subtype_For_Exception_Decl is access all Subtype_For_Exception_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Exception_Decl);
         package Bare_Exception_Decl_Alloc is new Alloc
           (Subtype_For_Exception_Decl, Access_To_Subtype_For_Exception_Decl);

         function Allocate_Exception_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Decl;

         function Allocate_Exception_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Decl
         is
            Result      : constant Access_To_Subtype_For_Exception_Decl := Bare_Exception_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Exception_Decl;
            return Bare_Exception_Decl (Result);
         end Allocate_Exception_Decl;

      package Bare_Exception_Handler_Memos is new Langkit_Support.Packrat
        (Bare_Exception_Handler, Token_Index);

         
         subtype Subtype_For_Exception_Handler is
            Root_Node_Record (Ada_Exception_Handler);
         type Access_To_Subtype_For_Exception_Handler is access all Subtype_For_Exception_Handler;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Exception_Handler);
         package Bare_Exception_Handler_Alloc is new Alloc
           (Subtype_For_Exception_Handler, Access_To_Subtype_For_Exception_Handler);

         function Allocate_Exception_Handler
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Handler;

         function Allocate_Exception_Handler
           (Pool : Bump_Ptr_Pool) return Bare_Exception_Handler
         is
            Result      : constant Access_To_Subtype_For_Exception_Handler := Bare_Exception_Handler_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Exception_Handler;
            return Bare_Exception_Handler (Result);
         end Allocate_Exception_Handler;

      package Bare_For_Loop_Var_Decl_Memos is new Langkit_Support.Packrat
        (Bare_For_Loop_Var_Decl, Token_Index);

         
         subtype Subtype_For_For_Loop_Var_Decl is
            Root_Node_Record (Ada_For_Loop_Var_Decl);
         type Access_To_Subtype_For_For_Loop_Var_Decl is access all Subtype_For_For_Loop_Var_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_For_Loop_Var_Decl);
         package Bare_For_Loop_Var_Decl_Alloc is new Alloc
           (Subtype_For_For_Loop_Var_Decl, Access_To_Subtype_For_For_Loop_Var_Decl);

         function Allocate_For_Loop_Var_Decl
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Var_Decl;

         function Allocate_For_Loop_Var_Decl
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Var_Decl
         is
            Result      : constant Access_To_Subtype_For_For_Loop_Var_Decl := Bare_For_Loop_Var_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_For_Loop_Var_Decl;
            return Bare_For_Loop_Var_Decl (Result);
         end Allocate_For_Loop_Var_Decl;

      package Bare_Generic_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Decl, Token_Index);

      package Bare_Generic_Package_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Package_Decl is
            Root_Node_Record (Ada_Generic_Package_Decl);
         type Access_To_Subtype_For_Generic_Package_Decl is access all Subtype_For_Generic_Package_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Package_Decl);
         package Bare_Generic_Package_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Package_Decl, Access_To_Subtype_For_Generic_Package_Decl);

         function Allocate_Generic_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Decl;

         function Allocate_Generic_Package_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Decl := Bare_Generic_Package_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Decl;
            return Bare_Generic_Package_Decl (Result);
         end Allocate_Generic_Package_Decl;

      package Bare_Generic_Subp_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Decl is
            Root_Node_Record (Ada_Generic_Subp_Decl);
         type Access_To_Subtype_For_Generic_Subp_Decl is access all Subtype_For_Generic_Subp_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Subp_Decl);
         package Bare_Generic_Subp_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Decl, Access_To_Subtype_For_Generic_Subp_Decl);

         function Allocate_Generic_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Decl;

         function Allocate_Generic_Subp_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Decl := Bare_Generic_Subp_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Decl;
            return Bare_Generic_Subp_Decl (Result);
         end Allocate_Generic_Subp_Decl;

      package Bare_Generic_Instantiation_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Instantiation, Token_Index);

      package Bare_Generic_Package_Instantiation_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Instantiation, Token_Index);

         
         subtype Subtype_For_Generic_Package_Instantiation is
            Root_Node_Record (Ada_Generic_Package_Instantiation);
         type Access_To_Subtype_For_Generic_Package_Instantiation is access all Subtype_For_Generic_Package_Instantiation;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Package_Instantiation);
         package Bare_Generic_Package_Instantiation_Alloc is new Alloc
           (Subtype_For_Generic_Package_Instantiation, Access_To_Subtype_For_Generic_Package_Instantiation);

         function Allocate_Generic_Package_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Instantiation;

         function Allocate_Generic_Package_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Instantiation
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Instantiation := Bare_Generic_Package_Instantiation_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Instantiation;
            return Bare_Generic_Package_Instantiation (Result);
         end Allocate_Generic_Package_Instantiation;

      package Bare_Generic_Subp_Instantiation_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Instantiation, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Instantiation is
            Root_Node_Record (Ada_Generic_Subp_Instantiation);
         type Access_To_Subtype_For_Generic_Subp_Instantiation is access all Subtype_For_Generic_Subp_Instantiation;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Subp_Instantiation);
         package Bare_Generic_Subp_Instantiation_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Instantiation, Access_To_Subtype_For_Generic_Subp_Instantiation);

         function Allocate_Generic_Subp_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Instantiation;

         function Allocate_Generic_Subp_Instantiation
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Instantiation
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Instantiation := Bare_Generic_Subp_Instantiation_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Instantiation;
            return Bare_Generic_Subp_Instantiation (Result);
         end Allocate_Generic_Subp_Instantiation;

      package Bare_Generic_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Renaming_Decl, Token_Index);

      package Bare_Generic_Package_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Package_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Package_Renaming_Decl is
            Root_Node_Record (Ada_Generic_Package_Renaming_Decl);
         type Access_To_Subtype_For_Generic_Package_Renaming_Decl is access all Subtype_For_Generic_Package_Renaming_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Package_Renaming_Decl);
         package Bare_Generic_Package_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Package_Renaming_Decl, Access_To_Subtype_For_Generic_Package_Renaming_Decl);

         function Allocate_Generic_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Renaming_Decl;

         function Allocate_Generic_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Package_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Package_Renaming_Decl := Bare_Generic_Package_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Package_Renaming_Decl;
            return Bare_Generic_Package_Renaming_Decl (Result);
         end Allocate_Generic_Package_Renaming_Decl;

      package Bare_Generic_Subp_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Generic_Subp_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Generic_Subp_Renaming_Decl is
            Root_Node_Record (Ada_Generic_Subp_Renaming_Decl);
         type Access_To_Subtype_For_Generic_Subp_Renaming_Decl is access all Subtype_For_Generic_Subp_Renaming_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Generic_Subp_Renaming_Decl);
         package Bare_Generic_Subp_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Generic_Subp_Renaming_Decl, Access_To_Subtype_For_Generic_Subp_Renaming_Decl);

         function Allocate_Generic_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Renaming_Decl;

         function Allocate_Generic_Subp_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Generic_Subp_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Generic_Subp_Renaming_Decl := Bare_Generic_Subp_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Generic_Subp_Renaming_Decl;
            return Bare_Generic_Subp_Renaming_Decl (Result);
         end Allocate_Generic_Subp_Renaming_Decl;

      package Bare_Label_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Label_Decl, Token_Index);

         
         subtype Subtype_For_Label_Decl is
            Root_Node_Record (Ada_Label_Decl);
         type Access_To_Subtype_For_Label_Decl is access all Subtype_For_Label_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Label_Decl);
         package Bare_Label_Decl_Alloc is new Alloc
           (Subtype_For_Label_Decl, Access_To_Subtype_For_Label_Decl);

         function Allocate_Label_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Label_Decl;

         function Allocate_Label_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Label_Decl
         is
            Result      : constant Access_To_Subtype_For_Label_Decl := Bare_Label_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Label_Decl;
            return Bare_Label_Decl (Result);
         end Allocate_Label_Decl;

      package Bare_Named_Stmt_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Named_Stmt_Decl, Token_Index);

         
         subtype Subtype_For_Named_Stmt_Decl is
            Root_Node_Record (Ada_Named_Stmt_Decl);
         type Access_To_Subtype_For_Named_Stmt_Decl is access all Subtype_For_Named_Stmt_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Named_Stmt_Decl);
         package Bare_Named_Stmt_Decl_Alloc is new Alloc
           (Subtype_For_Named_Stmt_Decl, Access_To_Subtype_For_Named_Stmt_Decl);

         function Allocate_Named_Stmt_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt_Decl;

         function Allocate_Named_Stmt_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt_Decl
         is
            Result      : constant Access_To_Subtype_For_Named_Stmt_Decl := Bare_Named_Stmt_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Named_Stmt_Decl;
            return Bare_Named_Stmt_Decl (Result);
         end Allocate_Named_Stmt_Decl;

      package Bare_Number_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Number_Decl, Token_Index);

         
         subtype Subtype_For_Number_Decl is
            Root_Node_Record (Ada_Number_Decl);
         type Access_To_Subtype_For_Number_Decl is access all Subtype_For_Number_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Number_Decl);
         package Bare_Number_Decl_Alloc is new Alloc
           (Subtype_For_Number_Decl, Access_To_Subtype_For_Number_Decl);

         function Allocate_Number_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Number_Decl;

         function Allocate_Number_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Number_Decl
         is
            Result      : constant Access_To_Subtype_For_Number_Decl := Bare_Number_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Number_Decl;
            return Bare_Number_Decl (Result);
         end Allocate_Number_Decl;

      package Bare_Object_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Object_Decl, Token_Index);

         
         subtype Subtype_For_Object_Decl is
            Root_Node_Record (Ada_Object_Decl);
         type Access_To_Subtype_For_Object_Decl is access all Subtype_For_Object_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Object_Decl);
         package Bare_Object_Decl_Alloc is new Alloc
           (Subtype_For_Object_Decl, Access_To_Subtype_For_Object_Decl);

         function Allocate_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Object_Decl;

         function Allocate_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Object_Decl
         is
            Result      : constant Access_To_Subtype_For_Object_Decl := Bare_Object_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Object_Decl;
            return Bare_Object_Decl (Result);
         end Allocate_Object_Decl;

      package Bare_Extended_Return_Stmt_Object_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Extended_Return_Stmt_Object_Decl, Token_Index);

         
         subtype Subtype_For_Extended_Return_Stmt_Object_Decl is
            Root_Node_Record (Ada_Extended_Return_Stmt_Object_Decl);
         type Access_To_Subtype_For_Extended_Return_Stmt_Object_Decl is access all Subtype_For_Extended_Return_Stmt_Object_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Extended_Return_Stmt_Object_Decl);
         package Bare_Extended_Return_Stmt_Object_Decl_Alloc is new Alloc
           (Subtype_For_Extended_Return_Stmt_Object_Decl, Access_To_Subtype_For_Extended_Return_Stmt_Object_Decl);

         function Allocate_Extended_Return_Stmt_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt_Object_Decl;

         function Allocate_Extended_Return_Stmt_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt_Object_Decl
         is
            Result      : constant Access_To_Subtype_For_Extended_Return_Stmt_Object_Decl := Bare_Extended_Return_Stmt_Object_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Extended_Return_Stmt_Object_Decl;
            return Bare_Extended_Return_Stmt_Object_Decl (Result);
         end Allocate_Extended_Return_Stmt_Object_Decl;

      package Bare_No_Type_Object_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_No_Type_Object_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_No_Type_Object_Renaming_Decl is
            Root_Node_Record (Ada_No_Type_Object_Renaming_Decl);
         type Access_To_Subtype_For_No_Type_Object_Renaming_Decl is access all Subtype_For_No_Type_Object_Renaming_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_No_Type_Object_Renaming_Decl);
         package Bare_No_Type_Object_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_No_Type_Object_Renaming_Decl, Access_To_Subtype_For_No_Type_Object_Renaming_Decl);

         function Allocate_No_Type_Object_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_No_Type_Object_Renaming_Decl;

         function Allocate_No_Type_Object_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_No_Type_Object_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_No_Type_Object_Renaming_Decl := Bare_No_Type_Object_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_No_Type_Object_Renaming_Decl;
            return Bare_No_Type_Object_Renaming_Decl (Result);
         end Allocate_No_Type_Object_Renaming_Decl;

      package Bare_Package_Renaming_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Package_Renaming_Decl, Token_Index);

         
         subtype Subtype_For_Package_Renaming_Decl is
            Root_Node_Record (Ada_Package_Renaming_Decl);
         type Access_To_Subtype_For_Package_Renaming_Decl is access all Subtype_For_Package_Renaming_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Package_Renaming_Decl);
         package Bare_Package_Renaming_Decl_Alloc is new Alloc
           (Subtype_For_Package_Renaming_Decl, Access_To_Subtype_For_Package_Renaming_Decl);

         function Allocate_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Renaming_Decl;

         function Allocate_Package_Renaming_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Package_Renaming_Decl
         is
            Result      : constant Access_To_Subtype_For_Package_Renaming_Decl := Bare_Package_Renaming_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Package_Renaming_Decl;
            return Bare_Package_Renaming_Decl (Result);
         end Allocate_Package_Renaming_Decl;

      package Bare_Single_Protected_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Single_Protected_Decl, Token_Index);

         
         subtype Subtype_For_Single_Protected_Decl is
            Root_Node_Record (Ada_Single_Protected_Decl);
         type Access_To_Subtype_For_Single_Protected_Decl is access all Subtype_For_Single_Protected_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Single_Protected_Decl);
         package Bare_Single_Protected_Decl_Alloc is new Alloc
           (Subtype_For_Single_Protected_Decl, Access_To_Subtype_For_Single_Protected_Decl);

         function Allocate_Single_Protected_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Protected_Decl;

         function Allocate_Single_Protected_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Protected_Decl
         is
            Result      : constant Access_To_Subtype_For_Single_Protected_Decl := Bare_Single_Protected_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Single_Protected_Decl;
            return Bare_Single_Protected_Decl (Result);
         end Allocate_Single_Protected_Decl;

      package Bare_Single_Task_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Single_Task_Decl, Token_Index);

         
         subtype Subtype_For_Single_Task_Decl is
            Root_Node_Record (Ada_Single_Task_Decl);
         type Access_To_Subtype_For_Single_Task_Decl is access all Subtype_For_Single_Task_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Single_Task_Decl);
         package Bare_Single_Task_Decl_Alloc is new Alloc
           (Subtype_For_Single_Task_Decl, Access_To_Subtype_For_Single_Task_Decl);

         function Allocate_Single_Task_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Decl;

         function Allocate_Single_Task_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Single_Task_Decl
         is
            Result      : constant Access_To_Subtype_For_Single_Task_Decl := Bare_Single_Task_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Single_Task_Decl;
            return Bare_Single_Task_Decl (Result);
         end Allocate_Single_Task_Decl;

      package Bare_Synthetic_Object_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Object_Decl, Token_Index);

         
         subtype Subtype_For_Synthetic_Object_Decl is
            Root_Node_Record (Ada_Synthetic_Object_Decl);
         type Access_To_Subtype_For_Synthetic_Object_Decl is access all Subtype_For_Synthetic_Object_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Object_Decl);
         package Bare_Synthetic_Object_Decl_Alloc is new Alloc
           (Subtype_For_Synthetic_Object_Decl, Access_To_Subtype_For_Synthetic_Object_Decl);

         function Allocate_Synthetic_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Object_Decl;

         function Allocate_Synthetic_Object_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Object_Decl
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Object_Decl := Bare_Synthetic_Object_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Object_Decl;
            return Bare_Synthetic_Object_Decl (Result);
         end Allocate_Synthetic_Object_Decl;

      package Bare_Case_Stmt_Alternative_Memos is new Langkit_Support.Packrat
        (Bare_Case_Stmt_Alternative, Token_Index);

         
         subtype Subtype_For_Case_Stmt_Alternative is
            Root_Node_Record (Ada_Case_Stmt_Alternative);
         type Access_To_Subtype_For_Case_Stmt_Alternative is access all Subtype_For_Case_Stmt_Alternative;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Case_Stmt_Alternative);
         package Bare_Case_Stmt_Alternative_Alloc is new Alloc
           (Subtype_For_Case_Stmt_Alternative, Access_To_Subtype_For_Case_Stmt_Alternative);

         function Allocate_Case_Stmt_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative;

         function Allocate_Case_Stmt_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt_Alternative
         is
            Result      : constant Access_To_Subtype_For_Case_Stmt_Alternative := Bare_Case_Stmt_Alternative_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Stmt_Alternative;
            return Bare_Case_Stmt_Alternative (Result);
         end Allocate_Case_Stmt_Alternative;

      package Bare_Compilation_Unit_Memos is new Langkit_Support.Packrat
        (Bare_Compilation_Unit, Token_Index);

         
         subtype Subtype_For_Compilation_Unit is
            Root_Node_Record (Ada_Compilation_Unit);
         type Access_To_Subtype_For_Compilation_Unit is access all Subtype_For_Compilation_Unit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Compilation_Unit);
         package Bare_Compilation_Unit_Alloc is new Alloc
           (Subtype_For_Compilation_Unit, Access_To_Subtype_For_Compilation_Unit);

         function Allocate_Compilation_Unit
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit;

         function Allocate_Compilation_Unit
           (Pool : Bump_Ptr_Pool) return Bare_Compilation_Unit
         is
            Result      : constant Access_To_Subtype_For_Compilation_Unit := Bare_Compilation_Unit_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Compilation_Unit;
            return Bare_Compilation_Unit (Result);
         end Allocate_Compilation_Unit;

      package Bare_Component_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Component_Clause, Token_Index);

         
         subtype Subtype_For_Component_Clause is
            Root_Node_Record (Ada_Component_Clause);
         type Access_To_Subtype_For_Component_Clause is access all Subtype_For_Component_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Component_Clause);
         package Bare_Component_Clause_Alloc is new Alloc
           (Subtype_For_Component_Clause, Access_To_Subtype_For_Component_Clause);

         function Allocate_Component_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Component_Clause;

         function Allocate_Component_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Component_Clause
         is
            Result      : constant Access_To_Subtype_For_Component_Clause := Bare_Component_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_Clause;
            return Bare_Component_Clause (Result);
         end Allocate_Component_Clause;

      package Bare_Component_Def_Memos is new Langkit_Support.Packrat
        (Bare_Component_Def, Token_Index);

         
         subtype Subtype_For_Component_Def is
            Root_Node_Record (Ada_Component_Def);
         type Access_To_Subtype_For_Component_Def is access all Subtype_For_Component_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Component_Def);
         package Bare_Component_Def_Alloc is new Alloc
           (Subtype_For_Component_Def, Access_To_Subtype_For_Component_Def);

         function Allocate_Component_Def
           (Pool : Bump_Ptr_Pool) return Bare_Component_Def;

         function Allocate_Component_Def
           (Pool : Bump_Ptr_Pool) return Bare_Component_Def
         is
            Result      : constant Access_To_Subtype_For_Component_Def := Bare_Component_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Component_Def;
            return Bare_Component_Def (Result);
         end Allocate_Component_Def;

      package Bare_Constant_Node_Memos is new Langkit_Support.Packrat
        (Bare_Constant_Node, Token_Index);

      package Bare_Constant_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Constant_Absent, Token_Index);

         
         subtype Subtype_For_Constant_Absent is
            Root_Node_Record (Ada_Constant_Absent);
         type Access_To_Subtype_For_Constant_Absent is access all Subtype_For_Constant_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Constant_Absent);
         package Bare_Constant_Absent_Alloc is new Alloc
           (Subtype_For_Constant_Absent, Access_To_Subtype_For_Constant_Absent);

         function Allocate_Constant_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Absent;

         function Allocate_Constant_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Absent
         is
            Result      : constant Access_To_Subtype_For_Constant_Absent := Bare_Constant_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constant_Absent;
            return Bare_Constant_Absent (Result);
         end Allocate_Constant_Absent;

      package Bare_Constant_Present_Memos is new Langkit_Support.Packrat
        (Bare_Constant_Present, Token_Index);

         
         subtype Subtype_For_Constant_Present is
            Root_Node_Record (Ada_Constant_Present);
         type Access_To_Subtype_For_Constant_Present is access all Subtype_For_Constant_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Constant_Present);
         package Bare_Constant_Present_Alloc is new Alloc
           (Subtype_For_Constant_Present, Access_To_Subtype_For_Constant_Present);

         function Allocate_Constant_Present
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Present;

         function Allocate_Constant_Present
           (Pool : Bump_Ptr_Pool) return Bare_Constant_Present
         is
            Result      : constant Access_To_Subtype_For_Constant_Present := Bare_Constant_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constant_Present;
            return Bare_Constant_Present (Result);
         end Allocate_Constant_Present;

      package Bare_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Constraint, Token_Index);

      package Bare_Composite_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Composite_Constraint, Token_Index);

         
         subtype Subtype_For_Composite_Constraint is
            Root_Node_Record (Ada_Composite_Constraint);
         type Access_To_Subtype_For_Composite_Constraint is access all Subtype_For_Composite_Constraint;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Composite_Constraint);
         package Bare_Composite_Constraint_Alloc is new Alloc
           (Subtype_For_Composite_Constraint, Access_To_Subtype_For_Composite_Constraint);

         function Allocate_Composite_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Composite_Constraint;

         function Allocate_Composite_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Composite_Constraint
         is
            Result      : constant Access_To_Subtype_For_Composite_Constraint := Bare_Composite_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Composite_Constraint;
            return Bare_Composite_Constraint (Result);
         end Allocate_Composite_Constraint;

      package Bare_Delta_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Delta_Constraint, Token_Index);

         
         subtype Subtype_For_Delta_Constraint is
            Root_Node_Record (Ada_Delta_Constraint);
         type Access_To_Subtype_For_Delta_Constraint is access all Subtype_For_Delta_Constraint;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Delta_Constraint);
         package Bare_Delta_Constraint_Alloc is new Alloc
           (Subtype_For_Delta_Constraint, Access_To_Subtype_For_Delta_Constraint);

         function Allocate_Delta_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Constraint;

         function Allocate_Delta_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Constraint
         is
            Result      : constant Access_To_Subtype_For_Delta_Constraint := Bare_Delta_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Delta_Constraint;
            return Bare_Delta_Constraint (Result);
         end Allocate_Delta_Constraint;

      package Bare_Digits_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Digits_Constraint, Token_Index);

         
         subtype Subtype_For_Digits_Constraint is
            Root_Node_Record (Ada_Digits_Constraint);
         type Access_To_Subtype_For_Digits_Constraint is access all Subtype_For_Digits_Constraint;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Digits_Constraint);
         package Bare_Digits_Constraint_Alloc is new Alloc
           (Subtype_For_Digits_Constraint, Access_To_Subtype_For_Digits_Constraint);

         function Allocate_Digits_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Digits_Constraint;

         function Allocate_Digits_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Digits_Constraint
         is
            Result      : constant Access_To_Subtype_For_Digits_Constraint := Bare_Digits_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Digits_Constraint;
            return Bare_Digits_Constraint (Result);
         end Allocate_Digits_Constraint;

      package Bare_Range_Constraint_Memos is new Langkit_Support.Packrat
        (Bare_Range_Constraint, Token_Index);

         
         subtype Subtype_For_Range_Constraint is
            Root_Node_Record (Ada_Range_Constraint);
         type Access_To_Subtype_For_Range_Constraint is access all Subtype_For_Range_Constraint;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Range_Constraint);
         package Bare_Range_Constraint_Alloc is new Alloc
           (Subtype_For_Range_Constraint, Access_To_Subtype_For_Range_Constraint);

         function Allocate_Range_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Range_Constraint;

         function Allocate_Range_Constraint
           (Pool : Bump_Ptr_Pool) return Bare_Range_Constraint
         is
            Result      : constant Access_To_Subtype_For_Range_Constraint := Bare_Range_Constraint_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Range_Constraint;
            return Bare_Range_Constraint (Result);
         end Allocate_Range_Constraint;

      package Bare_Declarative_Part_Memos is new Langkit_Support.Packrat
        (Bare_Declarative_Part, Token_Index);

         
         subtype Subtype_For_Declarative_Part is
            Root_Node_Record (Ada_Declarative_Part);
         type Access_To_Subtype_For_Declarative_Part is access all Subtype_For_Declarative_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Declarative_Part);
         package Bare_Declarative_Part_Alloc is new Alloc
           (Subtype_For_Declarative_Part, Access_To_Subtype_For_Declarative_Part);

         function Allocate_Declarative_Part
           (Pool : Bump_Ptr_Pool) return Bare_Declarative_Part;

         function Allocate_Declarative_Part
           (Pool : Bump_Ptr_Pool) return Bare_Declarative_Part
         is
            Result      : constant Access_To_Subtype_For_Declarative_Part := Bare_Declarative_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Declarative_Part;
            return Bare_Declarative_Part (Result);
         end Allocate_Declarative_Part;

      package Bare_Private_Part_Memos is new Langkit_Support.Packrat
        (Bare_Private_Part, Token_Index);

         
         subtype Subtype_For_Private_Part is
            Root_Node_Record (Ada_Private_Part);
         type Access_To_Subtype_For_Private_Part is access all Subtype_For_Private_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Private_Part);
         package Bare_Private_Part_Alloc is new Alloc
           (Subtype_For_Private_Part, Access_To_Subtype_For_Private_Part);

         function Allocate_Private_Part
           (Pool : Bump_Ptr_Pool) return Bare_Private_Part;

         function Allocate_Private_Part
           (Pool : Bump_Ptr_Pool) return Bare_Private_Part
         is
            Result      : constant Access_To_Subtype_For_Private_Part := Bare_Private_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Part;
            return Bare_Private_Part (Result);
         end Allocate_Private_Part;

      package Bare_Public_Part_Memos is new Langkit_Support.Packrat
        (Bare_Public_Part, Token_Index);

         
         subtype Subtype_For_Public_Part is
            Root_Node_Record (Ada_Public_Part);
         type Access_To_Subtype_For_Public_Part is access all Subtype_For_Public_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Public_Part);
         package Bare_Public_Part_Alloc is new Alloc
           (Subtype_For_Public_Part, Access_To_Subtype_For_Public_Part);

         function Allocate_Public_Part
           (Pool : Bump_Ptr_Pool) return Bare_Public_Part;

         function Allocate_Public_Part
           (Pool : Bump_Ptr_Pool) return Bare_Public_Part
         is
            Result      : constant Access_To_Subtype_For_Public_Part := Bare_Public_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Public_Part;
            return Bare_Public_Part (Result);
         end Allocate_Public_Part;

      package Bare_Elsif_Expr_Part_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Expr_Part, Token_Index);

         
         subtype Subtype_For_Elsif_Expr_Part is
            Root_Node_Record (Ada_Elsif_Expr_Part);
         type Access_To_Subtype_For_Elsif_Expr_Part is access all Subtype_For_Elsif_Expr_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Elsif_Expr_Part);
         package Bare_Elsif_Expr_Part_Alloc is new Alloc
           (Subtype_For_Elsif_Expr_Part, Access_To_Subtype_For_Elsif_Expr_Part);

         function Allocate_Elsif_Expr_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part;

         function Allocate_Elsif_Expr_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Expr_Part
         is
            Result      : constant Access_To_Subtype_For_Elsif_Expr_Part := Bare_Elsif_Expr_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Expr_Part;
            return Bare_Elsif_Expr_Part (Result);
         end Allocate_Elsif_Expr_Part;

      package Bare_Elsif_Stmt_Part_Memos is new Langkit_Support.Packrat
        (Bare_Elsif_Stmt_Part, Token_Index);

         
         subtype Subtype_For_Elsif_Stmt_Part is
            Root_Node_Record (Ada_Elsif_Stmt_Part);
         type Access_To_Subtype_For_Elsif_Stmt_Part is access all Subtype_For_Elsif_Stmt_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Elsif_Stmt_Part);
         package Bare_Elsif_Stmt_Part_Alloc is new Alloc
           (Subtype_For_Elsif_Stmt_Part, Access_To_Subtype_For_Elsif_Stmt_Part);

         function Allocate_Elsif_Stmt_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part;

         function Allocate_Elsif_Stmt_Part
           (Pool : Bump_Ptr_Pool) return Bare_Elsif_Stmt_Part
         is
            Result      : constant Access_To_Subtype_For_Elsif_Stmt_Part := Bare_Elsif_Stmt_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Elsif_Stmt_Part;
            return Bare_Elsif_Stmt_Part (Result);
         end Allocate_Elsif_Stmt_Part;

      package Bare_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Expr, Token_Index);

      package Bare_Abstract_State_Decl_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Abstract_State_Decl_Expr, Token_Index);

         
         subtype Subtype_For_Abstract_State_Decl_Expr is
            Root_Node_Record (Ada_Abstract_State_Decl_Expr);
         type Access_To_Subtype_For_Abstract_State_Decl_Expr is access all Subtype_For_Abstract_State_Decl_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abstract_State_Decl_Expr);
         package Bare_Abstract_State_Decl_Expr_Alloc is new Alloc
           (Subtype_For_Abstract_State_Decl_Expr, Access_To_Subtype_For_Abstract_State_Decl_Expr);

         function Allocate_Abstract_State_Decl_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_State_Decl_Expr;

         function Allocate_Abstract_State_Decl_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Abstract_State_Decl_Expr
         is
            Result      : constant Access_To_Subtype_For_Abstract_State_Decl_Expr := Bare_Abstract_State_Decl_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abstract_State_Decl_Expr;
            return Bare_Abstract_State_Decl_Expr (Result);
         end Allocate_Abstract_State_Decl_Expr;

      package Bare_Allocator_Memos is new Langkit_Support.Packrat
        (Bare_Allocator, Token_Index);

         
         subtype Subtype_For_Allocator is
            Root_Node_Record (Ada_Allocator);
         type Access_To_Subtype_For_Allocator is access all Subtype_For_Allocator;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Allocator);
         package Bare_Allocator_Alloc is new Alloc
           (Subtype_For_Allocator, Access_To_Subtype_For_Allocator);

         function Allocate_Allocator
           (Pool : Bump_Ptr_Pool) return Bare_Allocator;

         function Allocate_Allocator
           (Pool : Bump_Ptr_Pool) return Bare_Allocator
         is
            Result      : constant Access_To_Subtype_For_Allocator := Bare_Allocator_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Allocator;
            return Bare_Allocator (Result);
         end Allocate_Allocator;

      package Bare_Base_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Base_Aggregate, Token_Index);

      package Bare_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Aggregate, Token_Index);

         
         subtype Subtype_For_Aggregate is
            Root_Node_Record (Ada_Aggregate);
         type Access_To_Subtype_For_Aggregate is access all Subtype_For_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Aggregate);
         package Bare_Aggregate_Alloc is new Alloc
           (Subtype_For_Aggregate, Access_To_Subtype_For_Aggregate);

         function Allocate_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate;

         function Allocate_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Aggregate := Bare_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Aggregate;
            return Bare_Aggregate (Result);
         end Allocate_Aggregate;

      package Bare_Bracket_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Bracket_Aggregate, Token_Index);

         
         subtype Subtype_For_Bracket_Aggregate is
            Root_Node_Record (Ada_Bracket_Aggregate);
         type Access_To_Subtype_For_Bracket_Aggregate is access all Subtype_For_Bracket_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Bracket_Aggregate);
         package Bare_Bracket_Aggregate_Alloc is new Alloc
           (Subtype_For_Bracket_Aggregate, Access_To_Subtype_For_Bracket_Aggregate);

         function Allocate_Bracket_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Aggregate;

         function Allocate_Bracket_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Bracket_Aggregate := Bare_Bracket_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Bracket_Aggregate;
            return Bare_Bracket_Aggregate (Result);
         end Allocate_Bracket_Aggregate;

      package Bare_Delta_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Delta_Aggregate, Token_Index);

         
         subtype Subtype_For_Delta_Aggregate is
            Root_Node_Record (Ada_Delta_Aggregate);
         type Access_To_Subtype_For_Delta_Aggregate is access all Subtype_For_Delta_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Delta_Aggregate);
         package Bare_Delta_Aggregate_Alloc is new Alloc
           (Subtype_For_Delta_Aggregate, Access_To_Subtype_For_Delta_Aggregate);

         function Allocate_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Aggregate;

         function Allocate_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Delta_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Delta_Aggregate := Bare_Delta_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Delta_Aggregate;
            return Bare_Delta_Aggregate (Result);
         end Allocate_Delta_Aggregate;

      package Bare_Bracket_Delta_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Bracket_Delta_Aggregate, Token_Index);

         
         subtype Subtype_For_Bracket_Delta_Aggregate is
            Root_Node_Record (Ada_Bracket_Delta_Aggregate);
         type Access_To_Subtype_For_Bracket_Delta_Aggregate is access all Subtype_For_Bracket_Delta_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Bracket_Delta_Aggregate);
         package Bare_Bracket_Delta_Aggregate_Alloc is new Alloc
           (Subtype_For_Bracket_Delta_Aggregate, Access_To_Subtype_For_Bracket_Delta_Aggregate);

         function Allocate_Bracket_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Delta_Aggregate;

         function Allocate_Bracket_Delta_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Bracket_Delta_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Bracket_Delta_Aggregate := Bare_Bracket_Delta_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Bracket_Delta_Aggregate;
            return Bare_Bracket_Delta_Aggregate (Result);
         end Allocate_Bracket_Delta_Aggregate;

      package Bare_Null_Record_Aggregate_Memos is new Langkit_Support.Packrat
        (Bare_Null_Record_Aggregate, Token_Index);

         
         subtype Subtype_For_Null_Record_Aggregate is
            Root_Node_Record (Ada_Null_Record_Aggregate);
         type Access_To_Subtype_For_Null_Record_Aggregate is access all Subtype_For_Null_Record_Aggregate;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Record_Aggregate);
         package Bare_Null_Record_Aggregate_Alloc is new Alloc
           (Subtype_For_Null_Record_Aggregate, Access_To_Subtype_For_Null_Record_Aggregate);

         function Allocate_Null_Record_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Aggregate;

         function Allocate_Null_Record_Aggregate
           (Pool : Bump_Ptr_Pool) return Bare_Null_Record_Aggregate
         is
            Result      : constant Access_To_Subtype_For_Null_Record_Aggregate := Bare_Null_Record_Aggregate_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Record_Aggregate;
            return Bare_Null_Record_Aggregate (Result);
         end Allocate_Null_Record_Aggregate;

      package Bare_Bin_Op_Memos is new Langkit_Support.Packrat
        (Bare_Bin_Op, Token_Index);

         
         subtype Subtype_For_Bin_Op is
            Root_Node_Record (Ada_Bin_Op);
         type Access_To_Subtype_For_Bin_Op is access all Subtype_For_Bin_Op;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Bin_Op);
         package Bare_Bin_Op_Alloc is new Alloc
           (Subtype_For_Bin_Op, Access_To_Subtype_For_Bin_Op);

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op;

         function Allocate_Bin_Op
           (Pool : Bump_Ptr_Pool) return Bare_Bin_Op
         is
            Result      : constant Access_To_Subtype_For_Bin_Op := Bare_Bin_Op_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Bin_Op;
            return Bare_Bin_Op (Result);
         end Allocate_Bin_Op;

      package Bare_Relation_Op_Memos is new Langkit_Support.Packrat
        (Bare_Relation_Op, Token_Index);

         
         subtype Subtype_For_Relation_Op is
            Root_Node_Record (Ada_Relation_Op);
         type Access_To_Subtype_For_Relation_Op is access all Subtype_For_Relation_Op;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Relation_Op);
         package Bare_Relation_Op_Alloc is new Alloc
           (Subtype_For_Relation_Op, Access_To_Subtype_For_Relation_Op);

         function Allocate_Relation_Op
           (Pool : Bump_Ptr_Pool) return Bare_Relation_Op;

         function Allocate_Relation_Op
           (Pool : Bump_Ptr_Pool) return Bare_Relation_Op
         is
            Result      : constant Access_To_Subtype_For_Relation_Op := Bare_Relation_Op_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Relation_Op;
            return Bare_Relation_Op (Result);
         end Allocate_Relation_Op;

      package Bare_Box_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Box_Expr, Token_Index);

         
         subtype Subtype_For_Box_Expr is
            Root_Node_Record (Ada_Box_Expr);
         type Access_To_Subtype_For_Box_Expr is access all Subtype_For_Box_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Box_Expr);
         package Bare_Box_Expr_Alloc is new Alloc
           (Subtype_For_Box_Expr, Access_To_Subtype_For_Box_Expr);

         function Allocate_Box_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Box_Expr;

         function Allocate_Box_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Box_Expr
         is
            Result      : constant Access_To_Subtype_For_Box_Expr := Bare_Box_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Box_Expr;
            return Bare_Box_Expr (Result);
         end Allocate_Box_Expr;

      package Bare_Case_Expr_Alternative_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expr_Alternative, Token_Index);

         
         subtype Subtype_For_Case_Expr_Alternative is
            Root_Node_Record (Ada_Case_Expr_Alternative);
         type Access_To_Subtype_For_Case_Expr_Alternative is access all Subtype_For_Case_Expr_Alternative;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Case_Expr_Alternative);
         package Bare_Case_Expr_Alternative_Alloc is new Alloc
           (Subtype_For_Case_Expr_Alternative, Access_To_Subtype_For_Case_Expr_Alternative);

         function Allocate_Case_Expr_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative;

         function Allocate_Case_Expr_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr_Alternative
         is
            Result      : constant Access_To_Subtype_For_Case_Expr_Alternative := Bare_Case_Expr_Alternative_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Expr_Alternative;
            return Bare_Case_Expr_Alternative (Result);
         end Allocate_Case_Expr_Alternative;

      package Bare_Concat_Op_Memos is new Langkit_Support.Packrat
        (Bare_Concat_Op, Token_Index);

         
         subtype Subtype_For_Concat_Op is
            Root_Node_Record (Ada_Concat_Op);
         type Access_To_Subtype_For_Concat_Op is access all Subtype_For_Concat_Op;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Concat_Op);
         package Bare_Concat_Op_Alloc is new Alloc
           (Subtype_For_Concat_Op, Access_To_Subtype_For_Concat_Op);

         function Allocate_Concat_Op
           (Pool : Bump_Ptr_Pool) return Bare_Concat_Op;

         function Allocate_Concat_Op
           (Pool : Bump_Ptr_Pool) return Bare_Concat_Op
         is
            Result      : constant Access_To_Subtype_For_Concat_Op := Bare_Concat_Op_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Concat_Op;
            return Bare_Concat_Op (Result);
         end Allocate_Concat_Op;

      package Bare_Concat_Operand_Memos is new Langkit_Support.Packrat
        (Bare_Concat_Operand, Token_Index);

         
         subtype Subtype_For_Concat_Operand is
            Root_Node_Record (Ada_Concat_Operand);
         type Access_To_Subtype_For_Concat_Operand is access all Subtype_For_Concat_Operand;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Concat_Operand);
         package Bare_Concat_Operand_Alloc is new Alloc
           (Subtype_For_Concat_Operand, Access_To_Subtype_For_Concat_Operand);

         function Allocate_Concat_Operand
           (Pool : Bump_Ptr_Pool) return Bare_Concat_Operand;

         function Allocate_Concat_Operand
           (Pool : Bump_Ptr_Pool) return Bare_Concat_Operand
         is
            Result      : constant Access_To_Subtype_For_Concat_Operand := Bare_Concat_Operand_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Concat_Operand;
            return Bare_Concat_Operand (Result);
         end Allocate_Concat_Operand;

      package Bare_Cond_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Cond_Expr, Token_Index);

      package Bare_Case_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Case_Expr, Token_Index);

         
         subtype Subtype_For_Case_Expr is
            Root_Node_Record (Ada_Case_Expr);
         type Access_To_Subtype_For_Case_Expr is access all Subtype_For_Case_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Case_Expr);
         package Bare_Case_Expr_Alloc is new Alloc
           (Subtype_For_Case_Expr, Access_To_Subtype_For_Case_Expr);

         function Allocate_Case_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr;

         function Allocate_Case_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Case_Expr
         is
            Result      : constant Access_To_Subtype_For_Case_Expr := Bare_Case_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Expr;
            return Bare_Case_Expr (Result);
         end Allocate_Case_Expr;

      package Bare_If_Expr_Memos is new Langkit_Support.Packrat
        (Bare_If_Expr, Token_Index);

         
         subtype Subtype_For_If_Expr is
            Root_Node_Record (Ada_If_Expr);
         type Access_To_Subtype_For_If_Expr is access all Subtype_For_If_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_If_Expr);
         package Bare_If_Expr_Alloc is new Alloc
           (Subtype_For_If_Expr, Access_To_Subtype_For_If_Expr);

         function Allocate_If_Expr
           (Pool : Bump_Ptr_Pool) return Bare_If_Expr;

         function Allocate_If_Expr
           (Pool : Bump_Ptr_Pool) return Bare_If_Expr
         is
            Result      : constant Access_To_Subtype_For_If_Expr := Bare_If_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_If_Expr;
            return Bare_If_Expr (Result);
         end Allocate_If_Expr;

      package Bare_Contract_Cases_Memos is new Langkit_Support.Packrat
        (Bare_Contract_Cases, Token_Index);

         
         subtype Subtype_For_Contract_Cases is
            Root_Node_Record (Ada_Contract_Cases);
         type Access_To_Subtype_For_Contract_Cases is access all Subtype_For_Contract_Cases;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Contract_Cases);
         package Bare_Contract_Cases_Alloc is new Alloc
           (Subtype_For_Contract_Cases, Access_To_Subtype_For_Contract_Cases);

         function Allocate_Contract_Cases
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Cases;

         function Allocate_Contract_Cases
           (Pool : Bump_Ptr_Pool) return Bare_Contract_Cases
         is
            Result      : constant Access_To_Subtype_For_Contract_Cases := Bare_Contract_Cases_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Contract_Cases;
            return Bare_Contract_Cases (Result);
         end Allocate_Contract_Cases;

      package Bare_Decl_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Decl_Expr, Token_Index);

         
         subtype Subtype_For_Decl_Expr is
            Root_Node_Record (Ada_Decl_Expr);
         type Access_To_Subtype_For_Decl_Expr is access all Subtype_For_Decl_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decl_Expr);
         package Bare_Decl_Expr_Alloc is new Alloc
           (Subtype_For_Decl_Expr, Access_To_Subtype_For_Decl_Expr);

         function Allocate_Decl_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Expr;

         function Allocate_Decl_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Expr
         is
            Result      : constant Access_To_Subtype_For_Decl_Expr := Bare_Decl_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decl_Expr;
            return Bare_Decl_Expr (Result);
         end Allocate_Decl_Expr;

      package Bare_Format_String_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Literal, Token_Index);

         
         subtype Subtype_For_Format_String_Literal is
            Root_Node_Record (Ada_Format_String_Literal);
         type Access_To_Subtype_For_Format_String_Literal is access all Subtype_For_Format_String_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Format_String_Literal);
         package Bare_Format_String_Literal_Alloc is new Alloc
           (Subtype_For_Format_String_Literal, Access_To_Subtype_For_Format_String_Literal);

         function Allocate_Format_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Literal;

         function Allocate_Format_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Literal
         is
            Result      : constant Access_To_Subtype_For_Format_String_Literal := Bare_Format_String_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Format_String_Literal;
            return Bare_Format_String_Literal (Result);
         end Allocate_Format_String_Literal;

      package Bare_Membership_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Membership_Expr, Token_Index);

         
         subtype Subtype_For_Membership_Expr is
            Root_Node_Record (Ada_Membership_Expr);
         type Access_To_Subtype_For_Membership_Expr is access all Subtype_For_Membership_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Membership_Expr);
         package Bare_Membership_Expr_Alloc is new Alloc
           (Subtype_For_Membership_Expr, Access_To_Subtype_For_Membership_Expr);

         function Allocate_Membership_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Membership_Expr;

         function Allocate_Membership_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Membership_Expr
         is
            Result      : constant Access_To_Subtype_For_Membership_Expr := Bare_Membership_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Membership_Expr;
            return Bare_Membership_Expr (Result);
         end Allocate_Membership_Expr;

      package Bare_Name_Memos is new Langkit_Support.Packrat
        (Bare_Name, Token_Index);

      package Bare_Array_Subcomponent_Choice_Name_Memos is new Langkit_Support.Packrat
        (Bare_Array_Subcomponent_Choice_Name, Token_Index);

         
         subtype Subtype_For_Array_Subcomponent_Choice_Name is
            Root_Node_Record (Ada_Array_Subcomponent_Choice_Name);
         type Access_To_Subtype_For_Array_Subcomponent_Choice_Name is access all Subtype_For_Array_Subcomponent_Choice_Name;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Array_Subcomponent_Choice_Name);
         package Bare_Array_Subcomponent_Choice_Name_Alloc is new Alloc
           (Subtype_For_Array_Subcomponent_Choice_Name, Access_To_Subtype_For_Array_Subcomponent_Choice_Name);

         function Allocate_Array_Subcomponent_Choice_Name
           (Pool : Bump_Ptr_Pool) return Bare_Array_Subcomponent_Choice_Name;

         function Allocate_Array_Subcomponent_Choice_Name
           (Pool : Bump_Ptr_Pool) return Bare_Array_Subcomponent_Choice_Name
         is
            Result      : constant Access_To_Subtype_For_Array_Subcomponent_Choice_Name := Bare_Array_Subcomponent_Choice_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Array_Subcomponent_Choice_Name;
            return Bare_Array_Subcomponent_Choice_Name (Result);
         end Allocate_Array_Subcomponent_Choice_Name;

      package Bare_Attribute_Ref_Memos is new Langkit_Support.Packrat
        (Bare_Attribute_Ref, Token_Index);

         
         subtype Subtype_For_Attribute_Ref is
            Root_Node_Record (Ada_Attribute_Ref);
         type Access_To_Subtype_For_Attribute_Ref is access all Subtype_For_Attribute_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Attribute_Ref);
         package Bare_Attribute_Ref_Alloc is new Alloc
           (Subtype_For_Attribute_Ref, Access_To_Subtype_For_Attribute_Ref);

         function Allocate_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Ref;

         function Allocate_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Attribute_Ref
         is
            Result      : constant Access_To_Subtype_For_Attribute_Ref := Bare_Attribute_Ref_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Attribute_Ref;
            return Bare_Attribute_Ref (Result);
         end Allocate_Attribute_Ref;

      package Bare_Call_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Call_Expr, Token_Index);

         
         subtype Subtype_For_Call_Expr is
            Root_Node_Record (Ada_Call_Expr);
         type Access_To_Subtype_For_Call_Expr is access all Subtype_For_Call_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Call_Expr);
         package Bare_Call_Expr_Alloc is new Alloc
           (Subtype_For_Call_Expr, Access_To_Subtype_For_Call_Expr);

         function Allocate_Call_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr;

         function Allocate_Call_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Call_Expr
         is
            Result      : constant Access_To_Subtype_For_Call_Expr := Bare_Call_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Call_Expr;
            return Bare_Call_Expr (Result);
         end Allocate_Call_Expr;

      package Bare_Defining_Name_Memos is new Langkit_Support.Packrat
        (Bare_Defining_Name, Token_Index);

         
         subtype Subtype_For_Defining_Name is
            Root_Node_Record (Ada_Defining_Name);
         type Access_To_Subtype_For_Defining_Name is access all Subtype_For_Defining_Name;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Defining_Name);
         package Bare_Defining_Name_Alloc is new Alloc
           (Subtype_For_Defining_Name, Access_To_Subtype_For_Defining_Name);

         function Allocate_Defining_Name
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name;

         function Allocate_Defining_Name
           (Pool : Bump_Ptr_Pool) return Bare_Defining_Name
         is
            Result      : constant Access_To_Subtype_For_Defining_Name := Bare_Defining_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Defining_Name;
            return Bare_Defining_Name (Result);
         end Allocate_Defining_Name;

      package Bare_Synthetic_Defining_Name_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Defining_Name, Token_Index);

         
         subtype Subtype_For_Synthetic_Defining_Name is
            Root_Node_Record (Ada_Synthetic_Defining_Name);
         type Access_To_Subtype_For_Synthetic_Defining_Name is access all Subtype_For_Synthetic_Defining_Name;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Defining_Name);
         package Bare_Synthetic_Defining_Name_Alloc is new Alloc
           (Subtype_For_Synthetic_Defining_Name, Access_To_Subtype_For_Synthetic_Defining_Name);

         function Allocate_Synthetic_Defining_Name
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Defining_Name;

         function Allocate_Synthetic_Defining_Name
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Defining_Name
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Defining_Name := Bare_Synthetic_Defining_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Defining_Name;
            return Bare_Synthetic_Defining_Name (Result);
         end Allocate_Synthetic_Defining_Name;

      package Bare_Discrete_Subtype_Name_Memos is new Langkit_Support.Packrat
        (Bare_Discrete_Subtype_Name, Token_Index);

         
         subtype Subtype_For_Discrete_Subtype_Name is
            Root_Node_Record (Ada_Discrete_Subtype_Name);
         type Access_To_Subtype_For_Discrete_Subtype_Name is access all Subtype_For_Discrete_Subtype_Name;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Discrete_Subtype_Name);
         package Bare_Discrete_Subtype_Name_Alloc is new Alloc
           (Subtype_For_Discrete_Subtype_Name, Access_To_Subtype_For_Discrete_Subtype_Name);

         function Allocate_Discrete_Subtype_Name
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Name;

         function Allocate_Discrete_Subtype_Name
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Name
         is
            Result      : constant Access_To_Subtype_For_Discrete_Subtype_Name := Bare_Discrete_Subtype_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discrete_Subtype_Name;
            return Bare_Discrete_Subtype_Name (Result);
         end Allocate_Discrete_Subtype_Name;

      package Bare_Dotted_Name_Memos is new Langkit_Support.Packrat
        (Bare_Dotted_Name, Token_Index);

         
         subtype Subtype_For_Dotted_Name is
            Root_Node_Record (Ada_Dotted_Name);
         type Access_To_Subtype_For_Dotted_Name is access all Subtype_For_Dotted_Name;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Dotted_Name);
         package Bare_Dotted_Name_Alloc is new Alloc
           (Subtype_For_Dotted_Name, Access_To_Subtype_For_Dotted_Name);

         function Allocate_Dotted_Name
           (Pool : Bump_Ptr_Pool) return Bare_Dotted_Name;

         function Allocate_Dotted_Name
           (Pool : Bump_Ptr_Pool) return Bare_Dotted_Name
         is
            Result      : constant Access_To_Subtype_For_Dotted_Name := Bare_Dotted_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Dotted_Name;
            return Bare_Dotted_Name (Result);
         end Allocate_Dotted_Name;

      package Bare_End_Name_Memos is new Langkit_Support.Packrat
        (Bare_End_Name, Token_Index);

         
         subtype Subtype_For_End_Name is
            Root_Node_Record (Ada_End_Name);
         type Access_To_Subtype_For_End_Name is access all Subtype_For_End_Name;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_End_Name);
         package Bare_End_Name_Alloc is new Alloc
           (Subtype_For_End_Name, Access_To_Subtype_For_End_Name);

         function Allocate_End_Name
           (Pool : Bump_Ptr_Pool) return Bare_End_Name;

         function Allocate_End_Name
           (Pool : Bump_Ptr_Pool) return Bare_End_Name
         is
            Result      : constant Access_To_Subtype_For_End_Name := Bare_End_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_End_Name;
            return Bare_End_Name (Result);
         end Allocate_End_Name;

      package Bare_Explicit_Deref_Memos is new Langkit_Support.Packrat
        (Bare_Explicit_Deref, Token_Index);

         
         subtype Subtype_For_Explicit_Deref is
            Root_Node_Record (Ada_Explicit_Deref);
         type Access_To_Subtype_For_Explicit_Deref is access all Subtype_For_Explicit_Deref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Explicit_Deref);
         package Bare_Explicit_Deref_Alloc is new Alloc
           (Subtype_For_Explicit_Deref, Access_To_Subtype_For_Explicit_Deref);

         function Allocate_Explicit_Deref
           (Pool : Bump_Ptr_Pool) return Bare_Explicit_Deref;

         function Allocate_Explicit_Deref
           (Pool : Bump_Ptr_Pool) return Bare_Explicit_Deref
         is
            Result      : constant Access_To_Subtype_For_Explicit_Deref := Bare_Explicit_Deref_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Explicit_Deref;
            return Bare_Explicit_Deref (Result);
         end Allocate_Explicit_Deref;

      package Bare_Qual_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Qual_Expr, Token_Index);

         
         subtype Subtype_For_Qual_Expr is
            Root_Node_Record (Ada_Qual_Expr);
         type Access_To_Subtype_For_Qual_Expr is access all Subtype_For_Qual_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Qual_Expr);
         package Bare_Qual_Expr_Alloc is new Alloc
           (Subtype_For_Qual_Expr, Access_To_Subtype_For_Qual_Expr);

         function Allocate_Qual_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Qual_Expr;

         function Allocate_Qual_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Qual_Expr
         is
            Result      : constant Access_To_Subtype_For_Qual_Expr := Bare_Qual_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Qual_Expr;
            return Bare_Qual_Expr (Result);
         end Allocate_Qual_Expr;

      package Bare_Reduce_Attribute_Ref_Memos is new Langkit_Support.Packrat
        (Bare_Reduce_Attribute_Ref, Token_Index);

         
         subtype Subtype_For_Reduce_Attribute_Ref is
            Root_Node_Record (Ada_Reduce_Attribute_Ref);
         type Access_To_Subtype_For_Reduce_Attribute_Ref is access all Subtype_For_Reduce_Attribute_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Reduce_Attribute_Ref);
         package Bare_Reduce_Attribute_Ref_Alloc is new Alloc
           (Subtype_For_Reduce_Attribute_Ref, Access_To_Subtype_For_Reduce_Attribute_Ref);

         function Allocate_Reduce_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Reduce_Attribute_Ref;

         function Allocate_Reduce_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Reduce_Attribute_Ref
         is
            Result      : constant Access_To_Subtype_For_Reduce_Attribute_Ref := Bare_Reduce_Attribute_Ref_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Reduce_Attribute_Ref;
            return Bare_Reduce_Attribute_Ref (Result);
         end Allocate_Reduce_Attribute_Ref;

      package Bare_Single_Tok_Node_Memos is new Langkit_Support.Packrat
        (Bare_Single_Tok_Node, Token_Index);

      package Bare_Base_Id_Memos is new Langkit_Support.Packrat
        (Bare_Base_Id, Token_Index);

      package Bare_Char_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Char_Literal, Token_Index);

         
         subtype Subtype_For_Char_Literal is
            Root_Node_Record (Ada_Char_Literal);
         type Access_To_Subtype_For_Char_Literal is access all Subtype_For_Char_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Char_Literal);
         package Bare_Char_Literal_Alloc is new Alloc
           (Subtype_For_Char_Literal, Access_To_Subtype_For_Char_Literal);

         function Allocate_Char_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Char_Literal;

         function Allocate_Char_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Char_Literal
         is
            Result      : constant Access_To_Subtype_For_Char_Literal := Bare_Char_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Char_Literal;
            return Bare_Char_Literal (Result);
         end Allocate_Char_Literal;

      package Bare_Identifier_Memos is new Langkit_Support.Packrat
        (Bare_Identifier, Token_Index);

         
         subtype Subtype_For_Identifier is
            Root_Node_Record (Ada_Identifier);
         type Access_To_Subtype_For_Identifier is access all Subtype_For_Identifier;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Identifier);
         package Bare_Identifier_Alloc is new Alloc
           (Subtype_For_Identifier, Access_To_Subtype_For_Identifier);

         function Allocate_Identifier
           (Pool : Bump_Ptr_Pool) return Bare_Identifier;

         function Allocate_Identifier
           (Pool : Bump_Ptr_Pool) return Bare_Identifier
         is
            Result      : constant Access_To_Subtype_For_Identifier := Bare_Identifier_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Identifier;
            return Bare_Identifier (Result);
         end Allocate_Identifier;

      package Bare_Op_Memos is new Langkit_Support.Packrat
        (Bare_Op, Token_Index);

      package Bare_Op_Abs_Memos is new Langkit_Support.Packrat
        (Bare_Op_Abs, Token_Index);

         
         subtype Subtype_For_Op_Abs is
            Root_Node_Record (Ada_Op_Abs);
         type Access_To_Subtype_For_Op_Abs is access all Subtype_For_Op_Abs;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Abs);
         package Bare_Op_Abs_Alloc is new Alloc
           (Subtype_For_Op_Abs, Access_To_Subtype_For_Op_Abs);

         function Allocate_Op_Abs
           (Pool : Bump_Ptr_Pool) return Bare_Op_Abs;

         function Allocate_Op_Abs
           (Pool : Bump_Ptr_Pool) return Bare_Op_Abs
         is
            Result      : constant Access_To_Subtype_For_Op_Abs := Bare_Op_Abs_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Abs;
            return Bare_Op_Abs (Result);
         end Allocate_Op_Abs;

      package Bare_Op_And_Memos is new Langkit_Support.Packrat
        (Bare_Op_And, Token_Index);

         
         subtype Subtype_For_Op_And is
            Root_Node_Record (Ada_Op_And);
         type Access_To_Subtype_For_Op_And is access all Subtype_For_Op_And;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_And);
         package Bare_Op_And_Alloc is new Alloc
           (Subtype_For_Op_And, Access_To_Subtype_For_Op_And);

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And;

         function Allocate_Op_And
           (Pool : Bump_Ptr_Pool) return Bare_Op_And
         is
            Result      : constant Access_To_Subtype_For_Op_And := Bare_Op_And_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_And;
            return Bare_Op_And (Result);
         end Allocate_Op_And;

      package Bare_Op_And_Then_Memos is new Langkit_Support.Packrat
        (Bare_Op_And_Then, Token_Index);

         
         subtype Subtype_For_Op_And_Then is
            Root_Node_Record (Ada_Op_And_Then);
         type Access_To_Subtype_For_Op_And_Then is access all Subtype_For_Op_And_Then;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_And_Then);
         package Bare_Op_And_Then_Alloc is new Alloc
           (Subtype_For_Op_And_Then, Access_To_Subtype_For_Op_And_Then);

         function Allocate_Op_And_Then
           (Pool : Bump_Ptr_Pool) return Bare_Op_And_Then;

         function Allocate_Op_And_Then
           (Pool : Bump_Ptr_Pool) return Bare_Op_And_Then
         is
            Result      : constant Access_To_Subtype_For_Op_And_Then := Bare_Op_And_Then_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_And_Then;
            return Bare_Op_And_Then (Result);
         end Allocate_Op_And_Then;

      package Bare_Op_Concat_Memos is new Langkit_Support.Packrat
        (Bare_Op_Concat, Token_Index);

         
         subtype Subtype_For_Op_Concat is
            Root_Node_Record (Ada_Op_Concat);
         type Access_To_Subtype_For_Op_Concat is access all Subtype_For_Op_Concat;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Concat);
         package Bare_Op_Concat_Alloc is new Alloc
           (Subtype_For_Op_Concat, Access_To_Subtype_For_Op_Concat);

         function Allocate_Op_Concat
           (Pool : Bump_Ptr_Pool) return Bare_Op_Concat;

         function Allocate_Op_Concat
           (Pool : Bump_Ptr_Pool) return Bare_Op_Concat
         is
            Result      : constant Access_To_Subtype_For_Op_Concat := Bare_Op_Concat_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Concat;
            return Bare_Op_Concat (Result);
         end Allocate_Op_Concat;

      package Bare_Op_Div_Memos is new Langkit_Support.Packrat
        (Bare_Op_Div, Token_Index);

         
         subtype Subtype_For_Op_Div is
            Root_Node_Record (Ada_Op_Div);
         type Access_To_Subtype_For_Op_Div is access all Subtype_For_Op_Div;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Div);
         package Bare_Op_Div_Alloc is new Alloc
           (Subtype_For_Op_Div, Access_To_Subtype_For_Op_Div);

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div;

         function Allocate_Op_Div
           (Pool : Bump_Ptr_Pool) return Bare_Op_Div
         is
            Result      : constant Access_To_Subtype_For_Op_Div := Bare_Op_Div_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Div;
            return Bare_Op_Div (Result);
         end Allocate_Op_Div;

      package Bare_Op_Double_Dot_Memos is new Langkit_Support.Packrat
        (Bare_Op_Double_Dot, Token_Index);

         
         subtype Subtype_For_Op_Double_Dot is
            Root_Node_Record (Ada_Op_Double_Dot);
         type Access_To_Subtype_For_Op_Double_Dot is access all Subtype_For_Op_Double_Dot;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Double_Dot);
         package Bare_Op_Double_Dot_Alloc is new Alloc
           (Subtype_For_Op_Double_Dot, Access_To_Subtype_For_Op_Double_Dot);

         function Allocate_Op_Double_Dot
           (Pool : Bump_Ptr_Pool) return Bare_Op_Double_Dot;

         function Allocate_Op_Double_Dot
           (Pool : Bump_Ptr_Pool) return Bare_Op_Double_Dot
         is
            Result      : constant Access_To_Subtype_For_Op_Double_Dot := Bare_Op_Double_Dot_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Double_Dot;
            return Bare_Op_Double_Dot (Result);
         end Allocate_Op_Double_Dot;

      package Bare_Op_Eq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Eq, Token_Index);

         
         subtype Subtype_For_Op_Eq is
            Root_Node_Record (Ada_Op_Eq);
         type Access_To_Subtype_For_Op_Eq is access all Subtype_For_Op_Eq;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Eq);
         package Bare_Op_Eq_Alloc is new Alloc
           (Subtype_For_Op_Eq, Access_To_Subtype_For_Op_Eq);

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq;

         function Allocate_Op_Eq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Eq
         is
            Result      : constant Access_To_Subtype_For_Op_Eq := Bare_Op_Eq_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Eq;
            return Bare_Op_Eq (Result);
         end Allocate_Op_Eq;

      package Bare_Op_Gt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Gt, Token_Index);

         
         subtype Subtype_For_Op_Gt is
            Root_Node_Record (Ada_Op_Gt);
         type Access_To_Subtype_For_Op_Gt is access all Subtype_For_Op_Gt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Gt);
         package Bare_Op_Gt_Alloc is new Alloc
           (Subtype_For_Op_Gt, Access_To_Subtype_For_Op_Gt);

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt;

         function Allocate_Op_Gt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gt
         is
            Result      : constant Access_To_Subtype_For_Op_Gt := Bare_Op_Gt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Gt;
            return Bare_Op_Gt (Result);
         end Allocate_Op_Gt;

      package Bare_Op_Gte_Memos is new Langkit_Support.Packrat
        (Bare_Op_Gte, Token_Index);

         
         subtype Subtype_For_Op_Gte is
            Root_Node_Record (Ada_Op_Gte);
         type Access_To_Subtype_For_Op_Gte is access all Subtype_For_Op_Gte;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Gte);
         package Bare_Op_Gte_Alloc is new Alloc
           (Subtype_For_Op_Gte, Access_To_Subtype_For_Op_Gte);

         function Allocate_Op_Gte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gte;

         function Allocate_Op_Gte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Gte
         is
            Result      : constant Access_To_Subtype_For_Op_Gte := Bare_Op_Gte_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Gte;
            return Bare_Op_Gte (Result);
         end Allocate_Op_Gte;

      package Bare_Op_In_Memos is new Langkit_Support.Packrat
        (Bare_Op_In, Token_Index);

         
         subtype Subtype_For_Op_In is
            Root_Node_Record (Ada_Op_In);
         type Access_To_Subtype_For_Op_In is access all Subtype_For_Op_In;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_In);
         package Bare_Op_In_Alloc is new Alloc
           (Subtype_For_Op_In, Access_To_Subtype_For_Op_In);

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In;

         function Allocate_Op_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_In
         is
            Result      : constant Access_To_Subtype_For_Op_In := Bare_Op_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_In;
            return Bare_Op_In (Result);
         end Allocate_Op_In;

      package Bare_Op_Lt_Memos is new Langkit_Support.Packrat
        (Bare_Op_Lt, Token_Index);

         
         subtype Subtype_For_Op_Lt is
            Root_Node_Record (Ada_Op_Lt);
         type Access_To_Subtype_For_Op_Lt is access all Subtype_For_Op_Lt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Lt);
         package Bare_Op_Lt_Alloc is new Alloc
           (Subtype_For_Op_Lt, Access_To_Subtype_For_Op_Lt);

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt;

         function Allocate_Op_Lt
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lt
         is
            Result      : constant Access_To_Subtype_For_Op_Lt := Bare_Op_Lt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Lt;
            return Bare_Op_Lt (Result);
         end Allocate_Op_Lt;

      package Bare_Op_Lte_Memos is new Langkit_Support.Packrat
        (Bare_Op_Lte, Token_Index);

         
         subtype Subtype_For_Op_Lte is
            Root_Node_Record (Ada_Op_Lte);
         type Access_To_Subtype_For_Op_Lte is access all Subtype_For_Op_Lte;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Lte);
         package Bare_Op_Lte_Alloc is new Alloc
           (Subtype_For_Op_Lte, Access_To_Subtype_For_Op_Lte);

         function Allocate_Op_Lte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lte;

         function Allocate_Op_Lte
           (Pool : Bump_Ptr_Pool) return Bare_Op_Lte
         is
            Result      : constant Access_To_Subtype_For_Op_Lte := Bare_Op_Lte_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Lte;
            return Bare_Op_Lte (Result);
         end Allocate_Op_Lte;

      package Bare_Op_Minus_Memos is new Langkit_Support.Packrat
        (Bare_Op_Minus, Token_Index);

         
         subtype Subtype_For_Op_Minus is
            Root_Node_Record (Ada_Op_Minus);
         type Access_To_Subtype_For_Op_Minus is access all Subtype_For_Op_Minus;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Minus);
         package Bare_Op_Minus_Alloc is new Alloc
           (Subtype_For_Op_Minus, Access_To_Subtype_For_Op_Minus);

         function Allocate_Op_Minus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Minus;

         function Allocate_Op_Minus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Minus
         is
            Result      : constant Access_To_Subtype_For_Op_Minus := Bare_Op_Minus_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Minus;
            return Bare_Op_Minus (Result);
         end Allocate_Op_Minus;

      package Bare_Op_Mod_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mod, Token_Index);

         
         subtype Subtype_For_Op_Mod is
            Root_Node_Record (Ada_Op_Mod);
         type Access_To_Subtype_For_Op_Mod is access all Subtype_For_Op_Mod;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Mod);
         package Bare_Op_Mod_Alloc is new Alloc
           (Subtype_For_Op_Mod, Access_To_Subtype_For_Op_Mod);

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod;

         function Allocate_Op_Mod
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mod
         is
            Result      : constant Access_To_Subtype_For_Op_Mod := Bare_Op_Mod_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Mod;
            return Bare_Op_Mod (Result);
         end Allocate_Op_Mod;

      package Bare_Op_Mult_Memos is new Langkit_Support.Packrat
        (Bare_Op_Mult, Token_Index);

         
         subtype Subtype_For_Op_Mult is
            Root_Node_Record (Ada_Op_Mult);
         type Access_To_Subtype_For_Op_Mult is access all Subtype_For_Op_Mult;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Mult);
         package Bare_Op_Mult_Alloc is new Alloc
           (Subtype_For_Op_Mult, Access_To_Subtype_For_Op_Mult);

         function Allocate_Op_Mult
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mult;

         function Allocate_Op_Mult
           (Pool : Bump_Ptr_Pool) return Bare_Op_Mult
         is
            Result      : constant Access_To_Subtype_For_Op_Mult := Bare_Op_Mult_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Mult;
            return Bare_Op_Mult (Result);
         end Allocate_Op_Mult;

      package Bare_Op_Neq_Memos is new Langkit_Support.Packrat
        (Bare_Op_Neq, Token_Index);

         
         subtype Subtype_For_Op_Neq is
            Root_Node_Record (Ada_Op_Neq);
         type Access_To_Subtype_For_Op_Neq is access all Subtype_For_Op_Neq;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Neq);
         package Bare_Op_Neq_Alloc is new Alloc
           (Subtype_For_Op_Neq, Access_To_Subtype_For_Op_Neq);

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq;

         function Allocate_Op_Neq
           (Pool : Bump_Ptr_Pool) return Bare_Op_Neq
         is
            Result      : constant Access_To_Subtype_For_Op_Neq := Bare_Op_Neq_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Neq;
            return Bare_Op_Neq (Result);
         end Allocate_Op_Neq;

      package Bare_Op_Not_Memos is new Langkit_Support.Packrat
        (Bare_Op_Not, Token_Index);

         
         subtype Subtype_For_Op_Not is
            Root_Node_Record (Ada_Op_Not);
         type Access_To_Subtype_For_Op_Not is access all Subtype_For_Op_Not;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Not);
         package Bare_Op_Not_Alloc is new Alloc
           (Subtype_For_Op_Not, Access_To_Subtype_For_Op_Not);

         function Allocate_Op_Not
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not;

         function Allocate_Op_Not
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not
         is
            Result      : constant Access_To_Subtype_For_Op_Not := Bare_Op_Not_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Not;
            return Bare_Op_Not (Result);
         end Allocate_Op_Not;

      package Bare_Op_Not_In_Memos is new Langkit_Support.Packrat
        (Bare_Op_Not_In, Token_Index);

         
         subtype Subtype_For_Op_Not_In is
            Root_Node_Record (Ada_Op_Not_In);
         type Access_To_Subtype_For_Op_Not_In is access all Subtype_For_Op_Not_In;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Not_In);
         package Bare_Op_Not_In_Alloc is new Alloc
           (Subtype_For_Op_Not_In, Access_To_Subtype_For_Op_Not_In);

         function Allocate_Op_Not_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not_In;

         function Allocate_Op_Not_In
           (Pool : Bump_Ptr_Pool) return Bare_Op_Not_In
         is
            Result      : constant Access_To_Subtype_For_Op_Not_In := Bare_Op_Not_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Not_In;
            return Bare_Op_Not_In (Result);
         end Allocate_Op_Not_In;

      package Bare_Op_Or_Memos is new Langkit_Support.Packrat
        (Bare_Op_Or, Token_Index);

         
         subtype Subtype_For_Op_Or is
            Root_Node_Record (Ada_Op_Or);
         type Access_To_Subtype_For_Op_Or is access all Subtype_For_Op_Or;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Or);
         package Bare_Op_Or_Alloc is new Alloc
           (Subtype_For_Op_Or, Access_To_Subtype_For_Op_Or);

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or;

         function Allocate_Op_Or
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or
         is
            Result      : constant Access_To_Subtype_For_Op_Or := Bare_Op_Or_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Or;
            return Bare_Op_Or (Result);
         end Allocate_Op_Or;

      package Bare_Op_Or_Else_Memos is new Langkit_Support.Packrat
        (Bare_Op_Or_Else, Token_Index);

         
         subtype Subtype_For_Op_Or_Else is
            Root_Node_Record (Ada_Op_Or_Else);
         type Access_To_Subtype_For_Op_Or_Else is access all Subtype_For_Op_Or_Else;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Or_Else);
         package Bare_Op_Or_Else_Alloc is new Alloc
           (Subtype_For_Op_Or_Else, Access_To_Subtype_For_Op_Or_Else);

         function Allocate_Op_Or_Else
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or_Else;

         function Allocate_Op_Or_Else
           (Pool : Bump_Ptr_Pool) return Bare_Op_Or_Else
         is
            Result      : constant Access_To_Subtype_For_Op_Or_Else := Bare_Op_Or_Else_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Or_Else;
            return Bare_Op_Or_Else (Result);
         end Allocate_Op_Or_Else;

      package Bare_Op_Plus_Memos is new Langkit_Support.Packrat
        (Bare_Op_Plus, Token_Index);

         
         subtype Subtype_For_Op_Plus is
            Root_Node_Record (Ada_Op_Plus);
         type Access_To_Subtype_For_Op_Plus is access all Subtype_For_Op_Plus;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Plus);
         package Bare_Op_Plus_Alloc is new Alloc
           (Subtype_For_Op_Plus, Access_To_Subtype_For_Op_Plus);

         function Allocate_Op_Plus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Plus;

         function Allocate_Op_Plus
           (Pool : Bump_Ptr_Pool) return Bare_Op_Plus
         is
            Result      : constant Access_To_Subtype_For_Op_Plus := Bare_Op_Plus_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Plus;
            return Bare_Op_Plus (Result);
         end Allocate_Op_Plus;

      package Bare_Op_Pow_Memos is new Langkit_Support.Packrat
        (Bare_Op_Pow, Token_Index);

         
         subtype Subtype_For_Op_Pow is
            Root_Node_Record (Ada_Op_Pow);
         type Access_To_Subtype_For_Op_Pow is access all Subtype_For_Op_Pow;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Pow);
         package Bare_Op_Pow_Alloc is new Alloc
           (Subtype_For_Op_Pow, Access_To_Subtype_For_Op_Pow);

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow;

         function Allocate_Op_Pow
           (Pool : Bump_Ptr_Pool) return Bare_Op_Pow
         is
            Result      : constant Access_To_Subtype_For_Op_Pow := Bare_Op_Pow_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Pow;
            return Bare_Op_Pow (Result);
         end Allocate_Op_Pow;

      package Bare_Op_Rem_Memos is new Langkit_Support.Packrat
        (Bare_Op_Rem, Token_Index);

         
         subtype Subtype_For_Op_Rem is
            Root_Node_Record (Ada_Op_Rem);
         type Access_To_Subtype_For_Op_Rem is access all Subtype_For_Op_Rem;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Rem);
         package Bare_Op_Rem_Alloc is new Alloc
           (Subtype_For_Op_Rem, Access_To_Subtype_For_Op_Rem);

         function Allocate_Op_Rem
           (Pool : Bump_Ptr_Pool) return Bare_Op_Rem;

         function Allocate_Op_Rem
           (Pool : Bump_Ptr_Pool) return Bare_Op_Rem
         is
            Result      : constant Access_To_Subtype_For_Op_Rem := Bare_Op_Rem_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Rem;
            return Bare_Op_Rem (Result);
         end Allocate_Op_Rem;

      package Bare_Op_Xor_Memos is new Langkit_Support.Packrat
        (Bare_Op_Xor, Token_Index);

         
         subtype Subtype_For_Op_Xor is
            Root_Node_Record (Ada_Op_Xor);
         type Access_To_Subtype_For_Op_Xor is access all Subtype_For_Op_Xor;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Op_Xor);
         package Bare_Op_Xor_Alloc is new Alloc
           (Subtype_For_Op_Xor, Access_To_Subtype_For_Op_Xor);

         function Allocate_Op_Xor
           (Pool : Bump_Ptr_Pool) return Bare_Op_Xor;

         function Allocate_Op_Xor
           (Pool : Bump_Ptr_Pool) return Bare_Op_Xor
         is
            Result      : constant Access_To_Subtype_For_Op_Xor := Bare_Op_Xor_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Op_Xor;
            return Bare_Op_Xor (Result);
         end Allocate_Op_Xor;

      package Bare_String_Literal_Memos is new Langkit_Support.Packrat
        (Bare_String_Literal, Token_Index);

         
         subtype Subtype_For_String_Literal is
            Root_Node_Record (Ada_String_Literal);
         type Access_To_Subtype_For_String_Literal is access all Subtype_For_String_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_String_Literal);
         package Bare_String_Literal_Alloc is new Alloc
           (Subtype_For_String_Literal, Access_To_Subtype_For_String_Literal);

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal;

         function Allocate_String_Literal
           (Pool : Bump_Ptr_Pool) return Bare_String_Literal
         is
            Result      : constant Access_To_Subtype_For_String_Literal := Bare_String_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_String_Literal;
            return Bare_String_Literal (Result);
         end Allocate_String_Literal;

      package Bare_Null_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Null_Literal, Token_Index);

         
         subtype Subtype_For_Null_Literal is
            Root_Node_Record (Ada_Null_Literal);
         type Access_To_Subtype_For_Null_Literal is access all Subtype_For_Null_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Literal);
         package Bare_Null_Literal_Alloc is new Alloc
           (Subtype_For_Null_Literal, Access_To_Subtype_For_Null_Literal);

         function Allocate_Null_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Null_Literal;

         function Allocate_Null_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Null_Literal
         is
            Result      : constant Access_To_Subtype_For_Null_Literal := Bare_Null_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Literal;
            return Bare_Null_Literal (Result);
         end Allocate_Null_Literal;

      package Bare_Num_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Num_Literal, Token_Index);

      package Bare_Int_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Int_Literal, Token_Index);

         
         subtype Subtype_For_Int_Literal is
            Root_Node_Record (Ada_Int_Literal);
         type Access_To_Subtype_For_Int_Literal is access all Subtype_For_Int_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Int_Literal);
         package Bare_Int_Literal_Alloc is new Alloc
           (Subtype_For_Int_Literal, Access_To_Subtype_For_Int_Literal);

         function Allocate_Int_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Int_Literal;

         function Allocate_Int_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Int_Literal
         is
            Result      : constant Access_To_Subtype_For_Int_Literal := Bare_Int_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Int_Literal;
            return Bare_Int_Literal (Result);
         end Allocate_Int_Literal;

      package Bare_Real_Literal_Memos is new Langkit_Support.Packrat
        (Bare_Real_Literal, Token_Index);

         
         subtype Subtype_For_Real_Literal is
            Root_Node_Record (Ada_Real_Literal);
         type Access_To_Subtype_For_Real_Literal is access all Subtype_For_Real_Literal;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Real_Literal);
         package Bare_Real_Literal_Alloc is new Alloc
           (Subtype_For_Real_Literal, Access_To_Subtype_For_Real_Literal);

         function Allocate_Real_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Real_Literal;

         function Allocate_Real_Literal
           (Pool : Bump_Ptr_Pool) return Bare_Real_Literal
         is
            Result      : constant Access_To_Subtype_For_Real_Literal := Bare_Real_Literal_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Real_Literal;
            return Bare_Real_Literal (Result);
         end Allocate_Real_Literal;

      package Bare_Synthetic_Identifier_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Identifier, Token_Index);

         
         subtype Subtype_For_Synthetic_Identifier is
            Root_Node_Record (Ada_Synthetic_Identifier);
         type Access_To_Subtype_For_Synthetic_Identifier is access all Subtype_For_Synthetic_Identifier;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Identifier);
         package Bare_Synthetic_Identifier_Alloc is new Alloc
           (Subtype_For_Synthetic_Identifier, Access_To_Subtype_For_Synthetic_Identifier);

         function Allocate_Synthetic_Identifier
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Identifier;

         function Allocate_Synthetic_Identifier
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Identifier
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Identifier := Bare_Synthetic_Identifier_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Identifier;
            return Bare_Synthetic_Identifier (Result);
         end Allocate_Synthetic_Identifier;

      package Bare_Target_Name_Memos is new Langkit_Support.Packrat
        (Bare_Target_Name, Token_Index);

         
         subtype Subtype_For_Target_Name is
            Root_Node_Record (Ada_Target_Name);
         type Access_To_Subtype_For_Target_Name is access all Subtype_For_Target_Name;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Target_Name);
         package Bare_Target_Name_Alloc is new Alloc
           (Subtype_For_Target_Name, Access_To_Subtype_For_Target_Name);

         function Allocate_Target_Name
           (Pool : Bump_Ptr_Pool) return Bare_Target_Name;

         function Allocate_Target_Name
           (Pool : Bump_Ptr_Pool) return Bare_Target_Name
         is
            Result      : constant Access_To_Subtype_For_Target_Name := Bare_Target_Name_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Target_Name;
            return Bare_Target_Name (Result);
         end Allocate_Target_Name;

      package Bare_Update_Attribute_Ref_Memos is new Langkit_Support.Packrat
        (Bare_Update_Attribute_Ref, Token_Index);

         
         subtype Subtype_For_Update_Attribute_Ref is
            Root_Node_Record (Ada_Update_Attribute_Ref);
         type Access_To_Subtype_For_Update_Attribute_Ref is access all Subtype_For_Update_Attribute_Ref;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Update_Attribute_Ref);
         package Bare_Update_Attribute_Ref_Alloc is new Alloc
           (Subtype_For_Update_Attribute_Ref, Access_To_Subtype_For_Update_Attribute_Ref);

         function Allocate_Update_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Update_Attribute_Ref;

         function Allocate_Update_Attribute_Ref
           (Pool : Bump_Ptr_Pool) return Bare_Update_Attribute_Ref
         is
            Result      : constant Access_To_Subtype_For_Update_Attribute_Ref := Bare_Update_Attribute_Ref_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Update_Attribute_Ref;
            return Bare_Update_Attribute_Ref (Result);
         end Allocate_Update_Attribute_Ref;

      package Bare_Paren_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Paren_Expr, Token_Index);

         
         subtype Subtype_For_Paren_Expr is
            Root_Node_Record (Ada_Paren_Expr);
         type Access_To_Subtype_For_Paren_Expr is access all Subtype_For_Paren_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Paren_Expr);
         package Bare_Paren_Expr_Alloc is new Alloc
           (Subtype_For_Paren_Expr, Access_To_Subtype_For_Paren_Expr);

         function Allocate_Paren_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expr;

         function Allocate_Paren_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Expr
         is
            Result      : constant Access_To_Subtype_For_Paren_Expr := Bare_Paren_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Paren_Expr;
            return Bare_Paren_Expr (Result);
         end Allocate_Paren_Expr;

      package Bare_Quantified_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Quantified_Expr, Token_Index);

         
         subtype Subtype_For_Quantified_Expr is
            Root_Node_Record (Ada_Quantified_Expr);
         type Access_To_Subtype_For_Quantified_Expr is access all Subtype_For_Quantified_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Quantified_Expr);
         package Bare_Quantified_Expr_Alloc is new Alloc
           (Subtype_For_Quantified_Expr, Access_To_Subtype_For_Quantified_Expr);

         function Allocate_Quantified_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expr;

         function Allocate_Quantified_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Quantified_Expr
         is
            Result      : constant Access_To_Subtype_For_Quantified_Expr := Bare_Quantified_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Quantified_Expr;
            return Bare_Quantified_Expr (Result);
         end Allocate_Quantified_Expr;

      package Bare_Raise_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Raise_Expr, Token_Index);

         
         subtype Subtype_For_Raise_Expr is
            Root_Node_Record (Ada_Raise_Expr);
         type Access_To_Subtype_For_Raise_Expr is access all Subtype_For_Raise_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Raise_Expr);
         package Bare_Raise_Expr_Alloc is new Alloc
           (Subtype_For_Raise_Expr, Access_To_Subtype_For_Raise_Expr);

         function Allocate_Raise_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Expr;

         function Allocate_Raise_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Expr
         is
            Result      : constant Access_To_Subtype_For_Raise_Expr := Bare_Raise_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Raise_Expr;
            return Bare_Raise_Expr (Result);
         end Allocate_Raise_Expr;

      package Bare_Un_Op_Memos is new Langkit_Support.Packrat
        (Bare_Un_Op, Token_Index);

         
         subtype Subtype_For_Un_Op is
            Root_Node_Record (Ada_Un_Op);
         type Access_To_Subtype_For_Un_Op is access all Subtype_For_Un_Op;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Un_Op);
         package Bare_Un_Op_Alloc is new Alloc
           (Subtype_For_Un_Op, Access_To_Subtype_For_Un_Op);

         function Allocate_Un_Op
           (Pool : Bump_Ptr_Pool) return Bare_Un_Op;

         function Allocate_Un_Op
           (Pool : Bump_Ptr_Pool) return Bare_Un_Op
         is
            Result      : constant Access_To_Subtype_For_Un_Op := Bare_Un_Op_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Un_Op;
            return Bare_Un_Op (Result);
         end Allocate_Un_Op;

      package Bare_For_Loop_Iter_Filter_Memos is new Langkit_Support.Packrat
        (Bare_For_Loop_Iter_Filter, Token_Index);

         
         subtype Subtype_For_For_Loop_Iter_Filter is
            Root_Node_Record (Ada_For_Loop_Iter_Filter);
         type Access_To_Subtype_For_For_Loop_Iter_Filter is access all Subtype_For_For_Loop_Iter_Filter;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_For_Loop_Iter_Filter);
         package Bare_For_Loop_Iter_Filter_Alloc is new Alloc
           (Subtype_For_For_Loop_Iter_Filter, Access_To_Subtype_For_For_Loop_Iter_Filter);

         function Allocate_For_Loop_Iter_Filter
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Iter_Filter;

         function Allocate_For_Loop_Iter_Filter
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Iter_Filter
         is
            Result      : constant Access_To_Subtype_For_For_Loop_Iter_Filter := Bare_For_Loop_Iter_Filter_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_For_Loop_Iter_Filter;
            return Bare_For_Loop_Iter_Filter (Result);
         end Allocate_For_Loop_Iter_Filter;

      package Bare_Format_String_Chunk_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Chunk, Token_Index);

         
         subtype Subtype_For_Format_String_Chunk is
            Root_Node_Record (Ada_Format_String_Chunk);
         type Access_To_Subtype_For_Format_String_Chunk is access all Subtype_For_Format_String_Chunk;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Format_String_Chunk);
         package Bare_Format_String_Chunk_Alloc is new Alloc
           (Subtype_For_Format_String_Chunk, Access_To_Subtype_For_Format_String_Chunk);

         function Allocate_Format_String_Chunk
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Chunk;

         function Allocate_Format_String_Chunk
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Chunk
         is
            Result      : constant Access_To_Subtype_For_Format_String_Chunk := Bare_Format_String_Chunk_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Format_String_Chunk;
            return Bare_Format_String_Chunk (Result);
         end Allocate_Format_String_Chunk;

      package Bare_Format_String_Tok_Node_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Tok_Node, Token_Index);

      package Bare_Format_String_Tok_End_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Tok_End, Token_Index);

         
         subtype Subtype_For_Format_String_Tok_End is
            Root_Node_Record (Ada_Format_String_Tok_End);
         type Access_To_Subtype_For_Format_String_Tok_End is access all Subtype_For_Format_String_Tok_End;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Format_String_Tok_End);
         package Bare_Format_String_Tok_End_Alloc is new Alloc
           (Subtype_For_Format_String_Tok_End, Access_To_Subtype_For_Format_String_Tok_End);

         function Allocate_Format_String_Tok_End
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_End;

         function Allocate_Format_String_Tok_End
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_End
         is
            Result      : constant Access_To_Subtype_For_Format_String_Tok_End := Bare_Format_String_Tok_End_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Format_String_Tok_End;
            return Bare_Format_String_Tok_End (Result);
         end Allocate_Format_String_Tok_End;

      package Bare_Format_String_Tok_Mid_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Tok_Mid, Token_Index);

         
         subtype Subtype_For_Format_String_Tok_Mid is
            Root_Node_Record (Ada_Format_String_Tok_Mid);
         type Access_To_Subtype_For_Format_String_Tok_Mid is access all Subtype_For_Format_String_Tok_Mid;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Format_String_Tok_Mid);
         package Bare_Format_String_Tok_Mid_Alloc is new Alloc
           (Subtype_For_Format_String_Tok_Mid, Access_To_Subtype_For_Format_String_Tok_Mid);

         function Allocate_Format_String_Tok_Mid
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_Mid;

         function Allocate_Format_String_Tok_Mid
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_Mid
         is
            Result      : constant Access_To_Subtype_For_Format_String_Tok_Mid := Bare_Format_String_Tok_Mid_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Format_String_Tok_Mid;
            return Bare_Format_String_Tok_Mid (Result);
         end Allocate_Format_String_Tok_Mid;

      package Bare_Format_String_Tok_Start_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Tok_Start, Token_Index);

         
         subtype Subtype_For_Format_String_Tok_Start is
            Root_Node_Record (Ada_Format_String_Tok_Start);
         type Access_To_Subtype_For_Format_String_Tok_Start is access all Subtype_For_Format_String_Tok_Start;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Format_String_Tok_Start);
         package Bare_Format_String_Tok_Start_Alloc is new Alloc
           (Subtype_For_Format_String_Tok_Start, Access_To_Subtype_For_Format_String_Tok_Start);

         function Allocate_Format_String_Tok_Start
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_Start;

         function Allocate_Format_String_Tok_Start
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_Start
         is
            Result      : constant Access_To_Subtype_For_Format_String_Tok_Start := Bare_Format_String_Tok_Start_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Format_String_Tok_Start;
            return Bare_Format_String_Tok_Start (Result);
         end Allocate_Format_String_Tok_Start;

      package Bare_Format_String_Tok_String_Memos is new Langkit_Support.Packrat
        (Bare_Format_String_Tok_String, Token_Index);

         
         subtype Subtype_For_Format_String_Tok_String is
            Root_Node_Record (Ada_Format_String_Tok_String);
         type Access_To_Subtype_For_Format_String_Tok_String is access all Subtype_For_Format_String_Tok_String;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Format_String_Tok_String);
         package Bare_Format_String_Tok_String_Alloc is new Alloc
           (Subtype_For_Format_String_Tok_String, Access_To_Subtype_For_Format_String_Tok_String);

         function Allocate_Format_String_Tok_String
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_String;

         function Allocate_Format_String_Tok_String
           (Pool : Bump_Ptr_Pool) return Bare_Format_String_Tok_String
         is
            Result      : constant Access_To_Subtype_For_Format_String_Tok_String := Bare_Format_String_Tok_String_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Format_String_Tok_String;
            return Bare_Format_String_Tok_String (Result);
         end Allocate_Format_String_Tok_String;

      package Bare_Handled_Stmts_Memos is new Langkit_Support.Packrat
        (Bare_Handled_Stmts, Token_Index);

         
         subtype Subtype_For_Handled_Stmts is
            Root_Node_Record (Ada_Handled_Stmts);
         type Access_To_Subtype_For_Handled_Stmts is access all Subtype_For_Handled_Stmts;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Handled_Stmts);
         package Bare_Handled_Stmts_Alloc is new Alloc
           (Subtype_For_Handled_Stmts, Access_To_Subtype_For_Handled_Stmts);

         function Allocate_Handled_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Handled_Stmts;

         function Allocate_Handled_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Handled_Stmts
         is
            Result      : constant Access_To_Subtype_For_Handled_Stmts := Bare_Handled_Stmts_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Handled_Stmts;
            return Bare_Handled_Stmts (Result);
         end Allocate_Handled_Stmts;

      package Bare_Interface_Kind_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind, Token_Index);

      package Bare_Interface_Kind_Limited_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Limited, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Limited is
            Root_Node_Record (Ada_Interface_Kind_Limited);
         type Access_To_Subtype_For_Interface_Kind_Limited is access all Subtype_For_Interface_Kind_Limited;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Interface_Kind_Limited);
         package Bare_Interface_Kind_Limited_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Limited, Access_To_Subtype_For_Interface_Kind_Limited);

         function Allocate_Interface_Kind_Limited
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Limited;

         function Allocate_Interface_Kind_Limited
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Limited
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Limited := Bare_Interface_Kind_Limited_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Limited;
            return Bare_Interface_Kind_Limited (Result);
         end Allocate_Interface_Kind_Limited;

      package Bare_Interface_Kind_Protected_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Protected, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Protected is
            Root_Node_Record (Ada_Interface_Kind_Protected);
         type Access_To_Subtype_For_Interface_Kind_Protected is access all Subtype_For_Interface_Kind_Protected;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Interface_Kind_Protected);
         package Bare_Interface_Kind_Protected_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Protected, Access_To_Subtype_For_Interface_Kind_Protected);

         function Allocate_Interface_Kind_Protected
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Protected;

         function Allocate_Interface_Kind_Protected
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Protected
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Protected := Bare_Interface_Kind_Protected_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Protected;
            return Bare_Interface_Kind_Protected (Result);
         end Allocate_Interface_Kind_Protected;

      package Bare_Interface_Kind_Synchronized_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Synchronized, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Synchronized is
            Root_Node_Record (Ada_Interface_Kind_Synchronized);
         type Access_To_Subtype_For_Interface_Kind_Synchronized is access all Subtype_For_Interface_Kind_Synchronized;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Interface_Kind_Synchronized);
         package Bare_Interface_Kind_Synchronized_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Synchronized, Access_To_Subtype_For_Interface_Kind_Synchronized);

         function Allocate_Interface_Kind_Synchronized
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Synchronized;

         function Allocate_Interface_Kind_Synchronized
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Synchronized
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Synchronized := Bare_Interface_Kind_Synchronized_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Synchronized;
            return Bare_Interface_Kind_Synchronized (Result);
         end Allocate_Interface_Kind_Synchronized;

      package Bare_Interface_Kind_Task_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Kind_Task, Token_Index);

         
         subtype Subtype_For_Interface_Kind_Task is
            Root_Node_Record (Ada_Interface_Kind_Task);
         type Access_To_Subtype_For_Interface_Kind_Task is access all Subtype_For_Interface_Kind_Task;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Interface_Kind_Task);
         package Bare_Interface_Kind_Task_Alloc is new Alloc
           (Subtype_For_Interface_Kind_Task, Access_To_Subtype_For_Interface_Kind_Task);

         function Allocate_Interface_Kind_Task
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Task;

         function Allocate_Interface_Kind_Task
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Kind_Task
         is
            Result      : constant Access_To_Subtype_For_Interface_Kind_Task := Bare_Interface_Kind_Task_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Kind_Task;
            return Bare_Interface_Kind_Task (Result);
         end Allocate_Interface_Kind_Task;

      package Bare_Iter_Type_Memos is new Langkit_Support.Packrat
        (Bare_Iter_Type, Token_Index);

      package Bare_Iter_Type_In_Memos is new Langkit_Support.Packrat
        (Bare_Iter_Type_In, Token_Index);

         
         subtype Subtype_For_Iter_Type_In is
            Root_Node_Record (Ada_Iter_Type_In);
         type Access_To_Subtype_For_Iter_Type_In is access all Subtype_For_Iter_Type_In;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Iter_Type_In);
         package Bare_Iter_Type_In_Alloc is new Alloc
           (Subtype_For_Iter_Type_In, Access_To_Subtype_For_Iter_Type_In);

         function Allocate_Iter_Type_In
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_In;

         function Allocate_Iter_Type_In
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_In
         is
            Result      : constant Access_To_Subtype_For_Iter_Type_In := Bare_Iter_Type_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Iter_Type_In;
            return Bare_Iter_Type_In (Result);
         end Allocate_Iter_Type_In;

      package Bare_Iter_Type_Of_Memos is new Langkit_Support.Packrat
        (Bare_Iter_Type_Of, Token_Index);

         
         subtype Subtype_For_Iter_Type_Of is
            Root_Node_Record (Ada_Iter_Type_Of);
         type Access_To_Subtype_For_Iter_Type_Of is access all Subtype_For_Iter_Type_Of;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Iter_Type_Of);
         package Bare_Iter_Type_Of_Alloc is new Alloc
           (Subtype_For_Iter_Type_Of, Access_To_Subtype_For_Iter_Type_Of);

         function Allocate_Iter_Type_Of
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_Of;

         function Allocate_Iter_Type_Of
           (Pool : Bump_Ptr_Pool) return Bare_Iter_Type_Of
         is
            Result      : constant Access_To_Subtype_For_Iter_Type_Of := Bare_Iter_Type_Of_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Iter_Type_Of;
            return Bare_Iter_Type_Of (Result);
         end Allocate_Iter_Type_Of;

      package Bare_Library_Item_Memos is new Langkit_Support.Packrat
        (Bare_Library_Item, Token_Index);

         
         subtype Subtype_For_Library_Item is
            Root_Node_Record (Ada_Library_Item);
         type Access_To_Subtype_For_Library_Item is access all Subtype_For_Library_Item;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Library_Item);
         package Bare_Library_Item_Alloc is new Alloc
           (Subtype_For_Library_Item, Access_To_Subtype_For_Library_Item);

         function Allocate_Library_Item
           (Pool : Bump_Ptr_Pool) return Bare_Library_Item;

         function Allocate_Library_Item
           (Pool : Bump_Ptr_Pool) return Bare_Library_Item
         is
            Result      : constant Access_To_Subtype_For_Library_Item := Bare_Library_Item_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Library_Item;
            return Bare_Library_Item (Result);
         end Allocate_Library_Item;

      package Bare_Limited_Node_Memos is new Langkit_Support.Packrat
        (Bare_Limited_Node, Token_Index);

      package Bare_Limited_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Limited_Absent, Token_Index);

         
         subtype Subtype_For_Limited_Absent is
            Root_Node_Record (Ada_Limited_Absent);
         type Access_To_Subtype_For_Limited_Absent is access all Subtype_For_Limited_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Limited_Absent);
         package Bare_Limited_Absent_Alloc is new Alloc
           (Subtype_For_Limited_Absent, Access_To_Subtype_For_Limited_Absent);

         function Allocate_Limited_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Absent;

         function Allocate_Limited_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Absent
         is
            Result      : constant Access_To_Subtype_For_Limited_Absent := Bare_Limited_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Limited_Absent;
            return Bare_Limited_Absent (Result);
         end Allocate_Limited_Absent;

      package Bare_Limited_Present_Memos is new Langkit_Support.Packrat
        (Bare_Limited_Present, Token_Index);

         
         subtype Subtype_For_Limited_Present is
            Root_Node_Record (Ada_Limited_Present);
         type Access_To_Subtype_For_Limited_Present is access all Subtype_For_Limited_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Limited_Present);
         package Bare_Limited_Present_Alloc is new Alloc
           (Subtype_For_Limited_Present, Access_To_Subtype_For_Limited_Present);

         function Allocate_Limited_Present
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Present;

         function Allocate_Limited_Present
           (Pool : Bump_Ptr_Pool) return Bare_Limited_Present
         is
            Result      : constant Access_To_Subtype_For_Limited_Present := Bare_Limited_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Limited_Present;
            return Bare_Limited_Present (Result);
         end Allocate_Limited_Present;

      package Bare_Loop_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Loop_Spec, Token_Index);

      package Bare_For_Loop_Spec_Memos is new Langkit_Support.Packrat
        (Bare_For_Loop_Spec, Token_Index);

         
         subtype Subtype_For_For_Loop_Spec is
            Root_Node_Record (Ada_For_Loop_Spec);
         type Access_To_Subtype_For_For_Loop_Spec is access all Subtype_For_For_Loop_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_For_Loop_Spec);
         package Bare_For_Loop_Spec_Alloc is new Alloc
           (Subtype_For_For_Loop_Spec, Access_To_Subtype_For_For_Loop_Spec);

         function Allocate_For_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Spec;

         function Allocate_For_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Spec
         is
            Result      : constant Access_To_Subtype_For_For_Loop_Spec := Bare_For_Loop_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_For_Loop_Spec;
            return Bare_For_Loop_Spec (Result);
         end Allocate_For_Loop_Spec;

      package Bare_While_Loop_Spec_Memos is new Langkit_Support.Packrat
        (Bare_While_Loop_Spec, Token_Index);

         
         subtype Subtype_For_While_Loop_Spec is
            Root_Node_Record (Ada_While_Loop_Spec);
         type Access_To_Subtype_For_While_Loop_Spec is access all Subtype_For_While_Loop_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_While_Loop_Spec);
         package Bare_While_Loop_Spec_Alloc is new Alloc
           (Subtype_For_While_Loop_Spec, Access_To_Subtype_For_While_Loop_Spec);

         function Allocate_While_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Spec;

         function Allocate_While_Loop_Spec
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Spec
         is
            Result      : constant Access_To_Subtype_For_While_Loop_Spec := Bare_While_Loop_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_While_Loop_Spec;
            return Bare_While_Loop_Spec (Result);
         end Allocate_While_Loop_Spec;

      package Bare_Mode_Memos is new Langkit_Support.Packrat
        (Bare_Mode, Token_Index);

      package Bare_Mode_Default_Memos is new Langkit_Support.Packrat
        (Bare_Mode_Default, Token_Index);

         
         subtype Subtype_For_Mode_Default is
            Root_Node_Record (Ada_Mode_Default);
         type Access_To_Subtype_For_Mode_Default is access all Subtype_For_Mode_Default;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Mode_Default);
         package Bare_Mode_Default_Alloc is new Alloc
           (Subtype_For_Mode_Default, Access_To_Subtype_For_Mode_Default);

         function Allocate_Mode_Default
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Default;

         function Allocate_Mode_Default
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Default
         is
            Result      : constant Access_To_Subtype_For_Mode_Default := Bare_Mode_Default_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_Default;
            return Bare_Mode_Default (Result);
         end Allocate_Mode_Default;

      package Bare_Mode_In_Memos is new Langkit_Support.Packrat
        (Bare_Mode_In, Token_Index);

         
         subtype Subtype_For_Mode_In is
            Root_Node_Record (Ada_Mode_In);
         type Access_To_Subtype_For_Mode_In is access all Subtype_For_Mode_In;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Mode_In);
         package Bare_Mode_In_Alloc is new Alloc
           (Subtype_For_Mode_In, Access_To_Subtype_For_Mode_In);

         function Allocate_Mode_In
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In;

         function Allocate_Mode_In
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In
         is
            Result      : constant Access_To_Subtype_For_Mode_In := Bare_Mode_In_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_In;
            return Bare_Mode_In (Result);
         end Allocate_Mode_In;

      package Bare_Mode_In_Out_Memos is new Langkit_Support.Packrat
        (Bare_Mode_In_Out, Token_Index);

         
         subtype Subtype_For_Mode_In_Out is
            Root_Node_Record (Ada_Mode_In_Out);
         type Access_To_Subtype_For_Mode_In_Out is access all Subtype_For_Mode_In_Out;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Mode_In_Out);
         package Bare_Mode_In_Out_Alloc is new Alloc
           (Subtype_For_Mode_In_Out, Access_To_Subtype_For_Mode_In_Out);

         function Allocate_Mode_In_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In_Out;

         function Allocate_Mode_In_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_In_Out
         is
            Result      : constant Access_To_Subtype_For_Mode_In_Out := Bare_Mode_In_Out_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_In_Out;
            return Bare_Mode_In_Out (Result);
         end Allocate_Mode_In_Out;

      package Bare_Mode_Out_Memos is new Langkit_Support.Packrat
        (Bare_Mode_Out, Token_Index);

         
         subtype Subtype_For_Mode_Out is
            Root_Node_Record (Ada_Mode_Out);
         type Access_To_Subtype_For_Mode_Out is access all Subtype_For_Mode_Out;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Mode_Out);
         package Bare_Mode_Out_Alloc is new Alloc
           (Subtype_For_Mode_Out, Access_To_Subtype_For_Mode_Out);

         function Allocate_Mode_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Out;

         function Allocate_Mode_Out
           (Pool : Bump_Ptr_Pool) return Bare_Mode_Out
         is
            Result      : constant Access_To_Subtype_For_Mode_Out := Bare_Mode_Out_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mode_Out;
            return Bare_Mode_Out (Result);
         end Allocate_Mode_Out;

      package Bare_Multi_Abstract_State_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Multi_Abstract_State_Decl, Token_Index);

         
         subtype Subtype_For_Multi_Abstract_State_Decl is
            Root_Node_Record (Ada_Multi_Abstract_State_Decl);
         type Access_To_Subtype_For_Multi_Abstract_State_Decl is access all Subtype_For_Multi_Abstract_State_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Multi_Abstract_State_Decl);
         package Bare_Multi_Abstract_State_Decl_Alloc is new Alloc
           (Subtype_For_Multi_Abstract_State_Decl, Access_To_Subtype_For_Multi_Abstract_State_Decl);

         function Allocate_Multi_Abstract_State_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Multi_Abstract_State_Decl;

         function Allocate_Multi_Abstract_State_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Multi_Abstract_State_Decl
         is
            Result      : constant Access_To_Subtype_For_Multi_Abstract_State_Decl := Bare_Multi_Abstract_State_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Multi_Abstract_State_Decl;
            return Bare_Multi_Abstract_State_Decl (Result);
         end Allocate_Multi_Abstract_State_Decl;

      package Bare_Not_Null_Memos is new Langkit_Support.Packrat
        (Bare_Not_Null, Token_Index);

      package Bare_Not_Null_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Not_Null_Absent, Token_Index);

         
         subtype Subtype_For_Not_Null_Absent is
            Root_Node_Record (Ada_Not_Null_Absent);
         type Access_To_Subtype_For_Not_Null_Absent is access all Subtype_For_Not_Null_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Not_Null_Absent);
         package Bare_Not_Null_Absent_Alloc is new Alloc
           (Subtype_For_Not_Null_Absent, Access_To_Subtype_For_Not_Null_Absent);

         function Allocate_Not_Null_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Absent;

         function Allocate_Not_Null_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Absent
         is
            Result      : constant Access_To_Subtype_For_Not_Null_Absent := Bare_Not_Null_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Not_Null_Absent;
            return Bare_Not_Null_Absent (Result);
         end Allocate_Not_Null_Absent;

      package Bare_Not_Null_Present_Memos is new Langkit_Support.Packrat
        (Bare_Not_Null_Present, Token_Index);

         
         subtype Subtype_For_Not_Null_Present is
            Root_Node_Record (Ada_Not_Null_Present);
         type Access_To_Subtype_For_Not_Null_Present is access all Subtype_For_Not_Null_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Not_Null_Present);
         package Bare_Not_Null_Present_Alloc is new Alloc
           (Subtype_For_Not_Null_Present, Access_To_Subtype_For_Not_Null_Present);

         function Allocate_Not_Null_Present
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Present;

         function Allocate_Not_Null_Present
           (Pool : Bump_Ptr_Pool) return Bare_Not_Null_Present
         is
            Result      : constant Access_To_Subtype_For_Not_Null_Present := Bare_Not_Null_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Not_Null_Present;
            return Bare_Not_Null_Present (Result);
         end Allocate_Not_Null_Present;

      package Bare_Null_Component_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Null_Component_Decl, Token_Index);

         
         subtype Subtype_For_Null_Component_Decl is
            Root_Node_Record (Ada_Null_Component_Decl);
         type Access_To_Subtype_For_Null_Component_Decl is access all Subtype_For_Null_Component_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Component_Decl);
         package Bare_Null_Component_Decl_Alloc is new Alloc
           (Subtype_For_Null_Component_Decl, Access_To_Subtype_For_Null_Component_Decl);

         function Allocate_Null_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Component_Decl;

         function Allocate_Null_Component_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Null_Component_Decl
         is
            Result      : constant Access_To_Subtype_For_Null_Component_Decl := Bare_Null_Component_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Component_Decl;
            return Bare_Null_Component_Decl (Result);
         end Allocate_Null_Component_Decl;

      package Bare_Others_Designator_Memos is new Langkit_Support.Packrat
        (Bare_Others_Designator, Token_Index);

         
         subtype Subtype_For_Others_Designator is
            Root_Node_Record (Ada_Others_Designator);
         type Access_To_Subtype_For_Others_Designator is access all Subtype_For_Others_Designator;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Others_Designator);
         package Bare_Others_Designator_Alloc is new Alloc
           (Subtype_For_Others_Designator, Access_To_Subtype_For_Others_Designator);

         function Allocate_Others_Designator
           (Pool : Bump_Ptr_Pool) return Bare_Others_Designator;

         function Allocate_Others_Designator
           (Pool : Bump_Ptr_Pool) return Bare_Others_Designator
         is
            Result      : constant Access_To_Subtype_For_Others_Designator := Bare_Others_Designator_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Others_Designator;
            return Bare_Others_Designator (Result);
         end Allocate_Others_Designator;

      package Bare_Overriding_Node_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Node, Token_Index);

      package Bare_Overriding_Not_Overriding_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Not_Overriding, Token_Index);

         
         subtype Subtype_For_Overriding_Not_Overriding is
            Root_Node_Record (Ada_Overriding_Not_Overriding);
         type Access_To_Subtype_For_Overriding_Not_Overriding is access all Subtype_For_Overriding_Not_Overriding;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Overriding_Not_Overriding);
         package Bare_Overriding_Not_Overriding_Alloc is new Alloc
           (Subtype_For_Overriding_Not_Overriding, Access_To_Subtype_For_Overriding_Not_Overriding);

         function Allocate_Overriding_Not_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Not_Overriding;

         function Allocate_Overriding_Not_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Not_Overriding
         is
            Result      : constant Access_To_Subtype_For_Overriding_Not_Overriding := Bare_Overriding_Not_Overriding_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Overriding_Not_Overriding;
            return Bare_Overriding_Not_Overriding (Result);
         end Allocate_Overriding_Not_Overriding;

      package Bare_Overriding_Overriding_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Overriding, Token_Index);

         
         subtype Subtype_For_Overriding_Overriding is
            Root_Node_Record (Ada_Overriding_Overriding);
         type Access_To_Subtype_For_Overriding_Overriding is access all Subtype_For_Overriding_Overriding;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Overriding_Overriding);
         package Bare_Overriding_Overriding_Alloc is new Alloc
           (Subtype_For_Overriding_Overriding, Access_To_Subtype_For_Overriding_Overriding);

         function Allocate_Overriding_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Overriding;

         function Allocate_Overriding_Overriding
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Overriding
         is
            Result      : constant Access_To_Subtype_For_Overriding_Overriding := Bare_Overriding_Overriding_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Overriding_Overriding;
            return Bare_Overriding_Overriding (Result);
         end Allocate_Overriding_Overriding;

      package Bare_Overriding_Unspecified_Memos is new Langkit_Support.Packrat
        (Bare_Overriding_Unspecified, Token_Index);

         
         subtype Subtype_For_Overriding_Unspecified is
            Root_Node_Record (Ada_Overriding_Unspecified);
         type Access_To_Subtype_For_Overriding_Unspecified is access all Subtype_For_Overriding_Unspecified;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Overriding_Unspecified);
         package Bare_Overriding_Unspecified_Alloc is new Alloc
           (Subtype_For_Overriding_Unspecified, Access_To_Subtype_For_Overriding_Unspecified);

         function Allocate_Overriding_Unspecified
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Unspecified;

         function Allocate_Overriding_Unspecified
           (Pool : Bump_Ptr_Pool) return Bare_Overriding_Unspecified
         is
            Result      : constant Access_To_Subtype_For_Overriding_Unspecified := Bare_Overriding_Unspecified_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Overriding_Unspecified;
            return Bare_Overriding_Unspecified (Result);
         end Allocate_Overriding_Unspecified;

      package Bare_Params_Memos is new Langkit_Support.Packrat
        (Bare_Params, Token_Index);

         
         subtype Subtype_For_Params is
            Root_Node_Record (Ada_Params);
         type Access_To_Subtype_For_Params is access all Subtype_For_Params;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Params);
         package Bare_Params_Alloc is new Alloc
           (Subtype_For_Params, Access_To_Subtype_For_Params);

         function Allocate_Params
           (Pool : Bump_Ptr_Pool) return Bare_Params;

         function Allocate_Params
           (Pool : Bump_Ptr_Pool) return Bare_Params
         is
            Result      : constant Access_To_Subtype_For_Params := Bare_Params_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Params;
            return Bare_Params (Result);
         end Allocate_Params;

      package Bare_Paren_Abstract_State_Decl_Memos is new Langkit_Support.Packrat
        (Bare_Paren_Abstract_State_Decl, Token_Index);

         
         subtype Subtype_For_Paren_Abstract_State_Decl is
            Root_Node_Record (Ada_Paren_Abstract_State_Decl);
         type Access_To_Subtype_For_Paren_Abstract_State_Decl is access all Subtype_For_Paren_Abstract_State_Decl;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Paren_Abstract_State_Decl);
         package Bare_Paren_Abstract_State_Decl_Alloc is new Alloc
           (Subtype_For_Paren_Abstract_State_Decl, Access_To_Subtype_For_Paren_Abstract_State_Decl);

         function Allocate_Paren_Abstract_State_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Abstract_State_Decl;

         function Allocate_Paren_Abstract_State_Decl
           (Pool : Bump_Ptr_Pool) return Bare_Paren_Abstract_State_Decl
         is
            Result      : constant Access_To_Subtype_For_Paren_Abstract_State_Decl := Bare_Paren_Abstract_State_Decl_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Paren_Abstract_State_Decl;
            return Bare_Paren_Abstract_State_Decl (Result);
         end Allocate_Paren_Abstract_State_Decl;

      package Bare_Pp_Directive_Memos is new Langkit_Support.Packrat
        (Bare_Pp_Directive, Token_Index);

      package Bare_Pp_Else_Directive_Memos is new Langkit_Support.Packrat
        (Bare_Pp_Else_Directive, Token_Index);

         
         subtype Subtype_For_Pp_Else_Directive is
            Root_Node_Record (Ada_Pp_Else_Directive);
         type Access_To_Subtype_For_Pp_Else_Directive is access all Subtype_For_Pp_Else_Directive;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pp_Else_Directive);
         package Bare_Pp_Else_Directive_Alloc is new Alloc
           (Subtype_For_Pp_Else_Directive, Access_To_Subtype_For_Pp_Else_Directive);

         function Allocate_Pp_Else_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_Else_Directive;

         function Allocate_Pp_Else_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_Else_Directive
         is
            Result      : constant Access_To_Subtype_For_Pp_Else_Directive := Bare_Pp_Else_Directive_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pp_Else_Directive;
            return Bare_Pp_Else_Directive (Result);
         end Allocate_Pp_Else_Directive;

      package Bare_Pp_Elsif_Directive_Memos is new Langkit_Support.Packrat
        (Bare_Pp_Elsif_Directive, Token_Index);

         
         subtype Subtype_For_Pp_Elsif_Directive is
            Root_Node_Record (Ada_Pp_Elsif_Directive);
         type Access_To_Subtype_For_Pp_Elsif_Directive is access all Subtype_For_Pp_Elsif_Directive;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pp_Elsif_Directive);
         package Bare_Pp_Elsif_Directive_Alloc is new Alloc
           (Subtype_For_Pp_Elsif_Directive, Access_To_Subtype_For_Pp_Elsif_Directive);

         function Allocate_Pp_Elsif_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_Elsif_Directive;

         function Allocate_Pp_Elsif_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_Elsif_Directive
         is
            Result      : constant Access_To_Subtype_For_Pp_Elsif_Directive := Bare_Pp_Elsif_Directive_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pp_Elsif_Directive;
            return Bare_Pp_Elsif_Directive (Result);
         end Allocate_Pp_Elsif_Directive;

      package Bare_Pp_End_If_Directive_Memos is new Langkit_Support.Packrat
        (Bare_Pp_End_If_Directive, Token_Index);

         
         subtype Subtype_For_Pp_End_If_Directive is
            Root_Node_Record (Ada_Pp_End_If_Directive);
         type Access_To_Subtype_For_Pp_End_If_Directive is access all Subtype_For_Pp_End_If_Directive;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pp_End_If_Directive);
         package Bare_Pp_End_If_Directive_Alloc is new Alloc
           (Subtype_For_Pp_End_If_Directive, Access_To_Subtype_For_Pp_End_If_Directive);

         function Allocate_Pp_End_If_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_End_If_Directive;

         function Allocate_Pp_End_If_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_End_If_Directive
         is
            Result      : constant Access_To_Subtype_For_Pp_End_If_Directive := Bare_Pp_End_If_Directive_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pp_End_If_Directive;
            return Bare_Pp_End_If_Directive (Result);
         end Allocate_Pp_End_If_Directive;

      package Bare_Pp_If_Directive_Memos is new Langkit_Support.Packrat
        (Bare_Pp_If_Directive, Token_Index);

         
         subtype Subtype_For_Pp_If_Directive is
            Root_Node_Record (Ada_Pp_If_Directive);
         type Access_To_Subtype_For_Pp_If_Directive is access all Subtype_For_Pp_If_Directive;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pp_If_Directive);
         package Bare_Pp_If_Directive_Alloc is new Alloc
           (Subtype_For_Pp_If_Directive, Access_To_Subtype_For_Pp_If_Directive);

         function Allocate_Pp_If_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_If_Directive;

         function Allocate_Pp_If_Directive
           (Pool : Bump_Ptr_Pool) return Bare_Pp_If_Directive
         is
            Result      : constant Access_To_Subtype_For_Pp_If_Directive := Bare_Pp_If_Directive_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pp_If_Directive;
            return Bare_Pp_If_Directive (Result);
         end Allocate_Pp_If_Directive;

      package Bare_Pp_Then_Kw_Memos is new Langkit_Support.Packrat
        (Bare_Pp_Then_Kw, Token_Index);

         
         subtype Subtype_For_Pp_Then_Kw is
            Root_Node_Record (Ada_Pp_Then_Kw);
         type Access_To_Subtype_For_Pp_Then_Kw is access all Subtype_For_Pp_Then_Kw;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pp_Then_Kw);
         package Bare_Pp_Then_Kw_Alloc is new Alloc
           (Subtype_For_Pp_Then_Kw, Access_To_Subtype_For_Pp_Then_Kw);

         function Allocate_Pp_Then_Kw
           (Pool : Bump_Ptr_Pool) return Bare_Pp_Then_Kw;

         function Allocate_Pp_Then_Kw
           (Pool : Bump_Ptr_Pool) return Bare_Pp_Then_Kw
         is
            Result      : constant Access_To_Subtype_For_Pp_Then_Kw := Bare_Pp_Then_Kw_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pp_Then_Kw;
            return Bare_Pp_Then_Kw (Result);
         end Allocate_Pp_Then_Kw;

      package Bare_Pragma_Node_Memos is new Langkit_Support.Packrat
        (Bare_Pragma_Node, Token_Index);

         
         subtype Subtype_For_Pragma_Node is
            Root_Node_Record (Ada_Pragma_Node);
         type Access_To_Subtype_For_Pragma_Node is access all Subtype_For_Pragma_Node;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Pragma_Node);
         package Bare_Pragma_Node_Alloc is new Alloc
           (Subtype_For_Pragma_Node, Access_To_Subtype_For_Pragma_Node);

         function Allocate_Pragma_Node
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node;

         function Allocate_Pragma_Node
           (Pool : Bump_Ptr_Pool) return Bare_Pragma_Node
         is
            Result      : constant Access_To_Subtype_For_Pragma_Node := Bare_Pragma_Node_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Pragma_Node;
            return Bare_Pragma_Node (Result);
         end Allocate_Pragma_Node;

      package Bare_Private_Node_Memos is new Langkit_Support.Packrat
        (Bare_Private_Node, Token_Index);

      package Bare_Private_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Private_Absent, Token_Index);

         
         subtype Subtype_For_Private_Absent is
            Root_Node_Record (Ada_Private_Absent);
         type Access_To_Subtype_For_Private_Absent is access all Subtype_For_Private_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Private_Absent);
         package Bare_Private_Absent_Alloc is new Alloc
           (Subtype_For_Private_Absent, Access_To_Subtype_For_Private_Absent);

         function Allocate_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Private_Absent;

         function Allocate_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Private_Absent
         is
            Result      : constant Access_To_Subtype_For_Private_Absent := Bare_Private_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Absent;
            return Bare_Private_Absent (Result);
         end Allocate_Private_Absent;

      package Bare_Private_Present_Memos is new Langkit_Support.Packrat
        (Bare_Private_Present, Token_Index);

         
         subtype Subtype_For_Private_Present is
            Root_Node_Record (Ada_Private_Present);
         type Access_To_Subtype_For_Private_Present is access all Subtype_For_Private_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Private_Present);
         package Bare_Private_Present_Alloc is new Alloc
           (Subtype_For_Private_Present, Access_To_Subtype_For_Private_Present);

         function Allocate_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_Private_Present;

         function Allocate_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_Private_Present
         is
            Result      : constant Access_To_Subtype_For_Private_Present := Bare_Private_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Present;
            return Bare_Private_Present (Result);
         end Allocate_Private_Present;

      package Bare_Protected_Def_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Def, Token_Index);

         
         subtype Subtype_For_Protected_Def is
            Root_Node_Record (Ada_Protected_Def);
         type Access_To_Subtype_For_Protected_Def is access all Subtype_For_Protected_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Protected_Def);
         package Bare_Protected_Def_Alloc is new Alloc
           (Subtype_For_Protected_Def, Access_To_Subtype_For_Protected_Def);

         function Allocate_Protected_Def
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Def;

         function Allocate_Protected_Def
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Def
         is
            Result      : constant Access_To_Subtype_For_Protected_Def := Bare_Protected_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Def;
            return Bare_Protected_Def (Result);
         end Allocate_Protected_Def;

      package Bare_Protected_Node_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Node, Token_Index);

      package Bare_Protected_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Absent, Token_Index);

         
         subtype Subtype_For_Protected_Absent is
            Root_Node_Record (Ada_Protected_Absent);
         type Access_To_Subtype_For_Protected_Absent is access all Subtype_For_Protected_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Protected_Absent);
         package Bare_Protected_Absent_Alloc is new Alloc
           (Subtype_For_Protected_Absent, Access_To_Subtype_For_Protected_Absent);

         function Allocate_Protected_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Absent;

         function Allocate_Protected_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Absent
         is
            Result      : constant Access_To_Subtype_For_Protected_Absent := Bare_Protected_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Absent;
            return Bare_Protected_Absent (Result);
         end Allocate_Protected_Absent;

      package Bare_Protected_Present_Memos is new Langkit_Support.Packrat
        (Bare_Protected_Present, Token_Index);

         
         subtype Subtype_For_Protected_Present is
            Root_Node_Record (Ada_Protected_Present);
         type Access_To_Subtype_For_Protected_Present is access all Subtype_For_Protected_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Protected_Present);
         package Bare_Protected_Present_Alloc is new Alloc
           (Subtype_For_Protected_Present, Access_To_Subtype_For_Protected_Present);

         function Allocate_Protected_Present
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Present;

         function Allocate_Protected_Present
           (Pool : Bump_Ptr_Pool) return Bare_Protected_Present
         is
            Result      : constant Access_To_Subtype_For_Protected_Present := Bare_Protected_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Protected_Present;
            return Bare_Protected_Present (Result);
         end Allocate_Protected_Present;

      package Bare_Quantifier_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier, Token_Index);

      package Bare_Quantifier_All_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_All, Token_Index);

         
         subtype Subtype_For_Quantifier_All is
            Root_Node_Record (Ada_Quantifier_All);
         type Access_To_Subtype_For_Quantifier_All is access all Subtype_For_Quantifier_All;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Quantifier_All);
         package Bare_Quantifier_All_Alloc is new Alloc
           (Subtype_For_Quantifier_All, Access_To_Subtype_For_Quantifier_All);

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All;

         function Allocate_Quantifier_All
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_All
         is
            Result      : constant Access_To_Subtype_For_Quantifier_All := Bare_Quantifier_All_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Quantifier_All;
            return Bare_Quantifier_All (Result);
         end Allocate_Quantifier_All;

      package Bare_Quantifier_Some_Memos is new Langkit_Support.Packrat
        (Bare_Quantifier_Some, Token_Index);

         
         subtype Subtype_For_Quantifier_Some is
            Root_Node_Record (Ada_Quantifier_Some);
         type Access_To_Subtype_For_Quantifier_Some is access all Subtype_For_Quantifier_Some;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Quantifier_Some);
         package Bare_Quantifier_Some_Alloc is new Alloc
           (Subtype_For_Quantifier_Some, Access_To_Subtype_For_Quantifier_Some);

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some;

         function Allocate_Quantifier_Some
           (Pool : Bump_Ptr_Pool) return Bare_Quantifier_Some
         is
            Result      : constant Access_To_Subtype_For_Quantifier_Some := Bare_Quantifier_Some_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Quantifier_Some;
            return Bare_Quantifier_Some (Result);
         end Allocate_Quantifier_Some;

      package Bare_Range_Spec_Memos is new Langkit_Support.Packrat
        (Bare_Range_Spec, Token_Index);

         
         subtype Subtype_For_Range_Spec is
            Root_Node_Record (Ada_Range_Spec);
         type Access_To_Subtype_For_Range_Spec is access all Subtype_For_Range_Spec;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Range_Spec);
         package Bare_Range_Spec_Alloc is new Alloc
           (Subtype_For_Range_Spec, Access_To_Subtype_For_Range_Spec);

         function Allocate_Range_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Range_Spec;

         function Allocate_Range_Spec
           (Pool : Bump_Ptr_Pool) return Bare_Range_Spec
         is
            Result      : constant Access_To_Subtype_For_Range_Spec := Bare_Range_Spec_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Range_Spec;
            return Bare_Range_Spec (Result);
         end Allocate_Range_Spec;

      package Bare_Renaming_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Renaming_Clause, Token_Index);

         
         subtype Subtype_For_Renaming_Clause is
            Root_Node_Record (Ada_Renaming_Clause);
         type Access_To_Subtype_For_Renaming_Clause is access all Subtype_For_Renaming_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Renaming_Clause);
         package Bare_Renaming_Clause_Alloc is new Alloc
           (Subtype_For_Renaming_Clause, Access_To_Subtype_For_Renaming_Clause);

         function Allocate_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Clause;

         function Allocate_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Renaming_Clause
         is
            Result      : constant Access_To_Subtype_For_Renaming_Clause := Bare_Renaming_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Renaming_Clause;
            return Bare_Renaming_Clause (Result);
         end Allocate_Renaming_Clause;

      package Bare_Synthetic_Renaming_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Renaming_Clause, Token_Index);

         
         subtype Subtype_For_Synthetic_Renaming_Clause is
            Root_Node_Record (Ada_Synthetic_Renaming_Clause);
         type Access_To_Subtype_For_Synthetic_Renaming_Clause is access all Subtype_For_Synthetic_Renaming_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Renaming_Clause);
         package Bare_Synthetic_Renaming_Clause_Alloc is new Alloc
           (Subtype_For_Synthetic_Renaming_Clause, Access_To_Subtype_For_Synthetic_Renaming_Clause);

         function Allocate_Synthetic_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Renaming_Clause;

         function Allocate_Synthetic_Renaming_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Renaming_Clause
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Renaming_Clause := Bare_Synthetic_Renaming_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Renaming_Clause;
            return Bare_Synthetic_Renaming_Clause (Result);
         end Allocate_Synthetic_Renaming_Clause;

      package Bare_Reverse_Node_Memos is new Langkit_Support.Packrat
        (Bare_Reverse_Node, Token_Index);

      package Bare_Reverse_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Reverse_Absent, Token_Index);

         
         subtype Subtype_For_Reverse_Absent is
            Root_Node_Record (Ada_Reverse_Absent);
         type Access_To_Subtype_For_Reverse_Absent is access all Subtype_For_Reverse_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Reverse_Absent);
         package Bare_Reverse_Absent_Alloc is new Alloc
           (Subtype_For_Reverse_Absent, Access_To_Subtype_For_Reverse_Absent);

         function Allocate_Reverse_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Absent;

         function Allocate_Reverse_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Absent
         is
            Result      : constant Access_To_Subtype_For_Reverse_Absent := Bare_Reverse_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Reverse_Absent;
            return Bare_Reverse_Absent (Result);
         end Allocate_Reverse_Absent;

      package Bare_Reverse_Present_Memos is new Langkit_Support.Packrat
        (Bare_Reverse_Present, Token_Index);

         
         subtype Subtype_For_Reverse_Present is
            Root_Node_Record (Ada_Reverse_Present);
         type Access_To_Subtype_For_Reverse_Present is access all Subtype_For_Reverse_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Reverse_Present);
         package Bare_Reverse_Present_Alloc is new Alloc
           (Subtype_For_Reverse_Present, Access_To_Subtype_For_Reverse_Present);

         function Allocate_Reverse_Present
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Present;

         function Allocate_Reverse_Present
           (Pool : Bump_Ptr_Pool) return Bare_Reverse_Present
         is
            Result      : constant Access_To_Subtype_For_Reverse_Present := Bare_Reverse_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Reverse_Present;
            return Bare_Reverse_Present (Result);
         end Allocate_Reverse_Present;

      package Bare_Select_When_Part_Memos is new Langkit_Support.Packrat
        (Bare_Select_When_Part, Token_Index);

         
         subtype Subtype_For_Select_When_Part is
            Root_Node_Record (Ada_Select_When_Part);
         type Access_To_Subtype_For_Select_When_Part is access all Subtype_For_Select_When_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Select_When_Part);
         package Bare_Select_When_Part_Alloc is new Alloc
           (Subtype_For_Select_When_Part, Access_To_Subtype_For_Select_When_Part);

         function Allocate_Select_When_Part
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part;

         function Allocate_Select_When_Part
           (Pool : Bump_Ptr_Pool) return Bare_Select_When_Part
         is
            Result      : constant Access_To_Subtype_For_Select_When_Part := Bare_Select_When_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Select_When_Part;
            return Bare_Select_When_Part (Result);
         end Allocate_Select_When_Part;

      package Bare_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Stmt, Token_Index);

      package Bare_Composite_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Composite_Stmt, Token_Index);

      package Bare_Accept_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Accept_Stmt, Token_Index);

         
         subtype Subtype_For_Accept_Stmt is
            Root_Node_Record (Ada_Accept_Stmt);
         type Access_To_Subtype_For_Accept_Stmt is access all Subtype_For_Accept_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Accept_Stmt);
         package Bare_Accept_Stmt_Alloc is new Alloc
           (Subtype_For_Accept_Stmt, Access_To_Subtype_For_Accept_Stmt);

         function Allocate_Accept_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt;

         function Allocate_Accept_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt
         is
            Result      : constant Access_To_Subtype_For_Accept_Stmt := Bare_Accept_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Accept_Stmt;
            return Bare_Accept_Stmt (Result);
         end Allocate_Accept_Stmt;

      package Bare_Accept_Stmt_With_Stmts_Memos is new Langkit_Support.Packrat
        (Bare_Accept_Stmt_With_Stmts, Token_Index);

         
         subtype Subtype_For_Accept_Stmt_With_Stmts is
            Root_Node_Record (Ada_Accept_Stmt_With_Stmts);
         type Access_To_Subtype_For_Accept_Stmt_With_Stmts is access all Subtype_For_Accept_Stmt_With_Stmts;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Accept_Stmt_With_Stmts);
         package Bare_Accept_Stmt_With_Stmts_Alloc is new Alloc
           (Subtype_For_Accept_Stmt_With_Stmts, Access_To_Subtype_For_Accept_Stmt_With_Stmts);

         function Allocate_Accept_Stmt_With_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt_With_Stmts;

         function Allocate_Accept_Stmt_With_Stmts
           (Pool : Bump_Ptr_Pool) return Bare_Accept_Stmt_With_Stmts
         is
            Result      : constant Access_To_Subtype_For_Accept_Stmt_With_Stmts := Bare_Accept_Stmt_With_Stmts_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Accept_Stmt_With_Stmts;
            return Bare_Accept_Stmt_With_Stmts (Result);
         end Allocate_Accept_Stmt_With_Stmts;

      package Bare_Base_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Base_Loop_Stmt, Token_Index);

      package Bare_For_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_For_Loop_Stmt, Token_Index);

         
         subtype Subtype_For_For_Loop_Stmt is
            Root_Node_Record (Ada_For_Loop_Stmt);
         type Access_To_Subtype_For_For_Loop_Stmt is access all Subtype_For_For_Loop_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_For_Loop_Stmt);
         package Bare_For_Loop_Stmt_Alloc is new Alloc
           (Subtype_For_For_Loop_Stmt, Access_To_Subtype_For_For_Loop_Stmt);

         function Allocate_For_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Stmt;

         function Allocate_For_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_For_Loop_Stmt
         is
            Result      : constant Access_To_Subtype_For_For_Loop_Stmt := Bare_For_Loop_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_For_Loop_Stmt;
            return Bare_For_Loop_Stmt (Result);
         end Allocate_For_Loop_Stmt;

      package Bare_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Loop_Stmt, Token_Index);

         
         subtype Subtype_For_Loop_Stmt is
            Root_Node_Record (Ada_Loop_Stmt);
         type Access_To_Subtype_For_Loop_Stmt is access all Subtype_For_Loop_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Loop_Stmt);
         package Bare_Loop_Stmt_Alloc is new Alloc
           (Subtype_For_Loop_Stmt, Access_To_Subtype_For_Loop_Stmt);

         function Allocate_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Loop_Stmt;

         function Allocate_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Loop_Stmt
         is
            Result      : constant Access_To_Subtype_For_Loop_Stmt := Bare_Loop_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Loop_Stmt;
            return Bare_Loop_Stmt (Result);
         end Allocate_Loop_Stmt;

      package Bare_While_Loop_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_While_Loop_Stmt, Token_Index);

         
         subtype Subtype_For_While_Loop_Stmt is
            Root_Node_Record (Ada_While_Loop_Stmt);
         type Access_To_Subtype_For_While_Loop_Stmt is access all Subtype_For_While_Loop_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_While_Loop_Stmt);
         package Bare_While_Loop_Stmt_Alloc is new Alloc
           (Subtype_For_While_Loop_Stmt, Access_To_Subtype_For_While_Loop_Stmt);

         function Allocate_While_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Stmt;

         function Allocate_While_Loop_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_While_Loop_Stmt
         is
            Result      : constant Access_To_Subtype_For_While_Loop_Stmt := Bare_While_Loop_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_While_Loop_Stmt;
            return Bare_While_Loop_Stmt (Result);
         end Allocate_While_Loop_Stmt;

      package Bare_Block_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Block_Stmt, Token_Index);

      package Bare_Begin_Block_Memos is new Langkit_Support.Packrat
        (Bare_Begin_Block, Token_Index);

         
         subtype Subtype_For_Begin_Block is
            Root_Node_Record (Ada_Begin_Block);
         type Access_To_Subtype_For_Begin_Block is access all Subtype_For_Begin_Block;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Begin_Block);
         package Bare_Begin_Block_Alloc is new Alloc
           (Subtype_For_Begin_Block, Access_To_Subtype_For_Begin_Block);

         function Allocate_Begin_Block
           (Pool : Bump_Ptr_Pool) return Bare_Begin_Block;

         function Allocate_Begin_Block
           (Pool : Bump_Ptr_Pool) return Bare_Begin_Block
         is
            Result      : constant Access_To_Subtype_For_Begin_Block := Bare_Begin_Block_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Begin_Block;
            return Bare_Begin_Block (Result);
         end Allocate_Begin_Block;

      package Bare_Decl_Block_Memos is new Langkit_Support.Packrat
        (Bare_Decl_Block, Token_Index);

         
         subtype Subtype_For_Decl_Block is
            Root_Node_Record (Ada_Decl_Block);
         type Access_To_Subtype_For_Decl_Block is access all Subtype_For_Decl_Block;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decl_Block);
         package Bare_Decl_Block_Alloc is new Alloc
           (Subtype_For_Decl_Block, Access_To_Subtype_For_Decl_Block);

         function Allocate_Decl_Block
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Block;

         function Allocate_Decl_Block
           (Pool : Bump_Ptr_Pool) return Bare_Decl_Block
         is
            Result      : constant Access_To_Subtype_For_Decl_Block := Bare_Decl_Block_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decl_Block;
            return Bare_Decl_Block (Result);
         end Allocate_Decl_Block;

      package Bare_Case_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Case_Stmt, Token_Index);

         
         subtype Subtype_For_Case_Stmt is
            Root_Node_Record (Ada_Case_Stmt);
         type Access_To_Subtype_For_Case_Stmt is access all Subtype_For_Case_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Case_Stmt);
         package Bare_Case_Stmt_Alloc is new Alloc
           (Subtype_For_Case_Stmt, Access_To_Subtype_For_Case_Stmt);

         function Allocate_Case_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt;

         function Allocate_Case_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Case_Stmt
         is
            Result      : constant Access_To_Subtype_For_Case_Stmt := Bare_Case_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Case_Stmt;
            return Bare_Case_Stmt (Result);
         end Allocate_Case_Stmt;

      package Bare_Extended_Return_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Extended_Return_Stmt, Token_Index);

         
         subtype Subtype_For_Extended_Return_Stmt is
            Root_Node_Record (Ada_Extended_Return_Stmt);
         type Access_To_Subtype_For_Extended_Return_Stmt is access all Subtype_For_Extended_Return_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Extended_Return_Stmt);
         package Bare_Extended_Return_Stmt_Alloc is new Alloc
           (Subtype_For_Extended_Return_Stmt, Access_To_Subtype_For_Extended_Return_Stmt);

         function Allocate_Extended_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt;

         function Allocate_Extended_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Extended_Return_Stmt
         is
            Result      : constant Access_To_Subtype_For_Extended_Return_Stmt := Bare_Extended_Return_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Extended_Return_Stmt;
            return Bare_Extended_Return_Stmt (Result);
         end Allocate_Extended_Return_Stmt;

      package Bare_If_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_If_Stmt, Token_Index);

         
         subtype Subtype_For_If_Stmt is
            Root_Node_Record (Ada_If_Stmt);
         type Access_To_Subtype_For_If_Stmt is access all Subtype_For_If_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_If_Stmt);
         package Bare_If_Stmt_Alloc is new Alloc
           (Subtype_For_If_Stmt, Access_To_Subtype_For_If_Stmt);

         function Allocate_If_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_If_Stmt;

         function Allocate_If_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_If_Stmt
         is
            Result      : constant Access_To_Subtype_For_If_Stmt := Bare_If_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_If_Stmt;
            return Bare_If_Stmt (Result);
         end Allocate_If_Stmt;

      package Bare_Named_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Named_Stmt, Token_Index);

         
         subtype Subtype_For_Named_Stmt is
            Root_Node_Record (Ada_Named_Stmt);
         type Access_To_Subtype_For_Named_Stmt is access all Subtype_For_Named_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Named_Stmt);
         package Bare_Named_Stmt_Alloc is new Alloc
           (Subtype_For_Named_Stmt, Access_To_Subtype_For_Named_Stmt);

         function Allocate_Named_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt;

         function Allocate_Named_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Named_Stmt
         is
            Result      : constant Access_To_Subtype_For_Named_Stmt := Bare_Named_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Named_Stmt;
            return Bare_Named_Stmt (Result);
         end Allocate_Named_Stmt;

      package Bare_Select_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Select_Stmt, Token_Index);

         
         subtype Subtype_For_Select_Stmt is
            Root_Node_Record (Ada_Select_Stmt);
         type Access_To_Subtype_For_Select_Stmt is access all Subtype_For_Select_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Select_Stmt);
         package Bare_Select_Stmt_Alloc is new Alloc
           (Subtype_For_Select_Stmt, Access_To_Subtype_For_Select_Stmt);

         function Allocate_Select_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Select_Stmt;

         function Allocate_Select_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Select_Stmt
         is
            Result      : constant Access_To_Subtype_For_Select_Stmt := Bare_Select_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Select_Stmt;
            return Bare_Select_Stmt (Result);
         end Allocate_Select_Stmt;

      package Bare_Error_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Error_Stmt, Token_Index);

         
         subtype Subtype_For_Error_Stmt is
            Root_Node_Record (Ada_Error_Stmt);
         type Access_To_Subtype_For_Error_Stmt is access all Subtype_For_Error_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Error_Stmt);
         package Bare_Error_Stmt_Alloc is new Alloc
           (Subtype_For_Error_Stmt, Access_To_Subtype_For_Error_Stmt);

         function Allocate_Error_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Error_Stmt;

         function Allocate_Error_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Error_Stmt
         is
            Result      : constant Access_To_Subtype_For_Error_Stmt := Bare_Error_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Error_Stmt;
            return Bare_Error_Stmt (Result);
         end Allocate_Error_Stmt;

      package Bare_Simple_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Simple_Stmt, Token_Index);

      package Bare_Abort_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Abort_Stmt, Token_Index);

         
         subtype Subtype_For_Abort_Stmt is
            Root_Node_Record (Ada_Abort_Stmt);
         type Access_To_Subtype_For_Abort_Stmt is access all Subtype_For_Abort_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Abort_Stmt);
         package Bare_Abort_Stmt_Alloc is new Alloc
           (Subtype_For_Abort_Stmt, Access_To_Subtype_For_Abort_Stmt);

         function Allocate_Abort_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Stmt;

         function Allocate_Abort_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Abort_Stmt
         is
            Result      : constant Access_To_Subtype_For_Abort_Stmt := Bare_Abort_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Abort_Stmt;
            return Bare_Abort_Stmt (Result);
         end Allocate_Abort_Stmt;

      package Bare_Assign_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Assign_Stmt, Token_Index);

         
         subtype Subtype_For_Assign_Stmt is
            Root_Node_Record (Ada_Assign_Stmt);
         type Access_To_Subtype_For_Assign_Stmt is access all Subtype_For_Assign_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Assign_Stmt);
         package Bare_Assign_Stmt_Alloc is new Alloc
           (Subtype_For_Assign_Stmt, Access_To_Subtype_For_Assign_Stmt);

         function Allocate_Assign_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Assign_Stmt;

         function Allocate_Assign_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Assign_Stmt
         is
            Result      : constant Access_To_Subtype_For_Assign_Stmt := Bare_Assign_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Assign_Stmt;
            return Bare_Assign_Stmt (Result);
         end Allocate_Assign_Stmt;

      package Bare_Call_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Call_Stmt, Token_Index);

         
         subtype Subtype_For_Call_Stmt is
            Root_Node_Record (Ada_Call_Stmt);
         type Access_To_Subtype_For_Call_Stmt is access all Subtype_For_Call_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Call_Stmt);
         package Bare_Call_Stmt_Alloc is new Alloc
           (Subtype_For_Call_Stmt, Access_To_Subtype_For_Call_Stmt);

         function Allocate_Call_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Call_Stmt;

         function Allocate_Call_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Call_Stmt
         is
            Result      : constant Access_To_Subtype_For_Call_Stmt := Bare_Call_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Call_Stmt;
            return Bare_Call_Stmt (Result);
         end Allocate_Call_Stmt;

      package Bare_Delay_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Delay_Stmt, Token_Index);

         
         subtype Subtype_For_Delay_Stmt is
            Root_Node_Record (Ada_Delay_Stmt);
         type Access_To_Subtype_For_Delay_Stmt is access all Subtype_For_Delay_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Delay_Stmt);
         package Bare_Delay_Stmt_Alloc is new Alloc
           (Subtype_For_Delay_Stmt, Access_To_Subtype_For_Delay_Stmt);

         function Allocate_Delay_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Delay_Stmt;

         function Allocate_Delay_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Delay_Stmt
         is
            Result      : constant Access_To_Subtype_For_Delay_Stmt := Bare_Delay_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Delay_Stmt;
            return Bare_Delay_Stmt (Result);
         end Allocate_Delay_Stmt;

      package Bare_Exit_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Exit_Stmt, Token_Index);

         
         subtype Subtype_For_Exit_Stmt is
            Root_Node_Record (Ada_Exit_Stmt);
         type Access_To_Subtype_For_Exit_Stmt is access all Subtype_For_Exit_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Exit_Stmt);
         package Bare_Exit_Stmt_Alloc is new Alloc
           (Subtype_For_Exit_Stmt, Access_To_Subtype_For_Exit_Stmt);

         function Allocate_Exit_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Exit_Stmt;

         function Allocate_Exit_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Exit_Stmt
         is
            Result      : constant Access_To_Subtype_For_Exit_Stmt := Bare_Exit_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Exit_Stmt;
            return Bare_Exit_Stmt (Result);
         end Allocate_Exit_Stmt;

      package Bare_Goto_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Goto_Stmt, Token_Index);

         
         subtype Subtype_For_Goto_Stmt is
            Root_Node_Record (Ada_Goto_Stmt);
         type Access_To_Subtype_For_Goto_Stmt is access all Subtype_For_Goto_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Goto_Stmt);
         package Bare_Goto_Stmt_Alloc is new Alloc
           (Subtype_For_Goto_Stmt, Access_To_Subtype_For_Goto_Stmt);

         function Allocate_Goto_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Goto_Stmt;

         function Allocate_Goto_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Goto_Stmt
         is
            Result      : constant Access_To_Subtype_For_Goto_Stmt := Bare_Goto_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Goto_Stmt;
            return Bare_Goto_Stmt (Result);
         end Allocate_Goto_Stmt;

      package Bare_Label_Memos is new Langkit_Support.Packrat
        (Bare_Label, Token_Index);

         
         subtype Subtype_For_Label is
            Root_Node_Record (Ada_Label);
         type Access_To_Subtype_For_Label is access all Subtype_For_Label;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Label);
         package Bare_Label_Alloc is new Alloc
           (Subtype_For_Label, Access_To_Subtype_For_Label);

         function Allocate_Label
           (Pool : Bump_Ptr_Pool) return Bare_Label;

         function Allocate_Label
           (Pool : Bump_Ptr_Pool) return Bare_Label
         is
            Result      : constant Access_To_Subtype_For_Label := Bare_Label_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Label;
            return Bare_Label (Result);
         end Allocate_Label;

      package Bare_Null_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Null_Stmt, Token_Index);

         
         subtype Subtype_For_Null_Stmt is
            Root_Node_Record (Ada_Null_Stmt);
         type Access_To_Subtype_For_Null_Stmt is access all Subtype_For_Null_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Null_Stmt);
         package Bare_Null_Stmt_Alloc is new Alloc
           (Subtype_For_Null_Stmt, Access_To_Subtype_For_Null_Stmt);

         function Allocate_Null_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Null_Stmt;

         function Allocate_Null_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Null_Stmt
         is
            Result      : constant Access_To_Subtype_For_Null_Stmt := Bare_Null_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Null_Stmt;
            return Bare_Null_Stmt (Result);
         end Allocate_Null_Stmt;

      package Bare_Raise_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Raise_Stmt, Token_Index);

         
         subtype Subtype_For_Raise_Stmt is
            Root_Node_Record (Ada_Raise_Stmt);
         type Access_To_Subtype_For_Raise_Stmt is access all Subtype_For_Raise_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Raise_Stmt);
         package Bare_Raise_Stmt_Alloc is new Alloc
           (Subtype_For_Raise_Stmt, Access_To_Subtype_For_Raise_Stmt);

         function Allocate_Raise_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Stmt;

         function Allocate_Raise_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Raise_Stmt
         is
            Result      : constant Access_To_Subtype_For_Raise_Stmt := Bare_Raise_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Raise_Stmt;
            return Bare_Raise_Stmt (Result);
         end Allocate_Raise_Stmt;

      package Bare_Requeue_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Requeue_Stmt, Token_Index);

         
         subtype Subtype_For_Requeue_Stmt is
            Root_Node_Record (Ada_Requeue_Stmt);
         type Access_To_Subtype_For_Requeue_Stmt is access all Subtype_For_Requeue_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Requeue_Stmt);
         package Bare_Requeue_Stmt_Alloc is new Alloc
           (Subtype_For_Requeue_Stmt, Access_To_Subtype_For_Requeue_Stmt);

         function Allocate_Requeue_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Requeue_Stmt;

         function Allocate_Requeue_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Requeue_Stmt
         is
            Result      : constant Access_To_Subtype_For_Requeue_Stmt := Bare_Requeue_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Requeue_Stmt;
            return Bare_Requeue_Stmt (Result);
         end Allocate_Requeue_Stmt;

      package Bare_Return_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Return_Stmt, Token_Index);

         
         subtype Subtype_For_Return_Stmt is
            Root_Node_Record (Ada_Return_Stmt);
         type Access_To_Subtype_For_Return_Stmt is access all Subtype_For_Return_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Return_Stmt);
         package Bare_Return_Stmt_Alloc is new Alloc
           (Subtype_For_Return_Stmt, Access_To_Subtype_For_Return_Stmt);

         function Allocate_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Return_Stmt;

         function Allocate_Return_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Return_Stmt
         is
            Result      : constant Access_To_Subtype_For_Return_Stmt := Bare_Return_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Return_Stmt;
            return Bare_Return_Stmt (Result);
         end Allocate_Return_Stmt;

      package Bare_Simple_Decl_Stmt_Memos is new Langkit_Support.Packrat
        (Bare_Simple_Decl_Stmt, Token_Index);

         
         subtype Subtype_For_Simple_Decl_Stmt is
            Root_Node_Record (Ada_Simple_Decl_Stmt);
         type Access_To_Subtype_For_Simple_Decl_Stmt is access all Subtype_For_Simple_Decl_Stmt;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Simple_Decl_Stmt);
         package Bare_Simple_Decl_Stmt_Alloc is new Alloc
           (Subtype_For_Simple_Decl_Stmt, Access_To_Subtype_For_Simple_Decl_Stmt);

         function Allocate_Simple_Decl_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Simple_Decl_Stmt;

         function Allocate_Simple_Decl_Stmt
           (Pool : Bump_Ptr_Pool) return Bare_Simple_Decl_Stmt
         is
            Result      : constant Access_To_Subtype_For_Simple_Decl_Stmt := Bare_Simple_Decl_Stmt_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Simple_Decl_Stmt;
            return Bare_Simple_Decl_Stmt (Result);
         end Allocate_Simple_Decl_Stmt;

      package Bare_Terminate_Alternative_Memos is new Langkit_Support.Packrat
        (Bare_Terminate_Alternative, Token_Index);

         
         subtype Subtype_For_Terminate_Alternative is
            Root_Node_Record (Ada_Terminate_Alternative);
         type Access_To_Subtype_For_Terminate_Alternative is access all Subtype_For_Terminate_Alternative;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Terminate_Alternative);
         package Bare_Terminate_Alternative_Alloc is new Alloc
           (Subtype_For_Terminate_Alternative, Access_To_Subtype_For_Terminate_Alternative);

         function Allocate_Terminate_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Terminate_Alternative;

         function Allocate_Terminate_Alternative
           (Pool : Bump_Ptr_Pool) return Bare_Terminate_Alternative
         is
            Result      : constant Access_To_Subtype_For_Terminate_Alternative := Bare_Terminate_Alternative_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Terminate_Alternative;
            return Bare_Terminate_Alternative (Result);
         end Allocate_Terminate_Alternative;

      package Bare_Subp_Kind_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Kind, Token_Index);

      package Bare_Subp_Kind_Function_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Kind_Function, Token_Index);

         
         subtype Subtype_For_Subp_Kind_Function is
            Root_Node_Record (Ada_Subp_Kind_Function);
         type Access_To_Subtype_For_Subp_Kind_Function is access all Subtype_For_Subp_Kind_Function;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subp_Kind_Function);
         package Bare_Subp_Kind_Function_Alloc is new Alloc
           (Subtype_For_Subp_Kind_Function, Access_To_Subtype_For_Subp_Kind_Function);

         function Allocate_Subp_Kind_Function
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Function;

         function Allocate_Subp_Kind_Function
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Function
         is
            Result      : constant Access_To_Subtype_For_Subp_Kind_Function := Bare_Subp_Kind_Function_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Kind_Function;
            return Bare_Subp_Kind_Function (Result);
         end Allocate_Subp_Kind_Function;

      package Bare_Subp_Kind_Procedure_Memos is new Langkit_Support.Packrat
        (Bare_Subp_Kind_Procedure, Token_Index);

         
         subtype Subtype_For_Subp_Kind_Procedure is
            Root_Node_Record (Ada_Subp_Kind_Procedure);
         type Access_To_Subtype_For_Subp_Kind_Procedure is access all Subtype_For_Subp_Kind_Procedure;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subp_Kind_Procedure);
         package Bare_Subp_Kind_Procedure_Alloc is new Alloc
           (Subtype_For_Subp_Kind_Procedure, Access_To_Subtype_For_Subp_Kind_Procedure);

         function Allocate_Subp_Kind_Procedure
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Procedure;

         function Allocate_Subp_Kind_Procedure
           (Pool : Bump_Ptr_Pool) return Bare_Subp_Kind_Procedure
         is
            Result      : constant Access_To_Subtype_For_Subp_Kind_Procedure := Bare_Subp_Kind_Procedure_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subp_Kind_Procedure;
            return Bare_Subp_Kind_Procedure (Result);
         end Allocate_Subp_Kind_Procedure;

      package Bare_Subunit_Memos is new Langkit_Support.Packrat
        (Bare_Subunit, Token_Index);

         
         subtype Subtype_For_Subunit is
            Root_Node_Record (Ada_Subunit);
         type Access_To_Subtype_For_Subunit is access all Subtype_For_Subunit;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subunit);
         package Bare_Subunit_Alloc is new Alloc
           (Subtype_For_Subunit, Access_To_Subtype_For_Subunit);

         function Allocate_Subunit
           (Pool : Bump_Ptr_Pool) return Bare_Subunit;

         function Allocate_Subunit
           (Pool : Bump_Ptr_Pool) return Bare_Subunit
         is
            Result      : constant Access_To_Subtype_For_Subunit := Bare_Subunit_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subunit;
            return Bare_Subunit (Result);
         end Allocate_Subunit;

      package Bare_Synchronized_Node_Memos is new Langkit_Support.Packrat
        (Bare_Synchronized_Node, Token_Index);

      package Bare_Synchronized_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Synchronized_Absent, Token_Index);

         
         subtype Subtype_For_Synchronized_Absent is
            Root_Node_Record (Ada_Synchronized_Absent);
         type Access_To_Subtype_For_Synchronized_Absent is access all Subtype_For_Synchronized_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synchronized_Absent);
         package Bare_Synchronized_Absent_Alloc is new Alloc
           (Subtype_For_Synchronized_Absent, Access_To_Subtype_For_Synchronized_Absent);

         function Allocate_Synchronized_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Absent;

         function Allocate_Synchronized_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Absent
         is
            Result      : constant Access_To_Subtype_For_Synchronized_Absent := Bare_Synchronized_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synchronized_Absent;
            return Bare_Synchronized_Absent (Result);
         end Allocate_Synchronized_Absent;

      package Bare_Synchronized_Present_Memos is new Langkit_Support.Packrat
        (Bare_Synchronized_Present, Token_Index);

         
         subtype Subtype_For_Synchronized_Present is
            Root_Node_Record (Ada_Synchronized_Present);
         type Access_To_Subtype_For_Synchronized_Present is access all Subtype_For_Synchronized_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synchronized_Present);
         package Bare_Synchronized_Present_Alloc is new Alloc
           (Subtype_For_Synchronized_Present, Access_To_Subtype_For_Synchronized_Present);

         function Allocate_Synchronized_Present
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Present;

         function Allocate_Synchronized_Present
           (Pool : Bump_Ptr_Pool) return Bare_Synchronized_Present
         is
            Result      : constant Access_To_Subtype_For_Synchronized_Present := Bare_Synchronized_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synchronized_Present;
            return Bare_Synchronized_Present (Result);
         end Allocate_Synchronized_Present;

      package Bare_Tagged_Node_Memos is new Langkit_Support.Packrat
        (Bare_Tagged_Node, Token_Index);

      package Bare_Tagged_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Tagged_Absent, Token_Index);

         
         subtype Subtype_For_Tagged_Absent is
            Root_Node_Record (Ada_Tagged_Absent);
         type Access_To_Subtype_For_Tagged_Absent is access all Subtype_For_Tagged_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Tagged_Absent);
         package Bare_Tagged_Absent_Alloc is new Alloc
           (Subtype_For_Tagged_Absent, Access_To_Subtype_For_Tagged_Absent);

         function Allocate_Tagged_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Absent;

         function Allocate_Tagged_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Absent
         is
            Result      : constant Access_To_Subtype_For_Tagged_Absent := Bare_Tagged_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Tagged_Absent;
            return Bare_Tagged_Absent (Result);
         end Allocate_Tagged_Absent;

      package Bare_Tagged_Present_Memos is new Langkit_Support.Packrat
        (Bare_Tagged_Present, Token_Index);

         
         subtype Subtype_For_Tagged_Present is
            Root_Node_Record (Ada_Tagged_Present);
         type Access_To_Subtype_For_Tagged_Present is access all Subtype_For_Tagged_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Tagged_Present);
         package Bare_Tagged_Present_Alloc is new Alloc
           (Subtype_For_Tagged_Present, Access_To_Subtype_For_Tagged_Present);

         function Allocate_Tagged_Present
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Present;

         function Allocate_Tagged_Present
           (Pool : Bump_Ptr_Pool) return Bare_Tagged_Present
         is
            Result      : constant Access_To_Subtype_For_Tagged_Present := Bare_Tagged_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Tagged_Present;
            return Bare_Tagged_Present (Result);
         end Allocate_Tagged_Present;

      package Bare_Task_Def_Memos is new Langkit_Support.Packrat
        (Bare_Task_Def, Token_Index);

         
         subtype Subtype_For_Task_Def is
            Root_Node_Record (Ada_Task_Def);
         type Access_To_Subtype_For_Task_Def is access all Subtype_For_Task_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Task_Def);
         package Bare_Task_Def_Alloc is new Alloc
           (Subtype_For_Task_Def, Access_To_Subtype_For_Task_Def);

         function Allocate_Task_Def
           (Pool : Bump_Ptr_Pool) return Bare_Task_Def;

         function Allocate_Task_Def
           (Pool : Bump_Ptr_Pool) return Bare_Task_Def
         is
            Result      : constant Access_To_Subtype_For_Task_Def := Bare_Task_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Task_Def;
            return Bare_Task_Def (Result);
         end Allocate_Task_Def;

      package Bare_Type_Attributes_Repository_Memos is new Langkit_Support.Packrat
        (Bare_Type_Attributes_Repository, Token_Index);

         
         subtype Subtype_For_Type_Attributes_Repository is
            Root_Node_Record (Ada_Type_Attributes_Repository);
         type Access_To_Subtype_For_Type_Attributes_Repository is access all Subtype_For_Type_Attributes_Repository;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Attributes_Repository);
         package Bare_Type_Attributes_Repository_Alloc is new Alloc
           (Subtype_For_Type_Attributes_Repository, Access_To_Subtype_For_Type_Attributes_Repository);

         function Allocate_Type_Attributes_Repository
           (Pool : Bump_Ptr_Pool) return Bare_Type_Attributes_Repository;

         function Allocate_Type_Attributes_Repository
           (Pool : Bump_Ptr_Pool) return Bare_Type_Attributes_Repository
         is
            Result      : constant Access_To_Subtype_For_Type_Attributes_Repository := Bare_Type_Attributes_Repository_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Type_Attributes_Repository;
            return Bare_Type_Attributes_Repository (Result);
         end Allocate_Type_Attributes_Repository;

      package Bare_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Def, Token_Index);

      package Bare_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Access_Def, Token_Index);

      package Bare_Access_To_Subp_Def_Memos is new Langkit_Support.Packrat
        (Bare_Access_To_Subp_Def, Token_Index);

         
         subtype Subtype_For_Access_To_Subp_Def is
            Root_Node_Record (Ada_Access_To_Subp_Def);
         type Access_To_Subtype_For_Access_To_Subp_Def is access all Subtype_For_Access_To_Subp_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Access_To_Subp_Def);
         package Bare_Access_To_Subp_Def_Alloc is new Alloc
           (Subtype_For_Access_To_Subp_Def, Access_To_Subtype_For_Access_To_Subp_Def);

         function Allocate_Access_To_Subp_Def
           (Pool : Bump_Ptr_Pool) return Bare_Access_To_Subp_Def;

         function Allocate_Access_To_Subp_Def
           (Pool : Bump_Ptr_Pool) return Bare_Access_To_Subp_Def
         is
            Result      : constant Access_To_Subtype_For_Access_To_Subp_Def := Bare_Access_To_Subp_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Access_To_Subp_Def;
            return Bare_Access_To_Subp_Def (Result);
         end Allocate_Access_To_Subp_Def;

      package Bare_Base_Type_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Base_Type_Access_Def, Token_Index);

      package Bare_Anonymous_Type_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Type_Access_Def, Token_Index);

         
         subtype Subtype_For_Anonymous_Type_Access_Def is
            Root_Node_Record (Ada_Anonymous_Type_Access_Def);
         type Access_To_Subtype_For_Anonymous_Type_Access_Def is access all Subtype_For_Anonymous_Type_Access_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Anonymous_Type_Access_Def);
         package Bare_Anonymous_Type_Access_Def_Alloc is new Alloc
           (Subtype_For_Anonymous_Type_Access_Def, Access_To_Subtype_For_Anonymous_Type_Access_Def);

         function Allocate_Anonymous_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Access_Def;

         function Allocate_Anonymous_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type_Access_Def
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Type_Access_Def := Bare_Anonymous_Type_Access_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Type_Access_Def;
            return Bare_Anonymous_Type_Access_Def (Result);
         end Allocate_Anonymous_Type_Access_Def;

      package Bare_Type_Access_Def_Memos is new Langkit_Support.Packrat
        (Bare_Type_Access_Def, Token_Index);

         
         subtype Subtype_For_Type_Access_Def is
            Root_Node_Record (Ada_Type_Access_Def);
         type Access_To_Subtype_For_Type_Access_Def is access all Subtype_For_Type_Access_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Type_Access_Def);
         package Bare_Type_Access_Def_Alloc is new Alloc
           (Subtype_For_Type_Access_Def, Access_To_Subtype_For_Type_Access_Def);

         function Allocate_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Access_Def;

         function Allocate_Type_Access_Def
           (Pool : Bump_Ptr_Pool) return Bare_Type_Access_Def
         is
            Result      : constant Access_To_Subtype_For_Type_Access_Def := Bare_Type_Access_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Type_Access_Def;
            return Bare_Type_Access_Def (Result);
         end Allocate_Type_Access_Def;

      package Bare_Array_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Array_Type_Def, Token_Index);

         
         subtype Subtype_For_Array_Type_Def is
            Root_Node_Record (Ada_Array_Type_Def);
         type Access_To_Subtype_For_Array_Type_Def is access all Subtype_For_Array_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Array_Type_Def);
         package Bare_Array_Type_Def_Alloc is new Alloc
           (Subtype_For_Array_Type_Def, Access_To_Subtype_For_Array_Type_Def);

         function Allocate_Array_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Array_Type_Def;

         function Allocate_Array_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Array_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Array_Type_Def := Bare_Array_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Array_Type_Def;
            return Bare_Array_Type_Def (Result);
         end Allocate_Array_Type_Def;

      package Bare_Derived_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Derived_Type_Def, Token_Index);

         
         subtype Subtype_For_Derived_Type_Def is
            Root_Node_Record (Ada_Derived_Type_Def);
         type Access_To_Subtype_For_Derived_Type_Def is access all Subtype_For_Derived_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Derived_Type_Def);
         package Bare_Derived_Type_Def_Alloc is new Alloc
           (Subtype_For_Derived_Type_Def, Access_To_Subtype_For_Derived_Type_Def);

         function Allocate_Derived_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Derived_Type_Def;

         function Allocate_Derived_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Derived_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Derived_Type_Def := Bare_Derived_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Derived_Type_Def;
            return Bare_Derived_Type_Def (Result);
         end Allocate_Derived_Type_Def;

      package Bare_Enum_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Type_Def, Token_Index);

         
         subtype Subtype_For_Enum_Type_Def is
            Root_Node_Record (Ada_Enum_Type_Def);
         type Access_To_Subtype_For_Enum_Type_Def is access all Subtype_For_Enum_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Type_Def);
         package Bare_Enum_Type_Def_Alloc is new Alloc
           (Subtype_For_Enum_Type_Def, Access_To_Subtype_For_Enum_Type_Def);

         function Allocate_Enum_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Type_Def;

         function Allocate_Enum_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Enum_Type_Def := Bare_Enum_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Type_Def;
            return Bare_Enum_Type_Def (Result);
         end Allocate_Enum_Type_Def;

      package Bare_Formal_Discrete_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Formal_Discrete_Type_Def, Token_Index);

         
         subtype Subtype_For_Formal_Discrete_Type_Def is
            Root_Node_Record (Ada_Formal_Discrete_Type_Def);
         type Access_To_Subtype_For_Formal_Discrete_Type_Def is access all Subtype_For_Formal_Discrete_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Formal_Discrete_Type_Def);
         package Bare_Formal_Discrete_Type_Def_Alloc is new Alloc
           (Subtype_For_Formal_Discrete_Type_Def, Access_To_Subtype_For_Formal_Discrete_Type_Def);

         function Allocate_Formal_Discrete_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Discrete_Type_Def;

         function Allocate_Formal_Discrete_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Formal_Discrete_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Formal_Discrete_Type_Def := Bare_Formal_Discrete_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Formal_Discrete_Type_Def;
            return Bare_Formal_Discrete_Type_Def (Result);
         end Allocate_Formal_Discrete_Type_Def;

      package Bare_Interface_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Interface_Type_Def, Token_Index);

         
         subtype Subtype_For_Interface_Type_Def is
            Root_Node_Record (Ada_Interface_Type_Def);
         type Access_To_Subtype_For_Interface_Type_Def is access all Subtype_For_Interface_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Interface_Type_Def);
         package Bare_Interface_Type_Def_Alloc is new Alloc
           (Subtype_For_Interface_Type_Def, Access_To_Subtype_For_Interface_Type_Def);

         function Allocate_Interface_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Type_Def;

         function Allocate_Interface_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Interface_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Interface_Type_Def := Bare_Interface_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Interface_Type_Def;
            return Bare_Interface_Type_Def (Result);
         end Allocate_Interface_Type_Def;

      package Bare_Mod_Int_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Mod_Int_Type_Def, Token_Index);

         
         subtype Subtype_For_Mod_Int_Type_Def is
            Root_Node_Record (Ada_Mod_Int_Type_Def);
         type Access_To_Subtype_For_Mod_Int_Type_Def is access all Subtype_For_Mod_Int_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Mod_Int_Type_Def);
         package Bare_Mod_Int_Type_Def_Alloc is new Alloc
           (Subtype_For_Mod_Int_Type_Def, Access_To_Subtype_For_Mod_Int_Type_Def);

         function Allocate_Mod_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Mod_Int_Type_Def;

         function Allocate_Mod_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Mod_Int_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Mod_Int_Type_Def := Bare_Mod_Int_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Mod_Int_Type_Def;
            return Bare_Mod_Int_Type_Def (Result);
         end Allocate_Mod_Int_Type_Def;

      package Bare_Private_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Private_Type_Def, Token_Index);

         
         subtype Subtype_For_Private_Type_Def is
            Root_Node_Record (Ada_Private_Type_Def);
         type Access_To_Subtype_For_Private_Type_Def is access all Subtype_For_Private_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Private_Type_Def);
         package Bare_Private_Type_Def_Alloc is new Alloc
           (Subtype_For_Private_Type_Def, Access_To_Subtype_For_Private_Type_Def);

         function Allocate_Private_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Private_Type_Def;

         function Allocate_Private_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Private_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Private_Type_Def := Bare_Private_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Private_Type_Def;
            return Bare_Private_Type_Def (Result);
         end Allocate_Private_Type_Def;

      package Bare_Real_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Real_Type_Def, Token_Index);

      package Bare_Decimal_Fixed_Point_Def_Memos is new Langkit_Support.Packrat
        (Bare_Decimal_Fixed_Point_Def, Token_Index);

         
         subtype Subtype_For_Decimal_Fixed_Point_Def is
            Root_Node_Record (Ada_Decimal_Fixed_Point_Def);
         type Access_To_Subtype_For_Decimal_Fixed_Point_Def is access all Subtype_For_Decimal_Fixed_Point_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Decimal_Fixed_Point_Def);
         package Bare_Decimal_Fixed_Point_Def_Alloc is new Alloc
           (Subtype_For_Decimal_Fixed_Point_Def, Access_To_Subtype_For_Decimal_Fixed_Point_Def);

         function Allocate_Decimal_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Decimal_Fixed_Point_Def;

         function Allocate_Decimal_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Decimal_Fixed_Point_Def
         is
            Result      : constant Access_To_Subtype_For_Decimal_Fixed_Point_Def := Bare_Decimal_Fixed_Point_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Decimal_Fixed_Point_Def;
            return Bare_Decimal_Fixed_Point_Def (Result);
         end Allocate_Decimal_Fixed_Point_Def;

      package Bare_Floating_Point_Def_Memos is new Langkit_Support.Packrat
        (Bare_Floating_Point_Def, Token_Index);

         
         subtype Subtype_For_Floating_Point_Def is
            Root_Node_Record (Ada_Floating_Point_Def);
         type Access_To_Subtype_For_Floating_Point_Def is access all Subtype_For_Floating_Point_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Floating_Point_Def);
         package Bare_Floating_Point_Def_Alloc is new Alloc
           (Subtype_For_Floating_Point_Def, Access_To_Subtype_For_Floating_Point_Def);

         function Allocate_Floating_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Floating_Point_Def;

         function Allocate_Floating_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Floating_Point_Def
         is
            Result      : constant Access_To_Subtype_For_Floating_Point_Def := Bare_Floating_Point_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Floating_Point_Def;
            return Bare_Floating_Point_Def (Result);
         end Allocate_Floating_Point_Def;

      package Bare_Ordinary_Fixed_Point_Def_Memos is new Langkit_Support.Packrat
        (Bare_Ordinary_Fixed_Point_Def, Token_Index);

         
         subtype Subtype_For_Ordinary_Fixed_Point_Def is
            Root_Node_Record (Ada_Ordinary_Fixed_Point_Def);
         type Access_To_Subtype_For_Ordinary_Fixed_Point_Def is access all Subtype_For_Ordinary_Fixed_Point_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Ordinary_Fixed_Point_Def);
         package Bare_Ordinary_Fixed_Point_Def_Alloc is new Alloc
           (Subtype_For_Ordinary_Fixed_Point_Def, Access_To_Subtype_For_Ordinary_Fixed_Point_Def);

         function Allocate_Ordinary_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Ordinary_Fixed_Point_Def;

         function Allocate_Ordinary_Fixed_Point_Def
           (Pool : Bump_Ptr_Pool) return Bare_Ordinary_Fixed_Point_Def
         is
            Result      : constant Access_To_Subtype_For_Ordinary_Fixed_Point_Def := Bare_Ordinary_Fixed_Point_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Ordinary_Fixed_Point_Def;
            return Bare_Ordinary_Fixed_Point_Def (Result);
         end Allocate_Ordinary_Fixed_Point_Def;

      package Bare_Record_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Record_Type_Def, Token_Index);

         
         subtype Subtype_For_Record_Type_Def is
            Root_Node_Record (Ada_Record_Type_Def);
         type Access_To_Subtype_For_Record_Type_Def is access all Subtype_For_Record_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Record_Type_Def);
         package Bare_Record_Type_Def_Alloc is new Alloc
           (Subtype_For_Record_Type_Def, Access_To_Subtype_For_Record_Type_Def);

         function Allocate_Record_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Type_Def;

         function Allocate_Record_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Record_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Record_Type_Def := Bare_Record_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Record_Type_Def;
            return Bare_Record_Type_Def (Result);
         end Allocate_Record_Type_Def;

      package Bare_Signed_Int_Type_Def_Memos is new Langkit_Support.Packrat
        (Bare_Signed_Int_Type_Def, Token_Index);

         
         subtype Subtype_For_Signed_Int_Type_Def is
            Root_Node_Record (Ada_Signed_Int_Type_Def);
         type Access_To_Subtype_For_Signed_Int_Type_Def is access all Subtype_For_Signed_Int_Type_Def;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Signed_Int_Type_Def);
         package Bare_Signed_Int_Type_Def_Alloc is new Alloc
           (Subtype_For_Signed_Int_Type_Def, Access_To_Subtype_For_Signed_Int_Type_Def);

         function Allocate_Signed_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Signed_Int_Type_Def;

         function Allocate_Signed_Int_Type_Def
           (Pool : Bump_Ptr_Pool) return Bare_Signed_Int_Type_Def
         is
            Result      : constant Access_To_Subtype_For_Signed_Int_Type_Def := Bare_Signed_Int_Type_Def_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Signed_Int_Type_Def;
            return Bare_Signed_Int_Type_Def (Result);
         end Allocate_Signed_Int_Type_Def;

      package Bare_Type_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Type_Expr, Token_Index);

      package Bare_Anonymous_Type_Memos is new Langkit_Support.Packrat
        (Bare_Anonymous_Type, Token_Index);

         
         subtype Subtype_For_Anonymous_Type is
            Root_Node_Record (Ada_Anonymous_Type);
         type Access_To_Subtype_For_Anonymous_Type is access all Subtype_For_Anonymous_Type;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Anonymous_Type);
         package Bare_Anonymous_Type_Alloc is new Alloc
           (Subtype_For_Anonymous_Type, Access_To_Subtype_For_Anonymous_Type);

         function Allocate_Anonymous_Type
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type;

         function Allocate_Anonymous_Type
           (Pool : Bump_Ptr_Pool) return Bare_Anonymous_Type
         is
            Result      : constant Access_To_Subtype_For_Anonymous_Type := Bare_Anonymous_Type_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Anonymous_Type;
            return Bare_Anonymous_Type (Result);
         end Allocate_Anonymous_Type;

      package Bare_Enum_Lit_Synth_Type_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Enum_Lit_Synth_Type_Expr, Token_Index);

         
         subtype Subtype_For_Enum_Lit_Synth_Type_Expr is
            Root_Node_Record (Ada_Enum_Lit_Synth_Type_Expr);
         type Access_To_Subtype_For_Enum_Lit_Synth_Type_Expr is access all Subtype_For_Enum_Lit_Synth_Type_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Enum_Lit_Synth_Type_Expr);
         package Bare_Enum_Lit_Synth_Type_Expr_Alloc is new Alloc
           (Subtype_For_Enum_Lit_Synth_Type_Expr, Access_To_Subtype_For_Enum_Lit_Synth_Type_Expr);

         function Allocate_Enum_Lit_Synth_Type_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Synth_Type_Expr;

         function Allocate_Enum_Lit_Synth_Type_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Enum_Lit_Synth_Type_Expr
         is
            Result      : constant Access_To_Subtype_For_Enum_Lit_Synth_Type_Expr := Bare_Enum_Lit_Synth_Type_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Enum_Lit_Synth_Type_Expr;
            return Bare_Enum_Lit_Synth_Type_Expr (Result);
         end Allocate_Enum_Lit_Synth_Type_Expr;

      package Bare_Subtype_Indication_Memos is new Langkit_Support.Packrat
        (Bare_Subtype_Indication, Token_Index);

         
         subtype Subtype_For_Subtype_Indication is
            Root_Node_Record (Ada_Subtype_Indication);
         type Access_To_Subtype_For_Subtype_Indication is access all Subtype_For_Subtype_Indication;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Subtype_Indication);
         package Bare_Subtype_Indication_Alloc is new Alloc
           (Subtype_For_Subtype_Indication, Access_To_Subtype_For_Subtype_Indication);

         function Allocate_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Indication;

         function Allocate_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Subtype_Indication
         is
            Result      : constant Access_To_Subtype_For_Subtype_Indication := Bare_Subtype_Indication_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Subtype_Indication;
            return Bare_Subtype_Indication (Result);
         end Allocate_Subtype_Indication;

      package Bare_Constrained_Subtype_Indication_Memos is new Langkit_Support.Packrat
        (Bare_Constrained_Subtype_Indication, Token_Index);

         
         subtype Subtype_For_Constrained_Subtype_Indication is
            Root_Node_Record (Ada_Constrained_Subtype_Indication);
         type Access_To_Subtype_For_Constrained_Subtype_Indication is access all Subtype_For_Constrained_Subtype_Indication;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Constrained_Subtype_Indication);
         package Bare_Constrained_Subtype_Indication_Alloc is new Alloc
           (Subtype_For_Constrained_Subtype_Indication, Access_To_Subtype_For_Constrained_Subtype_Indication);

         function Allocate_Constrained_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Subtype_Indication;

         function Allocate_Constrained_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Constrained_Subtype_Indication
         is
            Result      : constant Access_To_Subtype_For_Constrained_Subtype_Indication := Bare_Constrained_Subtype_Indication_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Constrained_Subtype_Indication;
            return Bare_Constrained_Subtype_Indication (Result);
         end Allocate_Constrained_Subtype_Indication;

      package Bare_Discrete_Subtype_Indication_Memos is new Langkit_Support.Packrat
        (Bare_Discrete_Subtype_Indication, Token_Index);

         
         subtype Subtype_For_Discrete_Subtype_Indication is
            Root_Node_Record (Ada_Discrete_Subtype_Indication);
         type Access_To_Subtype_For_Discrete_Subtype_Indication is access all Subtype_For_Discrete_Subtype_Indication;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Discrete_Subtype_Indication);
         package Bare_Discrete_Subtype_Indication_Alloc is new Alloc
           (Subtype_For_Discrete_Subtype_Indication, Access_To_Subtype_For_Discrete_Subtype_Indication);

         function Allocate_Discrete_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Indication;

         function Allocate_Discrete_Subtype_Indication
           (Pool : Bump_Ptr_Pool) return Bare_Discrete_Subtype_Indication
         is
            Result      : constant Access_To_Subtype_For_Discrete_Subtype_Indication := Bare_Discrete_Subtype_Indication_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Discrete_Subtype_Indication;
            return Bare_Discrete_Subtype_Indication (Result);
         end Allocate_Discrete_Subtype_Indication;

      package Bare_Synthetic_Type_Expr_Memos is new Langkit_Support.Packrat
        (Bare_Synthetic_Type_Expr, Token_Index);

         
         subtype Subtype_For_Synthetic_Type_Expr is
            Root_Node_Record (Ada_Synthetic_Type_Expr);
         type Access_To_Subtype_For_Synthetic_Type_Expr is access all Subtype_For_Synthetic_Type_Expr;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Synthetic_Type_Expr);
         package Bare_Synthetic_Type_Expr_Alloc is new Alloc
           (Subtype_For_Synthetic_Type_Expr, Access_To_Subtype_For_Synthetic_Type_Expr);

         function Allocate_Synthetic_Type_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Type_Expr;

         function Allocate_Synthetic_Type_Expr
           (Pool : Bump_Ptr_Pool) return Bare_Synthetic_Type_Expr
         is
            Result      : constant Access_To_Subtype_For_Synthetic_Type_Expr := Bare_Synthetic_Type_Expr_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Synthetic_Type_Expr;
            return Bare_Synthetic_Type_Expr (Result);
         end Allocate_Synthetic_Type_Expr;

      package Bare_Unconstrained_Array_Index_Memos is new Langkit_Support.Packrat
        (Bare_Unconstrained_Array_Index, Token_Index);

         
         subtype Subtype_For_Unconstrained_Array_Index is
            Root_Node_Record (Ada_Unconstrained_Array_Index);
         type Access_To_Subtype_For_Unconstrained_Array_Index is access all Subtype_For_Unconstrained_Array_Index;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Unconstrained_Array_Index);
         package Bare_Unconstrained_Array_Index_Alloc is new Alloc
           (Subtype_For_Unconstrained_Array_Index, Access_To_Subtype_For_Unconstrained_Array_Index);

         function Allocate_Unconstrained_Array_Index
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index;

         function Allocate_Unconstrained_Array_Index
           (Pool : Bump_Ptr_Pool) return Bare_Unconstrained_Array_Index
         is
            Result      : constant Access_To_Subtype_For_Unconstrained_Array_Index := Bare_Unconstrained_Array_Index_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Unconstrained_Array_Index;
            return Bare_Unconstrained_Array_Index (Result);
         end Allocate_Unconstrained_Array_Index;

      package Bare_Until_Node_Memos is new Langkit_Support.Packrat
        (Bare_Until_Node, Token_Index);

      package Bare_Until_Absent_Memos is new Langkit_Support.Packrat
        (Bare_Until_Absent, Token_Index);

         
         subtype Subtype_For_Until_Absent is
            Root_Node_Record (Ada_Until_Absent);
         type Access_To_Subtype_For_Until_Absent is access all Subtype_For_Until_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Until_Absent);
         package Bare_Until_Absent_Alloc is new Alloc
           (Subtype_For_Until_Absent, Access_To_Subtype_For_Until_Absent);

         function Allocate_Until_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Until_Absent;

         function Allocate_Until_Absent
           (Pool : Bump_Ptr_Pool) return Bare_Until_Absent
         is
            Result      : constant Access_To_Subtype_For_Until_Absent := Bare_Until_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Until_Absent;
            return Bare_Until_Absent (Result);
         end Allocate_Until_Absent;

      package Bare_Until_Present_Memos is new Langkit_Support.Packrat
        (Bare_Until_Present, Token_Index);

         
         subtype Subtype_For_Until_Present is
            Root_Node_Record (Ada_Until_Present);
         type Access_To_Subtype_For_Until_Present is access all Subtype_For_Until_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Until_Present);
         package Bare_Until_Present_Alloc is new Alloc
           (Subtype_For_Until_Present, Access_To_Subtype_For_Until_Present);

         function Allocate_Until_Present
           (Pool : Bump_Ptr_Pool) return Bare_Until_Present;

         function Allocate_Until_Present
           (Pool : Bump_Ptr_Pool) return Bare_Until_Present
         is
            Result      : constant Access_To_Subtype_For_Until_Present := Bare_Until_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Until_Present;
            return Bare_Until_Present (Result);
         end Allocate_Until_Present;

      package Bare_Use_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Use_Clause, Token_Index);

      package Bare_Use_Package_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Use_Package_Clause, Token_Index);

         
         subtype Subtype_For_Use_Package_Clause is
            Root_Node_Record (Ada_Use_Package_Clause);
         type Access_To_Subtype_For_Use_Package_Clause is access all Subtype_For_Use_Package_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Use_Package_Clause);
         package Bare_Use_Package_Clause_Alloc is new Alloc
           (Subtype_For_Use_Package_Clause, Access_To_Subtype_For_Use_Package_Clause);

         function Allocate_Use_Package_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Package_Clause;

         function Allocate_Use_Package_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Package_Clause
         is
            Result      : constant Access_To_Subtype_For_Use_Package_Clause := Bare_Use_Package_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Use_Package_Clause;
            return Bare_Use_Package_Clause (Result);
         end Allocate_Use_Package_Clause;

      package Bare_Use_Type_Clause_Memos is new Langkit_Support.Packrat
        (Bare_Use_Type_Clause, Token_Index);

         
         subtype Subtype_For_Use_Type_Clause is
            Root_Node_Record (Ada_Use_Type_Clause);
         type Access_To_Subtype_For_Use_Type_Clause is access all Subtype_For_Use_Type_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Use_Type_Clause);
         package Bare_Use_Type_Clause_Alloc is new Alloc
           (Subtype_For_Use_Type_Clause, Access_To_Subtype_For_Use_Type_Clause);

         function Allocate_Use_Type_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Type_Clause;

         function Allocate_Use_Type_Clause
           (Pool : Bump_Ptr_Pool) return Bare_Use_Type_Clause
         is
            Result      : constant Access_To_Subtype_For_Use_Type_Clause := Bare_Use_Type_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Use_Type_Clause;
            return Bare_Use_Type_Clause (Result);
         end Allocate_Use_Type_Clause;

      package Bare_Value_Sequence_Memos is new Langkit_Support.Packrat
        (Bare_Value_Sequence, Token_Index);

         
         subtype Subtype_For_Value_Sequence is
            Root_Node_Record (Ada_Value_Sequence);
         type Access_To_Subtype_For_Value_Sequence is access all Subtype_For_Value_Sequence;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Value_Sequence);
         package Bare_Value_Sequence_Alloc is new Alloc
           (Subtype_For_Value_Sequence, Access_To_Subtype_For_Value_Sequence);

         function Allocate_Value_Sequence
           (Pool : Bump_Ptr_Pool) return Bare_Value_Sequence;

         function Allocate_Value_Sequence
           (Pool : Bump_Ptr_Pool) return Bare_Value_Sequence
         is
            Result      : constant Access_To_Subtype_For_Value_Sequence := Bare_Value_Sequence_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Value_Sequence;
            return Bare_Value_Sequence (Result);
         end Allocate_Value_Sequence;

      package Bare_Variant_Memos is new Langkit_Support.Packrat
        (Bare_Variant, Token_Index);

         
         subtype Subtype_For_Variant is
            Root_Node_Record (Ada_Variant);
         type Access_To_Subtype_For_Variant is access all Subtype_For_Variant;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Variant);
         package Bare_Variant_Alloc is new Alloc
           (Subtype_For_Variant, Access_To_Subtype_For_Variant);

         function Allocate_Variant
           (Pool : Bump_Ptr_Pool) return Bare_Variant;

         function Allocate_Variant
           (Pool : Bump_Ptr_Pool) return Bare_Variant
         is
            Result      : constant Access_To_Subtype_For_Variant := Bare_Variant_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Variant;
            return Bare_Variant (Result);
         end Allocate_Variant;

      package Bare_Variant_Part_Memos is new Langkit_Support.Packrat
        (Bare_Variant_Part, Token_Index);

         
         subtype Subtype_For_Variant_Part is
            Root_Node_Record (Ada_Variant_Part);
         type Access_To_Subtype_For_Variant_Part is access all Subtype_For_Variant_Part;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_Variant_Part);
         package Bare_Variant_Part_Alloc is new Alloc
           (Subtype_For_Variant_Part, Access_To_Subtype_For_Variant_Part);

         function Allocate_Variant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Variant_Part;

         function Allocate_Variant_Part
           (Pool : Bump_Ptr_Pool) return Bare_Variant_Part
         is
            Result      : constant Access_To_Subtype_For_Variant_Part := Bare_Variant_Part_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_Variant_Part;
            return Bare_Variant_Part (Result);
         end Allocate_Variant_Part;

      package Bare_With_Clause_Memos is new Langkit_Support.Packrat
        (Bare_With_Clause, Token_Index);

         
         subtype Subtype_For_With_Clause is
            Root_Node_Record (Ada_With_Clause);
         type Access_To_Subtype_For_With_Clause is access all Subtype_For_With_Clause;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_With_Clause);
         package Bare_With_Clause_Alloc is new Alloc
           (Subtype_For_With_Clause, Access_To_Subtype_For_With_Clause);

         function Allocate_With_Clause
           (Pool : Bump_Ptr_Pool) return Bare_With_Clause;

         function Allocate_With_Clause
           (Pool : Bump_Ptr_Pool) return Bare_With_Clause
         is
            Result      : constant Access_To_Subtype_For_With_Clause := Bare_With_Clause_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_With_Clause;
            return Bare_With_Clause (Result);
         end Allocate_With_Clause;

      package Bare_With_Private_Memos is new Langkit_Support.Packrat
        (Bare_With_Private, Token_Index);

      package Bare_With_Private_Absent_Memos is new Langkit_Support.Packrat
        (Bare_With_Private_Absent, Token_Index);

         
         subtype Subtype_For_With_Private_Absent is
            Root_Node_Record (Ada_With_Private_Absent);
         type Access_To_Subtype_For_With_Private_Absent is access all Subtype_For_With_Private_Absent;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_With_Private_Absent);
         package Bare_With_Private_Absent_Alloc is new Alloc
           (Subtype_For_With_Private_Absent, Access_To_Subtype_For_With_Private_Absent);

         function Allocate_With_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Absent;

         function Allocate_With_Private_Absent
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Absent
         is
            Result      : constant Access_To_Subtype_For_With_Private_Absent := Bare_With_Private_Absent_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_With_Private_Absent;
            return Bare_With_Private_Absent (Result);
         end Allocate_With_Private_Absent;

      package Bare_With_Private_Present_Memos is new Langkit_Support.Packrat
        (Bare_With_Private_Present, Token_Index);

         
         subtype Subtype_For_With_Private_Present is
            Root_Node_Record (Ada_With_Private_Present);
         type Access_To_Subtype_For_With_Private_Present is access all Subtype_For_With_Private_Present;
         pragma No_Strict_Aliasing (Access_To_Subtype_For_With_Private_Present);
         package Bare_With_Private_Present_Alloc is new Alloc
           (Subtype_For_With_Private_Present, Access_To_Subtype_For_With_Private_Present);

         function Allocate_With_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Present;

         function Allocate_With_Private_Present
           (Pool : Bump_Ptr_Pool) return Bare_With_Private_Present
         is
            Result      : constant Access_To_Subtype_For_With_Private_Present := Bare_With_Private_Present_Alloc.Alloc (Pool);
            Result_Kind : Ada_Node_Kind_Type
               with Import, Address => Result.Kind'Address;
            --  Result.Kind is a discriminant, so we can't modify it directly.
            --  We need to initialize it manually, though, as we don't use a
            --  standard Ada allocator for nodes. Use an overlay to workaround
            --  Ada's restrictions.
         begin
            Result_Kind := Ada_With_Private_Present;
            return Bare_With_Private_Present (Result);
         end Allocate_With_Private_Present;

   pragma Warnings (On, "is not referenced");

   type Dontskip_Parser_Function is access function
     (Parser : in out Parser_Type;
      Pos    : Token_Index) return Bare_Ada_Node;

   package Dont_Skip_Fn_Vectors
   is new Ada.Containers.Vectors (Natural, Dontskip_Parser_Function);

   type Free_Parse_List_Record;
   type Free_Parse_List is access all Free_Parse_List_Record;
   --  Cache of temporary lists of AST nodes used in List parsers

   type Free_Parse_List_Record is record
      Nodes : Bare_Ada_Node_Vectors.Vector;
      Next  : Free_Parse_List;
   end record;

   type Parser_Private_Part_Type is record
      Parse_Lists : Free_Parse_List;

      
      Abort_Stmt_Transform_Parse0_Memo : Bare_Abort_Stmt_Memos.Memo_Type;
      
      Abstract_State_Decl_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Abstract_Subp_Decl_Transform_Parse0_Memo : Bare_Abstract_Subp_Decl_Memos.Memo_Type;
      
      Accept_Stmt_Or_Parse0_Memo : Bare_Accept_Stmt_Memos.Memo_Type;
      
      Access_Def_Or_Parse0_Memo : Bare_Access_Def_Memos.Memo_Type;
      
      Add_Term_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Aggregate_Assoc_Or_Parse1_Memo : Bare_Basic_Assoc_Memos.Memo_Type;
      
      Aggregate_Or_Parse0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Allocator_Transform_Parse0_Memo : Bare_Allocator_Memos.Memo_Type;
      
      Anonymous_Type_Decl_Transform_Parse0_Memo : Bare_Anonymous_Type_Decl_Memos.Memo_Type;
      
      Anonymous_Type_Transform_Parse0_Memo : Bare_Anonymous_Type_Memos.Memo_Type;
      
      Array_Subcomponent_Choice_Or_Parse0_Memo : Bare_Name_Memos.Memo_Type;
      
      Array_Type_Def_Transform_Parse2_Memo : Bare_Array_Type_Def_Memos.Memo_Type;
      
      Aspect_Assoc_Or_Parse2_Memo : Bare_Aspect_Assoc_Memos.Memo_Type;
      
      Aspect_Clause_Or_Parse1_Memo : Bare_Aspect_Clause_Memos.Memo_Type;
      
      Aspect_Spec_Opt_Parse0_Memo : Bare_Aspect_Spec_Memos.Memo_Type;
      
      Assignment_Stmt_Transform_Parse0_Memo : Bare_Assign_Stmt_Memos.Memo_Type;
      
      Attr_Suffix_List_Parse0_Memo : Bare_Assoc_List_Memos.Memo_Type;
      
      Basic_Decl_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Basic_Decls_List_Parse0_Memo : Bare_Ada_Node_List_Memos.Memo_Type;
      
      Block_Stmt_Or_Parse0_Memo : Bare_Composite_Stmt_Memos.Memo_Type;
      
      Body_Or_Parse0_Memo : Bare_Body_Node_Memos.Memo_Type;
      
      Body_Stub_Or_Parse0_Memo : Bare_Body_Stub_Memos.Memo_Type;
      
      Boolean_Op_Or_Parse0_Memo : Bare_Op_Memos.Memo_Type;
      
      Box_Expr_Transform_Parse0_Memo : Bare_Box_Expr_Memos.Memo_Type;
      
      Bracket_Aggregate_Or_Parse0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Call_Stmt_Transform_Parse0_Memo : Bare_Call_Stmt_Memos.Memo_Type;
      
      Call_Suffix_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Case_Alt_Transform_Parse0_Memo : Bare_Case_Stmt_Alternative_Memos.Memo_Type;
      
      Case_Expr_Alt_Transform_Parse0_Memo : Bare_Case_Expr_Alternative_Memos.Memo_Type;
      
      Case_Expr_Transform_Parse0_Memo : Bare_Case_Expr_Memos.Memo_Type;
      
      Case_Stmt_Transform_Parse0_Memo : Bare_Case_Stmt_Memos.Memo_Type;
      
      Char_Literal_Transform_Parse0_Memo : Bare_Char_Literal_Memos.Memo_Type;
      
      Choice_List_List_Parse0_Memo : Bare_Alternatives_List_Memos.Memo_Type;
      
      Choice_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Compilation_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Compilation_Unit_Transform_Parse0_Memo : Bare_Compilation_Unit_Memos.Memo_Type;
      
      Component_Clause_Transform_Parse0_Memo : Bare_Component_Clause_Memos.Memo_Type;
      
      Component_Decl_Transform_Parse0_Memo : Bare_Component_Decl_Memos.Memo_Type;
      
      Component_Def_Transform_Parse0_Memo : Bare_Component_Def_Memos.Memo_Type;
      
      Component_Item_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Component_List_Transform_Parse0_Memo : Bare_Component_List_Memos.Memo_Type;
      
      Composite_Constraint_Assoc_Transform_Parse0_Memo : Bare_Composite_Constraint_Assoc_Memos.Memo_Type;
      
      Composite_Constraint_Transform_Parse0_Memo : Bare_Composite_Constraint_Memos.Memo_Type;
      
      Compound_Stmt_Or_Parse0_Memo : Bare_Composite_Stmt_Memos.Memo_Type;
      
      Conditional_Expr_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Constrained_Subtype_Indication_Transform_Parse0_Memo : Bare_Constrained_Subtype_Indication_Memos.Memo_Type;
      
      Constraint_List_List_Parse0_Memo : Bare_Constraint_List_Memos.Memo_Type;
      
      Constraint_Or_Parse0_Memo : Bare_Constraint_Memos.Memo_Type;
      
      Context_Item_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Contract_Case_Assoc_Transform_Parse0_Memo : Bare_Contract_Case_Assoc_Memos.Memo_Type;
      
      Contract_Cases_Expr_Transform_Parse0_Memo : Bare_Contract_Cases_Memos.Memo_Type;
      
      Dec_Literal_Transform_Parse0_Memo : Bare_Real_Literal_Memos.Memo_Type;
      
      Decimal_Fixed_Point_Def_Transform_Parse0_Memo : Bare_Decimal_Fixed_Point_Def_Memos.Memo_Type;
      
      Decl_Part_Transform_Parse0_Memo : Bare_Declarative_Part_Memos.Memo_Type;
      
      Declare_Expr_Transform_Parse0_Memo : Bare_Decl_Expr_Memos.Memo_Type;
      
      Defining_Id_List_List_Parse0_Memo : Bare_Defining_Name_List_Memos.Memo_Type;
      
      Defining_Id_Transform_Parse0_Memo : Bare_Defining_Name_Memos.Memo_Type;
      
      Defining_Name_Transform_Parse0_Memo : Bare_Defining_Name_Memos.Memo_Type;
      
      Delay_Stmt_Transform_Parse0_Memo : Bare_Delay_Stmt_Memos.Memo_Type;
      
      Delta_Choice_List_List_Parse0_Memo : Bare_Alternatives_List_Memos.Memo_Type;
      
      Delta_Constraint_Transform_Parse0_Memo : Bare_Delta_Constraint_Memos.Memo_Type;
      
      Derived_Type_Def_Transform_Parse0_Memo : Bare_Derived_Type_Def_Memos.Memo_Type;
      
      Digits_Constraint_Transform_Parse0_Memo : Bare_Digits_Constraint_Memos.Memo_Type;
      
      Direct_Name_Or_Parse0_Memo : Bare_Base_Id_Memos.Memo_Type;
      
      Direct_Name_Or_Target_Name_Or_Parse0_Memo : Bare_Name_Memos.Memo_Type;
      
      Discr_Spec_List_List_Parse0_Memo : Bare_Discriminant_Spec_List_Memos.Memo_Type;
      
      Discrete_Range_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Discrete_Subtype_Definition_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Discrete_Subtype_Indication_Transform_Parse0_Memo : Bare_Discrete_Subtype_Indication_Memos.Memo_Type;
      
      Discriminant_Part_Or_Parse0_Memo : Bare_Discriminant_Part_Memos.Memo_Type;
      
      Discriminant_Spec_Transform_Parse0_Memo : Bare_Discriminant_Spec_Memos.Memo_Type;
      
      Dontskip_Case_Alt0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Elsif_Part0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Exception_Handler0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Generic_Decl0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Generic_Decl1_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Handled_Stmts0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_If_Stmt0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_If_Stmt1_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Iloop_Stmt0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Iloop_Stmt1_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Iloop_Stmt2_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Package_Body0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Package_Decl0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Package_Decl1_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Protected_Body0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Recov_Decl_Part0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Select_Stmt0_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Select_Stmt1_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Dontskip_Select_Stmt2_Extract_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Elsif_Part_Transform_Parse0_Memo : Bare_Elsif_Stmt_Part_Memos.Memo_Type;
      
      Entry_Body_Transform_Parse3_Memo : Bare_Entry_Body_Memos.Memo_Type;
      
      Entry_Decl_Transform_Parse1_Memo : Bare_Entry_Decl_Memos.Memo_Type;
      
      Enum_Literal_Decl_Transform_Parse1_Memo : Bare_Enum_Literal_Decl_Memos.Memo_Type;
      
      Enum_Type_Def_Transform_Parse0_Memo : Bare_Enum_Type_Def_Memos.Memo_Type;
      
      Exception_Decl_Transform_Parse0_Memo : Bare_Exception_Decl_Memos.Memo_Type;
      
      Exception_Handler_Transform_Parse0_Memo : Bare_Exception_Handler_Memos.Memo_Type;
      
      Exit_Stmt_Transform_Parse0_Memo : Bare_Exit_Stmt_Memos.Memo_Type;
      
      Expr_Fn_Transform_Parse0_Memo : Bare_Expr_Function_Memos.Memo_Type;
      
      Expr_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Ext_Ret_Stmt_Object_Decl_Transform_Parse0_Memo : Bare_Extended_Return_Stmt_Object_Decl_Memos.Memo_Type;
      
      Ext_Return_Stmt_Transform_Parse0_Memo : Bare_Extended_Return_Stmt_Memos.Memo_Type;
      
      Factor_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Floating_Point_Def_Transform_Parse0_Memo : Bare_Floating_Point_Def_Memos.Memo_Type;
      
      For_Loop_Param_Spec_Transform_Parse4_Memo : Bare_For_Loop_Spec_Memos.Memo_Type;
      
      Formal_Discrete_Type_Def_Transform_Parse0_Memo : Bare_Formal_Discrete_Type_Def_Memos.Memo_Type;
      
      Formal_Subp_Decl_Or_Parse2_Memo : Bare_Basic_Decl_Memos.Memo_Type;
      
      Formal_Type_Decl_Or_Parse1_Memo : Bare_Base_Type_Decl_Memos.Memo_Type;
      
      Format_String_Literal_Or_Parse0_Memo : Bare_Format_String_Literal_Memos.Memo_Type;
      
      Generic_Decl_Or_Parse0_Memo : Bare_Generic_Decl_Memos.Memo_Type;
      
      Generic_Formal_Decl_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Generic_Formal_Part_Transform_Parse0_Memo : Bare_Generic_Formal_Part_Memos.Memo_Type;
      
      Generic_Instantiation_Or_Parse1_Memo : Bare_Generic_Instantiation_Memos.Memo_Type;
      
      Generic_Renaming_Decl_Or_Parse1_Memo : Bare_Generic_Renaming_Decl_Memos.Memo_Type;
      
      Goto_Stmt_Transform_Parse0_Memo : Bare_Goto_Stmt_Memos.Memo_Type;
      
      Handled_Stmts_Transform_Parse0_Memo : Bare_Handled_Stmts_Memos.Memo_Type;
      
      Iblock_Stmt_Or_Parse0_Memo : Bare_Block_Stmt_Memos.Memo_Type;
      
      Identifier_Transform_Parse0_Memo : Bare_Identifier_Memos.Memo_Type;
      
      If_Expr_Transform_Parse1_Memo : Bare_If_Expr_Memos.Memo_Type;
      
      If_Stmt_Transform_Parse0_Memo : Bare_If_Stmt_Memos.Memo_Type;
      
      Iloop_Stmt_Or_Parse0_Memo : Bare_Base_Loop_Stmt_Memos.Memo_Type;
      
      Incomplete_Type_Decl_Or_Parse0_Memo : Bare_Incomplete_Type_Decl_Memos.Memo_Type;
      
      Int_Literal_Transform_Parse0_Memo : Bare_Int_Literal_Memos.Memo_Type;
      
      Interface_Type_Def_Transform_Parse4_Memo : Bare_Interface_Type_Def_Memos.Memo_Type;
      
      Iterated_Assoc_Transform_Parse0_Memo : Bare_Iterated_Assoc_Memos.Memo_Type;
      
      Label_Transform_Parse1_Memo : Bare_Label_Memos.Memo_Type;
      
      Library_Item_Transform_Parse1_Memo : Bare_Library_Item_Memos.Memo_Type;
      
      Library_Unit_Body_Or_Parse0_Memo : Bare_Body_Node_Memos.Memo_Type;
      
      Library_Unit_Renaming_Decl_Or_Parse0_Memo : Bare_Basic_Decl_Memos.Memo_Type;
      
      Loop_Stmt_Or_Parse0_Memo : Bare_Composite_Stmt_Memos.Memo_Type;
      
      Membership_Choice_List_List_Parse0_Memo : Bare_Expr_Alternatives_List_Memos.Memo_Type;
      
      Membership_Choice_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Mod_Int_Type_Def_Transform_Parse0_Memo : Bare_Mod_Int_Type_Def_Memos.Memo_Type;
      
      Mode_Or_Parse0_Memo : Bare_Mode_Memos.Memo_Type;
      
      Multi_Abstract_State_Decl_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Multidim_Array_Assoc_Transform_Parse0_Memo : Bare_Multi_Dim_Array_Assoc_Memos.Memo_Type;
      
      Name_Or_Parse2_Memo : Bare_Name_Memos.Memo_Type;
      
      No_Type_Object_Renaming_Decl_Transform_Parse0_Memo : Bare_No_Type_Object_Renaming_Decl_Memos.Memo_Type;
      
      Null_Literal_Transform_Parse0_Memo : Bare_Null_Literal_Memos.Memo_Type;
      
      Null_Stmt_Transform_Parse0_Memo : Bare_Null_Stmt_Memos.Memo_Type;
      
      Null_Subp_Decl_Transform_Parse0_Memo : Bare_Null_Subp_Decl_Memos.Memo_Type;
      
      Num_Literal_Or_Parse0_Memo : Bare_Num_Literal_Memos.Memo_Type;
      
      Number_Decl_Transform_Parse0_Memo : Bare_Number_Decl_Memos.Memo_Type;
      
      Object_Decl_Or_Parse0_Memo : Bare_Object_Decl_Memos.Memo_Type;
      
      Ordinary_Fixed_Point_Def_Transform_Parse0_Memo : Bare_Ordinary_Fixed_Point_Def_Memos.Memo_Type;
      
      Others_Designator_Transform_Parse0_Memo : Bare_Others_Designator_Memos.Memo_Type;
      
      Overriding_Indicator_Or_Parse0_Memo : Bare_Overriding_Node_Memos.Memo_Type;
      
      Package_Body_Stub_Transform_Parse0_Memo : Bare_Package_Body_Stub_Memos.Memo_Type;
      
      Package_Body_Transform_Parse1_Memo : Bare_Package_Body_Memos.Memo_Type;
      
      Package_Decl_Transform_Parse3_Memo : Bare_Package_Decl_Memos.Memo_Type;
      
      Package_Renaming_Decl_Transform_Parse0_Memo : Bare_Package_Renaming_Decl_Memos.Memo_Type;
      
      Param_Assoc_Transform_Parse0_Memo : Bare_Param_Assoc_Memos.Memo_Type;
      
      Param_Spec_Transform_Parse0_Memo : Bare_Param_Spec_Memos.Memo_Type;
      
      Param_Specs_Transform_Parse0_Memo : Bare_Params_Memos.Memo_Type;
      
      Paren_Expr_Transform_Parse0_Memo : Bare_Paren_Expr_Memos.Memo_Type;
      
      Parent_List_List_Parse0_Memo : Bare_Parent_List_Memos.Memo_Type;
      
      Pp_Directive_Or_Parse0_Memo : Bare_Pp_Directive_Memos.Memo_Type;
      
      Pp_Expr_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Pp_Term_Or_Parse2_Memo : Bare_Expr_Memos.Memo_Type;
      
      Pp_Then_Opt_Parse0_Memo : Bare_Pp_Then_Kw_Memos.Memo_Type;
      
      Pragma_Argument_Transform_Parse1_Memo : Bare_Pragma_Argument_Assoc_Memos.Memo_Type;
      
      Pragma_Transform_Parse0_Memo : Bare_Pragma_Node_Memos.Memo_Type;
      
      Primary_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Protected_Body_Stub_Transform_Parse0_Memo : Bare_Protected_Body_Stub_Memos.Memo_Type;
      
      Protected_Body_Transform_Parse1_Memo : Bare_Protected_Body_Memos.Memo_Type;
      
      Protected_Decl_Transform_Parse0_Memo : Bare_Single_Protected_Decl_Memos.Memo_Type;
      
      Protected_Def_Transform_Parse3_Memo : Bare_Protected_Def_Memos.Memo_Type;
      
      Protected_El_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Protected_Op_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Protected_Type_Decl_Transform_Parse0_Memo : Bare_Protected_Type_Decl_Memos.Memo_Type;
      
      Qual_Name_Internal_Or_Parse0_Memo : Bare_Name_Memos.Memo_Type;
      
      Qualified_Name_Transform_Parse0_Memo : Bare_Qual_Expr_Memos.Memo_Type;
      
      Quantified_Expr_Transform_Parse2_Memo : Bare_Quantified_Expr_Memos.Memo_Type;
      
      Raise_Expr_Or_Parse0_Memo : Bare_Raise_Expr_Memos.Memo_Type;
      
      Raise_Stmt_Or_Parse0_Memo : Bare_Raise_Stmt_Memos.Memo_Type;
      
      Range_Constraint_Transform_Parse1_Memo : Bare_Range_Constraint_Memos.Memo_Type;
      
      Range_Spec_Transform_Parse0_Memo : Bare_Range_Spec_Memos.Memo_Type;
      
      Real_Type_Def_Or_Parse0_Memo : Bare_Real_Type_Def_Memos.Memo_Type;
      
      Record_Def_Or_Parse0_Memo : Bare_Base_Record_Def_Memos.Memo_Type;
      
      Record_Type_Def_Transform_Parse0_Memo : Bare_Record_Type_Def_Memos.Memo_Type;
      
      Recov_Decl_Part_Dont_Skip_Parse0_Memo : Bare_Declarative_Part_Memos.Memo_Type;
      
      Regular_Aggregate_Or_Parse0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Rel_Op_Or_Parse0_Memo : Bare_Op_Memos.Memo_Type;
      
      Relation_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Renaming_Clause_Transform_Parse0_Memo : Bare_Renaming_Clause_Memos.Memo_Type;
      
      Requeue_Stmt_Transform_Parse0_Memo : Bare_Requeue_Stmt_Memos.Memo_Type;
      
      Return_Stmt_Transform_Parse0_Memo : Bare_Return_Stmt_Memos.Memo_Type;
      
      Select_Stmt_Transform_Parse1_Memo : Bare_Select_Stmt_Memos.Memo_Type;
      
      Sexpr_Or_Box_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Signed_Int_Type_Def_Transform_Parse0_Memo : Bare_Signed_Int_Type_Def_Memos.Memo_Type;
      
      Simple_Decl_Stmt_Transform_Parse0_Memo : Bare_Simple_Decl_Stmt_Memos.Memo_Type;
      
      Simple_Expr_Or_Parse0_Memo : Bare_Expr_Memos.Memo_Type;
      
      Simple_Stmt_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Simple_Subp_Decl_Transform_Parse0_Memo : Bare_Subp_Decl_Memos.Memo_Type;
      
      Single_Task_Decl_Transform_Parse1_Memo : Bare_Single_Task_Decl_Memos.Memo_Type;
      
      Static_Name_Or_Parse0_Memo : Bare_Name_Memos.Memo_Type;
      
      Stmt_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Stmts_List_Parse0_Memo : Bare_Stmt_List_Memos.Memo_Type;
      
      String_Literal_Transform_Parse0_Memo : Bare_String_Literal_Memos.Memo_Type;
      
      Sub_Object_Decl_Transform_Parse0_Memo : Bare_Object_Decl_Memos.Memo_Type;
      
      Subp_Body_Stub_Transform_Parse0_Memo : Bare_Subp_Body_Stub_Memos.Memo_Type;
      
      Subp_Body_Transform_Parse1_Memo : Bare_Subp_Body_Memos.Memo_Type;
      
      Subp_Decl_Or_Parse0_Memo : Bare_Basic_Decl_Memos.Memo_Type;
      
      Subp_Renaming_Decl_Transform_Parse0_Memo : Bare_Subp_Renaming_Decl_Memos.Memo_Type;
      
      Subp_Spec_Transform_Parse2_Memo : Bare_Subp_Spec_Memos.Memo_Type;
      
      Subtype_Decl_Transform_Parse0_Memo : Bare_Subtype_Decl_Memos.Memo_Type;
      
      Subtype_Indication_Transform_Parse0_Memo : Bare_Subtype_Indication_Memos.Memo_Type;
      
      Subtype_Name_Or_Parse0_Memo : Bare_Name_Memos.Memo_Type;
      
      Subunit_Transform_Parse0_Memo : Bare_Subunit_Memos.Memo_Type;
      
      Target_Name_Transform_Parse0_Memo : Bare_Target_Name_Memos.Memo_Type;
      
      Task_Body_Stub_Transform_Parse0_Memo : Bare_Task_Body_Stub_Memos.Memo_Type;
      
      Task_Body_Transform_Parse1_Memo : Bare_Task_Body_Memos.Memo_Type;
      
      Task_Def_Transform_Parse3_Memo : Bare_Task_Def_Memos.Memo_Type;
      
      Task_Item_Or_Parse0_Memo : Bare_Ada_Node_Memos.Memo_Type;
      
      Task_Type_Decl_Transform_Parse0_Memo : Bare_Task_Type_Decl_Memos.Memo_Type;
      
      Term_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Terminate_Alternative_Transform_Parse0_Memo : Bare_Terminate_Alternative_Memos.Memo_Type;
      
      Type_Decl_Or_Parse1_Memo : Bare_Base_Type_Decl_Memos.Memo_Type;
      
      Type_Def_Or_Parse0_Memo : Bare_Type_Def_Memos.Memo_Type;
      
      Type_Expr_Or_Parse0_Memo : Bare_Type_Expr_Memos.Memo_Type;
      
      Unconstrained_Index_Transform_Parse0_Memo : Bare_Unconstrained_Array_Index_Memos.Memo_Type;
      
      Unop_Term_Or_Parse1_Memo : Bare_Expr_Memos.Memo_Type;
      
      Update_Attr_Aggregate_Or_Parse0_Memo : Bare_Base_Aggregate_Memos.Memo_Type;
      
      Update_Attr_Content_List_Parse0_Memo : Bare_Assoc_List_Memos.Memo_Type;
      
      Use_Clause_Or_Parse0_Memo : Bare_Use_Clause_Memos.Memo_Type;
      
      Use_Package_Clause_Transform_Parse0_Memo : Bare_Use_Package_Clause_Memos.Memo_Type;
      
      Use_Type_Clause_Transform_Parse0_Memo : Bare_Use_Type_Clause_Memos.Memo_Type;
      
      Value_Sequence_Transform_Parse0_Memo : Bare_Value_Sequence_Memos.Memo_Type;
      
      Variant_Part_Transform_Parse0_Memo : Bare_Variant_Part_Memos.Memo_Type;
      
      Variant_Transform_Parse0_Memo : Bare_Variant_Memos.Memo_Type;
      
      While_Loop_Spec_Transform_Parse0_Memo : Bare_While_Loop_Spec_Memos.Memo_Type;
      
      With_Clause_Transform_Parse0_Memo : Bare_With_Clause_Memos.Memo_Type;

      Dont_Skip : Dont_Skip_Fn_Vectors.Vector;
   end record;
   type Parser_Private_Part is access all Parser_Private_Part_Type;
   pragma No_Strict_Aliasing (Parser_Private_Part);
   function "+" is new Ada.Unchecked_Conversion
     (System.Address, Parser_Private_Part);
   function "+" is new Ada.Unchecked_Conversion
     (Parser_Private_Part, System.Address);

   
function Abort_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abort_Stmt;

   
function Abstract_State_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Abstract_Subp_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abstract_Subp_Decl;

   
function Accept_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Accept_Stmt;

   
function Access_Def_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Access_Def;

   
function Add_Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Aggregate_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Aggregate_Assoc_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Assoc;

   
function Allocator_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Allocator;

   
function Anonymous_Type_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type;

   
function Anonymous_Type_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type_Decl;

   
function Array_Subcomponent_Choice_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Array_Type_Def_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Array_Type_Def;

   
function Aspect_Assoc_Or_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Assoc;

   
function Aspect_Clause_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Clause;

   
function Aspect_Spec_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Spec;

   
function Assignment_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assign_Stmt;

   
function Attr_Suffix_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assoc_List;

   
function Basic_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Basic_Decls_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node_List;

   
function Block_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Stmt;

   
function Body_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Node;

   
function Body_Stub_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Stub;

   
function Boolean_Op_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Op;

   
function Box_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Box_Expr;

   
function Bracket_Aggregate_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Call_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call_Stmt;

   
function Call_Suffix_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Case_Alt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Stmt_Alternative;

   
function Case_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr;

   
function Case_Expr_Alt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr_Alternative;

   
function Case_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Stmt;

   
function Char_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Char_Literal;

   
function Choice_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Choice_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Alternatives_List;

   
function Compilation_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Compilation_Unit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Compilation_Unit;

   
function Component_Clause_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Clause;

   
function Component_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Decl;

   
function Component_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Def;

   
function Component_Item_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Component_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_List;

   
function Composite_Constraint_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Constraint;

   
function Composite_Constraint_Assoc_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Constraint_Assoc;

   
function Compound_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Stmt;

   
function Conditional_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Constrained_Subtype_Indication_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constrained_Subtype_Indication;

   
function Constraint_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constraint;

   
function Constraint_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Constraint_List;

   
function Context_Item_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Contract_Case_Assoc_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Contract_Case_Assoc;

   
function Contract_Cases_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Contract_Cases;

   
function Dec_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Real_Literal;

   
function Decimal_Fixed_Point_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decimal_Fixed_Point_Def;

   
function Decl_Part_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declarative_Part;

   
function Declare_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Decl_Expr;

   
function Defining_Id_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name;

   
function Defining_Id_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name_List;

   
function Defining_Name_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Defining_Name;

   
function Delay_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Delay_Stmt;

   
function Delta_Choice_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Alternatives_List;

   
function Delta_Constraint_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Delta_Constraint;

   
function Derived_Type_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Derived_Type_Def;

   
function Digits_Constraint_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Digits_Constraint;

   
function Direct_Name_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Id;

   
function Direct_Name_Or_Target_Name_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Discr_Spec_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Spec_List;

   
function Discrete_Range_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Discrete_Subtype_Definition_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Discrete_Subtype_Indication_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discrete_Subtype_Indication;

   
function Discriminant_Part_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Part;

   
function Discriminant_Spec_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Discriminant_Spec;

   
function Dontskip_Case_Alt0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Elsif_Part0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Exception_Handler0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Generic_Decl0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Generic_Decl1_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Handled_Stmts0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_If_Stmt0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_If_Stmt1_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Iloop_Stmt0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Iloop_Stmt1_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Iloop_Stmt2_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Package_Body0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Package_Decl0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Package_Decl1_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Protected_Body0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Recov_Decl_Part0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Select_Stmt0_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Select_Stmt1_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Dontskip_Select_Stmt2_Extract_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Elsif_Part_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Elsif_Stmt_Part;

   
function Entry_Body_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Entry_Body;

   
function Entry_Decl_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Entry_Decl;

   
function Enum_Literal_Decl_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enum_Literal_Decl;

   
function Enum_Type_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Enum_Type_Def;

   
function Exception_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Exception_Decl;

   
function Exception_Handler_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Exception_Handler;

   
function Exit_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Exit_Stmt;

   
function Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Expr_Fn_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr_Function;

   
function Ext_Ret_Stmt_Object_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Extended_Return_Stmt_Object_Decl;

   
function Ext_Return_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Extended_Return_Stmt;

   
function Factor_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Floating_Point_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Floating_Point_Def;

   
function For_Loop_Param_Spec_Transform_Parse4
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_For_Loop_Spec;

   
function Formal_Discrete_Type_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Formal_Discrete_Type_Def;

   
function Formal_Subp_Decl_Or_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Decl;

   
function Formal_Type_Decl_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Type_Decl;

   
function Format_String_Literal_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Format_String_Literal;

   
function Generic_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Decl;

   
function Generic_Formal_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Generic_Formal_Part_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Formal_Part;

   
function Generic_Instantiation_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Instantiation;

   
function Generic_Renaming_Decl_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Generic_Renaming_Decl;

   
function Goto_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Goto_Stmt;

   
function Handled_Stmts_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Handled_Stmts;

   
function Iblock_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Block_Stmt;

   
function Identifier_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Identifier;

   
function If_Expr_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_If_Expr;

   
function If_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_If_Stmt;

   
function Iloop_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Loop_Stmt;

   
function Incomplete_Type_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Incomplete_Type_Decl;

   
function Int_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Int_Literal;

   
function Interface_Type_Def_Transform_Parse4
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Interface_Type_Def;

   
function Iterated_Assoc_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Iterated_Assoc;

   
function Label_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Label;

   
function Library_Item_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Library_Item;

   
function Library_Unit_Body_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Node;

   
function Library_Unit_Renaming_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Decl;

   
function Loop_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Stmt;

   
function Membership_Choice_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Membership_Choice_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr_Alternatives_List;

   
function Mod_Int_Type_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Mod_Int_Type_Def;

   
function Mode_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Mode;

   
function Multi_Abstract_State_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Multidim_Array_Assoc_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Multi_Dim_Array_Assoc;

   
function Name_Or_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function No_Type_Object_Renaming_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_No_Type_Object_Renaming_Decl;

   
function Null_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Literal;

   
function Null_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Stmt;

   
function Null_Subp_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Null_Subp_Decl;

   
function Num_Literal_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Num_Literal;

   
function Number_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Number_Decl;

   
function Object_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Object_Decl;

   
function Ordinary_Fixed_Point_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ordinary_Fixed_Point_Def;

   
function Others_Designator_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Others_Designator;

   
function Overriding_Indicator_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Overriding_Node;

   
function Package_Body_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Body;

   
function Package_Body_Stub_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Body_Stub;

   
function Package_Decl_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Decl;

   
function Package_Renaming_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Package_Renaming_Decl;

   
function Param_Assoc_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Param_Assoc;

   
function Param_Spec_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Param_Spec;

   
function Param_Specs_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Params;

   
function Paren_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Paren_Expr;

   
function Parent_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Parent_List;

   
function Pp_Directive_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pp_Directive;

   
function Pp_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Pp_Term_Or_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Pp_Then_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pp_Then_Kw;

   
function Pragma_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pragma_Node;

   
function Pragma_Argument_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Pragma_Argument_Assoc;

   
function Primary_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Protected_Body_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Body;

   
function Protected_Body_Stub_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Body_Stub;

   
function Protected_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Single_Protected_Decl;

   
function Protected_Def_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Def;

   
function Protected_El_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Protected_Op_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Protected_Type_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Protected_Type_Decl;

   
function Qual_Name_Internal_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Qualified_Name_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Qual_Expr;

   
function Quantified_Expr_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Quantified_Expr;

   
function Raise_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Raise_Expr;

   
function Raise_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Raise_Stmt;

   
function Range_Constraint_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Constraint;

   
function Range_Spec_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Range_Spec;

   
function Real_Type_Def_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Real_Type_Def;

   
function Record_Def_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Record_Def;

   
function Record_Type_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Record_Type_Def;

   
function Recov_Decl_Part_Dont_Skip_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Declarative_Part;

   
function Regular_Aggregate_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Rel_Op_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Op;

   
function Relation_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Renaming_Clause_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Renaming_Clause;

   
function Requeue_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Requeue_Stmt;

   
function Return_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Return_Stmt;

   
function Select_Stmt_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Select_Stmt;

   
function Sexpr_Or_Box_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Signed_Int_Type_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Signed_Int_Type_Def;

   
function Simple_Decl_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Simple_Decl_Stmt;

   
function Simple_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Simple_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Simple_Subp_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Decl;

   
function Single_Task_Decl_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Single_Task_Decl;

   
function Static_Name_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Stmts_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Stmt_List;

   
function String_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_String_Literal;

   
function Sub_Object_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Object_Decl;

   
function Subp_Body_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Body;

   
function Subp_Body_Stub_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Body_Stub;

   
function Subp_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Decl;

   
function Subp_Renaming_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Renaming_Decl;

   
function Subp_Spec_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subp_Spec;

   
function Subtype_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subtype_Decl;

   
function Subtype_Indication_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subtype_Indication;

   
function Subtype_Name_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name;

   
function Subunit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Subunit;

   
function Target_Name_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Target_Name;

   
function Task_Body_Transform_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Body;

   
function Task_Body_Stub_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Body_Stub;

   
function Task_Def_Transform_Parse3
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Def;

   
function Task_Item_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node;

   
function Task_Type_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Task_Type_Decl;

   
function Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Terminate_Alternative_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Terminate_Alternative;

   
function Type_Decl_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Type_Decl;

   
function Type_Def_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Def;

   
function Type_Expr_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Type_Expr;

   
function Unconstrained_Index_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Unconstrained_Array_Index;

   
function Unop_Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr;

   
function Update_Attr_Aggregate_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate;

   
function Update_Attr_Content_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assoc_List;

   
function Use_Clause_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Use_Clause;

   
function Use_Package_Clause_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Use_Package_Clause;

   
function Use_Type_Clause_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Use_Type_Clause;

   
function Value_Sequence_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Value_Sequence;

   
function Variant_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variant;

   
function Variant_Part_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Variant_Part;

   
function While_Loop_Spec_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_While_Loop_Spec;

   
function With_Clause_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_With_Clause;


   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True);
   --  Helper for the user parsing function, to be called after a low-level
   --  parsing function. Check_Complete has the same semantics as in Parse. If
   --  the parsing failed (Parser.Current_Pos = No_Token_Index), append
   --  corresponding diagnostics to Parser.Diagnostics, do nothing instead.

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type);
   --  Add a diagnostic for the last fail position of the parser

   pragma Warnings (Off, "is not referenced");

   function Get_Parse_List (Parser : Parser_Type) return Free_Parse_List;
   --  Get a free parse list, or allocate one if there is no free parse list in
   --  Parser. When done with the result, the caller must invoke
   --  Release_Parse_List.

   procedure Release_Parse_List
     (Parser : Parser_Type; List : in out Free_Parse_List);
   --  Release a parse list, putting it in Parsers' free list. Set List to
   --  null.

   procedure Initialize_List
     (Self   : Bare_Ada_List;
      Parser : Parser_Type;
      Count  : Natural);
   --  Helper for parsers, to initialize the list of children in a freshly
   --  allocated list node.

   pragma Warnings (On, "is not referenced");

   ---------------------
   -- Initialize_List --
   ---------------------

   procedure Initialize_List
     (Self   : Bare_Ada_List;
      Parser : Parser_Type;
      Count  : Natural) is
   begin
      Self.Count := Count;
      Self.Nodes := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, 0);
   end Initialize_List;

   -----------------
   -- Init_Parser --
   -----------------

   procedure Init_Parser
     (Input       : Internal_Lexer_Input;
      With_Trivia : Boolean;
      Unit        : access Implementation.Analysis_Unit_Type;
      TDH         : Token_Data_Handler_Access;
      Parser      : in out Parser_Type)
   is
      --  Never try to use file readers for internal units: these are generally
      --  not actual source files, and file readers, which are external users
      --  of the generated library, have no reason to be aware of them.

      FR : constant Internal_File_Reader_Access :=
        (if Unit.Is_Internal
         then null
         else Unit.Context.File_Reader);
   begin
      Reset (Parser);
      Extract_Tokens (Input, With_Trivia, FR, TDH.all, Parser.Diagnostics);
      Parser.Unit := Unit;
      Parser.TDH := TDH;
   end Init_Parser;

   ------------------------------
   -- Add_Last_Fail_Diagnostic --
   ------------------------------

   procedure Add_Last_Fail_Diagnostic (Parser : in out Parser_Type)
   is
      Last_Token : Stored_Token_Data renames
         Get_Token (Parser.TDH.all, Parser.Last_Fail.Pos);
      D : constant Diagnostic :=
        (if Parser.Last_Fail.Kind = Token_Fail then
          Create (Sloc_Range (Parser.TDH.all, Last_Token), To_Text
            ("Expected "
             & Token_Error_Image (Parser.Last_Fail.Expected_Token_Id)
             & ", got "
             & Token_Error_Image (Parser.Last_Fail.Found_Token_Id)))
         else
           Create (Sloc_Range (Parser.TDH.all, Last_Token),
                   To_Text (Parser.Last_Fail.Custom_Message.all)));
   begin
      Parser.Diagnostics.Append (D);
   end Add_Last_Fail_Diagnostic;

   ---------------------------
   -- Process_Parsing_Error --
   ---------------------------

   procedure Process_Parsing_Error
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True) is
   begin

      if Parser.Current_Pos = No_Token_Index then
         Add_Last_Fail_Diagnostic (Parser);
      elsif Check_Complete
        and then Parser.Current_Pos /= Last_Token (Parser.TDH.all)
      then
         --  If the fail pos is the current position of the parser or after,
         --  it means that the longest parse is the correct result, and that we
         --  have some garbage afterwards.
         if Parser.Current_Pos >= Parser.Last_Fail.Pos then
            declare
               First_Garbage_Token : Stored_Token_Data renames
                  Get_Token (Parser.TDH.all, Parser.Current_Pos);
            begin
               Append
                 (Parser.Diagnostics,
                  Sloc_Range (Parser.TDH.all, First_Garbage_Token),
                  To_Text
                    ("End of input expected, got """
                     & Token_Kind_Name
                         (To_Token_Kind (First_Garbage_Token.Kind))
                     & """"));
            end;

         --  Else, the last fail pos is further down the line, and we want to
         --  have the diagnostic of what exactly failed.
         else
            Add_Last_Fail_Diagnostic (Parser);
         end if;
      end if;

   end Process_Parsing_Error;

   -----------
   -- Parse --
   -----------

   function Parse
     (Parser         : in out Parser_Type;
      Check_Complete : Boolean := True;
      Rule           : Grammar_Rule) return Parsed_Node
   is
      Result : Bare_Ada_Node;
   begin
      case Rule is
         when Parent_List_Rule =>
            Result := Parent_List_List_Parse0
              (Parser, First_Token_Index);
         when Protected_Type_Decl_Rule =>
            Result := Protected_Type_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Protected_Op_Rule =>
            Result := Protected_Op_Or_Parse0
              (Parser, First_Token_Index);
         when Protected_El_Rule =>
            Result := Protected_El_Or_Parse0
              (Parser, First_Token_Index);
         when Protected_Def_Rule =>
            Result := Protected_Def_Transform_Parse3
              (Parser, First_Token_Index);
         when Protected_Decl_Rule =>
            Result := Protected_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Task_Item_Rule =>
            Result := Task_Item_Or_Parse0
              (Parser, First_Token_Index);
         when Task_Def_Rule =>
            Result := Task_Def_Transform_Parse3
              (Parser, First_Token_Index);
         when Task_Type_Decl_Rule =>
            Result := Task_Type_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Subtype_Decl_Rule =>
            Result := Subtype_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Interface_Type_Def_Rule =>
            Result := Interface_Type_Def_Transform_Parse4
              (Parser, First_Token_Index);
         when Unconstrained_Index_Rule =>
            Result := Unconstrained_Index_Transform_Parse0
              (Parser, First_Token_Index);
         when Array_Type_Def_Rule =>
            Result := Array_Type_Def_Transform_Parse2
              (Parser, First_Token_Index);
         when Discrete_Subtype_Definition_Rule =>
            Result := Discrete_Subtype_Definition_Or_Parse0
              (Parser, First_Token_Index);
         when Constraint_List_Rule =>
            Result := Constraint_List_List_Parse0
              (Parser, First_Token_Index);
         when Signed_Int_Type_Def_Rule =>
            Result := Signed_Int_Type_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Mod_Int_Type_Def_Rule =>
            Result := Mod_Int_Type_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Derived_Type_Def_Rule =>
            Result := Derived_Type_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Composite_Constraint_Assoc_Rule =>
            Result := Composite_Constraint_Assoc_Transform_Parse0
              (Parser, First_Token_Index);
         when Composite_Constraint_Rule =>
            Result := Composite_Constraint_Transform_Parse0
              (Parser, First_Token_Index);
         when Digits_Constraint_Rule =>
            Result := Digits_Constraint_Transform_Parse0
              (Parser, First_Token_Index);
         when Delta_Constraint_Rule =>
            Result := Delta_Constraint_Transform_Parse0
              (Parser, First_Token_Index);
         when Range_Constraint_Rule =>
            Result := Range_Constraint_Transform_Parse1
              (Parser, First_Token_Index);
         when Constraint_Rule =>
            Result := Constraint_Or_Parse0
              (Parser, First_Token_Index);
         when Discriminant_Spec_Rule =>
            Result := Discriminant_Spec_Transform_Parse0
              (Parser, First_Token_Index);
         when Discr_Spec_List_Rule =>
            Result := Discr_Spec_List_List_Parse0
              (Parser, First_Token_Index);
         when Discriminant_Part_Rule =>
            Result := Discriminant_Part_Or_Parse0
              (Parser, First_Token_Index);
         when Enum_Literal_Decl_Rule =>
            Result := Enum_Literal_Decl_Transform_Parse1
              (Parser, First_Token_Index);
         when Formal_Discrete_Type_Def_Rule =>
            Result := Formal_Discrete_Type_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Record_Def_Rule =>
            Result := Record_Def_Or_Parse0
              (Parser, First_Token_Index);
         when Range_Spec_Rule =>
            Result := Range_Spec_Transform_Parse0
              (Parser, First_Token_Index);
         when Real_Type_Def_Rule =>
            Result := Real_Type_Def_Or_Parse0
              (Parser, First_Token_Index);
         when Sexpr_Or_Box_Rule =>
            Result := Sexpr_Or_Box_Or_Parse0
              (Parser, First_Token_Index);
         when Ordinary_Fixed_Point_Def_Rule =>
            Result := Ordinary_Fixed_Point_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Decimal_Fixed_Point_Def_Rule =>
            Result := Decimal_Fixed_Point_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Floating_Point_Def_Rule =>
            Result := Floating_Point_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Record_Type_Def_Rule =>
            Result := Record_Type_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Access_Def_Rule =>
            Result := Access_Def_Or_Parse0
              (Parser, First_Token_Index);
         when Enum_Type_Def_Rule =>
            Result := Enum_Type_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Def_Rule =>
            Result := Type_Def_Or_Parse0
              (Parser, First_Token_Index);
         when Variant_Rule =>
            Result := Variant_Transform_Parse0
              (Parser, First_Token_Index);
         when Anonymous_Type_Decl_Rule =>
            Result := Anonymous_Type_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Incomplete_Type_Decl_Rule =>
            Result := Incomplete_Type_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Type_Decl_Rule =>
            Result := Type_Decl_Or_Parse1
              (Parser, First_Token_Index);
         when Variant_Part_Rule =>
            Result := Variant_Part_Transform_Parse0
              (Parser, First_Token_Index);
         when Component_Def_Rule =>
            Result := Component_Def_Transform_Parse0
              (Parser, First_Token_Index);
         when Component_Item_Rule =>
            Result := Component_Item_Or_Parse0
              (Parser, First_Token_Index);
         when Component_Decl_Rule =>
            Result := Component_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Component_List_Rule =>
            Result := Component_List_Transform_Parse0
              (Parser, First_Token_Index);
         when Generic_Decl_Rule =>
            Result := Generic_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Generic_Formal_Part_Rule =>
            Result := Generic_Formal_Part_Transform_Parse0
              (Parser, First_Token_Index);
         when Generic_Formal_Decl_Rule =>
            Result := Generic_Formal_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Formal_Type_Decl_Rule =>
            Result := Formal_Type_Decl_Or_Parse1
              (Parser, First_Token_Index);
         when Formal_Subp_Decl_Rule =>
            Result := Formal_Subp_Decl_Or_Parse2
              (Parser, First_Token_Index);
         when Renaming_Clause_Rule =>
            Result := Renaming_Clause_Transform_Parse0
              (Parser, First_Token_Index);
         when Generic_Renaming_Decl_Rule =>
            Result := Generic_Renaming_Decl_Or_Parse1
              (Parser, First_Token_Index);
         when Generic_Instantiation_Rule =>
            Result := Generic_Instantiation_Or_Parse1
              (Parser, First_Token_Index);
         when Exception_Decl_Rule =>
            Result := Exception_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Basic_Decls_Rule =>
            Result := Basic_Decls_List_Parse0
              (Parser, First_Token_Index);
         when Package_Renaming_Decl_Rule =>
            Result := Package_Renaming_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Package_Decl_Rule =>
            Result := Package_Decl_Transform_Parse3
              (Parser, First_Token_Index);
         when Basic_Decl_Rule =>
            Result := Basic_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Object_Decl_Rule =>
            Result := Object_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Sub_Object_Decl_Rule =>
            Result := Sub_Object_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when No_Type_Object_Renaming_Decl_Rule =>
            Result := No_Type_Object_Renaming_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Ext_Ret_Stmt_Object_Decl_Rule =>
            Result := Ext_Ret_Stmt_Object_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Defining_Id_List_Rule =>
            Result := Defining_Id_List_List_Parse0
              (Parser, First_Token_Index);
         when Number_Decl_Rule =>
            Result := Number_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Contract_Case_Assoc_Rule =>
            Result := Contract_Case_Assoc_Transform_Parse0
              (Parser, First_Token_Index);
         when Contract_Cases_Expr_Rule =>
            Result := Contract_Cases_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Abstract_State_Decl_Rule =>
            Result := Abstract_State_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Multi_Abstract_State_Decl_Rule =>
            Result := Multi_Abstract_State_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Aspect_Assoc_Rule =>
            Result := Aspect_Assoc_Or_Parse2
              (Parser, First_Token_Index);
         when Aspect_Spec_Rule =>
            Result := Aspect_Spec_Opt_Parse0
              (Parser, First_Token_Index);
         when Single_Task_Decl_Rule =>
            Result := Single_Task_Decl_Transform_Parse1
              (Parser, First_Token_Index);
         when Overriding_Indicator_Rule =>
            Result := Overriding_Indicator_Or_Parse0
              (Parser, First_Token_Index);
         when Entry_Decl_Rule =>
            Result := Entry_Decl_Transform_Parse1
              (Parser, First_Token_Index);
         when Component_Clause_Rule =>
            Result := Component_Clause_Transform_Parse0
              (Parser, First_Token_Index);
         when Aspect_Clause_Rule =>
            Result := Aspect_Clause_Or_Parse1
              (Parser, First_Token_Index);
         when Param_Spec_Rule =>
            Result := Param_Spec_Transform_Parse0
              (Parser, First_Token_Index);
         when Param_Specs_Rule =>
            Result := Param_Specs_Transform_Parse0
              (Parser, First_Token_Index);
         when Subp_Spec_Rule =>
            Result := Subp_Spec_Transform_Parse2
              (Parser, First_Token_Index);
         when Expr_Fn_Rule =>
            Result := Expr_Fn_Transform_Parse0
              (Parser, First_Token_Index);
         when Null_Subp_Decl_Rule =>
            Result := Null_Subp_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Abstract_Subp_Decl_Rule =>
            Result := Abstract_Subp_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Subp_Renaming_Decl_Rule =>
            Result := Subp_Renaming_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Simple_Subp_Decl_Rule =>
            Result := Simple_Subp_Decl_Transform_Parse0
              (Parser, First_Token_Index);
         when Subp_Decl_Rule =>
            Result := Subp_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when With_Clause_Rule =>
            Result := With_Clause_Transform_Parse0
              (Parser, First_Token_Index);
         when Context_Item_Rule =>
            Result := Context_Item_Or_Parse0
              (Parser, First_Token_Index);
         when Use_Clause_Rule =>
            Result := Use_Clause_Or_Parse0
              (Parser, First_Token_Index);
         when Use_Package_Clause_Rule =>
            Result := Use_Package_Clause_Transform_Parse0
              (Parser, First_Token_Index);
         when Use_Type_Clause_Rule =>
            Result := Use_Type_Clause_Transform_Parse0
              (Parser, First_Token_Index);
         when Subtype_Indication_Rule =>
            Result := Subtype_Indication_Transform_Parse0
              (Parser, First_Token_Index);
         when Discrete_Subtype_Indication_Rule =>
            Result := Discrete_Subtype_Indication_Transform_Parse0
              (Parser, First_Token_Index);
         when Constrained_Subtype_Indication_Rule =>
            Result := Constrained_Subtype_Indication_Transform_Parse0
              (Parser, First_Token_Index);
         when Type_Expr_Rule =>
            Result := Type_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Anonymous_Type_Rule =>
            Result := Anonymous_Type_Transform_Parse0
              (Parser, First_Token_Index);
         when Mode_Rule =>
            Result := Mode_Or_Parse0
              (Parser, First_Token_Index);
         when Pragma_Argument_Rule =>
            Result := Pragma_Argument_Transform_Parse1
              (Parser, First_Token_Index);
         when Pragma_Rule =>
            Result := Pragma_Transform_Parse0
              (Parser, First_Token_Index);
         when Subunit_Rule =>
            Result := Subunit_Transform_Parse0
              (Parser, First_Token_Index);
         when Library_Unit_Body_Rule =>
            Result := Library_Unit_Body_Or_Parse0
              (Parser, First_Token_Index);
         when Library_Unit_Renaming_Decl_Rule =>
            Result := Library_Unit_Renaming_Decl_Or_Parse0
              (Parser, First_Token_Index);
         when Library_Item_Rule =>
            Result := Library_Item_Transform_Parse1
              (Parser, First_Token_Index);
         when Compilation_Unit_Rule =>
            Result := Compilation_Unit_Transform_Parse0
              (Parser, First_Token_Index);
         when Compilation_Rule =>
            Result := Compilation_Or_Parse0
              (Parser, First_Token_Index);
         when Decl_Part_Rule =>
            Result := Decl_Part_Transform_Parse0
              (Parser, First_Token_Index);
         when Entry_Body_Rule =>
            Result := Entry_Body_Transform_Parse3
              (Parser, First_Token_Index);
         when Protected_Body_Rule =>
            Result := Protected_Body_Transform_Parse1
              (Parser, First_Token_Index);
         when Protected_Body_Stub_Rule =>
            Result := Protected_Body_Stub_Transform_Parse0
              (Parser, First_Token_Index);
         when Task_Body_Rule =>
            Result := Task_Body_Transform_Parse1
              (Parser, First_Token_Index);
         when Task_Body_Stub_Rule =>
            Result := Task_Body_Stub_Transform_Parse0
              (Parser, First_Token_Index);
         when Package_Body_Stub_Rule =>
            Result := Package_Body_Stub_Transform_Parse0
              (Parser, First_Token_Index);
         when Package_Body_Rule =>
            Result := Package_Body_Transform_Parse1
              (Parser, First_Token_Index);
         when Terminate_Alternative_Rule =>
            Result := Terminate_Alternative_Transform_Parse0
              (Parser, First_Token_Index);
         when Select_Stmt_Rule =>
            Result := Select_Stmt_Transform_Parse1
              (Parser, First_Token_Index);
         when Accept_Stmt_Rule =>
            Result := Accept_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Case_Alt_Rule =>
            Result := Case_Alt_Transform_Parse0
              (Parser, First_Token_Index);
         when Case_Stmt_Rule =>
            Result := Case_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Ext_Return_Stmt_Rule =>
            Result := Ext_Return_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Iblock_Stmt_Rule =>
            Result := Iblock_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Block_Stmt_Rule =>
            Result := Block_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when While_Loop_Spec_Rule =>
            Result := While_Loop_Spec_Transform_Parse0
              (Parser, First_Token_Index);
         when Iloop_Stmt_Rule =>
            Result := Iloop_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Loop_Stmt_Rule =>
            Result := Loop_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Compound_Stmt_Rule =>
            Result := Compound_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Elsif_Part_Rule =>
            Result := Elsif_Part_Transform_Parse0
              (Parser, First_Token_Index);
         when If_Stmt_Rule =>
            Result := If_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Raise_Stmt_Rule =>
            Result := Raise_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Delay_Stmt_Rule =>
            Result := Delay_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Abort_Stmt_Rule =>
            Result := Abort_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Body_Rule =>
            Result := Body_Or_Parse0
              (Parser, First_Token_Index);
         when Body_Stub_Rule =>
            Result := Body_Stub_Or_Parse0
              (Parser, First_Token_Index);
         when Subp_Body_Stub_Rule =>
            Result := Subp_Body_Stub_Transform_Parse0
              (Parser, First_Token_Index);
         when Recov_Decl_Part_Rule =>
            Result := Recov_Decl_Part_Dont_Skip_Parse0
              (Parser, First_Token_Index);
         when Subp_Body_Rule =>
            Result := Subp_Body_Transform_Parse1
              (Parser, First_Token_Index);
         when Handled_Stmts_Rule =>
            Result := Handled_Stmts_Transform_Parse0
              (Parser, First_Token_Index);
         when Exception_Handler_Rule =>
            Result := Exception_Handler_Transform_Parse0
              (Parser, First_Token_Index);
         when Stmts_Rule =>
            Result := Stmts_List_Parse0
              (Parser, First_Token_Index);
         when Label_Rule =>
            Result := Label_Transform_Parse1
              (Parser, First_Token_Index);
         when Stmt_Rule =>
            Result := Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Call_Stmt_Rule =>
            Result := Call_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Simple_Stmt_Rule =>
            Result := Simple_Stmt_Or_Parse0
              (Parser, First_Token_Index);
         when Simple_Decl_Stmt_Rule =>
            Result := Simple_Decl_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Null_Stmt_Rule =>
            Result := Null_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Assignment_Stmt_Rule =>
            Result := Assignment_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Goto_Stmt_Rule =>
            Result := Goto_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Exit_Stmt_Rule =>
            Result := Exit_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Return_Stmt_Rule =>
            Result := Return_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Requeue_Stmt_Rule =>
            Result := Requeue_Stmt_Transform_Parse0
              (Parser, First_Token_Index);
         when Identifier_Rule =>
            Result := Identifier_Transform_Parse0
              (Parser, First_Token_Index);
         when Char_Literal_Rule =>
            Result := Char_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when String_Literal_Rule =>
            Result := String_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Format_String_Literal_Rule =>
            Result := Format_String_Literal_Or_Parse0
              (Parser, First_Token_Index);
         when Defining_Id_Rule =>
            Result := Defining_Id_Transform_Parse0
              (Parser, First_Token_Index);
         when Dec_Literal_Rule =>
            Result := Dec_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Int_Literal_Rule =>
            Result := Int_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Num_Literal_Rule =>
            Result := Num_Literal_Or_Parse0
              (Parser, First_Token_Index);
         when Null_Literal_Rule =>
            Result := Null_Literal_Transform_Parse0
              (Parser, First_Token_Index);
         when Allocator_Rule =>
            Result := Allocator_Transform_Parse0
              (Parser, First_Token_Index);
         when For_Loop_Param_Spec_Rule =>
            Result := For_Loop_Param_Spec_Transform_Parse4
              (Parser, First_Token_Index);
         when Quantified_Expr_Rule =>
            Result := Quantified_Expr_Transform_Parse2
              (Parser, First_Token_Index);
         when Case_Expr_Rule =>
            Result := Case_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Case_Expr_Alt_Rule =>
            Result := Case_Expr_Alt_Transform_Parse0
              (Parser, First_Token_Index);
         when Raise_Expr_Rule =>
            Result := Raise_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when If_Expr_Rule =>
            Result := If_Expr_Transform_Parse1
              (Parser, First_Token_Index);
         when Conditional_Expr_Rule =>
            Result := Conditional_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Box_Expr_Rule =>
            Result := Box_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Others_Designator_Rule =>
            Result := Others_Designator_Transform_Parse0
              (Parser, First_Token_Index);
         when Iterated_Assoc_Rule =>
            Result := Iterated_Assoc_Transform_Parse0
              (Parser, First_Token_Index);
         when Aggregate_Assoc_Rule =>
            Result := Aggregate_Assoc_Or_Parse1
              (Parser, First_Token_Index);
         when Regular_Aggregate_Rule =>
            Result := Regular_Aggregate_Or_Parse0
              (Parser, First_Token_Index);
         when Bracket_Aggregate_Rule =>
            Result := Bracket_Aggregate_Or_Parse0
              (Parser, First_Token_Index);
         when Aggregate_Rule =>
            Result := Aggregate_Or_Parse0
              (Parser, First_Token_Index);
         when Direct_Name_Rule =>
            Result := Direct_Name_Or_Parse0
              (Parser, First_Token_Index);
         when Param_Assoc_Rule =>
            Result := Param_Assoc_Transform_Parse0
              (Parser, First_Token_Index);
         when Call_Suffix_Rule =>
            Result := Call_Suffix_Or_Parse0
              (Parser, First_Token_Index);
         when Attr_Suffix_Rule =>
            Result := Attr_Suffix_List_Parse0
              (Parser, First_Token_Index);
         when Qualified_Name_Rule =>
            Result := Qualified_Name_Transform_Parse0
              (Parser, First_Token_Index);
         when Qual_Name_Internal_Rule =>
            Result := Qual_Name_Internal_Or_Parse0
              (Parser, First_Token_Index);
         when Value_Sequence_Rule =>
            Result := Value_Sequence_Transform_Parse0
              (Parser, First_Token_Index);
         when Name_Rule =>
            Result := Name_Or_Parse2
              (Parser, First_Token_Index);
         when Defining_Name_Rule =>
            Result := Defining_Name_Transform_Parse0
              (Parser, First_Token_Index);
         when Direct_Name_Or_Target_Name_Rule =>
            Result := Direct_Name_Or_Target_Name_Or_Parse0
              (Parser, First_Token_Index);
         when Target_Name_Rule =>
            Result := Target_Name_Transform_Parse0
              (Parser, First_Token_Index);
         when Update_Attr_Aggregate_Rule =>
            Result := Update_Attr_Aggregate_Or_Parse0
              (Parser, First_Token_Index);
         when Update_Attr_Content_Rule =>
            Result := Update_Attr_Content_List_Parse0
              (Parser, First_Token_Index);
         when Multidim_Array_Assoc_Rule =>
            Result := Multidim_Array_Assoc_Transform_Parse0
              (Parser, First_Token_Index);
         when Subtype_Name_Rule =>
            Result := Subtype_Name_Or_Parse0
              (Parser, First_Token_Index);
         when Static_Name_Rule =>
            Result := Static_Name_Or_Parse0
              (Parser, First_Token_Index);
         when Primary_Rule =>
            Result := Primary_Or_Parse0
              (Parser, First_Token_Index);
         when Paren_Expr_Rule =>
            Result := Paren_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Declare_Expr_Rule =>
            Result := Declare_Expr_Transform_Parse0
              (Parser, First_Token_Index);
         when Factor_Rule =>
            Result := Factor_Or_Parse1
              (Parser, First_Token_Index);
         when Term_Rule =>
            Result := Term_Or_Parse1
              (Parser, First_Token_Index);
         when Unop_Term_Rule =>
            Result := Unop_Term_Or_Parse1
              (Parser, First_Token_Index);
         when Add_Term_Rule =>
            Result := Add_Term_Or_Parse1
              (Parser, First_Token_Index);
         when Simple_Expr_Rule =>
            Result := Simple_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Boolean_Op_Rule =>
            Result := Boolean_Op_Or_Parse0
              (Parser, First_Token_Index);
         when Discrete_Range_Rule =>
            Result := Discrete_Range_Or_Parse1
              (Parser, First_Token_Index);
         when Array_Subcomponent_Choice_Rule =>
            Result := Array_Subcomponent_Choice_Or_Parse0
              (Parser, First_Token_Index);
         when Choice_Rule =>
            Result := Choice_Or_Parse0
              (Parser, First_Token_Index);
         when Choice_List_Rule =>
            Result := Choice_List_List_Parse0
              (Parser, First_Token_Index);
         when Delta_Choice_List_Rule =>
            Result := Delta_Choice_List_List_Parse0
              (Parser, First_Token_Index);
         when Rel_Op_Rule =>
            Result := Rel_Op_Or_Parse0
              (Parser, First_Token_Index);
         when Membership_Choice_Rule =>
            Result := Membership_Choice_Or_Parse0
              (Parser, First_Token_Index);
         when Membership_Choice_List_Rule =>
            Result := Membership_Choice_List_List_Parse0
              (Parser, First_Token_Index);
         when Relation_Rule =>
            Result := Relation_Or_Parse1
              (Parser, First_Token_Index);
         when Expr_Rule =>
            Result := Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Pp_Directive_Rule =>
            Result := Pp_Directive_Or_Parse0
              (Parser, First_Token_Index);
         when Pp_Then_Rule =>
            Result := Pp_Then_Opt_Parse0
              (Parser, First_Token_Index);
         when Pp_Expr_Rule =>
            Result := Pp_Expr_Or_Parse0
              (Parser, First_Token_Index);
         when Pp_Term_Rule =>
            Result := Pp_Term_Or_Parse2
              (Parser, First_Token_Index);
      end case;
      Process_Parsing_Error (Parser, Check_Complete);
      Set_Parents (Result, null);
      return Parsed_Node (Result);
   exception
      when Exc : Precondition_Failure | Property_Error =>
         Append
           (Parser.Diagnostics,
            No_Source_Location_Range,
            To_Text ("Error during parsing: "
                     & Ada.Exceptions.Exception_Message (Exc)));
         return Parsed_Node (No_Bare_Ada_Node);
   end Parse;

   


function Abort_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abort_Stmt
is
   use Bare_Abort_Stmt_Memos;

      Row_Pos0 :
            Token_Index
               := No_Token_Index;
      Token_Pos0 :
            Token_Index
               := No_Token_Index;
      Token_Res0 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos0 :
            Token_Index
               := No_Token_Index;
      Tmp_List0 :
            Free_Parse_List;
      Defer_Pos0 :
            Token_Index
               := No_Token_Index;
      Defer_Res0 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos1 :
            Token_Index
               := No_Token_Index;
      Token_Res1 :
            Token_Index
               := No_Token_Index;
      List_Pos0 :
            Token_Index
               := No_Token_Index;
      List_Res0 :
            Bare_Name_List
               := No_Bare_Ada_Node;
      Token_Pos2 :
            Token_Index
               := No_Token_Index;
      Token_Res2 :
            Token_Index
               := No_Token_Index;
      Transform_Res0 :
            Bare_Abort_Stmt
               := No_Bare_Ada_Node;
      Transform_Diags0 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Abort_Stmt_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res0 := M.Instance;
      return Transform_Res0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareAbortStmt>) at parser.lkt:941:19>

Transform_Diags0 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos0 := Pos;



--  BEGIN <Token(<WithText Abort>, ) at parser.lkt:941:29>

Token_Res0 := Row_Pos0;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res0));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Abort)
   then
       Token_Pos0 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos0 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos0,
             Expected_Token_Id => Ada_Abort,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos0 := Row_Pos0 + 1;
   end if;
end;

--  END <Token(<WithText Abort>, ) at parser.lkt:941:29>




if Token_Pos0 /= No_Token_Index then

   Row_Pos0 := Token_Pos0;

else
   Row_Pos0 := No_Token_Index;
   goto Exit_Row0_0;

end if;


--  BEGIN <List at parser.lkt:941:37>

    List_Pos0 := No_Token_Index;



Lst_Cpos0 := Row_Pos0;
Tmp_List0 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:941:43>

Defer_Res0 :=
   Name_Or_Parse2 (Parser, Lst_Cpos0);
Defer_Pos0 := Parser.Current_Pos;

--  END <Defer at parser.lkt:941:43>


   exit when Defer_Pos0 = No_Token_Index;

   List_Pos0 := Defer_Pos0;
   Lst_Cpos0 := List_Pos0;

   Tmp_List0.Nodes.Append (Defer_Res0);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:941:49>

Token_Res1 := Lst_Cpos0;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res1));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos1 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos0 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos0,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos1 := Lst_Cpos0 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:941:49>


      exit when Token_Pos1 = No_Token_Index;

      Lst_Cpos0 := Token_Pos1;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List0.Nodes.Length;
begin
   List_Res0 := Allocate_Name_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos0;
      Token_End := (if Lst_Cpos0 = Row_Pos0
                    then Row_Pos0
                    else List_Pos0 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos0, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res0,
      Kind              => Ada_Name_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res0,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List0.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res0.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List0);

--  END <List at parser.lkt:941:37>




if List_Pos0 /= No_Token_Index then

   Row_Pos0 := List_Pos0;

else
   Row_Pos0 := No_Token_Index;
   goto Exit_Row0_0;

end if;


--  BEGIN <Opt at parser.lkt:941:54>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:941:55>

Token_Res2 := Row_Pos0;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res2));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos2 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos0 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos0,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos2 := Row_Pos0 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:941:55>


if Token_Pos2 = No_Token_Index then

         
   Token_Res2 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos0)),
                To_Text ("Missing ';'"));

       
   Token_Pos2 := Row_Pos0;



end if;

--  END <Opt at parser.lkt:941:54>




if Token_Pos2 /= No_Token_Index then

   Row_Pos0 := Token_Pos2;

else
   Row_Pos0 := No_Token_Index;
   goto Exit_Row0_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row0_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos0 /= No_Token_Index then

   Transform_Res0 := Allocate_Abort_Stmt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res0,
      Kind => Ada_Abort_Stmt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos0 = Pos
                            then No_Token_Index
                            else Row_Pos0 - 1));

      
      Initialize_Fields_For_Abort_Stmt
        (Self => Transform_Res0,
         Abort_Stmt_F_Names => List_Res0);

         if List_Res0 /= null and then Is_Incomplete (List_Res0) then
            Transform_Res0.Last_Attempted_Child := 0;
         elsif List_Res0 /= null and then not Is_Ghost (List_Res0) then
            Transform_Res0.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos0 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags0);
end if;

--  END <Transform(<CompiledType BareAbortStmt>) at parser.lkt:941:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Abort_Stmt_Transform_Parse0_Memo,
      Row_Pos0 /= No_Token_Index,
      Transform_Res0,
      Pos,
      Row_Pos0);


   Parser.Current_Pos := Row_Pos0;

   return Transform_Res0;
end Abort_Stmt_Transform_Parse0;

   


function Abstract_State_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Row_Pos1 :
            Token_Index
               := No_Token_Index;
      Defer_Pos1 :
            Token_Index
               := No_Token_Index;
      Defer_Res1 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Defer_Pos2 :
            Token_Index
               := No_Token_Index;
      Defer_Res2 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Transform_Res1 :
            Bare_Abstract_State_Decl
               := No_Bare_Ada_Node;
      Transform_Diags1 :
            Ada.Containers.Count_Type;
      Row_Pos2 :
            Token_Index
               := No_Token_Index;
      Token_Pos3 :
            Token_Index
               := No_Token_Index;
      Token_Res3 :
            Token_Index
               := No_Token_Index;
      Defer_Pos3 :
            Token_Index
               := No_Token_Index;
      Defer_Res3 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos4 :
            Token_Index
               := No_Token_Index;
      Token_Res4 :
            Token_Index
               := No_Token_Index;
      Transform_Res2 :
            Bare_Paren_Abstract_State_Decl
               := No_Bare_Ada_Node;
      Transform_Diags2 :
            Ada.Containers.Count_Type;
      Or_Pos0 :
            Token_Index
               := No_Token_Index;
      Or_Res0 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Abstract_State_Decl_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res0 := M.Instance;
      return Or_Res0;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res0;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:456:28>

Or_Pos0 := No_Token_Index;
Or_Res0 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareAbstractStateDecl>) at parser.lkt:457:11>

Transform_Diags1 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos1 := Pos;



--  BEGIN <Defer at parser.lkt:457:29>

Defer_Res1 :=
   Defining_Name_Transform_Parse0 (Parser, Row_Pos1);
Defer_Pos1 := Parser.Current_Pos;

--  END <Defer at parser.lkt:457:29>




if Defer_Pos1 /= No_Token_Index then

   Row_Pos1 := Defer_Pos1;

else
   Row_Pos1 := No_Token_Index;
   goto Exit_Row1_0;

end if;


--  BEGIN <Defer at parser.lkt:457:43>

Defer_Res2 :=
   Aspect_Spec_Opt_Parse0 (Parser, Row_Pos1);
Defer_Pos2 := Parser.Current_Pos;

--  END <Defer at parser.lkt:457:43>




if Defer_Pos2 /= No_Token_Index then

   Row_Pos1 := Defer_Pos2;

else
   Row_Pos1 := No_Token_Index;
   goto Exit_Row1_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row1_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos1 /= No_Token_Index then

   Transform_Res1 := Allocate_Abstract_State_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res1,
      Kind => Ada_Abstract_State_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos1 = Pos
                            then No_Token_Index
                            else Row_Pos1 - 1));

      
      Initialize_Fields_For_Abstract_State_Decl
        (Self => Transform_Res1,
         Abstract_State_Decl_F_Name => Defer_Res1,
         Abstract_State_Decl_F_Aspects => Defer_Res2);

         if Defer_Res1 /= null and then Is_Incomplete (Defer_Res1) then
            Transform_Res1.Last_Attempted_Child := 0;
         elsif Defer_Res1 /= null and then not Is_Ghost (Defer_Res1) then
            Transform_Res1.Last_Attempted_Child := -1;
         end if;
         if Defer_Res2 /= null and then Is_Incomplete (Defer_Res2) then
            Transform_Res1.Last_Attempted_Child := 0;
         elsif Defer_Res2 /= null and then not Is_Ghost (Defer_Res2) then
            Transform_Res1.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos1 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags1);
end if;

--  END <Transform(<CompiledType BareAbstractStateDecl>) at parser.lkt:457:11>

    if Row_Pos1 /= No_Token_Index then
        Or_Pos0 := Row_Pos1;
        Or_Res0 := Transform_Res1;
        goto Exit_Or0;
    end if;
    
--  BEGIN <Transform(<CompiledType BareParenAbstractStateDecl>) at parser.lkt:458:11>

Transform_Diags2 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos2 := Pos;



--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:458:34>

Token_Res3 := Row_Pos2;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res3));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos3 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos2 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos2,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos3 := Row_Pos2 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:458:34>




if Token_Pos3 /= No_Token_Index then

   Row_Pos2 := Token_Pos3;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;


--  BEGIN <Defer at parser.lkt:458:38>

Defer_Res3 :=
   Abstract_State_Decl_Or_Parse0 (Parser, Row_Pos2);
Defer_Pos3 := Parser.Current_Pos;

--  END <Defer at parser.lkt:458:38>




if Defer_Pos3 /= No_Token_Index then

   Row_Pos2 := Defer_Pos3;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:458:58>

Token_Res4 := Row_Pos2;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res4));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos4 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos2 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos2,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos4 := Row_Pos2 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:458:58>




if Token_Pos4 /= No_Token_Index then

   Row_Pos2 := Token_Pos4;

else
   Row_Pos2 := No_Token_Index;
   goto Exit_Row2_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row2_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos2 /= No_Token_Index then

   Transform_Res2 := Allocate_Paren_Abstract_State_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res2,
      Kind => Ada_Paren_Abstract_State_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos2 = Pos
                            then No_Token_Index
                            else Row_Pos2 - 1));

      
      Initialize_Fields_For_Paren_Abstract_State_Decl
        (Self => Transform_Res2,
         Paren_Abstract_State_Decl_F_Decl => Defer_Res3);

         if Defer_Res3 /= null and then Is_Incomplete (Defer_Res3) then
            Transform_Res2.Last_Attempted_Child := 0;
         elsif Defer_Res3 /= null and then not Is_Ghost (Defer_Res3) then
            Transform_Res2.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos2 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags2);
end if;

--  END <Transform(<CompiledType BareParenAbstractStateDecl>) at parser.lkt:458:11>

    if Row_Pos2 /= No_Token_Index then
        Or_Pos0 := Row_Pos2;
        Or_Res0 := Transform_Res2;
        goto Exit_Or0;
    end if;
<<Exit_Or0>>

--  END <Or at parser.lkt:456:28>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Abstract_State_Decl_Or_Parse0_Memo,
      Or_Pos0 /= No_Token_Index,
      Or_Res0,
      Pos,
      Or_Pos0);


   Parser.Current_Pos := Or_Pos0;

   return Or_Res0;
end Abstract_State_Decl_Or_Parse0;

   


function Abstract_Subp_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Abstract_Subp_Decl
is
   use Bare_Abstract_Subp_Decl_Memos;

      Row_Pos3 :
            Token_Index
               := No_Token_Index;
      Defer_Pos4 :
            Token_Index
               := No_Token_Index;
      Defer_Res4 :
            Bare_Overriding_Node
               := No_Bare_Ada_Node;
      Defer_Pos5 :
            Token_Index
               := No_Token_Index;
      Defer_Res5 :
            Bare_Subp_Spec
               := No_Bare_Ada_Node;
      Token_Pos5 :
            Token_Index
               := No_Token_Index;
      Token_Res5 :
            Token_Index
               := No_Token_Index;
      Token_Pos6 :
            Token_Index
               := No_Token_Index;
      Token_Res6 :
            Token_Index
               := No_Token_Index;
      Defer_Pos6 :
            Token_Index
               := No_Token_Index;
      Defer_Res6 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Token_Pos7 :
            Token_Index
               := No_Token_Index;
      Token_Res7 :
            Token_Index
               := No_Token_Index;
      Transform_Res3 :
            Bare_Abstract_Subp_Decl
               := No_Bare_Ada_Node;
      Transform_Diags3 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Abstract_Subp_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res3 := M.Instance;
      return Transform_Res3;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res3;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareAbstractSubpDecl>) at parser.lkt:560:27>

Transform_Diags3 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos3 := Pos;



--  BEGIN <Defer at parser.lkt:561:9>

Defer_Res4 :=
   Overriding_Indicator_Or_Parse0 (Parser, Row_Pos3);
Defer_Pos4 := Parser.Current_Pos;

--  END <Defer at parser.lkt:561:9>




if Defer_Pos4 /= No_Token_Index then

   Row_Pos3 := Defer_Pos4;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;


--  BEGIN <Defer at parser.lkt:562:9>

Defer_Res5 :=
   Subp_Spec_Transform_Parse2 (Parser, Row_Pos3);
Defer_Pos5 := Parser.Current_Pos;

--  END <Defer at parser.lkt:562:9>




if Defer_Pos5 /= No_Token_Index then

   Row_Pos3 := Defer_Pos5;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;


--  BEGIN <Token(<WithText Is>, ) at parser.lkt:563:9>

Token_Res5 := Row_Pos3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res5));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Is)
   then
       Token_Pos5 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos3,
             Expected_Token_Id => Ada_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos5 := Row_Pos3 + 1;
   end if;
end;

--  END <Token(<WithText Is>, ) at parser.lkt:563:9>




if Token_Pos5 /= No_Token_Index then

   Row_Pos3 := Token_Pos5;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;


--  BEGIN <Token(<WithSymbol Identifier>, abstract) at parser.lkt:564:9>

Token_Res6 := Row_Pos3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res6));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Abstract)
   then
       Token_Pos6 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos3,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos6 := Row_Pos3 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, abstract) at parser.lkt:564:9>




if Token_Pos6 /= No_Token_Index then

   Row_Pos3 := Token_Pos6;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;


--  BEGIN <Defer at parser.lkt:565:9>

Defer_Res6 :=
   Aspect_Spec_Opt_Parse0 (Parser, Row_Pos3);
Defer_Pos6 := Parser.Current_Pos;

--  END <Defer at parser.lkt:565:9>




if Defer_Pos6 /= No_Token_Index then

   Row_Pos3 := Defer_Pos6;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;


--  BEGIN <Opt at parser.lkt:566:9>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:566:10>

Token_Res7 := Row_Pos3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res7));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos7 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos3,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos7 := Row_Pos3 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:566:10>


if Token_Pos7 = No_Token_Index then

         
   Token_Res7 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos3)),
                To_Text ("Missing ';'"));

       
   Token_Pos7 := Row_Pos3;



end if;

--  END <Opt at parser.lkt:566:9>




if Token_Pos7 /= No_Token_Index then

   Row_Pos3 := Token_Pos7;

else
   Row_Pos3 := No_Token_Index;
   goto Exit_Row3_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row3_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos3 /= No_Token_Index then

   Transform_Res3 := Allocate_Abstract_Subp_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res3,
      Kind => Ada_Abstract_Subp_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos3 = Pos
                            then No_Token_Index
                            else Row_Pos3 - 1));

      
      Initialize_Fields_For_Abstract_Subp_Decl
        (Self => Transform_Res3,
         Classic_Subp_Decl_F_Overriding => Defer_Res4,
         Classic_Subp_Decl_F_Subp_Spec => Defer_Res5,
         Abstract_Subp_Decl_F_Aspects => Defer_Res6);

         if Defer_Res4 /= null and then Is_Incomplete (Defer_Res4) then
            Transform_Res3.Last_Attempted_Child := 0;
         elsif Defer_Res4 /= null and then not Is_Ghost (Defer_Res4) then
            Transform_Res3.Last_Attempted_Child := -1;
         end if;
         if Defer_Res5 /= null and then Is_Incomplete (Defer_Res5) then
            Transform_Res3.Last_Attempted_Child := 0;
         elsif Defer_Res5 /= null and then not Is_Ghost (Defer_Res5) then
            Transform_Res3.Last_Attempted_Child := -1;
         end if;
         if Defer_Res6 /= null and then Is_Incomplete (Defer_Res6) then
            Transform_Res3.Last_Attempted_Child := 0;
         elsif Defer_Res6 /= null and then not Is_Ghost (Defer_Res6) then
            Transform_Res3.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos3 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags3);
end if;

--  END <Transform(<CompiledType BareAbstractSubpDecl>) at parser.lkt:560:27>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Abstract_Subp_Decl_Transform_Parse0_Memo,
      Row_Pos3 /= No_Token_Index,
      Transform_Res3,
      Pos,
      Row_Pos3);


   Parser.Current_Pos := Row_Pos3;

   return Transform_Res3;
end Abstract_Subp_Decl_Transform_Parse0;

   


function Accept_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Accept_Stmt
is
   use Bare_Accept_Stmt_Memos;

      Row_Pos4 :
            Token_Index
               := No_Token_Index;
      Token_Pos8 :
            Token_Index
               := No_Token_Index;
      Token_Res8 :
            Token_Index
               := No_Token_Index;
      Row_Pos5 :
            Token_Index
               := No_Token_Index;
      Row_Pos6 :
            Token_Index
               := No_Token_Index;
      Defer_Pos7 :
            Token_Index
               := No_Token_Index;
      Defer_Res7 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Transform_Res4 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Transform_Diags4 :
            Ada.Containers.Count_Type;
      Transform_Res5 :
            Bare_Accept_Stmt_Body
               := No_Bare_Ada_Node;
      Transform_Diags5 :
            Ada.Containers.Count_Type;
      Row_Pos7 :
            Token_Index
               := No_Token_Index;
      Token_Pos9 :
            Token_Index
               := No_Token_Index;
      Token_Res9 :
            Token_Index
               := No_Token_Index;
      Defer_Pos8 :
            Token_Index
               := No_Token_Index;
      Defer_Res8 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos10 :
            Token_Index
               := No_Token_Index;
      Token_Res10 :
            Token_Index
               := No_Token_Index;
      Row_Pos8 :
            Token_Index
               := No_Token_Index;
      Defer_Pos9 :
            Token_Index
               := No_Token_Index;
      Defer_Res9 :
            Bare_Params
               := No_Bare_Ada_Node;
      Transform_Res6 :
            Bare_Entry_Completion_Formal_Params
               := No_Bare_Ada_Node;
      Transform_Diags6 :
            Ada.Containers.Count_Type;
      Token_Pos11 :
            Token_Index
               := No_Token_Index;
      Token_Res11 :
            Token_Index
               := No_Token_Index;
      Transform_Res7 :
            Bare_Accept_Stmt
               := No_Bare_Ada_Node;
      Transform_Diags7 :
            Ada.Containers.Count_Type;
      Row_Pos9 :
            Token_Index
               := No_Token_Index;
      Token_Pos12 :
            Token_Index
               := No_Token_Index;
      Token_Res12 :
            Token_Index
               := No_Token_Index;
      Row_Pos10 :
            Token_Index
               := No_Token_Index;
      Row_Pos11 :
            Token_Index
               := No_Token_Index;
      Defer_Pos10 :
            Token_Index
               := No_Token_Index;
      Defer_Res10 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Transform_Res8 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Transform_Diags8 :
            Ada.Containers.Count_Type;
      Transform_Res9 :
            Bare_Accept_Stmt_Body
               := No_Bare_Ada_Node;
      Transform_Diags9 :
            Ada.Containers.Count_Type;
      Row_Pos12 :
            Token_Index
               := No_Token_Index;
      Token_Pos13 :
            Token_Index
               := No_Token_Index;
      Token_Res13 :
            Token_Index
               := No_Token_Index;
      Defer_Pos11 :
            Token_Index
               := No_Token_Index;
      Defer_Res11 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos14 :
            Token_Index
               := No_Token_Index;
      Token_Res14 :
            Token_Index
               := No_Token_Index;
      Row_Pos13 :
            Token_Index
               := No_Token_Index;
      Defer_Pos12 :
            Token_Index
               := No_Token_Index;
      Defer_Res12 :
            Bare_Params
               := No_Bare_Ada_Node;
      Transform_Res10 :
            Bare_Entry_Completion_Formal_Params
               := No_Bare_Ada_Node;
      Transform_Diags10 :
            Ada.Containers.Count_Type;
      Token_Pos15 :
            Token_Index
               := No_Token_Index;
      Token_Res15 :
            Token_Index
               := No_Token_Index;
      Defer_Pos13 :
            Token_Index
               := No_Token_Index;
      Defer_Res13 :
            Bare_Handled_Stmts
               := No_Bare_Ada_Node;
      Row_Pos14 :
            Token_Index
               := No_Token_Index;
      Token_Pos16 :
            Token_Index
               := No_Token_Index;
      Token_Res16 :
            Token_Index
               := No_Token_Index;
      Row_Pos15 :
            Token_Index
               := No_Token_Index;
      Defer_Pos14 :
            Token_Index
               := No_Token_Index;
      Defer_Res14 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Transform_Res11 :
            Bare_End_Name
               := No_Bare_Ada_Node;
      Transform_Diags11 :
            Ada.Containers.Count_Type;
      Token_Pos17 :
            Token_Index
               := No_Token_Index;
      Token_Res17 :
            Token_Index
               := No_Token_Index;
      Transform_Res12 :
            Bare_Accept_Stmt_With_Stmts
               := No_Bare_Ada_Node;
      Transform_Diags12 :
            Ada.Containers.Count_Type;
      Or_Pos1 :
            Token_Index
               := No_Token_Index;
      Or_Res1 :
            Bare_Accept_Stmt
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Accept_Stmt_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res1 := M.Instance;
      return Or_Res1;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res1;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:825:20>

Or_Pos1 := No_Token_Index;
Or_Res1 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareAcceptStmt>) at parser.lkt:826:11>

Transform_Diags7 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos4 := Pos;



--  BEGIN <Token(<WithText Accept>, ) at parser.lkt:827:13>

Token_Res8 := Row_Pos4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res8));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Accept)
   then
       Token_Pos8 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos4,
             Expected_Token_Id => Ada_Accept,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos8 := Row_Pos4 + 1;
   end if;
end;

--  END <Token(<WithText Accept>, ) at parser.lkt:827:13>




if Token_Pos8 /= No_Token_Index then

   Row_Pos4 := Token_Pos8;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;


--  BEGIN <Transform(<CompiledType BareAcceptStmtBody>) at parser.lkt:828:13>

Transform_Diags5 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos5 := Row_Pos4;



--  BEGIN <Transform(<CompiledType BareDefiningName>) at parser.lkt:828:28>

Transform_Diags4 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos6 := Row_Pos5;



--  BEGIN <Defer at parser.lkt:828:41>

Defer_Res7 :=
   Identifier_Transform_Parse0 (Parser, Row_Pos6);
Defer_Pos7 := Parser.Current_Pos;

--  END <Defer at parser.lkt:828:41>




if Defer_Pos7 /= No_Token_Index then

   Row_Pos6 := Defer_Pos7;

else
   Row_Pos6 := No_Token_Index;
   goto Exit_Row6_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row6_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos6 /= No_Token_Index then

   Transform_Res4 := Allocate_Defining_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res4,
      Kind => Ada_Defining_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos5,
      Token_End_Index   => (if Row_Pos6 = Row_Pos5
                            then No_Token_Index
                            else Row_Pos6 - 1));

      
      Initialize_Fields_For_Defining_Name
        (Self => Transform_Res4,
         Defining_Name_F_Name => Defer_Res7);

         if Defer_Res7 /= null and then Is_Incomplete (Defer_Res7) then
            Transform_Res4.Last_Attempted_Child := 0;
         elsif Defer_Res7 /= null and then not Is_Ghost (Defer_Res7) then
            Transform_Res4.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos6 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags4);
end if;

--  END <Transform(<CompiledType BareDefiningName>) at parser.lkt:828:28>




if Row_Pos6 /= No_Token_Index then

   Row_Pos5 := Row_Pos6;

else
   Row_Pos5 := No_Token_Index;
   goto Exit_Row5_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row5_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos5 /= No_Token_Index then

   Transform_Res5 := Allocate_Accept_Stmt_Body (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res5,
      Kind => Ada_Accept_Stmt_Body,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos4,
      Token_End_Index   => (if Row_Pos5 = Row_Pos4
                            then No_Token_Index
                            else Row_Pos5 - 1));

      
      Initialize_Fields_For_Accept_Stmt_Body
        (Self => Transform_Res5,
         Accept_Stmt_Body_F_Name => Transform_Res4);

         if Transform_Res4 /= null and then Is_Incomplete (Transform_Res4) then
            Transform_Res5.Last_Attempted_Child := 0;
         elsif Transform_Res4 /= null and then not Is_Ghost (Transform_Res4) then
            Transform_Res5.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos5 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags5);
end if;

--  END <Transform(<CompiledType BareAcceptStmtBody>) at parser.lkt:828:13>




if Row_Pos5 /= No_Token_Index then

   Row_Pos4 := Row_Pos5;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;


--  BEGIN <Opt at parser.lkt:829:13>












--  BEGIN <_Extract at parser.lkt:829:14>

--  BEGIN <_Row at ???>

Row_Pos7 := Row_Pos4;



--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:829:19>

Token_Res9 := Row_Pos7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res9));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos9 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos7,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos9 := Row_Pos7 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:829:19>




if Token_Pos9 /= No_Token_Index then

   Row_Pos7 := Token_Pos9;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;


--  BEGIN <Defer at parser.lkt:829:23>

Defer_Res8 :=
   Expr_Or_Parse0 (Parser, Row_Pos7);
Defer_Pos8 := Parser.Current_Pos;

--  END <Defer at parser.lkt:829:23>




if Defer_Pos8 /= No_Token_Index then

   Row_Pos7 := Defer_Pos8;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:829:28>

Token_Res10 := Row_Pos7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res10));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos10 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos7,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos10 := Row_Pos7 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:829:28>




if Token_Pos10 /= No_Token_Index then

   Row_Pos7 := Token_Pos10;

else
   Row_Pos7 := No_Token_Index;
   goto Exit_Row7_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row7_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:829:14>


if Row_Pos7 = No_Token_Index then

         
   Defer_Res8 := No_Bare_Ada_Node;



       
   Row_Pos7 := Row_Pos4;



end if;

--  END <Opt at parser.lkt:829:13>




if Row_Pos7 /= No_Token_Index then

   Row_Pos4 := Row_Pos7;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;


--  BEGIN <Transform(<CompiledType BareEntryCompletionFormalParams>) at parser.lkt:830:13>

Transform_Diags6 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos8 := Row_Pos4;



--  BEGIN <Opt at parser.lkt:830:41>












--  BEGIN <Defer at parser.lkt:830:42>

Defer_Res9 :=
   Param_Specs_Transform_Parse0 (Parser, Row_Pos8);
Defer_Pos9 := Parser.Current_Pos;

--  END <Defer at parser.lkt:830:42>


if Defer_Pos9 = No_Token_Index then

         
   Defer_Res9 := No_Bare_Ada_Node;



       
   Defer_Pos9 := Row_Pos8;



end if;

--  END <Opt at parser.lkt:830:41>




if Defer_Pos9 /= No_Token_Index then

   Row_Pos8 := Defer_Pos9;

else
   Row_Pos8 := No_Token_Index;
   goto Exit_Row8_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row8_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos8 /= No_Token_Index then

   Transform_Res6 := Allocate_Entry_Completion_Formal_Params (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res6,
      Kind => Ada_Entry_Completion_Formal_Params,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos4,
      Token_End_Index   => (if Row_Pos8 = Row_Pos4
                            then No_Token_Index
                            else Row_Pos8 - 1));

      
      Initialize_Fields_For_Entry_Completion_Formal_Params
        (Self => Transform_Res6,
         Entry_Completion_Formal_Params_F_Params => Defer_Res9);

         if Defer_Res9 /= null and then Is_Incomplete (Defer_Res9) then
            Transform_Res6.Last_Attempted_Child := 0;
         elsif Defer_Res9 /= null and then not Is_Ghost (Defer_Res9) then
            Transform_Res6.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos8 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags6);
end if;

--  END <Transform(<CompiledType BareEntryCompletionFormalParams>) at parser.lkt:830:13>




if Row_Pos8 /= No_Token_Index then

   Row_Pos4 := Row_Pos8;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;


--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:831:13>

Token_Res11 := Row_Pos4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res11));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos11 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos4,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos11 := Row_Pos4 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:831:13>




if Token_Pos11 /= No_Token_Index then

   Row_Pos4 := Token_Pos11;

else
   Row_Pos4 := No_Token_Index;
   goto Exit_Row4_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row4_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos4 /= No_Token_Index then

   Transform_Res7 := Allocate_Accept_Stmt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res7,
      Kind => Ada_Accept_Stmt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos4 = Pos
                            then No_Token_Index
                            else Row_Pos4 - 1));

      
      Initialize_Fields_For_Accept_Stmt
        (Self => Transform_Res7,
         Accept_Stmt_F_Body_Decl => Transform_Res5,
         Accept_Stmt_F_Entry_Index_Expr => Defer_Res8,
         Accept_Stmt_F_Params => Transform_Res6);

         if Transform_Res5 /= null and then Is_Incomplete (Transform_Res5) then
            Transform_Res7.Last_Attempted_Child := 0;
         elsif Transform_Res5 /= null and then not Is_Ghost (Transform_Res5) then
            Transform_Res7.Last_Attempted_Child := -1;
         end if;
         if Defer_Res8 /= null and then Is_Incomplete (Defer_Res8) then
            Transform_Res7.Last_Attempted_Child := 0;
         elsif Defer_Res8 /= null and then not Is_Ghost (Defer_Res8) then
            Transform_Res7.Last_Attempted_Child := -1;
         end if;
         if Transform_Res6 /= null and then Is_Incomplete (Transform_Res6) then
            Transform_Res7.Last_Attempted_Child := 0;
         elsif Transform_Res6 /= null and then not Is_Ghost (Transform_Res6) then
            Transform_Res7.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos4 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags7);
end if;

--  END <Transform(<CompiledType BareAcceptStmt>) at parser.lkt:826:11>

    if Row_Pos4 /= No_Token_Index then
        Or_Pos1 := Row_Pos4;
        Or_Res1 := Transform_Res7;
        goto Exit_Or1;
    end if;
    
--  BEGIN <Transform(<CompiledType BareAcceptStmtWithStmts>) at parser.lkt:833:11>

Transform_Diags12 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos9 := Pos;



--  BEGIN <Token(<WithText Accept>, ) at parser.lkt:834:13>

Token_Res12 := Row_Pos9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res12));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Accept)
   then
       Token_Pos12 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos9,
             Expected_Token_Id => Ada_Accept,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos12 := Row_Pos9 + 1;
   end if;
end;

--  END <Token(<WithText Accept>, ) at parser.lkt:834:13>




if Token_Pos12 /= No_Token_Index then

   Row_Pos9 := Token_Pos12;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <Transform(<CompiledType BareAcceptStmtBody>) at parser.lkt:835:13>

Transform_Diags9 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos10 := Row_Pos9;



--  BEGIN <Transform(<CompiledType BareDefiningName>) at parser.lkt:835:28>

Transform_Diags8 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos11 := Row_Pos10;



--  BEGIN <Defer at parser.lkt:835:41>

Defer_Res10 :=
   Identifier_Transform_Parse0 (Parser, Row_Pos11);
Defer_Pos10 := Parser.Current_Pos;

--  END <Defer at parser.lkt:835:41>




if Defer_Pos10 /= No_Token_Index then

   Row_Pos11 := Defer_Pos10;

else
   Row_Pos11 := No_Token_Index;
   goto Exit_Row11_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row11_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos11 /= No_Token_Index then

   Transform_Res8 := Allocate_Defining_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res8,
      Kind => Ada_Defining_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos10,
      Token_End_Index   => (if Row_Pos11 = Row_Pos10
                            then No_Token_Index
                            else Row_Pos11 - 1));

      
      Initialize_Fields_For_Defining_Name
        (Self => Transform_Res8,
         Defining_Name_F_Name => Defer_Res10);

         if Defer_Res10 /= null and then Is_Incomplete (Defer_Res10) then
            Transform_Res8.Last_Attempted_Child := 0;
         elsif Defer_Res10 /= null and then not Is_Ghost (Defer_Res10) then
            Transform_Res8.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos11 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags8);
end if;

--  END <Transform(<CompiledType BareDefiningName>) at parser.lkt:835:28>




if Row_Pos11 /= No_Token_Index then

   Row_Pos10 := Row_Pos11;

else
   Row_Pos10 := No_Token_Index;
   goto Exit_Row10_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row10_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos10 /= No_Token_Index then

   Transform_Res9 := Allocate_Accept_Stmt_Body (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res9,
      Kind => Ada_Accept_Stmt_Body,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos9,
      Token_End_Index   => (if Row_Pos10 = Row_Pos9
                            then No_Token_Index
                            else Row_Pos10 - 1));

      
      Initialize_Fields_For_Accept_Stmt_Body
        (Self => Transform_Res9,
         Accept_Stmt_Body_F_Name => Transform_Res8);

         if Transform_Res8 /= null and then Is_Incomplete (Transform_Res8) then
            Transform_Res9.Last_Attempted_Child := 0;
         elsif Transform_Res8 /= null and then not Is_Ghost (Transform_Res8) then
            Transform_Res9.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos10 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags9);
end if;

--  END <Transform(<CompiledType BareAcceptStmtBody>) at parser.lkt:835:13>




if Row_Pos10 /= No_Token_Index then

   Row_Pos9 := Row_Pos10;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <Opt at parser.lkt:836:13>












--  BEGIN <_Extract at parser.lkt:836:14>

--  BEGIN <_Row at ???>

Row_Pos12 := Row_Pos9;



--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:836:19>

Token_Res13 := Row_Pos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res13));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos13 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos12,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos13 := Row_Pos12 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:836:19>




if Token_Pos13 /= No_Token_Index then

   Row_Pos12 := Token_Pos13;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  BEGIN <Defer at parser.lkt:836:23>

Defer_Res11 :=
   Expr_Or_Parse0 (Parser, Row_Pos12);
Defer_Pos11 := Parser.Current_Pos;

--  END <Defer at parser.lkt:836:23>




if Defer_Pos11 /= No_Token_Index then

   Row_Pos12 := Defer_Pos11;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:836:28>

Token_Res14 := Row_Pos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res14));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos14 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos12,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos14 := Row_Pos12 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:836:28>




if Token_Pos14 /= No_Token_Index then

   Row_Pos12 := Token_Pos14;

else
   Row_Pos12 := No_Token_Index;
   goto Exit_Row12_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row12_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:836:14>


if Row_Pos12 = No_Token_Index then

         
   Defer_Res11 := No_Bare_Ada_Node;



       
   Row_Pos12 := Row_Pos9;



end if;

--  END <Opt at parser.lkt:836:13>




if Row_Pos12 /= No_Token_Index then

   Row_Pos9 := Row_Pos12;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <Transform(<CompiledType BareEntryCompletionFormalParams>) at parser.lkt:837:13>

Transform_Diags10 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos13 := Row_Pos9;



--  BEGIN <Opt at parser.lkt:837:41>












--  BEGIN <Defer at parser.lkt:837:42>

Defer_Res12 :=
   Param_Specs_Transform_Parse0 (Parser, Row_Pos13);
Defer_Pos12 := Parser.Current_Pos;

--  END <Defer at parser.lkt:837:42>


if Defer_Pos12 = No_Token_Index then

         
   Defer_Res12 := No_Bare_Ada_Node;



       
   Defer_Pos12 := Row_Pos13;



end if;

--  END <Opt at parser.lkt:837:41>




if Defer_Pos12 /= No_Token_Index then

   Row_Pos13 := Defer_Pos12;

else
   Row_Pos13 := No_Token_Index;
   goto Exit_Row13_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row13_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos13 /= No_Token_Index then

   Transform_Res10 := Allocate_Entry_Completion_Formal_Params (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res10,
      Kind => Ada_Entry_Completion_Formal_Params,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos9,
      Token_End_Index   => (if Row_Pos13 = Row_Pos9
                            then No_Token_Index
                            else Row_Pos13 - 1));

      
      Initialize_Fields_For_Entry_Completion_Formal_Params
        (Self => Transform_Res10,
         Entry_Completion_Formal_Params_F_Params => Defer_Res12);

         if Defer_Res12 /= null and then Is_Incomplete (Defer_Res12) then
            Transform_Res10.Last_Attempted_Child := 0;
         elsif Defer_Res12 /= null and then not Is_Ghost (Defer_Res12) then
            Transform_Res10.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos13 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags10);
end if;

--  END <Transform(<CompiledType BareEntryCompletionFormalParams>) at parser.lkt:837:13>




if Row_Pos13 /= No_Token_Index then

   Row_Pos9 := Row_Pos13;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <Token(<WithText Do>, ) at parser.lkt:838:13>

Token_Res15 := Row_Pos9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res15));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Do)
   then
       Token_Pos15 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos9,
             Expected_Token_Id => Ada_Do,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos15 := Row_Pos9 + 1;
   end if;
end;

--  END <Token(<WithText Do>, ) at parser.lkt:838:13>




if Token_Pos15 /= No_Token_Index then

   Row_Pos9 := Token_Pos15;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <Defer at parser.lkt:839:13>

Defer_Res13 :=
   Handled_Stmts_Transform_Parse0 (Parser, Row_Pos9);
Defer_Pos13 := Parser.Current_Pos;

--  END <Defer at parser.lkt:839:13>




if Defer_Pos13 /= No_Token_Index then

   Row_Pos9 := Defer_Pos13;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <_Extract at parser.lkt:840:13>

--  BEGIN <_Row at ???>

Row_Pos14 := Row_Pos9;



--  BEGIN <Token(<WithText End>, ) at parser.lkt:840:18>

Token_Res16 := Row_Pos14;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res16));
begin
   if
      T.Kind /= From_Token_Kind (Ada_End)
   then
       Token_Pos16 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos14 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos14,
             Expected_Token_Id => Ada_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos16 := Row_Pos14 + 1;
   end if;
end;

--  END <Token(<WithText End>, ) at parser.lkt:840:18>




if Token_Pos16 /= No_Token_Index then

   Row_Pos14 := Token_Pos16;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;


--  BEGIN <Opt at parser.lkt:840:24>












--  BEGIN <Transform(<CompiledType BareEndName>) at parser.lkt:840:25>

Transform_Diags11 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos15 := Row_Pos14;



--  BEGIN <Defer at parser.lkt:840:33>

Defer_Res14 :=
   Identifier_Transform_Parse0 (Parser, Row_Pos15);
Defer_Pos14 := Parser.Current_Pos;

--  END <Defer at parser.lkt:840:33>




if Defer_Pos14 /= No_Token_Index then

   Row_Pos15 := Defer_Pos14;

else
   Row_Pos15 := No_Token_Index;
   goto Exit_Row15_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row15_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos15 /= No_Token_Index then

   Transform_Res11 := Allocate_End_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res11,
      Kind => Ada_End_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos14,
      Token_End_Index   => (if Row_Pos15 = Row_Pos14
                            then No_Token_Index
                            else Row_Pos15 - 1));

      
      Initialize_Fields_For_End_Name
        (Self => Transform_Res11,
         End_Name_F_Name => Defer_Res14);

         if Defer_Res14 /= null and then Is_Incomplete (Defer_Res14) then
            Transform_Res11.Last_Attempted_Child := 0;
         elsif Defer_Res14 /= null and then not Is_Ghost (Defer_Res14) then
            Transform_Res11.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos15 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags11);
end if;

--  END <Transform(<CompiledType BareEndName>) at parser.lkt:840:25>


if Row_Pos15 = No_Token_Index then

         
   Transform_Res11 := No_Bare_Ada_Node;



       
   Row_Pos15 := Row_Pos14;



end if;

--  END <Opt at parser.lkt:840:24>




if Row_Pos15 /= No_Token_Index then

   Row_Pos14 := Row_Pos15;

else
   Row_Pos14 := No_Token_Index;
   goto Exit_Row14_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row14_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:840:13>




if Row_Pos14 /= No_Token_Index then

   Row_Pos9 := Row_Pos14;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;


--  BEGIN <Opt at parser.lkt:841:13>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:841:14>

Token_Res17 := Row_Pos9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res17));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos17 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos9,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos17 := Row_Pos9 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:841:14>


if Token_Pos17 = No_Token_Index then

         
   Token_Res17 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos9)),
                To_Text ("Missing ';'"));

       
   Token_Pos17 := Row_Pos9;



end if;

--  END <Opt at parser.lkt:841:13>




if Token_Pos17 /= No_Token_Index then

   Row_Pos9 := Token_Pos17;

else
   Row_Pos9 := No_Token_Index;
   goto Exit_Row9_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row9_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos9 /= No_Token_Index then

   Transform_Res12 := Allocate_Accept_Stmt_With_Stmts (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res12,
      Kind => Ada_Accept_Stmt_With_Stmts,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos9 = Pos
                            then No_Token_Index
                            else Row_Pos9 - 1));

      
      Initialize_Fields_For_Accept_Stmt_With_Stmts
        (Self => Transform_Res12,
         Accept_Stmt_F_Body_Decl => Transform_Res9,
         Accept_Stmt_F_Entry_Index_Expr => Defer_Res11,
         Accept_Stmt_F_Params => Transform_Res10,
         Accept_Stmt_With_Stmts_F_Stmts => Defer_Res13,
         Accept_Stmt_With_Stmts_F_End_Name => Transform_Res11);

         if Transform_Res9 /= null and then Is_Incomplete (Transform_Res9) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Transform_Res9 /= null and then not Is_Ghost (Transform_Res9) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Defer_Res11 /= null and then Is_Incomplete (Defer_Res11) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res11 /= null and then not Is_Ghost (Defer_Res11) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Transform_Res10 /= null and then Is_Incomplete (Transform_Res10) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Transform_Res10 /= null and then not Is_Ghost (Transform_Res10) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Defer_Res13 /= null and then Is_Incomplete (Defer_Res13) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Defer_Res13 /= null and then not Is_Ghost (Defer_Res13) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;
         if Transform_Res11 /= null and then Is_Incomplete (Transform_Res11) then
            Transform_Res12.Last_Attempted_Child := 0;
         elsif Transform_Res11 /= null and then not Is_Ghost (Transform_Res11) then
            Transform_Res12.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos9 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags12);
end if;

--  END <Transform(<CompiledType BareAcceptStmtWithStmts>) at parser.lkt:833:11>

    if Row_Pos9 /= No_Token_Index then
        Or_Pos1 := Row_Pos9;
        Or_Res1 := Transform_Res12;
        goto Exit_Or1;
    end if;
<<Exit_Or1>>

--  END <Or at parser.lkt:825:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Accept_Stmt_Or_Parse0_Memo,
      Or_Pos1 /= No_Token_Index,
      Or_Res1,
      Pos,
      Or_Pos1);


   Parser.Current_Pos := Or_Pos1;

   return Or_Res1;
end Accept_Stmt_Or_Parse0;

   


function Access_Def_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Access_Def
is
   use Bare_Access_Def_Memos;

      Row_Pos16 :
            Token_Index
               := No_Token_Index;
      Row_Pos17 :
            Token_Index
               := No_Token_Index;
      Token_Pos18 :
            Token_Index
               := No_Token_Index;
      Token_Res18 :
            Token_Index
               := No_Token_Index;
      Token_Pos19 :
            Token_Index
               := No_Token_Index;
      Token_Res19 :
            Token_Index
               := No_Token_Index;
      Opt_Res0 :
            Bare_Not_Null
               := No_Bare_Ada_Node;
      Token_Pos20 :
            Token_Index
               := No_Token_Index;
      Token_Res20 :
            Token_Index
               := No_Token_Index;
      Token_Pos21 :
            Token_Index
               := No_Token_Index;
      Token_Res21 :
            Token_Index
               := No_Token_Index;
      Opt_Res1 :
            Bare_Protected_Node
               := No_Bare_Ada_Node;
      Defer_Pos15 :
            Token_Index
               := No_Token_Index;
      Defer_Res15 :
            Bare_Subp_Spec
               := No_Bare_Ada_Node;
      Transform_Res13 :
            Bare_Access_To_Subp_Def
               := No_Bare_Ada_Node;
      Transform_Diags13 :
            Ada.Containers.Count_Type;
      Row_Pos18 :
            Token_Index
               := No_Token_Index;
      Row_Pos19 :
            Token_Index
               := No_Token_Index;
      Token_Pos22 :
            Token_Index
               := No_Token_Index;
      Token_Res22 :
            Token_Index
               := No_Token_Index;
      Token_Pos23 :
            Token_Index
               := No_Token_Index;
      Token_Res23 :
            Token_Index
               := No_Token_Index;
      Opt_Res2 :
            Bare_Not_Null
               := No_Bare_Ada_Node;
      Token_Pos24 :
            Token_Index
               := No_Token_Index;
      Token_Res24 :
            Token_Index
               := No_Token_Index;
      Token_Pos25 :
            Token_Index
               := No_Token_Index;
      Token_Res25 :
            Token_Index
               := No_Token_Index;
      Opt_Res3 :
            Bare_All_Node
               := No_Bare_Ada_Node;
      Token_Pos26 :
            Token_Index
               := No_Token_Index;
      Token_Res26 :
            Token_Index
               := No_Token_Index;
      Opt_Res4 :
            Bare_Constant_Node
               := No_Bare_Ada_Node;
      Defer_Pos16 :
            Token_Index
               := No_Token_Index;
      Defer_Res16 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Transform_Res14 :
            Bare_Type_Access_Def
               := No_Bare_Ada_Node;
      Transform_Diags14 :
            Ada.Containers.Count_Type;
      Or_Pos2 :
            Token_Index
               := No_Token_Index;
      Or_Res2 :
            Bare_Access_Def
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Access_Def_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res2 := M.Instance;
      return Or_Res2;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res2;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:158:19>

Or_Pos2 := No_Token_Index;
Or_Res2 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareAccessToSubpDef>) at parser.lkt:159:11>

Transform_Diags13 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos16 := Pos;



--  BEGIN <Opt at parser.lkt:160:13>












--  BEGIN <_Row at ???>

Row_Pos17 := Row_Pos16;



--  BEGIN <Token(<WithText Not>, ) at parser.lkt:160:21>

Token_Res18 := Row_Pos17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res18));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos18 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos17,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos18 := Row_Pos17 + 1;
   end if;
end;

--  END <Token(<WithText Not>, ) at parser.lkt:160:21>




if Token_Pos18 /= No_Token_Index then

   Row_Pos17 := Token_Pos18;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;


--  BEGIN <Token(<WithSymbol Null>, ) at parser.lkt:160:27>

Token_Res19 := Row_Pos17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res19));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos19 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos17,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos19 := Row_Pos17 + 1;
   end if;
end;

--  END <Token(<WithSymbol Null>, ) at parser.lkt:160:27>




if Token_Pos19 /= No_Token_Index then

   Row_Pos17 := Token_Pos19;

else
   Row_Pos17 := No_Token_Index;
   goto Exit_Row17_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row17_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos17 = No_Token_Index then

         Opt_Res0 := Allocate_Not_Null_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res0,
            Kind              => Ada_Not_Null_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos16,
            Token_End_Index   => No_Token_Index);


       
   Row_Pos17 := Row_Pos16;


else

      Opt_Res0 := Allocate_Not_Null_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res0,
         Kind              => Ada_Not_Null_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos16,
         Token_End_Index   => Row_Pos17 - 1);

end if;

--  END <Opt at parser.lkt:160:13>




if Row_Pos17 /= No_Token_Index then

   Row_Pos16 := Row_Pos17;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  BEGIN <Token(<WithText Access>, ) at parser.lkt:161:13>

Token_Res20 := Row_Pos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res20));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Access)
   then
       Token_Pos20 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos16,
             Expected_Token_Id => Ada_Access,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos20 := Row_Pos16 + 1;
   end if;
end;

--  END <Token(<WithText Access>, ) at parser.lkt:161:13>




if Token_Pos20 /= No_Token_Index then

   Row_Pos16 := Token_Pos20;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  BEGIN <Opt at parser.lkt:162:13>












--  BEGIN <Token(<WithSymbol Identifier>, protected) at parser.lkt:162:23>

Token_Res21 := Row_Pos16;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res21));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Protected)
   then
       Token_Pos21 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos16 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos16,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos21 := Row_Pos16 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, protected) at parser.lkt:162:23>


if Token_Pos21 = No_Token_Index then

         Opt_Res1 := Allocate_Protected_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res1,
            Kind              => Ada_Protected_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos16,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos21 := Row_Pos16;


else

      Opt_Res1 := Allocate_Protected_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res1,
         Kind              => Ada_Protected_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos16,
         Token_End_Index   => Token_Pos21 - 1);

end if;

--  END <Opt at parser.lkt:162:13>




if Token_Pos21 /= No_Token_Index then

   Row_Pos16 := Token_Pos21;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;


--  BEGIN <Defer at parser.lkt:163:13>

Defer_Res15 :=
   Subp_Spec_Transform_Parse2 (Parser, Row_Pos16);
Defer_Pos15 := Parser.Current_Pos;

--  END <Defer at parser.lkt:163:13>




if Defer_Pos15 /= No_Token_Index then

   Row_Pos16 := Defer_Pos15;

else
   Row_Pos16 := No_Token_Index;
   goto Exit_Row16_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row16_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos16 /= No_Token_Index then

   Transform_Res13 := Allocate_Access_To_Subp_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res13,
      Kind => Ada_Access_To_Subp_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos16 = Pos
                            then No_Token_Index
                            else Row_Pos16 - 1));

      
      Initialize_Fields_For_Access_To_Subp_Def
        (Self => Transform_Res13,
         Access_Def_F_Has_Not_Null => Opt_Res0,
         Access_To_Subp_Def_F_Has_Protected => Opt_Res1,
         Access_To_Subp_Def_F_Subp_Spec => Defer_Res15);

         if Opt_Res0 /= null and then Is_Incomplete (Opt_Res0) then
            Transform_Res13.Last_Attempted_Child := 0;
         elsif Opt_Res0 /= null and then not Is_Ghost (Opt_Res0) then
            Transform_Res13.Last_Attempted_Child := -1;
         end if;
         if Opt_Res1 /= null and then Is_Incomplete (Opt_Res1) then
            Transform_Res13.Last_Attempted_Child := 0;
         elsif Opt_Res1 /= null and then not Is_Ghost (Opt_Res1) then
            Transform_Res13.Last_Attempted_Child := -1;
         end if;
         if Defer_Res15 /= null and then Is_Incomplete (Defer_Res15) then
            Transform_Res13.Last_Attempted_Child := 0;
         elsif Defer_Res15 /= null and then not Is_Ghost (Defer_Res15) then
            Transform_Res13.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos16 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags13);
end if;

--  END <Transform(<CompiledType BareAccessToSubpDef>) at parser.lkt:159:11>

    if Row_Pos16 /= No_Token_Index then
        Or_Pos2 := Row_Pos16;
        Or_Res2 := Transform_Res13;
        goto Exit_Or2;
    end if;
    
--  BEGIN <Transform(<CompiledType BareTypeAccessDef>) at parser.lkt:165:11>

Transform_Diags14 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos18 := Pos;



--  BEGIN <Opt at parser.lkt:166:13>












--  BEGIN <_Row at ???>

Row_Pos19 := Row_Pos18;



--  BEGIN <Token(<WithText Not>, ) at parser.lkt:166:21>

Token_Res22 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res22));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Not)
   then
       Token_Pos22 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Ada_Not,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos22 := Row_Pos19 + 1;
   end if;
end;

--  END <Token(<WithText Not>, ) at parser.lkt:166:21>




if Token_Pos22 /= No_Token_Index then

   Row_Pos19 := Token_Pos22;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;


--  BEGIN <Token(<WithSymbol Null>, ) at parser.lkt:166:27>

Token_Res23 := Row_Pos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res23));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos23 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos19,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos23 := Row_Pos19 + 1;
   end if;
end;

--  END <Token(<WithSymbol Null>, ) at parser.lkt:166:27>




if Token_Pos23 /= No_Token_Index then

   Row_Pos19 := Token_Pos23;

else
   Row_Pos19 := No_Token_Index;
   goto Exit_Row19_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row19_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos19 = No_Token_Index then

         Opt_Res2 := Allocate_Not_Null_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res2,
            Kind              => Ada_Not_Null_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos18,
            Token_End_Index   => No_Token_Index);


       
   Row_Pos19 := Row_Pos18;


else

      Opt_Res2 := Allocate_Not_Null_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res2,
         Kind              => Ada_Not_Null_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos18,
         Token_End_Index   => Row_Pos19 - 1);

end if;

--  END <Opt at parser.lkt:166:13>




if Row_Pos19 /= No_Token_Index then

   Row_Pos18 := Row_Pos19;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Token(<WithText Access>, ) at parser.lkt:167:13>

Token_Res24 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res24));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Access)
   then
       Token_Pos24 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Ada_Access,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos24 := Row_Pos18 + 1;
   end if;
end;

--  END <Token(<WithText Access>, ) at parser.lkt:167:13>




if Token_Pos24 /= No_Token_Index then

   Row_Pos18 := Token_Pos24;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Opt at parser.lkt:168:13>












--  BEGIN <Token(<WithText All>, ) at parser.lkt:168:17>

Token_Res25 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res25));
begin
   if
      T.Kind /= From_Token_Kind (Ada_All)
   then
       Token_Pos25 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Ada_All,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos25 := Row_Pos18 + 1;
   end if;
end;

--  END <Token(<WithText All>, ) at parser.lkt:168:17>


if Token_Pos25 = No_Token_Index then

         Opt_Res3 := Allocate_All_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res3,
            Kind              => Ada_All_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos18,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos25 := Row_Pos18;


else

      Opt_Res3 := Allocate_All_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res3,
         Kind              => Ada_All_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos18,
         Token_End_Index   => Token_Pos25 - 1);

end if;

--  END <Opt at parser.lkt:168:13>




if Token_Pos25 /= No_Token_Index then

   Row_Pos18 := Token_Pos25;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Opt at parser.lkt:169:13>












--  BEGIN <Token(<WithText Constant>, ) at parser.lkt:169:22>

Token_Res26 := Row_Pos18;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res26));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Constant)
   then
       Token_Pos26 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos18 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos18,
             Expected_Token_Id => Ada_Constant,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos26 := Row_Pos18 + 1;
   end if;
end;

--  END <Token(<WithText Constant>, ) at parser.lkt:169:22>


if Token_Pos26 = No_Token_Index then

         Opt_Res4 := Allocate_Constant_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res4,
            Kind              => Ada_Constant_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos18,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos26 := Row_Pos18;


else

      Opt_Res4 := Allocate_Constant_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res4,
         Kind              => Ada_Constant_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos18,
         Token_End_Index   => Token_Pos26 - 1);

end if;

--  END <Opt at parser.lkt:169:13>




if Token_Pos26 /= No_Token_Index then

   Row_Pos18 := Token_Pos26;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;


--  BEGIN <Defer at parser.lkt:170:13>

Defer_Res16 :=
   Subtype_Indication_Transform_Parse0 (Parser, Row_Pos18);
Defer_Pos16 := Parser.Current_Pos;

--  END <Defer at parser.lkt:170:13>




if Defer_Pos16 /= No_Token_Index then

   Row_Pos18 := Defer_Pos16;

else
   Row_Pos18 := No_Token_Index;
   goto Exit_Row18_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row18_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos18 /= No_Token_Index then

   Transform_Res14 := Allocate_Type_Access_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res14,
      Kind => Ada_Type_Access_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos18 = Pos
                            then No_Token_Index
                            else Row_Pos18 - 1));

      
      Initialize_Fields_For_Type_Access_Def
        (Self => Transform_Res14,
         Access_Def_F_Has_Not_Null => Opt_Res2,
         Type_Access_Def_F_Has_All => Opt_Res3,
         Type_Access_Def_F_Has_Constant => Opt_Res4,
         Type_Access_Def_F_Subtype_Indication => Defer_Res16);

         if Opt_Res2 /= null and then Is_Incomplete (Opt_Res2) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Opt_Res2 /= null and then not Is_Ghost (Opt_Res2) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;
         if Opt_Res3 /= null and then Is_Incomplete (Opt_Res3) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Opt_Res3 /= null and then not Is_Ghost (Opt_Res3) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;
         if Opt_Res4 /= null and then Is_Incomplete (Opt_Res4) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Opt_Res4 /= null and then not Is_Ghost (Opt_Res4) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;
         if Defer_Res16 /= null and then Is_Incomplete (Defer_Res16) then
            Transform_Res14.Last_Attempted_Child := 0;
         elsif Defer_Res16 /= null and then not Is_Ghost (Defer_Res16) then
            Transform_Res14.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos18 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags14);
end if;

--  END <Transform(<CompiledType BareTypeAccessDef>) at parser.lkt:165:11>

    if Row_Pos18 /= No_Token_Index then
        Or_Pos2 := Row_Pos18;
        Or_Res2 := Transform_Res14;
        goto Exit_Or2;
    end if;
<<Exit_Or2>>

--  END <Or at parser.lkt:158:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Access_Def_Or_Parse0_Memo,
      Or_Pos2 /= No_Token_Index,
      Or_Res2,
      Pos,
      Or_Pos2);


   Parser.Current_Pos := Or_Pos2;

   return Or_Res2;
end Access_Def_Or_Parse0;

   


function Add_Term_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Expr
is
   use Bare_Expr_Memos;

      Nobt0 :
            Boolean
               := False;
      Row_Pos20 :
            Token_Index
               := No_Token_Index;
      Defer_Pos17 :
            Token_Index
               := No_Token_Index;
      Defer_Res17 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Row_Pos21 :
            Token_Index
               := No_Token_Index;
      Token_Pos27 :
            Token_Index
               := No_Token_Index;
      Token_Res27 :
            Token_Index
               := No_Token_Index;
      Transform_Res15 :
            Bare_Op_Plus
               := No_Bare_Ada_Node;
      Transform_Diags15 :
            Ada.Containers.Count_Type;
      Row_Pos22 :
            Token_Index
               := No_Token_Index;
      Token_Pos28 :
            Token_Index
               := No_Token_Index;
      Token_Res28 :
            Token_Index
               := No_Token_Index;
      Transform_Res16 :
            Bare_Op_Minus
               := No_Bare_Ada_Node;
      Transform_Diags16 :
            Ada.Containers.Count_Type;
      Or_Pos3 :
            Token_Index
               := No_Token_Index;
      Or_Res3 :
            Bare_Op
               := No_Bare_Ada_Node;
      Defer_Pos18 :
            Token_Index
               := No_Token_Index;
      Defer_Res18 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Row_Progress0 :
            Integer
               := 0;
      Transform_Res17 :
            Bare_Bin_Op
               := No_Bare_Ada_Node;
      Transform_Has_Failed0 :
            Boolean
               := False;
      Transform_Diags17 :
            Ada.Containers.Count_Type;
      Defer_Pos19 :
            Token_Index
               := No_Token_Index;
      Defer_Res19 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos4 :
            Token_Index
               := No_Token_Index;
      Or_Res4 :
            Bare_Expr
               := No_Bare_Ada_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Expr := No_Bare_Ada_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Add_Term_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res4 := M.Instance;
      return Or_Res4;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res4;
   end if;

       Set (PP.Add_Term_Or_Parse1_Memo, False, Or_Res4, Pos, Mem_Pos);

       <<Try_Again>>

      Nobt0 := False;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1264:17>

Or_Pos4 := No_Token_Index;
Or_Res4 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareBinOp>) at parser.lkt:1265:11>

Transform_Diags17 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos20 := Pos;



--  BEGIN <Defer at parser.lkt:1265:17>

Defer_Res17 :=
   Add_Term_Or_Parse1 (Parser, Row_Pos20);
Defer_Pos17 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1265:17>



Row_Progress0 := 1;

if Defer_Pos17 /= No_Token_Index then

   Row_Pos20 := Defer_Pos17;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  BEGIN <Or at parser.lkt:1265:26>

Or_Pos3 := No_Token_Index;
Or_Res3 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareOpPlus>) at parser.lkt:1265:29>

Transform_Diags15 := Parser.Diagnostics.Length;


--  BEGIN <_Row at parser.lkt:1265:29>

Row_Pos21 := Row_Pos20;



--  BEGIN <Token(<WithText Plus>, ) at parser.lkt:1265:37>

Token_Res27 := Row_Pos21;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res27));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Plus)
   then
       Token_Pos27 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos21 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos21,
             Expected_Token_Id => Ada_Plus,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos27 := Row_Pos21 + 1;
   end if;
end;

--  END <Token(<WithText Plus>, ) at parser.lkt:1265:37>




if Token_Pos27 /= No_Token_Index then

   Row_Pos21 := Token_Pos27;

else
   Row_Pos21 := No_Token_Index;
   goto Exit_Row21_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row21_0>>
pragma Warnings (On, "referenced");

--  END <_Row at parser.lkt:1265:29>



if Row_Pos21 /= No_Token_Index then

   Transform_Res15 := Allocate_Op_Plus (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res15,
      Kind => Ada_Op_Plus,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos20,
      Token_End_Index   => (if Row_Pos21 = Row_Pos20
                            then No_Token_Index
                            else Row_Pos21 - 1));

      
      Initialize_Fields_For_Op_Plus
        (Self => Transform_Res15);



elsif Row_Pos21 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags15);
end if;

--  END <Transform(<CompiledType BareOpPlus>) at parser.lkt:1265:29>

    if Row_Pos21 /= No_Token_Index then
        Or_Pos3 := Row_Pos21;
        Or_Res3 := Transform_Res15;
        goto Exit_Or4;
    end if;
    
--  BEGIN <Transform(<CompiledType BareOpMinus>) at parser.lkt:1265:44>

Transform_Diags16 := Parser.Diagnostics.Length;


--  BEGIN <_Row at parser.lkt:1265:44>

Row_Pos22 := Row_Pos20;



--  BEGIN <Token(<WithText Minus>, ) at parser.lkt:1265:53>

Token_Res28 := Row_Pos22;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res28));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Minus)
   then
       Token_Pos28 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos22 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos22,
             Expected_Token_Id => Ada_Minus,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos28 := Row_Pos22 + 1;
   end if;
end;

--  END <Token(<WithText Minus>, ) at parser.lkt:1265:53>




if Token_Pos28 /= No_Token_Index then

   Row_Pos22 := Token_Pos28;

else
   Row_Pos22 := No_Token_Index;
   goto Exit_Row22_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row22_0>>
pragma Warnings (On, "referenced");

--  END <_Row at parser.lkt:1265:44>



if Row_Pos22 /= No_Token_Index then

   Transform_Res16 := Allocate_Op_Minus (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res16,
      Kind => Ada_Op_Minus,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos20,
      Token_End_Index   => (if Row_Pos22 = Row_Pos20
                            then No_Token_Index
                            else Row_Pos22 - 1));

      
      Initialize_Fields_For_Op_Minus
        (Self => Transform_Res16);



elsif Row_Pos22 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags16);
end if;

--  END <Transform(<CompiledType BareOpMinus>) at parser.lkt:1265:44>

    if Row_Pos22 /= No_Token_Index then
        Or_Pos3 := Row_Pos22;
        Or_Res3 := Transform_Res16;
        goto Exit_Or4;
    end if;
<<Exit_Or4>>

--  END <Or at parser.lkt:1265:26>



Row_Progress0 := 2;

if Or_Pos3 /= No_Token_Index then

   Row_Pos20 := Or_Pos3;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  BEGIN <Cut at ???>
Nobt0 := True;
--  END <Cut at ???>


   Nobt0 := Nobt0;

Row_Progress0 := 3;

if Row_Pos20 /= No_Token_Index then

   Row_Pos20 := Row_Pos20;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;


--  BEGIN <Defer at parser.lkt:1265:61>

Defer_Res18 :=
   Term_Or_Parse1 (Parser, Row_Pos20);
Defer_Pos18 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1265:61>



Row_Progress0 := 4;

if Defer_Pos18 /= No_Token_Index then

   Row_Pos20 := Defer_Pos18;

else
   Row_Pos20 := No_Token_Index;
   goto Exit_Row20_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row20_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos20 = No_Token_Index and then Nobt0 then

   Row_Pos20 := Parser.Last_Fail.Pos;

   Transform_Has_Failed0 := True;
end if;

if Row_Pos20 /= No_Token_Index then

   Transform_Res17 := Allocate_Bin_Op (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res17,
      Kind => Ada_Bin_Op,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos20 = Pos
                            then No_Token_Index
                            else Row_Pos20 - 1));

      
      Initialize_Fields_For_Bin_Op
        (Self => Transform_Res17,
         Bin_Op_F_Left => Defer_Res17,
         Bin_Op_F_Op => Or_Res3,
         Bin_Op_F_Right => Defer_Res18);

         if Defer_Res17 /= null and then Is_Incomplete (Defer_Res17) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Defer_Res17 /= null and then not Is_Ghost (Defer_Res17) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;
         if Or_Res3 /= null and then Is_Incomplete (Or_Res3) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Or_Res3 /= null and then not Is_Ghost (Or_Res3) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;
         if Defer_Res18 /= null and then Is_Incomplete (Defer_Res18) then
            Transform_Res17.Last_Attempted_Child := 0;
         elsif Defer_Res18 /= null and then not Is_Ghost (Defer_Res18) then
            Transform_Res17.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed0 then
      Transform_Res17.Last_Attempted_Child :=
         Row_Progress0;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <add_term>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos20 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags17);
end if;

--  END <Transform(<CompiledType BareBinOp>) at parser.lkt:1265:11>

    if Row_Pos20 /= No_Token_Index then
        Or_Pos4 := Row_Pos20;
        Or_Res4 := Transform_Res17;
        goto Exit_Or3;
    end if;
    
--  BEGIN <Defer at parser.lkt:1266:11>

Defer_Res19 :=
   Unop_Term_Or_Parse1 (Parser, Pos);
Defer_Pos19 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1266:11>

    if Defer_Pos19 /= No_Token_Index then
        Or_Pos4 := Defer_Pos19;
        Or_Res4 := Defer_Res19;
        goto Exit_Or3;
    end if;
<<Exit_Or3>>

--  END <Or at parser.lkt:1264:17>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos4 > Mem_Pos then
         Mem_Pos := Or_Pos4;
         Mem_Res := Or_Res4;
         Set
           (PP.Add_Term_Or_Parse1_Memo,
            Or_Pos4 /= No_Token_Index,
            Or_Res4,
            Pos,
            Or_Pos4);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res4 := Mem_Res;
         Or_Pos4 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Add_Term_Or_Parse1_Memo,
      Or_Pos4 /= No_Token_Index,
      Or_Res4,
      Pos,
      Or_Pos4);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos4;

   return Or_Res4;
end Add_Term_Or_Parse1;

   


function Aggregate_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate
is
   use Bare_Base_Aggregate_Memos;

      Defer_Pos20 :
            Token_Index
               := No_Token_Index;
      Defer_Res20 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;
      Defer_Pos21 :
            Token_Index
               := No_Token_Index;
      Defer_Res21 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;
      Or_Pos5 :
            Token_Index
               := No_Token_Index;
      Or_Res5 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Aggregate_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res5 := M.Instance;
      return Or_Res5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res5;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1118:18>

Or_Pos5 := No_Token_Index;
Or_Res5 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:1118:21>

Defer_Res20 :=
   Regular_Aggregate_Or_Parse0 (Parser, Pos);
Defer_Pos20 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1118:21>

    if Defer_Pos20 /= No_Token_Index then
        Or_Pos5 := Defer_Pos20;
        Or_Res5 := Defer_Res20;
        goto Exit_Or5;
    end if;
    
--  BEGIN <Defer at parser.lkt:1118:41>

Defer_Res21 :=
   Bracket_Aggregate_Or_Parse0 (Parser, Pos);
Defer_Pos21 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1118:41>

    if Defer_Pos21 /= No_Token_Index then
        Or_Pos5 := Defer_Pos21;
        Or_Res5 := Defer_Res21;
        goto Exit_Or5;
    end if;
<<Exit_Or5>>

--  END <Or at parser.lkt:1118:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Aggregate_Or_Parse0_Memo,
      Or_Pos5 /= No_Token_Index,
      Or_Res5,
      Pos,
      Or_Pos5);


   Parser.Current_Pos := Or_Pos5;

   return Or_Res5;
end Aggregate_Or_Parse0;

   


function Aggregate_Assoc_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Basic_Assoc
is
   use Bare_Basic_Assoc_Memos;

      Defer_Pos22 :
            Token_Index
               := No_Token_Index;
      Defer_Res22 :
            Bare_Iterated_Assoc
               := No_Bare_Ada_Node;
      Row_Pos23 :
            Token_Index
               := No_Token_Index;
      Row_Pos24 :
            Token_Index
               := No_Token_Index;
      Defer_Pos23 :
            Token_Index
               := No_Token_Index;
      Defer_Res23 :
            Bare_Alternatives_List
               := No_Bare_Ada_Node;
      Token_Pos29 :
            Token_Index
               := No_Token_Index;
      Token_Res29 :
            Token_Index
               := No_Token_Index;
      Defer_Pos24 :
            Token_Index
               := No_Token_Index;
      Defer_Res24 :
            Bare_Box_Expr
               := No_Bare_Ada_Node;
      Defer_Pos25 :
            Token_Index
               := No_Token_Index;
      Defer_Res25 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos6 :
            Token_Index
               := No_Token_Index;
      Or_Res6 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res18 :
            Bare_Aggregate_Assoc
               := No_Bare_Ada_Node;
      Transform_Diags18 :
            Ada.Containers.Count_Type;
      Or_Pos7 :
            Token_Index
               := No_Token_Index;
      Or_Res7 :
            Bare_Basic_Assoc
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Aggregate_Assoc_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res7 := M.Instance;
      return Or_Res7;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res7;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1084:24>

Or_Pos7 := No_Token_Index;
Or_Res7 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:1085:11>

Defer_Res22 :=
   Iterated_Assoc_Transform_Parse0 (Parser, Pos);
Defer_Pos22 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1085:11>

    if Defer_Pos22 /= No_Token_Index then
        Or_Pos7 := Defer_Pos22;
        Or_Res7 := Defer_Res22;
        goto Exit_Or6;
    end if;
    
--  BEGIN <Transform(<CompiledType BareAggregateAssoc>) at parser.lkt:1086:11>

Transform_Diags18 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos23 := Pos;



--  BEGIN <Opt at parser.lkt:1086:26>












--  BEGIN <_Extract at parser.lkt:1086:27>

--  BEGIN <_Row at ???>

Row_Pos24 := Row_Pos23;



--  BEGIN <Defer at parser.lkt:1086:32>

Defer_Res23 :=
   Choice_List_List_Parse0 (Parser, Row_Pos24);
Defer_Pos23 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1086:32>




if Defer_Pos23 /= No_Token_Index then

   Row_Pos24 := Defer_Pos23;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;


--  BEGIN <Token(<WithText Arrow>, ) at parser.lkt:1086:44>

Token_Res29 := Row_Pos24;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res29));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos29 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos24 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos24,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos29 := Row_Pos24 + 1;
   end if;
end;

--  END <Token(<WithText Arrow>, ) at parser.lkt:1086:44>




if Token_Pos29 /= No_Token_Index then

   Row_Pos24 := Token_Pos29;

else
   Row_Pos24 := No_Token_Index;
   goto Exit_Row24_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row24_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:1086:27>


if Row_Pos24 = No_Token_Index then

         
   Defer_Res23 :=
     Allocate_Alternatives_List (Parser.Mem_Pool);
   Initialize
     (Self              => Defer_Res23,
      Kind              => Ada_Alternatives_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos23 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => Defer_Res23,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos24 := Row_Pos23;



end if;

--  END <Opt at parser.lkt:1086:26>




if Row_Pos24 /= No_Token_Index then

   Row_Pos23 := Row_Pos24;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;


--  BEGIN <Or at parser.lkt:1086:50>

Or_Pos6 := No_Token_Index;
Or_Res6 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:1086:53>

Defer_Res24 :=
   Box_Expr_Transform_Parse0 (Parser, Row_Pos23);
Defer_Pos24 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1086:53>

    if Defer_Pos24 /= No_Token_Index then
        Or_Pos6 := Defer_Pos24;
        Or_Res6 := Defer_Res24;
        goto Exit_Or7;
    end if;
    
--  BEGIN <Defer at parser.lkt:1086:64>

Defer_Res25 :=
   Expr_Or_Parse0 (Parser, Row_Pos23);
Defer_Pos25 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1086:64>

    if Defer_Pos25 /= No_Token_Index then
        Or_Pos6 := Defer_Pos25;
        Or_Res6 := Defer_Res25;
        goto Exit_Or7;
    end if;
<<Exit_Or7>>

--  END <Or at parser.lkt:1086:50>




if Or_Pos6 /= No_Token_Index then

   Row_Pos23 := Or_Pos6;

else
   Row_Pos23 := No_Token_Index;
   goto Exit_Row23_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row23_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos23 /= No_Token_Index then

   Transform_Res18 := Allocate_Aggregate_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res18,
      Kind => Ada_Aggregate_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos23 = Pos
                            then No_Token_Index
                            else Row_Pos23 - 1));

      
      Initialize_Fields_For_Aggregate_Assoc
        (Self => Transform_Res18,
         Aggregate_Assoc_F_Designators => Defer_Res23,
         Aggregate_Assoc_F_R_Expr => Or_Res6);

         if Defer_Res23 /= null and then Is_Incomplete (Defer_Res23) then
            Transform_Res18.Last_Attempted_Child := 0;
         elsif Defer_Res23 /= null and then not Is_Ghost (Defer_Res23) then
            Transform_Res18.Last_Attempted_Child := -1;
         end if;
         if Or_Res6 /= null and then Is_Incomplete (Or_Res6) then
            Transform_Res18.Last_Attempted_Child := 0;
         elsif Or_Res6 /= null and then not Is_Ghost (Or_Res6) then
            Transform_Res18.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos23 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags18);
end if;

--  END <Transform(<CompiledType BareAggregateAssoc>) at parser.lkt:1086:11>

    if Row_Pos23 /= No_Token_Index then
        Or_Pos7 := Row_Pos23;
        Or_Res7 := Transform_Res18;
        goto Exit_Or6;
    end if;
<<Exit_Or6>>

--  END <Or at parser.lkt:1084:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Aggregate_Assoc_Or_Parse1_Memo,
      Or_Pos7 /= No_Token_Index,
      Or_Res7,
      Pos,
      Or_Pos7);


   Parser.Current_Pos := Or_Pos7;

   return Or_Res7;
end Aggregate_Assoc_Or_Parse1;

   


function Allocator_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Allocator
is
   use Bare_Allocator_Memos;

      Nobt1 :
            Boolean
               := False;
      Row_Pos25 :
            Token_Index
               := No_Token_Index;
      Token_Pos30 :
            Token_Index
               := No_Token_Index;
      Token_Res30 :
            Token_Index
               := No_Token_Index;
      Row_Pos26 :
            Token_Index
               := No_Token_Index;
      Token_Pos31 :
            Token_Index
               := No_Token_Index;
      Token_Res31 :
            Token_Index
               := No_Token_Index;
      Defer_Pos26 :
            Token_Index
               := No_Token_Index;
      Defer_Res26 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos32 :
            Token_Index
               := No_Token_Index;
      Token_Res32 :
            Token_Index
               := No_Token_Index;
      Defer_Pos27 :
            Token_Index
               := No_Token_Index;
      Defer_Res27 :
            Bare_Qual_Expr
               := No_Bare_Ada_Node;
      Defer_Pos28 :
            Token_Index
               := No_Token_Index;
      Defer_Res28 :
            Bare_Subtype_Indication
               := No_Bare_Ada_Node;
      Or_Pos8 :
            Token_Index
               := No_Token_Index;
      Or_Res8 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Row_Progress1 :
            Integer
               := 0;
      Transform_Res19 :
            Bare_Allocator
               := No_Bare_Ada_Node;
      Transform_Has_Failed1 :
            Boolean
               := False;
      Transform_Diags19 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Allocator_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res19 := M.Instance;
      return Transform_Res19;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res19;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareAllocator>) at parser.lkt:1047:18>

Transform_Diags19 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos25 := Pos;



--  BEGIN <Token(<WithText New>, ) at parser.lkt:1048:9>

Token_Res30 := Row_Pos25;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res30));
begin
   if
      T.Kind /= From_Token_Kind (Ada_New)
   then
       Token_Pos30 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos25 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos25,
             Expected_Token_Id => Ada_New,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos30 := Row_Pos25 + 1;
   end if;
end;

--  END <Token(<WithText New>, ) at parser.lkt:1048:9>



Row_Progress1 := 1;

if Token_Pos30 /= No_Token_Index then

   Row_Pos25 := Token_Pos30;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;


--  BEGIN <Cut at ???>
Nobt1 := True;
--  END <Cut at ???>


   Nobt1 := Nobt1;

Row_Progress1 := 2;

if Row_Pos25 /= No_Token_Index then

   Row_Pos25 := Row_Pos25;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;


--  BEGIN <Opt at parser.lkt:1048:17>












--  BEGIN <_Extract at parser.lkt:1048:18>

--  BEGIN <_Row at ???>

Row_Pos26 := Row_Pos25;



--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:1048:23>

Token_Res31 := Row_Pos26;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res31));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos31 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos26 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos26,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos31 := Row_Pos26 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:1048:23>




if Token_Pos31 /= No_Token_Index then

   Row_Pos26 := Token_Pos31;

else
   Row_Pos26 := No_Token_Index;
   goto Exit_Row26_0;

end if;


--  BEGIN <Defer at parser.lkt:1048:27>

Defer_Res26 :=
   Name_Or_Parse2 (Parser, Row_Pos26);
Defer_Pos26 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1048:27>




if Defer_Pos26 /= No_Token_Index then

   Row_Pos26 := Defer_Pos26;

else
   Row_Pos26 := No_Token_Index;
   goto Exit_Row26_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:1048:32>

Token_Res32 := Row_Pos26;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res32));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos32 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos26 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos26,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos32 := Row_Pos26 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:1048:32>




if Token_Pos32 /= No_Token_Index then

   Row_Pos26 := Token_Pos32;

else
   Row_Pos26 := No_Token_Index;
   goto Exit_Row26_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row26_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:1048:18>


if Row_Pos26 = No_Token_Index then

         
   Defer_Res26 := No_Bare_Ada_Node;



       
   Row_Pos26 := Row_Pos25;



end if;

--  END <Opt at parser.lkt:1048:17>



Row_Progress1 := 3;

if Row_Pos26 /= No_Token_Index then

   Row_Pos25 := Row_Pos26;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;


--  BEGIN <Or at parser.lkt:1048:37>

Or_Pos8 := No_Token_Index;
Or_Res8 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:1048:40>

Defer_Res27 :=
   Qualified_Name_Transform_Parse0 (Parser, Row_Pos25);
Defer_Pos27 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1048:40>

    if Defer_Pos27 /= No_Token_Index then
        Or_Pos8 := Defer_Pos27;
        Or_Res8 := Defer_Res27;
        goto Exit_Or8;
    end if;
    
--  BEGIN <Defer at parser.lkt:1048:57>

Defer_Res28 :=
   Subtype_Indication_Transform_Parse0 (Parser, Row_Pos25);
Defer_Pos28 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1048:57>

    if Defer_Pos28 /= No_Token_Index then
        Or_Pos8 := Defer_Pos28;
        Or_Res8 := Defer_Res28;
        goto Exit_Or8;
    end if;
<<Exit_Or8>>

--  END <Or at parser.lkt:1048:37>



Row_Progress1 := 4;

if Or_Pos8 /= No_Token_Index then

   Row_Pos25 := Or_Pos8;

else
   Row_Pos25 := No_Token_Index;
   goto Exit_Row25_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row25_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos25 = No_Token_Index and then Nobt1 then

   Row_Pos25 := Parser.Last_Fail.Pos;

   Transform_Has_Failed1 := True;
end if;

if Row_Pos25 /= No_Token_Index then

   Transform_Res19 := Allocate_Allocator (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res19,
      Kind => Ada_Allocator,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos25 = Pos
                            then No_Token_Index
                            else Row_Pos25 - 1));

      
      Initialize_Fields_For_Allocator
        (Self => Transform_Res19,
         Allocator_F_Subpool => Defer_Res26,
         Allocator_F_Type_Or_Expr => Or_Res8);

         if Defer_Res26 /= null and then Is_Incomplete (Defer_Res26) then
            Transform_Res19.Last_Attempted_Child := 0;
         elsif Defer_Res26 /= null and then not Is_Ghost (Defer_Res26) then
            Transform_Res19.Last_Attempted_Child := -1;
         end if;
         if Or_Res8 /= null and then Is_Incomplete (Or_Res8) then
            Transform_Res19.Last_Attempted_Child := 0;
         elsif Or_Res8 /= null and then not Is_Ghost (Or_Res8) then
            Transform_Res19.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed1 then
      Transform_Res19.Last_Attempted_Child :=
         Row_Progress1;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <allocator>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos25 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags19);
end if;

--  END <Transform(<CompiledType BareAllocator>) at parser.lkt:1047:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Allocator_Transform_Parse0_Memo,
      Row_Pos25 /= No_Token_Index,
      Transform_Res19,
      Pos,
      Row_Pos25);


   Parser.Current_Pos := Row_Pos25;

   return Transform_Res19;
end Allocator_Transform_Parse0;

   


function Anonymous_Type_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type
is
   use Bare_Anonymous_Type_Memos;

      Row_Pos27 :
            Token_Index
               := No_Token_Index;
      Defer_Pos29 :
            Token_Index
               := No_Token_Index;
      Defer_Res29 :
            Bare_Anonymous_Type_Decl
               := No_Bare_Ada_Node;
      Transform_Res20 :
            Bare_Anonymous_Type
               := No_Bare_Ada_Node;
      Transform_Diags20 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Anonymous_Type_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res20 := M.Instance;
      return Transform_Res20;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res20;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareAnonymousType>) at parser.lkt:651:23>

Transform_Diags20 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos27 := Pos;



--  BEGIN <Defer at parser.lkt:651:37>

Defer_Res29 :=
   Anonymous_Type_Decl_Transform_Parse0 (Parser, Row_Pos27);
Defer_Pos29 := Parser.Current_Pos;

--  END <Defer at parser.lkt:651:37>




if Defer_Pos29 /= No_Token_Index then

   Row_Pos27 := Defer_Pos29;

else
   Row_Pos27 := No_Token_Index;
   goto Exit_Row27_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row27_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos27 /= No_Token_Index then

   Transform_Res20 := Allocate_Anonymous_Type (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res20,
      Kind => Ada_Anonymous_Type,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos27 = Pos
                            then No_Token_Index
                            else Row_Pos27 - 1));

      
      Initialize_Fields_For_Anonymous_Type
        (Self => Transform_Res20,
         Anonymous_Type_F_Type_Decl => Defer_Res29);

         if Defer_Res29 /= null and then Is_Incomplete (Defer_Res29) then
            Transform_Res20.Last_Attempted_Child := 0;
         elsif Defer_Res29 /= null and then not Is_Ghost (Defer_Res29) then
            Transform_Res20.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos27 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags20);
end if;

--  END <Transform(<CompiledType BareAnonymousType>) at parser.lkt:651:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Anonymous_Type_Transform_Parse0_Memo,
      Row_Pos27 /= No_Token_Index,
      Transform_Res20,
      Pos,
      Row_Pos27);


   Parser.Current_Pos := Row_Pos27;

   return Transform_Res20;
end Anonymous_Type_Transform_Parse0;

   


function Anonymous_Type_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Anonymous_Type_Decl
is
   use Bare_Anonymous_Type_Decl_Memos;

      Row_Pos28 :
            Token_Index
               := No_Token_Index;
      Null_Res0 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Null_Res1 :
            Bare_Discriminant_Part
               := No_Bare_Ada_Node;
      Defer_Pos30 :
            Token_Index
               := No_Token_Index;
      Defer_Res30 :
            Bare_Array_Type_Def
               := No_Bare_Ada_Node;
      Defer_Pos31 :
            Token_Index
               := No_Token_Index;
      Defer_Res31 :
            Bare_Access_Def
               := No_Bare_Ada_Node;
      Or_Pos9 :
            Token_Index
               := No_Token_Index;
      Or_Res9 :
            Bare_Type_Def
               := No_Bare_Ada_Node;
      Transform_Res21 :
            Bare_Anonymous_Type_Decl
               := No_Bare_Ada_Node;
      Transform_Diags21 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Anonymous_Type_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res21 := M.Instance;
      return Transform_Res21;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res21;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareAnonymousTypeDecl>) at parser.lkt:187:28>

Transform_Diags21 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos28 := Pos;



--  BEGIN <Null at parser.lkt:188:9>

   Null_Res0 := No_Bare_Ada_Node;

--  END <Null at parser.lkt:188:9>




if Row_Pos28 /= No_Token_Index then

   Row_Pos28 := Row_Pos28;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;


--  BEGIN <Null at parser.lkt:189:9>

   Null_Res1 := No_Bare_Ada_Node;

--  END <Null at parser.lkt:189:9>




if Row_Pos28 /= No_Token_Index then

   Row_Pos28 := Row_Pos28;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;


--  BEGIN <Or at parser.lkt:190:9>

Or_Pos9 := No_Token_Index;
Or_Res9 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:190:12>

Defer_Res30 :=
   Array_Type_Def_Transform_Parse2 (Parser, Row_Pos28);
Defer_Pos30 := Parser.Current_Pos;

--  END <Defer at parser.lkt:190:12>

    if Defer_Pos30 /= No_Token_Index then
        Or_Pos9 := Defer_Pos30;
        Or_Res9 := Defer_Res30;
        goto Exit_Or9;
    end if;
    
--  BEGIN <Defer at parser.lkt:190:29>

Defer_Res31 :=
   Access_Def_Or_Parse0 (Parser, Row_Pos28);
Defer_Pos31 := Parser.Current_Pos;

--  END <Defer at parser.lkt:190:29>

    if Defer_Pos31 /= No_Token_Index then
        Or_Pos9 := Defer_Pos31;
        Or_Res9 := Defer_Res31;
        goto Exit_Or9;
    end if;
<<Exit_Or9>>

--  END <Or at parser.lkt:190:9>




if Or_Pos9 /= No_Token_Index then

   Row_Pos28 := Or_Pos9;

else
   Row_Pos28 := No_Token_Index;
   goto Exit_Row28_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row28_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos28 /= No_Token_Index then

   Transform_Res21 := Allocate_Anonymous_Type_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res21,
      Kind => Ada_Anonymous_Type_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos28 = Pos
                            then No_Token_Index
                            else Row_Pos28 - 1));

      
      Initialize_Fields_For_Anonymous_Type_Decl
        (Self => Transform_Res21,
         Base_Type_Decl_F_Name => Null_Res0,
         Type_Decl_F_Discriminants => Null_Res1,
         Type_Decl_F_Type_Def => Or_Res9);

         if Null_Res0 /= null and then Is_Incomplete (Null_Res0) then
            Transform_Res21.Last_Attempted_Child := 0;
         elsif Null_Res0 /= null and then not Is_Ghost (Null_Res0) then
            Transform_Res21.Last_Attempted_Child := -1;
         end if;
         if Null_Res1 /= null and then Is_Incomplete (Null_Res1) then
            Transform_Res21.Last_Attempted_Child := 0;
         elsif Null_Res1 /= null and then not Is_Ghost (Null_Res1) then
            Transform_Res21.Last_Attempted_Child := -1;
         end if;
         if Or_Res9 /= null and then Is_Incomplete (Or_Res9) then
            Transform_Res21.Last_Attempted_Child := 0;
         elsif Or_Res9 /= null and then not Is_Ghost (Or_Res9) then
            Transform_Res21.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos28 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags21);
end if;

--  END <Transform(<CompiledType BareAnonymousTypeDecl>) at parser.lkt:187:28>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Anonymous_Type_Decl_Transform_Parse0_Memo,
      Row_Pos28 /= No_Token_Index,
      Transform_Res21,
      Pos,
      Row_Pos28);


   Parser.Current_Pos := Row_Pos28;

   return Transform_Res21;
end Anonymous_Type_Decl_Transform_Parse0;

   


function Array_Subcomponent_Choice_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Name
is
   use Bare_Name_Memos;

      Row_Pos29 :
            Token_Index
               := No_Token_Index;
      Defer_Pos32 :
            Token_Index
               := No_Token_Index;
      Defer_Res32 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos33 :
            Token_Index
               := No_Token_Index;
      Token_Res33 :
            Token_Index
               := No_Token_Index;
      Defer_Pos33 :
            Token_Index
               := No_Token_Index;
      Defer_Res33 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Transform_Res22 :
            Bare_Dotted_Name
               := No_Bare_Ada_Node;
      Transform_Diags22 :
            Ada.Containers.Count_Type;
      Row_Pos30 :
            Token_Index
               := No_Token_Index;
      Defer_Pos34 :
            Token_Index
               := No_Token_Index;
      Defer_Res34 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos34 :
            Token_Index
               := No_Token_Index;
      Token_Res34 :
            Token_Index
               := No_Token_Index;
      Defer_Pos35 :
            Token_Index
               := No_Token_Index;
      Defer_Res35 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos35 :
            Token_Index
               := No_Token_Index;
      Token_Res35 :
            Token_Index
               := No_Token_Index;
      Transform_Res23 :
            Bare_Array_Subcomponent_Choice_Name
               := No_Bare_Ada_Node;
      Transform_Diags23 :
            Ada.Containers.Count_Type;
      Row_Pos31 :
            Token_Index
               := No_Token_Index;
      Null_Res2 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos36 :
            Token_Index
               := No_Token_Index;
      Token_Res36 :
            Token_Index
               := No_Token_Index;
      Defer_Pos36 :
            Token_Index
               := No_Token_Index;
      Defer_Res36 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos37 :
            Token_Index
               := No_Token_Index;
      Token_Res37 :
            Token_Index
               := No_Token_Index;
      Transform_Res24 :
            Bare_Array_Subcomponent_Choice_Name
               := No_Bare_Ada_Node;
      Transform_Diags24 :
            Ada.Containers.Count_Type;
      Or_Pos10 :
            Token_Index
               := No_Token_Index;
      Or_Res10 :
            Bare_Name
               := No_Bare_Ada_Node;

      Mem_Pos : Token_Index := Pos;
      Mem_Res : Bare_Name := No_Bare_Ada_Node;

   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Array_Subcomponent_Choice_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res10 := M.Instance;
      return Or_Res10;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res10;
   end if;

       Set (PP.Array_Subcomponent_Choice_Or_Parse0_Memo, False, Or_Res10, Pos, Mem_Pos);

       <<Try_Again>>



   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1283:34>

Or_Pos10 := No_Token_Index;
Or_Res10 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareDottedName>) at parser.lkt:1284:11>

Transform_Diags22 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos29 := Pos;



--  BEGIN <Defer at parser.lkt:1284:22>

Defer_Res32 :=
   Array_Subcomponent_Choice_Or_Parse0 (Parser, Row_Pos29);
Defer_Pos32 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1284:22>




if Defer_Pos32 /= No_Token_Index then

   Row_Pos29 := Defer_Pos32;

else
   Row_Pos29 := No_Token_Index;
   goto Exit_Row29_0;

end if;


--  BEGIN <Token(<WithText Dot>, ) at parser.lkt:1284:48>

Token_Res33 := Row_Pos29;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res33));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Dot)
   then
       Token_Pos33 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos29 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos29,
             Expected_Token_Id => Ada_Dot,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos33 := Row_Pos29 + 1;
   end if;
end;

--  END <Token(<WithText Dot>, ) at parser.lkt:1284:48>




if Token_Pos33 /= No_Token_Index then

   Row_Pos29 := Token_Pos33;

else
   Row_Pos29 := No_Token_Index;
   goto Exit_Row29_0;

end if;


--  BEGIN <Defer at parser.lkt:1284:52>

Defer_Res33 :=
   Direct_Name_Or_Parse0 (Parser, Row_Pos29);
Defer_Pos33 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1284:52>




if Defer_Pos33 /= No_Token_Index then

   Row_Pos29 := Defer_Pos33;

else
   Row_Pos29 := No_Token_Index;
   goto Exit_Row29_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row29_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos29 /= No_Token_Index then

   Transform_Res22 := Allocate_Dotted_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res22,
      Kind => Ada_Dotted_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos29 = Pos
                            then No_Token_Index
                            else Row_Pos29 - 1));

      
      Initialize_Fields_For_Dotted_Name
        (Self => Transform_Res22,
         Dotted_Name_F_Prefix => Defer_Res32,
         Dotted_Name_F_Suffix => Defer_Res33);

         if Defer_Res32 /= null and then Is_Incomplete (Defer_Res32) then
            Transform_Res22.Last_Attempted_Child := 0;
         elsif Defer_Res32 /= null and then not Is_Ghost (Defer_Res32) then
            Transform_Res22.Last_Attempted_Child := -1;
         end if;
         if Defer_Res33 /= null and then Is_Incomplete (Defer_Res33) then
            Transform_Res22.Last_Attempted_Child := 0;
         elsif Defer_Res33 /= null and then not Is_Ghost (Defer_Res33) then
            Transform_Res22.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos29 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags22);
end if;

--  END <Transform(<CompiledType BareDottedName>) at parser.lkt:1284:11>

    if Row_Pos29 /= No_Token_Index then
        Or_Pos10 := Row_Pos29;
        Or_Res10 := Transform_Res22;
        goto Exit_Or10;
    end if;
    
--  BEGIN <Transform(<CompiledType BareArraySubcomponentChoiceName>) at parser.lkt:1285:11>

Transform_Diags23 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos30 := Pos;



--  BEGIN <Defer at parser.lkt:1286:13>

Defer_Res34 :=
   Array_Subcomponent_Choice_Or_Parse0 (Parser, Row_Pos30);
Defer_Pos34 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1286:13>




if Defer_Pos34 /= No_Token_Index then

   Row_Pos30 := Defer_Pos34;

else
   Row_Pos30 := No_Token_Index;
   goto Exit_Row30_0;

end if;


--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:1286:39>

Token_Res34 := Row_Pos30;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res34));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos34 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos30 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos30,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos34 := Row_Pos30 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:1286:39>




if Token_Pos34 /= No_Token_Index then

   Row_Pos30 := Token_Pos34;

else
   Row_Pos30 := No_Token_Index;
   goto Exit_Row30_0;

end if;


--  BEGIN <Defer at parser.lkt:1286:43>

Defer_Res35 :=
   Call_Suffix_Or_Parse0 (Parser, Row_Pos30);
Defer_Pos35 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1286:43>




if Defer_Pos35 /= No_Token_Index then

   Row_Pos30 := Defer_Pos35;

else
   Row_Pos30 := No_Token_Index;
   goto Exit_Row30_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:1286:55>

Token_Res35 := Row_Pos30;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res35));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos35 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos30 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos30,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos35 := Row_Pos30 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:1286:55>




if Token_Pos35 /= No_Token_Index then

   Row_Pos30 := Token_Pos35;

else
   Row_Pos30 := No_Token_Index;
   goto Exit_Row30_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row30_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos30 /= No_Token_Index then

   Transform_Res23 := Allocate_Array_Subcomponent_Choice_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res23,
      Kind => Ada_Array_Subcomponent_Choice_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos30 = Pos
                            then No_Token_Index
                            else Row_Pos30 - 1));

      
      Initialize_Fields_For_Array_Subcomponent_Choice_Name
        (Self => Transform_Res23,
         Array_Subcomponent_Choice_Name_F_Name => Defer_Res34,
         Array_Subcomponent_Choice_Name_F_Suffix => Defer_Res35);

         if Defer_Res34 /= null and then Is_Incomplete (Defer_Res34) then
            Transform_Res23.Last_Attempted_Child := 0;
         elsif Defer_Res34 /= null and then not Is_Ghost (Defer_Res34) then
            Transform_Res23.Last_Attempted_Child := -1;
         end if;
         if Defer_Res35 /= null and then Is_Incomplete (Defer_Res35) then
            Transform_Res23.Last_Attempted_Child := 0;
         elsif Defer_Res35 /= null and then not Is_Ghost (Defer_Res35) then
            Transform_Res23.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos30 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags23);
end if;

--  END <Transform(<CompiledType BareArraySubcomponentChoiceName>) at parser.lkt:1285:11>

    if Row_Pos30 /= No_Token_Index then
        Or_Pos10 := Row_Pos30;
        Or_Res10 := Transform_Res23;
        goto Exit_Or10;
    end if;
    
--  BEGIN <Transform(<CompiledType BareArraySubcomponentChoiceName>) at parser.lkt:1288:11>

Transform_Diags24 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos31 := Pos;



--  BEGIN <Null at parser.lkt:1288:39>

   Null_Res2 := No_Bare_Ada_Node;

--  END <Null at parser.lkt:1288:39>




if Row_Pos31 /= No_Token_Index then

   Row_Pos31 := Row_Pos31;

else
   Row_Pos31 := No_Token_Index;
   goto Exit_Row31_0;

end if;


--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:1288:50>

Token_Res36 := Row_Pos31;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res36));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos36 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos31 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos31,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos36 := Row_Pos31 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:1288:50>




if Token_Pos36 /= No_Token_Index then

   Row_Pos31 := Token_Pos36;

else
   Row_Pos31 := No_Token_Index;
   goto Exit_Row31_0;

end if;


--  BEGIN <Defer at parser.lkt:1288:54>

Defer_Res36 :=
   Call_Suffix_Or_Parse0 (Parser, Row_Pos31);
Defer_Pos36 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1288:54>




if Defer_Pos36 /= No_Token_Index then

   Row_Pos31 := Defer_Pos36;

else
   Row_Pos31 := No_Token_Index;
   goto Exit_Row31_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:1288:66>

Token_Res37 := Row_Pos31;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res37));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos37 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos31 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos31,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos37 := Row_Pos31 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:1288:66>




if Token_Pos37 /= No_Token_Index then

   Row_Pos31 := Token_Pos37;

else
   Row_Pos31 := No_Token_Index;
   goto Exit_Row31_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row31_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos31 /= No_Token_Index then

   Transform_Res24 := Allocate_Array_Subcomponent_Choice_Name (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res24,
      Kind => Ada_Array_Subcomponent_Choice_Name,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos31 = Pos
                            then No_Token_Index
                            else Row_Pos31 - 1));

      
      Initialize_Fields_For_Array_Subcomponent_Choice_Name
        (Self => Transform_Res24,
         Array_Subcomponent_Choice_Name_F_Name => Null_Res2,
         Array_Subcomponent_Choice_Name_F_Suffix => Defer_Res36);

         if Null_Res2 /= null and then Is_Incomplete (Null_Res2) then
            Transform_Res24.Last_Attempted_Child := 0;
         elsif Null_Res2 /= null and then not Is_Ghost (Null_Res2) then
            Transform_Res24.Last_Attempted_Child := -1;
         end if;
         if Defer_Res36 /= null and then Is_Incomplete (Defer_Res36) then
            Transform_Res24.Last_Attempted_Child := 0;
         elsif Defer_Res36 /= null and then not Is_Ghost (Defer_Res36) then
            Transform_Res24.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos31 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags24);
end if;

--  END <Transform(<CompiledType BareArraySubcomponentChoiceName>) at parser.lkt:1288:11>

    if Row_Pos31 /= No_Token_Index then
        Or_Pos10 := Row_Pos31;
        Or_Res10 := Transform_Res24;
        goto Exit_Or10;
    end if;
<<Exit_Or10>>

--  END <Or at parser.lkt:1283:34>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------

      if Or_Pos10 > Mem_Pos then
         Mem_Pos := Or_Pos10;
         Mem_Res := Or_Res10;
         Set
           (PP.Array_Subcomponent_Choice_Or_Parse0_Memo,
            Or_Pos10 /= No_Token_Index,
            Or_Res10,
            Pos,
            Or_Pos10);
         goto Try_Again;

      elsif Mem_Pos > Pos then
         Or_Res10 := Mem_Res;
         Or_Pos10 := Mem_Pos;
         goto No_Memo;
      end if;

   Set
     (PP.Array_Subcomponent_Choice_Or_Parse0_Memo,
      Or_Pos10 /= No_Token_Index,
      Or_Res10,
      Pos,
      Or_Pos10);

       <<No_Memo>>

   Parser.Current_Pos := Or_Pos10;

   return Or_Res10;
end Array_Subcomponent_Choice_Or_Parse0;

   


function Array_Type_Def_Transform_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Array_Type_Def
is
   use Bare_Array_Type_Def_Memos;

      Row_Pos32 :
            Token_Index
               := No_Token_Index;
      Token_Pos38 :
            Token_Index
               := No_Token_Index;
      Token_Res38 :
            Token_Index
               := No_Token_Index;
      Token_Pos39 :
            Token_Index
               := No_Token_Index;
      Token_Res39 :
            Token_Index
               := No_Token_Index;
      Row_Pos33 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos1 :
            Token_Index
               := No_Token_Index;
      Tmp_List1 :
            Free_Parse_List;
      Defer_Pos37 :
            Token_Index
               := No_Token_Index;
      Defer_Res37 :
            Bare_Unconstrained_Array_Index
               := No_Bare_Ada_Node;
      Token_Pos40 :
            Token_Index
               := No_Token_Index;
      Token_Res40 :
            Token_Index
               := No_Token_Index;
      List_Pos1 :
            Token_Index
               := No_Token_Index;
      List_Res1 :
            Bare_Unconstrained_Array_Index_List
               := No_Bare_Ada_Node;
      Transform_Res25 :
            Bare_Unconstrained_Array_Indices
               := No_Bare_Ada_Node;
      Transform_Diags25 :
            Ada.Containers.Count_Type;
      Row_Pos34 :
            Token_Index
               := No_Token_Index;
      Defer_Pos38 :
            Token_Index
               := No_Token_Index;
      Defer_Res38 :
            Bare_Constraint_List
               := No_Bare_Ada_Node;
      Transform_Res26 :
            Bare_Constrained_Array_Indices
               := No_Bare_Ada_Node;
      Transform_Diags26 :
            Ada.Containers.Count_Type;
      Or_Pos11 :
            Token_Index
               := No_Token_Index;
      Or_Res11 :
            Bare_Array_Indices
               := No_Bare_Ada_Node;
      Token_Pos41 :
            Token_Index
               := No_Token_Index;
      Token_Res41 :
            Token_Index
               := No_Token_Index;
      Token_Pos42 :
            Token_Index
               := No_Token_Index;
      Token_Res42 :
            Token_Index
               := No_Token_Index;
      Defer_Pos39 :
            Token_Index
               := No_Token_Index;
      Defer_Res39 :
            Bare_Component_Def
               := No_Bare_Ada_Node;
      Transform_Res27 :
            Bare_Array_Type_Def
               := No_Bare_Ada_Node;
      Transform_Diags27 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Array_Type_Def_Transform_Parse2_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res27 := M.Instance;
      return Transform_Res27;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res27;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareArrayTypeDef>) at parser.lkt:65:23>

Transform_Diags27 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos32 := Pos;



--  BEGIN <Token(<WithText Array>, ) at parser.lkt:66:9>

Token_Res38 := Row_Pos32;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res38));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Array)
   then
       Token_Pos38 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos32 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos32,
             Expected_Token_Id => Ada_Array,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos38 := Row_Pos32 + 1;
   end if;
end;

--  END <Token(<WithText Array>, ) at parser.lkt:66:9>




if Token_Pos38 /= No_Token_Index then

   Row_Pos32 := Token_Pos38;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;


--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:67:9>

Token_Res39 := Row_Pos32;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res39));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos39 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos32 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos32,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos39 := Row_Pos32 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:67:9>




if Token_Pos39 /= No_Token_Index then

   Row_Pos32 := Token_Pos39;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;


--  BEGIN <Or at parser.lkt:68:9>

Or_Pos11 := No_Token_Index;
Or_Res11 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareUnconstrainedArrayIndices>) at parser.lkt:69:15>

Transform_Diags25 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos33 := Row_Pos32;



--  BEGIN <List at parser.lkt:69:41>

    List_Pos1 := No_Token_Index;



Lst_Cpos1 := Row_Pos33;
Tmp_List1 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:69:47>

Defer_Res37 :=
   Unconstrained_Index_Transform_Parse0 (Parser, Lst_Cpos1);
Defer_Pos37 := Parser.Current_Pos;

--  END <Defer at parser.lkt:69:47>


   exit when Defer_Pos37 = No_Token_Index;

   List_Pos1 := Defer_Pos37;
   Lst_Cpos1 := List_Pos1;

   Tmp_List1.Nodes.Append (Defer_Res37);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:69:68>

Token_Res40 := Lst_Cpos1;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res40));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos40 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos1 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos1,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos40 := Lst_Cpos1 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:69:68>


      exit when Token_Pos40 = No_Token_Index;

      Lst_Cpos1 := Token_Pos40;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List1.Nodes.Length;
begin
   List_Res1 := Allocate_Unconstrained_Array_Index_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos33;
      Token_End := (if Lst_Cpos1 = Row_Pos33
                    then Row_Pos33
                    else List_Pos1 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos33, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res1,
      Kind              => Ada_Unconstrained_Array_Index_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res1,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List1.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res1.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List1);

--  END <List at parser.lkt:69:41>




if List_Pos1 /= No_Token_Index then

   Row_Pos33 := List_Pos1;

else
   Row_Pos33 := No_Token_Index;
   goto Exit_Row33_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row33_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos33 /= No_Token_Index then

   Transform_Res25 := Allocate_Unconstrained_Array_Indices (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res25,
      Kind => Ada_Unconstrained_Array_Indices,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos32,
      Token_End_Index   => (if Row_Pos33 = Row_Pos32
                            then No_Token_Index
                            else Row_Pos33 - 1));

      
      Initialize_Fields_For_Unconstrained_Array_Indices
        (Self => Transform_Res25,
         Unconstrained_Array_Indices_F_Types => List_Res1);

         if List_Res1 /= null and then Is_Incomplete (List_Res1) then
            Transform_Res25.Last_Attempted_Child := 0;
         elsif List_Res1 /= null and then not Is_Ghost (List_Res1) then
            Transform_Res25.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos33 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags25);
end if;

--  END <Transform(<CompiledType BareUnconstrainedArrayIndices>) at parser.lkt:69:15>

    if Row_Pos33 /= No_Token_Index then
        Or_Pos11 := Row_Pos33;
        Or_Res11 := Transform_Res25;
        goto Exit_Or11;
    end if;
    
--  BEGIN <Transform(<CompiledType BareConstrainedArrayIndices>) at parser.lkt:70:15>

Transform_Diags26 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos34 := Row_Pos32;



--  BEGIN <Defer at parser.lkt:70:39>

Defer_Res38 :=
   Constraint_List_List_Parse0 (Parser, Row_Pos34);
Defer_Pos38 := Parser.Current_Pos;

--  END <Defer at parser.lkt:70:39>




if Defer_Pos38 /= No_Token_Index then

   Row_Pos34 := Defer_Pos38;

else
   Row_Pos34 := No_Token_Index;
   goto Exit_Row34_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row34_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos34 /= No_Token_Index then

   Transform_Res26 := Allocate_Constrained_Array_Indices (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res26,
      Kind => Ada_Constrained_Array_Indices,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos32,
      Token_End_Index   => (if Row_Pos34 = Row_Pos32
                            then No_Token_Index
                            else Row_Pos34 - 1));

      
      Initialize_Fields_For_Constrained_Array_Indices
        (Self => Transform_Res26,
         Constrained_Array_Indices_F_List => Defer_Res38);

         if Defer_Res38 /= null and then Is_Incomplete (Defer_Res38) then
            Transform_Res26.Last_Attempted_Child := 0;
         elsif Defer_Res38 /= null and then not Is_Ghost (Defer_Res38) then
            Transform_Res26.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos34 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags26);
end if;

--  END <Transform(<CompiledType BareConstrainedArrayIndices>) at parser.lkt:70:15>

    if Row_Pos34 /= No_Token_Index then
        Or_Pos11 := Row_Pos34;
        Or_Res11 := Transform_Res26;
        goto Exit_Or11;
    end if;
<<Exit_Or11>>

--  END <Or at parser.lkt:68:9>




if Or_Pos11 /= No_Token_Index then

   Row_Pos32 := Or_Pos11;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:72:9>

Token_Res41 := Row_Pos32;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res41));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos41 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos32 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos32,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos41 := Row_Pos32 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:72:9>




if Token_Pos41 /= No_Token_Index then

   Row_Pos32 := Token_Pos41;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;


--  BEGIN <Token(<WithText Of>, ) at parser.lkt:73:9>

Token_Res42 := Row_Pos32;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res42));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Of)
   then
       Token_Pos42 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos32 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos32,
             Expected_Token_Id => Ada_Of,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos42 := Row_Pos32 + 1;
   end if;
end;

--  END <Token(<WithText Of>, ) at parser.lkt:73:9>




if Token_Pos42 /= No_Token_Index then

   Row_Pos32 := Token_Pos42;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;


--  BEGIN <Defer at parser.lkt:74:9>

Defer_Res39 :=
   Component_Def_Transform_Parse0 (Parser, Row_Pos32);
Defer_Pos39 := Parser.Current_Pos;

--  END <Defer at parser.lkt:74:9>




if Defer_Pos39 /= No_Token_Index then

   Row_Pos32 := Defer_Pos39;

else
   Row_Pos32 := No_Token_Index;
   goto Exit_Row32_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row32_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos32 /= No_Token_Index then

   Transform_Res27 := Allocate_Array_Type_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res27,
      Kind => Ada_Array_Type_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos32 = Pos
                            then No_Token_Index
                            else Row_Pos32 - 1));

      
      Initialize_Fields_For_Array_Type_Def
        (Self => Transform_Res27,
         Array_Type_Def_F_Indices => Or_Res11,
         Array_Type_Def_F_Component_Type => Defer_Res39);

         if Or_Res11 /= null and then Is_Incomplete (Or_Res11) then
            Transform_Res27.Last_Attempted_Child := 0;
         elsif Or_Res11 /= null and then not Is_Ghost (Or_Res11) then
            Transform_Res27.Last_Attempted_Child := -1;
         end if;
         if Defer_Res39 /= null and then Is_Incomplete (Defer_Res39) then
            Transform_Res27.Last_Attempted_Child := 0;
         elsif Defer_Res39 /= null and then not Is_Ghost (Defer_Res39) then
            Transform_Res27.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos32 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags27);
end if;

--  END <Transform(<CompiledType BareArrayTypeDef>) at parser.lkt:65:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Array_Type_Def_Transform_Parse2_Memo,
      Row_Pos32 /= No_Token_Index,
      Transform_Res27,
      Pos,
      Row_Pos32);


   Parser.Current_Pos := Row_Pos32;

   return Transform_Res27;
end Array_Type_Def_Transform_Parse2;

   


function Aspect_Assoc_Or_Parse2
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Assoc
is
   use Bare_Aspect_Assoc_Memos;

      Row_Pos35 :
            Token_Index
               := No_Token_Index;
      Row_Pos36 :
            Token_Index
               := No_Token_Index;
      Token_Pos43 :
            Token_Index
               := No_Token_Index;
      Token_Res43 :
            Token_Index
               := No_Token_Index;
      Transform_Res28 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Transform_Diags28 :
            Ada.Containers.Count_Type;
      Row_Pos37 :
            Token_Index
               := No_Token_Index;
      Token_Pos44 :
            Token_Index
               := No_Token_Index;
      Token_Res44 :
            Token_Index
               := No_Token_Index;
      Defer_Pos40 :
            Token_Index
               := No_Token_Index;
      Defer_Res40 :
            Bare_Null_Literal
               := No_Bare_Ada_Node;
      Row_Pos38 :
            Token_Index
               := No_Token_Index;
      Defer_Pos41 :
            Token_Index
               := No_Token_Index;
      Defer_Res41 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Transform_Res29 :
            Bare_Abstract_State_Decl_Expr
               := No_Bare_Ada_Node;
      Transform_Diags29 :
            Ada.Containers.Count_Type;
      Or_Pos12 :
            Token_Index
               := No_Token_Index;
      Or_Res12 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res30 :
            Bare_Aspect_Assoc
               := No_Bare_Ada_Node;
      Transform_Diags30 :
            Ada.Containers.Count_Type;
      Row_Pos39 :
            Token_Index
               := No_Token_Index;
      Defer_Pos42 :
            Token_Index
               := No_Token_Index;
      Defer_Res42 :
            Bare_Name
               := No_Bare_Ada_Node;
      Row_Pos40 :
            Token_Index
               := No_Token_Index;
      Token_Pos45 :
            Token_Index
               := No_Token_Index;
      Token_Res45 :
            Token_Index
               := No_Token_Index;
      Defer_Pos43 :
            Token_Index
               := No_Token_Index;
      Defer_Res43 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos44 :
            Token_Index
               := No_Token_Index;
      Defer_Res44 :
            Bare_Contract_Cases
               := No_Bare_Ada_Node;
      Or_Pos13 :
            Token_Index
               := No_Token_Index;
      Or_Res13 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res31 :
            Bare_Aspect_Assoc
               := No_Bare_Ada_Node;
      Transform_Diags31 :
            Ada.Containers.Count_Type;
      Or_Pos14 :
            Token_Index
               := No_Token_Index;
      Or_Res14 :
            Bare_Aspect_Assoc
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Aspect_Assoc_Or_Parse2_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res14 := M.Instance;
      return Or_Res14;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res14;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:466:21>

Or_Pos14 := No_Token_Index;
Or_Res14 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareAspectAssoc>) at parser.lkt:467:11>

Transform_Diags30 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos35 := Pos;



--  BEGIN <Transform(<CompiledType BareIdentifier>) at parser.lkt:468:13>

Transform_Diags28 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos36 := Row_Pos35;



--  BEGIN <Token(<WithSymbol Identifier>, Abstract_State) at parser.lkt:468:24>

Token_Res43 := Row_Pos36;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res43));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Abstract_State)
   then
       Token_Pos43 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos36 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos36,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos43 := Row_Pos36 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, Abstract_State) at parser.lkt:468:24>




if Token_Pos43 /= No_Token_Index then

   Row_Pos36 := Token_Pos43;

else
   Row_Pos36 := No_Token_Index;
   goto Exit_Row36_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row36_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos36 /= No_Token_Index then

   Transform_Res28 := Allocate_Identifier (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res28,
      Kind => Ada_Identifier,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos35,
      Token_End_Index   => (if Row_Pos36 = Row_Pos35
                            then No_Token_Index
                            else Row_Pos36 - 1));

      
      Initialize_Fields_For_Identifier
        (Self => Transform_Res28);



elsif Row_Pos36 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags28);
end if;

--  END <Transform(<CompiledType BareIdentifier>) at parser.lkt:468:13>




if Row_Pos36 /= No_Token_Index then

   Row_Pos35 := Row_Pos36;

else
   Row_Pos35 := No_Token_Index;
   goto Exit_Row35_0;

end if;


--  BEGIN <Opt at parser.lkt:469:13>












--  BEGIN <_Extract at parser.lkt:469:14>

--  BEGIN <_Row at ???>

Row_Pos37 := Row_Pos35;



--  BEGIN <Token(<WithText Arrow>, ) at parser.lkt:470:17>

Token_Res44 := Row_Pos37;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res44));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos44 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos37 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos37,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos44 := Row_Pos37 + 1;
   end if;
end;

--  END <Token(<WithText Arrow>, ) at parser.lkt:470:17>




if Token_Pos44 /= No_Token_Index then

   Row_Pos37 := Token_Pos44;

else
   Row_Pos37 := No_Token_Index;
   goto Exit_Row37_0;

end if;


--  BEGIN <Or at parser.lkt:471:17>

Or_Pos12 := No_Token_Index;
Or_Res12 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:472:23>

Defer_Res40 :=
   Null_Literal_Transform_Parse0 (Parser, Row_Pos37);
Defer_Pos40 := Parser.Current_Pos;

--  END <Defer at parser.lkt:472:23>

    if Defer_Pos40 /= No_Token_Index then
        Or_Pos12 := Defer_Pos40;
        Or_Res12 := Defer_Res40;
        goto Exit_Or13;
    end if;
    
--  BEGIN <Transform(<CompiledType BareAbstractStateDeclExpr>) at parser.lkt:473:23>

Transform_Diags29 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos38 := Row_Pos37;



--  BEGIN <Defer at parser.lkt:473:45>

Defer_Res41 :=
   Multi_Abstract_State_Decl_Or_Parse0 (Parser, Row_Pos38);
Defer_Pos41 := Parser.Current_Pos;

--  END <Defer at parser.lkt:473:45>




if Defer_Pos41 /= No_Token_Index then

   Row_Pos38 := Defer_Pos41;

else
   Row_Pos38 := No_Token_Index;
   goto Exit_Row38_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row38_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos38 /= No_Token_Index then

   Transform_Res29 := Allocate_Abstract_State_Decl_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res29,
      Kind => Ada_Abstract_State_Decl_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos37,
      Token_End_Index   => (if Row_Pos38 = Row_Pos37
                            then No_Token_Index
                            else Row_Pos38 - 1));

      
      Initialize_Fields_For_Abstract_State_Decl_Expr
        (Self => Transform_Res29,
         Abstract_State_Decl_Expr_F_State_Decl => Defer_Res41);

         if Defer_Res41 /= null and then Is_Incomplete (Defer_Res41) then
            Transform_Res29.Last_Attempted_Child := 0;
         elsif Defer_Res41 /= null and then not Is_Ghost (Defer_Res41) then
            Transform_Res29.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos38 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags29);
end if;

--  END <Transform(<CompiledType BareAbstractStateDeclExpr>) at parser.lkt:473:23>

    if Row_Pos38 /= No_Token_Index then
        Or_Pos12 := Row_Pos38;
        Or_Res12 := Transform_Res29;
        goto Exit_Or13;
    end if;
<<Exit_Or13>>

--  END <Or at parser.lkt:471:17>




if Or_Pos12 /= No_Token_Index then

   Row_Pos37 := Or_Pos12;

else
   Row_Pos37 := No_Token_Index;
   goto Exit_Row37_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row37_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:469:14>


if Row_Pos37 = No_Token_Index then

         
   Or_Res12 := No_Bare_Ada_Node;



       
   Row_Pos37 := Row_Pos35;



end if;

--  END <Opt at parser.lkt:469:13>




if Row_Pos37 /= No_Token_Index then

   Row_Pos35 := Row_Pos37;

else
   Row_Pos35 := No_Token_Index;
   goto Exit_Row35_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row35_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos35 /= No_Token_Index then

   Transform_Res30 := Allocate_Aspect_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res30,
      Kind => Ada_Aspect_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos35 = Pos
                            then No_Token_Index
                            else Row_Pos35 - 1));

      
      Initialize_Fields_For_Aspect_Assoc
        (Self => Transform_Res30,
         Aspect_Assoc_F_Id => Transform_Res28,
         Aspect_Assoc_F_Expr => Or_Res12);

         if Transform_Res28 /= null and then Is_Incomplete (Transform_Res28) then
            Transform_Res30.Last_Attempted_Child := 0;
         elsif Transform_Res28 /= null and then not Is_Ghost (Transform_Res28) then
            Transform_Res30.Last_Attempted_Child := -1;
         end if;
         if Or_Res12 /= null and then Is_Incomplete (Or_Res12) then
            Transform_Res30.Last_Attempted_Child := 0;
         elsif Or_Res12 /= null and then not Is_Ghost (Or_Res12) then
            Transform_Res30.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos35 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags30);
end if;

--  END <Transform(<CompiledType BareAspectAssoc>) at parser.lkt:467:11>

    if Row_Pos35 /= No_Token_Index then
        Or_Pos14 := Row_Pos35;
        Or_Res14 := Transform_Res30;
        goto Exit_Or12;
    end if;
    
--  BEGIN <Transform(<CompiledType BareAspectAssoc>) at parser.lkt:477:11>

Transform_Diags31 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos39 := Pos;



--  BEGIN <Defer at parser.lkt:477:23>

Defer_Res42 :=
   Name_Or_Parse2 (Parser, Row_Pos39);
Defer_Pos42 := Parser.Current_Pos;

--  END <Defer at parser.lkt:477:23>




if Defer_Pos42 /= No_Token_Index then

   Row_Pos39 := Defer_Pos42;

else
   Row_Pos39 := No_Token_Index;
   goto Exit_Row39_0;

end if;


--  BEGIN <Opt at parser.lkt:477:28>












--  BEGIN <_Extract at parser.lkt:477:29>

--  BEGIN <_Row at ???>

Row_Pos40 := Row_Pos39;



--  BEGIN <Token(<WithText Arrow>, ) at parser.lkt:477:34>

Token_Res45 := Row_Pos40;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res45));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos45 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos40 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos40,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos45 := Row_Pos40 + 1;
   end if;
end;

--  END <Token(<WithText Arrow>, ) at parser.lkt:477:34>




if Token_Pos45 /= No_Token_Index then

   Row_Pos40 := Token_Pos45;

else
   Row_Pos40 := No_Token_Index;
   goto Exit_Row40_0;

end if;


--  BEGIN <Or at parser.lkt:477:39>

Or_Pos13 := No_Token_Index;
Or_Res13 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:477:42>

Defer_Res43 :=
   Expr_Or_Parse0 (Parser, Row_Pos40);
Defer_Pos43 := Parser.Current_Pos;

--  END <Defer at parser.lkt:477:42>

    if Defer_Pos43 /= No_Token_Index then
        Or_Pos13 := Defer_Pos43;
        Or_Res13 := Defer_Res43;
        goto Exit_Or14;
    end if;
    
--  BEGIN <Defer at parser.lkt:477:49>

Defer_Res44 :=
   Contract_Cases_Expr_Transform_Parse0 (Parser, Row_Pos40);
Defer_Pos44 := Parser.Current_Pos;

--  END <Defer at parser.lkt:477:49>

    if Defer_Pos44 /= No_Token_Index then
        Or_Pos13 := Defer_Pos44;
        Or_Res13 := Defer_Res44;
        goto Exit_Or14;
    end if;
<<Exit_Or14>>

--  END <Or at parser.lkt:477:39>




if Or_Pos13 /= No_Token_Index then

   Row_Pos40 := Or_Pos13;

else
   Row_Pos40 := No_Token_Index;
   goto Exit_Row40_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row40_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:477:29>


if Row_Pos40 = No_Token_Index then

         
   Or_Res13 := No_Bare_Ada_Node;



       
   Row_Pos40 := Row_Pos39;



end if;

--  END <Opt at parser.lkt:477:28>




if Row_Pos40 /= No_Token_Index then

   Row_Pos39 := Row_Pos40;

else
   Row_Pos39 := No_Token_Index;
   goto Exit_Row39_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row39_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos39 /= No_Token_Index then

   Transform_Res31 := Allocate_Aspect_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res31,
      Kind => Ada_Aspect_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos39 = Pos
                            then No_Token_Index
                            else Row_Pos39 - 1));

      
      Initialize_Fields_For_Aspect_Assoc
        (Self => Transform_Res31,
         Aspect_Assoc_F_Id => Defer_Res42,
         Aspect_Assoc_F_Expr => Or_Res13);

         if Defer_Res42 /= null and then Is_Incomplete (Defer_Res42) then
            Transform_Res31.Last_Attempted_Child := 0;
         elsif Defer_Res42 /= null and then not Is_Ghost (Defer_Res42) then
            Transform_Res31.Last_Attempted_Child := -1;
         end if;
         if Or_Res13 /= null and then Is_Incomplete (Or_Res13) then
            Transform_Res31.Last_Attempted_Child := 0;
         elsif Or_Res13 /= null and then not Is_Ghost (Or_Res13) then
            Transform_Res31.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos39 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags31);
end if;

--  END <Transform(<CompiledType BareAspectAssoc>) at parser.lkt:477:11>

    if Row_Pos39 /= No_Token_Index then
        Or_Pos14 := Row_Pos39;
        Or_Res14 := Transform_Res31;
        goto Exit_Or12;
    end if;
<<Exit_Or12>>

--  END <Or at parser.lkt:466:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Aspect_Assoc_Or_Parse2_Memo,
      Or_Pos14 /= No_Token_Index,
      Or_Res14,
      Pos,
      Or_Pos14);


   Parser.Current_Pos := Or_Pos14;

   return Or_Res14;
end Aspect_Assoc_Or_Parse2;

   


function Aspect_Clause_Or_Parse1
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Clause
is
   use Bare_Aspect_Clause_Memos;

      Nobt2 :
            Boolean
               := False;
      Nobt3 :
            Boolean
               := False;
      Row_Pos41 :
            Token_Index
               := No_Token_Index;
      Token_Pos46 :
            Token_Index
               := No_Token_Index;
      Token_Res46 :
            Token_Index
               := No_Token_Index;
      Defer_Pos45 :
            Token_Index
               := No_Token_Index;
      Defer_Res45 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos47 :
            Token_Index
               := No_Token_Index;
      Token_Res47 :
            Token_Index
               := No_Token_Index;
      Defer_Pos46 :
            Token_Index
               := No_Token_Index;
      Defer_Res46 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;
      Token_Pos48 :
            Token_Index
               := No_Token_Index;
      Token_Res48 :
            Token_Index
               := No_Token_Index;
      Row_Progress2 :
            Integer
               := 0;
      Transform_Res32 :
            Bare_Enum_Rep_Clause
               := No_Bare_Ada_Node;
      Transform_Has_Failed2 :
            Boolean
               := False;
      Transform_Diags32 :
            Ada.Containers.Count_Type;
      Row_Pos42 :
            Token_Index
               := No_Token_Index;
      Token_Pos49 :
            Token_Index
               := No_Token_Index;
      Token_Res49 :
            Token_Index
               := No_Token_Index;
      Defer_Pos47 :
            Token_Index
               := No_Token_Index;
      Defer_Res47 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos50 :
            Token_Index
               := No_Token_Index;
      Token_Res50 :
            Token_Index
               := No_Token_Index;
      Token_Pos51 :
            Token_Index
               := No_Token_Index;
      Token_Res51 :
            Token_Index
               := No_Token_Index;
      Row_Pos43 :
            Token_Index
               := No_Token_Index;
      Token_Pos52 :
            Token_Index
               := No_Token_Index;
      Token_Res52 :
            Token_Index
               := No_Token_Index;
      Token_Pos53 :
            Token_Index
               := No_Token_Index;
      Token_Res53 :
            Token_Index
               := No_Token_Index;
      Defer_Pos48 :
            Token_Index
               := No_Token_Index;
      Defer_Res48 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos54 :
            Token_Index
               := No_Token_Index;
      Token_Res54 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos2 :
            Token_Index
               := No_Token_Index;
      Tmp_List2 :
            Free_Parse_List;
      Defer_Pos49 :
            Token_Index
               := No_Token_Index;
      Defer_Res49 :
            Bare_Component_Clause
               := No_Bare_Ada_Node;
      Defer_Pos50 :
            Token_Index
               := No_Token_Index;
      Defer_Res50 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      Or_Pos15 :
            Token_Index
               := No_Token_Index;
      Or_Res15 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      List_Pos2 :
            Token_Index
               := No_Token_Index;
      List_Res2 :
            Bare_Ada_Node_List
               := No_Bare_Ada_Node;
      Token_Pos55 :
            Token_Index
               := No_Token_Index;
      Token_Res55 :
            Token_Index
               := No_Token_Index;
      Token_Pos56 :
            Token_Index
               := No_Token_Index;
      Token_Res56 :
            Token_Index
               := No_Token_Index;
      Token_Pos57 :
            Token_Index
               := No_Token_Index;
      Token_Res57 :
            Token_Index
               := No_Token_Index;
      Transform_Res33 :
            Bare_Record_Rep_Clause
               := No_Bare_Ada_Node;
      Transform_Diags33 :
            Ada.Containers.Count_Type;
      Row_Pos44 :
            Token_Index
               := No_Token_Index;
      Token_Pos58 :
            Token_Index
               := No_Token_Index;
      Token_Res58 :
            Token_Index
               := No_Token_Index;
      Defer_Pos51 :
            Token_Index
               := No_Token_Index;
      Defer_Res51 :
            Bare_Base_Id
               := No_Bare_Ada_Node;
      Token_Pos59 :
            Token_Index
               := No_Token_Index;
      Token_Res59 :
            Token_Index
               := No_Token_Index;
      Token_Pos60 :
            Token_Index
               := No_Token_Index;
      Token_Res60 :
            Token_Index
               := No_Token_Index;
      Defer_Pos52 :
            Token_Index
               := No_Token_Index;
      Defer_Res52 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos61 :
            Token_Index
               := No_Token_Index;
      Token_Res61 :
            Token_Index
               := No_Token_Index;
      Transform_Res34 :
            Bare_At_Clause
               := No_Bare_Ada_Node;
      Transform_Diags34 :
            Ada.Containers.Count_Type;
      Row_Pos45 :
            Token_Index
               := No_Token_Index;
      Token_Pos62 :
            Token_Index
               := No_Token_Index;
      Token_Res62 :
            Token_Index
               := No_Token_Index;
      Defer_Pos53 :
            Token_Index
               := No_Token_Index;
      Defer_Res53 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos63 :
            Token_Index
               := No_Token_Index;
      Token_Res63 :
            Token_Index
               := No_Token_Index;
      Defer_Pos54 :
            Token_Index
               := No_Token_Index;
      Defer_Res54 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos64 :
            Token_Index
               := No_Token_Index;
      Token_Res64 :
            Token_Index
               := No_Token_Index;
      Row_Progress3 :
            Integer
               := 0;
      Transform_Res35 :
            Bare_Attribute_Def_Clause
               := No_Bare_Ada_Node;
      Transform_Has_Failed3 :
            Boolean
               := False;
      Transform_Diags35 :
            Ada.Containers.Count_Type;
      Or_Pos16 :
            Token_Index
               := No_Token_Index;
      Or_Res16 :
            Bare_Aspect_Clause
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Aspect_Clause_Or_Parse1_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res16 := M.Instance;
      return Or_Res16;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res16;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:515:22>

Or_Pos16 := No_Token_Index;
Or_Res16 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareEnumRepClause>) at parser.lkt:516:11>

Transform_Diags32 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos41 := Pos;



--  BEGIN <Token(<WithText For>, ) at parser.lkt:516:25>

Token_Res46 := Row_Pos41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res46));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos46 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos41,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos46 := Row_Pos41 + 1;
   end if;
end;

--  END <Token(<WithText For>, ) at parser.lkt:516:25>



Row_Progress2 := 1;

if Token_Pos46 /= No_Token_Index then

   Row_Pos41 := Token_Pos46;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Defer at parser.lkt:516:31>

Defer_Res45 :=
   Static_Name_Or_Parse0 (Parser, Row_Pos41);
Defer_Pos45 := Parser.Current_Pos;

--  END <Defer at parser.lkt:516:31>



Row_Progress2 := 2;

if Defer_Pos45 /= No_Token_Index then

   Row_Pos41 := Defer_Pos45;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Token(<WithText Use>, ) at parser.lkt:516:43>

Token_Res47 := Row_Pos41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res47));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Use)
   then
       Token_Pos47 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos41,
             Expected_Token_Id => Ada_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos47 := Row_Pos41 + 1;
   end if;
end;

--  END <Token(<WithText Use>, ) at parser.lkt:516:43>



Row_Progress2 := 3;

if Token_Pos47 /= No_Token_Index then

   Row_Pos41 := Token_Pos47;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Defer at parser.lkt:516:49>

Defer_Res46 :=
   Regular_Aggregate_Or_Parse0 (Parser, Row_Pos41);
Defer_Pos46 := Parser.Current_Pos;

--  END <Defer at parser.lkt:516:49>



Row_Progress2 := 4;

if Defer_Pos46 /= No_Token_Index then

   Row_Pos41 := Defer_Pos46;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Cut at ???>
Nobt2 := True;
--  END <Cut at ???>


   Nobt2 := Nobt2;

Row_Progress2 := 5;

if Row_Pos41 /= No_Token_Index then

   Row_Pos41 := Row_Pos41;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;


--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:516:69>

Token_Res48 := Row_Pos41;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res48));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos48 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos41 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos41,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos48 := Row_Pos41 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:516:69>



Row_Progress2 := 6;

if Token_Pos48 /= No_Token_Index then

   Row_Pos41 := Token_Pos48;

else
   Row_Pos41 := No_Token_Index;
   goto Exit_Row41_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row41_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos41 = No_Token_Index and then Nobt2 then

   Row_Pos41 := Parser.Last_Fail.Pos;

   Transform_Has_Failed2 := True;
end if;

if Row_Pos41 /= No_Token_Index then

   Transform_Res32 := Allocate_Enum_Rep_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res32,
      Kind => Ada_Enum_Rep_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos41 = Pos
                            then No_Token_Index
                            else Row_Pos41 - 1));

      
      Initialize_Fields_For_Enum_Rep_Clause
        (Self => Transform_Res32,
         Enum_Rep_Clause_F_Type_Name => Defer_Res45,
         Enum_Rep_Clause_F_Aggregate => Defer_Res46);

         if Defer_Res45 /= null and then Is_Incomplete (Defer_Res45) then
            Transform_Res32.Last_Attempted_Child := 0;
         elsif Defer_Res45 /= null and then not Is_Ghost (Defer_Res45) then
            Transform_Res32.Last_Attempted_Child := -1;
         end if;
         if Defer_Res46 /= null and then Is_Incomplete (Defer_Res46) then
            Transform_Res32.Last_Attempted_Child := 0;
         elsif Defer_Res46 /= null and then not Is_Ghost (Defer_Res46) then
            Transform_Res32.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed2 then
      Transform_Res32.Last_Attempted_Child :=
         Row_Progress2;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <aspect_clause>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos41 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags32);
end if;

--  END <Transform(<CompiledType BareEnumRepClause>) at parser.lkt:516:11>

    if Row_Pos41 /= No_Token_Index then
        Or_Pos16 := Row_Pos41;
        Or_Res16 := Transform_Res32;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<CompiledType BareRecordRepClause>) at parser.lkt:517:11>

Transform_Diags33 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos42 := Pos;



--  BEGIN <Token(<WithText For>, ) at parser.lkt:518:13>

Token_Res49 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res49));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos49 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos49 := Row_Pos42 + 1;
   end if;
end;

--  END <Token(<WithText For>, ) at parser.lkt:518:13>




if Token_Pos49 /= No_Token_Index then

   Row_Pos42 := Token_Pos49;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Defer at parser.lkt:519:13>

Defer_Res47 :=
   Static_Name_Or_Parse0 (Parser, Row_Pos42);
Defer_Pos47 := Parser.Current_Pos;

--  END <Defer at parser.lkt:519:13>




if Defer_Pos47 /= No_Token_Index then

   Row_Pos42 := Defer_Pos47;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Token(<WithText Use>, ) at parser.lkt:520:13>

Token_Res50 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res50));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Use)
   then
       Token_Pos50 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Ada_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos50 := Row_Pos42 + 1;
   end if;
end;

--  END <Token(<WithText Use>, ) at parser.lkt:520:13>




if Token_Pos50 /= No_Token_Index then

   Row_Pos42 := Token_Pos50;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Token(<WithText Record>, ) at parser.lkt:521:13>

Token_Res51 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res51));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Record)
   then
       Token_Pos51 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Ada_Record,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos51 := Row_Pos42 + 1;
   end if;
end;

--  END <Token(<WithText Record>, ) at parser.lkt:521:13>




if Token_Pos51 /= No_Token_Index then

   Row_Pos42 := Token_Pos51;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Opt at parser.lkt:522:13>












--  BEGIN <_Extract at parser.lkt:522:14>

--  BEGIN <_Row at ???>

Row_Pos43 := Row_Pos42;



--  BEGIN <Token(<WithText At>, ) at parser.lkt:522:19>

Token_Res52 := Row_Pos43;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res52));
begin
   if
      T.Kind /= From_Token_Kind (Ada_At)
   then
       Token_Pos52 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos43 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos43,
             Expected_Token_Id => Ada_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos52 := Row_Pos43 + 1;
   end if;
end;

--  END <Token(<WithText At>, ) at parser.lkt:522:19>




if Token_Pos52 /= No_Token_Index then

   Row_Pos43 := Token_Pos52;

else
   Row_Pos43 := No_Token_Index;
   goto Exit_Row43_0;

end if;


--  BEGIN <Token(<WithText Mod>, ) at parser.lkt:522:24>

Token_Res53 := Row_Pos43;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res53));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Mod)
   then
       Token_Pos53 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos43 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos43,
             Expected_Token_Id => Ada_Mod,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos53 := Row_Pos43 + 1;
   end if;
end;

--  END <Token(<WithText Mod>, ) at parser.lkt:522:24>




if Token_Pos53 /= No_Token_Index then

   Row_Pos43 := Token_Pos53;

else
   Row_Pos43 := No_Token_Index;
   goto Exit_Row43_0;

end if;


--  BEGIN <Defer at parser.lkt:522:30>

Defer_Res48 :=
   Simple_Expr_Or_Parse0 (Parser, Row_Pos43);
Defer_Pos48 := Parser.Current_Pos;

--  END <Defer at parser.lkt:522:30>




if Defer_Pos48 /= No_Token_Index then

   Row_Pos43 := Defer_Pos48;

else
   Row_Pos43 := No_Token_Index;
   goto Exit_Row43_0;

end if;


--  BEGIN <Opt at parser.lkt:522:42>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:522:43>

Token_Res54 := Row_Pos43;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res54));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos54 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos43 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos43,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos54 := Row_Pos43 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:522:43>


if Token_Pos54 = No_Token_Index then

         
   Token_Res54 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos43)),
                To_Text ("Missing ';'"));

       
   Token_Pos54 := Row_Pos43;



end if;

--  END <Opt at parser.lkt:522:42>




if Token_Pos54 /= No_Token_Index then

   Row_Pos43 := Token_Pos54;

else
   Row_Pos43 := No_Token_Index;
   goto Exit_Row43_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row43_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:522:14>


if Row_Pos43 = No_Token_Index then

         
   Defer_Res48 := No_Bare_Ada_Node;



       
   Row_Pos43 := Row_Pos42;



end if;

--  END <Opt at parser.lkt:522:13>




if Row_Pos43 /= No_Token_Index then

   Row_Pos42 := Row_Pos43;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <List at parser.lkt:523:13>

    List_Pos2 := Row_Pos42;



Lst_Cpos2 := Row_Pos42;
Tmp_List2 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Or at parser.lkt:523:19>

Or_Pos15 := No_Token_Index;
Or_Res15 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:523:22>

Defer_Res49 :=
   Component_Clause_Transform_Parse0 (Parser, Lst_Cpos2);
Defer_Pos49 := Parser.Current_Pos;

--  END <Defer at parser.lkt:523:22>

    if Defer_Pos49 /= No_Token_Index then
        Or_Pos15 := Defer_Pos49;
        Or_Res15 := Defer_Res49;
        goto Exit_Or16;
    end if;
    
--  BEGIN <Defer at parser.lkt:523:41>

Defer_Res50 :=
   Pragma_Transform_Parse0 (Parser, Lst_Cpos2);
Defer_Pos50 := Parser.Current_Pos;

--  END <Defer at parser.lkt:523:41>

    if Defer_Pos50 /= No_Token_Index then
        Or_Pos15 := Defer_Pos50;
        Or_Res15 := Defer_Res50;
        goto Exit_Or16;
    end if;
<<Exit_Or16>>

--  END <Or at parser.lkt:523:19>


   exit when Or_Pos15 = No_Token_Index;

   List_Pos2 := Or_Pos15;
   Lst_Cpos2 := List_Pos2;

   Tmp_List2.Nodes.Append (Or_Res15);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List2.Nodes.Length;
begin
   List_Res2 := Allocate_Ada_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos42;
      Token_End := (if Lst_Cpos2 = Row_Pos42
                    then Row_Pos42
                    else List_Pos2 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos42, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res2,
      Kind              => Ada_Ada_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res2,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List2.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res2.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List2);

--  END <List at parser.lkt:523:13>




if List_Pos2 /= No_Token_Index then

   Row_Pos42 := List_Pos2;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Token(<WithText End>, ) at parser.lkt:524:13>

Token_Res55 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res55));
begin
   if
      T.Kind /= From_Token_Kind (Ada_End)
   then
       Token_Pos55 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Ada_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos55 := Row_Pos42 + 1;
   end if;
end;

--  END <Token(<WithText End>, ) at parser.lkt:524:13>




if Token_Pos55 /= No_Token_Index then

   Row_Pos42 := Token_Pos55;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Token(<WithText Record>, ) at parser.lkt:525:13>

Token_Res56 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res56));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Record)
   then
       Token_Pos56 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Ada_Record,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos56 := Row_Pos42 + 1;
   end if;
end;

--  END <Token(<WithText Record>, ) at parser.lkt:525:13>




if Token_Pos56 /= No_Token_Index then

   Row_Pos42 := Token_Pos56;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;


--  BEGIN <Opt at parser.lkt:526:13>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:526:14>

Token_Res57 := Row_Pos42;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res57));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos57 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos42 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos42,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos57 := Row_Pos42 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:526:14>


if Token_Pos57 = No_Token_Index then

         
   Token_Res57 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos42)),
                To_Text ("Missing ';'"));

       
   Token_Pos57 := Row_Pos42;



end if;

--  END <Opt at parser.lkt:526:13>




if Token_Pos57 /= No_Token_Index then

   Row_Pos42 := Token_Pos57;

else
   Row_Pos42 := No_Token_Index;
   goto Exit_Row42_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row42_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos42 /= No_Token_Index then

   Transform_Res33 := Allocate_Record_Rep_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res33,
      Kind => Ada_Record_Rep_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos42 = Pos
                            then No_Token_Index
                            else Row_Pos42 - 1));

      
      Initialize_Fields_For_Record_Rep_Clause
        (Self => Transform_Res33,
         Record_Rep_Clause_F_Name => Defer_Res47,
         Record_Rep_Clause_F_At_Expr => Defer_Res48,
         Record_Rep_Clause_F_Components => List_Res2);

         if Defer_Res47 /= null and then Is_Incomplete (Defer_Res47) then
            Transform_Res33.Last_Attempted_Child := 0;
         elsif Defer_Res47 /= null and then not Is_Ghost (Defer_Res47) then
            Transform_Res33.Last_Attempted_Child := -1;
         end if;
         if Defer_Res48 /= null and then Is_Incomplete (Defer_Res48) then
            Transform_Res33.Last_Attempted_Child := 0;
         elsif Defer_Res48 /= null and then not Is_Ghost (Defer_Res48) then
            Transform_Res33.Last_Attempted_Child := -1;
         end if;
         if List_Res2 /= null and then Is_Incomplete (List_Res2) then
            Transform_Res33.Last_Attempted_Child := 0;
         elsif List_Res2 /= null and then not Is_Ghost (List_Res2) then
            Transform_Res33.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos42 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags33);
end if;

--  END <Transform(<CompiledType BareRecordRepClause>) at parser.lkt:517:11>

    if Row_Pos42 /= No_Token_Index then
        Or_Pos16 := Row_Pos42;
        Or_Res16 := Transform_Res33;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<CompiledType BareAtClause>) at parser.lkt:528:11>

Transform_Diags34 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos44 := Pos;



--  BEGIN <Token(<WithText For>, ) at parser.lkt:528:20>

Token_Res58 := Row_Pos44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res58));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos58 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos44,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos58 := Row_Pos44 + 1;
   end if;
end;

--  END <Token(<WithText For>, ) at parser.lkt:528:20>




if Token_Pos58 /= No_Token_Index then

   Row_Pos44 := Token_Pos58;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;


--  BEGIN <Defer at parser.lkt:528:26>

Defer_Res51 :=
   Direct_Name_Or_Parse0 (Parser, Row_Pos44);
Defer_Pos51 := Parser.Current_Pos;

--  END <Defer at parser.lkt:528:26>




if Defer_Pos51 /= No_Token_Index then

   Row_Pos44 := Defer_Pos51;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;


--  BEGIN <Token(<WithText Use>, ) at parser.lkt:528:38>

Token_Res59 := Row_Pos44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res59));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Use)
   then
       Token_Pos59 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos44,
             Expected_Token_Id => Ada_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos59 := Row_Pos44 + 1;
   end if;
end;

--  END <Token(<WithText Use>, ) at parser.lkt:528:38>




if Token_Pos59 /= No_Token_Index then

   Row_Pos44 := Token_Pos59;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;


--  BEGIN <Token(<WithText At>, ) at parser.lkt:528:44>

Token_Res60 := Row_Pos44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res60));
begin
   if
      T.Kind /= From_Token_Kind (Ada_At)
   then
       Token_Pos60 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos44,
             Expected_Token_Id => Ada_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos60 := Row_Pos44 + 1;
   end if;
end;

--  END <Token(<WithText At>, ) at parser.lkt:528:44>




if Token_Pos60 /= No_Token_Index then

   Row_Pos44 := Token_Pos60;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;


--  BEGIN <Defer at parser.lkt:528:49>

Defer_Res52 :=
   Expr_Or_Parse0 (Parser, Row_Pos44);
Defer_Pos52 := Parser.Current_Pos;

--  END <Defer at parser.lkt:528:49>




if Defer_Pos52 /= No_Token_Index then

   Row_Pos44 := Defer_Pos52;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;


--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:528:54>

Token_Res61 := Row_Pos44;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res61));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos61 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos44 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos44,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos61 := Row_Pos44 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:528:54>




if Token_Pos61 /= No_Token_Index then

   Row_Pos44 := Token_Pos61;

else
   Row_Pos44 := No_Token_Index;
   goto Exit_Row44_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row44_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos44 /= No_Token_Index then

   Transform_Res34 := Allocate_At_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res34,
      Kind => Ada_At_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos44 = Pos
                            then No_Token_Index
                            else Row_Pos44 - 1));

      
      Initialize_Fields_For_At_Clause
        (Self => Transform_Res34,
         At_Clause_F_Name => Defer_Res51,
         At_Clause_F_Expr => Defer_Res52);

         if Defer_Res51 /= null and then Is_Incomplete (Defer_Res51) then
            Transform_Res34.Last_Attempted_Child := 0;
         elsif Defer_Res51 /= null and then not Is_Ghost (Defer_Res51) then
            Transform_Res34.Last_Attempted_Child := -1;
         end if;
         if Defer_Res52 /= null and then Is_Incomplete (Defer_Res52) then
            Transform_Res34.Last_Attempted_Child := 0;
         elsif Defer_Res52 /= null and then not Is_Ghost (Defer_Res52) then
            Transform_Res34.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos44 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags34);
end if;

--  END <Transform(<CompiledType BareAtClause>) at parser.lkt:528:11>

    if Row_Pos44 /= No_Token_Index then
        Or_Pos16 := Row_Pos44;
        Or_Res16 := Transform_Res34;
        goto Exit_Or15;
    end if;
    
--  BEGIN <Transform(<CompiledType BareAttributeDefClause>) at parser.lkt:531:11>

Transform_Diags35 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos45 := Pos;



--  BEGIN <Token(<WithText For>, ) at parser.lkt:531:30>

Token_Res62 := Row_Pos45;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res62));
begin
   if
      T.Kind /= From_Token_Kind (Ada_For)
   then
       Token_Pos62 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos45 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos45,
             Expected_Token_Id => Ada_For,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos62 := Row_Pos45 + 1;
   end if;
end;

--  END <Token(<WithText For>, ) at parser.lkt:531:30>



Row_Progress3 := 1;

if Token_Pos62 /= No_Token_Index then

   Row_Pos45 := Token_Pos62;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Defer at parser.lkt:531:36>

Defer_Res53 :=
   Name_Or_Parse2 (Parser, Row_Pos45);
Defer_Pos53 := Parser.Current_Pos;

--  END <Defer at parser.lkt:531:36>



Row_Progress3 := 2;

if Defer_Pos53 /= No_Token_Index then

   Row_Pos45 := Defer_Pos53;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Token(<WithText Use>, ) at parser.lkt:531:41>

Token_Res63 := Row_Pos45;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res63));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Use)
   then
       Token_Pos63 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos45 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos45,
             Expected_Token_Id => Ada_Use,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos63 := Row_Pos45 + 1;
   end if;
end;

--  END <Token(<WithText Use>, ) at parser.lkt:531:41>



Row_Progress3 := 3;

if Token_Pos63 /= No_Token_Index then

   Row_Pos45 := Token_Pos63;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Cut at ???>
Nobt3 := True;
--  END <Cut at ???>


   Nobt3 := Nobt3;

Row_Progress3 := 4;

if Row_Pos45 /= No_Token_Index then

   Row_Pos45 := Row_Pos45;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Defer at parser.lkt:531:49>

Defer_Res54 :=
   Expr_Or_Parse0 (Parser, Row_Pos45);
Defer_Pos54 := Parser.Current_Pos;

--  END <Defer at parser.lkt:531:49>



Row_Progress3 := 5;

if Defer_Pos54 /= No_Token_Index then

   Row_Pos45 := Defer_Pos54;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;


--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:531:54>

Token_Res64 := Row_Pos45;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res64));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos64 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos45 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos45,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos64 := Row_Pos45 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:531:54>



Row_Progress3 := 6;

if Token_Pos64 /= No_Token_Index then

   Row_Pos45 := Token_Pos64;

else
   Row_Pos45 := No_Token_Index;
   goto Exit_Row45_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row45_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos45 = No_Token_Index and then Nobt3 then

   Row_Pos45 := Parser.Last_Fail.Pos;

   Transform_Has_Failed3 := True;
end if;

if Row_Pos45 /= No_Token_Index then

   Transform_Res35 := Allocate_Attribute_Def_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res35,
      Kind => Ada_Attribute_Def_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos45 = Pos
                            then No_Token_Index
                            else Row_Pos45 - 1));

      
      Initialize_Fields_For_Attribute_Def_Clause
        (Self => Transform_Res35,
         Attribute_Def_Clause_F_Attribute_Expr => Defer_Res53,
         Attribute_Def_Clause_F_Expr => Defer_Res54);

         if Defer_Res53 /= null and then Is_Incomplete (Defer_Res53) then
            Transform_Res35.Last_Attempted_Child := 0;
         elsif Defer_Res53 /= null and then not Is_Ghost (Defer_Res53) then
            Transform_Res35.Last_Attempted_Child := -1;
         end if;
         if Defer_Res54 /= null and then Is_Incomplete (Defer_Res54) then
            Transform_Res35.Last_Attempted_Child := 0;
         elsif Defer_Res54 /= null and then not Is_Ghost (Defer_Res54) then
            Transform_Res35.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed3 then
      Transform_Res35.Last_Attempted_Child :=
         Row_Progress3;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <aspect_clause>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos45 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags35);
end if;

--  END <Transform(<CompiledType BareAttributeDefClause>) at parser.lkt:531:11>

    if Row_Pos45 /= No_Token_Index then
        Or_Pos16 := Row_Pos45;
        Or_Res16 := Transform_Res35;
        goto Exit_Or15;
    end if;
<<Exit_Or15>>

--  END <Or at parser.lkt:515:22>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Aspect_Clause_Or_Parse1_Memo,
      Or_Pos16 /= No_Token_Index,
      Or_Res16,
      Pos,
      Or_Pos16);


   Parser.Current_Pos := Or_Pos16;

   return Or_Res16;
end Aspect_Clause_Or_Parse1;

   


function Aspect_Spec_Opt_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Aspect_Spec
is
   use Bare_Aspect_Spec_Memos;

      Nobt4 :
            Boolean
               := False;
      Row_Pos46 :
            Token_Index
               := No_Token_Index;
      Token_Pos65 :
            Token_Index
               := No_Token_Index;
      Token_Res65 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos3 :
            Token_Index
               := No_Token_Index;
      Tmp_List3 :
            Free_Parse_List;
      Defer_Pos55 :
            Token_Index
               := No_Token_Index;
      Defer_Res55 :
            Bare_Aspect_Assoc
               := No_Bare_Ada_Node;
      Token_Pos66 :
            Token_Index
               := No_Token_Index;
      Token_Res66 :
            Token_Index
               := No_Token_Index;
      List_Pos3 :
            Token_Index
               := No_Token_Index;
      List_Res3 :
            Bare_Aspect_Assoc_List
               := No_Bare_Ada_Node;
      Row_Progress4 :
            Integer
               := 0;
      Transform_Res36 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Transform_Has_Failed4 :
            Boolean
               := False;
      Transform_Diags36 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Aspect_Spec_Opt_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res36 := M.Instance;
      return Transform_Res36;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res36;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Opt at parser.lkt:479:20>












--  BEGIN <Transform(<CompiledType BareAspectSpec>) at parser.lkt:479:21>

Transform_Diags36 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos46 := Pos;



--  BEGIN <Token(<WithText With>, ) at parser.lkt:479:32>

Token_Res65 := Row_Pos46;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res65));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos65 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos46 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos46,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos65 := Row_Pos46 + 1;
   end if;
end;

--  END <Token(<WithText With>, ) at parser.lkt:479:32>



Row_Progress4 := 1;

if Token_Pos65 /= No_Token_Index then

   Row_Pos46 := Token_Pos65;

else
   Row_Pos46 := No_Token_Index;
   goto Exit_Row46_0;

end if;


--  BEGIN <Cut at ???>
Nobt4 := True;
--  END <Cut at ???>


   Nobt4 := Nobt4;

Row_Progress4 := 2;

if Row_Pos46 /= No_Token_Index then

   Row_Pos46 := Row_Pos46;

else
   Row_Pos46 := No_Token_Index;
   goto Exit_Row46_0;

end if;


--  BEGIN <List at parser.lkt:479:41>

    List_Pos3 := No_Token_Index;



Lst_Cpos3 := Row_Pos46;
Tmp_List3 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:479:47>

Defer_Res55 :=
   Aspect_Assoc_Or_Parse2 (Parser, Lst_Cpos3);
Defer_Pos55 := Parser.Current_Pos;

--  END <Defer at parser.lkt:479:47>


   exit when Defer_Pos55 = No_Token_Index;

   List_Pos3 := Defer_Pos55;
   Lst_Cpos3 := List_Pos3;

   Tmp_List3.Nodes.Append (Defer_Res55);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:479:61>

Token_Res66 := Lst_Cpos3;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res66));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos66 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos3 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos3,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos66 := Lst_Cpos3 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:479:61>


      exit when Token_Pos66 = No_Token_Index;

      Lst_Cpos3 := Token_Pos66;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List3.Nodes.Length;
begin
   List_Res3 := Allocate_Aspect_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos46;
      Token_End := (if Lst_Cpos3 = Row_Pos46
                    then Row_Pos46
                    else List_Pos3 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos46, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res3,
      Kind              => Ada_Aspect_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res3,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List3.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res3.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List3);

--  END <List at parser.lkt:479:41>



Row_Progress4 := 3;

if List_Pos3 /= No_Token_Index then

   Row_Pos46 := List_Pos3;

else
   Row_Pos46 := No_Token_Index;
   goto Exit_Row46_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row46_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos46 = No_Token_Index and then Nobt4 then

   Row_Pos46 := Parser.Last_Fail.Pos;

   Transform_Has_Failed4 := True;
end if;

if Row_Pos46 /= No_Token_Index then

   Transform_Res36 := Allocate_Aspect_Spec (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res36,
      Kind => Ada_Aspect_Spec,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos46 = Pos
                            then No_Token_Index
                            else Row_Pos46 - 1));

      
      Initialize_Fields_For_Aspect_Spec
        (Self => Transform_Res36,
         Aspect_Spec_F_Aspect_Assocs => List_Res3);

         if List_Res3 /= null and then Is_Incomplete (List_Res3) then
            Transform_Res36.Last_Attempted_Child := 0;
         elsif List_Res3 /= null and then not Is_Ghost (List_Res3) then
            Transform_Res36.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed4 then
      Transform_Res36.Last_Attempted_Child :=
         Row_Progress4;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <aspect_spec>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos46 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags36);
end if;

--  END <Transform(<CompiledType BareAspectSpec>) at parser.lkt:479:21>


if Row_Pos46 = No_Token_Index then

         
   if Nobt4 then
      Row_Pos46 := Parser.Last_Fail.Pos;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Row_Pos46)),
              To_Text ("Cannot parse <aspect_spec>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;


         if not Nobt4 then
            
   Transform_Res36 := No_Bare_Ada_Node;

         end if;


       if not Nobt4 then
          
   Row_Pos46 := Pos;

       end if;


end if;

--  END <Opt at parser.lkt:479:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Aspect_Spec_Opt_Parse0_Memo,
      Row_Pos46 /= No_Token_Index,
      Transform_Res36,
      Pos,
      Row_Pos46);


   Parser.Current_Pos := Row_Pos46;

   return Transform_Res36;
end Aspect_Spec_Opt_Parse0;

   


function Assignment_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assign_Stmt
is
   use Bare_Assign_Stmt_Memos;

      Nobt5 :
            Boolean
               := False;
      Row_Pos47 :
            Token_Index
               := No_Token_Index;
      Defer_Pos56 :
            Token_Index
               := No_Token_Index;
      Defer_Res56 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos67 :
            Token_Index
               := No_Token_Index;
      Token_Res67 :
            Token_Index
               := No_Token_Index;
      Defer_Pos57 :
            Token_Index
               := No_Token_Index;
      Defer_Res57 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos68 :
            Token_Index
               := No_Token_Index;
      Token_Res68 :
            Token_Index
               := No_Token_Index;
      Row_Progress5 :
            Integer
               := 0;
      Transform_Res37 :
            Bare_Assign_Stmt
               := No_Bare_Ada_Node;
      Transform_Has_Failed5 :
            Boolean
               := False;
      Transform_Diags37 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Assignment_Stmt_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res37 := M.Instance;
      return Transform_Res37;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res37;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareAssignStmt>) at parser.lkt:1017:24>

Transform_Diags37 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos47 := Pos;



--  BEGIN <Defer at parser.lkt:1017:35>

Defer_Res56 :=
   Name_Or_Parse2 (Parser, Row_Pos47);
Defer_Pos56 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1017:35>



Row_Progress5 := 1;

if Defer_Pos56 /= No_Token_Index then

   Row_Pos47 := Defer_Pos56;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;


--  BEGIN <Token(<WithText Assign>, ) at parser.lkt:1017:40>

Token_Res67 := Row_Pos47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res67));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Assign)
   then
       Token_Pos67 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos47,
             Expected_Token_Id => Ada_Assign,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos67 := Row_Pos47 + 1;
   end if;
end;

--  END <Token(<WithText Assign>, ) at parser.lkt:1017:40>



Row_Progress5 := 2;

if Token_Pos67 /= No_Token_Index then

   Row_Pos47 := Token_Pos67;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;


--  BEGIN <Cut at ???>
Nobt5 := True;
--  END <Cut at ???>


   Nobt5 := Nobt5;

Row_Progress5 := 3;

if Row_Pos47 /= No_Token_Index then

   Row_Pos47 := Row_Pos47;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;


--  BEGIN <Defer at parser.lkt:1017:47>

Defer_Res57 :=
   Expr_Or_Parse0 (Parser, Row_Pos47);
Defer_Pos57 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1017:47>



Row_Progress5 := 4;

if Defer_Pos57 /= No_Token_Index then

   Row_Pos47 := Defer_Pos57;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;


--  BEGIN <Opt at parser.lkt:1017:52>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:1017:53>

Token_Res68 := Row_Pos47;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res68));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos68 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos47 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos47,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos68 := Row_Pos47 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:1017:53>


if Token_Pos68 = No_Token_Index then

         
   Token_Res68 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos47)),
                To_Text ("Missing ';'"));

       
   Token_Pos68 := Row_Pos47;



end if;

--  END <Opt at parser.lkt:1017:52>



Row_Progress5 := 5;

if Token_Pos68 /= No_Token_Index then

   Row_Pos47 := Token_Pos68;

else
   Row_Pos47 := No_Token_Index;
   goto Exit_Row47_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row47_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos47 = No_Token_Index and then Nobt5 then

   Row_Pos47 := Parser.Last_Fail.Pos;

   Transform_Has_Failed5 := True;
end if;

if Row_Pos47 /= No_Token_Index then

   Transform_Res37 := Allocate_Assign_Stmt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res37,
      Kind => Ada_Assign_Stmt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos47 = Pos
                            then No_Token_Index
                            else Row_Pos47 - 1));

      
      Initialize_Fields_For_Assign_Stmt
        (Self => Transform_Res37,
         Assign_Stmt_F_Dest => Defer_Res56,
         Assign_Stmt_F_Expr => Defer_Res57);

         if Defer_Res56 /= null and then Is_Incomplete (Defer_Res56) then
            Transform_Res37.Last_Attempted_Child := 0;
         elsif Defer_Res56 /= null and then not Is_Ghost (Defer_Res56) then
            Transform_Res37.Last_Attempted_Child := -1;
         end if;
         if Defer_Res57 /= null and then Is_Incomplete (Defer_Res57) then
            Transform_Res37.Last_Attempted_Child := 0;
         elsif Defer_Res57 /= null and then not Is_Ghost (Defer_Res57) then
            Transform_Res37.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed5 then
      Transform_Res37.Last_Attempted_Child :=
         Row_Progress5;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <assignment_stmt>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos47 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags37);
end if;

--  END <Transform(<CompiledType BareAssignStmt>) at parser.lkt:1017:24>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Assignment_Stmt_Transform_Parse0_Memo,
      Row_Pos47 /= No_Token_Index,
      Transform_Res37,
      Pos,
      Row_Pos47);


   Parser.Current_Pos := Row_Pos47;

   return Transform_Res37;
end Assignment_Stmt_Transform_Parse0;

   


function Attr_Suffix_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Assoc_List
is
   use Bare_Assoc_List_Memos;

      Lst_Cpos4 :
            Token_Index
               := No_Token_Index;
      Tmp_List4 :
            Free_Parse_List;
      Defer_Pos58 :
            Token_Index
               := No_Token_Index;
      Defer_Res58 :
            Bare_Param_Assoc
               := No_Bare_Ada_Node;
      Token_Pos69 :
            Token_Index
               := No_Token_Index;
      Token_Res69 :
            Token_Index
               := No_Token_Index;
      List_Pos4 :
            Token_Index
               := No_Token_Index;
      List_Res4 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Attr_Suffix_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res4 := M.Instance;
      return List_Res4;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res4;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List at parser.lkt:1134:20>

    List_Pos4 := No_Token_Index;



Lst_Cpos4 := Pos;
Tmp_List4 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:1134:31>

Defer_Res58 :=
   Param_Assoc_Transform_Parse0 (Parser, Lst_Cpos4);
Defer_Pos58 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1134:31>


   exit when Defer_Pos58 = No_Token_Index;

   List_Pos4 := Defer_Pos58;
   Lst_Cpos4 := List_Pos4;

   Tmp_List4.Nodes.Append (Defer_Res58);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:1134:44>

Token_Res69 := Lst_Cpos4;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res69));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos69 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos4 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos4,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos69 := Lst_Cpos4 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:1134:44>


      exit when Token_Pos69 = No_Token_Index;

      Lst_Cpos4 := Token_Pos69;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List4.Nodes.Length;
begin
   List_Res4 := Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos4 = Pos
                    then Pos
                    else List_Pos4 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res4,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res4,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List4.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res4.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List4);

--  END <List at parser.lkt:1134:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Attr_Suffix_List_Parse0_Memo,
      List_Pos4 /= No_Token_Index,
      List_Res4,
      Pos,
      List_Pos4);


   Parser.Current_Pos := List_Pos4;

   return List_Res4;
end Attr_Suffix_List_Parse0;

   


function Basic_Decl_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Defer_Pos59 :
            Token_Index
               := No_Token_Index;
      Defer_Res59 :
            Bare_Null_Subp_Decl
               := No_Bare_Ada_Node;
      Defer_Pos60 :
            Token_Index
               := No_Token_Index;
      Defer_Res60 :
            Bare_Abstract_Subp_Decl
               := No_Bare_Ada_Node;
      Defer_Pos61 :
            Token_Index
               := No_Token_Index;
      Defer_Res61 :
            Bare_Expr_Function
               := No_Bare_Ada_Node;
      Defer_Pos62 :
            Token_Index
               := No_Token_Index;
      Defer_Res62 :
            Bare_Subp_Renaming_Decl
               := No_Bare_Ada_Node;
      Defer_Pos63 :
            Token_Index
               := No_Token_Index;
      Defer_Res63 :
            Bare_Body_Stub
               := No_Bare_Ada_Node;
      Defer_Pos64 :
            Token_Index
               := No_Token_Index;
      Defer_Res64 :
            Bare_Generic_Instantiation
               := No_Bare_Ada_Node;
      Defer_Pos65 :
            Token_Index
               := No_Token_Index;
      Defer_Res65 :
            Bare_Body_Node
               := No_Bare_Ada_Node;
      Defer_Pos66 :
            Token_Index
               := No_Token_Index;
      Defer_Res66 :
            Bare_Subp_Decl
               := No_Bare_Ada_Node;
      Defer_Pos67 :
            Token_Index
               := No_Token_Index;
      Defer_Res67 :
            Bare_Base_Type_Decl
               := No_Bare_Ada_Node;
      Defer_Pos68 :
            Token_Index
               := No_Token_Index;
      Defer_Res68 :
            Bare_Task_Type_Decl
               := No_Bare_Ada_Node;
      Defer_Pos69 :
            Token_Index
               := No_Token_Index;
      Defer_Res69 :
            Bare_Protected_Type_Decl
               := No_Bare_Ada_Node;
      Defer_Pos70 :
            Token_Index
               := No_Token_Index;
      Defer_Res70 :
            Bare_Subtype_Decl
               := No_Bare_Ada_Node;
      Defer_Pos71 :
            Token_Index
               := No_Token_Index;
      Defer_Res71 :
            Bare_Object_Decl
               := No_Bare_Ada_Node;
      Defer_Pos72 :
            Token_Index
               := No_Token_Index;
      Defer_Res72 :
            Bare_Single_Task_Decl
               := No_Bare_Ada_Node;
      Defer_Pos73 :
            Token_Index
               := No_Token_Index;
      Defer_Res73 :
            Bare_Single_Protected_Decl
               := No_Bare_Ada_Node;
      Defer_Pos74 :
            Token_Index
               := No_Token_Index;
      Defer_Res74 :
            Bare_Number_Decl
               := No_Bare_Ada_Node;
      Defer_Pos75 :
            Token_Index
               := No_Token_Index;
      Defer_Res75 :
            Bare_Package_Decl
               := No_Bare_Ada_Node;
      Defer_Pos76 :
            Token_Index
               := No_Token_Index;
      Defer_Res76 :
            Bare_Aspect_Clause
               := No_Bare_Ada_Node;
      Defer_Pos77 :
            Token_Index
               := No_Token_Index;
      Defer_Res77 :
            Bare_Use_Clause
               := No_Bare_Ada_Node;
      Defer_Pos78 :
            Token_Index
               := No_Token_Index;
      Defer_Res78 :
            Bare_Exception_Decl
               := No_Bare_Ada_Node;
      Defer_Pos79 :
            Token_Index
               := No_Token_Index;
      Defer_Res79 :
            Bare_Package_Renaming_Decl
               := No_Bare_Ada_Node;
      Defer_Pos80 :
            Token_Index
               := No_Token_Index;
      Defer_Res80 :
            Bare_Generic_Renaming_Decl
               := No_Bare_Ada_Node;
      Defer_Pos81 :
            Token_Index
               := No_Token_Index;
      Defer_Res81 :
            Bare_Generic_Decl
               := No_Bare_Ada_Node;
      Defer_Pos82 :
            Token_Index
               := No_Token_Index;
      Defer_Res82 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      Or_Pos17 :
            Token_Index
               := No_Token_Index;
      Or_Res17 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Basic_Decl_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res17 := M.Instance;
      return Or_Res17;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res17;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:384:19>

Or_Pos17 := No_Token_Index;
Or_Res17 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:385:11>

Defer_Res59 :=
   Null_Subp_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos59 := Parser.Current_Pos;

--  END <Defer at parser.lkt:385:11>

    if Defer_Pos59 /= No_Token_Index then
        Or_Pos17 := Defer_Pos59;
        Or_Res17 := Defer_Res59;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:386:11>

Defer_Res60 :=
   Abstract_Subp_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos60 := Parser.Current_Pos;

--  END <Defer at parser.lkt:386:11>

    if Defer_Pos60 /= No_Token_Index then
        Or_Pos17 := Defer_Pos60;
        Or_Res17 := Defer_Res60;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:387:11>

Defer_Res61 :=
   Expr_Fn_Transform_Parse0 (Parser, Pos);
Defer_Pos61 := Parser.Current_Pos;

--  END <Defer at parser.lkt:387:11>

    if Defer_Pos61 /= No_Token_Index then
        Or_Pos17 := Defer_Pos61;
        Or_Res17 := Defer_Res61;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:388:11>

Defer_Res62 :=
   Subp_Renaming_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos62 := Parser.Current_Pos;

--  END <Defer at parser.lkt:388:11>

    if Defer_Pos62 /= No_Token_Index then
        Or_Pos17 := Defer_Pos62;
        Or_Res17 := Defer_Res62;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:389:11>

Defer_Res63 :=
   Body_Stub_Or_Parse0 (Parser, Pos);
Defer_Pos63 := Parser.Current_Pos;

--  END <Defer at parser.lkt:389:11>

    if Defer_Pos63 /= No_Token_Index then
        Or_Pos17 := Defer_Pos63;
        Or_Res17 := Defer_Res63;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:390:11>

Defer_Res64 :=
   Generic_Instantiation_Or_Parse1 (Parser, Pos);
Defer_Pos64 := Parser.Current_Pos;

--  END <Defer at parser.lkt:390:11>

    if Defer_Pos64 /= No_Token_Index then
        Or_Pos17 := Defer_Pos64;
        Or_Res17 := Defer_Res64;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:391:11>

Defer_Res65 :=
   Body_Or_Parse0 (Parser, Pos);
Defer_Pos65 := Parser.Current_Pos;

--  END <Defer at parser.lkt:391:11>

    if Defer_Pos65 /= No_Token_Index then
        Or_Pos17 := Defer_Pos65;
        Or_Res17 := Defer_Res65;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:392:11>

Defer_Res66 :=
   Simple_Subp_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos66 := Parser.Current_Pos;

--  END <Defer at parser.lkt:392:11>

    if Defer_Pos66 /= No_Token_Index then
        Or_Pos17 := Defer_Pos66;
        Or_Res17 := Defer_Res66;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:393:11>

Defer_Res67 :=
   Type_Decl_Or_Parse1 (Parser, Pos);
Defer_Pos67 := Parser.Current_Pos;

--  END <Defer at parser.lkt:393:11>

    if Defer_Pos67 /= No_Token_Index then
        Or_Pos17 := Defer_Pos67;
        Or_Res17 := Defer_Res67;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:394:11>

Defer_Res68 :=
   Task_Type_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos68 := Parser.Current_Pos;

--  END <Defer at parser.lkt:394:11>

    if Defer_Pos68 /= No_Token_Index then
        Or_Pos17 := Defer_Pos68;
        Or_Res17 := Defer_Res68;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:395:11>

Defer_Res69 :=
   Protected_Type_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos69 := Parser.Current_Pos;

--  END <Defer at parser.lkt:395:11>

    if Defer_Pos69 /= No_Token_Index then
        Or_Pos17 := Defer_Pos69;
        Or_Res17 := Defer_Res69;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:396:11>

Defer_Res70 :=
   Subtype_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos70 := Parser.Current_Pos;

--  END <Defer at parser.lkt:396:11>

    if Defer_Pos70 /= No_Token_Index then
        Or_Pos17 := Defer_Pos70;
        Or_Res17 := Defer_Res70;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:397:11>

Defer_Res71 :=
   Object_Decl_Or_Parse0 (Parser, Pos);
Defer_Pos71 := Parser.Current_Pos;

--  END <Defer at parser.lkt:397:11>

    if Defer_Pos71 /= No_Token_Index then
        Or_Pos17 := Defer_Pos71;
        Or_Res17 := Defer_Res71;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:398:11>

Defer_Res72 :=
   Single_Task_Decl_Transform_Parse1 (Parser, Pos);
Defer_Pos72 := Parser.Current_Pos;

--  END <Defer at parser.lkt:398:11>

    if Defer_Pos72 /= No_Token_Index then
        Or_Pos17 := Defer_Pos72;
        Or_Res17 := Defer_Res72;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:399:11>

Defer_Res73 :=
   Protected_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos73 := Parser.Current_Pos;

--  END <Defer at parser.lkt:399:11>

    if Defer_Pos73 /= No_Token_Index then
        Or_Pos17 := Defer_Pos73;
        Or_Res17 := Defer_Res73;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:400:11>

Defer_Res74 :=
   Number_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos74 := Parser.Current_Pos;

--  END <Defer at parser.lkt:400:11>

    if Defer_Pos74 /= No_Token_Index then
        Or_Pos17 := Defer_Pos74;
        Or_Res17 := Defer_Res74;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:401:11>

Defer_Res75 :=
   Package_Decl_Transform_Parse3 (Parser, Pos);
Defer_Pos75 := Parser.Current_Pos;

--  END <Defer at parser.lkt:401:11>

    if Defer_Pos75 /= No_Token_Index then
        Or_Pos17 := Defer_Pos75;
        Or_Res17 := Defer_Res75;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:402:11>

Defer_Res76 :=
   Aspect_Clause_Or_Parse1 (Parser, Pos);
Defer_Pos76 := Parser.Current_Pos;

--  END <Defer at parser.lkt:402:11>

    if Defer_Pos76 /= No_Token_Index then
        Or_Pos17 := Defer_Pos76;
        Or_Res17 := Defer_Res76;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:403:11>

Defer_Res77 :=
   Use_Clause_Or_Parse0 (Parser, Pos);
Defer_Pos77 := Parser.Current_Pos;

--  END <Defer at parser.lkt:403:11>

    if Defer_Pos77 /= No_Token_Index then
        Or_Pos17 := Defer_Pos77;
        Or_Res17 := Defer_Res77;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:404:11>

Defer_Res78 :=
   Exception_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos78 := Parser.Current_Pos;

--  END <Defer at parser.lkt:404:11>

    if Defer_Pos78 /= No_Token_Index then
        Or_Pos17 := Defer_Pos78;
        Or_Res17 := Defer_Res78;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:405:11>

Defer_Res79 :=
   Package_Renaming_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos79 := Parser.Current_Pos;

--  END <Defer at parser.lkt:405:11>

    if Defer_Pos79 /= No_Token_Index then
        Or_Pos17 := Defer_Pos79;
        Or_Res17 := Defer_Res79;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:406:11>

Defer_Res80 :=
   Generic_Renaming_Decl_Or_Parse1 (Parser, Pos);
Defer_Pos80 := Parser.Current_Pos;

--  END <Defer at parser.lkt:406:11>

    if Defer_Pos80 /= No_Token_Index then
        Or_Pos17 := Defer_Pos80;
        Or_Res17 := Defer_Res80;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:407:11>

Defer_Res81 :=
   Generic_Decl_Or_Parse0 (Parser, Pos);
Defer_Pos81 := Parser.Current_Pos;

--  END <Defer at parser.lkt:407:11>

    if Defer_Pos81 /= No_Token_Index then
        Or_Pos17 := Defer_Pos81;
        Or_Res17 := Defer_Res81;
        goto Exit_Or17;
    end if;
    
--  BEGIN <Defer at parser.lkt:408:11>

Defer_Res82 :=
   Pragma_Transform_Parse0 (Parser, Pos);
Defer_Pos82 := Parser.Current_Pos;

--  END <Defer at parser.lkt:408:11>

    if Defer_Pos82 /= No_Token_Index then
        Or_Pos17 := Defer_Pos82;
        Or_Res17 := Defer_Res82;
        goto Exit_Or17;
    end if;
<<Exit_Or17>>

--  END <Or at parser.lkt:384:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Basic_Decl_Or_Parse0_Memo,
      Or_Pos17 /= No_Token_Index,
      Or_Res17,
      Pos,
      Or_Pos17);


   Parser.Current_Pos := Or_Pos17;

   return Or_Res17;
end Basic_Decl_Or_Parse0;

   


function Basic_Decls_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node_List
is
   use Bare_Ada_Node_List_Memos;

      Lst_Cpos5 :
            Token_Index
               := No_Token_Index;
      Tmp_List5 :
            Free_Parse_List;
      Defer_Pos83 :
            Token_Index
               := No_Token_Index;
      Defer_Res83 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Row_Pos48 :
            Token_Index
               := No_Token_Index;
      Transform_Res38 :
            Bare_Error_Decl
               := No_Bare_Ada_Node;
      Transform_Diags38 :
            Ada.Containers.Count_Type;
      Skip_Pos0 :
            Token_Index
               := No_Token_Index;
      Skip_Dummy0 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Or_Pos18 :
            Token_Index
               := No_Token_Index;
      Or_Res18 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      List_Pos5 :
            Token_Index
               := No_Token_Index;
      List_Res5 :
            Bare_Ada_Node_List
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Basic_Decls_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res5 := M.Instance;
      return List_Res5;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res5;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List at parser.lkt:370:20>

    List_Pos5 := Pos;



Lst_Cpos5 := Pos;
Tmp_List5 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Or at parser.lkt:370:26>

Or_Pos18 := No_Token_Index;
Or_Res18 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:370:29>

Defer_Res83 :=
   Basic_Decl_Or_Parse0 (Parser, Lst_Cpos5);
Defer_Pos83 := Parser.Current_Pos;

--  END <Defer at parser.lkt:370:29>

    if Defer_Pos83 /= No_Token_Index then
        Or_Pos18 := Defer_Pos83;
        Or_Res18 := Defer_Res83;
        goto Exit_Or18;
    end if;
    
--  BEGIN <Skip at parser.lkt:370:42>

if Get_Token (Parser.TDH.all, Lst_Cpos5).Kind
   = From_Token_Kind (Ada_Termination)
then
   Skip_Pos0 := No_Token_Index;
   goto Exit_Or19;
end if;

for Fn of PP.Dont_Skip loop
   Skip_Dummy0 := Fn (Parser, Lst_Cpos5);

   if Parser.Current_Pos /= No_Token_Index  then
      Skip_Pos0 := No_Token_Index;
      goto Exit_Or19;
   end if;
end loop;

Skip_Pos0 := Lst_Cpos5 + 1;

--  BEGIN <Transform(<CompiledType BareErrorDecl>) at ???>

Transform_Diags38 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos48 := Lst_Cpos5;


pragma Warnings (Off, "referenced");
<<Exit_Row48_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos48 /= No_Token_Index then

   Transform_Res38 := Allocate_Error_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res38,
      Kind => Ada_Error_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Lst_Cpos5,
      Token_End_Index   => (if Row_Pos48 = Lst_Cpos5
                            then No_Token_Index
                            else Row_Pos48 - 1));




elsif Row_Pos48 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags38);
end if;

--  END <Transform(<CompiledType BareErrorDecl>) at ???>

Transform_Res38.Token_End_Index := Lst_Cpos5;

Append (Parser.Diagnostics,
        Sloc_Range (Parser.TDH.all,
                    Get_Token (Parser.TDH.all, Lst_Cpos5)),
        To_Text ("Skipped token ")
        & Common.Text
            (Wrap_Token_Reference
               (Parser.Unit.Context,
                Parser.TDH,
                (Lst_Cpos5, No_Token_Index))));

<<Exit_Or19>>

--  END <Skip at parser.lkt:370:42>

    if Skip_Pos0 /= No_Token_Index then
        Or_Pos18 := Skip_Pos0;
        Or_Res18 := Transform_Res38;
        goto Exit_Or18;
    end if;
<<Exit_Or18>>

--  END <Or at parser.lkt:370:26>


   exit when Or_Pos18 = No_Token_Index;

   List_Pos5 := Or_Pos18;
   Lst_Cpos5 := List_Pos5;

   Tmp_List5.Nodes.Append (Or_Res18);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List5.Nodes.Length;
begin
   List_Res5 := Allocate_Ada_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos5 = Pos
                    then Pos
                    else List_Pos5 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res5,
      Kind              => Ada_Ada_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res5,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List5.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res5.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List5);

--  END <List at parser.lkt:370:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Basic_Decls_List_Parse0_Memo,
      List_Pos5 /= No_Token_Index,
      List_Res5,
      Pos,
      List_Pos5);


   Parser.Current_Pos := List_Pos5;

   return List_Res5;
end Basic_Decls_List_Parse0;

   


function Block_Stmt_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Stmt
is
   use Bare_Composite_Stmt_Memos;

      Defer_Pos84 :
            Token_Index
               := No_Token_Index;
      Defer_Res84 :
            Bare_Block_Stmt
               := No_Bare_Ada_Node;
      Row_Pos49 :
            Token_Index
               := No_Token_Index;
      Row_Pos50 :
            Token_Index
               := No_Token_Index;
      Defer_Pos85 :
            Token_Index
               := No_Token_Index;
      Defer_Res85 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Transform_Res39 :
            Bare_Named_Stmt_Decl
               := No_Bare_Ada_Node;
      Transform_Diags39 :
            Ada.Containers.Count_Type;
      Token_Pos70 :
            Token_Index
               := No_Token_Index;
      Token_Res70 :
            Token_Index
               := No_Token_Index;
      Defer_Pos86 :
            Token_Index
               := No_Token_Index;
      Defer_Res86 :
            Bare_Block_Stmt
               := No_Bare_Ada_Node;
      Transform_Res40 :
            Bare_Named_Stmt
               := No_Bare_Ada_Node;
      Transform_Diags40 :
            Ada.Containers.Count_Type;
      Or_Pos19 :
            Token_Index
               := No_Token_Index;
      Or_Res19 :
            Bare_Composite_Stmt
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Block_Stmt_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res19 := M.Instance;
      return Or_Res19;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res19;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:871:19>

Or_Pos19 := No_Token_Index;
Or_Res19 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:872:11>

Defer_Res84 :=
   Iblock_Stmt_Or_Parse0 (Parser, Pos);
Defer_Pos84 := Parser.Current_Pos;

--  END <Defer at parser.lkt:872:11>

    if Defer_Pos84 /= No_Token_Index then
        Or_Pos19 := Defer_Pos84;
        Or_Res19 := Defer_Res84;
        goto Exit_Or20;
    end if;
    
--  BEGIN <Transform(<CompiledType BareNamedStmt>) at parser.lkt:873:11>

Transform_Diags40 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos49 := Pos;



--  BEGIN <Transform(<CompiledType BareNamedStmtDecl>) at parser.lkt:873:21>

Transform_Diags39 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos50 := Row_Pos49;



--  BEGIN <Defer at parser.lkt:873:35>

Defer_Res85 :=
   Defining_Id_Transform_Parse0 (Parser, Row_Pos50);
Defer_Pos85 := Parser.Current_Pos;

--  END <Defer at parser.lkt:873:35>




if Defer_Pos85 /= No_Token_Index then

   Row_Pos50 := Defer_Pos85;

else
   Row_Pos50 := No_Token_Index;
   goto Exit_Row50_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row50_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos50 /= No_Token_Index then

   Transform_Res39 := Allocate_Named_Stmt_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res39,
      Kind => Ada_Named_Stmt_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Row_Pos49,
      Token_End_Index   => (if Row_Pos50 = Row_Pos49
                            then No_Token_Index
                            else Row_Pos50 - 1));

      
      Initialize_Fields_For_Named_Stmt_Decl
        (Self => Transform_Res39,
         Named_Stmt_Decl_F_Name => Defer_Res85);

         if Defer_Res85 /= null and then Is_Incomplete (Defer_Res85) then
            Transform_Res39.Last_Attempted_Child := 0;
         elsif Defer_Res85 /= null and then not Is_Ghost (Defer_Res85) then
            Transform_Res39.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos50 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags39);
end if;

--  END <Transform(<CompiledType BareNamedStmtDecl>) at parser.lkt:873:21>




if Row_Pos50 /= No_Token_Index then

   Row_Pos49 := Row_Pos50;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;


--  BEGIN <Token(<WithText Colon>, ) at parser.lkt:873:48>

Token_Res70 := Row_Pos49;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res70));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Colon)
   then
       Token_Pos70 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos49 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos49,
             Expected_Token_Id => Ada_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos70 := Row_Pos49 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) at parser.lkt:873:48>




if Token_Pos70 /= No_Token_Index then

   Row_Pos49 := Token_Pos70;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;


--  BEGIN <Defer at parser.lkt:873:52>

Defer_Res86 :=
   Iblock_Stmt_Or_Parse0 (Parser, Row_Pos49);
Defer_Pos86 := Parser.Current_Pos;

--  END <Defer at parser.lkt:873:52>




if Defer_Pos86 /= No_Token_Index then

   Row_Pos49 := Defer_Pos86;

else
   Row_Pos49 := No_Token_Index;
   goto Exit_Row49_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row49_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos49 /= No_Token_Index then

   Transform_Res40 := Allocate_Named_Stmt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res40,
      Kind => Ada_Named_Stmt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos49 = Pos
                            then No_Token_Index
                            else Row_Pos49 - 1));

      
      Initialize_Fields_For_Named_Stmt
        (Self => Transform_Res40,
         Named_Stmt_F_Decl => Transform_Res39,
         Named_Stmt_F_Stmt => Defer_Res86);

         if Transform_Res39 /= null and then Is_Incomplete (Transform_Res39) then
            Transform_Res40.Last_Attempted_Child := 0;
         elsif Transform_Res39 /= null and then not Is_Ghost (Transform_Res39) then
            Transform_Res40.Last_Attempted_Child := -1;
         end if;
         if Defer_Res86 /= null and then Is_Incomplete (Defer_Res86) then
            Transform_Res40.Last_Attempted_Child := 0;
         elsif Defer_Res86 /= null and then not Is_Ghost (Defer_Res86) then
            Transform_Res40.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos49 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags40);
end if;

--  END <Transform(<CompiledType BareNamedStmt>) at parser.lkt:873:11>

    if Row_Pos49 /= No_Token_Index then
        Or_Pos19 := Row_Pos49;
        Or_Res19 := Transform_Res40;
        goto Exit_Or20;
    end if;
<<Exit_Or20>>

--  END <Or at parser.lkt:871:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Block_Stmt_Or_Parse0_Memo,
      Or_Pos19 /= No_Token_Index,
      Or_Res19,
      Pos,
      Or_Pos19);


   Parser.Current_Pos := Or_Pos19;

   return Or_Res19;
end Block_Stmt_Or_Parse0;

   


function Body_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Node
is
   use Bare_Body_Node_Memos;

      Defer_Pos87 :
            Token_Index
               := No_Token_Index;
      Defer_Res87 :
            Bare_Subp_Body
               := No_Bare_Ada_Node;
      Defer_Pos88 :
            Token_Index
               := No_Token_Index;
      Defer_Res88 :
            Bare_Package_Body
               := No_Bare_Ada_Node;
      Defer_Pos89 :
            Token_Index
               := No_Token_Index;
      Defer_Res89 :
            Bare_Task_Body
               := No_Bare_Ada_Node;
      Defer_Pos90 :
            Token_Index
               := No_Token_Index;
      Defer_Res90 :
            Bare_Protected_Body
               := No_Bare_Ada_Node;
      Defer_Pos91 :
            Token_Index
               := No_Token_Index;
      Defer_Res91 :
            Bare_Entry_Body
               := No_Bare_Ada_Node;
      Or_Pos20 :
            Token_Index
               := No_Token_Index;
      Or_Res20 :
            Bare_Body_Node
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Body_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res20 := M.Instance;
      return Or_Res20;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res20;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:942:13>

Or_Pos20 := No_Token_Index;
Or_Res20 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:943:11>

Defer_Res87 :=
   Subp_Body_Transform_Parse1 (Parser, Pos);
Defer_Pos87 := Parser.Current_Pos;

--  END <Defer at parser.lkt:943:11>

    if Defer_Pos87 /= No_Token_Index then
        Or_Pos20 := Defer_Pos87;
        Or_Res20 := Defer_Res87;
        goto Exit_Or21;
    end if;
    
--  BEGIN <Defer at parser.lkt:944:11>

Defer_Res88 :=
   Package_Body_Transform_Parse1 (Parser, Pos);
Defer_Pos88 := Parser.Current_Pos;

--  END <Defer at parser.lkt:944:11>

    if Defer_Pos88 /= No_Token_Index then
        Or_Pos20 := Defer_Pos88;
        Or_Res20 := Defer_Res88;
        goto Exit_Or21;
    end if;
    
--  BEGIN <Defer at parser.lkt:945:11>

Defer_Res89 :=
   Task_Body_Transform_Parse1 (Parser, Pos);
Defer_Pos89 := Parser.Current_Pos;

--  END <Defer at parser.lkt:945:11>

    if Defer_Pos89 /= No_Token_Index then
        Or_Pos20 := Defer_Pos89;
        Or_Res20 := Defer_Res89;
        goto Exit_Or21;
    end if;
    
--  BEGIN <Defer at parser.lkt:946:11>

Defer_Res90 :=
   Protected_Body_Transform_Parse1 (Parser, Pos);
Defer_Pos90 := Parser.Current_Pos;

--  END <Defer at parser.lkt:946:11>

    if Defer_Pos90 /= No_Token_Index then
        Or_Pos20 := Defer_Pos90;
        Or_Res20 := Defer_Res90;
        goto Exit_Or21;
    end if;
    
--  BEGIN <Defer at parser.lkt:947:11>

Defer_Res91 :=
   Entry_Body_Transform_Parse3 (Parser, Pos);
Defer_Pos91 := Parser.Current_Pos;

--  END <Defer at parser.lkt:947:11>

    if Defer_Pos91 /= No_Token_Index then
        Or_Pos20 := Defer_Pos91;
        Or_Res20 := Defer_Res91;
        goto Exit_Or21;
    end if;
<<Exit_Or21>>

--  END <Or at parser.lkt:942:13>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Body_Or_Parse0_Memo,
      Or_Pos20 /= No_Token_Index,
      Or_Res20,
      Pos,
      Or_Pos20);


   Parser.Current_Pos := Or_Pos20;

   return Or_Res20;
end Body_Or_Parse0;

   


function Body_Stub_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Body_Stub
is
   use Bare_Body_Stub_Memos;

      Defer_Pos92 :
            Token_Index
               := No_Token_Index;
      Defer_Res92 :
            Bare_Subp_Body_Stub
               := No_Bare_Ada_Node;
      Defer_Pos93 :
            Token_Index
               := No_Token_Index;
      Defer_Res93 :
            Bare_Package_Body_Stub
               := No_Bare_Ada_Node;
      Defer_Pos94 :
            Token_Index
               := No_Token_Index;
      Defer_Res94 :
            Bare_Task_Body_Stub
               := No_Bare_Ada_Node;
      Defer_Pos95 :
            Token_Index
               := No_Token_Index;
      Defer_Res95 :
            Bare_Protected_Body_Stub
               := No_Bare_Ada_Node;
      Or_Pos21 :
            Token_Index
               := No_Token_Index;
      Or_Res21 :
            Bare_Body_Stub
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Body_Stub_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res21 := M.Instance;
      return Or_Res21;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res21;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:949:18>

Or_Pos21 := No_Token_Index;
Or_Res21 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:950:11>

Defer_Res92 :=
   Subp_Body_Stub_Transform_Parse0 (Parser, Pos);
Defer_Pos92 := Parser.Current_Pos;

--  END <Defer at parser.lkt:950:11>

    if Defer_Pos92 /= No_Token_Index then
        Or_Pos21 := Defer_Pos92;
        Or_Res21 := Defer_Res92;
        goto Exit_Or22;
    end if;
    
--  BEGIN <Defer at parser.lkt:951:11>

Defer_Res93 :=
   Package_Body_Stub_Transform_Parse0 (Parser, Pos);
Defer_Pos93 := Parser.Current_Pos;

--  END <Defer at parser.lkt:951:11>

    if Defer_Pos93 /= No_Token_Index then
        Or_Pos21 := Defer_Pos93;
        Or_Res21 := Defer_Res93;
        goto Exit_Or22;
    end if;
    
--  BEGIN <Defer at parser.lkt:952:11>

Defer_Res94 :=
   Task_Body_Stub_Transform_Parse0 (Parser, Pos);
Defer_Pos94 := Parser.Current_Pos;

--  END <Defer at parser.lkt:952:11>

    if Defer_Pos94 /= No_Token_Index then
        Or_Pos21 := Defer_Pos94;
        Or_Res21 := Defer_Res94;
        goto Exit_Or22;
    end if;
    
--  BEGIN <Defer at parser.lkt:953:11>

Defer_Res95 :=
   Protected_Body_Stub_Transform_Parse0 (Parser, Pos);
Defer_Pos95 := Parser.Current_Pos;

--  END <Defer at parser.lkt:953:11>

    if Defer_Pos95 /= No_Token_Index then
        Or_Pos21 := Defer_Pos95;
        Or_Res21 := Defer_Res95;
        goto Exit_Or22;
    end if;
<<Exit_Or22>>

--  END <Or at parser.lkt:949:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Body_Stub_Or_Parse0_Memo,
      Or_Pos21 /= No_Token_Index,
      Or_Res21,
      Pos,
      Or_Pos21);


   Parser.Current_Pos := Or_Pos21;

   return Or_Res21;
end Body_Stub_Or_Parse0;

   


function Boolean_Op_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Op
is
   use Bare_Op_Memos;

      Row_Pos51 :
            Token_Index
               := No_Token_Index;
      Token_Pos71 :
            Token_Index
               := No_Token_Index;
      Token_Res71 :
            Token_Index
               := No_Token_Index;
      Transform_Res41 :
            Bare_Op_Xor
               := No_Bare_Ada_Node;
      Transform_Diags41 :
            Ada.Containers.Count_Type;
      Row_Pos52 :
            Token_Index
               := No_Token_Index;
      Token_Pos72 :
            Token_Index
               := No_Token_Index;
      Token_Res72 :
            Token_Index
               := No_Token_Index;
      Token_Pos73 :
            Token_Index
               := No_Token_Index;
      Token_Res73 :
            Token_Index
               := No_Token_Index;
      Transform_Res42 :
            Bare_Op_And_Then
               := No_Bare_Ada_Node;
      Transform_Diags42 :
            Ada.Containers.Count_Type;
      Row_Pos53 :
            Token_Index
               := No_Token_Index;
      Token_Pos74 :
            Token_Index
               := No_Token_Index;
      Token_Res74 :
            Token_Index
               := No_Token_Index;
      Transform_Res43 :
            Bare_Op_And
               := No_Bare_Ada_Node;
      Transform_Diags43 :
            Ada.Containers.Count_Type;
      Row_Pos54 :
            Token_Index
               := No_Token_Index;
      Token_Pos75 :
            Token_Index
               := No_Token_Index;
      Token_Res75 :
            Token_Index
               := No_Token_Index;
      Token_Pos76 :
            Token_Index
               := No_Token_Index;
      Token_Res76 :
            Token_Index
               := No_Token_Index;
      Transform_Res44 :
            Bare_Op_Or_Else
               := No_Bare_Ada_Node;
      Transform_Diags44 :
            Ada.Containers.Count_Type;
      Row_Pos55 :
            Token_Index
               := No_Token_Index;
      Token_Pos77 :
            Token_Index
               := No_Token_Index;
      Token_Res77 :
            Token_Index
               := No_Token_Index;
      Transform_Res45 :
            Bare_Op_Or
               := No_Bare_Ada_Node;
      Transform_Diags45 :
            Ada.Containers.Count_Type;
      Or_Pos22 :
            Token_Index
               := No_Token_Index;
      Or_Res22 :
            Bare_Op
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Boolean_Op_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res22 := M.Instance;
      return Or_Res22;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res22;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1272:19>

Or_Pos22 := No_Token_Index;
Or_Res22 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareOpXor>) at parser.lkt:1273:11>

Transform_Diags41 := Parser.Diagnostics.Length;


--  BEGIN <_Row at parser.lkt:1273:11>

Row_Pos51 := Pos;



--  BEGIN <Token(<WithText Xor>, ) at parser.lkt:1273:18>

Token_Res71 := Row_Pos51;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res71));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Xor)
   then
       Token_Pos71 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos51 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos51,
             Expected_Token_Id => Ada_Xor,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos71 := Row_Pos51 + 1;
   end if;
end;

--  END <Token(<WithText Xor>, ) at parser.lkt:1273:18>




if Token_Pos71 /= No_Token_Index then

   Row_Pos51 := Token_Pos71;

else
   Row_Pos51 := No_Token_Index;
   goto Exit_Row51_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row51_0>>
pragma Warnings (On, "referenced");

--  END <_Row at parser.lkt:1273:11>



if Row_Pos51 /= No_Token_Index then

   Transform_Res41 := Allocate_Op_Xor (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res41,
      Kind => Ada_Op_Xor,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos51 = Pos
                            then No_Token_Index
                            else Row_Pos51 - 1));

      
      Initialize_Fields_For_Op_Xor
        (Self => Transform_Res41);



elsif Row_Pos51 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags41);
end if;

--  END <Transform(<CompiledType BareOpXor>) at parser.lkt:1273:11>

    if Row_Pos51 /= No_Token_Index then
        Or_Pos22 := Row_Pos51;
        Or_Res22 := Transform_Res41;
        goto Exit_Or23;
    end if;
    
--  BEGIN <Transform(<CompiledType BareOpAndThen>) at parser.lkt:1274:11>

Transform_Diags42 := Parser.Diagnostics.Length;


--  BEGIN <_Row at parser.lkt:1274:11>

Row_Pos52 := Pos;



--  BEGIN <Token(<WithText And>, ) at parser.lkt:1274:22>

Token_Res72 := Row_Pos52;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res72));
begin
   if
      T.Kind /= From_Token_Kind (Ada_And)
   then
       Token_Pos72 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos52 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos52,
             Expected_Token_Id => Ada_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos72 := Row_Pos52 + 1;
   end if;
end;

--  END <Token(<WithText And>, ) at parser.lkt:1274:22>




if Token_Pos72 /= No_Token_Index then

   Row_Pos52 := Token_Pos72;

else
   Row_Pos52 := No_Token_Index;
   goto Exit_Row52_0;

end if;


--  BEGIN <Token(<WithText Then>, ) at parser.lkt:1274:28>

Token_Res73 := Row_Pos52;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res73));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Then)
   then
       Token_Pos73 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos52 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos52,
             Expected_Token_Id => Ada_Then,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos73 := Row_Pos52 + 1;
   end if;
end;

--  END <Token(<WithText Then>, ) at parser.lkt:1274:28>




if Token_Pos73 /= No_Token_Index then

   Row_Pos52 := Token_Pos73;

else
   Row_Pos52 := No_Token_Index;
   goto Exit_Row52_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row52_0>>
pragma Warnings (On, "referenced");

--  END <_Row at parser.lkt:1274:11>



if Row_Pos52 /= No_Token_Index then

   Transform_Res42 := Allocate_Op_And_Then (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res42,
      Kind => Ada_Op_And_Then,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos52 = Pos
                            then No_Token_Index
                            else Row_Pos52 - 1));

      
      Initialize_Fields_For_Op_And_Then
        (Self => Transform_Res42);



elsif Row_Pos52 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags42);
end if;

--  END <Transform(<CompiledType BareOpAndThen>) at parser.lkt:1274:11>

    if Row_Pos52 /= No_Token_Index then
        Or_Pos22 := Row_Pos52;
        Or_Res22 := Transform_Res42;
        goto Exit_Or23;
    end if;
    
--  BEGIN <Transform(<CompiledType BareOpAnd>) at parser.lkt:1275:11>

Transform_Diags43 := Parser.Diagnostics.Length;


--  BEGIN <_Row at parser.lkt:1275:11>

Row_Pos53 := Pos;



--  BEGIN <Token(<WithText And>, ) at parser.lkt:1275:18>

Token_Res74 := Row_Pos53;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res74));
begin
   if
      T.Kind /= From_Token_Kind (Ada_And)
   then
       Token_Pos74 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos53 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos53,
             Expected_Token_Id => Ada_And,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos74 := Row_Pos53 + 1;
   end if;
end;

--  END <Token(<WithText And>, ) at parser.lkt:1275:18>




if Token_Pos74 /= No_Token_Index then

   Row_Pos53 := Token_Pos74;

else
   Row_Pos53 := No_Token_Index;
   goto Exit_Row53_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row53_0>>
pragma Warnings (On, "referenced");

--  END <_Row at parser.lkt:1275:11>



if Row_Pos53 /= No_Token_Index then

   Transform_Res43 := Allocate_Op_And (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res43,
      Kind => Ada_Op_And,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos53 = Pos
                            then No_Token_Index
                            else Row_Pos53 - 1));

      
      Initialize_Fields_For_Op_And
        (Self => Transform_Res43);



elsif Row_Pos53 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags43);
end if;

--  END <Transform(<CompiledType BareOpAnd>) at parser.lkt:1275:11>

    if Row_Pos53 /= No_Token_Index then
        Or_Pos22 := Row_Pos53;
        Or_Res22 := Transform_Res43;
        goto Exit_Or23;
    end if;
    
--  BEGIN <Transform(<CompiledType BareOpOrElse>) at parser.lkt:1276:11>

Transform_Diags44 := Parser.Diagnostics.Length;


--  BEGIN <_Row at parser.lkt:1276:11>

Row_Pos54 := Pos;



--  BEGIN <Token(<WithText Or>, ) at parser.lkt:1276:21>

Token_Res75 := Row_Pos54;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res75));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Or)
   then
       Token_Pos75 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos54 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos54,
             Expected_Token_Id => Ada_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos75 := Row_Pos54 + 1;
   end if;
end;

--  END <Token(<WithText Or>, ) at parser.lkt:1276:21>




if Token_Pos75 /= No_Token_Index then

   Row_Pos54 := Token_Pos75;

else
   Row_Pos54 := No_Token_Index;
   goto Exit_Row54_0;

end if;


--  BEGIN <Token(<WithText Else>, ) at parser.lkt:1276:26>

Token_Res76 := Row_Pos54;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res76));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Else)
   then
       Token_Pos76 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos54 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos54,
             Expected_Token_Id => Ada_Else,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos76 := Row_Pos54 + 1;
   end if;
end;

--  END <Token(<WithText Else>, ) at parser.lkt:1276:26>




if Token_Pos76 /= No_Token_Index then

   Row_Pos54 := Token_Pos76;

else
   Row_Pos54 := No_Token_Index;
   goto Exit_Row54_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row54_0>>
pragma Warnings (On, "referenced");

--  END <_Row at parser.lkt:1276:11>



if Row_Pos54 /= No_Token_Index then

   Transform_Res44 := Allocate_Op_Or_Else (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res44,
      Kind => Ada_Op_Or_Else,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos54 = Pos
                            then No_Token_Index
                            else Row_Pos54 - 1));

      
      Initialize_Fields_For_Op_Or_Else
        (Self => Transform_Res44);



elsif Row_Pos54 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags44);
end if;

--  END <Transform(<CompiledType BareOpOrElse>) at parser.lkt:1276:11>

    if Row_Pos54 /= No_Token_Index then
        Or_Pos22 := Row_Pos54;
        Or_Res22 := Transform_Res44;
        goto Exit_Or23;
    end if;
    
--  BEGIN <Transform(<CompiledType BareOpOr>) at parser.lkt:1277:11>

Transform_Diags45 := Parser.Diagnostics.Length;


--  BEGIN <_Row at parser.lkt:1277:11>

Row_Pos55 := Pos;



--  BEGIN <Token(<WithText Or>, ) at parser.lkt:1277:17>

Token_Res77 := Row_Pos55;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res77));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Or)
   then
       Token_Pos77 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos55 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos55,
             Expected_Token_Id => Ada_Or,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos77 := Row_Pos55 + 1;
   end if;
end;

--  END <Token(<WithText Or>, ) at parser.lkt:1277:17>




if Token_Pos77 /= No_Token_Index then

   Row_Pos55 := Token_Pos77;

else
   Row_Pos55 := No_Token_Index;
   goto Exit_Row55_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row55_0>>
pragma Warnings (On, "referenced");

--  END <_Row at parser.lkt:1277:11>



if Row_Pos55 /= No_Token_Index then

   Transform_Res45 := Allocate_Op_Or (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res45,
      Kind => Ada_Op_Or,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos55 = Pos
                            then No_Token_Index
                            else Row_Pos55 - 1));

      
      Initialize_Fields_For_Op_Or
        (Self => Transform_Res45);



elsif Row_Pos55 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags45);
end if;

--  END <Transform(<CompiledType BareOpOr>) at parser.lkt:1277:11>

    if Row_Pos55 /= No_Token_Index then
        Or_Pos22 := Row_Pos55;
        Or_Res22 := Transform_Res45;
        goto Exit_Or23;
    end if;
<<Exit_Or23>>

--  END <Or at parser.lkt:1272:19>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Boolean_Op_Or_Parse0_Memo,
      Or_Pos22 /= No_Token_Index,
      Or_Res22,
      Pos,
      Or_Pos22);


   Parser.Current_Pos := Or_Pos22;

   return Or_Res22;
end Boolean_Op_Or_Parse0;

   


function Box_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Box_Expr
is
   use Bare_Box_Expr_Memos;

      Row_Pos56 :
            Token_Index
               := No_Token_Index;
      Token_Pos78 :
            Token_Index
               := No_Token_Index;
      Token_Res78 :
            Token_Index
               := No_Token_Index;
      Transform_Res46 :
            Bare_Box_Expr
               := No_Bare_Ada_Node;
      Transform_Diags46 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Box_Expr_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res46 := M.Instance;
      return Transform_Res46;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res46;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareBoxExpr>) at parser.lkt:1079:17>

Transform_Diags46 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos56 := Pos;



--  BEGIN <Token(<WithText Diamond>, ) at parser.lkt:1079:25>

Token_Res78 := Row_Pos56;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res78));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Diamond)
   then
       Token_Pos78 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos56 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos56,
             Expected_Token_Id => Ada_Diamond,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos78 := Row_Pos56 + 1;
   end if;
end;

--  END <Token(<WithText Diamond>, ) at parser.lkt:1079:25>




if Token_Pos78 /= No_Token_Index then

   Row_Pos56 := Token_Pos78;

else
   Row_Pos56 := No_Token_Index;
   goto Exit_Row56_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row56_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos56 /= No_Token_Index then

   Transform_Res46 := Allocate_Box_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res46,
      Kind => Ada_Box_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos56 = Pos
                            then No_Token_Index
                            else Row_Pos56 - 1));

      
      Initialize_Fields_For_Box_Expr
        (Self => Transform_Res46);



elsif Row_Pos56 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags46);
end if;

--  END <Transform(<CompiledType BareBoxExpr>) at parser.lkt:1079:17>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Box_Expr_Transform_Parse0_Memo,
      Row_Pos56 /= No_Token_Index,
      Transform_Res46,
      Pos,
      Row_Pos56);


   Parser.Current_Pos := Row_Pos56;

   return Transform_Res46;
end Box_Expr_Transform_Parse0;

   


function Bracket_Aggregate_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Base_Aggregate
is
   use Bare_Base_Aggregate_Memos;

      Nobt6 :
            Boolean
               := False;
      Nobt7 :
            Boolean
               := False;
      Row_Pos57 :
            Token_Index
               := No_Token_Index;
      Token_Pos79 :
            Token_Index
               := No_Token_Index;
      Token_Res79 :
            Token_Index
               := No_Token_Index;
      Defer_Pos96 :
            Token_Index
               := No_Token_Index;
      Defer_Res96 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos80 :
            Token_Index
               := No_Token_Index;
      Token_Res80 :
            Token_Index
               := No_Token_Index;
      Token_Pos81 :
            Token_Index
               := No_Token_Index;
      Token_Res81 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos6 :
            Token_Index
               := No_Token_Index;
      Tmp_List6 :
            Free_Parse_List;
      Defer_Pos97 :
            Token_Index
               := No_Token_Index;
      Defer_Res97 :
            Bare_Basic_Assoc
               := No_Bare_Ada_Node;
      Token_Pos82 :
            Token_Index
               := No_Token_Index;
      Token_Res82 :
            Token_Index
               := No_Token_Index;
      List_Pos6 :
            Token_Index
               := No_Token_Index;
      List_Res6 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos83 :
            Token_Index
               := No_Token_Index;
      Token_Res83 :
            Token_Index
               := No_Token_Index;
      Row_Progress6 :
            Integer
               := 0;
      Transform_Res47 :
            Bare_Bracket_Delta_Aggregate
               := No_Bare_Ada_Node;
      Transform_Has_Failed6 :
            Boolean
               := False;
      Transform_Diags47 :
            Ada.Containers.Count_Type;
      Row_Pos58 :
            Token_Index
               := No_Token_Index;
      Token_Pos84 :
            Token_Index
               := No_Token_Index;
      Token_Res84 :
            Token_Index
               := No_Token_Index;
      Row_Pos59 :
            Token_Index
               := No_Token_Index;
      Defer_Pos98 :
            Token_Index
               := No_Token_Index;
      Defer_Res98 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos85 :
            Token_Index
               := No_Token_Index;
      Token_Res85 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos7 :
            Token_Index
               := No_Token_Index;
      Tmp_List7 :
            Free_Parse_List;
      Defer_Pos99 :
            Token_Index
               := No_Token_Index;
      Defer_Res99 :
            Bare_Basic_Assoc
               := No_Bare_Ada_Node;
      Token_Pos86 :
            Token_Index
               := No_Token_Index;
      Token_Res86 :
            Token_Index
               := No_Token_Index;
      List_Pos7 :
            Token_Index
               := No_Token_Index;
      List_Res7 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos87 :
            Token_Index
               := No_Token_Index;
      Token_Res87 :
            Token_Index
               := No_Token_Index;
      Row_Progress7 :
            Integer
               := 0;
      Transform_Res48 :
            Bare_Bracket_Aggregate
               := No_Bare_Ada_Node;
      Transform_Has_Failed7 :
            Boolean
               := False;
      Transform_Diags48 :
            Ada.Containers.Count_Type;
      Or_Pos23 :
            Token_Index
               := No_Token_Index;
      Or_Res23 :
            Bare_Base_Aggregate
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Bracket_Aggregate_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res23 := M.Instance;
      return Or_Res23;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res23;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1110:26>

Or_Pos23 := No_Token_Index;
Or_Res23 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareBracketDeltaAggregate>) at parser.lkt:1111:11>

Transform_Diags47 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos57 := Pos;



--  BEGIN <Token(<WithText BrackOpen>, ) at parser.lkt:1112:13>

Token_Res79 := Row_Pos57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res79));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Brack_Open)
   then
       Token_Pos79 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos57,
             Expected_Token_Id => Ada_Brack_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos79 := Row_Pos57 + 1;
   end if;
end;

--  END <Token(<WithText BrackOpen>, ) at parser.lkt:1112:13>



Row_Progress6 := 1;

if Token_Pos79 /= No_Token_Index then

   Row_Pos57 := Token_Pos79;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;


--  BEGIN <Defer at parser.lkt:1112:17>

Defer_Res96 :=
   Expr_Or_Parse0 (Parser, Row_Pos57);
Defer_Pos96 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1112:17>



Row_Progress6 := 2;

if Defer_Pos96 /= No_Token_Index then

   Row_Pos57 := Defer_Pos96;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;


--  BEGIN <Token(<WithText With>, ) at parser.lkt:1112:22>

Token_Res80 := Row_Pos57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res80));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos80 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos57,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos80 := Row_Pos57 + 1;
   end if;
end;

--  END <Token(<WithText With>, ) at parser.lkt:1112:22>



Row_Progress6 := 3;

if Token_Pos80 /= No_Token_Index then

   Row_Pos57 := Token_Pos80;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;


--  BEGIN <Token(<WithText Delta>, ) at parser.lkt:1112:29>

Token_Res81 := Row_Pos57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res81));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Delta)
   then
       Token_Pos81 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos57,
             Expected_Token_Id => Ada_Delta,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos81 := Row_Pos57 + 1;
   end if;
end;

--  END <Token(<WithText Delta>, ) at parser.lkt:1112:29>



Row_Progress6 := 4;

if Token_Pos81 /= No_Token_Index then

   Row_Pos57 := Token_Pos81;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;


--  BEGIN <Cut at ???>
Nobt6 := True;
--  END <Cut at ???>


   Nobt6 := Nobt6;

Row_Progress6 := 5;

if Row_Pos57 /= No_Token_Index then

   Row_Pos57 := Row_Pos57;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;


--  BEGIN <List at parser.lkt:1112:39>

    List_Pos6 := No_Token_Index;



Lst_Cpos6 := Row_Pos57;
Tmp_List6 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:1112:50>

Defer_Res97 :=
   Aggregate_Assoc_Or_Parse1 (Parser, Lst_Cpos6);
Defer_Pos97 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1112:50>


   exit when Defer_Pos97 = No_Token_Index;

   List_Pos6 := Defer_Pos97;
   Lst_Cpos6 := List_Pos6;

   Tmp_List6.Nodes.Append (Defer_Res97);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:1112:67>

Token_Res82 := Lst_Cpos6;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res82));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos82 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos6 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos6,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos82 := Lst_Cpos6 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:1112:67>


      exit when Token_Pos82 = No_Token_Index;

      Lst_Cpos6 := Token_Pos82;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List6.Nodes.Length;
begin
   List_Res6 := Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos57;
      Token_End := (if Lst_Cpos6 = Row_Pos57
                    then Row_Pos57
                    else List_Pos6 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos57, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res6,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res6,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List6.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res6.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List6);

--  END <List at parser.lkt:1112:39>



Row_Progress6 := 6;

if List_Pos6 /= No_Token_Index then

   Row_Pos57 := List_Pos6;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;


--  BEGIN <Token(<WithText BrackClose>, ) at parser.lkt:1112:72>

Token_Res83 := Row_Pos57;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res83));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Brack_Close)
   then
       Token_Pos83 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos57 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos57,
             Expected_Token_Id => Ada_Brack_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos83 := Row_Pos57 + 1;
   end if;
end;

--  END <Token(<WithText BrackClose>, ) at parser.lkt:1112:72>



Row_Progress6 := 7;

if Token_Pos83 /= No_Token_Index then

   Row_Pos57 := Token_Pos83;

else
   Row_Pos57 := No_Token_Index;
   goto Exit_Row57_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row57_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos57 = No_Token_Index and then Nobt6 then

   Row_Pos57 := Parser.Last_Fail.Pos;

   Transform_Has_Failed6 := True;
end if;

if Row_Pos57 /= No_Token_Index then

   Transform_Res47 := Allocate_Bracket_Delta_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res47,
      Kind => Ada_Bracket_Delta_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos57 = Pos
                            then No_Token_Index
                            else Row_Pos57 - 1));

      
      Initialize_Fields_For_Bracket_Delta_Aggregate
        (Self => Transform_Res47,
         Base_Aggregate_F_Ancestor_Expr => Defer_Res96,
         Base_Aggregate_F_Assocs => List_Res6);

         if Defer_Res96 /= null and then Is_Incomplete (Defer_Res96) then
            Transform_Res47.Last_Attempted_Child := 0;
         elsif Defer_Res96 /= null and then not Is_Ghost (Defer_Res96) then
            Transform_Res47.Last_Attempted_Child := -1;
         end if;
         if List_Res6 /= null and then Is_Incomplete (List_Res6) then
            Transform_Res47.Last_Attempted_Child := 0;
         elsif List_Res6 /= null and then not Is_Ghost (List_Res6) then
            Transform_Res47.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed6 then
      Transform_Res47.Last_Attempted_Child :=
         Row_Progress6;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <bracket_aggregate>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos57 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags47);
end if;

--  END <Transform(<CompiledType BareBracketDeltaAggregate>) at parser.lkt:1111:11>

    if Row_Pos57 /= No_Token_Index then
        Or_Pos23 := Row_Pos57;
        Or_Res23 := Transform_Res47;
        goto Exit_Or24;
    end if;
    
--  BEGIN <Transform(<CompiledType BareBracketAggregate>) at parser.lkt:1114:11>

Transform_Diags48 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos58 := Pos;



--  BEGIN <Token(<WithText BrackOpen>, ) at parser.lkt:1115:13>

Token_Res84 := Row_Pos58;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res84));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Brack_Open)
   then
       Token_Pos84 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos58 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos58,
             Expected_Token_Id => Ada_Brack_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos84 := Row_Pos58 + 1;
   end if;
end;

--  END <Token(<WithText BrackOpen>, ) at parser.lkt:1115:13>



Row_Progress7 := 1;

if Token_Pos84 /= No_Token_Index then

   Row_Pos58 := Token_Pos84;

else
   Row_Pos58 := No_Token_Index;
   goto Exit_Row58_0;

end if;


--  BEGIN <Cut at ???>
Nobt7 := True;
--  END <Cut at ???>


   Nobt7 := Nobt7;

Row_Progress7 := 2;

if Row_Pos58 /= No_Token_Index then

   Row_Pos58 := Row_Pos58;

else
   Row_Pos58 := No_Token_Index;
   goto Exit_Row58_0;

end if;


--  BEGIN <Opt at parser.lkt:1115:19>












--  BEGIN <_Extract at parser.lkt:1115:20>

--  BEGIN <_Row at ???>

Row_Pos59 := Row_Pos58;



--  BEGIN <Defer at parser.lkt:1115:25>

Defer_Res98 :=
   Expr_Or_Parse0 (Parser, Row_Pos59);
Defer_Pos98 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1115:25>




if Defer_Pos98 /= No_Token_Index then

   Row_Pos59 := Defer_Pos98;

else
   Row_Pos59 := No_Token_Index;
   goto Exit_Row59_0;

end if;


--  BEGIN <Token(<WithText With>, ) at parser.lkt:1115:30>

Token_Res85 := Row_Pos59;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res85));
begin
   if
      T.Kind /= From_Token_Kind (Ada_With)
   then
       Token_Pos85 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos59 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos59,
             Expected_Token_Id => Ada_With,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos85 := Row_Pos59 + 1;
   end if;
end;

--  END <Token(<WithText With>, ) at parser.lkt:1115:30>




if Token_Pos85 /= No_Token_Index then

   Row_Pos59 := Token_Pos85;

else
   Row_Pos59 := No_Token_Index;
   goto Exit_Row59_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row59_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:1115:20>


if Row_Pos59 = No_Token_Index then

         
   Defer_Res98 := No_Bare_Ada_Node;



       
   Row_Pos59 := Row_Pos58;



end if;

--  END <Opt at parser.lkt:1115:19>



Row_Progress7 := 3;

if Row_Pos59 /= No_Token_Index then

   Row_Pos58 := Row_Pos59;

else
   Row_Pos58 := No_Token_Index;
   goto Exit_Row58_0;

end if;


--  BEGIN <List at parser.lkt:1115:38>

    List_Pos7 := Row_Pos58;



Lst_Cpos7 := Row_Pos58;
Tmp_List7 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:1115:49>

Defer_Res99 :=
   Aggregate_Assoc_Or_Parse1 (Parser, Lst_Cpos7);
Defer_Pos99 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1115:49>


   exit when Defer_Pos99 = No_Token_Index;

   List_Pos7 := Defer_Pos99;
   Lst_Cpos7 := List_Pos7;

   Tmp_List7.Nodes.Append (Defer_Res99);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:1115:66>

Token_Res86 := Lst_Cpos7;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res86));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos86 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos7 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos7,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos86 := Lst_Cpos7 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:1115:66>


      exit when Token_Pos86 = No_Token_Index;

      Lst_Cpos7 := Token_Pos86;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List7.Nodes.Length;
begin
   List_Res7 := Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos58;
      Token_End := (if Lst_Cpos7 = Row_Pos58
                    then Row_Pos58
                    else List_Pos7 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos58, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res7,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res7,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List7.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res7.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List7);

--  END <List at parser.lkt:1115:38>



Row_Progress7 := 4;

if List_Pos7 /= No_Token_Index then

   Row_Pos58 := List_Pos7;

else
   Row_Pos58 := No_Token_Index;
   goto Exit_Row58_0;

end if;


--  BEGIN <Token(<WithText BrackClose>, ) at parser.lkt:1115:71>

Token_Res87 := Row_Pos58;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res87));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Brack_Close)
   then
       Token_Pos87 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos58 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos58,
             Expected_Token_Id => Ada_Brack_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos87 := Row_Pos58 + 1;
   end if;
end;

--  END <Token(<WithText BrackClose>, ) at parser.lkt:1115:71>



Row_Progress7 := 5;

if Token_Pos87 /= No_Token_Index then

   Row_Pos58 := Token_Pos87;

else
   Row_Pos58 := No_Token_Index;
   goto Exit_Row58_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row58_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos58 = No_Token_Index and then Nobt7 then

   Row_Pos58 := Parser.Last_Fail.Pos;

   Transform_Has_Failed7 := True;
end if;

if Row_Pos58 /= No_Token_Index then

   Transform_Res48 := Allocate_Bracket_Aggregate (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res48,
      Kind => Ada_Bracket_Aggregate,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos58 = Pos
                            then No_Token_Index
                            else Row_Pos58 - 1));

      
      Initialize_Fields_For_Bracket_Aggregate
        (Self => Transform_Res48,
         Base_Aggregate_F_Ancestor_Expr => Defer_Res98,
         Base_Aggregate_F_Assocs => List_Res7);

         if Defer_Res98 /= null and then Is_Incomplete (Defer_Res98) then
            Transform_Res48.Last_Attempted_Child := 0;
         elsif Defer_Res98 /= null and then not Is_Ghost (Defer_Res98) then
            Transform_Res48.Last_Attempted_Child := -1;
         end if;
         if List_Res7 /= null and then Is_Incomplete (List_Res7) then
            Transform_Res48.Last_Attempted_Child := 0;
         elsif List_Res7 /= null and then not Is_Ghost (List_Res7) then
            Transform_Res48.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed7 then
      Transform_Res48.Last_Attempted_Child :=
         Row_Progress7;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <bracket_aggregate>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos58 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags48);
end if;

--  END <Transform(<CompiledType BareBracketAggregate>) at parser.lkt:1114:11>

    if Row_Pos58 /= No_Token_Index then
        Or_Pos23 := Row_Pos58;
        Or_Res23 := Transform_Res48;
        goto Exit_Or24;
    end if;
<<Exit_Or24>>

--  END <Or at parser.lkt:1110:26>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Bracket_Aggregate_Or_Parse0_Memo,
      Or_Pos23 /= No_Token_Index,
      Or_Res23,
      Pos,
      Or_Pos23);


   Parser.Current_Pos := Or_Pos23;

   return Or_Res23;
end Bracket_Aggregate_Or_Parse0;

   


function Call_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Call_Stmt
is
   use Bare_Call_Stmt_Memos;

      Row_Pos60 :
            Token_Index
               := No_Token_Index;
      Defer_Pos100 :
            Token_Index
               := No_Token_Index;
      Defer_Res100 :
            Bare_Name
               := No_Bare_Ada_Node;
      Token_Pos88 :
            Token_Index
               := No_Token_Index;
      Token_Res88 :
            Token_Index
               := No_Token_Index;
      Transform_Res49 :
            Bare_Call_Stmt
               := No_Bare_Ada_Node;
      Transform_Diags49 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Call_Stmt_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res49 := M.Instance;
      return Transform_Res49;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res49;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCallStmt>) at parser.lkt:999:18>

Transform_Diags49 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos60 := Pos;



--  BEGIN <Defer at parser.lkt:999:27>

Defer_Res100 :=
   Name_Or_Parse2 (Parser, Row_Pos60);
Defer_Pos100 := Parser.Current_Pos;

--  END <Defer at parser.lkt:999:27>




if Defer_Pos100 /= No_Token_Index then

   Row_Pos60 := Defer_Pos100;

else
   Row_Pos60 := No_Token_Index;
   goto Exit_Row60_0;

end if;


--  BEGIN <Opt at parser.lkt:999:32>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:999:33>

Token_Res88 := Row_Pos60;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res88));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos88 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos60 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos60,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos88 := Row_Pos60 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:999:33>


if Token_Pos88 = No_Token_Index then

         
   Token_Res88 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos60)),
                To_Text ("Missing ';'"));

       
   Token_Pos88 := Row_Pos60;



end if;

--  END <Opt at parser.lkt:999:32>




if Token_Pos88 /= No_Token_Index then

   Row_Pos60 := Token_Pos88;

else
   Row_Pos60 := No_Token_Index;
   goto Exit_Row60_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row60_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos60 /= No_Token_Index then

   Transform_Res49 := Allocate_Call_Stmt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res49,
      Kind => Ada_Call_Stmt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos60 = Pos
                            then No_Token_Index
                            else Row_Pos60 - 1));

      
      Initialize_Fields_For_Call_Stmt
        (Self => Transform_Res49,
         Call_Stmt_F_Call => Defer_Res100);

         if Defer_Res100 /= null and then Is_Incomplete (Defer_Res100) then
            Transform_Res49.Last_Attempted_Child := 0;
         elsif Defer_Res100 /= null and then not Is_Ghost (Defer_Res100) then
            Transform_Res49.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos60 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags49);
end if;

--  END <Transform(<CompiledType BareCallStmt>) at parser.lkt:999:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Call_Stmt_Transform_Parse0_Memo,
      Row_Pos60 /= No_Token_Index,
      Transform_Res49,
      Pos,
      Row_Pos60);


   Parser.Current_Pos := Row_Pos60;

   return Transform_Res49;
end Call_Stmt_Transform_Parse0;

   


function Call_Suffix_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Defer_Pos101 :
            Token_Index
               := No_Token_Index;
      Defer_Res101 :
            Bare_Discrete_Subtype_Indication
               := No_Bare_Ada_Node;
      Defer_Pos102 :
            Token_Index
               := No_Token_Index;
      Defer_Res102 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Lst_Cpos8 :
            Token_Index
               := No_Token_Index;
      Tmp_List8 :
            Free_Parse_List;
      Defer_Pos103 :
            Token_Index
               := No_Token_Index;
      Defer_Res103 :
            Bare_Param_Assoc
               := No_Bare_Ada_Node;
      Token_Pos89 :
            Token_Index
               := No_Token_Index;
      Token_Res89 :
            Token_Index
               := No_Token_Index;
      List_Pos8 :
            Token_Index
               := No_Token_Index;
      List_Res8 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Or_Pos24 :
            Token_Index
               := No_Token_Index;
      Or_Res24 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Call_Suffix_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res24 := M.Instance;
      return Or_Res24;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res24;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1124:20>

Or_Pos24 := No_Token_Index;
Or_Res24 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:1126:11>

Defer_Res101 :=
   Discrete_Subtype_Indication_Transform_Parse0 (Parser, Pos);
Defer_Pos101 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1126:11>

    if Defer_Pos101 /= No_Token_Index then
        Or_Pos24 := Defer_Pos101;
        Or_Res24 := Defer_Res101;
        goto Exit_Or25;
    end if;
    
--  BEGIN <Defer at parser.lkt:1129:11>

Defer_Res102 :=
   Discrete_Range_Or_Parse1 (Parser, Pos);
Defer_Pos102 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1129:11>

    if Defer_Pos102 /= No_Token_Index then
        Or_Pos24 := Defer_Pos102;
        Or_Res24 := Defer_Res102;
        goto Exit_Or25;
    end if;
    
--  BEGIN <List at parser.lkt:1132:11>

    List_Pos8 := No_Token_Index;



Lst_Cpos8 := Pos;
Tmp_List8 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:1132:22>

Defer_Res103 :=
   Param_Assoc_Transform_Parse0 (Parser, Lst_Cpos8);
Defer_Pos103 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1132:22>


   exit when Defer_Pos103 = No_Token_Index;

   List_Pos8 := Defer_Pos103;
   Lst_Cpos8 := List_Pos8;

   Tmp_List8.Nodes.Append (Defer_Res103);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:1132:35>

Token_Res89 := Lst_Cpos8;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res89));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos89 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos8 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos8,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos89 := Lst_Cpos8 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:1132:35>


      exit when Token_Pos89 = No_Token_Index;

      Lst_Cpos8 := Token_Pos89;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List8.Nodes.Length;
begin
   List_Res8 := Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos8 = Pos
                    then Pos
                    else List_Pos8 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res8,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res8,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List8.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res8.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List8);

--  END <List at parser.lkt:1132:11>

    if List_Pos8 /= No_Token_Index then
        Or_Pos24 := List_Pos8;
        Or_Res24 := List_Res8;
        goto Exit_Or25;
    end if;
<<Exit_Or25>>

--  END <Or at parser.lkt:1124:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Call_Suffix_Or_Parse0_Memo,
      Or_Pos24 /= No_Token_Index,
      Or_Res24,
      Pos,
      Or_Pos24);


   Parser.Current_Pos := Or_Pos24;

   return Or_Res24;
end Call_Suffix_Or_Parse0;

   


function Case_Alt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Stmt_Alternative
is
   use Bare_Case_Stmt_Alternative_Memos;

      Nobt8 :
            Boolean
               := False;
      Row_Pos61 :
            Token_Index
               := No_Token_Index;
      Token_Pos90 :
            Token_Index
               := No_Token_Index;
      Token_Res90 :
            Token_Index
               := No_Token_Index;
      Defer_Pos104 :
            Token_Index
               := No_Token_Index;
      Defer_Res104 :
            Bare_Alternatives_List
               := No_Bare_Ada_Node;
      Token_Pos91 :
            Token_Index
               := No_Token_Index;
      Token_Res91 :
            Token_Index
               := No_Token_Index;
      Defer_Pos105 :
            Token_Index
               := No_Token_Index;
      Defer_Res105 :
            Bare_Stmt_List
               := No_Bare_Ada_Node;
      Row_Progress8 :
            Integer
               := 0;
      Transform_Res50 :
            Bare_Case_Stmt_Alternative
               := No_Bare_Ada_Node;
      Transform_Has_Failed8 :
            Boolean
               := False;
      Transform_Diags50 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Case_Alt_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res50 := M.Instance;
      return Transform_Res50;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res50;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCaseStmtAlternative>) at parser.lkt:844:17>

Transform_Diags50 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos61 := Pos;



--  BEGIN <Token(<WithText When>, ) at parser.lkt:845:9>

Token_Res90 := Row_Pos61;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res90));
begin
   if
      T.Kind /= From_Token_Kind (Ada_When)
   then
       Token_Pos90 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos61 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos61,
             Expected_Token_Id => Ada_When,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos90 := Row_Pos61 + 1;
   end if;
end;

--  END <Token(<WithText When>, ) at parser.lkt:845:9>



Row_Progress8 := 1;

if Token_Pos90 /= No_Token_Index then

   Row_Pos61 := Token_Pos90;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;


--  BEGIN <Cut at ???>
Nobt8 := True;
--  END <Cut at ???>


   Nobt8 := Nobt8;

Row_Progress8 := 2;

if Row_Pos61 /= No_Token_Index then

   Row_Pos61 := Row_Pos61;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;


--  BEGIN <Defer at parser.lkt:845:18>

Defer_Res104 :=
   Choice_List_List_Parse0 (Parser, Row_Pos61);
Defer_Pos104 := Parser.Current_Pos;

--  END <Defer at parser.lkt:845:18>



Row_Progress8 := 3;

if Defer_Pos104 /= No_Token_Index then

   Row_Pos61 := Defer_Pos104;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;


--  BEGIN <Token(<WithText Arrow>, ) at parser.lkt:845:30>

Token_Res91 := Row_Pos61;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res91));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos91 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos61 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos61,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos91 := Row_Pos61 + 1;
   end if;
end;

--  END <Token(<WithText Arrow>, ) at parser.lkt:845:30>



Row_Progress8 := 4;

if Token_Pos91 /= No_Token_Index then

   Row_Pos61 := Token_Pos91;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;


        
--  BEGIN <DontSkip at parser.lkt:845:35>

        PP.Dont_Skip.Append (Dontskip_Case_Alt0_Extract_Parse0'Access);
        
--  BEGIN <Defer at parser.lkt:845:35>

Defer_Res105 :=
   Stmts_List_Parse0 (Parser, Row_Pos61);
Defer_Pos105 := Parser.Current_Pos;

--  END <Defer at parser.lkt:845:35>

        PP.Dont_Skip.Delete_Last;
        
--  END <DontSkip at parser.lkt:845:35>

        


Row_Progress8 := 5;

if Defer_Pos105 /= No_Token_Index then

   Row_Pos61 := Defer_Pos105;

else
   Row_Pos61 := No_Token_Index;
   goto Exit_Row61_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row61_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos61 = No_Token_Index and then Nobt8 then

   Row_Pos61 := Parser.Last_Fail.Pos;

   Transform_Has_Failed8 := True;
end if;

if Row_Pos61 /= No_Token_Index then

   Transform_Res50 := Allocate_Case_Stmt_Alternative (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res50,
      Kind => Ada_Case_Stmt_Alternative,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos61 = Pos
                            then No_Token_Index
                            else Row_Pos61 - 1));

      
      Initialize_Fields_For_Case_Stmt_Alternative
        (Self => Transform_Res50,
         Case_Stmt_Alternative_F_Choices => Defer_Res104,
         Case_Stmt_Alternative_F_Stmts => Defer_Res105);

         if Defer_Res104 /= null and then Is_Incomplete (Defer_Res104) then
            Transform_Res50.Last_Attempted_Child := 0;
         elsif Defer_Res104 /= null and then not Is_Ghost (Defer_Res104) then
            Transform_Res50.Last_Attempted_Child := -1;
         end if;
         if Defer_Res105 /= null and then Is_Incomplete (Defer_Res105) then
            Transform_Res50.Last_Attempted_Child := 0;
         elsif Defer_Res105 /= null and then not Is_Ghost (Defer_Res105) then
            Transform_Res50.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed8 then
      Transform_Res50.Last_Attempted_Child :=
         Row_Progress8;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <case_alt>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos61 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags50);
end if;

--  END <Transform(<CompiledType BareCaseStmtAlternative>) at parser.lkt:844:17>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Case_Alt_Transform_Parse0_Memo,
      Row_Pos61 /= No_Token_Index,
      Transform_Res50,
      Pos,
      Row_Pos61);


   Parser.Current_Pos := Row_Pos61;

   return Transform_Res50;
end Case_Alt_Transform_Parse0;

   


function Case_Expr_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr
is
   use Bare_Case_Expr_Memos;

      Row_Pos62 :
            Token_Index
               := No_Token_Index;
      Token_Pos92 :
            Token_Index
               := No_Token_Index;
      Token_Res92 :
            Token_Index
               := No_Token_Index;
      Defer_Pos106 :
            Token_Index
               := No_Token_Index;
      Defer_Res106 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos93 :
            Token_Index
               := No_Token_Index;
      Token_Res93 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos9 :
            Token_Index
               := No_Token_Index;
      Tmp_List9 :
            Free_Parse_List;
      Defer_Pos107 :
            Token_Index
               := No_Token_Index;
      Defer_Res107 :
            Bare_Case_Expr_Alternative
               := No_Bare_Ada_Node;
      Token_Pos94 :
            Token_Index
               := No_Token_Index;
      Token_Res94 :
            Token_Index
               := No_Token_Index;
      List_Pos9 :
            Token_Index
               := No_Token_Index;
      List_Res9 :
            Bare_Case_Expr_Alternative_List
               := No_Bare_Ada_Node;
      Transform_Res51 :
            Bare_Case_Expr
               := No_Bare_Ada_Node;
      Transform_Diags51 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Case_Expr_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res51 := M.Instance;
      return Transform_Res51;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res51;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCaseExpr>) at parser.lkt:1064:18>

Transform_Diags51 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos62 := Pos;



--  BEGIN <Token(<WithText Case>, ) at parser.lkt:1064:27>

Token_Res92 := Row_Pos62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res92));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Case)
   then
       Token_Pos92 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos62,
             Expected_Token_Id => Ada_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos92 := Row_Pos62 + 1;
   end if;
end;

--  END <Token(<WithText Case>, ) at parser.lkt:1064:27>




if Token_Pos92 /= No_Token_Index then

   Row_Pos62 := Token_Pos92;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;


--  BEGIN <Defer at parser.lkt:1064:34>

Defer_Res106 :=
   Expr_Or_Parse0 (Parser, Row_Pos62);
Defer_Pos106 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1064:34>




if Defer_Pos106 /= No_Token_Index then

   Row_Pos62 := Defer_Pos106;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;


--  BEGIN <Token(<WithText Is>, ) at parser.lkt:1064:39>

Token_Res93 := Row_Pos62;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res93));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Is)
   then
       Token_Pos93 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos62 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos62,
             Expected_Token_Id => Ada_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos93 := Row_Pos62 + 1;
   end if;
end;

--  END <Token(<WithText Is>, ) at parser.lkt:1064:39>




if Token_Pos93 /= No_Token_Index then

   Row_Pos62 := Token_Pos93;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;


--  BEGIN <List at parser.lkt:1064:44>

    List_Pos9 := No_Token_Index;



Lst_Cpos9 := Row_Pos62;
Tmp_List9 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:1064:50>

Defer_Res107 :=
   Case_Expr_Alt_Transform_Parse0 (Parser, Lst_Cpos9);
Defer_Pos107 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1064:50>


   exit when Defer_Pos107 = No_Token_Index;

   List_Pos9 := Defer_Pos107;
   Lst_Cpos9 := List_Pos9;

   Tmp_List9.Nodes.Append (Defer_Res107);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:1064:65>

Token_Res94 := Lst_Cpos9;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res94));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos94 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos9 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos9,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos94 := Lst_Cpos9 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:1064:65>


      exit when Token_Pos94 = No_Token_Index;

      Lst_Cpos9 := Token_Pos94;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List9.Nodes.Length;
begin
   List_Res9 := Allocate_Case_Expr_Alternative_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos62;
      Token_End := (if Lst_Cpos9 = Row_Pos62
                    then Row_Pos62
                    else List_Pos9 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos62, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res9,
      Kind              => Ada_Case_Expr_Alternative_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res9,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List9.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res9.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List9);

--  END <List at parser.lkt:1064:44>




if List_Pos9 /= No_Token_Index then

   Row_Pos62 := List_Pos9;

else
   Row_Pos62 := No_Token_Index;
   goto Exit_Row62_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row62_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos62 /= No_Token_Index then

   Transform_Res51 := Allocate_Case_Expr (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res51,
      Kind => Ada_Case_Expr,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos62 = Pos
                            then No_Token_Index
                            else Row_Pos62 - 1));

      
      Initialize_Fields_For_Case_Expr
        (Self => Transform_Res51,
         Case_Expr_F_Expr => Defer_Res106,
         Case_Expr_F_Cases => List_Res9);

         if Defer_Res106 /= null and then Is_Incomplete (Defer_Res106) then
            Transform_Res51.Last_Attempted_Child := 0;
         elsif Defer_Res106 /= null and then not Is_Ghost (Defer_Res106) then
            Transform_Res51.Last_Attempted_Child := -1;
         end if;
         if List_Res9 /= null and then Is_Incomplete (List_Res9) then
            Transform_Res51.Last_Attempted_Child := 0;
         elsif List_Res9 /= null and then not Is_Ghost (List_Res9) then
            Transform_Res51.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos62 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags51);
end if;

--  END <Transform(<CompiledType BareCaseExpr>) at parser.lkt:1064:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Case_Expr_Transform_Parse0_Memo,
      Row_Pos62 /= No_Token_Index,
      Transform_Res51,
      Pos,
      Row_Pos62);


   Parser.Current_Pos := Row_Pos62;

   return Transform_Res51;
end Case_Expr_Transform_Parse0;

   


function Case_Expr_Alt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Expr_Alternative
is
   use Bare_Case_Expr_Alternative_Memos;

      Row_Pos63 :
            Token_Index
               := No_Token_Index;
      Token_Pos95 :
            Token_Index
               := No_Token_Index;
      Token_Res95 :
            Token_Index
               := No_Token_Index;
      Defer_Pos108 :
            Token_Index
               := No_Token_Index;
      Defer_Res108 :
            Bare_Alternatives_List
               := No_Bare_Ada_Node;
      Token_Pos96 :
            Token_Index
               := No_Token_Index;
      Token_Res96 :
            Token_Index
               := No_Token_Index;
      Defer_Pos109 :
            Token_Index
               := No_Token_Index;
      Defer_Res109 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Transform_Res52 :
            Bare_Case_Expr_Alternative
               := No_Bare_Ada_Node;
      Transform_Diags52 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Case_Expr_Alt_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res52 := M.Instance;
      return Transform_Res52;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res52;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCaseExprAlternative>) at parser.lkt:1065:22>

Transform_Diags52 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos63 := Pos;



--  BEGIN <Token(<WithText When>, ) at parser.lkt:1065:42>

Token_Res95 := Row_Pos63;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res95));
begin
   if
      T.Kind /= From_Token_Kind (Ada_When)
   then
       Token_Pos95 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos63 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos63,
             Expected_Token_Id => Ada_When,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos95 := Row_Pos63 + 1;
   end if;
end;

--  END <Token(<WithText When>, ) at parser.lkt:1065:42>




if Token_Pos95 /= No_Token_Index then

   Row_Pos63 := Token_Pos95;

else
   Row_Pos63 := No_Token_Index;
   goto Exit_Row63_0;

end if;


--  BEGIN <Defer at parser.lkt:1065:49>

Defer_Res108 :=
   Choice_List_List_Parse0 (Parser, Row_Pos63);
Defer_Pos108 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1065:49>




if Defer_Pos108 /= No_Token_Index then

   Row_Pos63 := Defer_Pos108;

else
   Row_Pos63 := No_Token_Index;
   goto Exit_Row63_0;

end if;


--  BEGIN <Token(<WithText Arrow>, ) at parser.lkt:1065:61>

Token_Res96 := Row_Pos63;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res96));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos96 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos63 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos63,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos96 := Row_Pos63 + 1;
   end if;
end;

--  END <Token(<WithText Arrow>, ) at parser.lkt:1065:61>




if Token_Pos96 /= No_Token_Index then

   Row_Pos63 := Token_Pos96;

else
   Row_Pos63 := No_Token_Index;
   goto Exit_Row63_0;

end if;


--  BEGIN <Defer at parser.lkt:1065:66>

Defer_Res109 :=
   Expr_Or_Parse0 (Parser, Row_Pos63);
Defer_Pos109 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1065:66>




if Defer_Pos109 /= No_Token_Index then

   Row_Pos63 := Defer_Pos109;

else
   Row_Pos63 := No_Token_Index;
   goto Exit_Row63_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row63_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos63 /= No_Token_Index then

   Transform_Res52 := Allocate_Case_Expr_Alternative (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res52,
      Kind => Ada_Case_Expr_Alternative,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos63 = Pos
                            then No_Token_Index
                            else Row_Pos63 - 1));

      
      Initialize_Fields_For_Case_Expr_Alternative
        (Self => Transform_Res52,
         Case_Expr_Alternative_F_Choices => Defer_Res108,
         Case_Expr_Alternative_F_Expr => Defer_Res109);

         if Defer_Res108 /= null and then Is_Incomplete (Defer_Res108) then
            Transform_Res52.Last_Attempted_Child := 0;
         elsif Defer_Res108 /= null and then not Is_Ghost (Defer_Res108) then
            Transform_Res52.Last_Attempted_Child := -1;
         end if;
         if Defer_Res109 /= null and then Is_Incomplete (Defer_Res109) then
            Transform_Res52.Last_Attempted_Child := 0;
         elsif Defer_Res109 /= null and then not Is_Ghost (Defer_Res109) then
            Transform_Res52.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos63 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags52);
end if;

--  END <Transform(<CompiledType BareCaseExprAlternative>) at parser.lkt:1065:22>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Case_Expr_Alt_Transform_Parse0_Memo,
      Row_Pos63 /= No_Token_Index,
      Transform_Res52,
      Pos,
      Row_Pos63);


   Parser.Current_Pos := Row_Pos63;

   return Transform_Res52;
end Case_Expr_Alt_Transform_Parse0;

   


function Case_Stmt_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Case_Stmt
is
   use Bare_Case_Stmt_Memos;

      Nobt9 :
            Boolean
               := False;
      Row_Pos64 :
            Token_Index
               := No_Token_Index;
      Token_Pos97 :
            Token_Index
               := No_Token_Index;
      Token_Res97 :
            Token_Index
               := No_Token_Index;
      Defer_Pos110 :
            Token_Index
               := No_Token_Index;
      Defer_Res110 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Token_Pos98 :
            Token_Index
               := No_Token_Index;
      Token_Res98 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos10 :
            Token_Index
               := No_Token_Index;
      Tmp_List10 :
            Free_Parse_List;
      Defer_Pos111 :
            Token_Index
               := No_Token_Index;
      Defer_Res111 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      List_Pos10 :
            Token_Index
               := No_Token_Index;
      List_Res10 :
            Bare_Pragma_Node_List
               := No_Bare_Ada_Node;
      Lst_Cpos11 :
            Token_Index
               := No_Token_Index;
      Tmp_List11 :
            Free_Parse_List;
      Defer_Pos112 :
            Token_Index
               := No_Token_Index;
      Defer_Res112 :
            Bare_Case_Stmt_Alternative
               := No_Bare_Ada_Node;
      List_Pos11 :
            Token_Index
               := No_Token_Index;
      List_Res11 :
            Bare_Case_Stmt_Alternative_List
               := No_Bare_Ada_Node;
      Token_Pos99 :
            Token_Index
               := No_Token_Index;
      Token_Res99 :
            Token_Index
               := No_Token_Index;
      Token_Pos100 :
            Token_Index
               := No_Token_Index;
      Token_Res100 :
            Token_Index
               := No_Token_Index;
      Token_Pos101 :
            Token_Index
               := No_Token_Index;
      Token_Res101 :
            Token_Index
               := No_Token_Index;
      Row_Progress9 :
            Integer
               := 0;
      Transform_Res53 :
            Bare_Case_Stmt
               := No_Bare_Ada_Node;
      Transform_Has_Failed9 :
            Boolean
               := False;
      Transform_Diags53 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Case_Stmt_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res53 := M.Instance;
      return Transform_Res53;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res53;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCaseStmt>) at parser.lkt:847:18>

Transform_Diags53 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos64 := Pos;



--  BEGIN <Token(<WithText Case>, ) at parser.lkt:848:9>

Token_Res97 := Row_Pos64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res97));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Case)
   then
       Token_Pos97 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos64,
             Expected_Token_Id => Ada_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos97 := Row_Pos64 + 1;
   end if;
end;

--  END <Token(<WithText Case>, ) at parser.lkt:848:9>



Row_Progress9 := 1;

if Token_Pos97 /= No_Token_Index then

   Row_Pos64 := Token_Pos97;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <Cut at ???>
Nobt9 := True;
--  END <Cut at ???>


   Nobt9 := Nobt9;

Row_Progress9 := 2;

if Row_Pos64 /= No_Token_Index then

   Row_Pos64 := Row_Pos64;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <Defer at parser.lkt:848:18>

Defer_Res110 :=
   Expr_Or_Parse0 (Parser, Row_Pos64);
Defer_Pos110 := Parser.Current_Pos;

--  END <Defer at parser.lkt:848:18>



Row_Progress9 := 3;

if Defer_Pos110 /= No_Token_Index then

   Row_Pos64 := Defer_Pos110;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <Token(<WithText Is>, ) at parser.lkt:848:23>

Token_Res98 := Row_Pos64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res98));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Is)
   then
       Token_Pos98 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos64,
             Expected_Token_Id => Ada_Is,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos98 := Row_Pos64 + 1;
   end if;
end;

--  END <Token(<WithText Is>, ) at parser.lkt:848:23>



Row_Progress9 := 4;

if Token_Pos98 /= No_Token_Index then

   Row_Pos64 := Token_Pos98;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <List at parser.lkt:848:28>

    List_Pos10 := Row_Pos64;



Lst_Cpos10 := Row_Pos64;
Tmp_List10 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:848:34>

Defer_Res111 :=
   Pragma_Transform_Parse0 (Parser, Lst_Cpos10);
Defer_Pos111 := Parser.Current_Pos;

--  END <Defer at parser.lkt:848:34>


   exit when Defer_Pos111 = No_Token_Index;

   List_Pos10 := Defer_Pos111;
   Lst_Cpos10 := List_Pos10;

   Tmp_List10.Nodes.Append (Defer_Res111);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List10.Nodes.Length;
begin
   List_Res10 := Allocate_Pragma_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos64;
      Token_End := (if Lst_Cpos10 = Row_Pos64
                    then Row_Pos64
                    else List_Pos10 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos64, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res10,
      Kind              => Ada_Pragma_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res10,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List10.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res10.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List10);

--  END <List at parser.lkt:848:28>



Row_Progress9 := 5;

if List_Pos10 /= No_Token_Index then

   Row_Pos64 := List_Pos10;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <List at parser.lkt:848:42>

    List_Pos11 := No_Token_Index;



Lst_Cpos11 := Row_Pos64;
Tmp_List11 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:848:48>

Defer_Res112 :=
   Case_Alt_Transform_Parse0 (Parser, Lst_Cpos11);
Defer_Pos112 := Parser.Current_Pos;

--  END <Defer at parser.lkt:848:48>


   exit when Defer_Pos112 = No_Token_Index;

   List_Pos11 := Defer_Pos112;
   Lst_Cpos11 := List_Pos11;

   Tmp_List11.Nodes.Append (Defer_Res112);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List11.Nodes.Length;
begin
   List_Res11 := Allocate_Case_Stmt_Alternative_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos64;
      Token_End := (if Lst_Cpos11 = Row_Pos64
                    then Row_Pos64
                    else List_Pos11 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos64, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res11,
      Kind              => Ada_Case_Stmt_Alternative_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res11,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List11.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res11.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List11);

--  END <List at parser.lkt:848:42>



Row_Progress9 := 6;

if List_Pos11 /= No_Token_Index then

   Row_Pos64 := List_Pos11;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <Token(<WithText End>, ) at parser.lkt:848:58>

Token_Res99 := Row_Pos64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res99));
begin
   if
      T.Kind /= From_Token_Kind (Ada_End)
   then
       Token_Pos99 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos64,
             Expected_Token_Id => Ada_End,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos99 := Row_Pos64 + 1;
   end if;
end;

--  END <Token(<WithText End>, ) at parser.lkt:848:58>



Row_Progress9 := 7;

if Token_Pos99 /= No_Token_Index then

   Row_Pos64 := Token_Pos99;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <Token(<WithText Case>, ) at parser.lkt:848:64>

Token_Res100 := Row_Pos64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res100));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Case)
   then
       Token_Pos100 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos64,
             Expected_Token_Id => Ada_Case,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos100 := Row_Pos64 + 1;
   end if;
end;

--  END <Token(<WithText Case>, ) at parser.lkt:848:64>



Row_Progress9 := 8;

if Token_Pos100 /= No_Token_Index then

   Row_Pos64 := Token_Pos100;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;


--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:848:71>

Token_Res101 := Row_Pos64;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res101));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos101 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos64 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos64,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos101 := Row_Pos64 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:848:71>



Row_Progress9 := 9;

if Token_Pos101 /= No_Token_Index then

   Row_Pos64 := Token_Pos101;

else
   Row_Pos64 := No_Token_Index;
   goto Exit_Row64_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row64_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos64 = No_Token_Index and then Nobt9 then

   Row_Pos64 := Parser.Last_Fail.Pos;

   Transform_Has_Failed9 := True;
end if;

if Row_Pos64 /= No_Token_Index then

   Transform_Res53 := Allocate_Case_Stmt (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res53,
      Kind => Ada_Case_Stmt,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos64 = Pos
                            then No_Token_Index
                            else Row_Pos64 - 1));

      
      Initialize_Fields_For_Case_Stmt
        (Self => Transform_Res53,
         Case_Stmt_F_Expr => Defer_Res110,
         Case_Stmt_F_Pragmas => List_Res10,
         Case_Stmt_F_Alternatives => List_Res11);

         if Defer_Res110 /= null and then Is_Incomplete (Defer_Res110) then
            Transform_Res53.Last_Attempted_Child := 0;
         elsif Defer_Res110 /= null and then not Is_Ghost (Defer_Res110) then
            Transform_Res53.Last_Attempted_Child := -1;
         end if;
         if List_Res10 /= null and then Is_Incomplete (List_Res10) then
            Transform_Res53.Last_Attempted_Child := 0;
         elsif List_Res10 /= null and then not Is_Ghost (List_Res10) then
            Transform_Res53.Last_Attempted_Child := -1;
         end if;
         if List_Res11 /= null and then Is_Incomplete (List_Res11) then
            Transform_Res53.Last_Attempted_Child := 0;
         elsif List_Res11 /= null and then not Is_Ghost (List_Res11) then
            Transform_Res53.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed9 then
      Transform_Res53.Last_Attempted_Child :=
         Row_Progress9;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <case_stmt>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos64 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags53);
end if;

--  END <Transform(<CompiledType BareCaseStmt>) at parser.lkt:847:18>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Case_Stmt_Transform_Parse0_Memo,
      Row_Pos64 /= No_Token_Index,
      Transform_Res53,
      Pos,
      Row_Pos64);


   Parser.Current_Pos := Row_Pos64;

   return Transform_Res53;
end Case_Stmt_Transform_Parse0;

   


function Char_Literal_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Char_Literal
is
   use Bare_Char_Literal_Memos;

      Row_Pos65 :
            Token_Index
               := No_Token_Index;
      Token_Pos102 :
            Token_Index
               := No_Token_Index;
      Token_Res102 :
            Token_Index
               := No_Token_Index;
      Transform_Res54 :
            Bare_Char_Literal
               := No_Bare_Ada_Node;
      Transform_Diags54 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Char_Literal_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res54 := M.Instance;
      return Transform_Res54;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res54;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCharLiteral>) at parser.lkt:1025:21>

Transform_Diags54 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos65 := Pos;



--  BEGIN <Token(<WithSymbol Char>, ) at parser.lkt:1025:33>

Token_Res102 := Row_Pos65;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res102));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Char)
   then
       Token_Pos102 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos65 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos65,
             Expected_Token_Id => Ada_Char,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos102 := Row_Pos65 + 1;
   end if;
end;

--  END <Token(<WithSymbol Char>, ) at parser.lkt:1025:33>




if Token_Pos102 /= No_Token_Index then

   Row_Pos65 := Token_Pos102;

else
   Row_Pos65 := No_Token_Index;
   goto Exit_Row65_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row65_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos65 /= No_Token_Index then

   Transform_Res54 := Allocate_Char_Literal (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res54,
      Kind => Ada_Char_Literal,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos65 = Pos
                            then No_Token_Index
                            else Row_Pos65 - 1));

      
      Initialize_Fields_For_Char_Literal
        (Self => Transform_Res54);



elsif Row_Pos65 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags54);
end if;

--  END <Transform(<CompiledType BareCharLiteral>) at parser.lkt:1025:21>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Char_Literal_Transform_Parse0_Memo,
      Row_Pos65 /= No_Token_Index,
      Transform_Res54,
      Pos,
      Row_Pos65);


   Parser.Current_Pos := Row_Pos65;

   return Transform_Res54;
end Char_Literal_Transform_Parse0;

   


function Choice_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Defer_Pos113 :
            Token_Index
               := No_Token_Index;
      Defer_Res113 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos114 :
            Token_Index
               := No_Token_Index;
      Defer_Res114 :
            Bare_Discrete_Subtype_Indication
               := No_Bare_Ada_Node;
      Defer_Pos115 :
            Token_Index
               := No_Token_Index;
      Defer_Res115 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos116 :
            Token_Index
               := No_Token_Index;
      Defer_Res116 :
            Bare_Others_Designator
               := No_Bare_Ada_Node;
      Or_Pos25 :
            Token_Index
               := No_Token_Index;
      Or_Res25 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Choice_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res25 := M.Instance;
      return Or_Res25;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res25;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:1290:15>

Or_Pos25 := No_Token_Index;
Or_Res25 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:1291:11>

Defer_Res113 :=
   Discrete_Range_Or_Parse1 (Parser, Pos);
Defer_Pos113 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1291:11>

    if Defer_Pos113 /= No_Token_Index then
        Or_Pos25 := Defer_Pos113;
        Or_Res25 := Defer_Res113;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Defer at parser.lkt:1292:11>

Defer_Res114 :=
   Discrete_Subtype_Indication_Transform_Parse0 (Parser, Pos);
Defer_Pos114 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1292:11>

    if Defer_Pos114 /= No_Token_Index then
        Or_Pos25 := Defer_Pos114;
        Or_Res25 := Defer_Res114;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Defer at parser.lkt:1293:11>

Defer_Res115 :=
   Expr_Or_Parse0 (Parser, Pos);
Defer_Pos115 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1293:11>

    if Defer_Pos115 /= No_Token_Index then
        Or_Pos25 := Defer_Pos115;
        Or_Res25 := Defer_Res115;
        goto Exit_Or26;
    end if;
    
--  BEGIN <Defer at parser.lkt:1294:11>

Defer_Res116 :=
   Others_Designator_Transform_Parse0 (Parser, Pos);
Defer_Pos116 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1294:11>

    if Defer_Pos116 /= No_Token_Index then
        Or_Pos25 := Defer_Pos116;
        Or_Res25 := Defer_Res116;
        goto Exit_Or26;
    end if;
<<Exit_Or26>>

--  END <Or at parser.lkt:1290:15>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Choice_Or_Parse0_Memo,
      Or_Pos25 /= No_Token_Index,
      Or_Res25,
      Pos,
      Or_Pos25);


   Parser.Current_Pos := Or_Pos25;

   return Or_Res25;
end Choice_Or_Parse0;

   


function Choice_List_List_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Alternatives_List
is
   use Bare_Alternatives_List_Memos;

      Lst_Cpos12 :
            Token_Index
               := No_Token_Index;
      Tmp_List12 :
            Free_Parse_List;
      Defer_Pos117 :
            Token_Index
               := No_Token_Index;
      Defer_Res117 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Token_Pos103 :
            Token_Index
               := No_Token_Index;
      Token_Res103 :
            Token_Index
               := No_Token_Index;
      List_Pos12 :
            Token_Index
               := No_Token_Index;
      List_Res12 :
            Bare_Alternatives_List
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Choice_List_List_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      List_Res12 := M.Instance;
      return List_Res12;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return List_Res12;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <List at parser.lkt:1296:20>

    List_Pos12 := No_Token_Index;



Lst_Cpos12 := Pos;
Tmp_List12 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:1296:38>

Defer_Res117 :=
   Choice_Or_Parse0 (Parser, Lst_Cpos12);
Defer_Pos117 := Parser.Current_Pos;

--  END <Defer at parser.lkt:1296:38>


   exit when Defer_Pos117 = No_Token_Index;

   List_Pos12 := Defer_Pos117;
   Lst_Cpos12 := List_Pos12;

   Tmp_List12.Nodes.Append (Defer_Res117);

      
--  BEGIN <Token(<WithText Pipe>, ) at parser.lkt:1296:46>

Token_Res103 := Lst_Cpos12;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res103));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Pipe)
   then
       Token_Pos103 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos12 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos12,
             Expected_Token_Id => Ada_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos103 := Lst_Cpos12 + 1;
   end if;
end;

--  END <Token(<WithText Pipe>, ) at parser.lkt:1296:46>


      exit when Token_Pos103 = No_Token_Index;

      Lst_Cpos12 := Token_Pos103;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List12.Nodes.Length;
begin
   List_Res12 := Allocate_Alternatives_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Pos;
      Token_End := (if Lst_Cpos12 = Pos
                    then Pos
                    else List_Pos12 - 1);

   else
      Token_Start := Token_Index'Max (Pos, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res12,
      Kind              => Ada_Alternatives_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res12,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List12.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res12.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List12);

--  END <List at parser.lkt:1296:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Choice_List_List_Parse0_Memo,
      List_Pos12 /= No_Token_Index,
      List_Res12,
      Pos,
      List_Pos12);


   Parser.Current_Pos := List_Pos12;

   return List_Res12;
end Choice_List_List_Parse0;

   


function Compilation_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Row_Pos66 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos13 :
            Token_Index
               := No_Token_Index;
      Tmp_List13 :
            Free_Parse_List;
      Defer_Pos118 :
            Token_Index
               := No_Token_Index;
      Defer_Res118 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      List_Pos13 :
            Token_Index
               := No_Token_Index;
      List_Res13 :
            Bare_Pragma_Node_List
               := No_Bare_Ada_Node;
      Token_Pos104 :
            Token_Index
               := No_Token_Index;
      Token_Res104 :
            Token_Index
               := No_Token_Index;
      Row_Pos67 :
            Token_Index
               := No_Token_Index;
      Defer_Pos119 :
            Token_Index
               := No_Token_Index;
      Defer_Res119 :
            Bare_Compilation_Unit
               := No_Bare_Ada_Node;
      Token_Pos105 :
            Token_Index
               := No_Token_Index;
      Token_Res105 :
            Token_Index
               := No_Token_Index;
      Row_Pos68 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos14 :
            Token_Index
               := No_Token_Index;
      Tmp_List14 :
            Free_Parse_List;
      Defer_Pos120 :
            Token_Index
               := No_Token_Index;
      Defer_Res120 :
            Bare_Compilation_Unit
               := No_Bare_Ada_Node;
      List_Pos14 :
            Token_Index
               := No_Token_Index;
      List_Res14 :
            Bare_Compilation_Unit_List
               := No_Bare_Ada_Node;
      Token_Pos106 :
            Token_Index
               := No_Token_Index;
      Token_Res106 :
            Token_Index
               := No_Token_Index;
      Or_Pos26 :
            Token_Index
               := No_Token_Index;
      Or_Res26 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Compilation_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res26 := M.Instance;
      return Or_Res26;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res26;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:723:20>

Or_Pos26 := No_Token_Index;
Or_Res26 := No_Bare_Ada_Node;
    
--  BEGIN <_Extract at parser.lkt:725:11>

--  BEGIN <_Row at ???>

Row_Pos66 := Pos;



--  BEGIN <List at parser.lkt:725:16>

    List_Pos13 := No_Token_Index;



Lst_Cpos13 := Row_Pos66;
Tmp_List13 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:725:22>

Defer_Res118 :=
   Pragma_Transform_Parse0 (Parser, Lst_Cpos13);
Defer_Pos118 := Parser.Current_Pos;

--  END <Defer at parser.lkt:725:22>


   exit when Defer_Pos118 = No_Token_Index;

   List_Pos13 := Defer_Pos118;
   Lst_Cpos13 := List_Pos13;

   Tmp_List13.Nodes.Append (Defer_Res118);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List13.Nodes.Length;
begin
   List_Res13 := Allocate_Pragma_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos66;
      Token_End := (if Lst_Cpos13 = Row_Pos66
                    then Row_Pos66
                    else List_Pos13 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos66, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res13,
      Kind              => Ada_Pragma_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res13,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List13.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res13.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List13);

--  END <List at parser.lkt:725:16>




if List_Pos13 /= No_Token_Index then

   Row_Pos66 := List_Pos13;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;


--  BEGIN <Token(<WithText Termination>, ) at parser.lkt:725:30>

Token_Res104 := Row_Pos66;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res104));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Termination)
   then
       Token_Pos104 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos66 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos66,
             Expected_Token_Id => Ada_Termination,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos104 := Row_Pos66;
   end if;
end;

--  END <Token(<WithText Termination>, ) at parser.lkt:725:30>




if Token_Pos104 /= No_Token_Index then

   Row_Pos66 := Token_Pos104;

else
   Row_Pos66 := No_Token_Index;
   goto Exit_Row66_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row66_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:725:11>

    if Row_Pos66 /= No_Token_Index then
        Or_Pos26 := Row_Pos66;
        Or_Res26 := List_Res13;
        goto Exit_Or27;
    end if;
    
--  BEGIN <_Extract at parser.lkt:728:11>

--  BEGIN <_Row at ???>

Row_Pos67 := Pos;



--  BEGIN <Defer at parser.lkt:728:16>

Defer_Res119 :=
   Compilation_Unit_Transform_Parse0 (Parser, Row_Pos67);
Defer_Pos119 := Parser.Current_Pos;

--  END <Defer at parser.lkt:728:16>




if Defer_Pos119 /= No_Token_Index then

   Row_Pos67 := Defer_Pos119;

else
   Row_Pos67 := No_Token_Index;
   goto Exit_Row67_0;

end if;


--  BEGIN <Token(<WithText Termination>, ) at parser.lkt:728:33>

Token_Res105 := Row_Pos67;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res105));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Termination)
   then
       Token_Pos105 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos67 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos67,
             Expected_Token_Id => Ada_Termination,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos105 := Row_Pos67;
   end if;
end;

--  END <Token(<WithText Termination>, ) at parser.lkt:728:33>




if Token_Pos105 /= No_Token_Index then

   Row_Pos67 := Token_Pos105;

else
   Row_Pos67 := No_Token_Index;
   goto Exit_Row67_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row67_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:728:11>

    if Row_Pos67 /= No_Token_Index then
        Or_Pos26 := Row_Pos67;
        Or_Res26 := Defer_Res119;
        goto Exit_Or27;
    end if;
    
--  BEGIN <_Extract at parser.lkt:731:11>

--  BEGIN <_Row at ???>

Row_Pos68 := Pos;



--  BEGIN <List at parser.lkt:731:16>

    List_Pos14 := Row_Pos68;



Lst_Cpos14 := Row_Pos68;
Tmp_List14 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:731:22>

Defer_Res120 :=
   Compilation_Unit_Transform_Parse0 (Parser, Lst_Cpos14);
Defer_Pos120 := Parser.Current_Pos;

--  END <Defer at parser.lkt:731:22>


   exit when Defer_Pos120 = No_Token_Index;

   List_Pos14 := Defer_Pos120;
   Lst_Cpos14 := List_Pos14;

   Tmp_List14.Nodes.Append (Defer_Res120);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List14.Nodes.Length;
begin
   List_Res14 := Allocate_Compilation_Unit_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos68;
      Token_End := (if Lst_Cpos14 = Row_Pos68
                    then Row_Pos68
                    else List_Pos14 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos68, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res14,
      Kind              => Ada_Compilation_Unit_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res14,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List14.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res14.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List14);

--  END <List at parser.lkt:731:16>




if List_Pos14 /= No_Token_Index then

   Row_Pos68 := List_Pos14;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;


--  BEGIN <Token(<WithText Termination>, ) at parser.lkt:731:40>

Token_Res106 := Row_Pos68;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res106));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Termination)
   then
       Token_Pos106 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos68 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos68,
             Expected_Token_Id => Ada_Termination,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos106 := Row_Pos68;
   end if;
end;

--  END <Token(<WithText Termination>, ) at parser.lkt:731:40>




if Token_Pos106 /= No_Token_Index then

   Row_Pos68 := Token_Pos106;

else
   Row_Pos68 := No_Token_Index;
   goto Exit_Row68_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row68_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:731:11>

    if Row_Pos68 /= No_Token_Index then
        Or_Pos26 := Row_Pos68;
        Or_Res26 := List_Res14;
        goto Exit_Or27;
    end if;
<<Exit_Or27>>

--  END <Or at parser.lkt:723:20>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Compilation_Or_Parse0_Memo,
      Or_Pos26 /= No_Token_Index,
      Or_Res26,
      Pos,
      Or_Pos26);


   Parser.Current_Pos := Or_Pos26;

   return Or_Res26;
end Compilation_Or_Parse0;

   


function Compilation_Unit_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Compilation_Unit
is
   use Bare_Compilation_Unit_Memos;

      Row_Pos69 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos15 :
            Token_Index
               := No_Token_Index;
      Tmp_List15 :
            Free_Parse_List;
      Defer_Pos121 :
            Token_Index
               := No_Token_Index;
      Defer_Res121 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      List_Pos15 :
            Token_Index
               := No_Token_Index;
      List_Res15 :
            Bare_Ada_Node_List
               := No_Bare_Ada_Node;
      Defer_Pos122 :
            Token_Index
               := No_Token_Index;
      Defer_Res122 :
            Bare_Subunit
               := No_Bare_Ada_Node;
      Defer_Pos123 :
            Token_Index
               := No_Token_Index;
      Defer_Res123 :
            Bare_Library_Item
               := No_Bare_Ada_Node;
      Or_Pos27 :
            Token_Index
               := No_Token_Index;
      Or_Res27 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Lst_Cpos16 :
            Token_Index
               := No_Token_Index;
      Tmp_List16 :
            Free_Parse_List;
      Defer_Pos124 :
            Token_Index
               := No_Token_Index;
      Defer_Res124 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      List_Pos16 :
            Token_Index
               := No_Token_Index;
      List_Res16 :
            Bare_Pragma_Node_List
               := No_Bare_Ada_Node;
      Transform_Res55 :
            Bare_Compilation_Unit
               := No_Bare_Ada_Node;
      Transform_Diags55 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Compilation_Unit_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res55 := M.Instance;
      return Transform_Res55;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res55;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCompilationUnit>) at parser.lkt:711:25>

Transform_Diags55 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos69 := Pos;



--  BEGIN <List at parser.lkt:712:9>

    List_Pos15 := Row_Pos69;



Lst_Cpos15 := Row_Pos69;
Tmp_List15 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:712:15>

Defer_Res121 :=
   Context_Item_Or_Parse0 (Parser, Lst_Cpos15);
Defer_Pos121 := Parser.Current_Pos;

--  END <Defer at parser.lkt:712:15>


   exit when Defer_Pos121 = No_Token_Index;

   List_Pos15 := Defer_Pos121;
   Lst_Cpos15 := List_Pos15;

   Tmp_List15.Nodes.Append (Defer_Res121);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List15.Nodes.Length;
begin
   List_Res15 := Allocate_Ada_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos69;
      Token_End := (if Lst_Cpos15 = Row_Pos69
                    then Row_Pos69
                    else List_Pos15 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos69, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res15,
      Kind              => Ada_Ada_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res15,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List15.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res15.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List15);

--  END <List at parser.lkt:712:9>




if List_Pos15 /= No_Token_Index then

   Row_Pos69 := List_Pos15;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;


--  BEGIN <Or at parser.lkt:713:9>

Or_Pos27 := No_Token_Index;
Or_Res27 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:713:12>

Defer_Res122 :=
   Subunit_Transform_Parse0 (Parser, Row_Pos69);
Defer_Pos122 := Parser.Current_Pos;

--  END <Defer at parser.lkt:713:12>

    if Defer_Pos122 /= No_Token_Index then
        Or_Pos27 := Defer_Pos122;
        Or_Res27 := Defer_Res122;
        goto Exit_Or28;
    end if;
    
--  BEGIN <Defer at parser.lkt:713:22>

Defer_Res123 :=
   Library_Item_Transform_Parse1 (Parser, Row_Pos69);
Defer_Pos123 := Parser.Current_Pos;

--  END <Defer at parser.lkt:713:22>

    if Defer_Pos123 /= No_Token_Index then
        Or_Pos27 := Defer_Pos123;
        Or_Res27 := Defer_Res123;
        goto Exit_Or28;
    end if;
<<Exit_Or28>>

--  END <Or at parser.lkt:713:9>




if Or_Pos27 /= No_Token_Index then

   Row_Pos69 := Or_Pos27;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;


--  BEGIN <List at parser.lkt:715:9>

    List_Pos16 := Row_Pos69;



Lst_Cpos16 := Row_Pos69;
Tmp_List16 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:715:15>

Defer_Res124 :=
   Pragma_Transform_Parse0 (Parser, Lst_Cpos16);
Defer_Pos124 := Parser.Current_Pos;

--  END <Defer at parser.lkt:715:15>


   exit when Defer_Pos124 = No_Token_Index;

   List_Pos16 := Defer_Pos124;
   Lst_Cpos16 := List_Pos16;

   Tmp_List16.Nodes.Append (Defer_Res124);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List16.Nodes.Length;
begin
   List_Res16 := Allocate_Pragma_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos69;
      Token_End := (if Lst_Cpos16 = Row_Pos69
                    then Row_Pos69
                    else List_Pos16 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos69, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res16,
      Kind              => Ada_Pragma_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res16,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List16.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res16.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List16);

--  END <List at parser.lkt:715:9>




if List_Pos16 /= No_Token_Index then

   Row_Pos69 := List_Pos16;

else
   Row_Pos69 := No_Token_Index;
   goto Exit_Row69_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row69_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos69 /= No_Token_Index then

   Transform_Res55 := Allocate_Compilation_Unit (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res55,
      Kind => Ada_Compilation_Unit,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos69 = Pos
                            then No_Token_Index
                            else Row_Pos69 - 1));

      
      Initialize_Fields_For_Compilation_Unit
        (Self => Transform_Res55,
         Compilation_Unit_F_Prelude => List_Res15,
         Compilation_Unit_F_Body => Or_Res27,
         Compilation_Unit_F_Pragmas => List_Res16);

         if List_Res15 /= null and then Is_Incomplete (List_Res15) then
            Transform_Res55.Last_Attempted_Child := 0;
         elsif List_Res15 /= null and then not Is_Ghost (List_Res15) then
            Transform_Res55.Last_Attempted_Child := -1;
         end if;
         if Or_Res27 /= null and then Is_Incomplete (Or_Res27) then
            Transform_Res55.Last_Attempted_Child := 0;
         elsif Or_Res27 /= null and then not Is_Ghost (Or_Res27) then
            Transform_Res55.Last_Attempted_Child := -1;
         end if;
         if List_Res16 /= null and then Is_Incomplete (List_Res16) then
            Transform_Res55.Last_Attempted_Child := 0;
         elsif List_Res16 /= null and then not Is_Ghost (List_Res16) then
            Transform_Res55.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos69 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags55);
end if;

--  END <Transform(<CompiledType BareCompilationUnit>) at parser.lkt:711:25>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Compilation_Unit_Transform_Parse0_Memo,
      Row_Pos69 /= No_Token_Index,
      Transform_Res55,
      Pos,
      Row_Pos69);


   Parser.Current_Pos := Row_Pos69;

   return Transform_Res55;
end Compilation_Unit_Transform_Parse0;

   


function Component_Clause_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Clause
is
   use Bare_Component_Clause_Memos;

      Row_Pos70 :
            Token_Index
               := No_Token_Index;
      Defer_Pos125 :
            Token_Index
               := No_Token_Index;
      Defer_Res125 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Token_Pos107 :
            Token_Index
               := No_Token_Index;
      Token_Res107 :
            Token_Index
               := No_Token_Index;
      Defer_Pos126 :
            Token_Index
               := No_Token_Index;
      Defer_Res126 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos127 :
            Token_Index
               := No_Token_Index;
      Defer_Res127 :
            Bare_Range_Spec
               := No_Bare_Ada_Node;
      Token_Pos108 :
            Token_Index
               := No_Token_Index;
      Token_Res108 :
            Token_Index
               := No_Token_Index;
      Transform_Res56 :
            Bare_Component_Clause
               := No_Bare_Ada_Node;
      Transform_Diags56 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Component_Clause_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res56 := M.Instance;
      return Transform_Res56;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res56;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareComponentClause>) at parser.lkt:512:25>

Transform_Diags56 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos70 := Pos;



--  BEGIN <Defer at parser.lkt:513:9>

Defer_Res125 :=
   Identifier_Transform_Parse0 (Parser, Row_Pos70);
Defer_Pos125 := Parser.Current_Pos;

--  END <Defer at parser.lkt:513:9>




if Defer_Pos125 /= No_Token_Index then

   Row_Pos70 := Defer_Pos125;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  BEGIN <Token(<WithText At>, ) at parser.lkt:513:20>

Token_Res107 := Row_Pos70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res107));
begin
   if
      T.Kind /= From_Token_Kind (Ada_At)
   then
       Token_Pos107 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos70,
             Expected_Token_Id => Ada_At,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos107 := Row_Pos70 + 1;
   end if;
end;

--  END <Token(<WithText At>, ) at parser.lkt:513:20>




if Token_Pos107 /= No_Token_Index then

   Row_Pos70 := Token_Pos107;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  BEGIN <Defer at parser.lkt:513:25>

Defer_Res126 :=
   Simple_Expr_Or_Parse0 (Parser, Row_Pos70);
Defer_Pos126 := Parser.Current_Pos;

--  END <Defer at parser.lkt:513:25>




if Defer_Pos126 /= No_Token_Index then

   Row_Pos70 := Defer_Pos126;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  BEGIN <Defer at parser.lkt:513:37>

Defer_Res127 :=
   Range_Spec_Transform_Parse0 (Parser, Row_Pos70);
Defer_Pos127 := Parser.Current_Pos;

--  END <Defer at parser.lkt:513:37>




if Defer_Pos127 /= No_Token_Index then

   Row_Pos70 := Defer_Pos127;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;


--  BEGIN <Opt at parser.lkt:513:48>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:513:49>

Token_Res108 := Row_Pos70;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res108));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos108 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos70 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos70,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos108 := Row_Pos70 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:513:49>


if Token_Pos108 = No_Token_Index then

         
   Token_Res108 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos70)),
                To_Text ("Missing ';'"));

       
   Token_Pos108 := Row_Pos70;



end if;

--  END <Opt at parser.lkt:513:48>




if Token_Pos108 /= No_Token_Index then

   Row_Pos70 := Token_Pos108;

else
   Row_Pos70 := No_Token_Index;
   goto Exit_Row70_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row70_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos70 /= No_Token_Index then

   Transform_Res56 := Allocate_Component_Clause (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res56,
      Kind => Ada_Component_Clause,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos70 = Pos
                            then No_Token_Index
                            else Row_Pos70 - 1));

      
      Initialize_Fields_For_Component_Clause
        (Self => Transform_Res56,
         Component_Clause_F_Id => Defer_Res125,
         Component_Clause_F_Position => Defer_Res126,
         Component_Clause_F_Range => Defer_Res127);

         if Defer_Res125 /= null and then Is_Incomplete (Defer_Res125) then
            Transform_Res56.Last_Attempted_Child := 0;
         elsif Defer_Res125 /= null and then not Is_Ghost (Defer_Res125) then
            Transform_Res56.Last_Attempted_Child := -1;
         end if;
         if Defer_Res126 /= null and then Is_Incomplete (Defer_Res126) then
            Transform_Res56.Last_Attempted_Child := 0;
         elsif Defer_Res126 /= null and then not Is_Ghost (Defer_Res126) then
            Transform_Res56.Last_Attempted_Child := -1;
         end if;
         if Defer_Res127 /= null and then Is_Incomplete (Defer_Res127) then
            Transform_Res56.Last_Attempted_Child := 0;
         elsif Defer_Res127 /= null and then not Is_Ghost (Defer_Res127) then
            Transform_Res56.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos70 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags56);
end if;

--  END <Transform(<CompiledType BareComponentClause>) at parser.lkt:512:25>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Component_Clause_Transform_Parse0_Memo,
      Row_Pos70 /= No_Token_Index,
      Transform_Res56,
      Pos,
      Row_Pos70);


   Parser.Current_Pos := Row_Pos70;

   return Transform_Res56;
end Component_Clause_Transform_Parse0;

   


function Component_Decl_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Decl
is
   use Bare_Component_Decl_Memos;

      Row_Pos71 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos17 :
            Token_Index
               := No_Token_Index;
      Tmp_List17 :
            Free_Parse_List;
      Defer_Pos128 :
            Token_Index
               := No_Token_Index;
      Defer_Res128 :
            Bare_Defining_Name
               := No_Bare_Ada_Node;
      Token_Pos109 :
            Token_Index
               := No_Token_Index;
      Token_Res109 :
            Token_Index
               := No_Token_Index;
      List_Pos17 :
            Token_Index
               := No_Token_Index;
      List_Res17 :
            Bare_Defining_Name_List
               := No_Bare_Ada_Node;
      Token_Pos110 :
            Token_Index
               := No_Token_Index;
      Token_Res110 :
            Token_Index
               := No_Token_Index;
      Defer_Pos129 :
            Token_Index
               := No_Token_Index;
      Defer_Res129 :
            Bare_Component_Def
               := No_Bare_Ada_Node;
      Row_Pos72 :
            Token_Index
               := No_Token_Index;
      Token_Pos111 :
            Token_Index
               := No_Token_Index;
      Token_Res111 :
            Token_Index
               := No_Token_Index;
      Defer_Pos130 :
            Token_Index
               := No_Token_Index;
      Defer_Res130 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos131 :
            Token_Index
               := No_Token_Index;
      Defer_Res131 :
            Bare_Aspect_Spec
               := No_Bare_Ada_Node;
      Token_Pos112 :
            Token_Index
               := No_Token_Index;
      Token_Res112 :
            Token_Index
               := No_Token_Index;
      Transform_Res57 :
            Bare_Component_Decl
               := No_Bare_Ada_Node;
      Transform_Diags57 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Component_Decl_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res57 := M.Instance;
      return Transform_Res57;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res57;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareComponentDecl>) at parser.lkt:236:23>

Transform_Diags57 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos71 := Pos;



--  BEGIN <List at parser.lkt:237:9>

    List_Pos17 := No_Token_Index;



Lst_Cpos17 := Row_Pos71;
Tmp_List17 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:237:15>

Defer_Res128 :=
   Defining_Id_Transform_Parse0 (Parser, Lst_Cpos17);
Defer_Pos128 := Parser.Current_Pos;

--  END <Defer at parser.lkt:237:15>


   exit when Defer_Pos128 = No_Token_Index;

   List_Pos17 := Defer_Pos128;
   Lst_Cpos17 := List_Pos17;

   Tmp_List17.Nodes.Append (Defer_Res128);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:237:28>

Token_Res109 := Lst_Cpos17;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res109));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos109 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos17 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos17,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos109 := Lst_Cpos17 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:237:28>


      exit when Token_Pos109 = No_Token_Index;

      Lst_Cpos17 := Token_Pos109;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List17.Nodes.Length;
begin
   List_Res17 := Allocate_Defining_Name_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos71;
      Token_End := (if Lst_Cpos17 = Row_Pos71
                    then Row_Pos71
                    else List_Pos17 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos71, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res17,
      Kind              => Ada_Defining_Name_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res17,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List17.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res17.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List17);

--  END <List at parser.lkt:237:9>




if List_Pos17 /= No_Token_Index then

   Row_Pos71 := List_Pos17;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Token(<WithText Colon>, ) at parser.lkt:238:9>

Token_Res110 := Row_Pos71;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res110));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Colon)
   then
       Token_Pos110 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos71 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos71,
             Expected_Token_Id => Ada_Colon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos110 := Row_Pos71 + 1;
   end if;
end;

--  END <Token(<WithText Colon>, ) at parser.lkt:238:9>




if Token_Pos110 /= No_Token_Index then

   Row_Pos71 := Token_Pos110;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Defer at parser.lkt:239:9>

Defer_Res129 :=
   Component_Def_Transform_Parse0 (Parser, Row_Pos71);
Defer_Pos129 := Parser.Current_Pos;

--  END <Defer at parser.lkt:239:9>




if Defer_Pos129 /= No_Token_Index then

   Row_Pos71 := Defer_Pos129;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Opt at parser.lkt:240:9>












--  BEGIN <_Extract at parser.lkt:240:10>

--  BEGIN <_Row at ???>

Row_Pos72 := Row_Pos71;



--  BEGIN <Token(<WithText Assign>, ) at parser.lkt:240:15>

Token_Res111 := Row_Pos72;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res111));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Assign)
   then
       Token_Pos111 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos72 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos72,
             Expected_Token_Id => Ada_Assign,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos111 := Row_Pos72 + 1;
   end if;
end;

--  END <Token(<WithText Assign>, ) at parser.lkt:240:15>




if Token_Pos111 /= No_Token_Index then

   Row_Pos72 := Token_Pos111;

else
   Row_Pos72 := No_Token_Index;
   goto Exit_Row72_0;

end if;


--  BEGIN <Defer at parser.lkt:240:20>

Defer_Res130 :=
   Expr_Or_Parse0 (Parser, Row_Pos72);
Defer_Pos130 := Parser.Current_Pos;

--  END <Defer at parser.lkt:240:20>




if Defer_Pos130 /= No_Token_Index then

   Row_Pos72 := Defer_Pos130;

else
   Row_Pos72 := No_Token_Index;
   goto Exit_Row72_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row72_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:240:10>


if Row_Pos72 = No_Token_Index then

         
   Defer_Res130 := No_Bare_Ada_Node;



       
   Row_Pos72 := Row_Pos71;



end if;

--  END <Opt at parser.lkt:240:9>




if Row_Pos72 /= No_Token_Index then

   Row_Pos71 := Row_Pos72;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Defer at parser.lkt:241:9>

Defer_Res131 :=
   Aspect_Spec_Opt_Parse0 (Parser, Row_Pos71);
Defer_Pos131 := Parser.Current_Pos;

--  END <Defer at parser.lkt:241:9>




if Defer_Pos131 /= No_Token_Index then

   Row_Pos71 := Defer_Pos131;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;


--  BEGIN <Opt at parser.lkt:242:9>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:242:10>

Token_Res112 := Row_Pos71;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res112));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos112 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos71 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos71,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos112 := Row_Pos71 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:242:10>


if Token_Pos112 = No_Token_Index then

         
   Token_Res112 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos71)),
                To_Text ("Missing ';'"));

       
   Token_Pos112 := Row_Pos71;



end if;

--  END <Opt at parser.lkt:242:9>




if Token_Pos112 /= No_Token_Index then

   Row_Pos71 := Token_Pos112;

else
   Row_Pos71 := No_Token_Index;
   goto Exit_Row71_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row71_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos71 /= No_Token_Index then

   Transform_Res57 := Allocate_Component_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res57,
      Kind => Ada_Component_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos71 = Pos
                            then No_Token_Index
                            else Row_Pos71 - 1));

      
      Initialize_Fields_For_Component_Decl
        (Self => Transform_Res57,
         Component_Decl_F_Ids => List_Res17,
         Component_Decl_F_Component_Def => Defer_Res129,
         Component_Decl_F_Default_Expr => Defer_Res130,
         Component_Decl_F_Aspects => Defer_Res131);

         if List_Res17 /= null and then Is_Incomplete (List_Res17) then
            Transform_Res57.Last_Attempted_Child := 0;
         elsif List_Res17 /= null and then not Is_Ghost (List_Res17) then
            Transform_Res57.Last_Attempted_Child := -1;
         end if;
         if Defer_Res129 /= null and then Is_Incomplete (Defer_Res129) then
            Transform_Res57.Last_Attempted_Child := 0;
         elsif Defer_Res129 /= null and then not Is_Ghost (Defer_Res129) then
            Transform_Res57.Last_Attempted_Child := -1;
         end if;
         if Defer_Res130 /= null and then Is_Incomplete (Defer_Res130) then
            Transform_Res57.Last_Attempted_Child := 0;
         elsif Defer_Res130 /= null and then not Is_Ghost (Defer_Res130) then
            Transform_Res57.Last_Attempted_Child := -1;
         end if;
         if Defer_Res131 /= null and then Is_Incomplete (Defer_Res131) then
            Transform_Res57.Last_Attempted_Child := 0;
         elsif Defer_Res131 /= null and then not Is_Ghost (Defer_Res131) then
            Transform_Res57.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos71 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags57);
end if;

--  END <Transform(<CompiledType BareComponentDecl>) at parser.lkt:236:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Component_Decl_Transform_Parse0_Memo,
      Row_Pos71 /= No_Token_Index,
      Transform_Res57,
      Pos,
      Row_Pos71);


   Parser.Current_Pos := Row_Pos71;

   return Transform_Res57;
end Component_Decl_Transform_Parse0;

   


function Component_Def_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_Def
is
   use Bare_Component_Def_Memos;

      Row_Pos73 :
            Token_Index
               := No_Token_Index;
      Token_Pos113 :
            Token_Index
               := No_Token_Index;
      Token_Res113 :
            Token_Index
               := No_Token_Index;
      Opt_Res5 :
            Bare_Aliased_Node
               := No_Bare_Ada_Node;
      Token_Pos114 :
            Token_Index
               := No_Token_Index;
      Token_Res114 :
            Token_Index
               := No_Token_Index;
      Opt_Res6 :
            Bare_Constant_Node
               := No_Bare_Ada_Node;
      Defer_Pos132 :
            Token_Index
               := No_Token_Index;
      Defer_Res132 :
            Bare_Type_Expr
               := No_Bare_Ada_Node;
      Transform_Res58 :
            Bare_Component_Def
               := No_Bare_Ada_Node;
      Transform_Diags58 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Component_Def_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res58 := M.Instance;
      return Transform_Res58;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res58;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareComponentDef>) at parser.lkt:227:22>

Transform_Diags58 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos73 := Pos;



--  BEGIN <Opt at parser.lkt:228:9>












--  BEGIN <Token(<WithSymbol Identifier>, aliased) at parser.lkt:228:17>

Token_Res113 := Row_Pos73;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res113));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Identifier)
      or else T.Symbol /= Precomputed_Symbol
        (Precomputed_Symbol_Table (Parser.TDH.Symbols),
         Precomputed_Sym_Aliased)
   then
       Token_Pos113 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos73 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos73,
             Expected_Token_Id => Ada_Identifier,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos113 := Row_Pos73 + 1;
   end if;
end;

--  END <Token(<WithSymbol Identifier>, aliased) at parser.lkt:228:17>


if Token_Pos113 = No_Token_Index then

         Opt_Res5 := Allocate_Aliased_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res5,
            Kind              => Ada_Aliased_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos73,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos113 := Row_Pos73;


else

      Opt_Res5 := Allocate_Aliased_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res5,
         Kind              => Ada_Aliased_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos73,
         Token_End_Index   => Token_Pos113 - 1);

end if;

--  END <Opt at parser.lkt:228:9>




if Token_Pos113 /= No_Token_Index then

   Row_Pos73 := Token_Pos113;

else
   Row_Pos73 := No_Token_Index;
   goto Exit_Row73_0;

end if;


--  BEGIN <Opt at parser.lkt:228:41>












--  BEGIN <Token(<WithText Constant>, ) at parser.lkt:228:50>

Token_Res114 := Row_Pos73;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res114));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Constant)
   then
       Token_Pos114 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos73 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos73,
             Expected_Token_Id => Ada_Constant,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos114 := Row_Pos73 + 1;
   end if;
end;

--  END <Token(<WithText Constant>, ) at parser.lkt:228:50>


if Token_Pos114 = No_Token_Index then

         Opt_Res6 := Allocate_Constant_Absent (Parser.Mem_Pool);
         Initialize
           (Self              => Opt_Res6,
            Kind              => Ada_Constant_Absent,
            Unit              => Parser.Unit,
            Token_Start_Index => Row_Pos73,
            Token_End_Index   => No_Token_Index);


       
   Token_Pos114 := Row_Pos73;


else

      Opt_Res6 := Allocate_Constant_Present (Parser.Mem_Pool);
      Initialize
        (Self              => Opt_Res6,
         Kind              => Ada_Constant_Present,
         Unit              => Parser.Unit,
         Token_Start_Index => Row_Pos73,
         Token_End_Index   => Token_Pos114 - 1);

end if;

--  END <Opt at parser.lkt:228:41>




if Token_Pos114 /= No_Token_Index then

   Row_Pos73 := Token_Pos114;

else
   Row_Pos73 := No_Token_Index;
   goto Exit_Row73_0;

end if;


--  BEGIN <Defer at parser.lkt:228:62>

Defer_Res132 :=
   Type_Expr_Or_Parse0 (Parser, Row_Pos73);
Defer_Pos132 := Parser.Current_Pos;

--  END <Defer at parser.lkt:228:62>




if Defer_Pos132 /= No_Token_Index then

   Row_Pos73 := Defer_Pos132;

else
   Row_Pos73 := No_Token_Index;
   goto Exit_Row73_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row73_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos73 /= No_Token_Index then

   Transform_Res58 := Allocate_Component_Def (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res58,
      Kind => Ada_Component_Def,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos73 = Pos
                            then No_Token_Index
                            else Row_Pos73 - 1));

      
      Initialize_Fields_For_Component_Def
        (Self => Transform_Res58,
         Component_Def_F_Has_Aliased => Opt_Res5,
         Component_Def_F_Has_Constant => Opt_Res6,
         Component_Def_F_Type_Expr => Defer_Res132);

         if Opt_Res5 /= null and then Is_Incomplete (Opt_Res5) then
            Transform_Res58.Last_Attempted_Child := 0;
         elsif Opt_Res5 /= null and then not Is_Ghost (Opt_Res5) then
            Transform_Res58.Last_Attempted_Child := -1;
         end if;
         if Opt_Res6 /= null and then Is_Incomplete (Opt_Res6) then
            Transform_Res58.Last_Attempted_Child := 0;
         elsif Opt_Res6 /= null and then not Is_Ghost (Opt_Res6) then
            Transform_Res58.Last_Attempted_Child := -1;
         end if;
         if Defer_Res132 /= null and then Is_Incomplete (Defer_Res132) then
            Transform_Res58.Last_Attempted_Child := 0;
         elsif Defer_Res132 /= null and then not Is_Ghost (Defer_Res132) then
            Transform_Res58.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos73 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags58);
end if;

--  END <Transform(<CompiledType BareComponentDef>) at parser.lkt:227:22>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Component_Def_Transform_Parse0_Memo,
      Row_Pos73 /= No_Token_Index,
      Transform_Res58,
      Pos,
      Row_Pos73);


   Parser.Current_Pos := Row_Pos73;

   return Transform_Res58;
end Component_Def_Transform_Parse0;

   


function Component_Item_Or_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Ada_Node
is
   use Bare_Ada_Node_Memos;

      Row_Pos74 :
            Token_Index
               := No_Token_Index;
      Token_Pos115 :
            Token_Index
               := No_Token_Index;
      Token_Res115 :
            Token_Index
               := No_Token_Index;
      Token_Pos116 :
            Token_Index
               := No_Token_Index;
      Token_Res116 :
            Token_Index
               := No_Token_Index;
      Transform_Res59 :
            Bare_Null_Component_Decl
               := No_Bare_Ada_Node;
      Transform_Diags59 :
            Ada.Containers.Count_Type;
      Defer_Pos133 :
            Token_Index
               := No_Token_Index;
      Defer_Res133 :
            Bare_Component_Decl
               := No_Bare_Ada_Node;
      Defer_Pos134 :
            Token_Index
               := No_Token_Index;
      Defer_Res134 :
            Bare_Aspect_Clause
               := No_Bare_Ada_Node;
      Defer_Pos135 :
            Token_Index
               := No_Token_Index;
      Defer_Res135 :
            Bare_Pragma_Node
               := No_Bare_Ada_Node;
      Or_Pos28 :
            Token_Index
               := No_Token_Index;
      Or_Res28 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Component_Item_Or_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Or_Res28 := M.Instance;
      return Or_Res28;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Or_Res28;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Or at parser.lkt:230:23>

Or_Pos28 := No_Token_Index;
Or_Res28 := No_Bare_Ada_Node;
    
--  BEGIN <Transform(<CompiledType BareNullComponentDecl>) at parser.lkt:231:11>

Transform_Diags59 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos74 := Pos;



--  BEGIN <Token(<WithSymbol Null>, ) at parser.lkt:231:29>

Token_Res115 := Row_Pos74;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res115));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Null)
   then
       Token_Pos115 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos74 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos74,
             Expected_Token_Id => Ada_Null,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos115 := Row_Pos74 + 1;
   end if;
end;

--  END <Token(<WithSymbol Null>, ) at parser.lkt:231:29>




if Token_Pos115 /= No_Token_Index then

   Row_Pos74 := Token_Pos115;

else
   Row_Pos74 := No_Token_Index;
   goto Exit_Row74_0;

end if;


--  BEGIN <Opt at parser.lkt:231:36>












--  BEGIN <Token(<WithText Semicolon>, ) at parser.lkt:231:37>

Token_Res116 := Row_Pos74;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res116));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Semicolon)
   then
       Token_Pos116 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos74 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos74,
             Expected_Token_Id => Ada_Semicolon,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos116 := Row_Pos74 + 1;
   end if;
end;

--  END <Token(<WithText Semicolon>, ) at parser.lkt:231:37>


if Token_Pos116 = No_Token_Index then

         
   Token_Res116 := No_Token_Index;


        Append (Parser.Diagnostics,
                Sloc_Range (Parser.TDH.all,
                            Get_Token (Parser.TDH.all, Row_Pos74)),
                To_Text ("Missing ';'"));

       
   Token_Pos116 := Row_Pos74;



end if;

--  END <Opt at parser.lkt:231:36>




if Token_Pos116 /= No_Token_Index then

   Row_Pos74 := Token_Pos116;

else
   Row_Pos74 := No_Token_Index;
   goto Exit_Row74_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row74_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos74 /= No_Token_Index then

   Transform_Res59 := Allocate_Null_Component_Decl (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res59,
      Kind => Ada_Null_Component_Decl,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos74 = Pos
                            then No_Token_Index
                            else Row_Pos74 - 1));




elsif Row_Pos74 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags59);
end if;

--  END <Transform(<CompiledType BareNullComponentDecl>) at parser.lkt:231:11>

    if Row_Pos74 /= No_Token_Index then
        Or_Pos28 := Row_Pos74;
        Or_Res28 := Transform_Res59;
        goto Exit_Or29;
    end if;
    
--  BEGIN <Defer at parser.lkt:232:11>

Defer_Res133 :=
   Component_Decl_Transform_Parse0 (Parser, Pos);
Defer_Pos133 := Parser.Current_Pos;

--  END <Defer at parser.lkt:232:11>

    if Defer_Pos133 /= No_Token_Index then
        Or_Pos28 := Defer_Pos133;
        Or_Res28 := Defer_Res133;
        goto Exit_Or29;
    end if;
    
--  BEGIN <Defer at parser.lkt:233:11>

Defer_Res134 :=
   Aspect_Clause_Or_Parse1 (Parser, Pos);
Defer_Pos134 := Parser.Current_Pos;

--  END <Defer at parser.lkt:233:11>

    if Defer_Pos134 /= No_Token_Index then
        Or_Pos28 := Defer_Pos134;
        Or_Res28 := Defer_Res134;
        goto Exit_Or29;
    end if;
    
--  BEGIN <Defer at parser.lkt:234:11>

Defer_Res135 :=
   Pragma_Transform_Parse0 (Parser, Pos);
Defer_Pos135 := Parser.Current_Pos;

--  END <Defer at parser.lkt:234:11>

    if Defer_Pos135 /= No_Token_Index then
        Or_Pos28 := Defer_Pos135;
        Or_Res28 := Defer_Res135;
        goto Exit_Or29;
    end if;
<<Exit_Or29>>

--  END <Or at parser.lkt:230:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Component_Item_Or_Parse0_Memo,
      Or_Pos28 /= No_Token_Index,
      Or_Res28,
      Pos,
      Or_Pos28);


   Parser.Current_Pos := Or_Pos28;

   return Or_Res28;
end Component_Item_Or_Parse0;

   


function Component_List_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Component_List
is
   use Bare_Component_List_Memos;

      Row_Pos75 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos18 :
            Token_Index
               := No_Token_Index;
      Tmp_List18 :
            Free_Parse_List;
      Defer_Pos136 :
            Token_Index
               := No_Token_Index;
      Defer_Res136 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      List_Pos18 :
            Token_Index
               := No_Token_Index;
      List_Res18 :
            Bare_Ada_Node_List
               := No_Bare_Ada_Node;
      Defer_Pos137 :
            Token_Index
               := No_Token_Index;
      Defer_Res137 :
            Bare_Variant_Part
               := No_Bare_Ada_Node;
      Transform_Res60 :
            Bare_Component_List
               := No_Bare_Ada_Node;
      Transform_Diags60 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Component_List_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res60 := M.Instance;
      return Transform_Res60;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res60;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareComponentList>) at parser.lkt:244:23>

Transform_Diags60 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos75 := Pos;



--  BEGIN <List at parser.lkt:244:37>

    List_Pos18 := Row_Pos75;



Lst_Cpos18 := Row_Pos75;
Tmp_List18 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:244:43>

Defer_Res136 :=
   Component_Item_Or_Parse0 (Parser, Lst_Cpos18);
Defer_Pos136 := Parser.Current_Pos;

--  END <Defer at parser.lkt:244:43>


   exit when Defer_Pos136 = No_Token_Index;

   List_Pos18 := Defer_Pos136;
   Lst_Cpos18 := List_Pos18;

   Tmp_List18.Nodes.Append (Defer_Res136);

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List18.Nodes.Length;
begin
   List_Res18 := Allocate_Ada_Node_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos75;
      Token_End := (if Lst_Cpos18 = Row_Pos75
                    then Row_Pos75
                    else List_Pos18 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos75, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res18,
      Kind              => Ada_Ada_Node_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res18,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List18.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res18.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List18);

--  END <List at parser.lkt:244:37>




if List_Pos18 /= No_Token_Index then

   Row_Pos75 := List_Pos18;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;


--  BEGIN <Opt at parser.lkt:244:59>












--  BEGIN <Defer at parser.lkt:244:60>

Defer_Res137 :=
   Variant_Part_Transform_Parse0 (Parser, Row_Pos75);
Defer_Pos137 := Parser.Current_Pos;

--  END <Defer at parser.lkt:244:60>


if Defer_Pos137 = No_Token_Index then

         
   Defer_Res137 := No_Bare_Ada_Node;



       
   Defer_Pos137 := Row_Pos75;



end if;

--  END <Opt at parser.lkt:244:59>




if Defer_Pos137 /= No_Token_Index then

   Row_Pos75 := Defer_Pos137;

else
   Row_Pos75 := No_Token_Index;
   goto Exit_Row75_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row75_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos75 /= No_Token_Index then

   Transform_Res60 := Allocate_Component_List (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res60,
      Kind => Ada_Component_List,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos75 = Pos
                            then No_Token_Index
                            else Row_Pos75 - 1));

      
      Initialize_Fields_For_Component_List
        (Self => Transform_Res60,
         Component_List_F_Components => List_Res18,
         Component_List_F_Variant_Part => Defer_Res137);

         if List_Res18 /= null and then Is_Incomplete (List_Res18) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif List_Res18 /= null and then not Is_Ghost (List_Res18) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;
         if Defer_Res137 /= null and then Is_Incomplete (Defer_Res137) then
            Transform_Res60.Last_Attempted_Child := 0;
         elsif Defer_Res137 /= null and then not Is_Ghost (Defer_Res137) then
            Transform_Res60.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos75 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags60);
end if;

--  END <Transform(<CompiledType BareComponentList>) at parser.lkt:244:23>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Component_List_Transform_Parse0_Memo,
      Row_Pos75 /= No_Token_Index,
      Transform_Res60,
      Pos,
      Row_Pos75);


   Parser.Current_Pos := Row_Pos75;

   return Transform_Res60;
end Component_List_Transform_Parse0;

   


function Composite_Constraint_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Constraint
is
   use Bare_Composite_Constraint_Memos;

      Row_Pos76 :
            Token_Index
               := No_Token_Index;
      Token_Pos117 :
            Token_Index
               := No_Token_Index;
      Token_Res117 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos19 :
            Token_Index
               := No_Token_Index;
      Tmp_List19 :
            Free_Parse_List;
      Defer_Pos138 :
            Token_Index
               := No_Token_Index;
      Defer_Res138 :
            Bare_Composite_Constraint_Assoc
               := No_Bare_Ada_Node;
      Token_Pos118 :
            Token_Index
               := No_Token_Index;
      Token_Res118 :
            Token_Index
               := No_Token_Index;
      List_Pos19 :
            Token_Index
               := No_Token_Index;
      List_Res19 :
            Bare_Assoc_List
               := No_Bare_Ada_Node;
      Token_Pos119 :
            Token_Index
               := No_Token_Index;
      Token_Res119 :
            Token_Index
               := No_Token_Index;
      Transform_Res61 :
            Bare_Composite_Constraint
               := No_Bare_Ada_Node;
      Transform_Diags61 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Composite_Constraint_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res61 := M.Instance;
      return Transform_Res61;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res61;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCompositeConstraint>) at parser.lkt:104:29>

Transform_Diags61 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos76 := Pos;



--  BEGIN <Token(<WithText ParOpen>, ) at parser.lkt:105:9>

Token_Res117 := Row_Pos76;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res117));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Open)
   then
       Token_Pos117 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos76 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos76,
             Expected_Token_Id => Ada_Par_Open,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos117 := Row_Pos76 + 1;
   end if;
end;

--  END <Token(<WithText ParOpen>, ) at parser.lkt:105:9>




if Token_Pos117 /= No_Token_Index then

   Row_Pos76 := Token_Pos117;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;


--  BEGIN <List at parser.lkt:105:13>

    List_Pos19 := No_Token_Index;



Lst_Cpos19 := Row_Pos76;
Tmp_List19 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:105:24>

Defer_Res138 :=
   Composite_Constraint_Assoc_Transform_Parse0 (Parser, Lst_Cpos19);
Defer_Pos138 := Parser.Current_Pos;

--  END <Defer at parser.lkt:105:24>


   exit when Defer_Pos138 = No_Token_Index;

   List_Pos19 := Defer_Pos138;
   Lst_Cpos19 := List_Pos19;

   Tmp_List19.Nodes.Append (Defer_Res138);

      
--  BEGIN <Token(<WithText Comma>, ) at parser.lkt:105:52>

Token_Res118 := Lst_Cpos19;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res118));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Comma)
   then
       Token_Pos118 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos19 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos19,
             Expected_Token_Id => Ada_Comma,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos118 := Lst_Cpos19 + 1;
   end if;
end;

--  END <Token(<WithText Comma>, ) at parser.lkt:105:52>


      exit when Token_Pos118 = No_Token_Index;

      Lst_Cpos19 := Token_Pos118;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List19.Nodes.Length;
begin
   List_Res19 := Allocate_Assoc_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos76;
      Token_End := (if Lst_Cpos19 = Row_Pos76
                    then Row_Pos76
                    else List_Pos19 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos76, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res19,
      Kind              => Ada_Assoc_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res19,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List19.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res19.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List19);

--  END <List at parser.lkt:105:13>




if List_Pos19 /= No_Token_Index then

   Row_Pos76 := List_Pos19;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;


--  BEGIN <Token(<WithText ParClose>, ) at parser.lkt:105:57>

Token_Res119 := Row_Pos76;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res119));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Par_Close)
   then
       Token_Pos119 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos76 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos76,
             Expected_Token_Id => Ada_Par_Close,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos119 := Row_Pos76 + 1;
   end if;
end;

--  END <Token(<WithText ParClose>, ) at parser.lkt:105:57>




if Token_Pos119 /= No_Token_Index then

   Row_Pos76 := Token_Pos119;

else
   Row_Pos76 := No_Token_Index;
   goto Exit_Row76_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row76_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>



if Row_Pos76 /= No_Token_Index then

   Transform_Res61 := Allocate_Composite_Constraint (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res61,
      Kind => Ada_Composite_Constraint,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos76 = Pos
                            then No_Token_Index
                            else Row_Pos76 - 1));

      
      Initialize_Fields_For_Composite_Constraint
        (Self => Transform_Res61,
         Composite_Constraint_F_Constraints => List_Res19);

         if List_Res19 /= null and then Is_Incomplete (List_Res19) then
            Transform_Res61.Last_Attempted_Child := 0;
         elsif List_Res19 /= null and then not Is_Ghost (List_Res19) then
            Transform_Res61.Last_Attempted_Child := -1;
         end if;


elsif Row_Pos76 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags61);
end if;

--  END <Transform(<CompiledType BareCompositeConstraint>) at parser.lkt:104:29>


   -------------------------------
   -- END MAIN COMBINATORS CODE --
   -------------------------------


   Set
     (PP.Composite_Constraint_Transform_Parse0_Memo,
      Row_Pos76 /= No_Token_Index,
      Transform_Res61,
      Pos,
      Row_Pos76);


   Parser.Current_Pos := Row_Pos76;

   return Transform_Res61;
end Composite_Constraint_Transform_Parse0;

   


function Composite_Constraint_Assoc_Transform_Parse0
  (Parser : in out Parser_Type;
   Pos    : Token_Index) return Bare_Composite_Constraint_Assoc
is
   use Bare_Composite_Constraint_Assoc_Memos;

      Nobt10 :
            Boolean
               := False;
      Row_Pos77 :
            Token_Index
               := No_Token_Index;
      Row_Pos78 :
            Token_Index
               := No_Token_Index;
      Lst_Cpos20 :
            Token_Index
               := No_Token_Index;
      Tmp_List20 :
            Free_Parse_List;
      Defer_Pos139 :
            Token_Index
               := No_Token_Index;
      Defer_Res139 :
            Bare_Identifier
               := No_Bare_Ada_Node;
      Token_Pos120 :
            Token_Index
               := No_Token_Index;
      Token_Res120 :
            Token_Index
               := No_Token_Index;
      List_Pos20 :
            Token_Index
               := No_Token_Index;
      List_Res20 :
            Bare_Discriminant_Choice_List
               := No_Bare_Ada_Node;
      Token_Pos121 :
            Token_Index
               := No_Token_Index;
      Token_Res121 :
            Token_Index
               := No_Token_Index;
      Defer_Pos140 :
            Token_Index
               := No_Token_Index;
      Defer_Res140 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Defer_Pos141 :
            Token_Index
               := No_Token_Index;
      Defer_Res141 :
            Bare_Discrete_Subtype_Indication
               := No_Bare_Ada_Node;
      Defer_Pos142 :
            Token_Index
               := No_Token_Index;
      Defer_Res142 :
            Bare_Expr
               := No_Bare_Ada_Node;
      Or_Pos29 :
            Token_Index
               := No_Token_Index;
      Or_Res29 :
            Bare_Ada_Node
               := No_Bare_Ada_Node;
      Row_Progress10 :
            Integer
               := 0;
      Transform_Res62 :
            Bare_Composite_Constraint_Assoc
               := No_Bare_Ada_Node;
      Transform_Has_Failed10 :
            Boolean
               := False;
      Transform_Diags62 :
            Ada.Containers.Count_Type;


   PP : constant Parser_Private_Part := +Parser.Private_Part;
   M  : Memo_Entry := Get (PP.Composite_Constraint_Assoc_Transform_Parse0_Memo, Pos);

begin
   if M.State = Success then
      Parser.Current_Pos := M.Final_Pos;
      Transform_Res62 := M.Instance;
      return Transform_Res62;
   elsif M.State = Failure then
      Parser.Current_Pos := No_Token_Index;
      return Transform_Res62;
   end if;


   ---------------------------
   -- MAIN COMBINATORS CODE --
   ---------------------------

   
--  BEGIN <Transform(<CompiledType BareCompositeConstraintAssoc>) at parser.lkt:95:35>

Transform_Diags62 := Parser.Diagnostics.Length;


--  BEGIN <_Row at ???>

Row_Pos77 := Pos;



--  BEGIN <Opt at parser.lkt:97:9>












--  BEGIN <_Extract at parser.lkt:97:10>

--  BEGIN <_Row at ???>

Row_Pos78 := Row_Pos77;



--  BEGIN <List at parser.lkt:97:15>

    List_Pos20 := No_Token_Index;



Lst_Cpos20 := Row_Pos78;
Tmp_List20 := Get_Parse_List (Parser);


loop
   
--  BEGIN <Defer at parser.lkt:97:39>

Defer_Res139 :=
   Identifier_Transform_Parse0 (Parser, Lst_Cpos20);
Defer_Pos139 := Parser.Current_Pos;

--  END <Defer at parser.lkt:97:39>


   exit when Defer_Pos139 = No_Token_Index;

   List_Pos20 := Defer_Pos139;
   Lst_Cpos20 := List_Pos20;

   Tmp_List20.Nodes.Append (Defer_Res139);

      
--  BEGIN <Token(<WithText Pipe>, ) at parser.lkt:97:51>

Token_Res120 := Lst_Cpos20;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res120));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Pipe)
   then
       Token_Pos120 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Lst_Cpos20 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Lst_Cpos20,
             Expected_Token_Id => Ada_Pipe,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos120 := Lst_Cpos20 + 1;
   end if;
end;

--  END <Token(<WithText Pipe>, ) at parser.lkt:97:51>


      exit when Token_Pos120 = No_Token_Index;

      Lst_Cpos20 := Token_Pos120;

end loop;


declare
   Token_Start, Token_End : Token_Index;
   Count                  : constant Natural := Tmp_List20.Nodes.Length;
begin
   List_Res20 := Allocate_Discriminant_Choice_List (Parser.Mem_Pool);

   if Count > 0 then
      Token_Start := Row_Pos78;
      Token_End := (if Lst_Cpos20 = Row_Pos78
                    then Row_Pos78
                    else List_Pos20 - 1);

   else
      Token_Start := Token_Index'Max (Row_Pos78, 1);
      Token_End := No_Token_Index;
   end if;

   Initialize
     (Self              => List_Res20,
      Kind              => Ada_Discriminant_Choice_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Token_Start,
      Token_End_Index   => Token_End);
   Initialize_List
     (Self   => List_Res20,
      Parser => Parser,
      Count  => Count);

   declare
      Vec : Bare_Ada_Node_Vectors.Vector renames
         Tmp_List20.Nodes;
      Arr : Alloc_AST_List_Array.Element_Array_Access renames
         List_Res20.Nodes;
   begin
      Arr := Alloc_AST_List_Array.Alloc (Parser.Mem_Pool, Vec.Length);
      for I in Vec.First_Index .. Vec.Last_Index loop
         Arr (I) := Vec.Get (I);
      end loop;
   end;
end;

Release_Parse_List (Parser, Tmp_List20);

--  END <List at parser.lkt:97:15>




if List_Pos20 /= No_Token_Index then

   Row_Pos78 := List_Pos20;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;


--  BEGIN <Token(<WithText Arrow>, ) at parser.lkt:97:56>

Token_Res121 := Row_Pos78;

declare
   T : constant Stored_Token_Data :=
      Token_Vectors.Get (Parser.TDH.Tokens, Natural (Token_Res121));
begin
   if
      T.Kind /= From_Token_Kind (Ada_Arrow)
   then
       Token_Pos121 := No_Token_Index;

       if Parser.Last_Fail.Pos <= Row_Pos78 then
          Parser.Last_Fail :=
            (Kind              => Token_Fail,
             Pos               => Row_Pos78,
             Expected_Token_Id => Ada_Arrow,
             Found_Token_Id    => To_Token_Kind (T.Kind));
       end if;
   else
          Token_Pos121 := Row_Pos78 + 1;
   end if;
end;

--  END <Token(<WithText Arrow>, ) at parser.lkt:97:56>




if Token_Pos121 /= No_Token_Index then

   Row_Pos78 := Token_Pos121;

else
   Row_Pos78 := No_Token_Index;
   goto Exit_Row78_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row78_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>

--  END <_Extract at parser.lkt:97:10>


if Row_Pos78 = No_Token_Index then

         
   List_Res20 :=
     Allocate_Discriminant_Choice_List (Parser.Mem_Pool);
   Initialize
     (Self              => List_Res20,
      Kind              => Ada_Discriminant_Choice_List,
      Unit              => Parser.Unit,
      Token_Start_Index => Row_Pos77 - 1,
      Token_End_Index   => No_Token_Index);
   Initialize_List
     (Self   => List_Res20,
      Parser => Parser,
      Count  => 0);



       
   Row_Pos78 := Row_Pos77;



end if;

--  END <Opt at parser.lkt:97:9>



Row_Progress10 := 1;

if Row_Pos78 /= No_Token_Index then

   Row_Pos77 := Row_Pos78;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;


--  BEGIN <Cut at ???>
Nobt10 := True;
--  END <Cut at ???>


   Nobt10 := Nobt10;

Row_Progress10 := 2;

if Row_Pos77 /= No_Token_Index then

   Row_Pos77 := Row_Pos77;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;


--  BEGIN <Or at parser.lkt:101:9>

Or_Pos29 := No_Token_Index;
Or_Res29 := No_Bare_Ada_Node;
    
--  BEGIN <Defer at parser.lkt:101:14>

Defer_Res140 :=
   Discrete_Range_Or_Parse1 (Parser, Row_Pos77);
Defer_Pos140 := Parser.Current_Pos;

--  END <Defer at parser.lkt:101:14>

    if Defer_Pos140 /= No_Token_Index then
        Or_Pos29 := Defer_Pos140;
        Or_Res29 := Defer_Res140;
        goto Exit_Or30;
    end if;
    
--  BEGIN <Defer at parser.lkt:101:31>

Defer_Res141 :=
   Discrete_Subtype_Indication_Transform_Parse0 (Parser, Row_Pos77);
Defer_Pos141 := Parser.Current_Pos;

--  END <Defer at parser.lkt:101:31>

    if Defer_Pos141 /= No_Token_Index then
        Or_Pos29 := Defer_Pos141;
        Or_Res29 := Defer_Res141;
        goto Exit_Or30;
    end if;
    
--  BEGIN <Defer at parser.lkt:101:61>

Defer_Res142 :=
   Expr_Or_Parse0 (Parser, Row_Pos77);
Defer_Pos142 := Parser.Current_Pos;

--  END <Defer at parser.lkt:101:61>

    if Defer_Pos142 /= No_Token_Index then
        Or_Pos29 := Defer_Pos142;
        Or_Res29 := Defer_Res142;
        goto Exit_Or30;
    end if;
<<Exit_Or30>>

--  END <Or at parser.lkt:101:9>



Row_Progress10 := 3;

if Or_Pos29 /= No_Token_Index then

   Row_Pos77 := Or_Pos29;

else
   Row_Pos77 := No_Token_Index;
   goto Exit_Row77_0;

end if;

pragma Warnings (Off, "referenced");
<<Exit_Row77_0>>
pragma Warnings (On, "referenced");

--  END <_Row at ???>


if Row_Pos77 = No_Token_Index and then Nobt10 then

   Row_Pos77 := Parser.Last_Fail.Pos;

   Transform_Has_Failed10 := True;
end if;

if Row_Pos77 /= No_Token_Index then

   Transform_Res62 := Allocate_Composite_Constraint_Assoc (Parser.Mem_Pool);

   Initialize
     (Self => Transform_Res62,
      Kind => Ada_Composite_Constraint_Assoc,
      Unit => Parser.Unit,

      Token_Start_Index => Pos,
      Token_End_Index   => (if Row_Pos77 = Pos
                            then No_Token_Index
                            else Row_Pos77 - 1));

      
      Initialize_Fields_For_Composite_Constraint_Assoc
        (Self => Transform_Res62,
         Composite_Constraint_Assoc_F_Ids => List_Res20,
         Composite_Constraint_Assoc_F_Constraint_Expr => Or_Res29);

         if List_Res20 /= null and then Is_Incomplete (List_Res20) then
            Transform_Res62.Last_Attempted_Child := 0;
         elsif List_Res20 /= null and then not Is_Ghost (List_Res20) then
            Transform_Res62.Last_Attempted_Child := -1;
         end if;
         if Or_Res29 /= null and then Is_Incomplete (Or_Res29) then
            Transform_Res62.Last_Attempted_Child := 0;
         elsif Or_Res29 /= null and then not Is_Ghost (Or_Res29) then
            Transform_Res62.Last_Attempted_Child := -1;
         end if;

   if Transform_Has_Failed10 then
      Transform_Res62.Last_Attempted_Child :=
         Row_Progress10;

      Append (Parser.Diagnostics,
              Sloc_Range (Parser.TDH.all,
                          Get_Token (Parser.TDH.all, Pos)),
              To_Text ("Cannot parse <composite_constraint_assoc>"));

      Add_Last_Fail_Diagnostic (Parser);
   end if;

elsif Row_Pos77 = No_Token_Index then
   Parser.Diagnostics.Set_Length (Transform_Diags62);
end if;

--  END <Transform(<CompiledType BareCompositeConstraintAssoc>) at parser.lkt:95:35>


   -------------------------------
   --