//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// UI スレッドへのメッセージ機構 (CLI 側)
//

#include "nono.h"
#include "cuimessage.h"
#include "kevent.h"

/*static*/ autofd CUIMessage::wpipe;
/*static*/ autofd CUIMessage::rpipe;

// CUIMessage の初期化。パイプを用意して kqueue ディスクリプタを返す。
int
CUIMessage::Init()
{
	int kq;
	int fds[2];

	kq = kqueue();
	if (kq < 0) {
		warn("CUIMessage::Init: kqueue");
		return -1;
	}

	if (pipe(fds) < 0) {
		warn("CUIMessage::Init: pipe");
		close(kq);
		return -1;
	}

	rpipe = fds[0];
	wpipe = fds[1];

	if (kevent_add(kq, rpipe, EVFILT_READ, EV_ADD, 0) < 0) {
		warn("CUIMessage::Init: kevent_add");
		close(kq);
		return -1;
	}

	return kq;
}

// UIMessage::Post() で呼ばれるコールバック関数。
/*static*/ void
CUIMessage::Process(uint id, int arg)
{
	if (id >= UIMessage::ID_MAX) {
		PANIC("Invalid UIMessage %u", (uint)id);
	}

	union64 m;
	m.h = id;
	m.l = arg;

	// パイプで通知。
	int r;
	r = write(wpipe, &m, sizeof(m));
	if (r < 0) {
		warn("CUIMessage::Process: write");
		return;
	}
	if (r < sizeof(m)) {
		warnx("CUIMessage::Process: write: too short");
		return;
	}
}
