//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// CRTC
//

#pragma once

#include "device.h"

class MFPDevice;
class TVRAMDevice;
class VideoCtlrDevice;

struct CRTC
{
	//      15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R00 |               -               |         水平トータル          |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R01 |               -               |       水平同期終了位置        |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R02 |               -               |       水平表示開始位置        |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R03 |               -               |       水平表示終了位置        |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	//
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R04 |           -           |              垂直トータル             |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R05 |           -           |            垂直同期終了位置           |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R06 |           -           |            垂直表示開始位置           |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R07 |           -           |            垂直表示終了位置           |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	//
	//      15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R08 |               -               |     外部同期水平アジャスト    |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R09 |           -           |              ラスタ番号               |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R10 |           -           |    テキスト画面スクロール X位置       |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R11 |           -           |    テキスト画面スクロール Y位置       |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	//
	//      15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R12 |           -           |     グラフィック画面スクロール X0     |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R13 |           -           |     グラフィック画面スクロール Y0     |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R14 |               -           |   グラフィック画面スクロール X1   |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R15 |               -           |   グラフィック画面スクロール Y1   |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R16 |               -           |   グラフィック画面スクロール X2   |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R17 |               -           |   グラフィック画面スクロール Y2   |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R18 |               -           |   グラフィック画面スクロール X3   |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R19 |               -           |   グラフィック画面スクロール Y3   |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	//
	//      15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R20 |       -       |MEM|SIZ|  COL  |     -     |HF |  VD   |   HD  |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R21 |           -           |MEN|SA |       AP      |       CP      |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R22 |          ソースラスタ         |   デスティネーションラスタ    |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// R23 |                          マスクパターン                       |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	//
	//      15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
	// OP  |                       -                       |RC | 0 |FC |VI |
	//     +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+

	uint16 r[24];
	uint16 op;

	static const uint32 R00		= 0x00;		// $E80000
	static const uint32 R01		= 0x01;		// $E80002
	static const uint32 R02		= 0x02;		// $E80004
	static const uint32 R03		= 0x03;		// $E80006
	static const uint32 R04		= 0x04;		// $E80008
	static const uint32 R05		= 0x05;		// $E8000A
	static const uint32 R06		= 0x06;		// $E8000C
	static const uint32 R07		= 0x07;		// $E8000E
	static const uint32 R08		= 0x08;		// $E80010
	static const uint32 R09		= 0x09;		// $E80012
	static const uint32 R10		= 0x0a;		// $E80014
	static const uint32 R11		= 0x0b;		// $E80016
	static const uint32 R12		= 0x0c;		// $E80018
	static const uint32 R13		= 0x0d;		// $E8001A
	static const uint32 R14		= 0x0e;		// $E8001C
	static const uint32 R15		= 0x0f;		// $E8001E
	static const uint32 R16		= 0x10;		// $E80020
	static const uint32 R17		= 0x11;		// $E80022
	static const uint32 R18		= 0x12;		// $E80024
	static const uint32 R19		= 0x13;		// $E80026
	static const uint32 R20		= 0x14;		// $E80028
	static const uint32 R21		= 0x15;		// $E8002A
	static const uint32 R22		= 0x16;		// $E8002C
	static const uint32 R23		= 0x17;		// $E8002E
	static const uint32 REG_END	= 0x18;
	static const uint32 REG_OP	= 0x240;	// $E80480

	// R20
	static const uint16 R20_MEM	= 0x0800;
	static const uint16 R20_SIZ	= 0x0400;
	static const uint16 R20_COL	= 0x0300;
	static const uint16 R20_HF	= 0x0010;
	static const uint16 R20_VD	= 0x000c;
	static const uint16 R20_HD	= 0x0003;

	// 動作ポート
	static const uint32 OP_RC	= 0x08;		// ラスターコピー開始(%1)
	static const uint32 OP_FC	= 0x02;		// 高速クリア開始(%1)
	static const uint32 OP_VI	= 0x01;		// 画像取り込み開始(%1)
};

class CRTCDevice : public IODevice
{
	using inherited = IODevice;
 public:
	CRTCDevice();
	~CRTCDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 offset) override;

 private:
	static inline uint32 Decoder(uint32 addr);

	// ワード読み出し
	busdata Peek2(uint32 addr) const;
	// レジスタへの書き込み
	void SetReg(uint32 offset, uint32 data);
	// 動作ポートへの書き込み
	void WriteOp(uint32 data);

	// 水平同期信号イベント
	void HSyncCallback(Event *);

	// ラスターコピー完了イベント
	void RasterCallback(Event *);

	// 垂直表示期間イベント
	void VDispCallback(Event *);

	DECLARE_MONITOR_SCREEN(MonitorScreen);

	struct CRTC crtc {};

	// ラスターコピー指示
	bool raster_copy {};

	// XXX もうちょっとなんとかする
	uint hsync_state {};
	uint vdisp_state {};

	MFPDevice *mfp {};
	TVRAMDevice *tvram {};
	VideoCtlrDevice *videoctlr {};

	Event *hsync_event {};
	Event *vdisp_event {};
	Event *raster_event {};

	Monitor *monitor {};

	static const busdata wait;
};
