//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// Goldfish (Qemu) RTC+Timer (の RTC のほう)
//

#pragma once

#include "rtc.h"

class TextScreen;

// GFRTC/GFTimer 共通
class GFRTC
{
 public:
	static const uint TIME_LOW		= 0x00U >> 2;
	static const uint TIME_HIGH		= 0x04U >> 2;
	static const uint ALARM_LOW		= 0x08U >> 2;
	static const uint ALARM_HIGH	= 0x0cU >> 2;
	static const uint INTR_STATUS	= 0x10U >> 2;
	static const uint ALARM_CLEAR	= 0x14U >> 2;
	static const uint ALARM_STATUS	= 0x18U >> 2;
	static const uint INTR_CLEAR	= 0x1cU >> 2;
};

class GFRTCDevice : public RTCDevice
{
	using inherited = RTCDevice;

 public:
	GFRTCDevice();
	~GFRTCDevice() override;

	void ResetHard(bool poweron) override;

	// モニタの下請け。(GFTimer から呼ばれる)
	int MonitorScreenRTC(TextScreen&, int y) const;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 0x1000 >> 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);

 private:
	void Tick1Hz() override;

	time_t MkTime() const;

	uint GetSec()  const override { return sec; }
	uint GetMin()  const override { return min; }
	uint GetHour() const override { return hour; }
	uint GetWday() const override;
	uint GetMday() const override { return day; }
	uint GetMon()  const override { return mon; }
	uint GetYear() const override { return year; }
	uint GetLeap() const override { return year % 4; }

	void SetSec(uint v)  override { sec = v; }
	void SetMin(uint v)  override { min = v; }
	void SetHour(uint v) override { hour = v; }
	void SetWday(uint v) override { }
	void SetMday(uint v) override { day = v; }
	void SetMon(uint v)  override { mon = v; }
	void SetYear(uint v) override { year = v; }
	void SetLeap(uint v) override { }

	// 現在時刻
	uint year;	// 西暦 (ゲタなし)
	uint mon;	// 月 (1-12)
	uint day;
	uint hour;
	uint min;
	uint sec;

	// TIME レジスタラッチ
	uint64 time_nsec {};
};
