//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// ベクタテーブル (モニタ)
//

#pragma once

#include "device.h"
#include <array>
#include <map>
#include <vector>

class MainbusDevice;
class MainMPUDevice;
enum class VMType;

class VectorTable : public Device
{
	using inherited = Device;

 public:
	explicit VectorTable(VMType vmtype);
	~VectorTable() override;

	bool Init() override;

	// 例外名を返す (例外履歴用)
	const char *GetExceptionName(int vector) const;

	// ベクタテーブルの要素数を返す
	int Size() const { return nametable.size(); }

 private:
	// 初期化
	void InitTableM680x0(VMType vmtype);
	void InitTableLuna88k();

	// モニタ更新
	DECLARE_MONITOR_SCREEN(MonitorScreenM680x0);
	DECLARE_MONITOR_SCREEN(MonitorScreenM88xx0);

	// m88100 のベクタテーブルから再分岐先を取得する。
	busaddr VectorToAddr(uint32 vecaddr);

	// ベクタテーブル
	std::vector<const char *> nametable {};

	MainbusDevice *mainbus {};
	MainMPUDevice *mpu {};

	// モニタ
	Monitor *monitor {};

	// 初期値
	static std::array<const char * const, 64>  name_m680x0;
	static std::map<int, const char * const>   name_x68030;
	static std::map<int, const char * const>   name_luna1;
	static std::map<int, const char * const>   name_news;
	static std::map<int, const char * const>   name_virt68k;
	static std::map<int, const char * const>   name_luna88k;
};

inline VectorTable *GetVectorTable() {
	return Object::GetObject<VectorTable>(OBJ_VECTOR_TABLE);
}
