//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// シグナルスレッド
//

#pragma once

#include "thread.h"

class SignalThread : public ThreadDevice
{
	using inherited = ThreadDevice;

 public:
	SignalThread();
	~SignalThread() override;

	bool StartThread() override;
	void ThreadRun() override;
	void Terminate() override;

	// このスレッドにシグナルを投げる
	void Kill(int signo);

 private:
	// シグナルをブロック/アンブロックする
	void Mask(int how, int signo);

	// ブロックするシグナル集合
	sigset_t waitset {};

	// コマンド(フラグ)
	// 終了フラグは立てるだけ、読むだけなので atomic じゃなくてもいいはず。
	volatile bool request_terminate {};
};

inline SignalThread *GetSignalThread() {
	return Object::GetObject<SignalThread>(OBJ_SIGNAL_THREAD);
}
