//
// nono
// Copyright (C) 2025 nono project
// Licensed under nono-license.txt
//

//
// ホストサウンドのドライバ (基本クラス)
//

#include "sounddriver.h"
#include "hostsound.h"

// コンストラクタ
SoundDriver::SoundDriver(HostDevice *hostdev_, const char *drivername_)
	: inherited(hostdev_, drivername_)
{
}

// デストラクタ
SoundDriver::~SoundDriver()
{
}

bool
SoundDriver::InitDriver(bool startup)
{
	if (inherited::InitDriver(startup) == false) {
		return false;
	}

	// 必要なパラメータをコピー。
	auto hostsnd = dynamic_cast<HostSoundDevice *>(hostdev);
	freq = hostsnd->freq;
	blkbytes = hostsnd->bytes_per_blk;

	return true;
}
