#!/usr/bin/env perl

#
# nono
# Copyright (C) 2023 nono project
# Licensed under nono-license.txt
#

# z80-asm の出力する .z80 形式を .COM に変換する。
# (10バイトのヘッダを取り除くだけ)
#
# usage: z80tocom.pl <infile.z80> [<outfile.com>]

{
	$filename = $ARGV[0];
	$filesize = -s $filename;

	if (@ARGV > 1) {
		$outfile = $ARGV[1];
	} else {
		$outfile = $filename;
		$outfile =~ s/(\.z80|)$/.com/;
	}

	# ファイルを全部読み込む
	open(IN, $filename) or die;
	binmode(IN);
	read(IN, $magic, 8);
	read(IN, $dummylen, 2);
	read(IN, $data, $filesize - 10);
	close(IN);

	# マジック照合
	if ($magic != "Z80ASM\x1a\x0a") {
		die("${filename} is not .z80 object format");
	}

	# 出力
	open(OUT, ">$outfile") or die;
	binmode(OUT);
	print OUT $data;
	close(OUT);

	exit 0;
}
