//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// サブメモリ
//

#pragma once

#include "device.h"

// サブメモリ (基本クラス)
class SubRAMBaseDevice : public IODevice
{
	using inherited = IODevice;
 public:
	SubRAMBaseDevice(uint objid_, uint ramsize_kb);
	~SubRAMBaseDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

	// XP からのバイトアクセス
	busdata Read1(uint32 addr) override;
	busdata Write1(uint32 addr, uint32 data) override;

	// Lance からのワードアクセス (これは override ではない)
	busdata Read2(uint32 addr);
	busdata Write2(uint32 addr, uint32 data);
	busdata Peek2(uint32 addr) const;

 private:
	// アドレスデコーダ
	uint32 Decoder(uint32 addr) const;

	// RAM 容量(バイト単位)を取得
	uint GetSize() const { return mask + 1; }

	std::unique_ptr<uint8[]> ram {};
	uint32 mask {};
};

// サブメモリ (XP/Lance との共有 RAM)
class SubRAMDevice : public SubRAMBaseDevice
{
	using inherited = SubRAMBaseDevice;
 public:
	explicit SubRAMDevice(uint ramsize_kb);
	~SubRAMDevice() override;

	void ResetHard(bool poweron) override;
};

// サブメモリ 2 (XP の非共有部)
class SubRAM2Device : public SubRAMBaseDevice
{
	using inherited = SubRAMBaseDevice;
 public:
	explicit SubRAM2Device(uint ramsize_kb);
	~SubRAM2Device() override;
};

inline SubRAMDevice *GetSubRAMDevice() {
	return Object::GetObject<SubRAMDevice>(OBJ_SUBRAM);
}
