//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// アクセス状況 (グラフィカル) ウィンドウ
//

#pragma once

#include "wxsubwindow.h"
#include "wxmonitor.h"

class MainbusDevice;

// アクセス状況 (グラフィカル) パネル
class WXAccStatPanel : public WXMonitorPanel
{
	using inherited = WXMonitorPanel;
 public:
	WXAccStatPanel(wxWindow *parent, Monitor *monitor_);
	~WXAccStatPanel() override;

	void FontChanged() override;
	void Draw() override;

 private:
	void CopyLine(int cx, int py, int clen);
	MainbusDevice *mainbus {};

	bool redraw_header {};

	bool is_x68030 {};
	bool bankram[2] {};
};

// アクセス状況 (グラフィカル) ウィンドウ
class WXAccStatWindow : public WXSubWindow
{
	using inherited = WXSubWindow;
 public:
	WXAccStatWindow(wxWindow *parent, Monitor *monitor_);
	~WXAccStatWindow() override;
};
