//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// メインバス (X68030)
//

#pragma once

#include "mainbus.h"

class BankRAMDevice;
class ExtRAMDevice;
class X68kIODevice;

class X68kMainbus final : public MainbusDevice
{
	using inherited = MainbusDevice;
 public:
	X68kMainbus();
	~X68kMainbus() override;

	bool Init() override;
	bool InitMainbus() override;
	void ResetByMPU() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

 private:
	DECLARE_MONITOR_SCREEN(MonitorScreen);
	DECLARE_MONITOR_SCREEN(MonitorScreenAccStat);

	inline bool IsIntio(uint32) const;

	// ブートページを切り替える。
	void SwitchBootPage(bool isrom) override;

	std::unique_ptr<ExtRAMDevice> pExtRAM /*{}*/;
	std::unique_ptr<X68kIODevice> pX68kIO /*{}*/;
	// どこに置く?
	std::unique_ptr<IODevice> pInterrupt {};

	std::array<bool, 256> is_intio {};

	Monitor *monitor {};

	std::array<BankRAMDevice*, 2> bankram /*{}*/;
};
