/* id32_dboot.c: Interdata 32b simulator disk bootstrap

   Copyright (c) 2000-2008, Robert M. Supnik

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   ROBERT M SUPNIK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   Except as contained in this notice, the name of Robert M Supnik shall not be
   used in advertising or otherwise to promote the sale, use or other dealings
   in this Software without prior written authorization from Robert M Supnik.

   17-Jul-06    RMS     Fixed transcription errors (Davis Johnson)
   17-Feb-03    RMS     Fixed for UNIX bootstrap, upper platter bootstrap
*/

#include "id_defs.h"

#define DBOOT_BEG       0x1000
#define DBOOT_START     0x100E
#define DBOOT_LEN       (sizeof (dboot_rom) / sizeof (uint8))

/* Transcribed from 32b Bootstrap Loader, 03-074N81R03A13 */

static uint8 dboot_rom[] = {
 0xca, 0xf0, 0x00, 0x30,
 0xc5, 0xf0, 0x00, 0x3a,
 0x02, 0x8e,
 0x26, 0xf7,
 0x03, 0x0e,
 0xe6, 0xd0, 0x0f, 0x30,
 0xd1, 0xe0, 0x00, 0x78,
 0xd0, 0xed, 0x03, 0x40,
 0xd3, 0xf0, 0x00, 0x7e,
 0xc4, 0xf0, 0x00, 0x0f,
 0x41, 0xed, 0x00, 0xd0,
 0xd2, 0xfd, 0x03, 0x25,
 0xd3, 0xf0, 0x00, 0x7f,
 0x10, 0xf4,
 0x41, 0xed, 0x00, 0xd0,
 0xd2, 0xfd, 0x03, 0x26,
 0xd3, 0xf0, 0x00, 0x7f,
 0xc4, 0xf0, 0x00, 0x0f,
 0x41, 0xed, 0x00, 0xd0,
 0xd2, 0xfd, 0x03, 0x27,
 0xd3, 0x20, 0x00, 0x7d,
 0xd3, 0x30, 0x00, 0x7c,
 0xd3, 0x40, 0x00, 0x7a,
 0x24, 0x50,
 0xd3, 0xf0, 0x00, 0x7b,
 0xcb, 0xf0, 0x00, 0x33,
 0x23, 0x23,
 0x11, 0xf1,
 0x08, 0x5f,
 0xe6, 0x7d, 0x03, 0x50,
 0xe6, 0x8d, 0x04, 0x4f,
 0x07, 0xcc,
 0x41, 0xed, 0x01, 0xfc,
 0xd1, 0xed, 0x03, 0x5c,
 0xd0, 0xed, 0x03, 0x48,
 0x58, 0xcd, 0x03, 0x58,
 0x43, 0x3d, 0x01, 0x9c,
 0xe6, 0x7d, 0x03, 0x50,
 0x41, 0xed, 0x01, 0xfc,
 0xe6, 0xed, 0x03, 0x54,
 0x24, 0x15,
 0xf8, 0xf0, 0x4f, 0x53, 0x33, 0x32,
 0xd3, 0x7e, 0x00, 0x24,
 0xc3, 0x70, 0x00, 0x10,
 0x23, 0x3e,
 0xc3, 0x70, 0x00, 0xe0,
 0x21, 0x3b,
 0x55, 0xfe, 0x00, 0x00,
 0x21, 0x38,
 0x58, 0x6e, 0x00, 0x08,
 0x10, 0x68,
 0x55, 0x6d, 0x03, 0x24,
 0x43, 0x3d, 0x01, 0xb2,
 0xca, 0xe0, 0x00, 0x30,
 0x27, 0x11,
 0x42, 0x3d, 0x01, 0x66,
 0x58, 0xcd, 0x03, 0x50,
 0x42, 0x3d, 0x01, 0x52,
 0x48, 0x10, 0x00, 0x7e,
 0x42, 0x3d, 0x02, 0xf0,
 0x58, 0xcd, 0x03, 0x48,
 0x43, 0x3d, 0x02, 0xf0,
 0x58, 0x8d, 0x03, 0x4c,
 0x23, 0x07,
 0x58, 0xce, 0x00, 0x0c,
 0x58, 0x8e, 0x00, 0x10,
 0x0b, 0x8c,
 0x26, 0xc1,
 0x11, 0x88,
 0x08, 0x18,
 0xe6, 0xf0, 0x11, 0x18,
 0x58, 0x0f, 0x00, 0x00,
 0x50, 0x01, 0x00, 0x00,
 0x59, 0x01, 0x00, 0x00,
 0x42, 0x3d, 0x03, 0x08,
 0x26, 0xf4,
 0x26, 0x14,
 0xc5, 0xf0, 0x12, 0x78,
 0x20, 0x8c,
 0x08, 0xd8,
 0xcb, 0xd0, 0x01, 0xe8,
 0x03, 0x08,
 0x27, 0x81,
 0x07, 0x77,
 0x41, 0xed, 0x01, 0xfc,
 0xd1, 0xed, 0x03, 0x40,
 0xd0, 0xe0, 0x00, 0x78,
 0x43, 0x00, 0x00, 0x60,
 0xde, 0x2d, 0x03, 0x28,
 0x08, 0x0c,
 0x4d, 0x0d, 0x45, 0x00, 0x03, 0x30,
 0x08, 0x91,
 0x4d, 0x0d, 0x45, 0x00, 0x03, 0x38,
 0x08, 0xa1,
 0x08, 0xb0,
 0x08, 0x55,
 0x42, 0x2d, 0x02, 0x4a,
 0xde, 0x3d, 0x03, 0x28,
 0x9d, 0x3f,
 0x22, 0x21,
 0x9d, 0x4f,
 0x42, 0x1d, 0x02, 0xf4,
 0xc3, 0xf0, 0x00, 0x10,
 0x20, 0x35,
 0x11, 0xa5,
 0x06, 0xba,
 0x98, 0x49,
 0xde, 0x4d, 0x03, 0x2b,
 0x9d, 0x3f,
 0x22, 0x21,
 0x9d, 0x4f,
 0x42, 0x7d, 0x02, 0xf8,
 0x20, 0x83,
 0x41, 0x6d, 0x02, 0x96,
 0x22, 0x0b,
 0x9d, 0x4f,
 0xc3, 0xf0, 0x00, 0x19,
 0x42, 0x3d, 0x02, 0xfc,
 0xde, 0x4d, 0x03, 0x2c,
 0x9d, 0x3f,
 0x22, 0x21,
 0x98, 0x49,
 0xde, 0x4d, 0x03, 0x2e,
 0x9d, 0x3f,
 0x22, 0x21,
 0xde, 0x4d, 0x03, 0x2d,
 0x9d, 0x3f,
 0x22, 0x21,
 0x98, 0x4a,
 0xde, 0x4d, 0x03, 0x2f,
 0x9d, 0x3f,
 0x22, 0x21,
 0xde, 0x4d, 0x03, 0x2b,
 0x9d, 0x3f,
 0x22, 0x21,
 0x9d, 0x4f,
 0x20, 0x81,
 0xc3, 0xf0, 0x00, 0x53,
 0x42, 0x3d, 0x03, 0x00,
 0x08, 0xfa,
 0x11, 0xfa,
 0x06, 0xf9,
 0xe6, 0x6d, 0x02, 0x54,
 0x34, 0x77,
 0x9a, 0x27,
 0x34, 0x77,
 0x98, 0x27,
 0x34, 0x88,
 0x9a, 0x28,
 0x34, 0x88,
 0x98, 0x28,
 0x08, 0x55,
 0x21, 0x24,
 0x98, 0x49,
 0x9a, 0x3b,
 0x23, 0x03,
 0x9a, 0x3b,
 0x98, 0x3f,
 0xde, 0x3d, 0x03, 0x2a,
 0xde, 0x2d, 0x03, 0x29,
 0x9d, 0x2f,
 0x20, 0x81,
 0xde, 0x2d, 0x03, 0x28,
 0x9b, 0x20,
 0x99, 0x21,
 0x34, 0x00,
 0x06, 0x01,
 0xde, 0x2d, 0x03, 0x28,
 0x9d, 0x3f,
 0x22, 0x21,
 0x42, 0x1d, 0x03, 0x04,
 0xc3, 0xf0, 0x00, 0x10,
 0x03, 0x3e,
 0x0b, 0x07,
 0x26, 0x04,
 0xc4, 0x00, 0xff, 0x00,
 0x0a, 0x70,
 0x26, 0x91,
 0x07, 0xaa,
 0x07, 0xbb,
 0x03, 0x06,
 0x24, 0x11,
 0x23, 0x0c,
 0x24, 0x12,
 0x23, 0x0a,
 0x24, 0x13,
 0x23, 0x08,
 0x24, 0x14,
 0x23, 0x06,
 0x24, 0x15,
 0x23, 0x04,
 0x24, 0x16,
 0x23, 0x02,
 0x24, 0x17,
 0x24, 0x01,
 0xde, 0x0d, 0x03, 0x28,
 0x9a, 0x01,
 0xde, 0x0d, 0x03, 0x28,
 0xd1, 0xed, 0x03, 0x40,
 0xd0, 0xe0, 0x00, 0x78,
 0x11, 0x0f,
 0x95, 0x10,
 0x22, 0x01,
 0x00, 0x00, 0x00, 0x00,
 0x48, 0x30,
 0xc1, 0xc2,
 0xc8, 0xc4,
 0xd0, 0xe0,
 0x00, 0x30,
 0x01, 0x90,
 0x01, 0x40,
 0x04, 0xc0,
 0x00, 0x18,
 0x00, 0x14,
 0x00, 0x40,
 0x00, 0x40,
 0x00
 };

/* Lower memory setup

        78      =       binary input device address
        79      =       binary device input command
        7A      =       disk device number
        7B      =       device code
        7C      =       disk controller address
        7D      =       selector channel address
        7E:7F   =       operating system extension (user specified)
*/

struct dboot_id {
    const char  *name;
    uint32      sw;
    uint32      cap;
    uint32      dtype;
    uint32      offset;
    uint32      adder;
    };

static struct dboot_id dboot_tab[] = {
    { "DP", 0,            2, 0x31, o_DP0, 0 },
    { "DP", SWMASK ('F'), 9, 0x32, o_DP0, o_DPF },
    { "DP", 0,            9, 0x33, o_DP0, 0 },
    { "DM", 0,           64, 0x35, o_ID0, 0 },
    { "DM", 0,          244, 0x36, o_ID0, 0 },
    { NULL }
    };

t_stat id_dboot (int32 u, DEVICE *dptr)
{
extern DIB ttp_dib, sch_dib;
extern uint32 PC;
uint32 i, typ, ctlno, off, add, cap, sch_dev;
UNIT *uptr;

DIB *ddib = (DIB *) dptr->ctxt;                         /* get disk DIB */
ctlno = ddib->dno;                                      /* get ctrl devno */
sch_dev = sch_dib.dno + ddib->sch;                      /* sch dev # */
uptr = dptr->units + u;                                 /* get capacity */
cap = uptr->capac >> 20;
for (i = typ = 0; dboot_tab[i].name != NULL; i++) {
    if ((strcmp (dboot_tab[i].name, dptr->name) == 0) &&
        ((dboot_tab[i].sw == 0) ||
        (dboot_tab[i].sw & sim_switches)) &&
        (dboot_tab[i].cap == cap)) {
        typ = dboot_tab[i].dtype;
        off = dboot_tab[i].offset;
        add = dboot_tab[i].adder;
        break;
        }
    }
if (typ == 0)
    return SCPE_NOFNC;

IOWriteBlk (DBOOT_BEG, DBOOT_LEN, dboot_rom);           /* copy boot */
IOWriteB (AL_DEV, ttp_dib.dno);                         /* bin input dev */
IOWriteB (AL_IOC, 0xa3);
IOWriteB (AL_DSKU, ctlno + ((u + 1) * off) + add);      /* disk dev addr */
IOWriteB (AL_DSKT, typ);                                /* disk type */
IOWriteB (AL_DSKC, ctlno);                              /* disk ctl addr */
IOWriteB (AL_SCH, sch_dev);
PC = DBOOT_START;
return SCPE_OK;
}
