/*
 * Copyright 2002-2020 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the Apache License 2.0 (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */

/*
 * AES low level APIs are deprecated for public use, but still ok for internal
 * use where we're using them to implement the higher level EVP interface, as is
 * the case here.
 */
#include "internal/deprecated.h"

#include <openssl/aes.h>
#include <openssl/modes.h>

void AES_cbc_encrypt(const unsigned char *in, unsigned char *out,
    size_t len, const AES_KEY *key,
    unsigned char *ivec, const int enc)
{

    if (enc)
        CRYPTO_cbc128_encrypt(in, out, len, key, ivec,
            (block128_f)AES_encrypt);
    else
        CRYPTO_cbc128_decrypt(in, out, len, key, ivec,
            (block128_f)AES_decrypt);
}
