# MD032 - Separate lists with blank lines

Aliases: `blanks-around-lists`

## What this rule does

Ensures lists have blank lines before and after them, making them visually distinct from surrounding content.

## Why this matters

- **Reliable parsing**: Many Markdown parsers require blank lines to properly recognize lists
- **Visual clarity**: Blank lines make lists stand out from paragraphs
- **Better readability**: Clear separation helps readers scan documents quickly
- **Consistent rendering**: Prevents lists from merging with adjacent content

## Examples

### ✅ Correct

```markdown
Text before the list.

* Item 1
* Item 2
* Item 3

Text after the list.
```

### ❌ Incorrect

<!-- rumdl-disable MD032 -->

```markdown
Text before the list.
* Item 1
* Item 2
* Item 3
Text after the list.
```

<!-- rumdl-enable MD032 -->

### 🔧 Fixed

```markdown
Text before the list.

* Item 1
* Item 2
* Item 3

Text after the list.
```

## Configuration

| Option                    | Type    | Default | Description                                                           |
| ------------------------- | ------- | ------- | --------------------------------------------------------------------- |
| `allow-lazy-continuation` | boolean | `true`  | Whether to allow lazy continuation (unindented text after list items) |

### Lazy continuation

By default, this rule allows "lazy continuation" - a CommonMark feature where unindented text following a list item becomes part of that list item:

```markdown
1. List item
Some text that continues the list item.
```

When `allow-lazy-continuation` is set to `false`, the rule requires a blank line between the list item and any following unindented text:

```toml
[MD032]
allow-lazy-continuation = false
```

With this setting, the above example would trigger a warning and be auto-fixed to:

```markdown
1. List item
   Some text that continues the list item.
```

The fix adds proper indentation to align with the list item's content column, making the continuation explicit rather than relying on lazy continuation behavior.

## Automatic fixes

This rule will:

- Add a blank line before lists that follow other content
- Add a blank line after lists that precede other content
- Handle nested lists correctly (only the outermost list needs surrounding blank lines)
- When `allow-lazy-continuation` is `false`: add proper indentation to lazy continuation lines

## Learn more

- [CommonMark Spec: Lists](https://spec.commonmark.org/0.31.2/#lists)
- [CommonMark Spec: Blank lines](https://spec.commonmark.org/0.31.2/#blank-lines)

## Related rules

- [MD022 - Separate headings with blank lines](md022.md)
- [MD031 - Separate code blocks with blank lines](md031.md)
- [MD004 - Use consistent list markers](md004.md)
- [MD058 - Separate tables with blank lines](md058.md)
