# MD065 - Blank lines around horizontal rules

Aliases: `blanks-around-horizontal-rules`

## What this rule does

Ensures horizontal rules (thematic breaks) have blank lines before and after them for better visual separation.

## Why this matters

- **Improves readability**: Blank lines around horizontal rules create clear visual breaks between sections
- **Consistent formatting**: Ensures all horizontal rules are styled the same way throughout the document
- **Better rendering**: Some markdown parsers may behave unexpectedly without blank lines around horizontal rules
- **Matches common conventions**: Most markdown style guides recommend blank lines around thematic breaks

## Examples

### ✅ Correct

```markdown
This is the first section.

---

This is the second section.
```

### ❌ Incorrect

```markdown
This is the first section.
---
This is the second section.
```

### 🔧 Fixed

```markdown
This is the first section.

---

This is the second section.
```

## Configuration

```toml
[MD065]
minimum-before = 1  # Minimum blank lines before horizontal rule (default: 1)
minimum-after = 1   # Minimum blank lines after horizontal rule (default: 1)
```

### Configuration options explained

- `minimum-before`: The minimum number of blank lines required before a horizontal rule (default: `1`)
- `minimum-after`: The minimum number of blank lines required after a horizontal rule (default: `1`)

## Exceptions

This rule does NOT flag horizontal rules in the following contexts:

### 1. Start of Document

No blank line is required before a horizontal rule at the very start of a document:

```markdown
---

Content after horizontal rule.
```

### 2. End of Document

No blank line is required after a horizontal rule at the end of a document:

```markdown
Content before horizontal rule.

---
```

### 3. Code Blocks

Horizontal rule patterns inside code blocks are not checked:

````markdown
```
---
```
````

### 4. Setext Headings

Setext heading underlines (which look like horizontal rules) are not flagged:

```markdown
Heading
---

This is correct - the --- is part of the heading, not a horizontal rule.
```

## Horizontal Rule Formats

This rule recognizes all valid horizontal rule formats:

- Hyphens: `---`, `----`, `- - -`
- Asterisks: `***`, `****`, `* * *`
- Underscores: `___`, `____`, `_ _ _`

All formats require at least 3 characters.

## Fix

The automatic fix adds the required blank lines before and/or after horizontal rules.

Before:

```markdown
Text before.
---
Text after.
```

After:

```markdown
Text before.

---

Text after.
```

## Related Rules

- [MD012](md012.md) - Multiple consecutive blank lines
- [MD035](md035.md) - Horizontal rule style (consistency of `---` vs `***` vs `___`)
- [MD022](md022.md) - Headings should be surrounded by blank lines

## Version

Added in rumdl v0.0.196.
