#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 727
#define LARGE_STATE_COUNT 3
#define SYMBOL_COUNT 179
#define ALIAS_COUNT 11
#define TOKEN_COUNT 83
#define EXTERNAL_TOKEN_COUNT 7
#define FIELD_COUNT 43
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 115

enum ts_symbol_identifiers {
  sym_identifier = 1,
  aux_sym_program_token1 = 2,
  anon_sym_COLON_COLON = 3,
  anon_sym_SEMI = 4,
  anon_sym_return = 5,
  anon_sym_COMMA = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  sym_break = 9,
  anon_sym_if = 10,
  anon_sym_then = 11,
  anon_sym_end = 12,
  anon_sym_elseif = 13,
  anon_sym_else = 14,
  anon_sym_for = 15,
  anon_sym_EQ = 16,
  anon_sym_in = 17,
  anon_sym_while = 18,
  anon_sym_repeat = 19,
  anon_sym_until = 20,
  anon_sym_do = 21,
  anon_sym_not = 22,
  anon_sym_POUND = 23,
  anon_sym_DASH = 24,
  anon_sym_TILDE = 25,
  anon_sym_or = 26,
  anon_sym_and = 27,
  anon_sym_LT = 28,
  anon_sym_LT_EQ = 29,
  anon_sym_EQ_EQ = 30,
  anon_sym_TILDE_EQ = 31,
  anon_sym_GT_EQ = 32,
  anon_sym_GT = 33,
  anon_sym_PIPE = 34,
  anon_sym_AMP = 35,
  anon_sym_LT_LT = 36,
  anon_sym_GT_GT = 37,
  anon_sym_PLUS = 38,
  anon_sym_STAR = 39,
  anon_sym_SLASH = 40,
  anon_sym_SLASH_SLASH = 41,
  anon_sym_PERCENT = 42,
  anon_sym_DOT_DOT = 43,
  anon_sym_CARET = 44,
  anon_sym_is = 45,
  anon_sym_as = 46,
  anon_sym_type = 47,
  anon_sym_COLON = 48,
  anon_sym_LBRACK = 49,
  anon_sym_RBRACK = 50,
  anon_sym_LBRACE = 51,
  anon_sym_RBRACE = 52,
  anon_sym_DOT = 53,
  anon_sym_local = 54,
  anon_sym_global = 55,
  anon_sym_function = 56,
  anon_sym_macroexp = 57,
  anon_sym_DOT_DOT_DOT = 58,
  sym_optional_marker = 59,
  anon_sym_record = 60,
  anon_sym_interface = 61,
  anon_sym_enum = 62,
  anon_sym_userdata = 63,
  anon_sym_metamethod = 64,
  anon_sym_where = 65,
  anon_sym_goto = 66,
  aux_sym_number_token1 = 67,
  aux_sym_number_token2 = 68,
  aux_sym_number_token3 = 69,
  anon_sym_true = 70,
  anon_sym_false = 71,
  anon_sym_PERCENT2 = 72,
  sym_format_specifier = 73,
  sym_escape_sequence = 74,
  sym_nil = 75,
  sym_comment = 76,
  sym__long_string_start = 77,
  sym__long_string_char = 78,
  sym__long_string_end = 79,
  sym__short_string_start = 80,
  sym__short_string_char = 81,
  sym__short_string_end = 82,
  sym_program = 83,
  sym__statement = 84,
  sym_return_statement = 85,
  sym_if_statement = 86,
  sym_elseif_block = 87,
  sym_else_block = 88,
  sym_numeric_for_statement = 89,
  sym_generic_for_statement = 90,
  sym__for_statement = 91,
  sym_while_statement = 92,
  sym_repeat_statement = 93,
  sym_do_statement = 94,
  sym__expression = 95,
  sym_parenthesized_expression = 96,
  sym_unary_op = 97,
  sym_bin_op = 98,
  sym_type_cast = 99,
  sym_type_tuple = 100,
  sym_type_union = 101,
  sym_var_declarator = 102,
  sym_var_declarators = 103,
  sym_expressions = 104,
  sym_var_declaration = 105,
  sym__type_def = 106,
  sym_type_declaration = 107,
  sym_assignment_variables = 108,
  sym_var_assignment = 109,
  sym__prefix_expression = 110,
  sym_method_index = 111,
  sym_arguments = 112,
  sym_function_call = 113,
  sym_table_entry = 114,
  sym_table_constructor = 115,
  sym_function_name = 116,
  sym_function_statement = 117,
  sym_macroexp_statement = 118,
  sym__macroexp_def = 119,
  sym_macroexp_body = 120,
  sym_variadic_type = 121,
  sym_return_type = 122,
  sym__partype = 123,
  sym__parname = 124,
  sym_typeargs = 125,
  sym_anon_function = 126,
  sym__annotated_var_arg = 127,
  sym_signature_arguments = 128,
  sym_function_signature = 129,
  sym_function_body = 130,
  sym_record_field = 131,
  sym__record_entry = 132,
  sym_metamethod_annotation = 133,
  sym_record_body = 134,
  sym__record_def = 135,
  sym__interface_def = 136,
  sym_interface_declaration = 137,
  sym_record_declaration = 138,
  sym_enum_body = 139,
  sym__enum_def = 140,
  sym_enum_declaration = 141,
  sym_anon_interface = 142,
  sym_anon_record = 143,
  sym__anon_enum = 144,
  sym__newtype = 145,
  sym_type_annotation = 146,
  sym__type = 147,
  sym_typearg_params = 148,
  sym_type_index = 149,
  sym_simple_type = 150,
  sym_table_type = 151,
  sym_function_type_args = 152,
  sym_function_type = 153,
  sym_goto = 154,
  sym_index = 155,
  sym__var = 156,
  sym_varargs = 157,
  sym_number = 158,
  sym_boolean = 159,
  sym__short_string_content = 160,
  sym__long_string_content = 161,
  sym_string = 162,
  aux_sym_program_repeat1 = 163,
  aux_sym_return_statement_repeat1 = 164,
  aux_sym_if_statement_repeat1 = 165,
  aux_sym_generic_for_statement_repeat1 = 166,
  aux_sym_type_tuple_repeat1 = 167,
  aux_sym_var_declarators_repeat1 = 168,
  aux_sym_assignment_variables_repeat1 = 169,
  aux_sym_table_constructor_repeat1 = 170,
  aux_sym_function_name_repeat1 = 171,
  aux_sym__partypelist_repeat1 = 172,
  aux_sym__parnamelist_repeat1 = 173,
  aux_sym_record_body_repeat1 = 174,
  aux_sym_enum_body_repeat1 = 175,
  aux_sym_table_type_repeat1 = 176,
  aux_sym__short_string_content_repeat1 = 177,
  aux_sym__long_string_content_repeat1 = 178,
  alias_sym_attribute = 179,
  alias_sym_for_body = 180,
  alias_sym_interface_body = 181,
  alias_sym_label = 182,
  alias_sym_macroexp_declaration = 183,
  alias_sym_macroexp_signature = 184,
  alias_sym_record_array_type = 185,
  alias_sym_string_content = 186,
  alias_sym_typedef = 187,
  alias_sym_userdata = 188,
  alias_sym_while_body = 189,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [aux_sym_program_token1] = "shebang_comment",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_SEMI] = ";",
  [anon_sym_return] = "return",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym_break] = "break",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_end] = "end",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_EQ] = "=",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_do] = "do",
  [anon_sym_not] = "op",
  [anon_sym_POUND] = "op",
  [anon_sym_DASH] = "op",
  [anon_sym_TILDE] = "op",
  [anon_sym_or] = "op",
  [anon_sym_and] = "op",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "op",
  [anon_sym_EQ_EQ] = "op",
  [anon_sym_TILDE_EQ] = "op",
  [anon_sym_GT_EQ] = "op",
  [anon_sym_GT] = ">",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "op",
  [anon_sym_LT_LT] = "op",
  [anon_sym_GT_GT] = "op",
  [anon_sym_PLUS] = "op",
  [anon_sym_STAR] = "op",
  [anon_sym_SLASH] = "op",
  [anon_sym_SLASH_SLASH] = "op",
  [anon_sym_PERCENT] = "op",
  [anon_sym_DOT_DOT] = "op",
  [anon_sym_CARET] = "op",
  [anon_sym_is] = "is",
  [anon_sym_as] = "as",
  [anon_sym_type] = "type",
  [anon_sym_COLON] = ":",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_local] = "local",
  [anon_sym_global] = "global",
  [anon_sym_function] = "function",
  [anon_sym_macroexp] = "macroexp",
  [anon_sym_DOT_DOT_DOT] = "...",
  [sym_optional_marker] = "optional_marker",
  [anon_sym_record] = "record",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_userdata] = "identifier",
  [anon_sym_metamethod] = "metamethod",
  [anon_sym_where] = "where",
  [anon_sym_goto] = "goto",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [aux_sym_number_token3] = "number_token3",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_PERCENT2] = "%",
  [sym_format_specifier] = "format_specifier",
  [sym_escape_sequence] = "escape_sequence",
  [sym_nil] = "nil",
  [sym_comment] = "comment",
  [sym__long_string_start] = "long_string_start",
  [sym__long_string_char] = "_long_string_char",
  [sym__long_string_end] = "long_string_end",
  [sym__short_string_start] = "short_string_start",
  [sym__short_string_char] = "_short_string_char",
  [sym__short_string_end] = "short_string_end",
  [sym_program] = "program",
  [sym__statement] = "_statement",
  [sym_return_statement] = "return_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_block] = "elseif_block",
  [sym_else_block] = "else_block",
  [sym_numeric_for_statement] = "numeric_for_statement",
  [sym_generic_for_statement] = "generic_for_statement",
  [sym__for_statement] = "_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_do_statement] = "do_statement",
  [sym__expression] = "_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_unary_op] = "unary_op",
  [sym_bin_op] = "bin_op",
  [sym_type_cast] = "type_cast",
  [sym_type_tuple] = "type_tuple",
  [sym_type_union] = "type_union",
  [sym_var_declarator] = "var",
  [sym_var_declarators] = "var_declarators",
  [sym_expressions] = "expressions",
  [sym_var_declaration] = "var_declaration",
  [sym__type_def] = "_type_def",
  [sym_type_declaration] = "type_declaration",
  [sym_assignment_variables] = "assignment_variables",
  [sym_var_assignment] = "var_assignment",
  [sym__prefix_expression] = "_prefix_expression",
  [sym_method_index] = "method_index",
  [sym_arguments] = "arguments",
  [sym_function_call] = "function_call",
  [sym_table_entry] = "table_entry",
  [sym_table_constructor] = "table_constructor",
  [sym_function_name] = "function_name",
  [sym_function_statement] = "function_statement",
  [sym_macroexp_statement] = "macroexp_statement",
  [sym__macroexp_def] = "_macroexp_def",
  [sym_macroexp_body] = "macroexp_body",
  [sym_variadic_type] = "variadic_type",
  [sym_return_type] = "return_type",
  [sym__partype] = "arg",
  [sym__parname] = "arg",
  [sym_typeargs] = "typeargs",
  [sym_anon_function] = "anon_function",
  [sym__annotated_var_arg] = "varargs",
  [sym_signature_arguments] = "arguments",
  [sym_function_signature] = "function_signature",
  [sym_function_body] = "function_body",
  [sym_record_field] = "field",
  [sym__record_entry] = "_record_entry",
  [sym_metamethod_annotation] = "metamethod",
  [sym_record_body] = "record_body",
  [sym__record_def] = "_record_def",
  [sym__interface_def] = "_interface_def",
  [sym_interface_declaration] = "interface_declaration",
  [sym_record_declaration] = "record_declaration",
  [sym_enum_body] = "enum_body",
  [sym__enum_def] = "_enum_def",
  [sym_enum_declaration] = "enum_declaration",
  [sym_anon_interface] = "anon_interface",
  [sym_anon_record] = "anon_record",
  [sym__anon_enum] = "_anon_enum",
  [sym__newtype] = "_newtype",
  [sym_type_annotation] = "type_annotation",
  [sym__type] = "_type",
  [sym_typearg_params] = "typeargs",
  [sym_type_index] = "type_index",
  [sym_simple_type] = "simple_type",
  [sym_table_type] = "table_type",
  [sym_function_type_args] = "arguments",
  [sym_function_type] = "function_type",
  [sym_goto] = "goto",
  [sym_index] = "index",
  [sym__var] = "_var",
  [sym_varargs] = "varargs",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym__short_string_content] = "_short_string_content",
  [sym__long_string_content] = "_long_string_content",
  [sym_string] = "string",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_return_statement_repeat1] = "return_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_generic_for_statement_repeat1] = "generic_for_statement_repeat1",
  [aux_sym_type_tuple_repeat1] = "type_tuple_repeat1",
  [aux_sym_var_declarators_repeat1] = "var_declarators_repeat1",
  [aux_sym_assignment_variables_repeat1] = "assignment_variables_repeat1",
  [aux_sym_table_constructor_repeat1] = "table_constructor_repeat1",
  [aux_sym_function_name_repeat1] = "function_name_repeat1",
  [aux_sym__partypelist_repeat1] = "_partypelist_repeat1",
  [aux_sym__parnamelist_repeat1] = "_parnamelist_repeat1",
  [aux_sym_record_body_repeat1] = "record_body_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_table_type_repeat1] = "table_type_repeat1",
  [aux_sym__short_string_content_repeat1] = "_short_string_content_repeat1",
  [aux_sym__long_string_content_repeat1] = "_long_string_content_repeat1",
  [alias_sym_attribute] = "attribute",
  [alias_sym_for_body] = "for_body",
  [alias_sym_interface_body] = "interface_body",
  [alias_sym_label] = "label",
  [alias_sym_macroexp_declaration] = "macroexp_declaration",
  [alias_sym_macroexp_signature] = "macroexp_signature",
  [alias_sym_record_array_type] = "record_array_type",
  [alias_sym_string_content] = "string_content",
  [alias_sym_typedef] = "typedef",
  [alias_sym_userdata] = "userdata",
  [alias_sym_while_body] = "while_body",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [aux_sym_program_token1] = aux_sym_program_token1,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_break] = sym_break,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_not,
  [anon_sym_DASH] = anon_sym_not,
  [anon_sym_TILDE] = anon_sym_not,
  [anon_sym_or] = anon_sym_not,
  [anon_sym_and] = anon_sym_not,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_not,
  [anon_sym_EQ_EQ] = anon_sym_not,
  [anon_sym_TILDE_EQ] = anon_sym_not,
  [anon_sym_GT_EQ] = anon_sym_not,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_not,
  [anon_sym_LT_LT] = anon_sym_not,
  [anon_sym_GT_GT] = anon_sym_not,
  [anon_sym_PLUS] = anon_sym_not,
  [anon_sym_STAR] = anon_sym_not,
  [anon_sym_SLASH] = anon_sym_not,
  [anon_sym_SLASH_SLASH] = anon_sym_not,
  [anon_sym_PERCENT] = anon_sym_not,
  [anon_sym_DOT_DOT] = anon_sym_not,
  [anon_sym_CARET] = anon_sym_not,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_macroexp] = anon_sym_macroexp,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [sym_optional_marker] = sym_optional_marker,
  [anon_sym_record] = anon_sym_record,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_userdata] = sym_identifier,
  [anon_sym_metamethod] = anon_sym_metamethod,
  [anon_sym_where] = anon_sym_where,
  [anon_sym_goto] = anon_sym_goto,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [aux_sym_number_token3] = aux_sym_number_token3,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_PERCENT2] = anon_sym_PERCENT,
  [sym_format_specifier] = sym_format_specifier,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_nil] = sym_nil,
  [sym_comment] = sym_comment,
  [sym__long_string_start] = sym__long_string_start,
  [sym__long_string_char] = sym__long_string_char,
  [sym__long_string_end] = sym__long_string_end,
  [sym__short_string_start] = sym__short_string_start,
  [sym__short_string_char] = sym__short_string_char,
  [sym__short_string_end] = sym__short_string_end,
  [sym_program] = sym_program,
  [sym__statement] = sym__statement,
  [sym_return_statement] = sym_return_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_block] = sym_elseif_block,
  [sym_else_block] = sym_else_block,
  [sym_numeric_for_statement] = sym_numeric_for_statement,
  [sym_generic_for_statement] = sym_generic_for_statement,
  [sym__for_statement] = sym__for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_do_statement] = sym_do_statement,
  [sym__expression] = sym__expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_unary_op] = sym_unary_op,
  [sym_bin_op] = sym_bin_op,
  [sym_type_cast] = sym_type_cast,
  [sym_type_tuple] = sym_type_tuple,
  [sym_type_union] = sym_type_union,
  [sym_var_declarator] = sym_var_declarator,
  [sym_var_declarators] = sym_var_declarators,
  [sym_expressions] = sym_expressions,
  [sym_var_declaration] = sym_var_declaration,
  [sym__type_def] = sym__type_def,
  [sym_type_declaration] = sym_type_declaration,
  [sym_assignment_variables] = sym_assignment_variables,
  [sym_var_assignment] = sym_var_assignment,
  [sym__prefix_expression] = sym__prefix_expression,
  [sym_method_index] = sym_method_index,
  [sym_arguments] = sym_arguments,
  [sym_function_call] = sym_function_call,
  [sym_table_entry] = sym_table_entry,
  [sym_table_constructor] = sym_table_constructor,
  [sym_function_name] = sym_function_name,
  [sym_function_statement] = sym_function_statement,
  [sym_macroexp_statement] = sym_macroexp_statement,
  [sym__macroexp_def] = sym__macroexp_def,
  [sym_macroexp_body] = sym_macroexp_body,
  [sym_variadic_type] = sym_variadic_type,
  [sym_return_type] = sym_return_type,
  [sym__partype] = sym__partype,
  [sym__parname] = sym__partype,
  [sym_typeargs] = sym_typeargs,
  [sym_anon_function] = sym_anon_function,
  [sym__annotated_var_arg] = sym_varargs,
  [sym_signature_arguments] = sym_arguments,
  [sym_function_signature] = sym_function_signature,
  [sym_function_body] = sym_function_body,
  [sym_record_field] = sym_record_field,
  [sym__record_entry] = sym__record_entry,
  [sym_metamethod_annotation] = sym_metamethod_annotation,
  [sym_record_body] = sym_record_body,
  [sym__record_def] = sym__record_def,
  [sym__interface_def] = sym__interface_def,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_record_declaration] = sym_record_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym__enum_def] = sym__enum_def,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_anon_interface] = sym_anon_interface,
  [sym_anon_record] = sym_anon_record,
  [sym__anon_enum] = sym__anon_enum,
  [sym__newtype] = sym__newtype,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type] = sym__type,
  [sym_typearg_params] = sym_typeargs,
  [sym_type_index] = sym_type_index,
  [sym_simple_type] = sym_simple_type,
  [sym_table_type] = sym_table_type,
  [sym_function_type_args] = sym_arguments,
  [sym_function_type] = sym_function_type,
  [sym_goto] = sym_goto,
  [sym_index] = sym_index,
  [sym__var] = sym__var,
  [sym_varargs] = sym_varargs,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym__short_string_content] = sym__short_string_content,
  [sym__long_string_content] = sym__long_string_content,
  [sym_string] = sym_string,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_return_statement_repeat1] = aux_sym_return_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_generic_for_statement_repeat1] = aux_sym_generic_for_statement_repeat1,
  [aux_sym_type_tuple_repeat1] = aux_sym_type_tuple_repeat1,
  [aux_sym_var_declarators_repeat1] = aux_sym_var_declarators_repeat1,
  [aux_sym_assignment_variables_repeat1] = aux_sym_assignment_variables_repeat1,
  [aux_sym_table_constructor_repeat1] = aux_sym_table_constructor_repeat1,
  [aux_sym_function_name_repeat1] = aux_sym_function_name_repeat1,
  [aux_sym__partypelist_repeat1] = aux_sym__partypelist_repeat1,
  [aux_sym__parnamelist_repeat1] = aux_sym__parnamelist_repeat1,
  [aux_sym_record_body_repeat1] = aux_sym_record_body_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_table_type_repeat1] = aux_sym_table_type_repeat1,
  [aux_sym__short_string_content_repeat1] = aux_sym__short_string_content_repeat1,
  [aux_sym__long_string_content_repeat1] = aux_sym__long_string_content_repeat1,
  [alias_sym_attribute] = alias_sym_attribute,
  [alias_sym_for_body] = alias_sym_for_body,
  [alias_sym_interface_body] = alias_sym_interface_body,
  [alias_sym_label] = alias_sym_label,
  [alias_sym_macroexp_declaration] = alias_sym_macroexp_declaration,
  [alias_sym_macroexp_signature] = alias_sym_macroexp_signature,
  [alias_sym_record_array_type] = alias_sym_record_array_type,
  [alias_sym_string_content] = alias_sym_string_content,
  [alias_sym_typedef] = alias_sym_typedef,
  [alias_sym_userdata] = alias_sym_userdata,
  [alias_sym_while_body] = alias_sym_while_body,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macroexp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_optional_marker] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_userdata] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_metamethod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT2] = {
    .visible = true,
    .named = false,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__long_string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__long_string_char] = {
    .visible = false,
    .named = true,
  },
  [sym__long_string_end] = {
    .visible = true,
    .named = false,
  },
  [sym__short_string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__short_string_char] = {
    .visible = false,
    .named = true,
  },
  [sym__short_string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_block] = {
    .visible = true,
    .named = true,
  },
  [sym_numeric_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bin_op] = {
    .visible = true,
    .named = true,
  },
  [sym_type_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_type_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_type_union] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declarators] = {
    .visible = true,
    .named = true,
  },
  [sym_expressions] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__type_def] = {
    .visible = false,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_variables] = {
    .visible = true,
    .named = true,
  },
  [sym_var_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_method_index] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_table_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_function_name] = {
    .visible = true,
    .named = true,
  },
  [sym_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_macroexp_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__macroexp_def] = {
    .visible = false,
    .named = true,
  },
  [sym_macroexp_body] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym__partype] = {
    .visible = true,
    .named = true,
  },
  [sym__parname] = {
    .visible = true,
    .named = true,
  },
  [sym_typeargs] = {
    .visible = true,
    .named = true,
  },
  [sym_anon_function] = {
    .visible = true,
    .named = true,
  },
  [sym__annotated_var_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_signature_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_record_field] = {
    .visible = true,
    .named = true,
  },
  [sym__record_entry] = {
    .visible = false,
    .named = true,
  },
  [sym_metamethod_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_record_body] = {
    .visible = true,
    .named = true,
  },
  [sym__record_def] = {
    .visible = false,
    .named = true,
  },
  [sym__interface_def] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_record_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_def] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_anon_interface] = {
    .visible = true,
    .named = true,
  },
  [sym_anon_record] = {
    .visible = true,
    .named = true,
  },
  [sym__anon_enum] = {
    .visible = false,
    .named = true,
  },
  [sym__newtype] = {
    .visible = false,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_typearg_params] = {
    .visible = true,
    .named = true,
  },
  [sym_type_index] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_table_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_args] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_goto] = {
    .visible = true,
    .named = true,
  },
  [sym_index] = {
    .visible = true,
    .named = true,
  },
  [sym__var] = {
    .visible = false,
    .named = true,
  },
  [sym_varargs] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym__short_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__long_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_return_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_declarators_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assignment_variables_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_constructor_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__partypelist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parnamelist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__short_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__long_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_for_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_label] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_macroexp_declaration] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_macroexp_signature] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_record_array_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_typedef] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_userdata] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_while_body] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_arguments = 1,
  field_attribute = 2,
  field_base = 3,
  field_body = 4,
  field_called_object = 5,
  field_condition = 6,
  field_content = 7,
  field_declarators = 8,
  field_end = 9,
  field_entry = 10,
  field_enum_body = 11,
  field_expr_key = 12,
  field_expressions = 13,
  field_initializer = 14,
  field_initializers = 15,
  field_interface_body = 16,
  field_is_types = 17,
  field_iterator = 18,
  field_key = 19,
  field_key_type = 20,
  field_left = 21,
  field_metamethod = 22,
  field_method = 23,
  field_name = 24,
  field_op = 25,
  field_optional_marker = 26,
  field_record_body = 27,
  field_return_type = 28,
  field_right = 29,
  field_scope = 30,
  field_signature = 31,
  field_start = 32,
  field_step = 33,
  field_target = 34,
  field_tuple_type = 35,
  field_type = 36,
  field_type_annotation = 37,
  field_typeargs = 38,
  field_value = 39,
  field_value_type = 40,
  field_variable = 41,
  field_variables = 42,
  field_where = 43,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_base] = "base",
  [field_body] = "body",
  [field_called_object] = "called_object",
  [field_condition] = "condition",
  [field_content] = "content",
  [field_declarators] = "declarators",
  [field_end] = "end",
  [field_entry] = "entry",
  [field_enum_body] = "enum_body",
  [field_expr_key] = "expr_key",
  [field_expressions] = "expressions",
  [field_initializer] = "initializer",
  [field_initializers] = "initializers",
  [field_interface_body] = "interface_body",
  [field_is_types] = "is_types",
  [field_iterator] = "iterator",
  [field_key] = "key",
  [field_key_type] = "key_type",
  [field_left] = "left",
  [field_metamethod] = "metamethod",
  [field_method] = "method",
  [field_name] = "name",
  [field_op] = "op",
  [field_optional_marker] = "optional_marker",
  [field_record_body] = "record_body",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_signature] = "signature",
  [field_start] = "start",
  [field_step] = "step",
  [field_target] = "target",
  [field_tuple_type] = "tuple_type",
  [field_type] = "type",
  [field_type_annotation] = "type_annotation",
  [field_typeargs] = "typeargs",
  [field_value] = "value",
  [field_value_type] = "value_type",
  [field_variable] = "variable",
  [field_variables] = "variables",
  [field_where] = "where",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 2},
  [4] = {.index = 3, .length = 3},
  [5] = {.index = 6, .length = 3},
  [6] = {.index = 9, .length = 4},
  [7] = {.index = 13, .length = 4},
  [8] = {.index = 17, .length = 3},
  [9] = {.index = 20, .length = 2},
  [11] = {.index = 22, .length = 2},
  [13] = {.index = 24, .length = 2},
  [14] = {.index = 26, .length = 1},
  [15] = {.index = 27, .length = 1},
  [16] = {.index = 28, .length = 1},
  [17] = {.index = 29, .length = 1},
  [18] = {.index = 30, .length = 3},
  [19] = {.index = 33, .length = 2},
  [20] = {.index = 35, .length = 2},
  [21] = {.index = 37, .length = 1},
  [22] = {.index = 38, .length = 2},
  [24] = {.index = 40, .length = 3},
  [25] = {.index = 43, .length = 2},
  [26] = {.index = 45, .length = 2},
  [27] = {.index = 47, .length = 3},
  [28] = {.index = 28, .length = 1},
  [29] = {.index = 50, .length = 1},
  [31] = {.index = 51, .length = 2},
  [32] = {.index = 53, .length = 3},
  [33] = {.index = 56, .length = 1},
  [34] = {.index = 57, .length = 2},
  [35] = {.index = 59, .length = 3},
  [36] = {.index = 62, .length = 3},
  [37] = {.index = 65, .length = 2},
  [38] = {.index = 67, .length = 2},
  [39] = {.index = 69, .length = 2},
  [40] = {.index = 71, .length = 3},
  [41] = {.index = 74, .length = 2},
  [42] = {.index = 76, .length = 1},
  [43] = {.index = 77, .length = 2},
  [44] = {.index = 79, .length = 3},
  [45] = {.index = 82, .length = 3},
  [46] = {.index = 85, .length = 2},
  [47] = {.index = 87, .length = 2},
  [48] = {.index = 89, .length = 3},
  [49] = {.index = 92, .length = 1},
  [50] = {.index = 93, .length = 2},
  [51] = {.index = 95, .length = 1},
  [52] = {.index = 96, .length = 1},
  [53] = {.index = 97, .length = 3},
  [54] = {.index = 100, .length = 2},
  [55] = {.index = 102, .length = 4},
  [56] = {.index = 79, .length = 3},
  [57] = {.index = 106, .length = 3},
  [58] = {.index = 109, .length = 1},
  [59] = {.index = 110, .length = 2},
  [60] = {.index = 112, .length = 3},
  [61] = {.index = 115, .length = 2},
  [62] = {.index = 117, .length = 4},
  [63] = {.index = 121, .length = 3},
  [64] = {.index = 124, .length = 1},
  [65] = {.index = 125, .length = 2},
  [66] = {.index = 127, .length = 3},
  [67] = {.index = 130, .length = 1},
  [68] = {.index = 131, .length = 1},
  [69] = {.index = 132, .length = 2},
  [70] = {.index = 134, .length = 4},
  [71] = {.index = 138, .length = 4},
  [72] = {.index = 142, .length = 1},
  [73] = {.index = 143, .length = 1},
  [74] = {.index = 144, .length = 2},
  [75] = {.index = 146, .length = 2},
  [76] = {.index = 146, .length = 2},
  [77] = {.index = 148, .length = 2},
  [78] = {.index = 150, .length = 4},
  [79] = {.index = 154, .length = 3},
  [80] = {.index = 157, .length = 4},
  [81] = {.index = 161, .length = 1},
  [82] = {.index = 162, .length = 2},
  [83] = {.index = 164, .length = 2},
  [84] = {.index = 166, .length = 2},
  [85] = {.index = 168, .length = 2},
  [86] = {.index = 170, .length = 4},
  [87] = {.index = 174, .length = 5},
  [88] = {.index = 179, .length = 1},
  [89] = {.index = 180, .length = 1},
  [90] = {.index = 181, .length = 3},
  [91] = {.index = 184, .length = 3},
  [93] = {.index = 187, .length = 2},
  [94] = {.index = 189, .length = 4},
  [95] = {.index = 193, .length = 2},
  [96] = {.index = 195, .length = 3},
  [97] = {.index = 198, .length = 4},
  [98] = {.index = 202, .length = 4},
  [99] = {.index = 206, .length = 2},
  [100] = {.index = 208, .length = 1},
  [101] = {.index = 209, .length = 3},
  [102] = {.index = 212, .length = 5},
  [103] = {.index = 144, .length = 2},
  [104] = {.index = 217, .length = 5},
  [105] = {.index = 222, .length = 5},
  [106] = {.index = 227, .length = 3},
  [107] = {.index = 230, .length = 3},
  [108] = {.index = 181, .length = 3},
  [109] = {.index = 233, .length = 6},
  [110] = {.index = 198, .length = 4},
  [111] = {.index = 239, .length = 4},
  [112] = {.index = 243, .length = 5},
  [113] = {.index = 222, .length = 5},
  [114] = {.index = 248, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_declarators, 1},
    {field_scope, 0},
  [3] =
    {field_name, 1, .inherited = true},
    {field_scope, 0},
    {field_value, 1, .inherited = true},
  [6] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_signature, 1, .inherited = true},
  [9] =
    {field_name, 1, .inherited = true},
    {field_record_body, 1, .inherited = true},
    {field_scope, 0},
    {field_typeargs, 1, .inherited = true},
  [13] =
    {field_interface_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_scope, 0},
    {field_typeargs, 1, .inherited = true},
  [17] =
    {field_enum_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_scope, 0},
  [20] =
    {field_arguments, 1},
    {field_called_object, 0},
  [22] =
    {field_end, 1},
    {field_start, 0},
  [24] =
    {field_op, 0},
    {field_right, 1},
  [26] =
    {field_value, 0},
  [27] =
    {field_arguments, 0},
  [28] =
    {field_condition, 1},
  [29] =
    {field_condition, 2},
  [30] =
    {field_declarators, 1},
    {field_scope, 0},
    {field_type_annotation, 2},
  [33] =
    {field_base, 0},
    {field_entry, 1, .inherited = true},
  [35] =
    {field_expressions, 2},
    {field_variables, 0},
  [37] =
    {field_key, 2},
  [38] =
    {field_key, 1},
    {field_key, 2},
  [40] =
    {field_content, 1},
    {field_end, 2},
    {field_start, 0},
  [43] =
    {field_arguments, 1},
    {field_typeargs, 0},
  [45] =
    {field_body, 2},
    {field_signature, 1},
  [47] =
    {field_left, 0},
    {field_op, 1},
    {field_right, 2},
  [50] =
    {field_condition, 3},
  [51] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [53] =
    {field_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_signature, 0, .inherited = true},
  [56] =
    {field_metamethod, 0},
  [57] =
    {field_name, 1},
    {field_record_body, 2},
  [59] =
    {field_name, 0, .inherited = true},
    {field_record_body, 0, .inherited = true},
    {field_typeargs, 0, .inherited = true},
  [62] =
    {field_interface_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_typeargs, 0, .inherited = true},
  [65] =
    {field_enum_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [67] =
    {field_interface_body, 2},
    {field_name, 1},
  [69] =
    {field_enum_body, 2},
    {field_name, 1},
  [71] =
    {field_declarators, 1},
    {field_initializers, 3},
    {field_scope, 0},
  [74] =
    {field_base, 0},
    {field_method, 2},
  [76] =
    {field_entry, 1},
  [77] =
    {field_entry, 0, .inherited = true},
    {field_entry, 1, .inherited = true},
  [79] =
    {field_body, 3},
    {field_name, 1},
    {field_signature, 2},
  [82] =
    {field_expr_key, 1},
    {field_expr_key, 2},
    {field_expr_key, 3},
  [85] =
    {field_key, 0},
    {field_value, 2},
  [87] =
    {field_name, 0},
    {field_optional_marker, 1},
  [89] =
    {field_name, 1, .inherited = true},
    {field_optional_marker, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [92] =
    {field_type, 1, .inherited = true},
  [93] =
    {field_arguments, 0},
    {field_return_type, 2},
  [95] =
    {field_typeargs, 1},
  [96] =
    {field_arguments, 1},
  [97] =
    {field_body, 4},
    {field_iterator, 3},
    {field_variable, 1},
  [100] =
    {field_name, 1},
    {field_value, 3},
  [102] =
    {field_body, 4},
    {field_name, 2},
    {field_scope, 0},
    {field_signature, 3},
  [106] =
    {field_name, 1},
    {field_record_body, 3},
    {field_typeargs, 2},
  [109] =
    {field_metamethod, 0, .inherited = true},
  [110] =
    {field_metamethod, 0, .inherited = true},
    {field_metamethod, 1, .inherited = true},
  [112] =
    {field_interface_body, 3},
    {field_name, 1},
    {field_typeargs, 2},
  [115] =
    {field_attribute, 2},
    {field_name, 0},
  [117] =
    {field_declarators, 1},
    {field_initializers, 4},
    {field_scope, 0},
    {field_type_annotation, 2},
  [121] =
    {field_base, 0},
    {field_entry, 1, .inherited = true},
    {field_method, 3},
  [124] =
    {field_type, 2},
  [125] =
    {field_name, 0},
    {field_type, 2},
  [127] =
    {field_arguments, 1},
    {field_return_type, 3},
    {field_typeargs, 0},
  [130] =
    {field_value_type, 1},
  [131] =
    {field_type, 0},
  [132] =
    {field_arguments, 2},
    {field_typeargs, 1},
  [134] =
    {field_body, 5},
    {field_iterator, 3},
    {field_iterator, 4},
    {field_variable, 1},
  [138] =
    {field_body, 5},
    {field_iterator, 4},
    {field_variable, 1},
    {field_variable, 2},
  [142] =
    {field_record_body, 1},
  [143] =
    {field_interface_body, 1},
  [144] =
    {field_is_types, 0},
    {field_is_types, 1},
  [146] =
    {field_key, 0},
    {field_type, 2},
  [148] =
    {field_expr_key, 1},
    {field_value, 4},
  [150] =
    {field_key, 0},
    {field_type, 1},
    {field_type, 2},
    {field_value, 4},
  [154] =
    {field_name, 0},
    {field_optional_marker, 1},
    {field_type, 3},
  [157] =
    {field_name, 1, .inherited = true},
    {field_optional_marker, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type, 3, .inherited = true},
  [161] =
    {field_tuple_type, 1},
  [162] =
    {field_tuple_type, 1},
    {field_tuple_type, 2, .inherited = true},
  [164] =
    {field_tuple_type, 0, .inherited = true},
    {field_tuple_type, 1, .inherited = true},
  [166] =
    {field_name, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [168] =
    {field_arguments, 1},
    {field_return_type, 3},
  [170] =
    {field_body, 6},
    {field_initializer, 3},
    {field_target, 5},
    {field_variable, 1},
  [174] =
    {field_body, 6},
    {field_iterator, 4},
    {field_iterator, 5},
    {field_variable, 1},
    {field_variable, 2},
  [179] =
    {field_record_body, 2},
  [180] =
    {field_interface_body, 2},
  [181] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_is_types, 2},
  [184] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_metamethod, 2, .inherited = true},
  [187] =
    {field_name, 1},
    {field_type, 3},
  [189] =
    {field_name, 1, .inherited = true},
    {field_optional_marker, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type, 4, .inherited = true},
  [193] =
    {field_key_type, 1},
    {field_value_type, 3},
  [195] =
    {field_arguments, 2},
    {field_return_type, 4},
    {field_typeargs, 1},
  [198] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_where, 2},
    {field_where, 3},
  [202] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_is_types, 2},
    {field_metamethod, 3, .inherited = true},
  [206] =
    {field_key, 1},
    {field_type, 4},
  [208] =
    {field_metamethod, 3, .inherited = true},
  [209] =
    {field_name, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type, 3, .inherited = true},
  [212] =
    {field_body, 8},
    {field_initializer, 3},
    {field_step, 7},
    {field_target, 5},
    {field_variable, 1},
  [217] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_metamethod, 4, .inherited = true},
    {field_where, 2},
    {field_where, 3},
  [222] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_is_types, 2},
    {field_where, 3},
    {field_where, 4},
  [227] =
    {field_name, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_type, 4, .inherited = true},
  [230] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_metamethod, 5, .inherited = true},
  [233] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_is_types, 2},
    {field_metamethod, 5, .inherited = true},
    {field_where, 3},
    {field_where, 4},
  [239] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_is_types, 2},
    {field_metamethod, 6, .inherited = true},
  [243] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_metamethod, 7, .inherited = true},
    {field_where, 2},
    {field_where, 3},
  [248] =
    {field_is_types, 0},
    {field_is_types, 1},
    {field_is_types, 2},
    {field_metamethod, 8, .inherited = true},
    {field_where, 3},
    {field_where, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_var_declarator,
  },
  [10] = {
    [1] = alias_sym_label,
  },
  [12] = {
    [0] = alias_sym_string_content,
  },
  [16] = {
    [2] = alias_sym_while_body,
  },
  [23] = {
    [1] = sym_var_declarator,
  },
  [27] = {
    [1] = anon_sym_not,
  },
  [30] = {
    [0] = alias_sym_userdata,
  },
  [31] = {
    [0] = alias_sym_typedef,
  },
  [32] = {
    [0] = alias_sym_macroexp_declaration,
  },
  [35] = {
    [0] = sym_record_declaration,
  },
  [36] = {
    [0] = sym_interface_declaration,
  },
  [37] = {
    [0] = sym_enum_declaration,
  },
  [38] = {
    [2] = alias_sym_interface_body,
  },
  [53] = {
    [4] = alias_sym_for_body,
  },
  [56] = {
    [2] = alias_sym_macroexp_signature,
  },
  [60] = {
    [3] = alias_sym_interface_body,
  },
  [61] = {
    [2] = alias_sym_attribute,
  },
  [70] = {
    [5] = alias_sym_for_body,
  },
  [71] = {
    [5] = alias_sym_for_body,
  },
  [73] = {
    [1] = alias_sym_interface_body,
  },
  [75] = {
    [0] = sym_identifier,
  },
  [86] = {
    [6] = alias_sym_for_body,
  },
  [87] = {
    [6] = alias_sym_for_body,
  },
  [89] = {
    [2] = alias_sym_interface_body,
  },
  [92] = {
    [1] = alias_sym_record_array_type,
  },
  [100] = {
    [1] = alias_sym_record_array_type,
  },
  [102] = {
    [8] = alias_sym_for_body,
  },
  [103] = {
    [3] = alias_sym_record_array_type,
  },
  [107] = {
    [3] = alias_sym_record_array_type,
  },
  [108] = {
    [4] = alias_sym_record_array_type,
  },
  [110] = {
    [5] = alias_sym_record_array_type,
  },
  [111] = {
    [4] = alias_sym_record_array_type,
  },
  [112] = {
    [5] = alias_sym_record_array_type,
  },
  [113] = {
    [6] = alias_sym_record_array_type,
  },
  [114] = {
    [6] = alias_sym_record_array_type,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_do_statement, 3,
    sym_do_statement,
    alias_sym_for_body,
    alias_sym_while_body,
  sym__type_def, 2,
    sym__type_def,
    alias_sym_typedef,
  sym__macroexp_def, 2,
    sym__macroexp_def,
    alias_sym_macroexp_declaration,
  sym_function_signature, 2,
    sym_function_signature,
    alias_sym_macroexp_signature,
  sym_record_body, 2,
    sym_record_body,
    alias_sym_interface_body,
  sym__record_def, 2,
    sym__record_def,
    sym_record_declaration,
  sym__interface_def, 2,
    sym__interface_def,
    sym_interface_declaration,
  sym__enum_def, 2,
    sym__enum_def,
    sym_enum_declaration,
  sym__type, 2,
    sym__type,
    alias_sym_record_array_type,
  sym__var, 2,
    sym__var,
    sym_var_declarator,
  aux_sym__short_string_content_repeat1, 2,
    aux_sym__short_string_content_repeat1,
    alias_sym_string_content,
  aux_sym__long_string_content_repeat1, 2,
    aux_sym__long_string_content_repeat1,
    alias_sym_string_content,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 7,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 5,
  [53] = 18,
  [54] = 54,
  [55] = 11,
  [56] = 56,
  [57] = 57,
  [58] = 51,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 33,
  [63] = 34,
  [64] = 17,
  [65] = 26,
  [66] = 39,
  [67] = 19,
  [68] = 43,
  [69] = 45,
  [70] = 60,
  [71] = 71,
  [72] = 57,
  [73] = 28,
  [74] = 61,
  [75] = 30,
  [76] = 31,
  [77] = 77,
  [78] = 32,
  [79] = 59,
  [80] = 56,
  [81] = 35,
  [82] = 41,
  [83] = 47,
  [84] = 36,
  [85] = 37,
  [86] = 38,
  [87] = 48,
  [88] = 40,
  [89] = 49,
  [90] = 42,
  [91] = 50,
  [92] = 44,
  [93] = 46,
  [94] = 54,
  [95] = 29,
  [96] = 60,
  [97] = 77,
  [98] = 98,
  [99] = 99,
  [100] = 25,
  [101] = 20,
  [102] = 102,
  [103] = 21,
  [104] = 104,
  [105] = 22,
  [106] = 23,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 24,
  [112] = 112,
  [113] = 54,
  [114] = 26,
  [115] = 71,
  [116] = 59,
  [117] = 57,
  [118] = 56,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 129,
  [136] = 119,
  [137] = 130,
  [138] = 123,
  [139] = 124,
  [140] = 125,
  [141] = 126,
  [142] = 127,
  [143] = 128,
  [144] = 122,
  [145] = 121,
  [146] = 132,
  [147] = 131,
  [148] = 120,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 7,
  [168] = 5,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 26,
  [177] = 26,
  [178] = 18,
  [179] = 17,
  [180] = 19,
  [181] = 11,
  [182] = 42,
  [183] = 37,
  [184] = 38,
  [185] = 39,
  [186] = 40,
  [187] = 43,
  [188] = 44,
  [189] = 45,
  [190] = 60,
  [191] = 54,
  [192] = 192,
  [193] = 46,
  [194] = 192,
  [195] = 29,
  [196] = 60,
  [197] = 30,
  [198] = 56,
  [199] = 41,
  [200] = 47,
  [201] = 48,
  [202] = 49,
  [203] = 50,
  [204] = 51,
  [205] = 36,
  [206] = 28,
  [207] = 31,
  [208] = 32,
  [209] = 33,
  [210] = 34,
  [211] = 35,
  [212] = 61,
  [213] = 77,
  [214] = 54,
  [215] = 57,
  [216] = 61,
  [217] = 59,
  [218] = 77,
  [219] = 71,
  [220] = 56,
  [221] = 221,
  [222] = 57,
  [223] = 221,
  [224] = 224,
  [225] = 224,
  [226] = 59,
  [227] = 71,
  [228] = 60,
  [229] = 229,
  [230] = 26,
  [231] = 231,
  [232] = 232,
  [233] = 133,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 54,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 57,
  [249] = 59,
  [250] = 250,
  [251] = 242,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 56,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 238,
  [272] = 272,
  [273] = 263,
  [274] = 260,
  [275] = 272,
  [276] = 253,
  [277] = 270,
  [278] = 278,
  [279] = 239,
  [280] = 240,
  [281] = 241,
  [282] = 243,
  [283] = 245,
  [284] = 252,
  [285] = 285,
  [286] = 134,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 327,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 426,
  [428] = 426,
  [429] = 429,
  [430] = 430,
  [431] = 430,
  [432] = 430,
  [433] = 433,
  [434] = 433,
  [435] = 433,
  [436] = 436,
  [437] = 436,
  [438] = 438,
  [439] = 438,
  [440] = 436,
  [441] = 438,
  [442] = 436,
  [443] = 438,
  [444] = 436,
  [445] = 438,
  [446] = 438,
  [447] = 436,
  [448] = 436,
  [449] = 449,
  [450] = 450,
  [451] = 438,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 454,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 454,
  [460] = 458,
  [461] = 461,
  [462] = 454,
  [463] = 458,
  [464] = 454,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 458,
  [469] = 469,
  [470] = 466,
  [471] = 469,
  [472] = 469,
  [473] = 466,
  [474] = 453,
  [475] = 475,
  [476] = 458,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 480,
  [500] = 500,
  [501] = 477,
  [502] = 502,
  [503] = 493,
  [504] = 494,
  [505] = 496,
  [506] = 497,
  [507] = 507,
  [508] = 508,
  [509] = 477,
  [510] = 495,
  [511] = 511,
  [512] = 480,
  [513] = 477,
  [514] = 495,
  [515] = 480,
  [516] = 516,
  [517] = 480,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 495,
  [522] = 493,
  [523] = 494,
  [524] = 480,
  [525] = 477,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 496,
  [530] = 480,
  [531] = 497,
  [532] = 518,
  [533] = 533,
  [534] = 26,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 537,
  [540] = 540,
  [541] = 56,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 544,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 54,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 551,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 61,
  [559] = 57,
  [560] = 59,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 60,
  [567] = 567,
  [568] = 551,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 71,
  [574] = 572,
  [575] = 16,
  [576] = 571,
  [577] = 577,
  [578] = 578,
  [579] = 571,
  [580] = 580,
  [581] = 581,
  [582] = 572,
  [583] = 583,
  [584] = 581,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 77,
  [590] = 590,
  [591] = 578,
  [592] = 592,
  [593] = 571,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 601,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 608,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 606,
  [614] = 614,
  [615] = 607,
  [616] = 600,
  [617] = 617,
  [618] = 602,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 608,
  [624] = 600,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 601,
  [631] = 611,
  [632] = 632,
  [633] = 633,
  [634] = 606,
  [635] = 635,
  [636] = 636,
  [637] = 602,
  [638] = 607,
  [639] = 611,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 645,
  [656] = 650,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 645,
  [661] = 661,
  [662] = 650,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 667,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 675,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 674,
  [687] = 687,
  [688] = 688,
  [689] = 688,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 676,
  [694] = 694,
  [695] = 687,
  [696] = 687,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 676,
  [702] = 702,
  [703] = 703,
  [704] = 677,
  [705] = 677,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 667,
  [710] = 681,
  [711] = 711,
  [712] = 673,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 681,
  [719] = 719,
  [720] = 708,
  [721] = 674,
  [722] = 708,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
};

static TSCharacterRange sym_format_specifier_character_set_1[] = {
  {' ', ' '}, {'#', '#'}, {'%', '%'}, {'+', '+'}, {'-', '.'}, {'0', '9'}, {'A', 'A'}, {'E', 'E'},
  {'G', 'G'}, {'X', 'X'}, {'a', 'a'}, {'c', 'g'}, {'i', 'i'}, {'o', 'q'}, {'s', 's'}, {'u', 'u'},
  {'x', 'x'},
};

static TSCharacterRange sym_format_specifier_character_set_4[] = {
  {'0', '9'}, {'A', 'A'}, {'E', 'E'}, {'G', 'G'}, {'X', 'X'}, {'a', 'a'}, {'c', 'g'}, {'i', 'i'},
  {'o', 'q'}, {'s', 's'}, {'u', 'u'}, {'x', 'x'},
};

static TSCharacterRange sym_format_specifier_character_set_5[] = {
  {' ', ' '}, {'#', '#'}, {'.', '.'}, {'0', '9'}, {'A', 'A'}, {'E', 'E'}, {'G', 'G'}, {'X', 'X'},
  {'a', 'a'}, {'c', 'g'}, {'i', 'i'}, {'o', 'q'}, {'s', 's'}, {'u', 'u'}, {'x', 'x'},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '#', 47,
        '%', 92,
        '&', 60,
        '(', 42,
        ')', 43,
        '*', 64,
        '+', 63,
        ',', 41,
        '-', 48,
        '.', 77,
        '/', 65,
        '0', 83,
        ':', 71,
        ';', 40,
        '<', 52,
        '=', 45,
        '>', 58,
        '?', 81,
        '[', 72,
        '\\', 7,
        ']', 73,
        '^', 70,
        '{', 74,
        '|', 59,
        '}', 75,
        '~', 50,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 1:
      if (lookahead == ' ') ADVANCE(3);
      if (lookahead == '#') ADVANCE(5);
      if (lookahead == '.') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(5);
      if (set_contains(sym_format_specifier_character_set_5, 15, lookahead)) ADVANCE(94);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(38);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(5);
      if (lookahead == '.') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(5);
      if (set_contains(sym_format_specifier_character_set_4, 12, lookahead)) ADVANCE(94);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(80);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(5);
      if (set_contains(sym_format_specifier_character_set_4, 12, lookahead)) ADVANCE(94);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        'd', 19,
        'u', 8,
        'x', 29,
        '"', 95,
        '\'', 95,
        '\\', 95,
        'a', 95,
        'b', 95,
        'f', 95,
        'n', 95,
        'r', 95,
        't', 95,
        'v', 95,
        'z', 95,
      );
      END_STATE();
    case 8:
      if (lookahead == '{') ADVANCE(27);
      END_STATE();
    case 9:
      if (lookahead == '}') ADVANCE(95);
      END_STATE();
    case 10:
      if (lookahead == '}') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(9);
      END_STATE();
    case 11:
      if (lookahead == '}') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(10);
      END_STATE();
    case 12:
      if (lookahead == '}') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(11);
      END_STATE();
    case 13:
      if (lookahead == '}') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 14:
      if (lookahead == '}') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 15:
      if (lookahead == '}') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == '}') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 17:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(95);
      END_STATE();
    case 18:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(17);
      END_STATE();
    case 19:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(18);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(86);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(91);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      if (set_contains(sym_format_specifier_character_set_4, 12, lookahead)) ADVANCE(94);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(95);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 29:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(25);
      END_STATE();
    case 30:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '#', 46,
        '%', 67,
        '&', 60,
        '(', 42,
        ')', 43,
        '*', 64,
        '+', 63,
        ',', 41,
        '-', 48,
        '.', 77,
        '/', 65,
        '0', 83,
        ':', 71,
        ';', 40,
        '<', 52,
        '=', 45,
        '>', 58,
        '?', 81,
        '[', 72,
        ']', 73,
        '^', 70,
        '{', 74,
        '|', 59,
        '}', 75,
        '~', 50,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 31:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '#', 46,
        '%', 93,
        '(', 42,
        ')', 43,
        ',', 41,
        '-', 48,
        '.', 6,
        '0', 83,
        ':', 71,
        ';', 40,
        '<', 51,
        '=', 44,
        '>', 57,
        '[', 72,
        '\\', 7,
        '{', 74,
        '|', 59,
        '}', 75,
        '~', 49,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(32);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 32:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '#', 46,
        '(', 42,
        ')', 43,
        ',', 41,
        '-', 48,
        '.', 6,
        '0', 83,
        ':', 71,
        ';', 40,
        '<', 51,
        '=', 44,
        '>', 57,
        '[', 72,
        '{', 74,
        '|', 59,
        '}', 75,
        '~', 49,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(32);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(84);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 33:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '#', 2,
        '%', 67,
        '&', 60,
        '(', 42,
        ')', 43,
        '*', 64,
        '+', 63,
        ',', 41,
        '-', 48,
        '.', 78,
        '/', 65,
        ':', 71,
        ';', 40,
        '<', 52,
        '=', 45,
        '>', 58,
        '[', 72,
        ']', 73,
        '^', 70,
        '{', 74,
        '|', 59,
        '}', 75,
        '~', 50,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 34:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '%', 67,
        '&', 60,
        '(', 42,
        ')', 43,
        '*', 64,
        '+', 63,
        ',', 41,
        '-', 48,
        '.', 78,
        '/', 65,
        ':', 71,
        ';', 40,
        '<', 52,
        '=', 45,
        '>', 58,
        '[', 72,
        ']', 73,
        '^', 70,
        '{', 74,
        '|', 59,
        '}', 75,
        '~', 50,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 35:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '%', 67,
        '&', 60,
        '(', 42,
        ')', 43,
        '*', 64,
        '+', 63,
        ',', 41,
        '-', 48,
        '.', 76,
        '/', 65,
        ':', 71,
        ';', 40,
        '<', 52,
        '=', 45,
        '>', 58,
        '[', 72,
        ']', 73,
        '^', 70,
        '{', 74,
        '|', 59,
        '}', 75,
        '~', 50,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(35);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 36:
      if (eof) ADVANCE(37);
      ADVANCE_MAP(
        '(', 42,
        ')', 43,
        ',', 41,
        '.', 79,
        ':', 71,
        ';', 40,
        '<', 51,
        '=', 44,
        '>', 57,
        '[', 72,
        '{', 74,
        '|', 59,
        '}', 75,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(36);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(aux_sym_program_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(54);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(38);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(55);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(61);
      if (lookahead == '=') ADVANCE(53);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(56);
      if (lookahead == '>') ADVANCE(62);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(66);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(80);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(39);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(69);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(68);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(4);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_optional_marker);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == 'x') ADVANCE(26);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_number_token3);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == 'p') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(89);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_number_token3);
      if (lookahead == 'p') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_number_token3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_PERCENT2);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_PERCENT2);
      if (lookahead == ' ') ADVANCE(3);
      if (lookahead == '#') ADVANCE(5);
      if (lookahead == '.') ADVANCE(24);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(5);
      if (set_contains(sym_format_specifier_character_set_1, 17, lookahead)) ADVANCE(94);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_format_specifier);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'd', 3,
        'e', 4,
        'f', 5,
        'g', 6,
        'i', 7,
        'l', 8,
        'm', 9,
        'n', 10,
        'o', 11,
        'r', 12,
        't', 13,
        'u', 14,
        'w', 15,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(21);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 's') ADVANCE(29);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(31);
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(33);
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 13:
      if (lookahead == 'h') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 'y') ADVANCE(39);
      END_STATE();
    case 14:
      if (lookahead == 'n') ADVANCE(40);
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(42);
      END_STATE();
    case 16:
      if (lookahead == 'd') ADVANCE(43);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(47);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 26:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(54);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(59);
      if (lookahead == 'p') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(63);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(64);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(65);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 47:
      if (lookahead == 'm') ADVANCE(71);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 50:
      if (lookahead == 'c') ADVANCE(73);
      END_STATE();
    case 51:
      if (lookahead == 'b') ADVANCE(74);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(77);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(79);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 59:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(87);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 69:
      if (lookahead == 'k') ADVANCE(90);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(94);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 76:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 77:
      if (lookahead == 'l') ADVANCE(96);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 79:
      if (lookahead == 'm') ADVANCE(98);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 82:
      if (lookahead == 'r') ADVANCE(101);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 86:
      if (lookahead == 'l') ADVANCE(102);
      END_STATE();
    case 87:
      if (lookahead == 'd') ADVANCE(103);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 91:
      if (lookahead == 'f') ADVANCE(106);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 95:
      if (lookahead == 'f') ADVANCE(109);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 99:
      if (lookahead == 'd') ADVANCE(112);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 101:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(115);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 107:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(117);
      END_STATE();
    case 110:
      if (lookahead == 'x') ADVANCE(118);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_record);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 116:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 117:
      if (lookahead == 'c') ADVANCE(122);
      END_STATE();
    case 118:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 119:
      if (lookahead == 'h') ADVANCE(124);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_macroexp);
      END_STATE();
    case 124:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_userdata);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 127:
      if (lookahead == 'd') ADVANCE(128);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_metamethod);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 33, .external_lex_state = 2},
  [2] = {.lex_state = 33, .external_lex_state = 3},
  [3] = {.lex_state = 33, .external_lex_state = 3},
  [4] = {.lex_state = 33, .external_lex_state = 3},
  [5] = {.lex_state = 33, .external_lex_state = 2},
  [6] = {.lex_state = 33, .external_lex_state = 3},
  [7] = {.lex_state = 33, .external_lex_state = 2},
  [8] = {.lex_state = 33, .external_lex_state = 3},
  [9] = {.lex_state = 33, .external_lex_state = 3},
  [10] = {.lex_state = 33, .external_lex_state = 3},
  [11] = {.lex_state = 33, .external_lex_state = 2},
  [12] = {.lex_state = 33, .external_lex_state = 3},
  [13] = {.lex_state = 33, .external_lex_state = 3},
  [14] = {.lex_state = 33, .external_lex_state = 3},
  [15] = {.lex_state = 33, .external_lex_state = 3},
  [16] = {.lex_state = 35, .external_lex_state = 2},
  [17] = {.lex_state = 33, .external_lex_state = 2},
  [18] = {.lex_state = 33, .external_lex_state = 2},
  [19] = {.lex_state = 33, .external_lex_state = 2},
  [20] = {.lex_state = 33, .external_lex_state = 3},
  [21] = {.lex_state = 33, .external_lex_state = 3},
  [22] = {.lex_state = 33, .external_lex_state = 3},
  [23] = {.lex_state = 33, .external_lex_state = 3},
  [24] = {.lex_state = 33, .external_lex_state = 3},
  [25] = {.lex_state = 33, .external_lex_state = 3},
  [26] = {.lex_state = 35, .external_lex_state = 2},
  [27] = {.lex_state = 35, .external_lex_state = 2},
  [28] = {.lex_state = 33, .external_lex_state = 2},
  [29] = {.lex_state = 33, .external_lex_state = 2},
  [30] = {.lex_state = 33, .external_lex_state = 2},
  [31] = {.lex_state = 33, .external_lex_state = 2},
  [32] = {.lex_state = 33, .external_lex_state = 2},
  [33] = {.lex_state = 33, .external_lex_state = 2},
  [34] = {.lex_state = 33, .external_lex_state = 2},
  [35] = {.lex_state = 33, .external_lex_state = 2},
  [36] = {.lex_state = 33, .external_lex_state = 2},
  [37] = {.lex_state = 33, .external_lex_state = 2},
  [38] = {.lex_state = 33, .external_lex_state = 2},
  [39] = {.lex_state = 33, .external_lex_state = 2},
  [40] = {.lex_state = 33, .external_lex_state = 2},
  [41] = {.lex_state = 33, .external_lex_state = 2},
  [42] = {.lex_state = 33, .external_lex_state = 2},
  [43] = {.lex_state = 33, .external_lex_state = 2},
  [44] = {.lex_state = 33, .external_lex_state = 2},
  [45] = {.lex_state = 33, .external_lex_state = 2},
  [46] = {.lex_state = 33, .external_lex_state = 2},
  [47] = {.lex_state = 33, .external_lex_state = 2},
  [48] = {.lex_state = 33, .external_lex_state = 2},
  [49] = {.lex_state = 33, .external_lex_state = 2},
  [50] = {.lex_state = 33, .external_lex_state = 2},
  [51] = {.lex_state = 33, .external_lex_state = 2},
  [52] = {.lex_state = 35, .external_lex_state = 2},
  [53] = {.lex_state = 35, .external_lex_state = 2},
  [54] = {.lex_state = 35, .external_lex_state = 2},
  [55] = {.lex_state = 35, .external_lex_state = 2},
  [56] = {.lex_state = 35, .external_lex_state = 2},
  [57] = {.lex_state = 35, .external_lex_state = 2},
  [58] = {.lex_state = 35, .external_lex_state = 2},
  [59] = {.lex_state = 35, .external_lex_state = 2},
  [60] = {.lex_state = 35, .external_lex_state = 2},
  [61] = {.lex_state = 35, .external_lex_state = 2},
  [62] = {.lex_state = 35, .external_lex_state = 2},
  [63] = {.lex_state = 35, .external_lex_state = 2},
  [64] = {.lex_state = 35, .external_lex_state = 2},
  [65] = {.lex_state = 33, .external_lex_state = 2},
  [66] = {.lex_state = 35, .external_lex_state = 2},
  [67] = {.lex_state = 35, .external_lex_state = 2},
  [68] = {.lex_state = 35, .external_lex_state = 2},
  [69] = {.lex_state = 35, .external_lex_state = 2},
  [70] = {.lex_state = 35, .external_lex_state = 2},
  [71] = {.lex_state = 35, .external_lex_state = 2},
  [72] = {.lex_state = 33, .external_lex_state = 2},
  [73] = {.lex_state = 35, .external_lex_state = 2},
  [74] = {.lex_state = 33, .external_lex_state = 2},
  [75] = {.lex_state = 35, .external_lex_state = 2},
  [76] = {.lex_state = 35, .external_lex_state = 2},
  [77] = {.lex_state = 35, .external_lex_state = 2},
  [78] = {.lex_state = 35, .external_lex_state = 2},
  [79] = {.lex_state = 33, .external_lex_state = 2},
  [80] = {.lex_state = 33, .external_lex_state = 2},
  [81] = {.lex_state = 35, .external_lex_state = 2},
  [82] = {.lex_state = 35, .external_lex_state = 2},
  [83] = {.lex_state = 35, .external_lex_state = 2},
  [84] = {.lex_state = 35, .external_lex_state = 2},
  [85] = {.lex_state = 35, .external_lex_state = 2},
  [86] = {.lex_state = 35, .external_lex_state = 2},
  [87] = {.lex_state = 35, .external_lex_state = 2},
  [88] = {.lex_state = 35, .external_lex_state = 2},
  [89] = {.lex_state = 35, .external_lex_state = 2},
  [90] = {.lex_state = 35, .external_lex_state = 2},
  [91] = {.lex_state = 35, .external_lex_state = 2},
  [92] = {.lex_state = 35, .external_lex_state = 2},
  [93] = {.lex_state = 35, .external_lex_state = 2},
  [94] = {.lex_state = 33, .external_lex_state = 2},
  [95] = {.lex_state = 35, .external_lex_state = 2},
  [96] = {.lex_state = 35, .external_lex_state = 2},
  [97] = {.lex_state = 35, .external_lex_state = 2},
  [98] = {.lex_state = 33, .external_lex_state = 2},
  [99] = {.lex_state = 33, .external_lex_state = 2},
  [100] = {.lex_state = 33, .external_lex_state = 2},
  [101] = {.lex_state = 33, .external_lex_state = 2},
  [102] = {.lex_state = 33, .external_lex_state = 2},
  [103] = {.lex_state = 33, .external_lex_state = 2},
  [104] = {.lex_state = 33, .external_lex_state = 2},
  [105] = {.lex_state = 33, .external_lex_state = 2},
  [106] = {.lex_state = 33, .external_lex_state = 2},
  [107] = {.lex_state = 33, .external_lex_state = 2},
  [108] = {.lex_state = 33, .external_lex_state = 2},
  [109] = {.lex_state = 33, .external_lex_state = 2},
  [110] = {.lex_state = 33, .external_lex_state = 2},
  [111] = {.lex_state = 33, .external_lex_state = 2},
  [112] = {.lex_state = 33, .external_lex_state = 2},
  [113] = {.lex_state = 33, .external_lex_state = 2},
  [114] = {.lex_state = 33, .external_lex_state = 2},
  [115] = {.lex_state = 33, .external_lex_state = 2},
  [116] = {.lex_state = 33, .external_lex_state = 2},
  [117] = {.lex_state = 33, .external_lex_state = 2},
  [118] = {.lex_state = 33, .external_lex_state = 2},
  [119] = {.lex_state = 33, .external_lex_state = 2},
  [120] = {.lex_state = 33, .external_lex_state = 2},
  [121] = {.lex_state = 33, .external_lex_state = 2},
  [122] = {.lex_state = 33, .external_lex_state = 2},
  [123] = {.lex_state = 33, .external_lex_state = 2},
  [124] = {.lex_state = 33, .external_lex_state = 2},
  [125] = {.lex_state = 33, .external_lex_state = 2},
  [126] = {.lex_state = 33, .external_lex_state = 2},
  [127] = {.lex_state = 33, .external_lex_state = 2},
  [128] = {.lex_state = 33, .external_lex_state = 2},
  [129] = {.lex_state = 33, .external_lex_state = 2},
  [130] = {.lex_state = 33, .external_lex_state = 2},
  [131] = {.lex_state = 33, .external_lex_state = 2},
  [132] = {.lex_state = 33, .external_lex_state = 2},
  [133] = {.lex_state = 31, .external_lex_state = 3},
  [134] = {.lex_state = 33, .external_lex_state = 3},
  [135] = {.lex_state = 33, .external_lex_state = 2},
  [136] = {.lex_state = 33, .external_lex_state = 2},
  [137] = {.lex_state = 33, .external_lex_state = 2},
  [138] = {.lex_state = 33, .external_lex_state = 2},
  [139] = {.lex_state = 33, .external_lex_state = 2},
  [140] = {.lex_state = 33, .external_lex_state = 2},
  [141] = {.lex_state = 33, .external_lex_state = 2},
  [142] = {.lex_state = 33, .external_lex_state = 2},
  [143] = {.lex_state = 33, .external_lex_state = 2},
  [144] = {.lex_state = 33, .external_lex_state = 2},
  [145] = {.lex_state = 33, .external_lex_state = 2},
  [146] = {.lex_state = 33, .external_lex_state = 2},
  [147] = {.lex_state = 33, .external_lex_state = 2},
  [148] = {.lex_state = 33, .external_lex_state = 2},
  [149] = {.lex_state = 0, .external_lex_state = 2},
  [150] = {.lex_state = 0, .external_lex_state = 2},
  [151] = {.lex_state = 33, .external_lex_state = 2},
  [152] = {.lex_state = 33, .external_lex_state = 2},
  [153] = {.lex_state = 33, .external_lex_state = 2},
  [154] = {.lex_state = 0, .external_lex_state = 2},
  [155] = {.lex_state = 0, .external_lex_state = 2},
  [156] = {.lex_state = 33, .external_lex_state = 2},
  [157] = {.lex_state = 0, .external_lex_state = 2},
  [158] = {.lex_state = 33, .external_lex_state = 2},
  [159] = {.lex_state = 33, .external_lex_state = 2},
  [160] = {.lex_state = 33, .external_lex_state = 2},
  [161] = {.lex_state = 0, .external_lex_state = 2},
  [162] = {.lex_state = 0, .external_lex_state = 2},
  [163] = {.lex_state = 0, .external_lex_state = 2},
  [164] = {.lex_state = 0, .external_lex_state = 2},
  [165] = {.lex_state = 0, .external_lex_state = 2},
  [166] = {.lex_state = 0, .external_lex_state = 2},
  [167] = {.lex_state = 36, .external_lex_state = 2},
  [168] = {.lex_state = 36, .external_lex_state = 2},
  [169] = {.lex_state = 0, .external_lex_state = 2},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 0, .external_lex_state = 2},
  [172] = {.lex_state = 0, .external_lex_state = 2},
  [173] = {.lex_state = 0, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 2},
  [175] = {.lex_state = 0, .external_lex_state = 2},
  [176] = {.lex_state = 0, .external_lex_state = 2},
  [177] = {.lex_state = 0, .external_lex_state = 2},
  [178] = {.lex_state = 36, .external_lex_state = 2},
  [179] = {.lex_state = 36, .external_lex_state = 2},
  [180] = {.lex_state = 36, .external_lex_state = 2},
  [181] = {.lex_state = 36, .external_lex_state = 2},
  [182] = {.lex_state = 31, .external_lex_state = 2},
  [183] = {.lex_state = 31, .external_lex_state = 2},
  [184] = {.lex_state = 31, .external_lex_state = 2},
  [185] = {.lex_state = 31, .external_lex_state = 2},
  [186] = {.lex_state = 31, .external_lex_state = 2},
  [187] = {.lex_state = 31, .external_lex_state = 2},
  [188] = {.lex_state = 31, .external_lex_state = 2},
  [189] = {.lex_state = 31, .external_lex_state = 2},
  [190] = {.lex_state = 0, .external_lex_state = 2},
  [191] = {.lex_state = 0, .external_lex_state = 2},
  [192] = {.lex_state = 31, .external_lex_state = 3},
  [193] = {.lex_state = 31, .external_lex_state = 2},
  [194] = {.lex_state = 31, .external_lex_state = 3},
  [195] = {.lex_state = 31, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 31, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 2},
  [199] = {.lex_state = 31, .external_lex_state = 2},
  [200] = {.lex_state = 31, .external_lex_state = 2},
  [201] = {.lex_state = 31, .external_lex_state = 2},
  [202] = {.lex_state = 31, .external_lex_state = 2},
  [203] = {.lex_state = 31, .external_lex_state = 2},
  [204] = {.lex_state = 31, .external_lex_state = 2},
  [205] = {.lex_state = 31, .external_lex_state = 2},
  [206] = {.lex_state = 31, .external_lex_state = 2},
  [207] = {.lex_state = 31, .external_lex_state = 2},
  [208] = {.lex_state = 31, .external_lex_state = 2},
  [209] = {.lex_state = 31, .external_lex_state = 2},
  [210] = {.lex_state = 31, .external_lex_state = 2},
  [211] = {.lex_state = 31, .external_lex_state = 2},
  [212] = {.lex_state = 0, .external_lex_state = 2},
  [213] = {.lex_state = 0, .external_lex_state = 2},
  [214] = {.lex_state = 0, .external_lex_state = 2},
  [215] = {.lex_state = 0, .external_lex_state = 2},
  [216] = {.lex_state = 0, .external_lex_state = 2},
  [217] = {.lex_state = 0, .external_lex_state = 2},
  [218] = {.lex_state = 0, .external_lex_state = 2},
  [219] = {.lex_state = 0, .external_lex_state = 2},
  [220] = {.lex_state = 0, .external_lex_state = 2},
  [221] = {.lex_state = 31, .external_lex_state = 3},
  [222] = {.lex_state = 0, .external_lex_state = 2},
  [223] = {.lex_state = 31, .external_lex_state = 3},
  [224] = {.lex_state = 31, .external_lex_state = 3},
  [225] = {.lex_state = 31, .external_lex_state = 3},
  [226] = {.lex_state = 0, .external_lex_state = 2},
  [227] = {.lex_state = 0, .external_lex_state = 2},
  [228] = {.lex_state = 0, .external_lex_state = 2},
  [229] = {.lex_state = 31, .external_lex_state = 3},
  [230] = {.lex_state = 0, .external_lex_state = 2},
  [231] = {.lex_state = 31, .external_lex_state = 3},
  [232] = {.lex_state = 33, .external_lex_state = 3},
  [233] = {.lex_state = 31, .external_lex_state = 3},
  [234] = {.lex_state = 31, .external_lex_state = 3},
  [235] = {.lex_state = 31, .external_lex_state = 3},
  [236] = {.lex_state = 31, .external_lex_state = 3},
  [237] = {.lex_state = 0, .external_lex_state = 2},
  [238] = {.lex_state = 31, .external_lex_state = 3},
  [239] = {.lex_state = 31, .external_lex_state = 3},
  [240] = {.lex_state = 31, .external_lex_state = 3},
  [241] = {.lex_state = 31, .external_lex_state = 3},
  [242] = {.lex_state = 31, .external_lex_state = 3},
  [243] = {.lex_state = 31, .external_lex_state = 3},
  [244] = {.lex_state = 31, .external_lex_state = 3},
  [245] = {.lex_state = 31, .external_lex_state = 3},
  [246] = {.lex_state = 31, .external_lex_state = 3},
  [247] = {.lex_state = 31, .external_lex_state = 3},
  [248] = {.lex_state = 0, .external_lex_state = 2},
  [249] = {.lex_state = 0, .external_lex_state = 2},
  [250] = {.lex_state = 31, .external_lex_state = 3},
  [251] = {.lex_state = 31, .external_lex_state = 3},
  [252] = {.lex_state = 31, .external_lex_state = 3},
  [253] = {.lex_state = 31, .external_lex_state = 3},
  [254] = {.lex_state = 31, .external_lex_state = 3},
  [255] = {.lex_state = 31, .external_lex_state = 3},
  [256] = {.lex_state = 31, .external_lex_state = 3},
  [257] = {.lex_state = 0, .external_lex_state = 2},
  [258] = {.lex_state = 31, .external_lex_state = 3},
  [259] = {.lex_state = 31, .external_lex_state = 3},
  [260] = {.lex_state = 31, .external_lex_state = 3},
  [261] = {.lex_state = 31, .external_lex_state = 3},
  [262] = {.lex_state = 31, .external_lex_state = 3},
  [263] = {.lex_state = 31, .external_lex_state = 3},
  [264] = {.lex_state = 31, .external_lex_state = 3},
  [265] = {.lex_state = 31, .external_lex_state = 3},
  [266] = {.lex_state = 31, .external_lex_state = 3},
  [267] = {.lex_state = 31, .external_lex_state = 3},
  [268] = {.lex_state = 31, .external_lex_state = 3},
  [269] = {.lex_state = 31, .external_lex_state = 3},
  [270] = {.lex_state = 31, .external_lex_state = 3},
  [271] = {.lex_state = 31, .external_lex_state = 3},
  [272] = {.lex_state = 31, .external_lex_state = 3},
  [273] = {.lex_state = 31, .external_lex_state = 3},
  [274] = {.lex_state = 31, .external_lex_state = 3},
  [275] = {.lex_state = 31, .external_lex_state = 3},
  [276] = {.lex_state = 31, .external_lex_state = 3},
  [277] = {.lex_state = 31, .external_lex_state = 3},
  [278] = {.lex_state = 31, .external_lex_state = 3},
  [279] = {.lex_state = 31, .external_lex_state = 3},
  [280] = {.lex_state = 31, .external_lex_state = 3},
  [281] = {.lex_state = 31, .external_lex_state = 3},
  [282] = {.lex_state = 31, .external_lex_state = 3},
  [283] = {.lex_state = 31, .external_lex_state = 3},
  [284] = {.lex_state = 31, .external_lex_state = 3},
  [285] = {.lex_state = 31, .external_lex_state = 3},
  [286] = {.lex_state = 33, .external_lex_state = 3},
  [287] = {.lex_state = 0, .external_lex_state = 2},
  [288] = {.lex_state = 0, .external_lex_state = 2},
  [289] = {.lex_state = 0, .external_lex_state = 2},
  [290] = {.lex_state = 0, .external_lex_state = 2},
  [291] = {.lex_state = 0, .external_lex_state = 2},
  [292] = {.lex_state = 0, .external_lex_state = 2},
  [293] = {.lex_state = 0, .external_lex_state = 2},
  [294] = {.lex_state = 0, .external_lex_state = 2},
  [295] = {.lex_state = 0, .external_lex_state = 2},
  [296] = {.lex_state = 0, .external_lex_state = 2},
  [297] = {.lex_state = 0, .external_lex_state = 2},
  [298] = {.lex_state = 0, .external_lex_state = 2},
  [299] = {.lex_state = 0, .external_lex_state = 2},
  [300] = {.lex_state = 0, .external_lex_state = 2},
  [301] = {.lex_state = 0, .external_lex_state = 2},
  [302] = {.lex_state = 0, .external_lex_state = 2},
  [303] = {.lex_state = 0, .external_lex_state = 2},
  [304] = {.lex_state = 0, .external_lex_state = 2},
  [305] = {.lex_state = 0, .external_lex_state = 2},
  [306] = {.lex_state = 0, .external_lex_state = 2},
  [307] = {.lex_state = 0, .external_lex_state = 2},
  [308] = {.lex_state = 0, .external_lex_state = 2},
  [309] = {.lex_state = 0, .external_lex_state = 2},
  [310] = {.lex_state = 0, .external_lex_state = 2},
  [311] = {.lex_state = 0, .external_lex_state = 2},
  [312] = {.lex_state = 0, .external_lex_state = 2},
  [313] = {.lex_state = 0, .external_lex_state = 2},
  [314] = {.lex_state = 0, .external_lex_state = 2},
  [315] = {.lex_state = 0, .external_lex_state = 2},
  [316] = {.lex_state = 0, .external_lex_state = 2},
  [317] = {.lex_state = 0, .external_lex_state = 2},
  [318] = {.lex_state = 0, .external_lex_state = 2},
  [319] = {.lex_state = 0, .external_lex_state = 2},
  [320] = {.lex_state = 0, .external_lex_state = 2},
  [321] = {.lex_state = 0, .external_lex_state = 2},
  [322] = {.lex_state = 0, .external_lex_state = 2},
  [323] = {.lex_state = 33, .external_lex_state = 2},
  [324] = {.lex_state = 33, .external_lex_state = 2},
  [325] = {.lex_state = 33, .external_lex_state = 2},
  [326] = {.lex_state = 33, .external_lex_state = 2},
  [327] = {.lex_state = 33, .external_lex_state = 2},
  [328] = {.lex_state = 33, .external_lex_state = 2},
  [329] = {.lex_state = 33, .external_lex_state = 2},
  [330] = {.lex_state = 33, .external_lex_state = 3},
  [331] = {.lex_state = 33, .external_lex_state = 2},
  [332] = {.lex_state = 33, .external_lex_state = 2},
  [333] = {.lex_state = 33, .external_lex_state = 2},
  [334] = {.lex_state = 33, .external_lex_state = 2},
  [335] = {.lex_state = 33, .external_lex_state = 2},
  [336] = {.lex_state = 0, .external_lex_state = 2},
  [337] = {.lex_state = 33, .external_lex_state = 2},
  [338] = {.lex_state = 0, .external_lex_state = 2},
  [339] = {.lex_state = 0, .external_lex_state = 2},
  [340] = {.lex_state = 0, .external_lex_state = 2},
  [341] = {.lex_state = 33, .external_lex_state = 2},
  [342] = {.lex_state = 33, .external_lex_state = 2},
  [343] = {.lex_state = 33, .external_lex_state = 2},
  [344] = {.lex_state = 33, .external_lex_state = 2},
  [345] = {.lex_state = 0, .external_lex_state = 2},
  [346] = {.lex_state = 0, .external_lex_state = 2},
  [347] = {.lex_state = 0, .external_lex_state = 2},
  [348] = {.lex_state = 0, .external_lex_state = 2},
  [349] = {.lex_state = 0, .external_lex_state = 2},
  [350] = {.lex_state = 0, .external_lex_state = 2},
  [351] = {.lex_state = 33, .external_lex_state = 2},
  [352] = {.lex_state = 0, .external_lex_state = 2},
  [353] = {.lex_state = 0, .external_lex_state = 2},
  [354] = {.lex_state = 0, .external_lex_state = 2},
  [355] = {.lex_state = 0, .external_lex_state = 2},
  [356] = {.lex_state = 0, .external_lex_state = 2},
  [357] = {.lex_state = 0, .external_lex_state = 2},
  [358] = {.lex_state = 0, .external_lex_state = 2},
  [359] = {.lex_state = 0, .external_lex_state = 2},
  [360] = {.lex_state = 0, .external_lex_state = 2},
  [361] = {.lex_state = 0, .external_lex_state = 2},
  [362] = {.lex_state = 0, .external_lex_state = 2},
  [363] = {.lex_state = 0, .external_lex_state = 2},
  [364] = {.lex_state = 0, .external_lex_state = 2},
  [365] = {.lex_state = 0, .external_lex_state = 2},
  [366] = {.lex_state = 0, .external_lex_state = 2},
  [367] = {.lex_state = 0, .external_lex_state = 2},
  [368] = {.lex_state = 0, .external_lex_state = 2},
  [369] = {.lex_state = 0, .external_lex_state = 2},
  [370] = {.lex_state = 0, .external_lex_state = 2},
  [371] = {.lex_state = 0, .external_lex_state = 2},
  [372] = {.lex_state = 0, .external_lex_state = 2},
  [373] = {.lex_state = 0, .external_lex_state = 2},
  [374] = {.lex_state = 0, .external_lex_state = 2},
  [375] = {.lex_state = 0, .external_lex_state = 2},
  [376] = {.lex_state = 0, .external_lex_state = 2},
  [377] = {.lex_state = 0, .external_lex_state = 2},
  [378] = {.lex_state = 0, .external_lex_state = 2},
  [379] = {.lex_state = 0, .external_lex_state = 2},
  [380] = {.lex_state = 0, .external_lex_state = 2},
  [381] = {.lex_state = 0, .external_lex_state = 2},
  [382] = {.lex_state = 0, .external_lex_state = 2},
  [383] = {.lex_state = 0, .external_lex_state = 2},
  [384] = {.lex_state = 0, .external_lex_state = 2},
  [385] = {.lex_state = 0, .external_lex_state = 2},
  [386] = {.lex_state = 0, .external_lex_state = 2},
  [387] = {.lex_state = 0, .external_lex_state = 2},
  [388] = {.lex_state = 0, .external_lex_state = 2},
  [389] = {.lex_state = 0, .external_lex_state = 2},
  [390] = {.lex_state = 0, .external_lex_state = 2},
  [391] = {.lex_state = 0, .external_lex_state = 2},
  [392] = {.lex_state = 0, .external_lex_state = 2},
  [393] = {.lex_state = 0, .external_lex_state = 2},
  [394] = {.lex_state = 0, .external_lex_state = 2},
  [395] = {.lex_state = 0, .external_lex_state = 2},
  [396] = {.lex_state = 0, .external_lex_state = 2},
  [397] = {.lex_state = 0, .external_lex_state = 2},
  [398] = {.lex_state = 0, .external_lex_state = 2},
  [399] = {.lex_state = 0, .external_lex_state = 2},
  [400] = {.lex_state = 0, .external_lex_state = 2},
  [401] = {.lex_state = 0, .external_lex_state = 2},
  [402] = {.lex_state = 0, .external_lex_state = 2},
  [403] = {.lex_state = 0, .external_lex_state = 2},
  [404] = {.lex_state = 0, .external_lex_state = 2},
  [405] = {.lex_state = 0, .external_lex_state = 2},
  [406] = {.lex_state = 0, .external_lex_state = 2},
  [407] = {.lex_state = 0, .external_lex_state = 2},
  [408] = {.lex_state = 0, .external_lex_state = 2},
  [409] = {.lex_state = 0, .external_lex_state = 2},
  [410] = {.lex_state = 0, .external_lex_state = 2},
  [411] = {.lex_state = 0, .external_lex_state = 2},
  [412] = {.lex_state = 0, .external_lex_state = 2},
  [413] = {.lex_state = 0, .external_lex_state = 2},
  [414] = {.lex_state = 0, .external_lex_state = 2},
  [415] = {.lex_state = 0, .external_lex_state = 2},
  [416] = {.lex_state = 0, .external_lex_state = 2},
  [417] = {.lex_state = 0, .external_lex_state = 2},
  [418] = {.lex_state = 0, .external_lex_state = 2},
  [419] = {.lex_state = 0, .external_lex_state = 2},
  [420] = {.lex_state = 0, .external_lex_state = 2},
  [421] = {.lex_state = 0, .external_lex_state = 2},
  [422] = {.lex_state = 0, .external_lex_state = 2},
  [423] = {.lex_state = 0, .external_lex_state = 2},
  [424] = {.lex_state = 0, .external_lex_state = 2},
  [425] = {.lex_state = 0, .external_lex_state = 2},
  [426] = {.lex_state = 0, .external_lex_state = 2},
  [427] = {.lex_state = 0, .external_lex_state = 2},
  [428] = {.lex_state = 0, .external_lex_state = 2},
  [429] = {.lex_state = 0, .external_lex_state = 2},
  [430] = {.lex_state = 0, .external_lex_state = 2},
  [431] = {.lex_state = 0, .external_lex_state = 2},
  [432] = {.lex_state = 0, .external_lex_state = 2},
  [433] = {.lex_state = 0, .external_lex_state = 2},
  [434] = {.lex_state = 0, .external_lex_state = 2},
  [435] = {.lex_state = 0, .external_lex_state = 2},
  [436] = {.lex_state = 0, .external_lex_state = 2},
  [437] = {.lex_state = 0, .external_lex_state = 2},
  [438] = {.lex_state = 0, .external_lex_state = 2},
  [439] = {.lex_state = 0, .external_lex_state = 2},
  [440] = {.lex_state = 0, .external_lex_state = 2},
  [441] = {.lex_state = 0, .external_lex_state = 2},
  [442] = {.lex_state = 0, .external_lex_state = 2},
  [443] = {.lex_state = 0, .external_lex_state = 2},
  [444] = {.lex_state = 0, .external_lex_state = 2},
  [445] = {.lex_state = 0, .external_lex_state = 2},
  [446] = {.lex_state = 0, .external_lex_state = 2},
  [447] = {.lex_state = 0, .external_lex_state = 2},
  [448] = {.lex_state = 0, .external_lex_state = 2},
  [449] = {.lex_state = 0, .external_lex_state = 2},
  [450] = {.lex_state = 0, .external_lex_state = 2},
  [451] = {.lex_state = 0, .external_lex_state = 2},
  [452] = {.lex_state = 0, .external_lex_state = 2},
  [453] = {.lex_state = 0, .external_lex_state = 2},
  [454] = {.lex_state = 0, .external_lex_state = 2},
  [455] = {.lex_state = 0, .external_lex_state = 2},
  [456] = {.lex_state = 0, .external_lex_state = 2},
  [457] = {.lex_state = 0, .external_lex_state = 2},
  [458] = {.lex_state = 0, .external_lex_state = 2},
  [459] = {.lex_state = 0, .external_lex_state = 2},
  [460] = {.lex_state = 0, .external_lex_state = 2},
  [461] = {.lex_state = 0, .external_lex_state = 2},
  [462] = {.lex_state = 0, .external_lex_state = 2},
  [463] = {.lex_state = 0, .external_lex_state = 2},
  [464] = {.lex_state = 0, .external_lex_state = 2},
  [465] = {.lex_state = 0, .external_lex_state = 2},
  [466] = {.lex_state = 0, .external_lex_state = 2},
  [467] = {.lex_state = 0, .external_lex_state = 2},
  [468] = {.lex_state = 0, .external_lex_state = 2},
  [469] = {.lex_state = 0, .external_lex_state = 2},
  [470] = {.lex_state = 0, .external_lex_state = 2},
  [471] = {.lex_state = 0, .external_lex_state = 2},
  [472] = {.lex_state = 0, .external_lex_state = 2},
  [473] = {.lex_state = 0, .external_lex_state = 2},
  [474] = {.lex_state = 0, .external_lex_state = 2},
  [475] = {.lex_state = 0, .external_lex_state = 2},
  [476] = {.lex_state = 0, .external_lex_state = 2},
  [477] = {.lex_state = 0, .external_lex_state = 2},
  [478] = {.lex_state = 0, .external_lex_state = 2},
  [479] = {.lex_state = 0, .external_lex_state = 2},
  [480] = {.lex_state = 0, .external_lex_state = 2},
  [481] = {.lex_state = 0, .external_lex_state = 2},
  [482] = {.lex_state = 0, .external_lex_state = 2},
  [483] = {.lex_state = 0, .external_lex_state = 2},
  [484] = {.lex_state = 0, .external_lex_state = 2},
  [485] = {.lex_state = 0, .external_lex_state = 2},
  [486] = {.lex_state = 0, .external_lex_state = 2},
  [487] = {.lex_state = 0, .external_lex_state = 2},
  [488] = {.lex_state = 0, .external_lex_state = 2},
  [489] = {.lex_state = 0, .external_lex_state = 2},
  [490] = {.lex_state = 0, .external_lex_state = 2},
  [491] = {.lex_state = 0, .external_lex_state = 2},
  [492] = {.lex_state = 0, .external_lex_state = 2},
  [493] = {.lex_state = 0, .external_lex_state = 2},
  [494] = {.lex_state = 0, .external_lex_state = 2},
  [495] = {.lex_state = 0, .external_lex_state = 2},
  [496] = {.lex_state = 0, .external_lex_state = 2},
  [497] = {.lex_state = 0, .external_lex_state = 2},
  [498] = {.lex_state = 0, .external_lex_state = 2},
  [499] = {.lex_state = 0, .external_lex_state = 2},
  [500] = {.lex_state = 0, .external_lex_state = 2},
  [501] = {.lex_state = 0, .external_lex_state = 2},
  [502] = {.lex_state = 0, .external_lex_state = 2},
  [503] = {.lex_state = 0, .external_lex_state = 2},
  [504] = {.lex_state = 0, .external_lex_state = 2},
  [505] = {.lex_state = 0, .external_lex_state = 2},
  [506] = {.lex_state = 0, .external_lex_state = 2},
  [507] = {.lex_state = 0, .external_lex_state = 2},
  [508] = {.lex_state = 0, .external_lex_state = 2},
  [509] = {.lex_state = 0, .external_lex_state = 2},
  [510] = {.lex_state = 0, .external_lex_state = 2},
  [511] = {.lex_state = 0, .external_lex_state = 2},
  [512] = {.lex_state = 0, .external_lex_state = 2},
  [513] = {.lex_state = 0, .external_lex_state = 2},
  [514] = {.lex_state = 0, .external_lex_state = 2},
  [515] = {.lex_state = 0, .external_lex_state = 2},
  [516] = {.lex_state = 0, .external_lex_state = 2},
  [517] = {.lex_state = 0, .external_lex_state = 2},
  [518] = {.lex_state = 0, .external_lex_state = 2},
  [519] = {.lex_state = 0, .external_lex_state = 2},
  [520] = {.lex_state = 0, .external_lex_state = 2},
  [521] = {.lex_state = 0, .external_lex_state = 2},
  [522] = {.lex_state = 0, .external_lex_state = 2},
  [523] = {.lex_state = 0, .external_lex_state = 2},
  [524] = {.lex_state = 0, .external_lex_state = 2},
  [525] = {.lex_state = 0, .external_lex_state = 2},
  [526] = {.lex_state = 33, .external_lex_state = 3},
  [527] = {.lex_state = 0, .external_lex_state = 2},
  [528] = {.lex_state = 33, .external_lex_state = 3},
  [529] = {.lex_state = 0, .external_lex_state = 2},
  [530] = {.lex_state = 0, .external_lex_state = 2},
  [531] = {.lex_state = 0, .external_lex_state = 2},
  [532] = {.lex_state = 0, .external_lex_state = 2},
  [533] = {.lex_state = 33, .external_lex_state = 3},
  [534] = {.lex_state = 31, .external_lex_state = 2},
  [535] = {.lex_state = 0, .external_lex_state = 2},
  [536] = {.lex_state = 33, .external_lex_state = 2},
  [537] = {.lex_state = 31, .external_lex_state = 4},
  [538] = {.lex_state = 0, .external_lex_state = 3},
  [539] = {.lex_state = 31, .external_lex_state = 4},
  [540] = {.lex_state = 0, .external_lex_state = 2},
  [541] = {.lex_state = 31, .external_lex_state = 2},
  [542] = {.lex_state = 0, .external_lex_state = 3},
  [543] = {.lex_state = 0, .external_lex_state = 3},
  [544] = {.lex_state = 31, .external_lex_state = 5},
  [545] = {.lex_state = 31, .external_lex_state = 5},
  [546] = {.lex_state = 31, .external_lex_state = 4},
  [547] = {.lex_state = 0, .external_lex_state = 2},
  [548] = {.lex_state = 31, .external_lex_state = 4},
  [549] = {.lex_state = 31, .external_lex_state = 2},
  [550] = {.lex_state = 0, .external_lex_state = 3},
  [551] = {.lex_state = 0, .external_lex_state = 2},
  [552] = {.lex_state = 31, .external_lex_state = 5},
  [553] = {.lex_state = 0, .external_lex_state = 2},
  [554] = {.lex_state = 33, .external_lex_state = 2},
  [555] = {.lex_state = 0, .external_lex_state = 3},
  [556] = {.lex_state = 0, .external_lex_state = 2},
  [557] = {.lex_state = 0, .external_lex_state = 2},
  [558] = {.lex_state = 31, .external_lex_state = 2},
  [559] = {.lex_state = 31, .external_lex_state = 2},
  [560] = {.lex_state = 31, .external_lex_state = 2},
  [561] = {.lex_state = 31, .external_lex_state = 5},
  [562] = {.lex_state = 0, .external_lex_state = 2},
  [563] = {.lex_state = 31, .external_lex_state = 4},
  [564] = {.lex_state = 31, .external_lex_state = 4},
  [565] = {.lex_state = 0, .external_lex_state = 2},
  [566] = {.lex_state = 31, .external_lex_state = 2},
  [567] = {.lex_state = 0, .external_lex_state = 2},
  [568] = {.lex_state = 0, .external_lex_state = 2},
  [569] = {.lex_state = 0, .external_lex_state = 2},
  [570] = {.lex_state = 33, .external_lex_state = 2},
  [571] = {.lex_state = 0, .external_lex_state = 2},
  [572] = {.lex_state = 31, .external_lex_state = 2},
  [573] = {.lex_state = 31, .external_lex_state = 2},
  [574] = {.lex_state = 31, .external_lex_state = 2},
  [575] = {.lex_state = 31, .external_lex_state = 2},
  [576] = {.lex_state = 0, .external_lex_state = 2},
  [577] = {.lex_state = 31, .external_lex_state = 5},
  [578] = {.lex_state = 0, .external_lex_state = 2},
  [579] = {.lex_state = 0, .external_lex_state = 2},
  [580] = {.lex_state = 0, .external_lex_state = 2},
  [581] = {.lex_state = 0, .external_lex_state = 2},
  [582] = {.lex_state = 31, .external_lex_state = 2},
  [583] = {.lex_state = 0, .external_lex_state = 2},
  [584] = {.lex_state = 0, .external_lex_state = 2},
  [585] = {.lex_state = 0, .external_lex_state = 3},
  [586] = {.lex_state = 0, .external_lex_state = 2},
  [587] = {.lex_state = 0, .external_lex_state = 2},
  [588] = {.lex_state = 0, .external_lex_state = 2},
  [589] = {.lex_state = 31, .external_lex_state = 2},
  [590] = {.lex_state = 33, .external_lex_state = 2},
  [591] = {.lex_state = 0, .external_lex_state = 2},
  [592] = {.lex_state = 31, .external_lex_state = 2},
  [593] = {.lex_state = 0, .external_lex_state = 2},
  [594] = {.lex_state = 0, .external_lex_state = 2},
  [595] = {.lex_state = 0, .external_lex_state = 2},
  [596] = {.lex_state = 0, .external_lex_state = 2},
  [597] = {.lex_state = 33, .external_lex_state = 2},
  [598] = {.lex_state = 0, .external_lex_state = 3},
  [599] = {.lex_state = 0, .external_lex_state = 2},
  [600] = {.lex_state = 0, .external_lex_state = 2},
  [601] = {.lex_state = 31, .external_lex_state = 2},
  [602] = {.lex_state = 31, .external_lex_state = 2},
  [603] = {.lex_state = 31, .external_lex_state = 2},
  [604] = {.lex_state = 0, .external_lex_state = 2},
  [605] = {.lex_state = 0, .external_lex_state = 2},
  [606] = {.lex_state = 0, .external_lex_state = 2},
  [607] = {.lex_state = 0, .external_lex_state = 2},
  [608] = {.lex_state = 31, .external_lex_state = 2},
  [609] = {.lex_state = 31, .external_lex_state = 2},
  [610] = {.lex_state = 0, .external_lex_state = 2},
  [611] = {.lex_state = 0, .external_lex_state = 2},
  [612] = {.lex_state = 0, .external_lex_state = 2},
  [613] = {.lex_state = 0, .external_lex_state = 2},
  [614] = {.lex_state = 0, .external_lex_state = 2},
  [615] = {.lex_state = 0, .external_lex_state = 2},
  [616] = {.lex_state = 0, .external_lex_state = 2},
  [617] = {.lex_state = 0, .external_lex_state = 2},
  [618] = {.lex_state = 31, .external_lex_state = 2},
  [619] = {.lex_state = 0, .external_lex_state = 2},
  [620] = {.lex_state = 0, .external_lex_state = 2},
  [621] = {.lex_state = 0, .external_lex_state = 2},
  [622] = {.lex_state = 0, .external_lex_state = 2},
  [623] = {.lex_state = 31, .external_lex_state = 2},
  [624] = {.lex_state = 0, .external_lex_state = 2},
  [625] = {.lex_state = 31, .external_lex_state = 2},
  [626] = {.lex_state = 0, .external_lex_state = 2},
  [627] = {.lex_state = 0, .external_lex_state = 2},
  [628] = {.lex_state = 0, .external_lex_state = 2},
  [629] = {.lex_state = 0, .external_lex_state = 2},
  [630] = {.lex_state = 31, .external_lex_state = 2},
  [631] = {.lex_state = 0, .external_lex_state = 2},
  [632] = {.lex_state = 0, .external_lex_state = 2},
  [633] = {.lex_state = 0, .external_lex_state = 2},
  [634] = {.lex_state = 0, .external_lex_state = 2},
  [635] = {.lex_state = 0, .external_lex_state = 2},
  [636] = {.lex_state = 0, .external_lex_state = 2},
  [637] = {.lex_state = 31, .external_lex_state = 2},
  [638] = {.lex_state = 0, .external_lex_state = 2},
  [639] = {.lex_state = 0, .external_lex_state = 2},
  [640] = {.lex_state = 0, .external_lex_state = 2},
  [641] = {.lex_state = 0, .external_lex_state = 2},
  [642] = {.lex_state = 0, .external_lex_state = 2},
  [643] = {.lex_state = 0, .external_lex_state = 2},
  [644] = {.lex_state = 0, .external_lex_state = 2},
  [645] = {.lex_state = 0, .external_lex_state = 2},
  [646] = {.lex_state = 0, .external_lex_state = 2},
  [647] = {.lex_state = 0, .external_lex_state = 2},
  [648] = {.lex_state = 0, .external_lex_state = 2},
  [649] = {.lex_state = 0, .external_lex_state = 2},
  [650] = {.lex_state = 0, .external_lex_state = 2},
  [651] = {.lex_state = 0, .external_lex_state = 2},
  [652] = {.lex_state = 0, .external_lex_state = 2},
  [653] = {.lex_state = 0, .external_lex_state = 2},
  [654] = {.lex_state = 0, .external_lex_state = 2},
  [655] = {.lex_state = 0, .external_lex_state = 2},
  [656] = {.lex_state = 0, .external_lex_state = 2},
  [657] = {.lex_state = 0, .external_lex_state = 2},
  [658] = {.lex_state = 0, .external_lex_state = 2},
  [659] = {.lex_state = 0, .external_lex_state = 2},
  [660] = {.lex_state = 0, .external_lex_state = 2},
  [661] = {.lex_state = 0, .external_lex_state = 2},
  [662] = {.lex_state = 0, .external_lex_state = 2},
  [663] = {.lex_state = 0, .external_lex_state = 2},
  [664] = {.lex_state = 0, .external_lex_state = 2},
  [665] = {.lex_state = 0, .external_lex_state = 2},
  [666] = {.lex_state = 0, .external_lex_state = 2},
  [667] = {.lex_state = 0, .external_lex_state = 2},
  [668] = {.lex_state = 0, .external_lex_state = 2},
  [669] = {.lex_state = 0, .external_lex_state = 2},
  [670] = {.lex_state = 0, .external_lex_state = 2},
  [671] = {.lex_state = 0, .external_lex_state = 2},
  [672] = {.lex_state = 31, .external_lex_state = 2},
  [673] = {.lex_state = 0, .external_lex_state = 2},
  [674] = {.lex_state = 0, .external_lex_state = 2},
  [675] = {.lex_state = 0, .external_lex_state = 6},
  [676] = {.lex_state = 0, .external_lex_state = 2},
  [677] = {.lex_state = 0, .external_lex_state = 2},
  [678] = {.lex_state = 0, .external_lex_state = 6},
  [679] = {.lex_state = 0, .external_lex_state = 2},
  [680] = {.lex_state = 0, .external_lex_state = 2},
  [681] = {.lex_state = 0, .external_lex_state = 2},
  [682] = {.lex_state = 0, .external_lex_state = 2},
  [683] = {.lex_state = 0, .external_lex_state = 2},
  [684] = {.lex_state = 0, .external_lex_state = 2},
  [685] = {.lex_state = 0, .external_lex_state = 2},
  [686] = {.lex_state = 0, .external_lex_state = 2},
  [687] = {.lex_state = 0, .external_lex_state = 2},
  [688] = {.lex_state = 0, .external_lex_state = 7},
  [689] = {.lex_state = 0, .external_lex_state = 7},
  [690] = {.lex_state = 0, .external_lex_state = 2},
  [691] = {.lex_state = 0, .external_lex_state = 2},
  [692] = {.lex_state = 0, .external_lex_state = 2},
  [693] = {.lex_state = 0, .external_lex_state = 2},
  [694] = {.lex_state = 0, .external_lex_state = 2},
  [695] = {.lex_state = 0, .external_lex_state = 2},
  [696] = {.lex_state = 0, .external_lex_state = 2},
  [697] = {.lex_state = 0, .external_lex_state = 2},
  [698] = {.lex_state = 0, .external_lex_state = 2},
  [699] = {.lex_state = 0, .external_lex_state = 2},
  [700] = {.lex_state = 0, .external_lex_state = 2},
  [701] = {.lex_state = 0, .external_lex_state = 2},
  [702] = {.lex_state = 0, .external_lex_state = 2},
  [703] = {.lex_state = 0, .external_lex_state = 2},
  [704] = {.lex_state = 0, .external_lex_state = 2},
  [705] = {.lex_state = 0, .external_lex_state = 2},
  [706] = {.lex_state = 0, .external_lex_state = 2},
  [707] = {.lex_state = 0, .external_lex_state = 2},
  [708] = {.lex_state = 0, .external_lex_state = 2},
  [709] = {.lex_state = 0, .external_lex_state = 2},
  [710] = {.lex_state = 0, .external_lex_state = 2},
  [711] = {.lex_state = 0, .external_lex_state = 2},
  [712] = {.lex_state = 0, .external_lex_state = 2},
  [713] = {.lex_state = 0, .external_lex_state = 2},
  [714] = {.lex_state = 0, .external_lex_state = 2},
  [715] = {.lex_state = 0, .external_lex_state = 2},
  [716] = {.lex_state = 0, .external_lex_state = 2},
  [717] = {.lex_state = 0, .external_lex_state = 2},
  [718] = {.lex_state = 0, .external_lex_state = 2},
  [719] = {.lex_state = 0, .external_lex_state = 2},
  [720] = {.lex_state = 0, .external_lex_state = 2},
  [721] = {.lex_state = 0, .external_lex_state = 2},
  [722] = {.lex_state = 0, .external_lex_state = 2},
  [723] = {.lex_state = 0, .external_lex_state = 2},
  [724] = {.lex_state = 0, .external_lex_state = 2},
  [725] = {.lex_state = 0, .external_lex_state = 2},
  [726] = {.lex_state = 0, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [aux_sym_program_token1] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_macroexp] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [sym_optional_marker] = ACTIONS(1),
    [anon_sym_record] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_userdata] = ACTIONS(1),
    [anon_sym_metamethod] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_number_token2] = ACTIONS(1),
    [aux_sym_number_token3] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_PERCENT2] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__long_string_start] = ACTIONS(1),
    [sym__long_string_char] = ACTIONS(1),
    [sym__long_string_end] = ACTIONS(1),
    [sym__short_string_start] = ACTIONS(1),
    [sym__short_string_char] = ACTIONS(1),
    [sym__short_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(706),
    [sym__statement] = STATE(170),
    [sym_return_statement] = STATE(392),
    [sym_if_statement] = STATE(392),
    [sym_numeric_for_statement] = STATE(392),
    [sym_generic_for_statement] = STATE(392),
    [sym__for_statement] = STATE(392),
    [sym_while_statement] = STATE(392),
    [sym_repeat_statement] = STATE(392),
    [sym_do_statement] = STATE(392),
    [sym_parenthesized_expression] = STATE(528),
    [sym_var_declaration] = STATE(392),
    [sym_type_declaration] = STATE(392),
    [sym_assignment_variables] = STATE(715),
    [sym_var_assignment] = STATE(392),
    [sym__prefix_expression] = STATE(528),
    [sym_method_index] = STATE(538),
    [sym_function_call] = STATE(330),
    [sym_function_statement] = STATE(392),
    [sym_macroexp_statement] = STATE(392),
    [sym_interface_declaration] = STATE(373),
    [sym_record_declaration] = STATE(373),
    [sym_enum_declaration] = STATE(373),
    [sym_goto] = STATE(392),
    [sym_index] = STATE(3),
    [sym__var] = STATE(526),
    [aux_sym_program_repeat1] = STATE(170),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [aux_sym_program_token1] = ACTIONS(9),
    [anon_sym_COLON_COLON] = ACTIONS(11),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [sym_break] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_while] = ACTIONS(23),
    [anon_sym_repeat] = ACTIONS(25),
    [anon_sym_do] = ACTIONS(27),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_global] = ACTIONS(31),
    [anon_sym_function] = ACTIONS(33),
    [anon_sym_goto] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_arguments] = STATE(10),
    [sym_table_constructor] = STATE(13),
    [sym_string] = STATE(13),
    [ts_builtin_sym_end] = ACTIONS(37),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_COLON_COLON] = ACTIONS(37),
    [anon_sym_SEMI] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_COMMA] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(37),
    [sym_break] = ACTIONS(39),
    [anon_sym_if] = ACTIONS(39),
    [anon_sym_then] = ACTIONS(39),
    [anon_sym_end] = ACTIONS(39),
    [anon_sym_elseif] = ACTIONS(39),
    [anon_sym_else] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_repeat] = ACTIONS(39),
    [anon_sym_until] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(37),
    [anon_sym_TILDE] = ACTIONS(39),
    [anon_sym_or] = ACTIONS(39),
    [anon_sym_and] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(37),
    [anon_sym_EQ_EQ] = ACTIONS(37),
    [anon_sym_TILDE_EQ] = ACTIONS(37),
    [anon_sym_GT_EQ] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_PIPE] = ACTIONS(37),
    [anon_sym_AMP] = ACTIONS(37),
    [anon_sym_LT_LT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(37),
    [anon_sym_PLUS] = ACTIONS(37),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_SLASH] = ACTIONS(39),
    [anon_sym_SLASH_SLASH] = ACTIONS(37),
    [anon_sym_PERCENT] = ACTIONS(37),
    [anon_sym_DOT_DOT] = ACTIONS(37),
    [anon_sym_CARET] = ACTIONS(37),
    [anon_sym_is] = ACTIONS(39),
    [anon_sym_as] = ACTIONS(39),
    [anon_sym_type] = ACTIONS(39),
    [anon_sym_COLON] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_RBRACK] = ACTIONS(37),
    [anon_sym_LBRACE] = ACTIONS(47),
    [anon_sym_RBRACE] = ACTIONS(37),
    [anon_sym_DOT] = ACTIONS(49),
    [anon_sym_local] = ACTIONS(39),
    [anon_sym_global] = ACTIONS(39),
    [anon_sym_function] = ACTIONS(39),
    [anon_sym_macroexp] = ACTIONS(39),
    [anon_sym_record] = ACTIONS(39),
    [anon_sym_interface] = ACTIONS(39),
    [anon_sym_enum] = ACTIONS(39),
    [anon_sym_userdata] = ACTIONS(39),
    [anon_sym_metamethod] = ACTIONS(39),
    [anon_sym_goto] = ACTIONS(39),
    [sym_comment] = ACTIONS(3),
    [sym__long_string_start] = ACTIONS(51),
    [sym__short_string_start] = ACTIONS(53),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(57), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [70] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(61), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [140] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_LT,
    ACTIONS(69), 1,
      anon_sym_DOT,
    STATE(41), 1,
      sym_typearg_params,
    ACTIONS(63), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(65), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(73), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [286] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(67), 1,
      anon_sym_LT,
    STATE(18), 1,
      sym_typearg_params,
    ACTIONS(75), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(77), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(79), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(81), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(57), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(85), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [567] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(69), 1,
      anon_sym_DOT,
    ACTIONS(87), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(89), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [638] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(93), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [707] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(97), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [776] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(101), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [845] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(105), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(109), 36,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [983] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(113), 36,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [1052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(117), 36,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [1121] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(121), 36,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [1190] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(125), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(129), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1328] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(133), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(137), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(141), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1535] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 27,
      sym__long_string_start,
      sym__short_string_start,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(145), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1604] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(151), 1,
      anon_sym_LPAREN,
    ACTIONS(153), 1,
      anon_sym_LT,
    STATE(56), 1,
      sym_typeargs,
    STATE(57), 1,
      sym_function_type_args,
    ACTIONS(147), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(149), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1680] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(155), 1,
      anon_sym_LT,
    STATE(53), 1,
      sym_typearg_params,
    ACTIONS(75), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(77), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [1752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(159), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [1820] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(163), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [1888] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(167), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [1956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(171), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(173), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(175), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2092] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(179), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(183), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(187), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2296] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(191), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(195), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(197), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(199), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(203), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2568] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(207), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2636] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(211), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(215), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2772] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(219), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(223), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(227), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [2976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(89), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [3044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(231), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [3112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(235), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [3180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(109), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [3248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(239), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [3316] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(243), 35,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_EQ,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [3384] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(155), 1,
      anon_sym_LT,
    ACTIONS(245), 1,
      anon_sym_DOT,
    STATE(82), 1,
      sym_typearg_params,
    ACTIONS(63), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(65), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3458] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(117), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3525] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(251), 1,
      anon_sym_COMMA,
    STATE(61), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(247), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(249), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3596] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_DOT,
    ACTIONS(87), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(89), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3665] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(151), 1,
      anon_sym_LPAREN,
    STATE(59), 1,
      sym_function_type_args,
    ACTIONS(254), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(256), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3736] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_COLON,
    ACTIONS(258), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(260), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(243), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3872] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(268), 1,
      anon_sym_COLON,
    ACTIONS(264), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(266), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [3941] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 1,
      anon_sym_COMMA,
    ACTIONS(277), 1,
      anon_sym_PIPE,
    ACTIONS(279), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(94), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(270), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(272), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4016] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 1,
      anon_sym_COMMA,
    STATE(61), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(281), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(283), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(179), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(183), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4221] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(113), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4288] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(290), 1,
      anon_sym_LT,
    STATE(72), 1,
      sym_function_type_args,
    STATE(80), 1,
      sym_typeargs,
    ACTIONS(147), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(149), 31,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(203), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(121), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(219), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(227), 34,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4631] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 1,
      anon_sym_PIPE,
    ACTIONS(292), 1,
      anon_sym_COMMA,
    ACTIONS(295), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(54), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(270), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(272), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4706] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 1,
      anon_sym_PIPE,
    ACTIONS(281), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(283), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4774] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      anon_sym_COLON,
    ACTIONS(258), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(260), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(159), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4908] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(299), 1,
      anon_sym_COMMA,
    STATE(74), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(281), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [4978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(167), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(171), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5110] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 1,
      anon_sym_PIPE,
    ACTIONS(295), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(281), 23,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5180] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(173), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(175), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5246] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_COLON,
    ACTIONS(264), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(266), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5314] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    STATE(79), 1,
      sym_function_type_args,
    ACTIONS(254), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(256), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(187), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(211), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(231), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5582] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(191), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5648] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(195), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(197), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(199), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(235), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5846] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(207), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(109), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [5978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(215), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6044] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(239), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(223), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6176] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(89), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6242] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 1,
      anon_sym_COMMA,
    STATE(74), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(247), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(249), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(163), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6378] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 1,
      anon_sym_PIPE,
    ACTIONS(279), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(307), 1,
      anon_sym_COMMA,
    STATE(113), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(270), 21,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(272), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6452] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 1,
      anon_sym_PIPE,
    ACTIONS(279), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(281), 23,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 33,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT_DOT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6522] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(311), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(315), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6652] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(145), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6717] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(123), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(125), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(319), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(129), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(323), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [6977] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(133), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7042] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(137), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(327), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7172] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(331), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7237] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(335), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7302] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(339), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(141), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 25,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(343), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7497] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(345), 1,
      anon_sym_COMMA,
    STATE(74), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(247), 23,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(249), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7566] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(290), 1,
      anon_sym_LT,
    STATE(117), 1,
      sym_function_type_args,
    STATE(118), 1,
      sym_typeargs,
    ACTIONS(147), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(149), 31,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7639] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 1,
      anon_sym_PIPE,
    ACTIONS(281), 24,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7706] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 1,
      anon_sym_COLON,
    ACTIONS(264), 23,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(266), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7772] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(351), 1,
      anon_sym_COLON,
    ACTIONS(258), 23,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(260), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7838] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    STATE(116), 1,
      sym_function_type_args,
    ACTIONS(254), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(256), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7906] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(353), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(355), 31,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [7973] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 1,
      anon_sym_PIPE,
    ACTIONS(337), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(339), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8038] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 16,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 30,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8113] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 14,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 30,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8190] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 19,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DOT_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 30,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8261] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 30,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8340] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(381), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(389), 1,
      anon_sym_is,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(363), 8,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8431] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(389), 1,
      anon_sym_is,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(363), 8,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 26,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_and,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8520] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 12,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 29,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8603] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 29,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8684] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 16,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 30,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8759] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(363), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 31,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8826] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(363), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 31,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8893] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 1,
      anon_sym_PIPE,
    ACTIONS(363), 22,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(365), 32,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_then,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [8958] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(397), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(415), 1,
      sym_nil,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(391), 3,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(153), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
    ACTIONS(395), 14,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_goto,
  [9050] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(81), 10,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_DOT,
    ACTIONS(423), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
    ACTIONS(79), 20,
      sym__long_string_start,
      sym__short_string_start,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [9112] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 15,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_RBRACE,
    ACTIONS(365), 22,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9178] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(353), 21,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
    ACTIONS(355), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9236] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(363), 21,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
    ACTIONS(365), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9294] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 18,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
    ACTIONS(365), 22,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9356] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 12,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_RBRACE,
    ACTIONS(365), 22,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9426] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(443), 1,
      anon_sym_and,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(451), 1,
      anon_sym_is,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(363), 7,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(365), 17,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9508] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(451), 1,
      anon_sym_is,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(363), 7,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(365), 18,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_and,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9588] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_RBRACE,
    ACTIONS(365), 21,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9662] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 12,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_RBRACE,
    ACTIONS(365), 21,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9734] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACE,
    ACTIONS(365), 22,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9802] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(363), 15,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_RBRACE,
    ACTIONS(365), 22,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9868] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 1,
      anon_sym_PIPE,
    ACTIONS(363), 21,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
    ACTIONS(365), 24,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9924] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(363), 21,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_RBRACE,
    ACTIONS(365), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [9982] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(347), 1,
      anon_sym_PIPE,
    ACTIONS(337), 21,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_RBRACE,
    ACTIONS(339), 24,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_TILDE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_is,
      anon_sym_as,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [10038] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(453), 1,
      anon_sym_end,
    ACTIONS(455), 1,
      anon_sym_elseif,
    ACTIONS(457), 1,
      anon_sym_else,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(725), 1,
      sym_else_block,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(540), 2,
      sym_elseif_block,
      aux_sym_if_statement_repeat1,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [10144] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(455), 1,
      anon_sym_elseif,
    ACTIONS(457), 1,
      anon_sym_else,
    ACTIONS(459), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(726), 1,
      sym_else_block,
    STATE(149), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(547), 2,
      sym_elseif_block,
      aux_sym_if_statement_repeat1,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [10250] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(443), 1,
      anon_sym_and,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(451), 1,
      anon_sym_is,
    ACTIONS(465), 1,
      anon_sym_or,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(461), 6,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(463), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [10333] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(443), 1,
      anon_sym_and,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(451), 1,
      anon_sym_is,
    ACTIONS(465), 1,
      anon_sym_or,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    STATE(362), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(467), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(469), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [10420] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(435), 1,
      anon_sym_as,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(443), 1,
      anon_sym_and,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(451), 1,
      anon_sym_is,
    ACTIONS(465), 1,
      anon_sym_or,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    STATE(360), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(473), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(475), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [10507] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 1,
      ts_builtin_sym_end,
    ACTIONS(479), 1,
      sym_identifier,
    ACTIONS(482), 1,
      anon_sym_COLON_COLON,
    ACTIONS(485), 1,
      anon_sym_return,
    ACTIONS(488), 1,
      anon_sym_LPAREN,
    ACTIONS(491), 1,
      sym_break,
    ACTIONS(494), 1,
      anon_sym_if,
    ACTIONS(499), 1,
      anon_sym_for,
    ACTIONS(502), 1,
      anon_sym_while,
    ACTIONS(505), 1,
      anon_sym_repeat,
    ACTIONS(508), 1,
      anon_sym_do,
    ACTIONS(511), 1,
      anon_sym_local,
    ACTIONS(514), 1,
      anon_sym_global,
    ACTIONS(517), 1,
      anon_sym_function,
    ACTIONS(520), 1,
      anon_sym_goto,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    ACTIONS(497), 4,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_until,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [10606] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(157), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    ACTIONS(523), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [10701] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(381), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(389), 1,
      anon_sym_is,
    ACTIONS(529), 1,
      anon_sym_or,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(525), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(527), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [10782] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    ACTIONS(531), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [10877] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(381), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(389), 1,
      anon_sym_is,
    ACTIONS(529), 1,
      anon_sym_or,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(533), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(535), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [10958] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(381), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(389), 1,
      anon_sym_is,
    ACTIONS(529), 1,
      anon_sym_or,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(539), 1,
      anon_sym_end,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(545), 1,
      anon_sym_LBRACE,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    STATE(410), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [11071] = 34,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(359), 1,
      anon_sym_as,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(381), 1,
      anon_sym_and,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(389), 1,
      anon_sym_is,
    ACTIONS(529), 1,
      anon_sym_or,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(559), 1,
      anon_sym_end,
    ACTIONS(561), 1,
      anon_sym_LBRACE,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    STATE(409), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [11184] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(563), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(391), 1,
      sym_function_body,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(165), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [11280] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(563), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(368), 1,
      sym_function_body,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(165), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [11376] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(563), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(108), 1,
      sym_function_body,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(165), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [11472] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(565), 1,
      ts_builtin_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [11565] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(567), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [11658] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(569), 1,
      anon_sym_until,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(171), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [11751] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      anon_sym_LT,
    STATE(178), 1,
      sym_typearg_params,
    ACTIONS(75), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(77), 26,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [11804] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 1,
      anon_sym_LT,
    ACTIONS(573), 1,
      anon_sym_DOT,
    STATE(199), 1,
      sym_typearg_params,
    ACTIONS(63), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(65), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [11859] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(575), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(173), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [11952] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(577), 1,
      ts_builtin_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [12045] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(579), 1,
      anon_sym_until,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [12138] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(577), 1,
      ts_builtin_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(164), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [12231] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(581), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [12324] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(583), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(175), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [12417] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_COLON_COLON,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(17), 1,
      sym_break,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_while,
    ACTIONS(25), 1,
      anon_sym_repeat,
    ACTIONS(27), 1,
      anon_sym_do,
    ACTIONS(29), 1,
      anon_sym_local,
    ACTIONS(31), 1,
      anon_sym_global,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_goto,
    ACTIONS(585), 1,
      anon_sym_end,
    STATE(3), 1,
      sym_index,
    STATE(330), 1,
      sym_function_call,
    STATE(526), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(715), 1,
      sym_assignment_variables,
    STATE(154), 2,
      sym__statement,
      aux_sym_program_repeat1,
    STATE(528), 2,
      sym_parenthesized_expression,
      sym__prefix_expression,
    STATE(373), 3,
      sym_interface_declaration,
      sym_record_declaration,
      sym_enum_declaration,
    STATE(392), 14,
      sym_return_statement,
      sym_if_statement,
      sym_numeric_for_statement,
      sym_generic_for_statement,
      sym__for_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_do_statement,
      sym_var_declaration,
      sym_type_declaration,
      sym_var_assignment,
      sym_function_statement,
      sym_macroexp_statement,
      sym_goto,
  [12510] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      anon_sym_LPAREN,
    ACTIONS(589), 1,
      anon_sym_LT,
    STATE(198), 1,
      sym_typeargs,
    STATE(215), 1,
      sym_function_type_args,
    ACTIONS(147), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(149), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12566] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_LT,
    STATE(220), 1,
      sym_typeargs,
    STATE(222), 1,
      sym_function_type_args,
    ACTIONS(147), 10,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(149), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12621] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(117), 26,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(113), 26,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(121), 26,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12762] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 1,
      anon_sym_DOT,
    ACTIONS(87), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(89), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(215), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(195), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(197), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(199), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(201), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(203), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [12995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(205), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(207), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(219), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(221), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(223), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(227), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13179] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(593), 1,
      anon_sym_COMMA,
    ACTIONS(596), 1,
      anon_sym_PIPE,
    ACTIONS(598), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(191), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(270), 9,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(272), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13233] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(600), 1,
      anon_sym_COMMA,
    STATE(212), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(247), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(249), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13283] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(609), 1,
      anon_sym_RBRACE,
    ACTIONS(611), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    STATE(578), 1,
      sym_table_entry,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(605), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(332), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [13367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(87), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(89), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13413] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(611), 1,
      sym_nil,
    ACTIONS(615), 1,
      anon_sym_RBRACE,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    STATE(591), 1,
      sym_table_entry,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(613), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(332), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [13497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(163), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13543] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(596), 1,
      anon_sym_PIPE,
    ACTIONS(617), 1,
      anon_sym_COMMA,
    STATE(214), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(270), 9,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(272), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(165), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(167), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13643] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      anon_sym_LPAREN,
    STATE(217), 1,
      sym_function_type_args,
    ACTIONS(254), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(256), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13693] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(209), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(211), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(231), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(235), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13831] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(109), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(239), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(243), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [13969] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(189), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(191), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(159), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(169), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(171), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(173), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(175), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14153] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(177), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(179), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(183), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(185), 13,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(187), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14291] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(620), 1,
      anon_sym_COMMA,
    STATE(212), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(281), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(283), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14341] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(596), 1,
      anon_sym_PIPE,
    ACTIONS(281), 10,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14390] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_COMMA,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(247), 10,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(249), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14439] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 1,
      anon_sym_COLON,
    ACTIONS(258), 12,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(260), 24,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14486] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(628), 1,
      anon_sym_COMMA,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(281), 10,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14535] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 1,
      anon_sym_COLON,
    ACTIONS(264), 12,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(266), 24,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14582] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_PIPE,
    ACTIONS(598), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(281), 10,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14631] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_PIPE,
    ACTIONS(281), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(283), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14678] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    STATE(226), 1,
      sym_function_type_args,
    ACTIONS(254), 10,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(256), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14727] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(611), 1,
      sym_nil,
    ACTIONS(633), 1,
      anon_sym_RBRACE,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    STATE(612), 1,
      sym_table_entry,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(332), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [14807] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 1,
      anon_sym_COLON,
    ACTIONS(258), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(260), 24,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [14853] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(611), 1,
      sym_nil,
    ACTIONS(637), 1,
      anon_sym_RBRACE,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    STATE(612), 1,
      sym_table_entry,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(332), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [14933] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(611), 1,
      sym_nil,
    ACTIONS(639), 1,
      anon_sym_RBRACE,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    STATE(612), 1,
      sym_table_entry,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(332), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15013] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(611), 1,
      sym_nil,
    ACTIONS(641), 1,
      anon_sym_RBRACE,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    STATE(612), 1,
      sym_table_entry,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(332), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15093] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 1,
      anon_sym_COLON,
    ACTIONS(264), 11,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(266), 24,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [15139] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(281), 10,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
    ACTIONS(283), 25,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_where,
      anon_sym_goto,
      sym_identifier,
  [15185] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(279), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(596), 1,
      anon_sym_PIPE,
    ACTIONS(647), 1,
      anon_sym_COMMA,
    STATE(237), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(270), 8,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
    ACTIONS(272), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [15236] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(603), 1,
      sym_identifier,
    ACTIONS(607), 1,
      anon_sym_LBRACK,
    ACTIONS(611), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    STATE(612), 1,
      sym_table_entry,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(332), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15313] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_LT,
    STATE(248), 1,
      sym_function_type_args,
    STATE(257), 1,
      sym_typeargs,
    ACTIONS(147), 8,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
    ACTIONS(149), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [15364] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(649), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(381), 1,
      sym_expressions,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(152), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15438] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(651), 1,
      anon_sym_EQ,
    ACTIONS(653), 1,
      anon_sym_COLON,
    ACTIONS(57), 5,
      anon_sym_TILDE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
    ACTIONS(55), 27,
      sym__long_string_start,
      sym__short_string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [15484] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(395), 1,
      anon_sym_end,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(415), 1,
      sym_nil,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(656), 1,
      anon_sym_LPAREN,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(153), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15558] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(649), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(390), 1,
      sym_expressions,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(152), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15632] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(649), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(367), 1,
      sym_expressions,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(152), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15706] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(658), 1,
      anon_sym_RPAREN,
    ACTIONS(660), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(329), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15780] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(662), 1,
      anon_sym_COMMA,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(247), 9,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
    ACTIONS(249), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [15826] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(668), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(128), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15897] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(670), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(144), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [15968] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(672), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(145), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16039] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(674), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(137), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16110] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(676), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(333), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16181] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(678), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(135), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16252] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(680), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(326), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16323] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(682), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(147), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16394] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(684), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(331), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16465] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(686), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(325), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16536] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 1,
      anon_sym_COLON,
    ACTIONS(258), 9,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
    ACTIONS(260), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [16579] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 1,
      anon_sym_COLON,
    ACTIONS(264), 9,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
    ACTIONS(266), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [16622] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(692), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(344), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16693] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(694), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(327), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16764] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(696), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(136), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16835] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(698), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(141), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16906] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(700), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(324), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [16977] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(702), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(342), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17048] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(704), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(156), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17119] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(288), 1,
      anon_sym_LPAREN,
    STATE(249), 1,
      sym_function_type_args,
    ACTIONS(254), 8,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
    ACTIONS(256), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [17164] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(706), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(351), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17235] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(708), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(328), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17306] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(710), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(139), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17377] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(712), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(151), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17448] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(714), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(341), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17519] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(716), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(138), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17590] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(718), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(337), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17661] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(720), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(343), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17732] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(722), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(159), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17803] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(724), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(334), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17874] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(726), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(158), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [17945] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(728), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(160), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18016] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(730), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(142), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18087] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(732), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(143), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18158] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(734), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(140), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18229] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(736), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(123), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18300] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(738), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(124), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18371] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(740), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(125), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18442] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(742), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(126), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18513] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(744), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(127), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18584] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(746), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(335), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18655] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(748), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(122), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18726] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(750), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(121), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18797] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(752), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(130), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18868] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(754), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(129), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [18939] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(756), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(131), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [19010] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(664), 1,
      anon_sym_not,
    ACTIONS(758), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(666), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(119), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [19081] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(393), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_not,
    ACTIONS(403), 1,
      anon_sym_LBRACE,
    ACTIONS(405), 1,
      anon_sym_function,
    ACTIONS(407), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(409), 1,
      aux_sym_number_token1,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    ACTIONS(760), 1,
      sym_nil,
    STATE(3), 1,
      sym_index,
    STATE(538), 1,
      sym_method_index,
    ACTIONS(411), 2,
      aux_sym_number_token2,
      aux_sym_number_token3,
    ACTIONS(413), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(401), 3,
      anon_sym_POUND,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2), 4,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
      sym__var,
    STATE(323), 10,
      sym__expression,
      sym_unary_op,
      sym_bin_op,
      sym_type_cast,
      sym_table_constructor,
      sym_anon_function,
      sym_varargs,
      sym_number,
      sym_boolean,
      sym_string,
  [19152] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 1,
      anon_sym_end,
    ACTIONS(81), 5,
      anon_sym_TILDE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_DOT,
    ACTIONS(79), 26,
      sym__long_string_start,
      sym__short_string_start,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DASH,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
      anon_sym_is,
      anon_sym_as,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [19194] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(762), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(764), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19233] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(770), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(774), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(764), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19341] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(778), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(782), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(786), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19449] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(790), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(794), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19521] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(798), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(802), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(806), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19629] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(808), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(810), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(814), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(818), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19737] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(822), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19773] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(824), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(826), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(830), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19845] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(834), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(838), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19917] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(842), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19953] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(846), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [19989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(850), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20025] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(854), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(858), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(862), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(866), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(870), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(874), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20241] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(878), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20277] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(882), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(886), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20349] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(890), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(894), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20421] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(898), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20457] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
    ACTIONS(902), 23,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_type,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      anon_sym_goto,
      sym_identifier,
  [20493] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(904), 1,
      anon_sym_do,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    STATE(387), 1,
      sym_do_statement,
    STATE(588), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [20562] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(904), 1,
      anon_sym_do,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    STATE(366), 1,
      sym_do_statement,
    STATE(594), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [20631] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(904), 1,
      anon_sym_do,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(914), 1,
      anon_sym_COMMA,
    STATE(393), 1,
      sym_do_statement,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [20697] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(916), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [20759] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(918), 1,
      anon_sym_RPAREN,
    STATE(599), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [20825] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(920), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [20887] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(922), 1,
      anon_sym_RPAREN,
    STATE(605), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [20953] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_SEMI,
    ACTIONS(932), 1,
      anon_sym_COLON,
    ACTIONS(924), 2,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
    ACTIONS(930), 6,
      sym__long_string_start,
      sym__short_string_start,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT,
    ACTIONS(926), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [20993] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(934), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21055] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(936), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21117] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(938), 1,
      anon_sym_RPAREN,
    STATE(599), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21183] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(904), 1,
      anon_sym_do,
    ACTIONS(940), 1,
      anon_sym_or,
    ACTIONS(942), 1,
      anon_sym_and,
    ACTIONS(944), 1,
      anon_sym_is,
    ACTIONS(946), 1,
      anon_sym_as,
    STATE(386), 1,
      sym_do_statement,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21246] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(904), 1,
      anon_sym_do,
    ACTIONS(940), 1,
      anon_sym_or,
    ACTIONS(942), 1,
      anon_sym_and,
    ACTIONS(944), 1,
      anon_sym_is,
    ACTIONS(946), 1,
      anon_sym_as,
    STATE(380), 1,
      sym_do_statement,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21309] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(288), 1,
      sym_record_body,
    STATE(358), 1,
      sym_typeargs,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [21381] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(940), 1,
      anon_sym_or,
    ACTIONS(942), 1,
      anon_sym_and,
    ACTIONS(944), 1,
      anon_sym_is,
    ACTIONS(946), 1,
      anon_sym_as,
    ACTIONS(954), 1,
      anon_sym_RPAREN,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21441] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(958), 1,
      anon_sym_end,
    ACTIONS(960), 1,
      anon_sym_LBRACE,
    ACTIONS(962), 1,
      anon_sym_where,
    STATE(353), 1,
      aux_sym_type_tuple_repeat1,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(408), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [21513] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 1,
      anon_sym_COMMA,
    STATE(350), 1,
      aux_sym_var_declarators_repeat1,
    ACTIONS(964), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(966), 17,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [21549] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(296), 1,
      sym_record_body,
    STATE(359), 1,
      sym_typeargs,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [21621] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(940), 1,
      anon_sym_or,
    ACTIONS(942), 1,
      anon_sym_and,
    ACTIONS(944), 1,
      anon_sym_is,
    ACTIONS(946), 1,
      anon_sym_as,
    ACTIONS(970), 1,
      anon_sym_RBRACK,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21681] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(940), 1,
      anon_sym_or,
    ACTIONS(942), 1,
      anon_sym_and,
    ACTIONS(944), 1,
      anon_sym_is,
    ACTIONS(946), 1,
      anon_sym_as,
    ACTIONS(972), 1,
      anon_sym_RBRACK,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21741] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(940), 1,
      anon_sym_or,
    ACTIONS(942), 1,
      anon_sym_and,
    ACTIONS(944), 1,
      anon_sym_is,
    ACTIONS(946), 1,
      anon_sym_as,
    ACTIONS(974), 1,
      anon_sym_then,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21801] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 1,
      anon_sym_SLASH,
    ACTIONS(431), 1,
      anon_sym_DOT_DOT,
    ACTIONS(433), 1,
      anon_sym_CARET,
    ACTIONS(437), 1,
      anon_sym_AMP,
    ACTIONS(441), 1,
      anon_sym_TILDE,
    ACTIONS(449), 1,
      anon_sym_PIPE,
    ACTIONS(906), 1,
      anon_sym_or,
    ACTIONS(908), 1,
      anon_sym_and,
    ACTIONS(910), 1,
      anon_sym_is,
    ACTIONS(912), 1,
      anon_sym_as,
    ACTIONS(976), 1,
      anon_sym_COMMA,
    ACTIONS(425), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(439), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(445), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(427), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(447), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [21861] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 1,
      anon_sym_COMMA,
    STATE(345), 1,
      aux_sym_var_declarators_repeat1,
    ACTIONS(978), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(980), 17,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [21897] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(319), 1,
      sym_record_body,
    STATE(361), 1,
      sym_typeargs,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [21969] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(989), 1,
      anon_sym_LT,
    ACTIONS(985), 6,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(987), 17,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22003] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(320), 1,
      sym_record_body,
    STATE(363), 1,
      sym_typeargs,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [22075] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    STATE(357), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(991), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(993), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22113] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(968), 1,
      anon_sym_COMMA,
    STATE(345), 1,
      aux_sym_var_declarators_repeat1,
    ACTIONS(995), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(997), 17,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22149] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 1,
      anon_sym_CARET,
    ACTIONS(371), 1,
      anon_sym_SLASH,
    ACTIONS(373), 1,
      anon_sym_DOT_DOT,
    ACTIONS(377), 1,
      anon_sym_AMP,
    ACTIONS(379), 1,
      anon_sym_TILDE,
    ACTIONS(387), 1,
      anon_sym_PIPE,
    ACTIONS(940), 1,
      anon_sym_or,
    ACTIONS(942), 1,
      anon_sym_and,
    ACTIONS(944), 1,
      anon_sym_is,
    ACTIONS(946), 1,
      anon_sym_as,
    ACTIONS(999), 1,
      anon_sym_then,
    ACTIONS(367), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(375), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(383), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(369), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(385), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [22209] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 1,
      anon_sym_EQ,
    ACTIONS(1007), 1,
      anon_sym_COLON,
    STATE(364), 1,
      sym_type_annotation,
    ACTIONS(1001), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1003), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22246] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(1009), 1,
      anon_sym_end,
    ACTIONS(1011), 1,
      anon_sym_LBRACE,
    ACTIONS(1013), 1,
      anon_sym_where,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(407), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [22315] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1015), 1,
      anon_sym_COMMA,
    STATE(354), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(461), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(463), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 6,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(1020), 17,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22381] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 6,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(980), 17,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22412] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(1022), 5,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
    ACTIONS(1024), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22447] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(300), 1,
      sym_record_body,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [22513] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(301), 1,
      sym_record_body,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [22579] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    STATE(354), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1026), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1028), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22613] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(292), 1,
      sym_record_body,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [22679] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    STATE(354), 1,
      aux_sym_return_statement_repeat1,
    ACTIONS(1030), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1032), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22713] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(948), 1,
      anon_sym_end,
    ACTIONS(950), 1,
      anon_sym_is,
    ACTIONS(952), 1,
      anon_sym_LBRACE,
    STATE(294), 1,
      sym_record_body,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(398), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [22779] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 1,
      anon_sym_EQ,
    ACTIONS(1034), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1036), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1042), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22838] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1046), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1050), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1054), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22922] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1058), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22950] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1062), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [22978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1066), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23006] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1070), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23034] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_SEMI,
    ACTIONS(924), 3,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(926), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23064] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1058), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23092] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1066), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23120] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1042), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1070), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23176] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1072), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1074), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23204] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      anon_sym_SEMI,
    ACTIONS(1076), 3,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1078), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23234] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1082), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1084), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23262] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1086), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1088), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1090), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1092), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1096), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1098), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1100), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23374] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1102), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1104), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23402] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1106), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1108), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1110), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1112), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23458] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1114), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1116), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23486] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1118), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1120), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1122), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1124), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23542] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1128), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23570] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(928), 1,
      anon_sym_SEMI,
    ACTIONS(924), 3,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(926), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1132), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1136), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1138), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1140), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23684] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 4,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_LPAREN,
    ACTIONS(1144), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23712] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1146), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(400), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [23769] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1148), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [23826] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1150), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [23883] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1152), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [23940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1154), 3,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1156), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [23967] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1158), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24024] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1160), 1,
      sym_identifier,
    ACTIONS(1163), 1,
      anon_sym_end,
    ACTIONS(1165), 1,
      anon_sym_type,
    ACTIONS(1168), 1,
      anon_sym_LBRACK,
    ACTIONS(1171), 1,
      anon_sym_macroexp,
    ACTIONS(1174), 1,
      anon_sym_record,
    ACTIONS(1177), 1,
      anon_sym_interface,
    ACTIONS(1180), 1,
      anon_sym_enum,
    ACTIONS(1183), 1,
      anon_sym_userdata,
    ACTIONS(1186), 1,
      anon_sym_metamethod,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24081] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1189), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(414), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24138] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1191), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(399), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24195] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1193), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(402), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24252] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1195), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24309] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1197), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24366] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1199), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24423] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1201), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24480] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1203), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(413), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1205), 3,
      ts_builtin_sym_end,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1207), 16,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24564] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1209), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24621] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      sym_identifier,
    ACTIONS(541), 1,
      anon_sym_type,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(549), 1,
      anon_sym_record,
    ACTIONS(551), 1,
      anon_sym_interface,
    ACTIONS(553), 1,
      anon_sym_enum,
    ACTIONS(555), 1,
      anon_sym_userdata,
    ACTIONS(557), 1,
      anon_sym_metamethod,
    ACTIONS(1211), 1,
      anon_sym_end,
    STATE(488), 1,
      sym__type_def,
    STATE(489), 1,
      sym__macroexp_def,
    STATE(492), 1,
      sym_metamethod_annotation,
    STATE(498), 1,
      sym__record_def,
    STATE(500), 1,
      sym__interface_def,
    STATE(508), 1,
      sym__enum_def,
    STATE(403), 3,
      sym_record_field,
      sym__record_entry,
      aux_sym_record_body_repeat1,
  [24678] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    ACTIONS(1221), 1,
      anon_sym_record,
    ACTIONS(1223), 1,
      anon_sym_interface,
    ACTIONS(1225), 1,
      anon_sym_enum,
    STATE(11), 1,
      sym_type_index,
    STATE(287), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
    STATE(290), 4,
      sym_anon_interface,
      sym_anon_record,
      sym__anon_enum,
      sym__newtype,
  [24721] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1229), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1227), 14,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1233), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1231), 14,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1237), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1235), 14,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1241), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1239), 14,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24817] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1247), 1,
      anon_sym_COLON,
    ACTIONS(1245), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1243), 13,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24843] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1253), 1,
      anon_sym_COLON,
    ACTIONS(1251), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1249), 13,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1257), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1255), 14,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24893] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1261), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1259), 14,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_COLON,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24917] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1265), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1263), 13,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1269), 2,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(1267), 13,
      anon_sym_return,
      sym_break,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_do,
      anon_sym_local,
      anon_sym_global,
      anon_sym_function,
      anon_sym_goto,
      sym_identifier,
  [24963] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1273), 1,
      anon_sym_RPAREN,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_type_index,
    STATE(606), 1,
      sym__partype,
    STATE(619), 1,
      sym__type,
    STATE(674), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25003] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1279), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      sym_type_index,
    STATE(613), 1,
      sym__partype,
    STATE(619), 1,
      sym__type,
    STATE(686), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25043] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1281), 1,
      anon_sym_RPAREN,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(634), 1,
      sym__partype,
    STATE(721), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25083] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(547), 1,
      anon_sym_macroexp,
    ACTIONS(1283), 1,
      sym_identifier,
    ACTIONS(1285), 1,
      anon_sym_type,
    ACTIONS(1287), 1,
      anon_sym_function,
    ACTIONS(1289), 1,
      anon_sym_record,
    ACTIONS(1291), 1,
      anon_sym_interface,
    ACTIONS(1293), 1,
      anon_sym_enum,
    STATE(339), 1,
      sym_var_declarator,
    STATE(352), 1,
      sym_var_declarators,
    STATE(365), 1,
      sym__interface_def,
    STATE(369), 1,
      sym__type_def,
    STATE(371), 1,
      sym__record_def,
    STATE(372), 1,
      sym__enum_def,
    STATE(385), 1,
      sym__macroexp_def,
  [25129] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(644), 1,
      sym__partype,
    STATE(677), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25166] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(644), 1,
      sym__partype,
    STATE(704), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25203] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(644), 1,
      sym__partype,
    STATE(705), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25240] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(644), 1,
      sym__partype,
    STATE(668), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25277] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(644), 1,
      sym__partype,
    STATE(709), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25314] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(644), 1,
      sym__partype,
    STATE(667), 1,
      sym__annotated_var_arg,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25351] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(35), 1,
      sym_return_type,
    STATE(55), 1,
      sym_type_index,
    STATE(60), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25385] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(35), 1,
      sym_return_type,
    STATE(55), 1,
      sym_type_index,
    STATE(96), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25419] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(40), 1,
      sym_return_type,
    STATE(55), 1,
      sym_type_index,
    STATE(96), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25453] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(40), 1,
      sym_return_type,
    STATE(55), 1,
      sym_type_index,
    STATE(60), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25487] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(35), 1,
      sym_return_type,
    STATE(181), 1,
      sym_type_index,
    STATE(196), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25521] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(40), 1,
      sym_return_type,
    STATE(181), 1,
      sym_type_index,
    STATE(196), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25555] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(35), 1,
      sym_return_type,
    STATE(181), 1,
      sym_type_index,
    STATE(228), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25589] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(40), 1,
      sym_return_type,
    STATE(181), 1,
      sym_type_index,
    STATE(228), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25623] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1309), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(190), 1,
      sym__type,
    STATE(197), 1,
      sym_variadic_type,
    STATE(211), 1,
      sym_return_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25657] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1309), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(186), 1,
      sym_return_type,
    STATE(190), 1,
      sym__type,
    STATE(197), 1,
      sym_variadic_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25691] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1311), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_type_index,
    STATE(70), 1,
      sym__type,
    STATE(75), 1,
      sym_variadic_type,
    STATE(88), 1,
      sym_return_type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25725] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1311), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_type_index,
    STATE(70), 1,
      sym__type,
    STATE(75), 1,
      sym_variadic_type,
    STATE(81), 1,
      sym_return_type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25759] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1313), 1,
      anon_sym_LPAREN,
    ACTIONS(1315), 1,
      anon_sym_function,
    STATE(181), 1,
      sym_type_index,
    STATE(197), 1,
      sym_variadic_type,
    STATE(211), 1,
      sym_return_type,
    STATE(566), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25793] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(181), 1,
      sym_type_index,
    STATE(228), 1,
      sym__type,
    STATE(424), 1,
      sym_return_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25827] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      anon_sym_LPAREN,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    STATE(30), 1,
      sym_variadic_type,
    STATE(181), 1,
      sym_type_index,
    STATE(228), 1,
      sym__type,
    STATE(425), 1,
      sym_return_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25861] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1313), 1,
      anon_sym_LPAREN,
    ACTIONS(1315), 1,
      anon_sym_function,
    STATE(181), 1,
      sym_type_index,
    STATE(186), 1,
      sym_return_type,
    STATE(197), 1,
      sym_variadic_type,
    STATE(566), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25895] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 1,
      sym_identifier,
    ACTIONS(1285), 1,
      anon_sym_type,
    ACTIONS(1287), 1,
      anon_sym_function,
    ACTIONS(1289), 1,
      anon_sym_record,
    ACTIONS(1291), 1,
      anon_sym_interface,
    ACTIONS(1293), 1,
      anon_sym_enum,
    STATE(339), 1,
      sym_var_declarator,
    STATE(352), 1,
      sym_var_declarators,
    STATE(374), 1,
      sym__type_def,
    STATE(375), 1,
      sym__record_def,
    STATE(376), 1,
      sym__interface_def,
    STATE(377), 1,
      sym__enum_def,
  [25935] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1317), 1,
      anon_sym_LPAREN,
    ACTIONS(1319), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(110), 1,
      sym_type_tuple,
    STATE(120), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25966] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1315), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(183), 1,
      sym_variadic_type,
    STATE(589), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [25997] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(37), 1,
      sym_variadic_type,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26028] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 1,
      anon_sym_COLON,
    ACTIONS(1327), 1,
      anon_sym_LBRACK,
    ACTIONS(1323), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [26049] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(619), 1,
      sym__type,
    STATE(644), 1,
      sym__partype,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26080] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1329), 1,
      anon_sym_LPAREN,
    STATE(31), 1,
      sym_variadic_type,
    STATE(55), 1,
      sym_type_index,
    STATE(97), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26111] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1329), 1,
      anon_sym_LPAREN,
    STATE(37), 1,
      sym_variadic_type,
    STATE(55), 1,
      sym_type_index,
    STATE(97), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26142] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(207), 1,
      sym_variadic_type,
    STATE(218), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26173] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1333), 1,
      anon_sym_LBRACK,
    ACTIONS(1331), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [26194] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(183), 1,
      sym_variadic_type,
    STATE(218), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26225] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1329), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_type_index,
    STATE(76), 1,
      sym_variadic_type,
    STATE(77), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26256] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1329), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_type_index,
    STATE(77), 1,
      sym__type,
    STATE(85), 1,
      sym_variadic_type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26287] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1337), 1,
      anon_sym_LBRACK,
    ACTIONS(1335), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [26308] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(720), 1,
      sym_variadic_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26339] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1341), 1,
      anon_sym_LBRACK,
    ACTIONS(1339), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [26360] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(31), 1,
      sym_variadic_type,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26391] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(693), 1,
      sym_variadic_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26422] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(722), 1,
      sym_variadic_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26453] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(701), 1,
      sym_variadic_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26484] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(676), 1,
      sym_variadic_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26515] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(213), 1,
      sym__type,
    STATE(708), 1,
      sym_variadic_type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26546] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1317), 1,
      anon_sym_LPAREN,
    ACTIONS(1343), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(110), 1,
      sym_type_tuple,
    STATE(148), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26577] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1347), 1,
      anon_sym_LBRACK,
    ACTIONS(1345), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [26598] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1315), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(207), 1,
      sym_variadic_type,
    STATE(589), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26629] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1329), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_type_index,
    STATE(71), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26657] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(349), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26685] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(651), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26713] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(1301), 1,
      anon_sym_function,
    ACTIONS(1329), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_type_index,
    STATE(73), 1,
      sym__type,
    STATE(93), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26741] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(461), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26769] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(665), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26797] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(475), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26825] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(338), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26853] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(647), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26881] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(610), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26909] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(467), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [26937] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_LBRACK,
    ACTIONS(1349), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [26955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_LBRACK,
    ACTIONS(1353), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [26973] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(627), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27001] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(649), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1359), 1,
      anon_sym_LBRACK,
    ACTIONS(1357), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [27047] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(656), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27075] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(551), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27103] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(571), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27131] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1315), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(574), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27159] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(645), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27187] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1363), 1,
      anon_sym_LBRACK,
    ACTIONS(1361), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [27205] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(206), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27233] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1367), 1,
      anon_sym_LBRACK,
    ACTIONS(1365), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [27251] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1315), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(573), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27279] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(654), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27307] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(650), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27335] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(553), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27363] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1315), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(582), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27391] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(655), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27419] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(596), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27447] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1371), 1,
      anon_sym_LBRACK,
    ACTIONS(1369), 9,
      anon_sym_end,
      anon_sym_type,
      anon_sym_macroexp,
      anon_sym_record,
      anon_sym_interface,
      anon_sym_enum,
      anon_sym_userdata,
      anon_sym_metamethod,
      sym_identifier,
  [27465] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(227), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27493] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(593), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27521] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(626), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27549] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1319), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(28), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27577] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1343), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(115), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27605] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(576), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27633] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(28), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27661] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(640), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27689] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(28), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27717] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1319), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(132), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27745] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(663), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27773] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(621), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27801] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(579), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27829] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(662), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27857] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1275), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(568), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27885] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1315), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(206), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27913] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1307), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(219), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27941] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 1,
      anon_sym_COMMA,
    ACTIONS(1375), 1,
      anon_sym_EQ,
    STATE(604), 1,
      aux_sym_assignment_variables_repeat1,
    ACTIONS(930), 7,
      sym__long_string_start,
      sym__short_string_start,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT,
  [27963] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(465), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [27991] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_LBRACK,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__long_string_start,
    ACTIONS(53), 1,
      sym__short_string_start,
    ACTIONS(1377), 1,
      anon_sym_COLON,
    ACTIONS(1379), 1,
      anon_sym_DOT,
    STATE(10), 1,
      sym_arguments,
    STATE(13), 2,
      sym_table_constructor,
      sym_string,
  [28023] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_identifier,
    ACTIONS(1305), 1,
      anon_sym_LBRACE,
    ACTIONS(1315), 1,
      anon_sym_function,
    ACTIONS(1321), 1,
      anon_sym_LPAREN,
    STATE(181), 1,
      sym_type_index,
    STATE(572), 1,
      sym__type,
    STATE(193), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [28051] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1343), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(28), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [28079] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1219), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(660), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [28107] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      sym_identifier,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    ACTIONS(1217), 1,
      anon_sym_LBRACE,
    ACTIONS(1343), 1,
      anon_sym_function,
    STATE(11), 1,
      sym_type_index,
    STATE(146), 1,
      sym__type,
    STATE(46), 4,
      sym_type_union,
      sym_simple_type,
      sym_table_type,
      sym_function_type,
  [28135] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 2,
      anon_sym_COMMA,
      anon_sym_EQ,
    ACTIONS(930), 7,
      sym__long_string_start,
      sym__short_string_start,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT,
  [28152] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      anon_sym_LPAREN,
    ACTIONS(589), 1,
      anon_sym_LT,
    STATE(541), 1,
      sym_typeargs,
    STATE(559), 1,
      sym_function_type_args,
    ACTIONS(147), 4,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
  [28174] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(1383), 1,
      sym_identifier,
    STATE(3), 1,
      sym_index,
    STATE(533), 1,
      sym__var,
    STATE(538), 1,
      sym_method_index,
    STATE(528), 3,
      sym_parenthesized_expression,
      sym__prefix_expression,
      sym_function_call,
  [28198] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1385), 1,
      anon_sym_LT,
    ACTIONS(1387), 1,
      anon_sym_COLON,
    ACTIONS(1389), 1,
      anon_sym_DOT,
    STATE(41), 1,
      sym_typearg_params,
    ACTIONS(63), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PIPE,
  [28219] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1391), 1,
      anon_sym_PERCENT2,
    ACTIONS(1395), 1,
      sym__short_string_char,
    ACTIONS(1397), 1,
      sym__short_string_end,
    STATE(548), 1,
      aux_sym__short_string_content_repeat1,
    STATE(688), 1,
      sym__short_string_content,
    ACTIONS(1393), 2,
      sym_format_specifier,
      sym_escape_sequence,
  [28242] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(47), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__long_string_start,
    ACTIONS(53), 1,
      sym__short_string_start,
    STATE(10), 1,
      sym_arguments,
    STATE(13), 2,
      sym_table_constructor,
      sym_string,
  [28265] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1391), 1,
      anon_sym_PERCENT2,
    ACTIONS(1395), 1,
      sym__short_string_char,
    ACTIONS(1399), 1,
      sym__short_string_end,
    STATE(548), 1,
      aux_sym__short_string_content_repeat1,
    STATE(689), 1,
      sym__short_string_content,
    ACTIONS(1393), 2,
      sym_format_specifier,
      sym_escape_sequence,
  [28288] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      anon_sym_else,
    ACTIONS(1401), 1,
      anon_sym_end,
    ACTIONS(1403), 1,
      anon_sym_elseif,
    STATE(719), 1,
      sym_else_block,
    STATE(567), 2,
      sym_elseif_block,
      aux_sym_if_statement_repeat1,
  [28308] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 1,
      anon_sym_LPAREN,
    STATE(560), 1,
      sym_function_type_args,
    ACTIONS(254), 4,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
  [28324] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym__long_string_start,
    ACTIONS(53), 1,
      sym__short_string_start,
    ACTIONS(1405), 1,
      anon_sym_end,
    STATE(289), 1,
      sym_enum_body,
    STATE(550), 2,
      sym_string,
      aux_sym_enum_body_repeat1,
  [28344] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym__long_string_start,
    ACTIONS(53), 1,
      sym__short_string_start,
    ACTIONS(1405), 1,
      anon_sym_end,
    STATE(297), 1,
      sym_enum_body,
    STATE(550), 2,
      sym_string,
      aux_sym_enum_body_repeat1,
  [28364] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 1,
      sym__long_string_end,
    ACTIONS(1407), 1,
      anon_sym_PERCENT2,
    STATE(561), 1,
      aux_sym__long_string_content_repeat1,
    STATE(675), 1,
      sym__long_string_content,
    ACTIONS(1409), 2,
      sym__long_string_char,
      sym_format_specifier,
  [28384] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 1,
      sym__long_string_end,
    ACTIONS(1407), 1,
      anon_sym_PERCENT2,
    STATE(561), 1,
      aux_sym__long_string_content_repeat1,
    STATE(678), 1,
      sym__long_string_content,
    ACTIONS(1409), 2,
      sym__long_string_char,
      sym_format_specifier,
  [28404] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 1,
      anon_sym_PERCENT2,
    ACTIONS(1417), 1,
      sym__short_string_char,
    ACTIONS(1420), 1,
      sym__short_string_end,
    STATE(546), 1,
      aux_sym__short_string_content_repeat1,
    ACTIONS(1414), 2,
      sym_format_specifier,
      sym_escape_sequence,
  [28424] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      anon_sym_else,
    ACTIONS(1403), 1,
      anon_sym_elseif,
    ACTIONS(1422), 1,
      anon_sym_end,
    STATE(725), 1,
      sym_else_block,
    STATE(567), 2,
      sym_elseif_block,
      aux_sym_if_statement_repeat1,
  [28444] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1391), 1,
      anon_sym_PERCENT2,
    ACTIONS(1395), 1,
      sym__short_string_char,
    ACTIONS(1424), 1,
      sym__short_string_end,
    STATE(546), 1,
      aux_sym__short_string_content_repeat1,
    ACTIONS(1393), 2,
      sym_format_specifier,
      sym_escape_sequence,
  [28464] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_COMMA,
    STATE(558), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(247), 3,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
  [28479] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym__long_string_start,
    ACTIONS(53), 1,
      sym__short_string_start,
    ACTIONS(1429), 1,
      anon_sym_end,
    STATE(555), 2,
      sym_string,
      aux_sym_enum_body_repeat1,
  [28496] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1431), 1,
      anon_sym_COMMA,
    ACTIONS(1433), 1,
      anon_sym_COLON,
    ACTIONS(1435), 1,
      anon_sym_RBRACE,
    STATE(631), 1,
      aux_sym_table_type_repeat1,
  [28515] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 1,
      anon_sym_PERCENT2,
    ACTIONS(1443), 1,
      sym__long_string_end,
    STATE(552), 1,
      aux_sym__long_string_content_repeat1,
    ACTIONS(1440), 2,
      sym__long_string_char,
      sym_format_specifier,
  [28532] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1431), 1,
      anon_sym_COMMA,
    ACTIONS(1445), 1,
      anon_sym_COLON,
    ACTIONS(1447), 1,
      anon_sym_RBRACE,
    STATE(611), 1,
      aux_sym_table_type_repeat1,
  [28551] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1451), 1,
      anon_sym_COLON,
    ACTIONS(1453), 1,
      anon_sym_DOT,
    STATE(570), 1,
      aux_sym_function_name_repeat1,
    ACTIONS(1449), 2,
      anon_sym_LPAREN,
      anon_sym_LT,
  [28568] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1455), 1,
      anon_sym_end,
    ACTIONS(1457), 1,
      sym__long_string_start,
    ACTIONS(1460), 1,
      sym__short_string_start,
    STATE(555), 2,
      sym_string,
      aux_sym_enum_body_repeat1,
  [28585] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(1463), 1,
      anon_sym_LPAREN,
    STATE(161), 1,
      sym_function_signature,
    STATE(421), 1,
      sym_signature_arguments,
    STATE(659), 1,
      sym_typeargs,
  [28604] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(1463), 1,
      anon_sym_LPAREN,
    STATE(162), 1,
      sym_function_signature,
    STATE(421), 1,
      sym_signature_arguments,
    STATE(659), 1,
      sym_typeargs,
  [28623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 1,
      anon_sym_COMMA,
    STATE(558), 1,
      aux_sym_type_tuple_repeat1,
    ACTIONS(281), 3,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
  [28638] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1468), 1,
      anon_sym_COLON,
    ACTIONS(258), 4,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
  [28651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1470), 1,
      anon_sym_COLON,
    ACTIONS(264), 4,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
  [28664] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1407), 1,
      anon_sym_PERCENT2,
    ACTIONS(1472), 1,
      sym__long_string_end,
    STATE(552), 1,
      aux_sym__long_string_content_repeat1,
    ACTIONS(1409), 2,
      sym__long_string_char,
      sym_format_specifier,
  [28681] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1474), 1,
      sym_identifier,
    ACTIONS(1476), 1,
      anon_sym_RPAREN,
    STATE(628), 1,
      sym__parname,
    STATE(716), 1,
      sym__annotated_var_arg,
  [28700] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1478), 1,
      anon_sym_PERCENT2,
    ACTIONS(1480), 4,
      sym__short_string_char,
      sym__short_string_end,
      sym_format_specifier,
      sym_escape_sequence,
  [28713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1478), 1,
      anon_sym_PERCENT2,
    ACTIONS(1480), 4,
      sym__short_string_char,
      sym__short_string_end,
      sym_format_specifier,
      sym_escape_sequence,
  [28726] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(1463), 1,
      anon_sym_LPAREN,
    STATE(421), 1,
      sym_signature_arguments,
    STATE(635), 1,
      sym_function_signature,
    STATE(659), 1,
      sym_typeargs,
  [28745] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_GT,
    ACTIONS(598), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1482), 1,
      anon_sym_COMMA,
    ACTIONS(1485), 1,
      anon_sym_PIPE,
    STATE(549), 1,
      aux_sym_type_tuple_repeat1,
  [28764] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      anon_sym_end,
    ACTIONS(1489), 1,
      anon_sym_elseif,
    ACTIONS(1492), 1,
      anon_sym_else,
    STATE(567), 2,
      sym_elseif_block,
      aux_sym_if_statement_repeat1,
  [28781] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1431), 1,
      anon_sym_COMMA,
    ACTIONS(1494), 1,
      anon_sym_COLON,
    ACTIONS(1496), 1,
      anon_sym_RBRACE,
    STATE(639), 1,
      aux_sym_table_type_repeat1,
  [28800] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(591), 1,
      anon_sym_LT,
    ACTIONS(1463), 1,
      anon_sym_LPAREN,
    STATE(163), 1,
      sym_function_signature,
    STATE(421), 1,
      sym_signature_arguments,
    STATE(659), 1,
      sym_typeargs,
  [28819] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1500), 1,
      anon_sym_DOT,
    STATE(570), 1,
      aux_sym_function_name_repeat1,
    ACTIONS(1498), 3,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COLON,
  [28834] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1503), 1,
      anon_sym_COMMA,
    ACTIONS(1505), 1,
      anon_sym_RPAREN,
    STATE(638), 1,
      aux_sym_type_tuple_repeat1,
  [28850] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE,
    ACTIONS(1507), 1,
      anon_sym_COMMA,
    ACTIONS(1509), 1,
      anon_sym_GT,
    STATE(637), 1,
      aux_sym_type_tuple_repeat1,
  [28866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE,
    ACTIONS(281), 3,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_DOT_DOT_DOT,
  [28878] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE,
    ACTIONS(1507), 1,
      anon_sym_COMMA,
    ACTIONS(1511), 1,
      anon_sym_GT,
    STATE(602), 1,
      aux_sym_type_tuple_repeat1,
  [28894] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 4,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
  [28904] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1513), 1,
      anon_sym_COMMA,
    ACTIONS(1515), 1,
      anon_sym_RPAREN,
    STATE(615), 1,
      aux_sym_type_tuple_repeat1,
  [28920] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      anon_sym_PERCENT2,
    ACTIONS(1519), 3,
      sym__long_string_char,
      sym__long_string_end,
      sym_format_specifier,
  [28932] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1523), 1,
      anon_sym_RBRACE,
    STATE(584), 1,
      aux_sym_table_constructor_repeat1,
    ACTIONS(1521), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [28946] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1515), 1,
      anon_sym_RPAREN,
    ACTIONS(1525), 1,
      anon_sym_COMMA,
    STATE(607), 1,
      aux_sym_type_tuple_repeat1,
  [28962] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1474), 1,
      sym_identifier,
    STATE(652), 1,
      sym__parname,
    STATE(691), 1,
      sym__annotated_var_arg,
  [28978] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 1,
      anon_sym_RBRACE,
    STATE(583), 1,
      aux_sym_table_constructor_repeat1,
    ACTIONS(1527), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [28992] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      anon_sym_PIPE,
    ACTIONS(1507), 1,
      anon_sym_COMMA,
    ACTIONS(1529), 1,
      anon_sym_GT,
    STATE(618), 1,
      aux_sym_type_tuple_repeat1,
  [29008] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1534), 1,
      anon_sym_RBRACE,
    STATE(583), 1,
      aux_sym_table_constructor_repeat1,
    ACTIONS(1531), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [29022] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_RBRACE,
    STATE(583), 1,
      aux_sym_table_constructor_repeat1,
    ACTIONS(1536), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [29036] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 4,
      sym__long_string_start,
      sym__short_string_start,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [29046] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1542), 1,
      anon_sym_COLON,
    ACTIONS(1544), 1,
      sym_optional_marker,
    ACTIONS(1540), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29060] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1277), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1474), 1,
      sym_identifier,
    STATE(652), 1,
      sym__parname,
    STATE(694), 1,
      sym__annotated_var_arg,
  [29076] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(904), 1,
      anon_sym_do,
    STATE(354), 1,
      aux_sym_return_statement_repeat1,
    STATE(395), 1,
      sym_do_statement,
  [29092] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1485), 1,
      anon_sym_PIPE,
    ACTIONS(281), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [29106] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1546), 4,
      anon_sym_LPAREN,
      anon_sym_LT,
      anon_sym_COLON,
      anon_sym_DOT,
  [29116] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1550), 1,
      anon_sym_RBRACE,
    STATE(581), 1,
      aux_sym_table_constructor_repeat1,
    ACTIONS(1548), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [29130] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1552), 1,
      anon_sym_COMMA,
    STATE(592), 1,
      aux_sym_generic_for_statement_repeat1,
    ACTIONS(1555), 2,
      anon_sym_in,
      anon_sym_GT,
  [29144] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1503), 1,
      anon_sym_COMMA,
    ACTIONS(1515), 1,
      anon_sym_RPAREN,
    STATE(638), 1,
      aux_sym_type_tuple_repeat1,
  [29160] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(904), 1,
      anon_sym_do,
    STATE(354), 1,
      aux_sym_return_statement_repeat1,
    STATE(384), 1,
      sym_do_statement,
  [29176] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1559), 1,
      anon_sym_EQ,
    ACTIONS(1561), 1,
      anon_sym_in,
    STATE(629), 1,
      aux_sym_generic_for_statement_repeat1,
  [29192] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(1563), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      aux_sym_type_tuple_repeat1,
  [29208] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 1,
      anon_sym_DOT,
    ACTIONS(1565), 1,
      anon_sym_COLON,
    STATE(554), 1,
      aux_sym_function_name_repeat1,
  [29221] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 1,
      sym__long_string_start,
    ACTIONS(419), 1,
      sym__short_string_start,
    STATE(670), 1,
      sym_string,
  [29234] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(1567), 1,
      anon_sym_RPAREN,
    STATE(354), 1,
      aux_sym_return_statement_repeat1,
  [29247] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1569), 1,
      anon_sym_COMMA,
    ACTIONS(1571), 1,
      anon_sym_RPAREN,
    STATE(614), 1,
      aux_sym__partypelist_repeat1,
  [29260] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1573), 1,
      anon_sym_GT,
    STATE(609), 1,
      aux_sym_generic_for_statement_repeat1,
  [29273] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COMMA,
    ACTIONS(1575), 1,
      anon_sym_GT,
    STATE(558), 1,
      aux_sym_type_tuple_repeat1,
  [29286] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1577), 1,
      anon_sym_GT,
    STATE(608), 1,
      aux_sym_generic_for_statement_repeat1,
  [29299] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 1,
      anon_sym_COMMA,
    ACTIONS(1579), 1,
      anon_sym_EQ,
    STATE(617), 1,
      aux_sym_assignment_variables_repeat1,
  [29312] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 1,
      anon_sym_COMMA,
    ACTIONS(1581), 1,
      anon_sym_RPAREN,
    STATE(354), 1,
      aux_sym_return_statement_repeat1,
  [29325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_COMMA,
    ACTIONS(1585), 1,
      anon_sym_RPAREN,
    STATE(624), 1,
      aux_sym__partypelist_repeat1,
  [29338] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1587), 1,
      anon_sym_COMMA,
    ACTIONS(1589), 1,
      anon_sym_RPAREN,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
  [29351] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1591), 1,
      anon_sym_GT,
    STATE(592), 1,
      aux_sym_generic_for_statement_repeat1,
  [29364] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1593), 1,
      anon_sym_GT,
    STATE(592), 1,
      aux_sym_generic_for_statement_repeat1,
  [29377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1595), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29388] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 1,
      anon_sym_COMMA,
    ACTIONS(1597), 1,
      anon_sym_RBRACE,
    STATE(636), 1,
      aux_sym_table_type_repeat1,
  [29401] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1534), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [29410] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1599), 1,
      anon_sym_COMMA,
    ACTIONS(1601), 1,
      anon_sym_RPAREN,
    STATE(616), 1,
      aux_sym__partypelist_repeat1,
  [29423] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1603), 1,
      anon_sym_COMMA,
    ACTIONS(1606), 1,
      anon_sym_RPAREN,
    STATE(614), 1,
      aux_sym__partypelist_repeat1,
  [29436] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1608), 1,
      anon_sym_COMMA,
    ACTIONS(1610), 1,
      anon_sym_RPAREN,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
  [29449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 1,
      anon_sym_COMMA,
    ACTIONS(1614), 1,
      anon_sym_RPAREN,
    STATE(614), 1,
      aux_sym__partypelist_repeat1,
  [29462] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1616), 1,
      anon_sym_COMMA,
    ACTIONS(1619), 1,
      anon_sym_EQ,
    STATE(617), 1,
      aux_sym_assignment_variables_repeat1,
  [29475] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COMMA,
    ACTIONS(1621), 1,
      anon_sym_GT,
    STATE(558), 1,
      aux_sym_type_tuple_repeat1,
  [29488] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1623), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29499] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1627), 1,
      anon_sym_COLON,
    ACTIONS(1625), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29510] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1629), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29521] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1631), 1,
      anon_sym_COMMA,
    ACTIONS(1633), 1,
      anon_sym_RPAREN,
    STATE(633), 1,
      aux_sym__parnamelist_repeat1,
  [29534] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1635), 1,
      anon_sym_GT,
    STATE(592), 1,
      aux_sym_generic_for_statement_repeat1,
  [29547] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1637), 1,
      anon_sym_COMMA,
    ACTIONS(1639), 1,
      anon_sym_RPAREN,
    STATE(614), 1,
      aux_sym__partypelist_repeat1,
  [29560] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 3,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_GT,
  [29569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1641), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [29580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(645), 1,
      anon_sym_PIPE,
    ACTIONS(1643), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29591] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 1,
      anon_sym_COMMA,
    ACTIONS(1647), 1,
      anon_sym_RPAREN,
    STATE(622), 1,
      aux_sym__parnamelist_repeat1,
  [29604] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1649), 1,
      anon_sym_in,
    STATE(592), 1,
      aux_sym_generic_for_statement_repeat1,
  [29617] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_COMMA,
    ACTIONS(1651), 1,
      anon_sym_GT,
    STATE(623), 1,
      aux_sym_generic_for_statement_repeat1,
  [29630] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 1,
      anon_sym_COMMA,
    ACTIONS(1653), 1,
      anon_sym_RBRACE,
    STATE(636), 1,
      aux_sym_table_type_repeat1,
  [29643] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(1655), 1,
      anon_sym_RPAREN,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
  [29656] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1657), 1,
      anon_sym_COMMA,
    ACTIONS(1660), 1,
      anon_sym_RPAREN,
    STATE(633), 1,
      aux_sym__parnamelist_repeat1,
  [29669] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1662), 1,
      anon_sym_COMMA,
    ACTIONS(1664), 1,
      anon_sym_RPAREN,
    STATE(600), 1,
      aux_sym__partypelist_repeat1,
  [29682] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1666), 1,
      anon_sym_return,
    STATE(291), 1,
      sym_macroexp_body,
    STATE(713), 1,
      sym_return_statement,
  [29695] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1668), 1,
      anon_sym_COMMA,
    ACTIONS(1671), 1,
      anon_sym_RBRACE,
    STATE(636), 1,
      aux_sym_table_type_repeat1,
  [29708] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COMMA,
    ACTIONS(1673), 1,
      anon_sym_GT,
    STATE(558), 1,
      aux_sym_type_tuple_repeat1,
  [29721] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1675), 1,
      anon_sym_COMMA,
    ACTIONS(1677), 1,
      anon_sym_RPAREN,
    STATE(216), 1,
      aux_sym_type_tuple_repeat1,
  [29734] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 1,
      anon_sym_COMMA,
    ACTIONS(1679), 1,
      anon_sym_RBRACE,
    STATE(636), 1,
      aux_sym_table_type_repeat1,
  [29747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1681), 1,
      anon_sym_RPAREN,
  [29757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 1,
      anon_sym_COLON,
    ACTIONS(1683), 1,
      sym_identifier,
  [29767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 1,
      anon_sym_COLON,
    ACTIONS(1685), 1,
      sym_identifier,
  [29777] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1474), 1,
      sym_identifier,
    STATE(652), 1,
      sym__parname,
  [29787] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1687), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29795] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1689), 1,
      anon_sym_RBRACE,
  [29805] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 1,
      anon_sym_COLON,
    ACTIONS(1691), 1,
      sym_identifier,
  [29815] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1693), 1,
      anon_sym_RBRACE,
  [29825] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1695), 2,
      anon_sym_LPAREN,
      anon_sym_LT,
  [29833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1697), 1,
      anon_sym_EQ,
  [29843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1699), 1,
      anon_sym_RPAREN,
  [29853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1701), 1,
      anon_sym_RBRACE,
  [29863] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1703), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [29871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 1,
      anon_sym_COLON,
    ACTIONS(1705), 1,
      sym_identifier,
  [29881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1707), 1,
      anon_sym_RBRACE,
  [29891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1709), 1,
      anon_sym_RBRACE,
  [29901] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1711), 1,
      anon_sym_RPAREN,
  [29911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 1,
      anon_sym_COLON,
    ACTIONS(1713), 1,
      sym_identifier,
  [29921] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1715), 2,
      anon_sym_LPAREN,
      anon_sym_LT,
  [29929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 1,
      anon_sym_LPAREN,
    STATE(420), 1,
      sym_signature_arguments,
  [29939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1717), 1,
      anon_sym_RBRACE,
  [29949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1719), 1,
      sym_identifier,
    STATE(556), 1,
      sym_function_name,
  [29959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1721), 1,
      anon_sym_RPAREN,
  [29969] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1723), 1,
      anon_sym_RBRACE,
  [29979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1725), 1,
      sym_identifier,
    STATE(356), 1,
      sym_var_declarator,
  [29989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_PIPE,
    ACTIONS(1727), 1,
      anon_sym_RBRACE,
  [29999] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1691), 1,
      sym_identifier,
  [30006] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1729), 1,
      anon_sym_RPAREN,
  [30013] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1731), 1,
      anon_sym_RPAREN,
  [30020] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1733), 1,
      sym_identifier,
  [30027] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1735), 1,
      anon_sym_RBRACK,
  [30034] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1737), 1,
      anon_sym_EQ,
  [30041] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1739), 1,
      anon_sym_GT,
  [30048] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1550), 1,
      anon_sym_RBRACE,
  [30055] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1741), 1,
      anon_sym_RPAREN,
  [30062] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1743), 1,
      sym__long_string_end,
  [30069] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1745), 1,
      anon_sym_RPAREN,
  [30076] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1747), 1,
      anon_sym_RPAREN,
  [30083] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      sym__long_string_end,
  [30090] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1683), 1,
      sym_identifier,
  [30097] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1751), 1,
      sym_identifier,
  [30104] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1753), 1,
      sym_identifier,
  [30111] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1755), 1,
      sym_identifier,
  [30118] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1757), 1,
      anon_sym_COLON,
  [30125] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1713), 1,
      sym_identifier,
  [30132] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1759), 1,
      sym_identifier,
  [30139] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1761), 1,
      anon_sym_RPAREN,
  [30146] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1763), 1,
      sym_identifier,
  [30153] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1749), 1,
      sym__short_string_end,
  [30160] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1743), 1,
      sym__short_string_end,
  [30167] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1765), 1,
      anon_sym_EQ,
  [30174] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1767), 1,
      anon_sym_RPAREN,
  [30181] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1769), 1,
      anon_sym_COLON,
  [30188] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1771), 1,
      anon_sym_RPAREN,
  [30195] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1773), 1,
      anon_sym_RPAREN,
  [30202] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1775), 1,
      sym_identifier,
  [30209] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1777), 1,
      sym_identifier,
  [30216] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1779), 1,
      sym_identifier,
  [30223] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1781), 1,
      anon_sym_COLON_COLON,
  [30230] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1783), 1,
      sym_identifier,
  [30237] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1785), 1,
      sym_identifier,
  [30244] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1787), 1,
      anon_sym_RPAREN,
  [30251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1789), 1,
      sym_identifier,
  [30258] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1705), 1,
      sym_identifier,
  [30265] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1791), 1,
      anon_sym_RPAREN,
  [30272] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1793), 1,
      anon_sym_RPAREN,
  [30279] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1795), 1,
      ts_builtin_sym_end,
  [30286] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1797), 1,
      sym_identifier,
  [30293] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1799), 1,
      anon_sym_RPAREN,
  [30300] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1801), 1,
      anon_sym_RPAREN,
  [30307] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1803), 1,
      sym_identifier,
  [30314] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1805), 1,
      anon_sym_COLON,
  [30321] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1523), 1,
      anon_sym_RBRACE,
  [30328] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1807), 1,
      anon_sym_end,
  [30335] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1809), 1,
      sym_identifier,
  [30342] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1811), 1,
      anon_sym_EQ,
  [30349] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1813), 1,
      anon_sym_RPAREN,
  [30356] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1815), 1,
      anon_sym_COLON,
  [30363] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1817), 1,
      sym_identifier,
  [30370] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1819), 1,
      anon_sym_end,
  [30377] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1821), 1,
      anon_sym_RPAREN,
  [30384] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1823), 1,
      anon_sym_RPAREN,
  [30391] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1825), 1,
      anon_sym_RPAREN,
  [30398] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1827), 1,
      sym_identifier,
  [30405] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1829), 1,
      sym_identifier,
  [30412] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1401), 1,
      anon_sym_end,
  [30419] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1422), 1,
      anon_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(3)] = 0,
  [SMALL_STATE(4)] = 70,
  [SMALL_STATE(5)] = 140,
  [SMALL_STATE(6)] = 216,
  [SMALL_STATE(7)] = 286,
  [SMALL_STATE(8)] = 360,
  [SMALL_STATE(9)] = 429,
  [SMALL_STATE(10)] = 498,
  [SMALL_STATE(11)] = 567,
  [SMALL_STATE(12)] = 638,
  [SMALL_STATE(13)] = 707,
  [SMALL_STATE(14)] = 776,
  [SMALL_STATE(15)] = 845,
  [SMALL_STATE(16)] = 914,
  [SMALL_STATE(17)] = 983,
  [SMALL_STATE(18)] = 1052,
  [SMALL_STATE(19)] = 1121,
  [SMALL_STATE(20)] = 1190,
  [SMALL_STATE(21)] = 1259,
  [SMALL_STATE(22)] = 1328,
  [SMALL_STATE(23)] = 1397,
  [SMALL_STATE(24)] = 1466,
  [SMALL_STATE(25)] = 1535,
  [SMALL_STATE(26)] = 1604,
  [SMALL_STATE(27)] = 1680,
  [SMALL_STATE(28)] = 1752,
  [SMALL_STATE(29)] = 1820,
  [SMALL_STATE(30)] = 1888,
  [SMALL_STATE(31)] = 1956,
  [SMALL_STATE(32)] = 2024,
  [SMALL_STATE(33)] = 2092,
  [SMALL_STATE(34)] = 2160,
  [SMALL_STATE(35)] = 2228,
  [SMALL_STATE(36)] = 2296,
  [SMALL_STATE(37)] = 2364,
  [SMALL_STATE(38)] = 2432,
  [SMALL_STATE(39)] = 2500,
  [SMALL_STATE(40)] = 2568,
  [SMALL_STATE(41)] = 2636,
  [SMALL_STATE(42)] = 2704,
  [SMALL_STATE(43)] = 2772,
  [SMALL_STATE(44)] = 2840,
  [SMALL_STATE(45)] = 2908,
  [SMALL_STATE(46)] = 2976,
  [SMALL_STATE(47)] = 3044,
  [SMALL_STATE(48)] = 3112,
  [SMALL_STATE(49)] = 3180,
  [SMALL_STATE(50)] = 3248,
  [SMALL_STATE(51)] = 3316,
  [SMALL_STATE(52)] = 3384,
  [SMALL_STATE(53)] = 3458,
  [SMALL_STATE(54)] = 3525,
  [SMALL_STATE(55)] = 3596,
  [SMALL_STATE(56)] = 3665,
  [SMALL_STATE(57)] = 3736,
  [SMALL_STATE(58)] = 3805,
  [SMALL_STATE(59)] = 3872,
  [SMALL_STATE(60)] = 3941,
  [SMALL_STATE(61)] = 4016,
  [SMALL_STATE(62)] = 4087,
  [SMALL_STATE(63)] = 4154,
  [SMALL_STATE(64)] = 4221,
  [SMALL_STATE(65)] = 4288,
  [SMALL_STATE(66)] = 4363,
  [SMALL_STATE(67)] = 4430,
  [SMALL_STATE(68)] = 4497,
  [SMALL_STATE(69)] = 4564,
  [SMALL_STATE(70)] = 4631,
  [SMALL_STATE(71)] = 4706,
  [SMALL_STATE(72)] = 4774,
  [SMALL_STATE(73)] = 4842,
  [SMALL_STATE(74)] = 4908,
  [SMALL_STATE(75)] = 4978,
  [SMALL_STATE(76)] = 5044,
  [SMALL_STATE(77)] = 5110,
  [SMALL_STATE(78)] = 5180,
  [SMALL_STATE(79)] = 5246,
  [SMALL_STATE(80)] = 5314,
  [SMALL_STATE(81)] = 5384,
  [SMALL_STATE(82)] = 5450,
  [SMALL_STATE(83)] = 5516,
  [SMALL_STATE(84)] = 5582,
  [SMALL_STATE(85)] = 5648,
  [SMALL_STATE(86)] = 5714,
  [SMALL_STATE(87)] = 5780,
  [SMALL_STATE(88)] = 5846,
  [SMALL_STATE(89)] = 5912,
  [SMALL_STATE(90)] = 5978,
  [SMALL_STATE(91)] = 6044,
  [SMALL_STATE(92)] = 6110,
  [SMALL_STATE(93)] = 6176,
  [SMALL_STATE(94)] = 6242,
  [SMALL_STATE(95)] = 6312,
  [SMALL_STATE(96)] = 6378,
  [SMALL_STATE(97)] = 6452,
  [SMALL_STATE(98)] = 6522,
  [SMALL_STATE(99)] = 6587,
  [SMALL_STATE(100)] = 6652,
  [SMALL_STATE(101)] = 6717,
  [SMALL_STATE(102)] = 6782,
  [SMALL_STATE(103)] = 6847,
  [SMALL_STATE(104)] = 6912,
  [SMALL_STATE(105)] = 6977,
  [SMALL_STATE(106)] = 7042,
  [SMALL_STATE(107)] = 7107,
  [SMALL_STATE(108)] = 7172,
  [SMALL_STATE(109)] = 7237,
  [SMALL_STATE(110)] = 7302,
  [SMALL_STATE(111)] = 7367,
  [SMALL_STATE(112)] = 7432,
  [SMALL_STATE(113)] = 7497,
  [SMALL_STATE(114)] = 7566,
  [SMALL_STATE(115)] = 7639,
  [SMALL_STATE(116)] = 7706,
  [SMALL_STATE(117)] = 7772,
  [SMALL_STATE(118)] = 7838,
  [SMALL_STATE(119)] = 7906,
  [SMALL_STATE(120)] = 7973,
  [SMALL_STATE(121)] = 8038,
  [SMALL_STATE(122)] = 8113,
  [SMALL_STATE(123)] = 8190,
  [SMALL_STATE(124)] = 8261,
  [SMALL_STATE(125)] = 8340,
  [SMALL_STATE(126)] = 8431,
  [SMALL_STATE(127)] = 8520,
  [SMALL_STATE(128)] = 8603,
  [SMALL_STATE(129)] = 8684,
  [SMALL_STATE(130)] = 8759,
  [SMALL_STATE(131)] = 8826,
  [SMALL_STATE(132)] = 8893,
  [SMALL_STATE(133)] = 8958,
  [SMALL_STATE(134)] = 9050,
  [SMALL_STATE(135)] = 9112,
  [SMALL_STATE(136)] = 9178,
  [SMALL_STATE(137)] = 9236,
  [SMALL_STATE(138)] = 9294,
  [SMALL_STATE(139)] = 9356,
  [SMALL_STATE(140)] = 9426,
  [SMALL_STATE(141)] = 9508,
  [SMALL_STATE(142)] = 9588,
  [SMALL_STATE(143)] = 9662,
  [SMALL_STATE(144)] = 9734,
  [SMALL_STATE(145)] = 9802,
  [SMALL_STATE(146)] = 9868,
  [SMALL_STATE(147)] = 9924,
  [SMALL_STATE(148)] = 9982,
  [SMALL_STATE(149)] = 10038,
  [SMALL_STATE(150)] = 10144,
  [SMALL_STATE(151)] = 10250,
  [SMALL_STATE(152)] = 10333,
  [SMALL_STATE(153)] = 10420,
  [SMALL_STATE(154)] = 10507,
  [SMALL_STATE(155)] = 10606,
  [SMALL_STATE(156)] = 10701,
  [SMALL_STATE(157)] = 10782,
  [SMALL_STATE(158)] = 10877,
  [SMALL_STATE(159)] = 10958,
  [SMALL_STATE(160)] = 11071,
  [SMALL_STATE(161)] = 11184,
  [SMALL_STATE(162)] = 11280,
  [SMALL_STATE(163)] = 11376,
  [SMALL_STATE(164)] = 11472,
  [SMALL_STATE(165)] = 11565,
  [SMALL_STATE(166)] = 11658,
  [SMALL_STATE(167)] = 11751,
  [SMALL_STATE(168)] = 11804,
  [SMALL_STATE(169)] = 11859,
  [SMALL_STATE(170)] = 11952,
  [SMALL_STATE(171)] = 12045,
  [SMALL_STATE(172)] = 12138,
  [SMALL_STATE(173)] = 12231,
  [SMALL_STATE(174)] = 12324,
  [SMALL_STATE(175)] = 12417,
  [SMALL_STATE(176)] = 12510,
  [SMALL_STATE(177)] = 12566,
  [SMALL_STATE(178)] = 12621,
  [SMALL_STATE(179)] = 12668,
  [SMALL_STATE(180)] = 12715,
  [SMALL_STATE(181)] = 12762,
  [SMALL_STATE(182)] = 12811,
  [SMALL_STATE(183)] = 12857,
  [SMALL_STATE(184)] = 12903,
  [SMALL_STATE(185)] = 12949,
  [SMALL_STATE(186)] = 12995,
  [SMALL_STATE(187)] = 13041,
  [SMALL_STATE(188)] = 13087,
  [SMALL_STATE(189)] = 13133,
  [SMALL_STATE(190)] = 13179,
  [SMALL_STATE(191)] = 13233,
  [SMALL_STATE(192)] = 13283,
  [SMALL_STATE(193)] = 13367,
  [SMALL_STATE(194)] = 13413,
  [SMALL_STATE(195)] = 13497,
  [SMALL_STATE(196)] = 13543,
  [SMALL_STATE(197)] = 13597,
  [SMALL_STATE(198)] = 13643,
  [SMALL_STATE(199)] = 13693,
  [SMALL_STATE(200)] = 13739,
  [SMALL_STATE(201)] = 13785,
  [SMALL_STATE(202)] = 13831,
  [SMALL_STATE(203)] = 13877,
  [SMALL_STATE(204)] = 13923,
  [SMALL_STATE(205)] = 13969,
  [SMALL_STATE(206)] = 14015,
  [SMALL_STATE(207)] = 14061,
  [SMALL_STATE(208)] = 14107,
  [SMALL_STATE(209)] = 14153,
  [SMALL_STATE(210)] = 14199,
  [SMALL_STATE(211)] = 14245,
  [SMALL_STATE(212)] = 14291,
  [SMALL_STATE(213)] = 14341,
  [SMALL_STATE(214)] = 14390,
  [SMALL_STATE(215)] = 14439,
  [SMALL_STATE(216)] = 14486,
  [SMALL_STATE(217)] = 14535,
  [SMALL_STATE(218)] = 14582,
  [SMALL_STATE(219)] = 14631,
  [SMALL_STATE(220)] = 14678,
  [SMALL_STATE(221)] = 14727,
  [SMALL_STATE(222)] = 14807,
  [SMALL_STATE(223)] = 14853,
  [SMALL_STATE(224)] = 14933,
  [SMALL_STATE(225)] = 15013,
  [SMALL_STATE(226)] = 15093,
  [SMALL_STATE(227)] = 15139,
  [SMALL_STATE(228)] = 15185,
  [SMALL_STATE(229)] = 15236,
  [SMALL_STATE(230)] = 15313,
  [SMALL_STATE(231)] = 15364,
  [SMALL_STATE(232)] = 15438,
  [SMALL_STATE(233)] = 15484,
  [SMALL_STATE(234)] = 15558,
  [SMALL_STATE(235)] = 15632,
  [SMALL_STATE(236)] = 15706,
  [SMALL_STATE(237)] = 15780,
  [SMALL_STATE(238)] = 15826,
  [SMALL_STATE(239)] = 15897,
  [SMALL_STATE(240)] = 15968,
  [SMALL_STATE(241)] = 16039,
  [SMALL_STATE(242)] = 16110,
  [SMALL_STATE(243)] = 16181,
  [SMALL_STATE(244)] = 16252,
  [SMALL_STATE(245)] = 16323,
  [SMALL_STATE(246)] = 16394,
  [SMALL_STATE(247)] = 16465,
  [SMALL_STATE(248)] = 16536,
  [SMALL_STATE(249)] = 16579,
  [SMALL_STATE(250)] = 16622,
  [SMALL_STATE(251)] = 16693,
  [SMALL_STATE(252)] = 16764,
  [SMALL_STATE(253)] = 16835,
  [SMALL_STATE(254)] = 16906,
  [SMALL_STATE(255)] = 16977,
  [SMALL_STATE(256)] = 17048,
  [SMALL_STATE(257)] = 17119,
  [SMALL_STATE(258)] = 17164,
  [SMALL_STATE(259)] = 17235,
  [SMALL_STATE(260)] = 17306,
  [SMALL_STATE(261)] = 17377,
  [SMALL_STATE(262)] = 17448,
  [SMALL_STATE(263)] = 17519,
  [SMALL_STATE(264)] = 17590,
  [SMALL_STATE(265)] = 17661,
  [SMALL_STATE(266)] = 17732,
  [SMALL_STATE(267)] = 17803,
  [SMALL_STATE(268)] = 17874,
  [SMALL_STATE(269)] = 17945,
  [SMALL_STATE(270)] = 18016,
  [SMALL_STATE(271)] = 18087,
  [SMALL_STATE(272)] = 18158,
  [SMALL_STATE(273)] = 18229,
  [SMALL_STATE(274)] = 18300,
  [SMALL_STATE(275)] = 18371,
  [SMALL_STATE(276)] = 18442,
  [SMALL_STATE(277)] = 18513,
  [SMALL_STATE(278)] = 18584,
  [SMALL_STATE(279)] = 18655,
  [SMALL_STATE(280)] = 18726,
  [SMALL_STATE(281)] = 18797,
  [SMALL_STATE(282)] = 18868,
  [SMALL_STATE(283)] = 18939,
  [SMALL_STATE(284)] = 19010,
  [SMALL_STATE(285)] = 19081,
  [SMALL_STATE(286)] = 19152,
  [SMALL_STATE(287)] = 19194,
  [SMALL_STATE(288)] = 19233,
  [SMALL_STATE(289)] = 19269,
  [SMALL_STATE(290)] = 19305,
  [SMALL_STATE(291)] = 19341,
  [SMALL_STATE(292)] = 19377,
  [SMALL_STATE(293)] = 19413,
  [SMALL_STATE(294)] = 19449,
  [SMALL_STATE(295)] = 19485,
  [SMALL_STATE(296)] = 19521,
  [SMALL_STATE(297)] = 19557,
  [SMALL_STATE(298)] = 19593,
  [SMALL_STATE(299)] = 19629,
  [SMALL_STATE(300)] = 19665,
  [SMALL_STATE(301)] = 19701,
  [SMALL_STATE(302)] = 19737,
  [SMALL_STATE(303)] = 19773,
  [SMALL_STATE(304)] = 19809,
  [SMALL_STATE(305)] = 19845,
  [SMALL_STATE(306)] = 19881,
  [SMALL_STATE(307)] = 19917,
  [SMALL_STATE(308)] = 19953,
  [SMALL_STATE(309)] = 19989,
  [SMALL_STATE(310)] = 20025,
  [SMALL_STATE(311)] = 20061,
  [SMALL_STATE(312)] = 20097,
  [SMALL_STATE(313)] = 20133,
  [SMALL_STATE(314)] = 20169,
  [SMALL_STATE(315)] = 20205,
  [SMALL_STATE(316)] = 20241,
  [SMALL_STATE(317)] = 20277,
  [SMALL_STATE(318)] = 20313,
  [SMALL_STATE(319)] = 20349,
  [SMALL_STATE(320)] = 20385,
  [SMALL_STATE(321)] = 20421,
  [SMALL_STATE(322)] = 20457,
  [SMALL_STATE(323)] = 20493,
  [SMALL_STATE(324)] = 20562,
  [SMALL_STATE(325)] = 20631,
  [SMALL_STATE(326)] = 20697,
  [SMALL_STATE(327)] = 20759,
  [SMALL_STATE(328)] = 20825,
  [SMALL_STATE(329)] = 20887,
  [SMALL_STATE(330)] = 20953,
  [SMALL_STATE(331)] = 20993,
  [SMALL_STATE(332)] = 21055,
  [SMALL_STATE(333)] = 21117,
  [SMALL_STATE(334)] = 21183,
  [SMALL_STATE(335)] = 21246,
  [SMALL_STATE(336)] = 21309,
  [SMALL_STATE(337)] = 21381,
  [SMALL_STATE(338)] = 21441,
  [SMALL_STATE(339)] = 21513,
  [SMALL_STATE(340)] = 21549,
  [SMALL_STATE(341)] = 21621,
  [SMALL_STATE(342)] = 21681,
  [SMALL_STATE(343)] = 21741,
  [SMALL_STATE(344)] = 21801,
  [SMALL_STATE(345)] = 21861,
  [SMALL_STATE(346)] = 21897,
  [SMALL_STATE(347)] = 21969,
  [SMALL_STATE(348)] = 22003,
  [SMALL_STATE(349)] = 22075,
  [SMALL_STATE(350)] = 22113,
  [SMALL_STATE(351)] = 22149,
  [SMALL_STATE(352)] = 22209,
  [SMALL_STATE(353)] = 22246,
  [SMALL_STATE(354)] = 22315,
  [SMALL_STATE(355)] = 22350,
  [SMALL_STATE(356)] = 22381,
  [SMALL_STATE(357)] = 22412,
  [SMALL_STATE(358)] = 22447,
  [SMALL_STATE(359)] = 22513,
  [SMALL_STATE(360)] = 22579,
  [SMALL_STATE(361)] = 22613,
  [SMALL_STATE(362)] = 22679,
  [SMALL_STATE(363)] = 22713,
  [SMALL_STATE(364)] = 22779,
  [SMALL_STATE(365)] = 22810,
  [SMALL_STATE(366)] = 22838,
  [SMALL_STATE(367)] = 22866,
  [SMALL_STATE(368)] = 22894,
  [SMALL_STATE(369)] = 22922,
  [SMALL_STATE(370)] = 22950,
  [SMALL_STATE(371)] = 22978,
  [SMALL_STATE(372)] = 23006,
  [SMALL_STATE(373)] = 23034,
  [SMALL_STATE(374)] = 23064,
  [SMALL_STATE(375)] = 23092,
  [SMALL_STATE(376)] = 23120,
  [SMALL_STATE(377)] = 23148,
  [SMALL_STATE(378)] = 23176,
  [SMALL_STATE(379)] = 23204,
  [SMALL_STATE(380)] = 23234,
  [SMALL_STATE(381)] = 23262,
  [SMALL_STATE(382)] = 23290,
  [SMALL_STATE(383)] = 23318,
  [SMALL_STATE(384)] = 23346,
  [SMALL_STATE(385)] = 23374,
  [SMALL_STATE(386)] = 23402,
  [SMALL_STATE(387)] = 23430,
  [SMALL_STATE(388)] = 23458,
  [SMALL_STATE(389)] = 23486,
  [SMALL_STATE(390)] = 23514,
  [SMALL_STATE(391)] = 23542,
  [SMALL_STATE(392)] = 23570,
  [SMALL_STATE(393)] = 23600,
  [SMALL_STATE(394)] = 23628,
  [SMALL_STATE(395)] = 23656,
  [SMALL_STATE(396)] = 23684,
  [SMALL_STATE(397)] = 23712,
  [SMALL_STATE(398)] = 23769,
  [SMALL_STATE(399)] = 23826,
  [SMALL_STATE(400)] = 23883,
  [SMALL_STATE(401)] = 23940,
  [SMALL_STATE(402)] = 23967,
  [SMALL_STATE(403)] = 24024,
  [SMALL_STATE(404)] = 24081,
  [SMALL_STATE(405)] = 24138,
  [SMALL_STATE(406)] = 24195,
  [SMALL_STATE(407)] = 24252,
  [SMALL_STATE(408)] = 24309,
  [SMALL_STATE(409)] = 24366,
  [SMALL_STATE(410)] = 24423,
  [SMALL_STATE(411)] = 24480,
  [SMALL_STATE(412)] = 24537,
  [SMALL_STATE(413)] = 24564,
  [SMALL_STATE(414)] = 24621,
  [SMALL_STATE(415)] = 24678,
  [SMALL_STATE(416)] = 24721,
  [SMALL_STATE(417)] = 24745,
  [SMALL_STATE(418)] = 24769,
  [SMALL_STATE(419)] = 24793,
  [SMALL_STATE(420)] = 24817,
  [SMALL_STATE(421)] = 24843,
  [SMALL_STATE(422)] = 24869,
  [SMALL_STATE(423)] = 24893,
  [SMALL_STATE(424)] = 24917,
  [SMALL_STATE(425)] = 24940,
  [SMALL_STATE(426)] = 24963,
  [SMALL_STATE(427)] = 25003,
  [SMALL_STATE(428)] = 25043,
  [SMALL_STATE(429)] = 25083,
  [SMALL_STATE(430)] = 25129,
  [SMALL_STATE(431)] = 25166,
  [SMALL_STATE(432)] = 25203,
  [SMALL_STATE(433)] = 25240,
  [SMALL_STATE(434)] = 25277,
  [SMALL_STATE(435)] = 25314,
  [SMALL_STATE(436)] = 25351,
  [SMALL_STATE(437)] = 25385,
  [SMALL_STATE(438)] = 25419,
  [SMALL_STATE(439)] = 25453,
  [SMALL_STATE(440)] = 25487,
  [SMALL_STATE(441)] = 25521,
  [SMALL_STATE(442)] = 25555,
  [SMALL_STATE(443)] = 25589,
  [SMALL_STATE(444)] = 25623,
  [SMALL_STATE(445)] = 25657,
  [SMALL_STATE(446)] = 25691,
  [SMALL_STATE(447)] = 25725,
  [SMALL_STATE(448)] = 25759,
  [SMALL_STATE(449)] = 25793,
  [SMALL_STATE(450)] = 25827,
  [SMALL_STATE(451)] = 25861,
  [SMALL_STATE(452)] = 25895,
  [SMALL_STATE(453)] = 25935,
  [SMALL_STATE(454)] = 25966,
  [SMALL_STATE(455)] = 25997,
  [SMALL_STATE(456)] = 26028,
  [SMALL_STATE(457)] = 26049,
  [SMALL_STATE(458)] = 26080,
  [SMALL_STATE(459)] = 26111,
  [SMALL_STATE(460)] = 26142,
  [SMALL_STATE(461)] = 26173,
  [SMALL_STATE(462)] = 26194,
  [SMALL_STATE(463)] = 26225,
  [SMALL_STATE(464)] = 26256,
  [SMALL_STATE(465)] = 26287,
  [SMALL_STATE(466)] = 26308,
  [SMALL_STATE(467)] = 26339,
  [SMALL_STATE(468)] = 26360,
  [SMALL_STATE(469)] = 26391,
  [SMALL_STATE(470)] = 26422,
  [SMALL_STATE(471)] = 26453,
  [SMALL_STATE(472)] = 26484,
  [SMALL_STATE(473)] = 26515,
  [SMALL_STATE(474)] = 26546,
  [SMALL_STATE(475)] = 26577,
  [SMALL_STATE(476)] = 26598,
  [SMALL_STATE(477)] = 26629,
  [SMALL_STATE(478)] = 26657,
  [SMALL_STATE(479)] = 26685,
  [SMALL_STATE(480)] = 26713,
  [SMALL_STATE(481)] = 26741,
  [SMALL_STATE(482)] = 26769,
  [SMALL_STATE(483)] = 26797,
  [SMALL_STATE(484)] = 26825,
  [SMALL_STATE(485)] = 26853,
  [SMALL_STATE(486)] = 26881,
  [SMALL_STATE(487)] = 26909,
  [SMALL_STATE(488)] = 26937,
  [SMALL_STATE(489)] = 26955,
  [SMALL_STATE(490)] = 26973,
  [SMALL_STATE(491)] = 27001,
  [SMALL_STATE(492)] = 27029,
  [SMALL_STATE(493)] = 27047,
  [SMALL_STATE(494)] = 27075,
  [SMALL_STATE(495)] = 27103,
  [SMALL_STATE(496)] = 27131,
  [SMALL_STATE(497)] = 27159,
  [SMALL_STATE(498)] = 27187,
  [SMALL_STATE(499)] = 27205,
  [SMALL_STATE(500)] = 27233,
  [SMALL_STATE(501)] = 27251,
  [SMALL_STATE(502)] = 27279,
  [SMALL_STATE(503)] = 27307,
  [SMALL_STATE(504)] = 27335,
  [SMALL_STATE(505)] = 27363,
  [SMALL_STATE(506)] = 27391,
  [SMALL_STATE(507)] = 27419,
  [SMALL_STATE(508)] = 27447,
  [SMALL_STATE(509)] = 27465,
  [SMALL_STATE(510)] = 27493,
  [SMALL_STATE(511)] = 27521,
  [SMALL_STATE(512)] = 27549,
  [SMALL_STATE(513)] = 27577,
  [SMALL_STATE(514)] = 27605,
  [SMALL_STATE(515)] = 27633,
  [SMALL_STATE(516)] = 27661,
  [SMALL_STATE(517)] = 27689,
  [SMALL_STATE(518)] = 27717,
  [SMALL_STATE(519)] = 27745,
  [SMALL_STATE(520)] = 27773,
  [SMALL_STATE(521)] = 27801,
  [SMALL_STATE(522)] = 27829,
  [SMALL_STATE(523)] = 27857,
  [SMALL_STATE(524)] = 27885,
  [SMALL_STATE(525)] = 27913,
  [SMALL_STATE(526)] = 27941,
  [SMALL_STATE(527)] = 27963,
  [SMALL_STATE(528)] = 27991,
  [SMALL_STATE(529)] = 28023,
  [SMALL_STATE(530)] = 28051,
  [SMALL_STATE(531)] = 28079,
  [SMALL_STATE(532)] = 28107,
  [SMALL_STATE(533)] = 28135,
  [SMALL_STATE(534)] = 28152,
  [SMALL_STATE(535)] = 28174,
  [SMALL_STATE(536)] = 28198,
  [SMALL_STATE(537)] = 28219,
  [SMALL_STATE(538)] = 28242,
  [SMALL_STATE(539)] = 28265,
  [SMALL_STATE(540)] = 28288,
  [SMALL_STATE(541)] = 28308,
  [SMALL_STATE(542)] = 28324,
  [SMALL_STATE(543)] = 28344,
  [SMALL_STATE(544)] = 28364,
  [SMALL_STATE(545)] = 28384,
  [SMALL_STATE(546)] = 28404,
  [SMALL_STATE(547)] = 28424,
  [SMALL_STATE(548)] = 28444,
  [SMALL_STATE(549)] = 28464,
  [SMALL_STATE(550)] = 28479,
  [SMALL_STATE(551)] = 28496,
  [SMALL_STATE(552)] = 28515,
  [SMALL_STATE(553)] = 28532,
  [SMALL_STATE(554)] = 28551,
  [SMALL_STATE(555)] = 28568,
  [SMALL_STATE(556)] = 28585,
  [SMALL_STATE(557)] = 28604,
  [SMALL_STATE(558)] = 28623,
  [SMALL_STATE(559)] = 28638,
  [SMALL_STATE(560)] = 28651,
  [SMALL_STATE(561)] = 28664,
  [SMALL_STATE(562)] = 28681,
  [SMALL_STATE(563)] = 28700,
  [SMALL_STATE(564)] = 28713,
  [SMALL_STATE(565)] = 28726,
  [SMALL_STATE(566)] = 28745,
  [SMALL_STATE(567)] = 28764,
  [SMALL_STATE(568)] = 28781,
  [SMALL_STATE(569)] = 28800,
  [SMALL_STATE(570)] = 28819,
  [SMALL_STATE(571)] = 28834,
  [SMALL_STATE(572)] = 28850,
  [SMALL_STATE(573)] = 28866,
  [SMALL_STATE(574)] = 28878,
  [SMALL_STATE(575)] = 28894,
  [SMALL_STATE(576)] = 28904,
  [SMALL_STATE(577)] = 28920,
  [SMALL_STATE(578)] = 28932,
  [SMALL_STATE(579)] = 28946,
  [SMALL_STATE(580)] = 28962,
  [SMALL_STATE(581)] = 28978,
  [SMALL_STATE(582)] = 28992,
  [SMALL_STATE(583)] = 29008,
  [SMALL_STATE(584)] = 29022,
  [SMALL_STATE(585)] = 29036,
  [SMALL_STATE(586)] = 29046,
  [SMALL_STATE(587)] = 29060,
  [SMALL_STATE(588)] = 29076,
  [SMALL_STATE(589)] = 29092,
  [SMALL_STATE(590)] = 29106,
  [SMALL_STATE(591)] = 29116,
  [SMALL_STATE(592)] = 29130,
  [SMALL_STATE(593)] = 29144,
  [SMALL_STATE(594)] = 29160,
  [SMALL_STATE(595)] = 29176,
  [SMALL_STATE(596)] = 29192,
  [SMALL_STATE(597)] = 29208,
  [SMALL_STATE(598)] = 29221,
  [SMALL_STATE(599)] = 29234,
  [SMALL_STATE(600)] = 29247,
  [SMALL_STATE(601)] = 29260,
  [SMALL_STATE(602)] = 29273,
  [SMALL_STATE(603)] = 29286,
  [SMALL_STATE(604)] = 29299,
  [SMALL_STATE(605)] = 29312,
  [SMALL_STATE(606)] = 29325,
  [SMALL_STATE(607)] = 29338,
  [SMALL_STATE(608)] = 29351,
  [SMALL_STATE(609)] = 29364,
  [SMALL_STATE(610)] = 29377,
  [SMALL_STATE(611)] = 29388,
  [SMALL_STATE(612)] = 29401,
  [SMALL_STATE(613)] = 29410,
  [SMALL_STATE(614)] = 29423,
  [SMALL_STATE(615)] = 29436,
  [SMALL_STATE(616)] = 29449,
  [SMALL_STATE(617)] = 29462,
  [SMALL_STATE(618)] = 29475,
  [SMALL_STATE(619)] = 29488,
  [SMALL_STATE(620)] = 29499,
  [SMALL_STATE(621)] = 29510,
  [SMALL_STATE(622)] = 29521,
  [SMALL_STATE(623)] = 29534,
  [SMALL_STATE(624)] = 29547,
  [SMALL_STATE(625)] = 29560,
  [SMALL_STATE(626)] = 29569,
  [SMALL_STATE(627)] = 29580,
  [SMALL_STATE(628)] = 29591,
  [SMALL_STATE(629)] = 29604,
  [SMALL_STATE(630)] = 29617,
  [SMALL_STATE(631)] = 29630,
  [SMALL_STATE(632)] = 29643,
  [SMALL_STATE(633)] = 29656,
  [SMALL_STATE(634)] = 29669,
  [SMALL_STATE(635)] = 29682,
  [SMALL_STATE(636)] = 29695,
  [SMALL_STATE(637)] = 29708,
  [SMALL_STATE(638)] = 29721,
  [SMALL_STATE(639)] = 29734,
  [SMALL_STATE(640)] = 29747,
  [SMALL_STATE(641)] = 29757,
  [SMALL_STATE(642)] = 29767,
  [SMALL_STATE(643)] = 29777,
  [SMALL_STATE(644)] = 29787,
  [SMALL_STATE(645)] = 29795,
  [SMALL_STATE(646)] = 29805,
  [SMALL_STATE(647)] = 29815,
  [SMALL_STATE(648)] = 29825,
  [SMALL_STATE(649)] = 29833,
  [SMALL_STATE(650)] = 29843,
  [SMALL_STATE(651)] = 29853,
  [SMALL_STATE(652)] = 29863,
  [SMALL_STATE(653)] = 29871,
  [SMALL_STATE(654)] = 29881,
  [SMALL_STATE(655)] = 29891,
  [SMALL_STATE(656)] = 29901,
  [SMALL_STATE(657)] = 29911,
  [SMALL_STATE(658)] = 29921,
  [SMALL_STATE(659)] = 29929,
  [SMALL_STATE(660)] = 29939,
  [SMALL_STATE(661)] = 29949,
  [SMALL_STATE(662)] = 29959,
  [SMALL_STATE(663)] = 29969,
  [SMALL_STATE(664)] = 29979,
  [SMALL_STATE(665)] = 29989,
  [SMALL_STATE(666)] = 29999,
  [SMALL_STATE(667)] = 30006,
  [SMALL_STATE(668)] = 30013,
  [SMALL_STATE(669)] = 30020,
  [SMALL_STATE(670)] = 30027,
  [SMALL_STATE(671)] = 30034,
  [SMALL_STATE(672)] = 30041,
  [SMALL_STATE(673)] = 30048,
  [SMALL_STATE(674)] = 30055,
  [SMALL_STATE(675)] = 30062,
  [SMALL_STATE(676)] = 30069,
  [SMALL_STATE(677)] = 30076,
  [SMALL_STATE(678)] = 30083,
  [SMALL_STATE(679)] = 30090,
  [SMALL_STATE(680)] = 30097,
  [SMALL_STATE(681)] = 30104,
  [SMALL_STATE(682)] = 30111,
  [SMALL_STATE(683)] = 30118,
  [SMALL_STATE(684)] = 30125,
  [SMALL_STATE(685)] = 30132,
  [SMALL_STATE(686)] = 30139,
  [SMALL_STATE(687)] = 30146,
  [SMALL_STATE(688)] = 30153,
  [SMALL_STATE(689)] = 30160,
  [SMALL_STATE(690)] = 30167,
  [SMALL_STATE(691)] = 30174,
  [SMALL_STATE(692)] = 30181,
  [SMALL_STATE(693)] = 30188,
  [SMALL_STATE(694)] = 30195,
  [SMALL_STATE(695)] = 30202,
  [SMALL_STATE(696)] = 30209,
  [SMALL_STATE(697)] = 30216,
  [SMALL_STATE(698)] = 30223,
  [SMALL_STATE(699)] = 30230,
  [SMALL_STATE(700)] = 30237,
  [SMALL_STATE(701)] = 30244,
  [SMALL_STATE(702)] = 30251,
  [SMALL_STATE(703)] = 30258,
  [SMALL_STATE(704)] = 30265,
  [SMALL_STATE(705)] = 30272,
  [SMALL_STATE(706)] = 30279,
  [SMALL_STATE(707)] = 30286,
  [SMALL_STATE(708)] = 30293,
  [SMALL_STATE(709)] = 30300,
  [SMALL_STATE(710)] = 30307,
  [SMALL_STATE(711)] = 30314,
  [SMALL_STATE(712)] = 30321,
  [SMALL_STATE(713)] = 30328,
  [SMALL_STATE(714)] = 30335,
  [SMALL_STATE(715)] = 30342,
  [SMALL_STATE(716)] = 30349,
  [SMALL_STATE(717)] = 30356,
  [SMALL_STATE(718)] = 30363,
  [SMALL_STATE(719)] = 30370,
  [SMALL_STATE(720)] = 30377,
  [SMALL_STATE(721)] = 30384,
  [SMALL_STATE(722)] = 30391,
  [SMALL_STATE(723)] = 30398,
  [SMALL_STATE(724)] = 30405,
  [SMALL_STATE(725)] = 30412,
  [SMALL_STATE(726)] = 30419,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(685),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(452),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(661),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(669),
  [37] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [39] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(697),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(702),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__var, 1, 0, 0),
  [57] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__var, 1, 0, 0),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 3, 0, 22),
  [61] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index, 3, 0, 22),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_type, 1, 0, 2),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_simple_type, 1, 0, 2),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(529),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(718),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index, 4, 0, 45),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index, 4, 0, 45),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_index, 3, 0, 0),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_index, 3, 0, 0),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [81] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, 0, 9),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, 0, 9),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type, 1, 0, 0),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type, 1, 0, 0),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3, 0, 0),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3, 0, 0),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1, 0, 0),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 1, 0, 0),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4, 0, 0),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4, 0, 0),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2, 0, 0),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2, 0, 0),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type, 3, 0, 0),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type, 3, 0, 0),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typearg_params, 3, 0, 0),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_typearg_params, 3, 0, 0),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_index, 4, 0, 0),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_index, 4, 0, 0),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typearg_params, 4, 0, 0),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_typearg_params, 4, 0, 0),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 11),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 11),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 2, 0, 0),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 2, 0, 0),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 24),
  [133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 24),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 3, 0, 0),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 3, 0, 0),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 4, 0, 0),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 4, 0, 0),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 5, 0, 0),
  [145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 5, 0, 0),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 1, 0, 0),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 1, 0, 0),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(696),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(505),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_union, 3, 0, 0),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_union, 3, 0, 0),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typeargs, 3, 0, 0),
  [163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_typeargs, 3, 0, 0),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 1, 0, 0),
  [167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 1, 0, 0),
  [169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 3, 1, 0),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 3, 1, 0),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_type, 4, 0, 82),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_type, 4, 0, 82),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_args, 3, 0, 84),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_args, 3, 0, 84),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_args, 3, 0, 49),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_args, 3, 0, 49),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 4, 0, 85),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 4, 0, 85),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 4, 10, 0),
  [191] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 4, 10, 0),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 4, 1, 0),
  [195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 4, 1, 0),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_type, 5, 0, 95),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_type, 5, 0, 95),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_args, 4, 0, 84),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_args, 4, 0, 84),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 5, 0, 96),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 5, 0, 96),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_type, 2, 0, 2),
  [211] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_simple_type, 2, 0, 2),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 5, 10, 0),
  [215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 5, 10, 0),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_args, 5, 0, 101),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_args, 5, 0, 101),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 6, 10, 0),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 6, 10, 0),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_args, 6, 0, 106),
  [227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_args, 6, 0, 106),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typeargs, 4, 0, 0),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_typeargs, 4, 0, 0),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variadic_type, 2, 0, 0),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variadic_type, 2, 0, 0),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_type, 3, 0, 67),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_type, 3, 0, 67),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_args, 2, 0, 0),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_args, 2, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(681),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 2, 1, 0),
  [249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 2, 1, 0),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 2, 1, 0), SHIFT(464),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 2, 0, 51),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 2, 0, 51),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 2, 0, 52),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 2, 0, 52),
  [262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(447),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 3, 0, 69),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 3, 0, 69),
  [268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(446),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 1, 1, 0),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_type, 1, 1, 0),
  [274] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 1, 1, 0), SHIFT(458),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_tuple_repeat1, 2, 0, 0),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_type_tuple_repeat1, 2, 0, 0),
  [285] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_tuple_repeat1, 2, 0, 0), SHIFT_REPEAT(477),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [290] = {.entry = {.count = 1, .reusable = false}}, SHIFT(695),
  [292] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 1, 1, 0), SHIFT(463),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(436),
  [299] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_tuple_repeat1, 2, 0, 0), SHIFT_REPEAT(513),
  [302] = {.entry = {.count = 1, .reusable = false}}, SHIFT(439),
  [304] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 2, 1, 0), SHIFT(459),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_body, 2, 0, 0),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_body, 2, 0, 0),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_tuple, 3, 0, 0),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_tuple, 3, 0, 0),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_tuple, 4, 0, 0),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_tuple, 4, 0, 0),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_body, 1, 0, 0),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_body, 1, 0, 0),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_function, 3, 0, 26),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_function, 3, 0, 26),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_varargs, 1, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_varargs, 1, 0, 0),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_cast, 3, 0, 0),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_cast, 3, 0, 0),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(437),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_op, 2, 0, 13),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_op, 2, 0, 13),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [359] = {.entry = {.count = 1, .reusable = false}}, SHIFT(453),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bin_op, 3, 0, 27),
  [365] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bin_op, 3, 0, 27),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [371] = {.entry = {.count = 1, .reusable = false}}, SHIFT(281),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [379] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [383] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(518),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1, 0, 0),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 1, 0, 0),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(569),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 4, 0, 0),
  [423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 4, 0, 0),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [429] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [435] = {.entry = {.count = 1, .reusable = false}}, SHIFT(474),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT(532),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_return_statement_repeat1, 2, 0, 0),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_return_statement_repeat1, 2, 0, 0),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expressions, 1, 0, 0),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expressions, 1, 0, 0),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2, 0, 0),
  [475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2, 0, 0),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0),
  [479] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(3),
  [482] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(680),
  [485] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(133),
  [488] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(264),
  [491] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(392),
  [494] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(265),
  [497] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0),
  [499] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(685),
  [502] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(278),
  [505] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(166),
  [508] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(169),
  [511] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(429),
  [514] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(452),
  [517] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(661),
  [520] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(669),
  [523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_block, 3, 0, 28),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 4, 0, 29),
  [527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 4, 0, 29),
  [529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [531] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_block, 4, 0, 28),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 3, 0, 17),
  [535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 3, 0, 17),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(692),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(641),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [547] = {.entry = {.count = 1, .reusable = false}}, SHIFT(682),
  [549] = {.entry = {.count = 1, .reusable = false}}, SHIFT(646),
  [551] = {.entry = {.count = 1, .reusable = false}}, SHIFT(653),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(657),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(456),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(642),
  [559] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [563] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 2, 0, 0),
  [567] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(710),
  [575] = {.entry = {.count = 1, .reusable = false}}, SHIFT(383),
  [577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1, 0, 0),
  [579] = {.entry = {.count = 1, .reusable = false}}, SHIFT(256),
  [581] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [583] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_block, 1, 0, 0),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_block, 2, 0, 0),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(687),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(695),
  [593] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 1, 1, 0), SHIFT(460),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [600] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 2, 1, 0), SHIFT(462),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(712),
  [607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [611] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [617] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 1, 1, 0), SHIFT(468),
  [620] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_tuple_repeat1, 2, 0, 0), SHIFT_REPEAT(525),
  [623] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 2, 1, 0), SHIFT(455),
  [626] = {.entry = {.count = 1, .reusable = false}}, SHIFT(444),
  [628] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_tuple_repeat1, 2, 0, 0), SHIFT_REPEAT(509),
  [631] = {.entry = {.count = 1, .reusable = false}}, SHIFT(445),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [635] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [643] = {.entry = {.count = 1, .reusable = false}}, SHIFT(441),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [649] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [651] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [653] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__var, 1, 0, 0), SHIFT(491),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [660] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [664] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [670] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [678] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [680] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [682] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [684] = {.entry = {.count = 1, .reusable = false}}, SHIFT(331),
  [686] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(442),
  [690] = {.entry = {.count = 1, .reusable = false}}, SHIFT(443),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [696] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [698] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [702] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [704] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [706] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [708] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [710] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [712] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [714] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [716] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [718] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [720] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [722] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [724] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [726] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [728] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [730] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [732] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [734] = {.entry = {.count = 1, .reusable = false}}, SHIFT(140),
  [736] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [738] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [740] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [742] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [744] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [746] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [748] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [750] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [752] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [754] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [756] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [758] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [760] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_def, 4, 0, 54),
  [764] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type_def, 4, 0, 54),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_record, 2, 0, 72),
  [770] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_record, 2, 0, 72),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enum_def, 3, 0, 39),
  [774] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__enum_def, 3, 0, 39),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__macroexp_def, 4, 0, 56),
  [778] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__macroexp_def, 4, 0, 56),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_def, 4, 0, 57),
  [782] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__record_def, 4, 0, 57),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 2, 0, 58),
  [786] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 2, 0, 58),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__interface_def, 4, 0, 60),
  [790] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__interface_def, 4, 0, 60),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2, 0, 0),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_body, 2, 0, 0),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_interface, 2, 0, 73),
  [798] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_interface, 2, 0, 73),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__anon_enum, 2, 0, 0),
  [802] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__anon_enum, 2, 0, 0),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macroexp_body, 2, 0, 0),
  [806] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macroexp_body, 2, 0, 0),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 3, 0, 74),
  [810] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 3, 0, 74),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_record, 3, 0, 88),
  [814] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_record, 3, 0, 88),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_interface, 3, 0, 89),
  [818] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_interface, 3, 0, 89),
  [820] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 4, 0, 90),
  [822] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 4, 0, 90),
  [824] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 4, 0, 92),
  [826] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 4, 0, 92),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 5, 0, 97),
  [830] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 5, 0, 97),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 5, 0, 98),
  [834] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 5, 0, 98),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 5, 0, 100),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 5, 0, 100),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 6, 0, 103),
  [842] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 6, 0, 103),
  [844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 6, 0, 104),
  [846] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 6, 0, 104),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 6, 0, 105),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 6, 0, 105),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 7, 0, 107),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 7, 0, 107),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 7, 0, 108),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 7, 0, 108),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 7, 0, 109),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 7, 0, 109),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 8, 0, 110),
  [866] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 8, 0, 110),
  [868] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 8, 0, 111),
  [870] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 8, 0, 111),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 9, 0, 112),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 9, 0, 112),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 9, 0, 113),
  [878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 9, 0, 113),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 10, 0, 114),
  [882] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 10, 0, 114),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 1, 0, 0),
  [886] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 1, 0, 0),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_def, 3, 0, 34),
  [890] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__record_def, 3, 0, 34),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__interface_def, 3, 0, 38),
  [894] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__interface_def, 3, 0, 38),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 1, 0, 0),
  [898] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_body, 1, 0, 0),
  [900] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 4, 0, 91),
  [902] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 4, 0, 91),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [908] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_entry, 5, 0, 77),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_entry, 3, 0, 46),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1, 0, 0),
  [926] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1, 0, 0),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_expression, 1, 0, 0),
  [932] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__prefix_expression, 1, 0, 0),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_entry, 5, 0, 78),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_entry, 1, 0, 14),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [948] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [950] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [958] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [962] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declarators, 1, 0, 0),
  [966] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declarators, 1, 0, 0),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(671),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_var_declarators_repeat1, 2, 0, 0),
  [980] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_var_declarators_repeat1, 2, 0, 0),
  [982] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_var_declarators_repeat1, 2, 0, 0), SHIFT_REPEAT(664),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declarator, 1, 0, 2),
  [987] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declarator, 1, 0, 2),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(714),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_annotation, 2, 0, 0),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_annotation, 2, 0, 0),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declarators, 2, 0, 0),
  [997] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declarators, 2, 0, 0),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declaration, 2, 0, 3),
  [1003] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declaration, 2, 0, 3),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1007] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [1009] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1013] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [1015] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_return_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(261),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declarator, 4, 0, 61),
  [1020] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declarator, 4, 0, 61),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_annotation, 3, 0, 0),
  [1024] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_annotation, 3, 0, 0),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3, 0, 0),
  [1028] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3, 0, 0),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expressions, 2, 0, 0),
  [1032] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expressions, 2, 0, 0),
  [1034] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declaration, 3, 0, 18),
  [1036] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declaration, 3, 0, 18),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_declaration, 2, 0, 7),
  [1042] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_declaration, 2, 0, 7),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_for_statement, 5, 0, 53),
  [1046] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_generic_for_statement, 5, 0, 53),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_assignment, 3, 0, 20),
  [1050] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_assignment, 3, 0, 20),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_statement, 5, 0, 55),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_statement, 5, 0, 55),
  [1056] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 2, 0, 4),
  [1058] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_declaration, 2, 0, 4),
  [1060] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 3, 0, 0),
  [1062] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 3, 0, 0),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_declaration, 2, 0, 6),
  [1066] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_declaration, 2, 0, 6),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_declaration, 2, 0, 8),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_declaration, 2, 0, 8),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_goto, 2, 0, 0),
  [1074] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_goto, 2, 0, 0),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 3, 0, 10),
  [1078] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 3, 0, 10),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1082] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 3, 0, 16),
  [1084] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 3, 0, 16),
  [1086] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declaration, 5, 0, 62),
  [1088] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declaration, 5, 0, 62),
  [1090] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, 0, 28),
  [1092] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, 0, 28),
  [1094] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 2, 0, 0),
  [1096] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 2, 0, 0),
  [1098] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_for_statement, 6, 0, 70),
  [1100] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_generic_for_statement, 6, 0, 70),
  [1102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macroexp_statement, 2, 0, 5),
  [1104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macroexp_statement, 2, 0, 5),
  [1106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_numeric_for_statement, 9, 0, 102),
  [1108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_numeric_for_statement, 9, 0, 102),
  [1110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_for_statement, 6, 0, 71),
  [1112] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_generic_for_statement, 6, 0, 71),
  [1114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, 0, 28),
  [1116] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, 0, 28),
  [1118] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, 0, 28),
  [1120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, 0, 28),
  [1122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_declaration, 4, 0, 40),
  [1124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_declaration, 4, 0, 40),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_statement, 4, 0, 44),
  [1128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_statement, 4, 0, 44),
  [1130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_numeric_for_statement, 7, 0, 86),
  [1132] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_numeric_for_statement, 7, 0, 86),
  [1134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 5, 0, 0),
  [1136] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 5, 0, 0),
  [1138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_for_statement, 7, 0, 87),
  [1140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_generic_for_statement, 7, 0, 87),
  [1142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, 0, 28),
  [1144] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, 0, 28),
  [1146] = {.entry = {.count = 1, .reusable = false}}, SHIFT(313),
  [1148] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [1150] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [1152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [1154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 2, 0, 0),
  [1156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 2, 0, 0),
  [1158] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [1160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(692),
  [1163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59),
  [1165] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(641),
  [1168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(598),
  [1171] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(682),
  [1174] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(646),
  [1177] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(653),
  [1180] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(657),
  [1183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(456),
  [1186] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 59), SHIFT_REPEAT(642),
  [1189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [1191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [1193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [1195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [1197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [1199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [1201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [1203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 4, 0, 10),
  [1207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 4, 0, 10),
  [1209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [1211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(317),
  [1213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [1221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [1223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [1225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [1227] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signature_arguments, 4, 0, 48),
  [1229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signature_arguments, 4, 0, 48),
  [1231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signature_arguments, 6, 0, 94),
  [1233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signature_arguments, 6, 0, 94),
  [1235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signature_arguments, 5, 0, 80),
  [1237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signature_arguments, 5, 0, 80),
  [1239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signature_arguments, 2, 0, 0),
  [1241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signature_arguments, 2, 0, 0),
  [1243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_signature, 2, 0, 25),
  [1245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 2, 0, 25),
  [1247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(450),
  [1249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_signature, 1, 0, 15),
  [1251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 1, 0, 15),
  [1253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(449),
  [1255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signature_arguments, 3, 0, 48),
  [1257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signature_arguments, 3, 0, 48),
  [1259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_signature_arguments, 3, 0, 49),
  [1261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signature_arguments, 3, 0, 49),
  [1263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_signature, 3, 0, 50),
  [1265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 3, 0, 50),
  [1267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_signature, 4, 0, 66),
  [1269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 4, 0, 66),
  [1271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(711),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [1285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(679),
  [1287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(724),
  [1289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(666),
  [1291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(703),
  [1293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(684),
  [1295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [1303] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 1, 0, 30),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_body_repeat1, 1, 0, 30),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_field, 3, 0, 75),
  [1333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_field, 3, 0, 75),
  [1335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_field, 3, 0, 76),
  [1337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_field, 3, 0, 76),
  [1339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_metamethod_annotation, 4, 0, 93),
  [1341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metamethod_annotation, 4, 0, 93),
  [1343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [1345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_field, 5, 0, 99),
  [1347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_field, 5, 0, 99),
  [1349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__record_entry, 1, 0, 31),
  [1351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_entry, 1, 0, 31),
  [1353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__record_entry, 1, 0, 32),
  [1355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_entry, 1, 0, 32),
  [1357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 1, 0, 33),
  [1359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_body_repeat1, 1, 0, 33),
  [1361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__record_entry, 1, 0, 35),
  [1363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_entry, 1, 0, 35),
  [1365] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__record_entry, 1, 0, 36),
  [1367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_entry, 1, 0, 36),
  [1369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__record_entry, 1, 0, 37),
  [1371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__record_entry, 1, 0, 37),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [1375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_variables, 1, 0, 1),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(702),
  [1381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_assignment_variables_repeat1, 2, 0, 23),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [1391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(564),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(577),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1411] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__short_string_content_repeat1, 2, 0, 0), SHIFT_REPEAT(564),
  [1414] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__short_string_content_repeat1, 2, 0, 0), SHIFT_REPEAT(564),
  [1417] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__short_string_content_repeat1, 2, 0, 0), SHIFT_REPEAT(563),
  [1420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__short_string_content_repeat1, 2, 0, 0),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__short_string_content, 1, 0, 12),
  [1426] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 2, 1, 0), SHIFT(454),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1437] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__long_string_content_repeat1, 2, 0, 0), SHIFT_REPEAT(577),
  [1440] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__long_string_content_repeat1, 2, 0, 0), SHIFT_REPEAT(577),
  [1443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__long_string_content_repeat1, 2, 0, 0),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_name, 2, 0, 19),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(707),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(723),
  [1455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0),
  [1457] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(545),
  [1460] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(537),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1465] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_tuple_repeat1, 2, 0, 0), SHIFT_REPEAT(501),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__long_string_content, 1, 0, 12),
  [1474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__short_string_content_repeat1, 1, 0, 0),
  [1480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__short_string_content_repeat1, 1, 0, 0),
  [1482] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_return_type, 1, 1, 0), SHIFT(476),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0),
  [1489] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(258),
  [1492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_name_repeat1, 2, 0, 43),
  [1500] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_name_repeat1, 2, 0, 43), SHIFT_REPEAT(723),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__long_string_content_repeat1, 1, 0, 0),
  [1519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__long_string_content_repeat1, 1, 0, 0),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1531] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_table_constructor_repeat1, 2, 0, 0), SHIFT_REPEAT(229),
  [1534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_table_constructor_repeat1, 2, 0, 0),
  [1536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1538] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_index, 3, 0, 21),
  [1540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parname, 1, 0, 2),
  [1542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [1546] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_name_repeat1, 2, 0, 42),
  [1548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1552] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_generic_for_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(700),
  [1555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_generic_for_statement_repeat1, 2, 0, 0),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(700),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(699),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_variables, 2, 0, 1),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1595] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parname, 4, 0, 79),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1603] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__partypelist_repeat1, 2, 0, 0), SHIFT_REPEAT(457),
  [1606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__partypelist_repeat1, 2, 0, 0),
  [1608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1616] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_assignment_variables_repeat1, 2, 0, 0), SHIFT_REPEAT(535),
  [1619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_assignment_variables_repeat1, 2, 0, 0),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__partype, 1, 0, 68),
  [1625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parname, 2, 0, 47),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parname, 3, 0, 65),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_table_type_repeat1, 2, 0, 81),
  [1643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__partype, 3, 0, 65),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1657] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__parnamelist_repeat1, 2, 0, 0), SHIFT_REPEAT(643),
  [1660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__parnamelist_repeat1, 2, 0, 0),
  [1662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1668] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_table_type_repeat1, 2, 0, 83), SHIFT_REPEAT(511),
  [1671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_table_type_repeat1, 2, 0, 83),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__annotated_var_arg, 3, 0, 64),
  [1683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(690),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [1687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__partypelist_repeat1, 2, 0, 84),
  [1689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_name, 3, 0, 41),
  [1697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__parnamelist_repeat1, 2, 0, 48),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_name, 4, 0, 63),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(717),
  [1737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(698),
  [1753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [1781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [1785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1795] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [1799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(672),
  [1811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_comment = 0,
  ts_external_token__long_string_start = 1,
  ts_external_token__long_string_char = 2,
  ts_external_token__long_string_end = 3,
  ts_external_token__short_string_start = 4,
  ts_external_token__short_string_char = 5,
  ts_external_token__short_string_end = 6,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_comment] = sym_comment,
  [ts_external_token__long_string_start] = sym__long_string_start,
  [ts_external_token__long_string_char] = sym__long_string_char,
  [ts_external_token__long_string_end] = sym__long_string_end,
  [ts_external_token__short_string_start] = sym__short_string_start,
  [ts_external_token__short_string_char] = sym__short_string_char,
  [ts_external_token__short_string_end] = sym__short_string_end,
};

static const bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_comment] = true,
    [ts_external_token__long_string_start] = true,
    [ts_external_token__long_string_char] = true,
    [ts_external_token__long_string_end] = true,
    [ts_external_token__short_string_start] = true,
    [ts_external_token__short_string_char] = true,
    [ts_external_token__short_string_end] = true,
  },
  [2] = {
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token_comment] = true,
    [ts_external_token__long_string_start] = true,
    [ts_external_token__short_string_start] = true,
  },
  [4] = {
    [ts_external_token_comment] = true,
    [ts_external_token__short_string_char] = true,
    [ts_external_token__short_string_end] = true,
  },
  [5] = {
    [ts_external_token_comment] = true,
    [ts_external_token__long_string_char] = true,
    [ts_external_token__long_string_end] = true,
  },
  [6] = {
    [ts_external_token_comment] = true,
    [ts_external_token__long_string_end] = true,
  },
  [7] = {
    [ts_external_token_comment] = true,
    [ts_external_token__short_string_end] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_teal_external_scanner_create(void);
void tree_sitter_teal_external_scanner_destroy(void *);
bool tree_sitter_teal_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_teal_external_scanner_serialize(void *, char *);
void tree_sitter_teal_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_teal(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_teal_external_scanner_create,
      tree_sitter_teal_external_scanner_destroy,
      tree_sitter_teal_external_scanner_scan,
      tree_sitter_teal_external_scanner_serialize,
      tree_sitter_teal_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
