/* gtk-frdp-version.h.in
 *
 * Copyright (C) 2018 Felipe Borges
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GTK_FRDP_VERSION_H
#define GTK_FRDP_VERSION_H

#if !defined(GTK_FRDP_INSIDE) && !defined(GTK_FRDP_COMPILATION)
# error "Only <gtk-frdp.h> can be included directly."
#endif

/**
 * SECTION:gtk-frdpversion
 * @short_description: gtk-frdp version checking
 *
 * gtk-frdp provides macros to check the version of the library
 * at compile-time
 */

/**
 * GTK_FRDP_MAJOR_VERSION:
 *
 * gtk-frdp major version component (e.g. 1 if %GTK_FRDP_VERSION is 1.2.3)
 */
#define GTK_FRDP_MAJOR_VERSION (0)

/**
 * GTK_FRDP_MINOR_VERSION:
 *
 * gtk-frdp minor version component (e.g. 2 if %GTK_FRDP_VERSION is 1.2.3)
 */
#define GTK_FRDP_MINOR_VERSION (2)

/**
 * GTK_FRDP_MICRO_VERSION:
 *
 * gtk-frdp micro version component (e.g. 3 if %GTK_FRDP_VERSION is 1.2.3)
 */
#define GTK_FRDP_MICRO_VERSION (0)

/**
 * GTK_FRDP_VERSION
 *
 * gtk-frdp version.
 */
#define GTK_FRDP_VERSION (0.2.0)

/**
 * GTK_FRDP_VERSION_S:
 *
 * gtk-frdp version, encoded as a string, useful for printing and
 * concatenation.
 */
#define GTK_FRDP_VERSION_S "0.2.0"

#define GTK_FRDP_ENCODE_VERSION(major,minor,micro) \
        ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * GTK_FRDP_VERSION_HEX:
 *
 * gtk-frdp version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 */
#define GTK_FRDP_VERSION_HEX \
        (GTK_FRDP_ENCODE_VERSION (GTK_FRDP_MAJOR_VERSION, GTK_FRDP_MINOR_VERSION, GTK_FRDP_MICRO_VERSION))

/**
 * GTK_FRDP_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to %TRUE if the version
 * of gtk-frdp is greater than the required one.
 */
#define GTK_FRDP_CHECK_VERSION(major,minor,micro)   \
        (GTK_FRDP_MAJOR_VERSION > (major) || \
         (GTK_FRDP_MAJOR_VERSION == (major) && GTK_FRDP_MINOR_VERSION > (minor)) || \
         (GTK_FRDP_MAJOR_VERSION == (major) && GTK_FRDP_MINOR_VERSION == (minor) && \
          GTK_FRDP_MICRO_VERSION >= (micro)))

#endif /* GTK_FRDP_VERSION_H */
