/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartCatalogLoader;
import io.quarkus.devtools.codestarts.CodestartPathLoader;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CodestartResourceLoader
implements CodestartPathLoader {
    private ResourceLoader resourceLoader;

    private CodestartResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public static Map<String, Codestart> loadCodestartsFromResources(List<ResourceLoader> codestartResourceLoaders, String relativePath) throws IOException {
        HashMap<String, Codestart> codestarts = new HashMap<String, Codestart>();
        for (ResourceLoader codestartResourceLoader : codestartResourceLoaders) {
            CodestartPathLoader pathLoader = CodestartResourceLoader.toCodestartPathLoader(codestartResourceLoader);
            Collection loadedCodestarts = CodestartCatalogLoader.loadCodestarts((CodestartPathLoader)pathLoader, (String)relativePath);
            for (Codestart codestart : loadedCodestarts) {
                codestarts.put(codestart.getName(), codestart);
            }
        }
        return codestarts;
    }

    public static CodestartPathLoader toCodestartPathLoader(ResourceLoader resourceLoader) {
        return new CodestartResourceLoader(resourceLoader);
    }

    public <T> T loadResourceAsPath(String name, CodestartPathLoader.PathConsumer<T> consumer) throws IOException {
        return (T)this.resourceLoader.loadResourceAsPath(name, arg_0 -> consumer.consume(arg_0));
    }
}

