/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class FontSizeResolveHandler
implements ResolveHandler {
    private double baseFontSize = this.parseDouble("org.jfree.layouting.defaults.FontSize", 12.0);

    private double parseDouble(String string, double d) {
        LibLayoutBoot libLayoutBoot = LibLayoutBoot.getInstance();
        String string2 = libLayoutBoot.getGlobalConfig().getConfigProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        LayoutElement layoutElement2 = layoutElement.getParent();
        FontSpecification fontSpecification = layoutElement.getLayoutContext().getFontSpecification();
        if (!(cSSValue instanceof CSSNumericValue)) {
            if (layoutElement2 == null) {
                fontSpecification.setFontSize(this.baseFontSize);
                layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, this.baseFontSize));
            } else {
                LayoutContext layoutContext2 = layoutElement2.getLayoutContext();
                FontSpecification fontSpecification2 = layoutContext2.getFontSpecification();
                double d = fontSpecification2.getFontSize();
                fontSpecification.setFontSize(d);
                layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, d));
            }
            return;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (CSSValueResolverUtility.isAbsoluteValue(cSSNumericValue)) {
            CSSNumericValue cSSNumericValue2 = CSSValueResolverUtility.convertLength(cSSNumericValue, layoutElement.getLayoutContext(), layoutProcess.getOutputMetaData());
            double d = cSSNumericValue2.getValue();
            fontSpecification.setFontSize(d);
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, d));
        } else if (CSSNumericType.EM.equals(cSSNumericValue.getType())) {
            double d;
            if (layoutElement2 == null) {
                d = this.baseFontSize;
            } else {
                LayoutContext layoutContext3 = layoutElement2.getLayoutContext();
                FontSpecification fontSpecification3 = layoutContext3.getFontSpecification();
                d = fontSpecification3.getFontSize();
            }
            double d2 = d * cSSNumericValue.getValue();
            fontSpecification.setFontSize(d2);
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, d2));
        } else if (CSSNumericType.EX.equals(cSSNumericValue.getType())) {
            double d;
            if (layoutElement2 == null) {
                d = this.baseFontSize * 0.5 / 0.7;
            } else {
                LayoutContext layoutContext4 = layoutElement2.getLayoutContext();
                FontSpecification fontSpecification4 = layoutContext4.getFontSpecification();
                d = fontSpecification4.getFontSize();
            }
            double d3 = d * cSSNumericValue.getValue();
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, d3));
            fontSpecification.setFontSize(d3);
        } else if (CSSNumericType.PERCENTAGE.equals(cSSNumericValue.getType())) {
            double d;
            if (layoutElement2 == null) {
                d = this.baseFontSize;
            } else {
                LayoutContext layoutContext5 = layoutElement2.getLayoutContext();
                FontSpecification fontSpecification5 = layoutContext5.getFontSpecification();
                d = fontSpecification5.getFontSize();
            }
            double d4 = d * cSSNumericValue.getValue() / 100.0;
            fontSpecification.setFontSize(d4);
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, d4));
        } else {
            fontSpecification.setFontSize(this.baseFontSize);
            layoutContext.setValue(styleKey, CSSNumericValue.createValue(CSSNumericType.PT, this.baseFontSize));
        }
    }
}

