/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;

public class SPFilterPersister
implements SPPersister {
    private final SPPersister targetPersister;
    private final Callable<Boolean> filterOn;
    private final Set<String> filterObjects;
    private final Set<String> seenUUIDS;

    public SPFilterPersister(SPPersister targetPersister, Callable<Boolean> filterOn, Set<String> filterObjects) {
        this.filterObjects = filterObjects;
        this.filterOn = filterOn;
        this.targetPersister = targetPersister;
        this.seenUUIDS = new HashSet<String>();
    }

    @Override
    public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
        this.targetPersister.removeObject(parentUUID, uuid);
    }

    @Override
    public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
        try {
            if (this.filterOn.call() == Boolean.TRUE) {
                if (this.filterObjects.contains(type) || this.seenUUIDS.contains(parentUUID)) {
                    this.seenUUIDS.add(uuid);
                } else {
                    this.targetPersister.persistObject(parentUUID, type, uuid, index);
                }
            } else {
                this.targetPersister.persistObject(parentUUID, type, uuid, index);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue) throws SPPersistenceException {
        try {
            if (this.filterOn.call() == Boolean.TRUE) {
                if (!this.seenUUIDS.contains(uuid)) {
                    this.targetPersister.persistProperty(uuid, propertyName, propertyType, oldValue, newValue);
                }
            } else {
                this.targetPersister.persistProperty(uuid, propertyName, propertyType, oldValue, newValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object newValue) throws SPPersistenceException {
        try {
            if (this.filterOn.call() == Boolean.TRUE) {
                if (!this.seenUUIDS.contains(uuid)) {
                    this.targetPersister.persistProperty(uuid, propertyName, propertyType, newValue);
                }
            } else {
                this.targetPersister.persistProperty(uuid, propertyName, propertyType, newValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void begin() throws SPPersistenceException {
        this.targetPersister.begin();
    }

    @Override
    public void commit() throws SPPersistenceException {
        this.targetPersister.commit();
    }

    @Override
    public void rollback() {
        this.targetPersister.rollback();
    }
}

