/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.CallSite;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.MethodHandle;
import com.googlecode.d2j.Proto;
import com.googlecode.d2j.dex.writer.DexWriteException;
import com.googlecode.d2j.dex.writer.ev.EncodedArray;
import com.googlecode.d2j.dex.writer.ev.EncodedValue;
import com.googlecode.d2j.dex.writer.item.AnnotationItem;
import com.googlecode.d2j.dex.writer.item.AnnotationSetItem;
import com.googlecode.d2j.dex.writer.item.AnnotationSetRefListItem;
import com.googlecode.d2j.dex.writer.item.AnnotationsDirectoryItem;
import com.googlecode.d2j.dex.writer.item.CallSiteIdItem;
import com.googlecode.d2j.dex.writer.item.ClassDataItem;
import com.googlecode.d2j.dex.writer.item.ClassDefItem;
import com.googlecode.d2j.dex.writer.item.CodeItem;
import com.googlecode.d2j.dex.writer.item.DebugInfoItem;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.MethodHandleItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import com.googlecode.d2j.dex.writer.item.ProtoIdItem;
import com.googlecode.d2j.dex.writer.item.StringDataItem;
import com.googlecode.d2j.dex.writer.item.StringIdItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import com.googlecode.d2j.dex.writer.item.TypeListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class ConstPool {
    public int dexVersion = 0x303335;
    public Map<CallSiteIdItem, CallSiteIdItem> callSiteIdItems = new TreeMap<CallSiteIdItem, CallSiteIdItem>();
    public Map<EncodedArray, EncodedArray> encodedArrayItems = new TreeMap<EncodedArray, EncodedArray>();
    public Map<AnnotationSetRefListItem, AnnotationSetRefListItem> annotationSetRefListItems = new HashMap<AnnotationSetRefListItem, AnnotationSetRefListItem>();
    public List<CodeItem> codeItems = new ArrayList<CodeItem>();
    public List<ClassDataItem> classDataItems = new ArrayList<ClassDataItem>();
    public List<DebugInfoItem> debugInfoItems = new ArrayList<DebugInfoItem>();
    public Map<AnnotationItem, AnnotationItem> annotationItems = new HashMap<AnnotationItem, AnnotationItem>();
    public List<AnnotationsDirectoryItem> annotationsDirectoryItems = new ArrayList<AnnotationsDirectoryItem>();
    public Map<AnnotationSetItem, AnnotationSetItem> annotationSetItems = new HashMap<AnnotationSetItem, AnnotationSetItem>();
    public Map<FieldIdItem, FieldIdItem> fields = new TreeMap<FieldIdItem, FieldIdItem>();
    public Map<MethodIdItem, MethodIdItem> methods = new TreeMap<MethodIdItem, MethodIdItem>();
    public Map<ProtoIdItem, ProtoIdItem> protos = new TreeMap<ProtoIdItem, ProtoIdItem>();
    public List<StringDataItem> stringDatas = new ArrayList<StringDataItem>(100);
    public Map<String, StringIdItem> strings = new TreeMap<String, StringIdItem>();
    public Map<TypeListItem, TypeListItem> typeLists = new TreeMap<TypeListItem, TypeListItem>();
    public Map<String, TypeIdItem> types = new TreeMap<String, TypeIdItem>();
    public Map<TypeIdItem, ClassDefItem> classDefs = new HashMap<TypeIdItem, ClassDefItem>();
    public Map<MethodHandleItem, MethodHandleItem> methodHandlers = new TreeMap<MethodHandleItem, MethodHandleItem>();
    private static final TypeListItem ZERO_SIZE_TYPE_LIST = new TypeListItem(Collections.EMPTY_LIST);

    public Object wrapEncodedItem(Object value) {
        if (value instanceof DexType) {
            return this.uniqType(((DexType)value).desc);
        }
        if (value instanceof Field) {
            return this.uniqField((Field)value);
        }
        if (value instanceof String) {
            return this.uniqString((String)value);
        }
        if (value instanceof Method) {
            return this.uniqMethod((Method)value);
        }
        if (value instanceof MethodHandle) {
            return this.uniqMethodHandle((MethodHandle)value);
        }
        if (value instanceof Proto) {
            return this.uniqProto((Proto)value);
        }
        return value;
    }

    private MethodHandleItem uniqMethodHandle(MethodHandle value) {
        MethodHandleItem mh = new MethodHandleItem();
        mh.type = value.getType();
        Field field = value.getField();
        Method method = value.getMethod();
        if (field != null) {
            mh.field = this.uniqField(field);
        } else if (method != null) {
            mh.method = this.uniqMethod(method);
        }
        MethodHandleItem result = this.methodHandlers.get(mh);
        if (result == null) {
            this.methodHandlers.put(mh, mh);
            result = mh;
        }
        return result;
    }

    public void clean() {
        this.encodedArrayItems.clear();
        this.annotationSetRefListItems.clear();
        this.codeItems.clear();
        this.classDataItems.clear();
        this.debugInfoItems.clear();
        this.annotationItems.clear();
        this.annotationsDirectoryItems.clear();
        this.annotationSetItems.clear();
        this.fields.clear();
        this.methods.clear();
        this.protos.clear();
        this.stringDatas.clear();
        this.typeLists.clear();
        this.types.clear();
        this.classDefs.clear();
    }

    private String buildShorty(String ret, String[] types2) {
        StringBuilder sb = new StringBuilder();
        if (ret.length() == 1) {
            sb.append(ret);
        } else {
            sb.append("L");
        }
        for (String s : types2) {
            if (s.length() == 1) {
                sb.append(s);
                continue;
            }
            sb.append("L");
        }
        return sb.toString();
    }

    PE iterateParent(ClassDefItem p) {
        ArrayList<TypeIdItem> list = new ArrayList<TypeIdItem>(6);
        list.add(p.superclazz);
        if (p.interfaces != null) {
            list.addAll(p.interfaces.items);
        }
        return new PE(p, list.iterator());
    }

    public void addDebugInfoItem(DebugInfoItem debugInfoItem) {
        this.debugInfoItems.add(debugInfoItem);
    }

    public void dex039() {
        if (this.dexVersion < 0x303339) {
            this.dexVersion = 0x303339;
        }
    }

    public void dex038() {
        if (this.dexVersion < 0x303338) {
            this.dexVersion = 0x303338;
        }
    }

    public List<ClassDefItem> buildSortedClassDefItems() {
        ArrayList<ClassDefItem> added = new ArrayList<ClassDefItem>();
        Stack<PE> stack1 = new Stack<PE>();
        HashSet<ClassDefItem> children = new HashSet<ClassDefItem>();
        for (ClassDefItem c : this.classDefs.values()) {
            if (added.contains(c)) continue;
            children.add(c);
            stack1.push(this.iterateParent(c));
            while (!stack1.empty()) {
                PE e = (PE)stack1.peek();
                boolean canPop = true;
                while (e.it.hasNext()) {
                    ClassDefItem superDef;
                    TypeIdItem tid = e.it.next();
                    if (tid == null || (superDef = this.classDefs.get(tid)) == null || added.contains(superDef)) continue;
                    if (children.contains(superDef)) {
                        System.err.println("WARN: dep-loop " + e.owner.clazz.descriptor.stringData.string + " -> " + superDef.clazz.descriptor.stringData.string);
                        continue;
                    }
                    canPop = false;
                    children.add(superDef);
                    stack1.push(this.iterateParent(superDef));
                    break;
                }
                if (!canPop) continue;
                stack1.pop();
                added.add(e.owner);
                children.remove(e.owner);
            }
            children.clear();
        }
        return added;
    }

    public AnnotationsDirectoryItem putAnnotationDirectoryItem() {
        AnnotationsDirectoryItem aDirectoryItem = new AnnotationsDirectoryItem();
        this.annotationsDirectoryItems.add(aDirectoryItem);
        return aDirectoryItem;
    }

    public AnnotationItem uniqAnnotationItem(AnnotationItem key) {
        AnnotationItem v = this.annotationItems.get(key);
        if (v == null) {
            this.annotationItems.put(key, key);
            return key;
        }
        return v;
    }

    public ClassDefItem putClassDefItem(int accessFlag, String name, String superClass, String[] itfClass) {
        TypeIdItem type = this.uniqType(name);
        if (this.classDefs.containsKey(type)) {
            throw new DexWriteException("dup clz: " + name);
        }
        ClassDefItem classDefItem = new ClassDefItem();
        classDefItem.accessFlags = accessFlag;
        classDefItem.clazz = type;
        if (superClass != null) {
            classDefItem.superclazz = this.uniqType(superClass);
        }
        if (itfClass != null && itfClass.length > 0) {
            classDefItem.interfaces = this.putTypeList(Arrays.asList(itfClass));
        }
        this.classDefs.put(type, classDefItem);
        return classDefItem;
    }

    public FieldIdItem uniqField(Field field) {
        return this.uniqField(field.getOwner(), field.getName(), field.getType());
    }

    public FieldIdItem uniqField(String owner, String name, String type) {
        FieldIdItem key = new FieldIdItem(this.uniqType(owner), this.uniqString(name), this.uniqType(type));
        FieldIdItem item = this.fields.get(key);
        if (item != null) {
            return item;
        }
        this.fields.put(key, key);
        return key;
    }

    public MethodIdItem uniqMethod(Method method) {
        MethodIdItem key = new MethodIdItem(this.uniqType(method.getOwner()), this.uniqString(method.getName()), this.uniqProto(method));
        return this.uniqMethod(key);
    }

    public MethodIdItem uniqMethod(String owner, String name, String[] parms, String ret) {
        MethodIdItem key = new MethodIdItem(this.uniqType(owner), this.uniqString(name), this.uniqProto(parms, ret));
        return this.uniqMethod(key);
    }

    public MethodIdItem uniqMethod(MethodIdItem key) {
        MethodIdItem item = this.methods.get(key);
        if (item != null) {
            return item;
        }
        this.methods.put(key, key);
        return key;
    }

    public ProtoIdItem uniqProto(Proto method) {
        return this.uniqProto(method.getParameterTypes(), method.getReturnType());
    }

    private ProtoIdItem uniqProto(Method method) {
        return this.uniqProto(method.getProto());
    }

    public ProtoIdItem uniqProto(String[] types, String retDesc) {
        TypeIdItem ret = this.uniqType(retDesc);
        StringIdItem shorty = this.uniqString(this.buildShorty(retDesc, types));
        TypeListItem params = this.putTypeList(types);
        ProtoIdItem key = new ProtoIdItem(params, ret, shorty);
        ProtoIdItem item = this.protos.get(key);
        if (item != null) {
            return item;
        }
        this.protos.put(key, key);
        return key;
    }

    public StringIdItem uniqString(String data) {
        StringIdItem item = this.strings.get(data);
        if (item != null) {
            return item;
        }
        StringDataItem sd = new StringDataItem(data);
        this.stringDatas.add(sd);
        item = new StringIdItem(sd);
        this.strings.put(data, item);
        return item;
    }

    public TypeIdItem uniqType(String type) {
        TypeIdItem item = this.types.get(type);
        if (item != null) {
            return item;
        }
        item = new TypeIdItem(this.uniqString(type));
        this.types.put(type, item);
        return item;
    }

    private TypeListItem putTypeList(String ... subList) {
        if (subList.length == 0) {
            return ZERO_SIZE_TYPE_LIST;
        }
        ArrayList<TypeIdItem> idItems = new ArrayList<TypeIdItem>(subList.length);
        for (String s : subList) {
            idItems.add(this.uniqType(s));
        }
        TypeListItem key = new TypeListItem(idItems);
        TypeListItem item = this.typeLists.get(key);
        if (item != null) {
            return item;
        }
        this.typeLists.put(key, key);
        return key;
    }

    private TypeListItem putTypeList(List<String> subList) {
        if (subList.size() == 0) {
            return ZERO_SIZE_TYPE_LIST;
        }
        ArrayList<TypeIdItem> idItems = new ArrayList<TypeIdItem>(subList.size());
        for (String s : subList) {
            idItems.add(this.uniqType(s));
        }
        TypeListItem key = new TypeListItem(idItems);
        TypeListItem item = this.typeLists.get(key);
        if (item != null) {
            return item;
        }
        this.typeLists.put(key, key);
        return key;
    }

    public ClassDataItem addClassDataItem(ClassDataItem dataItem) {
        this.classDataItems.add(dataItem);
        return dataItem;
    }

    public CallSiteIdItem uniqCallSite(CallSite callSite) {
        EncodedArray e = new EncodedArray();
        e.values.add(new EncodedValue(22, this.uniqMethodHandle(callSite.getBootstrapMethodHandler())));
        e.values.add(new EncodedValue(23, this.uniqString(callSite.getMethodName())));
        e.values.add(new EncodedValue(21, this.uniqProto(callSite.getMethodProto())));
        for (Object arg : callSite.getExtraArguments()) {
            e.values.add(EncodedValue.wrap(this.wrapEncodedItem(arg)));
        }
        CallSiteIdItem k = new CallSiteIdItem(callSite.getName(), this.uniqEncodedArrayItem(e));
        CallSiteIdItem v = this.callSiteIdItems.get(k);
        if (v == null) {
            v = k;
            this.callSiteIdItems.put(v, v);
        }
        return v;
    }

    public EncodedArray uniqEncodedArrayItem(EncodedArray k) {
        EncodedArray v = this.encodedArrayItems.get(k);
        if (v == null) {
            v = k;
            this.encodedArrayItems.put(v, v);
        }
        return v;
    }

    public AnnotationSetItem uniqAnnotationSetItem(AnnotationSetItem key) {
        ArrayList<AnnotationItem> copy = new ArrayList<AnnotationItem>(key.annotations);
        key.annotations.clear();
        for (AnnotationItem annotationItem : copy) {
            key.annotations.add(this.uniqAnnotationItem(annotationItem));
        }
        AnnotationSetItem v = this.annotationSetItems.get(key);
        if (v != null) {
            return v;
        }
        this.annotationSetItems.put(key, key);
        return key;
    }

    public AnnotationSetRefListItem uniqAnnotationSetRefListItem(AnnotationSetRefListItem key) {
        for (int i = 0; i < key.annotationSets.length; ++i) {
            AnnotationSetItem anno = key.annotationSets[i];
            if (anno == null) continue;
            key.annotationSets[i] = this.uniqAnnotationSetItem(anno);
        }
        AnnotationSetRefListItem v = this.annotationSetRefListItems.get(key);
        if (v == null) {
            this.annotationSetRefListItems.put(key, key);
            return key;
        }
        return v;
    }

    public void addCodeItem(CodeItem code) {
        this.codeItems.add(code);
    }

    static {
        ConstPool.ZERO_SIZE_TYPE_LIST.offset = 0;
    }

    static class PE {
        final ClassDefItem owner;
        final Iterator<TypeIdItem> it;

        PE(ClassDefItem owner, Iterator<TypeIdItem> it) {
            this.owner = owner;
            this.it = it;
        }
    }
}

