/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.discovery;

import org.jupnp.model.Location;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.header.HostHeader;
import org.jupnp.model.message.header.LocationHeader;
import org.jupnp.model.message.header.MaxAgeHeader;
import org.jupnp.model.message.header.NTSHeader;
import org.jupnp.model.message.header.ServerHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.types.NotificationSubtype;

public abstract class OutgoingNotificationRequest
extends OutgoingDatagramMessage<UpnpRequest> {
    private NotificationSubtype type;

    protected OutgoingNotificationRequest(Location location, LocalDevice device, NotificationSubtype type) {
        super(new UpnpRequest(UpnpRequest.Method.NOTIFY), ModelUtil.getInetAddressByName("239.255.255.250"), 1900);
        this.type = type;
        this.getHeaders().add(UpnpHeader.Type.MAX_AGE, new MaxAgeHeader(((DeviceIdentity)device.getIdentity()).getMaxAgeSeconds()));
        this.getHeaders().add(UpnpHeader.Type.LOCATION, new LocationHeader(location.getURL()));
        this.getHeaders().add(UpnpHeader.Type.SERVER, new ServerHeader());
        this.getHeaders().add(UpnpHeader.Type.HOST, new HostHeader());
        this.getHeaders().add(UpnpHeader.Type.NTS, new NTSHeader(type));
    }

    public NotificationSubtype getType() {
        return this.type;
    }
}

